# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .bridge_local_config import BridgeLocalConfig
from .bridge_local_stats import BridgeLocalStats

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class BridgeStatus(pydantic.BaseModel):
    current_time: dt.datetime = pydantic.Field()
    """
    Local time on the Bridge when the status check was performed.
    """

    response_duration: str = pydantic.Field()
    """
    Round trip time for the status check.
    """

    local_config: BridgeLocalConfig = pydantic.Field()
    """
    Local configuration parameters for the Bridge.
    """

    local_stats: BridgeLocalStats = pydantic.Field()
    """
    Local bridge statistics
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
