# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...capabilities_base.types.category_id import CategoryId
from ...capabilities_base.types.provider_id import ProviderId
from .provider_operations import ProviderOperations
from .provider_release import ProviderRelease

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ProviderCapabilities(pydantic.BaseModel):
    id: ProviderId = pydantic.Field()
    """
    Unique identifier for the Provider.
    """

    name: str = pydantic.Field()
    """
    Name of the Provider.
    """

    fullname: str = pydantic.Field()
    """
    Display name of the Provider.
    """

    description: str = pydantic.Field()
    """
    Description of the Provider.
    """

    connector_id: CategoryId = pydantic.Field()
    """
    Id of the Connector that the Provider implements.
    """

    connector: typing.Optional[ConnectorOrId] = pydantic.Field(default=None)
    """
    Id of the Connector that the Provider implements – or, if
    `expand=connector` is set – the details of the Connector. NOTE:
    The current default behavior is to return the ID of the
    Connector. This field will soon only be populated when
    `expand=connector` is set in the APIs that support it. It is
    recommended you use `connector_id` for a stable reference to the
    Connector ID. This field will soon only be populated when
    `expand=connector` is set in the APIs that support it.
    """

    operations: typing.Optional[typing.List[ProviderOperations]] = pydantic.Field(default=None)
    """
    Operations that the Provider implements.
    """

    provider_config: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Details on the specific configuration options for the Provider.
    """

    release: typing.Optional[ProviderRelease] = pydantic.Field(default=None)
    """
    Provider availability inforamtion.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}


from .connector_or_id import ConnectorOrId  # noqa: E402

ProviderCapabilities.update_forward_refs()
