# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...common.types.base import Base
from ...role_base.types.role_name import RoleName
from .member_id import MemberId
from .state import State

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Member(Base):
    id: MemberId
    state: State
    last_logon: dt.datetime = pydantic.Field()
    """
    Last logon time
    """

    fullname: str = pydantic.Field()
    """
    User's full display name.
    """

    nickname: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's nickname
    """

    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    Url of user's picture
    """

    ttl: str
    token_ttl: str
    expires: dt.datetime
    pin_expires: dt.datetime
    role_binding: typing.List[RoleName] = pydantic.Field()
    """
    Roles granted to this member. Tokens inherit this access.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
