# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .hcl_app_scan_on_cloud_credential import HclAppScanOnCloudCredential
from .hcl_app_scan_on_cloud_url import HclAppScanOnCloudUrl

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AppsecHclAppScanOnCloud(pydantic.BaseModel):
    """
    Configuration for HCL AppScan on Cloud as an application security provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/hcl-appscan-appsec-setup)
    """

    credential: HclAppScanOnCloudCredential = pydantic.Field()
    """
    Credentials used for accessing the HCL AppScan on Cloud API.
    """

    url: HclAppScanOnCloudUrl = pydantic.Field()
    """
    Base URL for the HCL AppScan on Cloud API. This URL should be the same as the URL used to access the HCL AppScan on Cloud web interface.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
