# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ProviderConfigId(str, enum.Enum):
    """
    List of supported providers.
    """

    APPSEC_HCL_APP_SCAN_ON_CLOUD = "appsec_hcl_appscan_on_cloud"
    """
    HCL AppScan on Cloud
    """

    APPSEC_OPEN_TEXT_CORE_APPLICATION_SECURITY = "appsec_opentext_core_application_security"
    """
    OpenText Core Application Security
    """

    ASSETS_ARMIS_CENTRIX = "assets_armis_centrix"
    """
    Armis Centrix™ for Asset Management and Security
    """

    ASSETS_ARMIS_CENTRIX_MOCK = "assets_armis_centrix_mock"
    """
    [MOCK] Armis Centrix™ for Asset Management and Security
    """

    ASSETS_AXONIUS = "assets_axonius"
    """
    Axonius Asset Cloud
    """

    ASSETS_AXONIUS_MOCK = "assets_axonius_mock"
    """
    [MOCK] Axonius Asset Cloud
    """

    ASSETS_CROWD_STRIKE = "assets_crowdstrike"
    """
    CrowdStrike Falcon Spotlight
    """

    ASSETS_CROWD_STRIKE_MOCK = "assets_crowdstrike_mock"
    """
    [MOCK] CrowdStrike Falcon Spotlight
    """

    ASSETS_NOZOMI_VANTAGE = "assets_nozomi_vantage"
    """
    Nozomi Vantage
    """

    ASSETS_NOZOMI_VANTAGE_MOCK = "assets_nozomi_vantage_mock"
    """
    [MOCK] Nozomi Vantage
    """

    ASSETS_QUALYS_CLOUD = "assets_qualys_cloud"
    """
    Qualys Vulnerability Management, Detection & Response (VMDR)
    """

    ASSETS_QUALYS_CLOUD_MOCK = "assets_qualys_cloud_mock"
    """
    [MOCK] Qualys Vulnerability Management, Detection & Response (VMDR)
    """

    ASSETS_SERVICE_NOW = "assets_servicenow"
    """
    ServiceNow Configuration Management Database (CMDB)
    """

    ASSETS_SERVICE_NOW_MOCK = "assets_servicenow_mock"
    """
    [MOCK] ServiceNow Configuration Management Database (CMDB)
    """

    ASSETS_SEVCO = "assets_sevco"
    """
    Sevco for Asset Management and Security
    """

    ASSETS_TANIUM_CLOUD = "assets_tanium_cloud"
    """
    Tanium Vulnerability Management
    """

    ASSETS_TANIUM_CLOUD_MOCK = "assets_tanium_cloud_mock"
    """
    [MOCK] Tanium Vulnerability Management
    """

    CLOUD_SECURITY_CROWD_STRIKE = "cloudsecurity_crowdstrike"
    """
    CrowdStrike Falcon® Insight EDR
    """

    CLOUD_SECURITY_DEFENDER = "cloudsecurity_defender"
    """
    Microsoft Defender for Cloud
    """

    EDR_CROWD_STRIKE = "edr_crowdstrike"
    """
    CrowdStrike Falcon® Insight EDR
    """

    EDR_DEFENDER = "edr_defender"
    """
    Microsoft Defender for Endpoint
    """

    EDR_MALWAREBYTES = "edr_malwarebytes"
    """
    ThreatDown Endpoint Detection & Response
    """

    EDR_SENTINEL_ONE = "edr_sentinelone"
    """
    SentinelOne Singularity™ Endpoint
    """

    EDR_SOPHOS = "edr_sophos"
    """
    Sophos Endpoint
    """

    EDR_TANIUM = "edr_tanium"
    """
    Tanium EDR
    """

    IDENTITY_ENTRA_ID = "identity_entra_id"
    """
    Microsoft Entra ID
    """

    IDENTITY_GOOGLE = "identity_google"
    """
    Google Workspace
    """

    IDENTITY_OKTA = "identity_okta"
    """
    Okta Identity
    """

    IDENTITY_PING_ONE = "identity_pingone"
    """
    PingOne Cloud Platform
    """

    NOTIFICATIONS_JIRA = "notifications_jira"
    """
    Atlassian Jira
    """

    NOTIFICATIONS_MOCK = "notifications_mock_notifications"
    """
    Synqly Test Provider
    """

    NOTIFICATIONS_SLACK_WEBHOOK = "notifications_slack_webhook"
    """
    Slack Incoming Webhook
    """

    NOTIFICATIONS_SLACK = "notifications_slack"
    """
    Slack
    """

    NOTIFICATIONS_TEAMS = "notifications_teams"
    """
    Microsoft Teams
    """

    SIEM_CROWDSTRIKE = "siem_crowdstrike"
    """
    CrowdStrike Falcon® Next-Gen SIEM
    """

    SIEM_ELASTICSEARCH = "siem_elasticsearch"
    """
    Elastic SIEM
    """

    SIEM_GOOGLE_CHRONICLE = "siem_google_chronicle"
    """
    Google Security Operations (Chronicle Compatibility)
    """

    SIEM_GOOGLE_SECURITY_OPERATIONS = "siem_google_security_operations"
    """
    Google Security Operations
    """

    SIEM_MOCK = "siem_mock_siem"
    """
    Synqly Test Provider
    """

    SIEM_OPEN_SEARCH = "siem_opensearch"
    """
    OpenSearch SIEM
    """

    SIEM_Q_RADAR = "siem_q_radar"
    """
    IBM QRadar SIEM
    """

    SIEM_RAPID_7_INSIGHT_IDR = "siem_rapid7_insightidr"
    """
    Rapid7 InsightIDR
    """

    SIEM_SENTINEL = "siem_sentinel"
    """
    Microsoft Sentinel
    """

    SIEM_SPLUNK = "siem_splunk"
    """
    Splunk Enterprise Security
    """

    SIEM_SUMO_LOGIC = "siem_sumo_logic"
    """
    Sumo Logic Cloud SIEM
    """

    SINK_AWS_S_3 = "sink_aws_s3"
    """
    Amazon S3
    """

    SINK_AWS_SECURITY_LAKE = "sink_aws_security_lake"
    """
    Amazon Security Lake
    """

    SINK_AWS_SQS = "sink_aws_sqs"
    """
    Amazon Simple Queue Service (SQS)
    """

    SINK_AZURE_MONITOR_LOGS = "sink_azure_monitor_logs"
    """
    Microsoft Azure Monitor Logs
    """

    SINK_CROWDSTRIKE_HEC = "sink_crowdstrike_hec"
    """
    CrowdStrike Falcon® Next-Gen SIEM (HEC)
    """

    SINK_ELASTICSEARCH = "sink_elasticsearch"
    """
    Elasticsearch
    """

    SINK_GOOGLE_SEC_OPS = "sink_google_sec_ops"
    """
    Google Security Operations (Chronicle Compatibility)
    """

    SINK_GOOGLE_SECURITY_OPERATIONS = "sink_google_security_operations"
    """
    Google Security Operations
    """

    SINK_MOCK = "sink_mock_sink"
    """
    Synqly Test Provider
    """

    SINK_OPEN_SEARCH = "sink_opensearch"
    """
    OpenSearch
    """

    SINK_SPLUNK = "sink_splunk"
    """
    Splunk Enterprise Security
    """

    STORAGE_AWS_S_3 = "storage_aws_s3"
    """
    Amazon S3
    """

    STORAGE_AZURE_BLOB = "storage_azure_blob"
    """
    Microsoft Azure Blob Storage
    """

    STORAGE_GCS = "storage_gcs"
    """
    Google Cloud Storage
    """

    STORAGE_MOCK = "storage_mock_storage"
    """
    Synqly Test Provider
    """

    TICKETING_AUTOTASK = "ticketing_autotask"
    """
    Autotask Operations Cloud
    """

    TICKETING_FRESHDESK = "ticketing_freshdesk"
    """
    Freshdesk
    """

    TICKETING_JIRA = "ticketing_jira"
    """
    Atlassian Jira
    """

    TICKETING_JIRA_SERVICE_MANAGEMENT = "ticketing_jira_service_management"
    """
    Jira Service Management
    """

    TICKETING_MOCK = "ticketing_mock_ticketing"
    """
    Synqly Test Provider
    """

    TICKETING_PAGER_DUTY = "ticketing_pagerduty"
    """
    PagerDuty Operations Cloud
    """

    TICKETING_SERVICE_NOW = "ticketing_servicenow"
    """
    ServiceNow IT Service Management (ITSM)
    """

    TICKETING_SERVICE_NOW_SIR = "ticketing_servicenow_sir"
    """
    ServiceNow Security Incident Response (SIR)
    """

    TICKETING_TORQ = "ticketing_torq"
    """
    Torq
    """

    TICKETING_ZENDESK = "ticketing_zendesk"
    """
    Zendesk
    """

    VULNERABILITIES_CROWD_STRIKE = "vulnerabilities_crowdstrike"
    """
    CrowdStrike Falcon® Spotlight
    """

    VULNERABILITIES_NUCLEUS = "vulnerabilities_nucleus"
    """
    Nucleus Vulnerability Management
    """

    VULNERABILITIES_QUALYS_CLOUD = "vulnerabilities_qualys_cloud"
    """
    Qualys Vulnerability Management, Detection & Response (VMDR)
    """

    VULNERABILITIES_QUALYS_CLOUD_MOCK = "vulnerabilities_qualys_cloud_mock"
    """
    [MOCK] Qualys Vulnerability Management, Detection & Response (VMDR)
    """

    VULNERABILITIES_RAPID_7_INSIGHT_CLOUD = "vulnerabilities_rapid7_insight_cloud"
    """
    Rapid7 InsightVM
    """

    VULNERABILITIES_RAPID_7_INSIGHT_CLOUD_MOCK = "vulnerabilities_rapid7_insight_cloud_mock"
    """
    [MOCK] Rapid7 Insight Vulnerability Management Cloud
    """

    VULNERABILITIES_SERVICE_NOW = "vulnerabilities_servicenow_vr"
    """
    ServiceNow Vulnerability Response
    """

    VULNERABILITIES_TANIUM_CLOUD = "vulnerabilities_tanium_cloud"
    """
    Tanium Vulnerability Management
    """

    VULNERABILITIES_TANIUM_CLOUD_MOCK = "vulnerabilities_tanium_cloud_mock"
    """
    [MOCK] Tsanium Vulnerability Management
    """

    VULNERABILITIES_TENABLE_CLOUD = "vulnerabilities_tenable_cloud"
    """
    Tenable Vulnerability Management
    """

    ALL = "*"
    """
    Any provider config type.
    """

    def visit(
        self,
        appsec_hcl_app_scan_on_cloud: typing.Callable[[], T_Result],
        appsec_open_text_core_application_security: typing.Callable[[], T_Result],
        assets_armis_centrix: typing.Callable[[], T_Result],
        assets_armis_centrix_mock: typing.Callable[[], T_Result],
        assets_axonius: typing.Callable[[], T_Result],
        assets_axonius_mock: typing.Callable[[], T_Result],
        assets_crowd_strike: typing.Callable[[], T_Result],
        assets_crowd_strike_mock: typing.Callable[[], T_Result],
        assets_nozomi_vantage: typing.Callable[[], T_Result],
        assets_nozomi_vantage_mock: typing.Callable[[], T_Result],
        assets_qualys_cloud: typing.Callable[[], T_Result],
        assets_qualys_cloud_mock: typing.Callable[[], T_Result],
        assets_service_now: typing.Callable[[], T_Result],
        assets_service_now_mock: typing.Callable[[], T_Result],
        assets_sevco: typing.Callable[[], T_Result],
        assets_tanium_cloud: typing.Callable[[], T_Result],
        assets_tanium_cloud_mock: typing.Callable[[], T_Result],
        cloud_security_crowd_strike: typing.Callable[[], T_Result],
        cloud_security_defender: typing.Callable[[], T_Result],
        edr_crowd_strike: typing.Callable[[], T_Result],
        edr_defender: typing.Callable[[], T_Result],
        edr_malwarebytes: typing.Callable[[], T_Result],
        edr_sentinel_one: typing.Callable[[], T_Result],
        edr_sophos: typing.Callable[[], T_Result],
        edr_tanium: typing.Callable[[], T_Result],
        identity_entra_id: typing.Callable[[], T_Result],
        identity_google: typing.Callable[[], T_Result],
        identity_okta: typing.Callable[[], T_Result],
        identity_ping_one: typing.Callable[[], T_Result],
        notifications_jira: typing.Callable[[], T_Result],
        notifications_mock: typing.Callable[[], T_Result],
        notifications_slack_webhook: typing.Callable[[], T_Result],
        notifications_slack: typing.Callable[[], T_Result],
        notifications_teams: typing.Callable[[], T_Result],
        siem_crowdstrike: typing.Callable[[], T_Result],
        siem_elasticsearch: typing.Callable[[], T_Result],
        siem_google_chronicle: typing.Callable[[], T_Result],
        siem_google_security_operations: typing.Callable[[], T_Result],
        siem_mock: typing.Callable[[], T_Result],
        siem_open_search: typing.Callable[[], T_Result],
        siem_q_radar: typing.Callable[[], T_Result],
        siem_rapid_7_insight_idr: typing.Callable[[], T_Result],
        siem_sentinel: typing.Callable[[], T_Result],
        siem_splunk: typing.Callable[[], T_Result],
        siem_sumo_logic: typing.Callable[[], T_Result],
        sink_aws_s_3: typing.Callable[[], T_Result],
        sink_aws_security_lake: typing.Callable[[], T_Result],
        sink_aws_sqs: typing.Callable[[], T_Result],
        sink_azure_monitor_logs: typing.Callable[[], T_Result],
        sink_crowdstrike_hec: typing.Callable[[], T_Result],
        sink_elasticsearch: typing.Callable[[], T_Result],
        sink_google_sec_ops: typing.Callable[[], T_Result],
        sink_google_security_operations: typing.Callable[[], T_Result],
        sink_mock: typing.Callable[[], T_Result],
        sink_open_search: typing.Callable[[], T_Result],
        sink_splunk: typing.Callable[[], T_Result],
        storage_aws_s_3: typing.Callable[[], T_Result],
        storage_azure_blob: typing.Callable[[], T_Result],
        storage_gcs: typing.Callable[[], T_Result],
        storage_mock: typing.Callable[[], T_Result],
        ticketing_autotask: typing.Callable[[], T_Result],
        ticketing_freshdesk: typing.Callable[[], T_Result],
        ticketing_jira: typing.Callable[[], T_Result],
        ticketing_jira_service_management: typing.Callable[[], T_Result],
        ticketing_mock: typing.Callable[[], T_Result],
        ticketing_pager_duty: typing.Callable[[], T_Result],
        ticketing_service_now: typing.Callable[[], T_Result],
        ticketing_service_now_sir: typing.Callable[[], T_Result],
        ticketing_torq: typing.Callable[[], T_Result],
        ticketing_zendesk: typing.Callable[[], T_Result],
        vulnerabilities_crowd_strike: typing.Callable[[], T_Result],
        vulnerabilities_nucleus: typing.Callable[[], T_Result],
        vulnerabilities_qualys_cloud: typing.Callable[[], T_Result],
        vulnerabilities_qualys_cloud_mock: typing.Callable[[], T_Result],
        vulnerabilities_rapid_7_insight_cloud: typing.Callable[[], T_Result],
        vulnerabilities_rapid_7_insight_cloud_mock: typing.Callable[[], T_Result],
        vulnerabilities_service_now: typing.Callable[[], T_Result],
        vulnerabilities_tanium_cloud: typing.Callable[[], T_Result],
        vulnerabilities_tanium_cloud_mock: typing.Callable[[], T_Result],
        vulnerabilities_tenable_cloud: typing.Callable[[], T_Result],
        all_: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ProviderConfigId.APPSEC_HCL_APP_SCAN_ON_CLOUD:
            return appsec_hcl_app_scan_on_cloud()
        if self is ProviderConfigId.APPSEC_OPEN_TEXT_CORE_APPLICATION_SECURITY:
            return appsec_open_text_core_application_security()
        if self is ProviderConfigId.ASSETS_ARMIS_CENTRIX:
            return assets_armis_centrix()
        if self is ProviderConfigId.ASSETS_ARMIS_CENTRIX_MOCK:
            return assets_armis_centrix_mock()
        if self is ProviderConfigId.ASSETS_AXONIUS:
            return assets_axonius()
        if self is ProviderConfigId.ASSETS_AXONIUS_MOCK:
            return assets_axonius_mock()
        if self is ProviderConfigId.ASSETS_CROWD_STRIKE:
            return assets_crowd_strike()
        if self is ProviderConfigId.ASSETS_CROWD_STRIKE_MOCK:
            return assets_crowd_strike_mock()
        if self is ProviderConfigId.ASSETS_NOZOMI_VANTAGE:
            return assets_nozomi_vantage()
        if self is ProviderConfigId.ASSETS_NOZOMI_VANTAGE_MOCK:
            return assets_nozomi_vantage_mock()
        if self is ProviderConfigId.ASSETS_QUALYS_CLOUD:
            return assets_qualys_cloud()
        if self is ProviderConfigId.ASSETS_QUALYS_CLOUD_MOCK:
            return assets_qualys_cloud_mock()
        if self is ProviderConfigId.ASSETS_SERVICE_NOW:
            return assets_service_now()
        if self is ProviderConfigId.ASSETS_SERVICE_NOW_MOCK:
            return assets_service_now_mock()
        if self is ProviderConfigId.ASSETS_SEVCO:
            return assets_sevco()
        if self is ProviderConfigId.ASSETS_TANIUM_CLOUD:
            return assets_tanium_cloud()
        if self is ProviderConfigId.ASSETS_TANIUM_CLOUD_MOCK:
            return assets_tanium_cloud_mock()
        if self is ProviderConfigId.CLOUD_SECURITY_CROWD_STRIKE:
            return cloud_security_crowd_strike()
        if self is ProviderConfigId.CLOUD_SECURITY_DEFENDER:
            return cloud_security_defender()
        if self is ProviderConfigId.EDR_CROWD_STRIKE:
            return edr_crowd_strike()
        if self is ProviderConfigId.EDR_DEFENDER:
            return edr_defender()
        if self is ProviderConfigId.EDR_MALWAREBYTES:
            return edr_malwarebytes()
        if self is ProviderConfigId.EDR_SENTINEL_ONE:
            return edr_sentinel_one()
        if self is ProviderConfigId.EDR_SOPHOS:
            return edr_sophos()
        if self is ProviderConfigId.EDR_TANIUM:
            return edr_tanium()
        if self is ProviderConfigId.IDENTITY_ENTRA_ID:
            return identity_entra_id()
        if self is ProviderConfigId.IDENTITY_GOOGLE:
            return identity_google()
        if self is ProviderConfigId.IDENTITY_OKTA:
            return identity_okta()
        if self is ProviderConfigId.IDENTITY_PING_ONE:
            return identity_ping_one()
        if self is ProviderConfigId.NOTIFICATIONS_JIRA:
            return notifications_jira()
        if self is ProviderConfigId.NOTIFICATIONS_MOCK:
            return notifications_mock()
        if self is ProviderConfigId.NOTIFICATIONS_SLACK_WEBHOOK:
            return notifications_slack_webhook()
        if self is ProviderConfigId.NOTIFICATIONS_SLACK:
            return notifications_slack()
        if self is ProviderConfigId.NOTIFICATIONS_TEAMS:
            return notifications_teams()
        if self is ProviderConfigId.SIEM_CROWDSTRIKE:
            return siem_crowdstrike()
        if self is ProviderConfigId.SIEM_ELASTICSEARCH:
            return siem_elasticsearch()
        if self is ProviderConfigId.SIEM_GOOGLE_CHRONICLE:
            return siem_google_chronicle()
        if self is ProviderConfigId.SIEM_GOOGLE_SECURITY_OPERATIONS:
            return siem_google_security_operations()
        if self is ProviderConfigId.SIEM_MOCK:
            return siem_mock()
        if self is ProviderConfigId.SIEM_OPEN_SEARCH:
            return siem_open_search()
        if self is ProviderConfigId.SIEM_Q_RADAR:
            return siem_q_radar()
        if self is ProviderConfigId.SIEM_RAPID_7_INSIGHT_IDR:
            return siem_rapid_7_insight_idr()
        if self is ProviderConfigId.SIEM_SENTINEL:
            return siem_sentinel()
        if self is ProviderConfigId.SIEM_SPLUNK:
            return siem_splunk()
        if self is ProviderConfigId.SIEM_SUMO_LOGIC:
            return siem_sumo_logic()
        if self is ProviderConfigId.SINK_AWS_S_3:
            return sink_aws_s_3()
        if self is ProviderConfigId.SINK_AWS_SECURITY_LAKE:
            return sink_aws_security_lake()
        if self is ProviderConfigId.SINK_AWS_SQS:
            return sink_aws_sqs()
        if self is ProviderConfigId.SINK_AZURE_MONITOR_LOGS:
            return sink_azure_monitor_logs()
        if self is ProviderConfigId.SINK_CROWDSTRIKE_HEC:
            return sink_crowdstrike_hec()
        if self is ProviderConfigId.SINK_ELASTICSEARCH:
            return sink_elasticsearch()
        if self is ProviderConfigId.SINK_GOOGLE_SEC_OPS:
            return sink_google_sec_ops()
        if self is ProviderConfigId.SINK_GOOGLE_SECURITY_OPERATIONS:
            return sink_google_security_operations()
        if self is ProviderConfigId.SINK_MOCK:
            return sink_mock()
        if self is ProviderConfigId.SINK_OPEN_SEARCH:
            return sink_open_search()
        if self is ProviderConfigId.SINK_SPLUNK:
            return sink_splunk()
        if self is ProviderConfigId.STORAGE_AWS_S_3:
            return storage_aws_s_3()
        if self is ProviderConfigId.STORAGE_AZURE_BLOB:
            return storage_azure_blob()
        if self is ProviderConfigId.STORAGE_GCS:
            return storage_gcs()
        if self is ProviderConfigId.STORAGE_MOCK:
            return storage_mock()
        if self is ProviderConfigId.TICKETING_AUTOTASK:
            return ticketing_autotask()
        if self is ProviderConfigId.TICKETING_FRESHDESK:
            return ticketing_freshdesk()
        if self is ProviderConfigId.TICKETING_JIRA:
            return ticketing_jira()
        if self is ProviderConfigId.TICKETING_JIRA_SERVICE_MANAGEMENT:
            return ticketing_jira_service_management()
        if self is ProviderConfigId.TICKETING_MOCK:
            return ticketing_mock()
        if self is ProviderConfigId.TICKETING_PAGER_DUTY:
            return ticketing_pager_duty()
        if self is ProviderConfigId.TICKETING_SERVICE_NOW:
            return ticketing_service_now()
        if self is ProviderConfigId.TICKETING_SERVICE_NOW_SIR:
            return ticketing_service_now_sir()
        if self is ProviderConfigId.TICKETING_TORQ:
            return ticketing_torq()
        if self is ProviderConfigId.TICKETING_ZENDESK:
            return ticketing_zendesk()
        if self is ProviderConfigId.VULNERABILITIES_CROWD_STRIKE:
            return vulnerabilities_crowd_strike()
        if self is ProviderConfigId.VULNERABILITIES_NUCLEUS:
            return vulnerabilities_nucleus()
        if self is ProviderConfigId.VULNERABILITIES_QUALYS_CLOUD:
            return vulnerabilities_qualys_cloud()
        if self is ProviderConfigId.VULNERABILITIES_QUALYS_CLOUD_MOCK:
            return vulnerabilities_qualys_cloud_mock()
        if self is ProviderConfigId.VULNERABILITIES_RAPID_7_INSIGHT_CLOUD:
            return vulnerabilities_rapid_7_insight_cloud()
        if self is ProviderConfigId.VULNERABILITIES_RAPID_7_INSIGHT_CLOUD_MOCK:
            return vulnerabilities_rapid_7_insight_cloud_mock()
        if self is ProviderConfigId.VULNERABILITIES_SERVICE_NOW:
            return vulnerabilities_service_now()
        if self is ProviderConfigId.VULNERABILITIES_TANIUM_CLOUD:
            return vulnerabilities_tanium_cloud()
        if self is ProviderConfigId.VULNERABILITIES_TANIUM_CLOUD_MOCK:
            return vulnerabilities_tanium_cloud_mock()
        if self is ProviderConfigId.VULNERABILITIES_TENABLE_CLOUD:
            return vulnerabilities_tenable_cloud()
        if self is ProviderConfigId.ALL:
            return all_()
