# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .crowd_strike_credential import CrowdStrikeCredential
from .crowdstrike_hec_credential import CrowdstrikeHecCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SiemCrowdstrike(pydantic.BaseModel):
    """
    Configuration for CrowdStrike Falcon® Next-Gen SIEM.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/crowdstrike-siem-setup)
    """

    credential: CrowdStrikeCredential = pydantic.Field()
    """
    The credential to use for the CrowdStrike Falcon NextGen SIEM tenant.
    """

    hec_credential: typing.Optional[CrowdstrikeHecCredential] = pydantic.Field(default=None)
    """
    Token credential to use for connecting to the CrowdStrike HEC service. If not provided, sending events to CrowdStrike is disabled.
    """

    hec_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The generated CrowdStrike HEC URL provided with your token.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the CrowdStrike Falcon® Next-Gen SIEM API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
