# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .google_chronicle_credential import GoogleChronicleCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SiemGoogleChronicle(pydantic.BaseModel):
    """
    Configuration for Google Security Operations (formerly Google Chronicle) as a SIEM Provider connecting via the older Backstory and Malachite APIs.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-chronicle-setup)
    """

    customer_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The customer ID reported when writing events. This field is required if writing events.
    """

    ingestion_credential: typing.Optional[GoogleChronicleCredential] = pydantic.Field(default=None)
    """
    Credentials used for writing events. If not specified then writing events is disabled.
    """

    ingestion_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Google SecOps Ingestion API.
    """

    search_credential: GoogleChronicleCredential = pydantic.Field()
    """
    Credentials used for querying and reading events.
    """

    search_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Google SecOps Search API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
