# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .aws_sqs_credential import AwsSqsCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SinkAwsSqs(pydantic.BaseModel):
    """
    Configuration for Amazon Simple Queue Service (SQS).

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/aws-sqs-sink-setup)
    """

    credential: AwsSqsCredential = pydantic.Field()
    """
    AWS Access Keys with write access to the configured SQS queue.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    Overrides the default AWS region. If not present, the region will be inferred from the URL.
    """

    url: str = pydantic.Field()
    """
    URL of the SQS queue where events are sent.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
