# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .azure_monitor_logs_credential import AzureMonitorLogsCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SinkAzureMonitorLogs(pydantic.BaseModel):
    """
    Configuration for Azure Monitor Logs as a Sink Provider. Azure Monitor Logs is a feature of Azure Monitor that collects and organizes log and performance data from monitored resources.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/azure-monitor-logs)
    """

    client_id: str = pydantic.Field()
    """
    Azure Client (Application) ID.
    """

    credential: AzureMonitorLogsCredential = pydantic.Field()
    """
    Credential with access to the configured data collection endpoint.
    """

    rule_id: str = pydantic.Field()
    """
    Data collection rule immutable ID.
    """

    stream_name: str = pydantic.Field()
    """
    Name of the data collection rule stream.
    """

    tenant_id: str = pydantic.Field()
    """
    Azure Directory (tenant) ID.
    """

    url: str = pydantic.Field()
    """
    URL of the Azure data collection endpoint.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
