# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.76.0-v202511211241-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class MarkdownLinksApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_file(self, **kwargs):
        """
        Delete a file by its ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file(file_id_with_extension=file_id_with_extension_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_id_with_extension: The file ID with extension (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_file_with_http_info(**kwargs)
        else:
            (data) = self.delete_file_with_http_info(**kwargs)
            return data

    def delete_file_with_http_info(self, **kwargs):
        """
        Delete a file by its ID
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_with_http_info(file_id_with_extension=file_id_with_extension_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_id_with_extension: The file ID with extension (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['file_id_with_extension']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id_with_extension' is set
        if ('file_id_with_extension' not in params) or (params['file_id_with_extension'] is None):
            raise ValueError("Missing the required parameter `file_id_with_extension` when calling `delete_file`")


        collection_formats = {}

        path_params = {}
        if 'file_id_with_extension' in params:
            path_params['fileIdWithExtension'] = params['file_id_with_extension']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/markdown/links/{fileIdWithExtension}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_markdown_link_file(self, **kwargs):
        """
        Get a markdown link file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_markdown_link_file(file_id_with_extension=file_id_with_extension_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_id_with_extension: The file ID with extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_markdown_link_file_with_http_info(**kwargs)
        else:
            (data) = self.get_markdown_link_file_with_http_info(**kwargs)
            return data

    def get_markdown_link_file_with_http_info(self, **kwargs):
        """
        Get a markdown link file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_markdown_link_file_with_http_info(file_id_with_extension=file_id_with_extension_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_id_with_extension: The file ID with extension (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """

        all_params = ['file_id_with_extension']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_markdown_link_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_id_with_extension' is set
        if ('file_id_with_extension' not in params) or (params['file_id_with_extension'] is None):
            raise ValueError("Missing the required parameter `file_id_with_extension` when calling `get_markdown_link_file`")


        collection_formats = {}

        path_params = {}
        if 'file_id_with_extension' in params:
            path_params['fileIdWithExtension'] = params['file_id_with_extension']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream', 'application/pdf', 'application/vnd.seeq.v1+json', 'image/*', 'text/*'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/markdown/links/{fileIdWithExtension}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'str'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def upload_file(self, **kwargs):
        """
        Upload a file for markdown links
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file:
        :return: MarkdownLinkUploadOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MarkdownLinkUploadOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upload_file_with_http_info(**kwargs)
        else:
            (data) = self.upload_file_with_http_info(**kwargs)
            return data

    def upload_file_with_http_info(self, **kwargs):
        """
        Upload a file for markdown links
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file:
        :return: MarkdownLinkUploadOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MarkdownLinkUploadOutputV1
        """

        all_params = ['file']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/markdown/links', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'MarkdownLinkUploadOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
