# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.76.0-v202511211241-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class UserGroupsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_identity_to_user_group(self, **kwargs):
        """
        Add a user to a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_identity_to_user_group(user_group_id=user_group_id_value, identity_id=identity_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to add user or user group to (required)
        :param str identity_id: ID of the user or user group to add. (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_identity_to_user_group_with_http_info(**kwargs)
        else:
            (data) = self.add_identity_to_user_group_with_http_info(**kwargs)
            return data

    def add_identity_to_user_group_with_http_info(self, **kwargs):
        """
        Add a user to a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_identity_to_user_group_with_http_info(user_group_id=user_group_id_value, identity_id=identity_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to add user or user group to (required)
        :param str identity_id: ID of the user or user group to add. (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['user_group_id', 'identity_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_identity_to_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `add_identity_to_user_group`")
        # verify the required parameter 'identity_id' is set
        if ('identity_id' not in params) or (params['identity_id'] is None):
            raise ValueError("Missing the required parameter `identity_id` when calling `add_identity_to_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']
        if 'identity_id' in params:
            path_params['identityId'] = params['identity_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}/{identityId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_user_group(self, **kwargs):
        """
        Archive a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_user_group(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of user group to archive (required)
        :param bool remove_permissions: Whether to remove permissions associated with the group being archived
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_user_group_with_http_info(**kwargs)
        else:
            (data) = self.archive_user_group_with_http_info(**kwargs)
            return data

    def archive_user_group_with_http_info(self, **kwargs):
        """
        Archive a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_user_group_with_http_info(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of user group to archive (required)
        :param bool remove_permissions: Whether to remove permissions associated with the group being archived
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['user_group_id', 'remove_permissions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `archive_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']

        query_params = []
        if 'remove_permissions' in params:
            query_params.append(('removePermissions', params['remove_permissions']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}/archive', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_user_group(self, **kwargs):
        """
        Create a user group hosted within Seeq
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_user_group(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserGroupInputV1 body: User group information (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_user_group_with_http_info(**kwargs)
        else:
            (data) = self.create_user_group_with_http_info(**kwargs)
            return data

    def create_user_group_with_http_info(self, **kwargs):
        """
        Create a user group hosted within Seeq
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_user_group_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserGroupInputV1 body: User group information (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_user_group`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_user_group(self, **kwargs):
        """
        Disable a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_user_group(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of user group to disable (required)
        :param bool remove_permissions: Whether to remove permissions associated with the group being disabled
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_user_group_with_http_info(**kwargs)
        else:
            (data) = self.disable_user_group_with_http_info(**kwargs)
            return data

    def disable_user_group_with_http_info(self, **kwargs):
        """
        Disable a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_user_group_with_http_info(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of user group to disable (required)
        :param bool remove_permissions: Whether to remove permissions associated with the group being disabled
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['user_group_id', 'remove_permissions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `disable_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']

        query_params = []
        if 'remove_permissions' in params:
            query_params.append(('removePermissions', params['remove_permissions']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}/disable', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_capability_user_groups(self, **kwargs):
        """
        Get the collection of usergroups used to manage capabilities
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_capability_user_groups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name_search: Search text by which to filter capability groups' names.
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination level, the total number of collection items that will be returned in this page of results
        :return: IdentityPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentityPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_capability_user_groups_with_http_info(**kwargs)
        else:
            (data) = self.get_capability_user_groups_with_http_info(**kwargs)
            return data

    def get_capability_user_groups_with_http_info(self, **kwargs):
        """
        Get the collection of usergroups used to manage capabilities
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_capability_user_groups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name_search: Search text by which to filter capability groups' names.
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination level, the total number of collection items that will be returned in this page of results
        :return: IdentityPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentityPreviewListV1
        """

        all_params = ['name_search', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_capability_user_groups" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name_search' in params:
            query_params.append(('nameSearch', params['name_search']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/capabilities', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'IdentityPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_user_group(self, **kwargs):
        """
        Get a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_group(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to get (required)
        :param bool include_members: Whether to include members in the output
        :param bool include_capabilities: Whether to include the granted capabilities in the output
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_group_with_http_info(**kwargs)
        else:
            (data) = self.get_user_group_with_http_info(**kwargs)
            return data

    def get_user_group_with_http_info(self, **kwargs):
        """
        Get a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_group_with_http_info(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to get (required)
        :param bool include_members: Whether to include members in the output
        :param bool include_capabilities: Whether to include the granted capabilities in the output
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['user_group_id', 'include_members', 'include_capabilities']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `get_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']

        query_params = []
        if 'include_members' in params:
            query_params.append(('includeMembers', params['include_members']))
        if 'include_capabilities' in params:
            query_params.append(('includeCapabilities', params['include_capabilities']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_user_groups(self, **kwargs):
        """
        Get a collection of usergroups
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_groups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name_search: Search text by which to filter user groups' names.
        :param str datasource_id_search: Search text by which to filter user groups' directories.
        :param bool is_enabled: Return only user groups that have the specified value for Enabled.
        :param str sort_order: Sort order for the results. Field must be 'name' followed by a space and either 'asc' or 'desc', for ascending or descending order
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination level, the total number of collection items that will be returned in this page of results
        :return: IdentityPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentityPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_user_groups_with_http_info(**kwargs)
        else:
            (data) = self.get_user_groups_with_http_info(**kwargs)
            return data

    def get_user_groups_with_http_info(self, **kwargs):
        """
        Get a collection of usergroups
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_groups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name_search: Search text by which to filter user groups' names.
        :param str datasource_id_search: Search text by which to filter user groups' directories.
        :param bool is_enabled: Return only user groups that have the specified value for Enabled.
        :param str sort_order: Sort order for the results. Field must be 'name' followed by a space and either 'asc' or 'desc', for ascending or descending order
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination level, the total number of collection items that will be returned in this page of results
        :return: IdentityPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentityPreviewListV1
        """

        all_params = ['name_search', 'datasource_id_search', 'is_enabled', 'sort_order', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_groups" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name_search' in params:
            query_params.append(('nameSearch', params['name_search']))
        if 'datasource_id_search' in params:
            query_params.append(('datasourceIdSearch', params['datasource_id_search']))
        if 'is_enabled' in params:
            query_params.append(('isEnabled', params['is_enabled']))
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'IdentityPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_user_groups(self, **kwargs):
        """
        Create or update multiple user groups
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_groups(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PutUserGroupsInputV1 body: (required)
        :return: ItemBatchOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemBatchOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_user_groups_with_http_info(**kwargs)
        else:
            (data) = self.put_user_groups_with_http_info(**kwargs)
            return data

    def put_user_groups_with_http_info(self, **kwargs):
        """
        Create or update multiple user groups
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_groups_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PutUserGroupsInputV1 body: (required)
        :return: ItemBatchOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemBatchOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_user_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_user_groups`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/batch', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemBatchOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_identity_from_user_group(self, **kwargs):
        """
        Remove a user from a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_identity_from_user_group(user_group_id=user_group_id_value, identity_id=identity_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to remove user from (required)
        :param str identity_id: ID of the user or user group to remove. (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_identity_from_user_group_with_http_info(**kwargs)
        else:
            (data) = self.remove_identity_from_user_group_with_http_info(**kwargs)
            return data

    def remove_identity_from_user_group_with_http_info(self, **kwargs):
        """
        Remove a user from a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_identity_from_user_group_with_http_info(user_group_id=user_group_id_value, identity_id=identity_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to remove user from (required)
        :param str identity_id: ID of the user or user group to remove. (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['user_group_id', 'identity_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_identity_from_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `remove_identity_from_user_group`")
        # verify the required parameter 'identity_id' is set
        if ('identity_id' not in params) or (params['identity_id'] is None):
            raise ValueError("Missing the required parameter `identity_id` when calling `remove_identity_from_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']
        if 'identity_id' in params:
            path_params['identityId'] = params['identity_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}/{identityId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_user_group(self, **kwargs):
        """
        Remove a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_user_group(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to remove (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_user_group_with_http_info(**kwargs)
        else:
            (data) = self.remove_user_group_with_http_info(**kwargs)
            return data

    def remove_user_group_with_http_info(self, **kwargs):
        """
        Remove a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_user_group_with_http_info(user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_group_id: ID of the user group to remove (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['user_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `remove_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_user_group(self, **kwargs):
        """
        Update name or description of a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_group(body=body_value, user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserGroupInputV1 body: New user group information (required)
        :param str user_group_id: ID of the user group to update (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_user_group_with_http_info(**kwargs)
        else:
            (data) = self.update_user_group_with_http_info(**kwargs)
            return data

    def update_user_group_with_http_info(self, **kwargs):
        """
        Update name or description of a user group
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_user_group_with_http_info(body=body_value, user_group_id=user_group_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserGroupInputV1 body: New user group information (required)
        :param str user_group_id: ID of the user group to update (required)
        :return: UserGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserGroupOutputV1
        """

        all_params = ['body', 'user_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_user_group`")
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params) or (params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `update_user_group`")


        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/usergroups/{userGroupId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'UserGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
