from helpers.objects.helpers import object_find
from common.tag.tag_obj import GITTag
from common.objects import GITObject
from helpers.refs.helpers import ref_create
from common.objects import GITObject


def tag_create(repo, name, ref, create_tag_object=False):
    sha = object_find(repo, ref)
    obj = GITObject.object_read(repo, sha)

    if create_tag_object:
        tag = GITTag()
        tag.kvlm = dict()
        tag.kvlm[b"object"] = sha.encode()
        tag.kvlm[b"type"] = obj.obj_type 
        tag.kvlm[b"tag"] = name.encode()
        tag.kvlm[b"tagger"] = b"Someone <someone@example.com>"
        tag.kvlm[None] = (
            b"This tag is generated by the zyra\n"
        )
        tag_sha = GITObject.object_write(tag, repo)
        ref_create(repo, "tags/" + name, tag_sha)
    else:
        ref_create(repo, "tags/" + name, sha)
