import os
from common.repo import GITRepository
import configparser
from termcolor import cprint

def repo_create(path):
    repo = GITRepository(path, True)

    if os.path.exists(repo.worktree):
        if not os.path.isdir(repo.worktree):
            cprint("The path that you provided is not a directory brother", "red")
            return None
        if os.path.exists(repo.gitdir):
            cprint("zyra repository is already initialized (.git folder is present)", "red")
            cprint("execute (rm -rf .git) to delete the folder", "yellow")
            return None
    else :
        os.makedirs(repo.worktree)
    
    repo_dir(repo, "branches", mkdir=True)
    repo_dir(repo, "objects", mkdir=True)
    repo_dir(repo, "refs", "tags", mkdir=True)
    repo_dir(repo, "refs", "heads", mkdir=True)


    # repo_file(repo, "refs", "heads")

    with open(repo_file(repo, "description"), "w") as f:
        f.write("Unnamed repository yo; edit this file to name the repo")
    
    with open(repo_file(repo, "config"), "w") as f:
        ret = configparser.ConfigParser()
        ret.add_section("core")
        ret.set("core", "repositoryformatversion", "0")
        ret.set("core", "filemode", "false")
        ret.set("core", "bare", "false")
        ret.write(f)

    with open(repo_file(repo, "HEAD"), 'w') as f:
        f.write("ref: refs/heads/master\n")

    return repo


def repo_path(repo, *path):
    return os.path.join(repo.gitdir, *path)

def repo_file(repo, *path, mkdir=False):
    if repo_dir(repo, *path[:-1], mkdir=mkdir):
        return repo_path(repo, *path)

def repo_dir(repo, *path, mkdir=False):
    path = repo_path(repo, *path)

    if os.path.exists(path):
        if (os.path.isdir(path)):
            return path
        else:
            raise Exception(f"Not a directory {path}")

    if mkdir:
        os.makedirs(path)
        return path
    else:
        return None

def repo_find(path=".", required=True):
    path = os.path.realpath(path)
    if os.path.isdir(os.path.join(path, ".git")):
        return GITRepository(path)
    
    parent = os.path.realpath(os.path.join(path, ".."))
    if parent == path:
        if required:
            cprint("First initalise the zyra directory using 'zyra init' command", "purple")
        else:
            return None
    
    return repo_find(parent, required)

def repo_store_branch(branch_name):
    repo = repo_find()
    path = repo_file(repo, "branches")
    branch_path = os.path.join(path, branch_name)

    with open(branch_path, "wb") as f:
        pass