"""Enums for reolink features"""

from enum import Enum


class SubType(str, Enum):
    """Subscription type"""

    push = "push"
    long_poll = "long_poll"
    all = "all"

    def __repr__(self) -> str:
        return self.value

    def __str__(self) -> str:
        return self.value


class VodRequestType(Enum):
    """VOD url request types"""

    RTMP = "RTMP"
    PLAYBACK = "Playback"
    FLV = "FLV"
    DOWNLOAD = "Download"
    NVR_DOWNLOAD = "NvrDownload"


class EncodingEnum(Enum):
    """Options for encoding of the streams"""

    h264 = "h264"
    h265 = "h265"


class ExposureEnum(Enum):
    """Options for exposure mode"""

    auto = "Auto"
    lownoise = "LowNoise"
    antismearing = "Anti-Smearing"
    manual = "Manual"


class SpotlightModeEnum(Enum):
    """Options for the spotlight mode"""

    off = 0
    auto = 1
    onatnight = 2
    schedule = 3
    adaptive = 5
    autoadaptive = 4


class SpotlightEventModeEnum(Enum):
    """Options for the spotlight event mode"""

    off = "off"
    on = "keepOn"
    flash = "flicker"


class StatusLedEnum(Enum):
    """Options for the status led mode"""

    stayoff = "KeepOff"
    auto = "Off"
    alwaysonatnight = "On"
    always = "Always"
    alwayson = "KeepOn"


class DayNightEnum(Enum):
    """Options for the DayNight setting"""

    auto = "Auto"
    color = "Color"
    blackwhite = "Black&White"


class HDREnum(Enum):
    """Options for the HDR setting"""

    off = 0
    on = 2
    auto = 1


class BinningModeEnum(Enum):
    """Options for the Binning mode setting"""

    off = 0
    on = 2
    auto = 1


class PtzEnum(Enum):
    """Options for PTZ control"""

    stop = "Stop"
    left = "Left"
    right = "Right"
    up = "Up"
    down = "Down"
    zoomin = "ZoomInc"
    zoomout = "ZoomDec"


class GuardEnum(Enum):
    """Options for PTZ Guard"""

    set = "setPos"
    goto = "toPos"


class TrackMethodEnum(Enum):
    """Options for AI Track Method"""

    # off = 0
    # pantilt = 1
    digital = 2
    digitalfirst = 3
    pantiltfirst = 4


class BatteryEnum(Enum):
    """Battery status"""

    discharging = 0
    charging = 1
    chargecomplete = 2


class ChimeToneEnum(Enum):
    """Chime ringtone"""

    off = -1
    citybird = 0
    originaltune = 1
    pianokey = 2
    loop = 3
    attraction = 4
    hophop = 5
    goodday = 6
    operetta = 7
    moonlight = 8
    waybackhome = 9


class HubToneEnum(Enum):
    """Hub ringtone"""

    alarm = -1
    citybird = 0
    originaltune = 1
    pianokey = 2
    loop = 3
    attraction = 4
    hophop = 5
    goodday = 6
    operetta = 7
    moonlight = 8
    waybackhome = 9


class HardwiredChimeTypeEnum(Enum):
    """Hardwired chime type for battery-powered doorbell"""

    none = "none"
    mechanical = "machine"
    digital1 = "negativeWave"
    digital2 = "positiveWave"
