#!/usr/bin/env python
#   -*- coding: utf-8 -*-

from setuptools import setup
from setuptools.command.install import install as _install

class install(_install):
    def pre_install_script(self):
        pass

    def post_install_script(self):
        pass

    def run(self):
        self.pre_install_script()

        _install.run(self)

        self.post_install_script()

if __name__ == '__main__':
    setup(
        name = 'wheel_axle',
        version = '0.0.11.dev20250731042338',
        description = 'Axle is Python wheel enhancement library',
        long_description = "# Wheel Axle - Python Wheel enhancement library\n\n[![Gitter](https://img.shields.io/gitter/room/karellen/Lobby?logo=gitter)](https://app.gitter.im/#/room/#karellen_Lobby:gitter.im)\n[![Build Status](https://img.shields.io/github/actions/workflow/status/karellen/wheel-axle/build.yml?branch=master)](https://github.com/karellen/wheel-axle/actions/workflows/build.yml)\n[![Coverage Status](https://img.shields.io/coveralls/github/karellen/wheel-axle/master?logo=coveralls)](https://coveralls.io/r/karellen/wheel-axle?branch=master)\n\n[![Wheel Axle Version](https://img.shields.io/pypi/v/wheel-axle?logo=pypi)](https://pypi.org/project/wheel-axle/)\n[![Wheel Axle Python Versions](https://img.shields.io/pypi/pyversions/wheel-axle?logo=pypi)](https://pypi.org/project/wheel-axle/)\n\n[![Wheel Axle Downloads Per Day](https://img.shields.io/pypi/dd/wheel-axle?logo=pypi)](https://pypistats.org/packages/wheel-axle)\n[![Wheel Axle Downloads Per Week](https://img.shields.io/pypi/dw/wheel-axle?logo=pypi)](https://pypistats.org/packages/wheel-axle)\n[![Wheel Axle Downloads Per Month](https://img.shields.io/pypi/dm/wheel-axle?logo=pypi)](https://pypistats.org/packages/wheel-axle)\n\n## Problem\n\n1. Python wheel does not support symlinks.\n2. Python wheel does not support overwriting in a convenient way:\n    * whether the distribution is pure-Python\n    * distribution ABI tag\n    * extend Python tag override capability\n\n## Solution\n\n**WARNING: THIS IS EXPERIMENTAL BETA SOFTWARE. THERE ARE NO WARRANTIES OF ANY KIND. USE AT YOUR OWN RISK.\nADDITIONAL INCLUDED DISCLAIMERS ALSO APPLY.**\n\nWheel-Axle (`axle`, `bdist_axle`) is a drop-in replacement/augmentation utility for `wheel` (`bdist_wheel`)\nthat extends and builds spec-compliant wheels.\n\nDuring the build, `axle` is able to capture and record in the Python wheel the symlinks in the following\nschema paths (locations):\n\n* purelib\n* platlib\n* scripts\n* headers\n* data\n\nAdditionally, `Axle` is able to customize the Python wheel tags via additional command line options.\n\nWhile the generated Python wheel is fully spec-compliant, additional symlink functionality is not possible without its\ncompanion library [Wheel Axle Runtime](https://github.com/karellen/wheel-axle-runtime). Thus, every Python wheel\ngenerated by the `bdist_axle` automatically becomes dependent on `wheel-axle-runtime` that provides\npost-install logic required.\n\n## Implementation\n\nThe body of the library is as ugly and messy as `distutils`/`setuptools` are, and consists of, mainly, in\nhacking/overwriting various `setuptools` commands to detect, handle and record symlinks and their targets. Once that\nproblem is solved, the list of symlinks is recorded in the `.dist-info/symlinks.txt`\nin the following CSV format:\n\n1. symlink name\n2. symlink target\n3. a boolean (0 or 1) flag indicating whether the target is a directory\n\n**NOTE: Symlinks may be relative, absolute and/or broken. Symlink targets are recorded verbatim (even when broken) and\nare NOT otherwise interpreted. THIS IS INTENTIONAL. Please\nsee [Wheel Axle Runtime Security Notice](https://github.com/karellen/wheel-axle-runtime#security)\nfor additional information.**\n\nA special `<distribution name and version>.pth` file is also added to the distribution. When the wheel is installed\nthis `.pth` file triggers the post-install logic via\n[wheel-axle-runtime](https://github.com/karellen/wheel-axle-runtime).\n\n## Usage\n\n`python setup.py bdist_wheel <arguments>` can be replaced with `python setup.py bdist_axle <arguments>`. The replacement\nis drop-in.\n\nAdditional functionality is available via the following options:\n\n```commandline\n  --python-tag        Python implementation compatibility tag (default: 'py3')\n  --root-is-pure      set to manually override whether the wheel is\n                      pure (default: None)\n  --abi-tag           set to override ABI tag (default: None)\n  --require-libpython set to indicate the package requires libpython in the\n                       exec_prefix/platlib\n```\n\nUsing `--python-tag`, `--root-is-pure` and `--abi-tag` allows you to create wheels that carry platform-dependent data\nwhile otherwise containing pure-Python libraries.\n",
        long_description_content_type = 'text/markdown',
        classifiers = [
            'License :: OSI Approved :: Apache Software License',
            'Programming Language :: Python :: 3.7',
            'Programming Language :: Python :: 3.8',
            'Programming Language :: Python :: 3.9',
            'Programming Language :: Python :: 3.10',
            'Programming Language :: Python :: 3.11',
            'Programming Language :: Python :: 3.12',
            'Programming Language :: Python :: 3.13',
            'Operating System :: MacOS :: MacOS X',
            'Operating System :: POSIX',
            'Operating System :: POSIX :: Linux',
            'Topic :: System :: Archiving :: Packaging',
            'Topic :: Software Development :: Build Tools',
            'Intended Audience :: Developers',
            'Development Status :: 4 - Beta'
        ],
        keywords = 'wheel packaging setuptools bdist_wheel symlink postinstall',

        author = 'Karellen, Inc.',
        author_email = 'supervisor@karellen.co',
        maintainer = 'Arcadiy Ivanov',
        maintainer_email = 'arcadiy@karellen.co',

        license = 'Apache License, Version 2.0',

        url = 'https://github.com/karellen/wheel-axle',
        project_urls = {
            'Bug Tracker': 'https://github.com/karellen/wheel-axle/issues',
            'Documentation': 'https://github.com/karellen/wheel-axle/',
            'Source Code': 'https://github.com/karellen/wheel-axle/'
        },

        scripts = [],
        packages = ['wheel_axle.bdist_axle'],
        namespace_packages = [],
        py_modules = [],
        entry_points = {
            'distutils.commands': ['bdist_axle = wheel_axle.bdist_axle:BdistAxle']
        },
        data_files = [],
        package_data = {
            'wheel_axle/bdist_axle': ['LICENSE']
        },
        install_requires = [
            'wheel>=0.37.0',
            'wheel-axle-runtime<1.0,>0.0.5'
        ],
        dependency_links = [],
        zip_safe = True,
        cmdclass = {'install': install},
        python_requires = '>=3.9',
        obsoletes = [],
    )
