# generated by datamodel-codegen:
#   filename:  openapi_norm.yaml
#   timestamp: 2025-10-28T09:25:24+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal

from pydantic import (
    AwareDatetime,
    BaseModel,
    Field,
    RootModel,
    confloat,
    conint,
    constr,
)


class AbstractAnalyseSettingsDto(BaseModel):
    type: str = Field(..., description="Response differs based on analyse type")
    includeConfirmedSegments: bool | None = Field(False, description="Default: false")
    includeNotConfirmedSegments: bool | None = Field(
        False, description="Default: false"
    )
    includeNumbers: bool | None = Field(False, description="Default: false")
    includeLockedSegments: bool | None = Field(False, description="Default: false")
    countSourceUnits: bool | None = Field(False, description="Default: false")
    includeTransMemory: bool | None = Field(False, description="Default: false")
    namingPattern: str | None = None
    analyzeByLanguage: bool | None = Field(False, description="Default: false")
    analyzeByProvider: bool | None = Field(False, description="Default: false")
    allowAutomaticPostAnalysis: bool | None = Field(
        False,
        description="If automatic post analysis should be created after update source. Default: false",
    )


class AbstractUserCreateDto(BaseModel):
    userName: constr(min_length=0, max_length=255)
    firstName: constr(min_length=0, max_length=255)
    lastName: constr(min_length=0, max_length=255)
    email: constr(min_length=0, max_length=255)
    password: constr(min_length=0, max_length=255) | None = Field(
        None, description="Will be ignored if sendInvitation parameter is set to true"
    )
    role: str = Field(
        ...,
        description='Enum: "ADMIN", "PROJECT_MANAGER", "LINGUIST", "GUEST", "SUBMITTER", "PORTAL_MEMBER"',
    )
    timezone: constr(min_length=0, max_length=255)
    receiveNewsletter: bool | None = Field(True, description="Default: true")
    note: constr(min_length=0, max_length=4096) | None = None
    active: bool | None = Field(True, description="Default: true")


class AbstractUserEditDto(BaseModel):
    userName: constr(min_length=0, max_length=255)
    firstName: constr(min_length=0, max_length=255)
    lastName: constr(min_length=0, max_length=255)
    email: constr(min_length=0, max_length=255)
    role: str = Field(
        ...,
        description='Enum: "ADMIN", "PROJECT_MANAGER", "LINGUIST", "GUEST", "SUBMITTER", "PORTAL_MEMBER"',
    )
    timezone: constr(min_length=0, max_length=255)
    receiveNewsletter: bool | None = Field(True, description="Default: true")
    note: constr(min_length=0, max_length=4096) | None = None
    active: bool | None = Field(True, description="Default: true")


class AddCommentDto(BaseModel):
    text: str


class AddTargetLangDto(BaseModel):
    targetLangs: List[str] | None = Field(None, max_length=2147483647, min_length=1)


class AdditionalWorkflowStepDto(BaseModel):
    id: str | None = None
    name: str | None = None


class AdditionalWorkflowStepRequestDto(BaseModel):
    name: constr(min_length=0, max_length=255) = Field(
        ..., description="Name of the additional workflow step"
    )


class AdditionalWorkflowStepV2Dto(BaseModel):
    id: str | None = None
    name: str | None = None


class AnalyseJobReference(BaseModel):
    uid: str | None = None
    filename: str | None = None
    innerId: str | None = None


class AnalyseLanguagePartReference(BaseModel):
    id: str | None = None
    sourceLang: str | None = None
    targetLang: str | None = None
    jobs: List[AnalyseJobReference] | None = Field(
        None,
        description='Max of 100 jobs returned, use "List jobs of analyses" to get all',
    )


class AndroidSettingsDto(BaseModel):
    tagRegexp: str | None = None
    icuSubFilter: bool | None = Field(None, description="Default: `false`")


class AppleTokenResponseDto(BaseModel):
    access_token: str | None = None
    token_type: str | None = None
    expires_in: str | None = None
    refresh_token: str | None = None
    id_token: str | None = None


class AsciidocSettingsDto(BaseModel):
    tagRegexp: str | None = None
    htmlInPassthrough: bool | None = Field(None, description="Default: `false`")
    nontranslatableMonospaceCustomStylesRegexp: str | None = None
    extractCustomDocumentAttributeNameRegexp: str | None = Field(
        None, description="Default: `.*`"
    )
    extractBtnMenuLabels: bool | None = Field(None, description="Default: `false`")


class Type1(str, Enum):
    JOB = "JOB"


class AsyncRequestReferenceDto(BaseModel):
    uid: str | None = Field(None, description="UID of the object")
    type: Type1 | None = Field(None, description="Type of the object")


class AuthSchema(BaseModel):
    type: str | None = None
    name: str | None = None
    description: str | None = None
    specUrl: str | None = None
    primary: bool | None = None


class BackgroundTaskReference(BaseModel):
    errorCode: str | None = None
    errorMessage: str | None = None
    dataText: str | None = None
    status: str | None = None


class BrowseRequestDto(BaseModel):
    queryLang: str | None = None
    query: str | None = None
    status: str | None = None
    pageNumber: int | None = None
    pageSize: conint(ge=1, le=50) | None = None


class BusinessUnitEditDto(BaseModel):
    name: constr(min_length=0, max_length=255)


class BusinessUnitReference(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class BusinessUnitReference2(BaseModel):
    uid: str | None = None
    name: str | None = None


class BusinessUnitReference3(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class BuyerReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None


class CleanupTask(BaseModel):
    pass


class ClientReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None


class ClientReference3(BaseModel):
    uid: str | None = None
    name: str | None = None
    note: str | None = None


class ClientReference4(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None


class CloneProjectDto(BaseModel):
    name: str


class ConcurrentRequestsDto(BaseModel):
    limit: int | None = Field(
        None,
        description="Max number of allowed concurrent request, null value means no limit",
    )
    count: int | None = Field(
        None, description="Current count of running concurrent requests"
    )


class ConnectorErrorDetailDto(BaseModel):
    code: str | None = None
    message: str | None = None
    messageCode: str | None = None
    args: Dict[str, Dict[str, Any]] | None = None
    skipPrefix: bool | None = None


class ConnectorErrorsDto(BaseModel):
    errors: List[ConnectorErrorDetailDto] | None = None


class ContinuousJobInfoDto(BaseModel):
    dateUpdated: AwareDatetime | None = None


class CostCenterEditDto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None


class CostCenterReference(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class CostCenterReference2(BaseModel):
    uid: str | None = None
    name: str | None = None


class CountsDto(BaseModel):
    segments: float | None = None
    words: float | None = None
    characters: float | None = None
    normalizedPages: float | None = None
    percent: float | None = None
    editingTime: float | None = None


class CountsDto2(BaseModel):
    segments: float | None = None
    words: float | None = None
    characters: float | None = None
    normalizedPages: float | None = None
    percent: float | None = None
    editingTime: float | None = None


class CountsDto3(BaseModel):
    segments: float | None = None
    words: float | None = None
    characters: float | None = None
    normalizedPages: float | None = None
    percent: float | None = None
    editingTime: float | None = None


class CreateProjectTemplateReferenceFileNoteDto(BaseModel):
    note: str


class CreateReferenceFileNoteDto(BaseModel):
    note: str


class CreateWorkflowStepDto(BaseModel):
    name: constr(min_length=1, max_length=255) = Field(
        ..., description="Name of the lqa workflow step"
    )
    order: int | None = Field(None, description="Order value")
    lqaEnabled: bool | None = Field(False, description="Default: false")
    abbr: constr(min_length=1, max_length=3) = Field(..., description="Abbreviation")


class CustomFieldDeprecateDto(BaseModel):
    deprecated: bool | None = None


class CustomFieldOptionDto(BaseModel):
    uid: str | None = None
    value: str | None = None
    deprecated: bool | None = None
    used: bool | None = None


class CustomFieldOptionsTruncatedDto(BaseModel):
    truncatedOptions: List[CustomFieldOptionDto] | None = Field(
        None,
        description="Truncated list of options with size 5.\n    To get all options use endpoint for getting options of the specific field",
    )
    remainingCount: int | None = None


class CustomFieldValueDto(BaseModel):
    fieldName: str
    value: Dict[str, Any]


class DictionaryItemDto(BaseModel):
    lang: str
    word: str


class DiscountSettingsDto(BaseModel):
    repetition: float | None = None
    tm101: float | None = None
    tm100: float | None = None
    tm95: float | None = None
    tm85: float | None = None
    tm75: float | None = None
    tm50: float | None = None
    tm0: float | None = None
    mt100: float | None = None
    mt95: float | None = None
    mt85: float | None = None
    mt75: float | None = None
    mt50: float | None = None
    mt0: float | None = None
    nt100: float | None = None
    nt99: float | None = None
    nt85: float | None = None
    nt75: float | None = None
    nt50: float | None = None
    nt0: float | None = None
    if100: float | None = None
    if95: float | None = None
    if85: float | None = None
    if75: float | None = None
    if50: float | None = None
    if0: float | None = None


class DitaSettingsDto(BaseModel):
    includeTags: str | None = None
    excludeTags: str | None = None
    inlineTags: str | None = None
    inlineTagsNonTranslatable: str | None = None
    tagRegexp: str | None = None
    extractSeparateSegmentsXpath: str | None = None


class DocBookSettingsDto(BaseModel):
    includeTags: str | None = None
    excludeTags: str | None = None
    inlineTags: str | None = None
    inlineTagsNonTranslatable: str | None = None
    tagRegexp: str | None = None


class DocSettingsDto(BaseModel):
    comments: bool | None = Field(False, description="Default: false")
    index: bool | None = Field(True, description="Default: true")
    other: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    hyperlinkTarget: bool | None = Field(False, description="Default: false")
    joinSimilarRuns: bool | None = Field(False, description="Default: false")
    targetFont: str | None = None
    properties: bool | None = Field(False, description="Default: false")
    hidden: bool | None = Field(False, description="Default: false")
    headerFooter: bool | None = Field(True, description="Default: true")


class DomainEditDto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None


class DomainReference(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class DomainReference3(BaseModel):
    uid: str | None = None
    name: str | None = None


class DomainReference4(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class DownloadTargetFileDto(BaseModel):
    callbackUrl: str | None = None


class DueDateSchemeListEntryDto(BaseModel):
    uid: str | None = None
    name: str | None = None


class EditQASettingsDtoV2(BaseModel):
    checks: List[Dict[str, Dict[str, Any]]] | None = Field(
        None,
        description="checks",
        examples=[
            '\n        {\n            "ignorable": false,\n            "enabled": true,\n            "type": "VOID",\n            "instant": false,\n            "name": "emptyTarget"\n        },\n        {\n            "ignorable": false,\n            "enabled": true,\n            "value": 12,\n            "type": "NUMBER",\n            "name": "targetLength"\n        },\n        {\n            "ignorable": false,\n            "enabled": true,\n            "value": "ASAP, irony",\n            "type": "STRING",\n            "instant": true,\n            "name": "forbiddenStrings"\n        },\n        {\n            "enabled": true,\n            "profile": "jiris",\n            "ignorable": true,\n            "type": "MORAVIA",\n            "name": "moravia"\n        },\n        {\n            "rules": [\n                {\n                    "description": "Description",\n                    "sourceRegexp": ".+",\n                    "targetRegexp": ".+",\n                    "ignorable": true\n                },\n                {\n                    "description": "Description",\n                    "sourceRegexp": "i+",\n                    "targetRegexp": "e+",\n                    "ignorable": false\n                }\n            ],\n            "type": "REGEX",\n            "name": "regexp"\n        },\n        {\n            "enabled": true,\n            "ignorable": true,\n            "type": "VOID",\n            "name": "customQa"\n        }\n    '
        ],
    )


class EditSegmentationRuleDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    primary: bool | None = Field(False, description="Default: false")


class EditWorkflowStepDto(BaseModel):
    name: constr(min_length=1, max_length=255) | None = Field(
        None, description="Name of the lqa workflow step"
    )
    order: int | None = Field(None, description="Order value")
    lqaEnabled: bool | None = Field(False, description="Default: false")
    abbr: constr(min_length=1, max_length=3) | None = Field(
        None, description="Abbreviation"
    )


class EditionDto(BaseModel):
    name: str | None = None


class Email(BaseModel):
    value: str | None = None
    type: str | None = None
    primary: bool | None = Field(False, description="Default: false")


class EmailQuotesResponseDto(BaseModel):
    recipients: List[str] | None = None


class EnabledCheckContextDtoV2(BaseModel):
    moraviaProfileId: str | None = None
    customQaDisplayName: str | None = None
    provider: str | None = None


class EnabledCheckContextDtoV4(BaseModel):
    moraviaProfileId: str | None = None
    customQaDisplayName: str | None = None
    provider: str | None = None


class EnabledCheckDtoV2(BaseModel):
    checkerType: str | None = None
    context: EnabledCheckContextDtoV2 | None = None


class EnabledCheckDtoV4(BaseModel):
    checkerType: str | None = None
    context: EnabledCheckContextDtoV4 | None = None


class ErrorDetailDto(BaseModel):
    code: str | None = Field(None, description="Code, e.g. NOT_FOUND.")
    args: Dict[str, Dict[str, Any]] | None = Field(
        None, description='Related arguments, e.g. number => "hello world"'
    )
    message: str | None = Field(None, description="Optional human-readable message.")


class ErrorDetailDtoV2(BaseModel):
    code: str | None = Field(None, description="Code, e.g. NOT_FOUND.")
    args: Dict[str, Dict[str, Any]] | None = Field(
        None, description='Related arguments, e.g. number => "hello world"'
    )
    message: str | None = Field(None, description="Optional human-readable message.")


class ErrorDetailDtoV3(BaseModel):
    code: str | None = Field(None, description="Code, e.g. NOT_FOUND.")
    args: Dict[str, Dict[str, Any]] | None = Field(
        None, description='Related arguments, e.g. number => "hello world"'
    )
    message: str | None = Field(None, description="Optional human-readable message.")


class ErrorDto(BaseModel):
    code: str | None = None
    message: str | None = None


class ErrorsReference(BaseModel):
    creationTask: BackgroundTaskReference | None = None
    lastTask: BackgroundTaskReference | None = None


class ExportTMDto(BaseModel):
    exportTargetLangs: List[str] | None = None
    callbackUrl: str | None = None


class FeaturesDto(BaseModel):
    icuEnabled: bool | None = None
    rejectJobs: bool | None = None
    qaHighlightsEnabled: bool | None = None
    lqaBulkCommentsCreation: bool | None = None
    mtForTMAbove100Enabled: bool | None = None
    mqmQualityEstimationEnabled: bool | None = None
    tweI18nEnabled: bool | None = None
    platformSettingsEnabled: bool | None = None
    ignoreTagMetadataEnabled: bool | None = None
    filteringByRegexEnabled: bool | None = None
    filteringByCustomMetadataEnabled: bool | None = None
    tbCustomFieldsEnabled: bool | None = None
    idmOrganizationLogoEnabled: bool | None = None
    loadingSegmentsUsingAnchorsEnabled: bool | None = None
    autoLqaCopilotEnabled: bool | None = None
    mtuOptimizationEnabled: bool | None = None


class FileDto(BaseModel):
    id: str | None = None
    name: str | None = None
    encodedName: str | None = None
    contentType: str | None = None
    note: str | None = None
    size: int | None = None
    directory: bool | None = None
    lastModified: AwareDatetime | None = None
    dueDate: AwareDatetime | None = None
    selected: bool | None = None
    error: ErrorDto | None = None


class FileHandoverDto(BaseModel):
    fileId: str | None = Field(None, description="ID of the uploaded file")
    filename: str | None = Field(None, description="Filename of the uploaded file")


class FileListDto(BaseModel):
    files: List[FileDto] | None = None
    currentFolder: str | None = None
    encodedCurrentFolder: str | None = None
    rootFolder: bool | None = None
    lastChangedFiles: List[FileDto] | None = None


class FileNamingSettingsDto(BaseModel):
    renameCompleted: bool | None = None
    completedFilePattern: constr(min_length=0, max_length=255) | None = None
    targetFolderPath: constr(min_length=0, max_length=255) | None = None


class FinishAssessmentDto(BaseModel):
    overallFeedback: str | None = Field(
        None,
        description="Overall feedback from the LQA reviewer.\n        If the assessment has already been finished before, null value means keep the previous feedback.",
    )


class FinishAssessmentItemDto(BaseModel):
    jobPartUid: str = Field(..., description="UID of the corresponding job part")
    overallFeedback: str | None = Field(
        None,
        description="Overall feedback from the LQA reviewer.\n        If the assessment has already been finished before, null value means keep the previous feedback.",
    )


class FinishAssessmentsDto(BaseModel):
    items: List[FinishAssessmentItemDto] = Field(..., max_length=100, min_length=1)


class GetFileRequestParamsDto(BaseModel):
    sourceLang: str | None = None
    targetLang: str | None = None
    callbackUrl: str | None = Field(
        None,
        examples=['{"callbackUrl": "https://www.yourdomain.com/callback_endpoint"}'],
    )


class GlossaryActivationDto(BaseModel):
    active: bool | None = None


class GlossarySimpleDto(BaseModel):
    uid: str | None = None
    name: str | None = None


class HtmlSettingsDto(BaseModel):
    breakTagCreatesSegment: bool | None = Field(True, description="Default: true")
    unknownTagCreatesTag: bool | None = Field(True, description="Default: true")
    preserveWhitespace: bool | None = Field(False, description="Default: false")
    importComments: bool | None = Field(True, description="Default: true")
    excludeElements: str | None = Field(
        None, description='Example: "script,blockquote"'
    )
    tagRegexp: str | None = None
    charEntitiesToTags: str | None = None
    translateMetaTagRegexp: str | None = None
    importDefaultMetaTags: bool | None = Field(True, description="Default: true")
    translatableAttributes: str | None = None
    importDefaultAttributes: bool | None = Field(True, description="Default: true")
    nonTranslatableInlineElements: str | None = Field(
        None, description='Example: "code"'
    )
    translatableInlineElements: str | None = Field(None, description='Example: "span"')
    updateLang: bool | None = Field(False, description="Default: false")
    escapeDisabled: bool | None = Field(None, description="Default: `false`")
    segmentationBeginTagPlaceholder: str | None = None
    segmentationEndTagPlaceholder: str | None = None
    segmentationSingleTagPlaceholder: str | None = None


class IdReference(BaseModel):
    id: str


class IdmlSettingsDto(BaseModel):
    extractNotes: bool | None = Field(False, description="Default: false")
    simplifyCodes: bool | None = Field(True, description="Default: true")
    extractMasterSpreads: bool | None = Field(True, description="Default: true")
    extractLockedLayers: bool | None = Field(True, description="Default: true")
    extractInvisibleLayers: bool | None = Field(False, description="Default: false")
    extractHiddenConditionalText: bool | None = Field(
        False, description="Default: false"
    )
    extractHyperlinks: bool | None = Field(False, description="Default: false")
    keepKerning: bool | None = Field(False, description="Default: false")
    keepTracking: bool | None = Field(False, description="Default: false")
    targetFont: str | None = None
    replaceFont: bool | None = Field(True, description="Default: true")
    removeXmlElements: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    extractCrossReferenceFormats: bool | None = Field(True, description="Default: true")
    extractVariables: bool | None = Field(True, description="Default: true")


class ImportGlossaryResponseDto(BaseModel):
    langs: List[str] | None = None
    createdTermsCount: int | None = None
    updatedTermsCount: int | None = None


class ImportTermBaseResponseDto(BaseModel):
    langs: List[str] | None = None
    createdTermsCount: int | None = None
    updatedTermsCount: int | None = None


class InputStream(BaseModel):
    pass


class InputStreamLength(BaseModel):
    stream: InputStream | None = None
    length: int | None = None
    name: str | None = None
    characterEncoding: str | None = None
    extension: str | None = None
    cleanupTask: CleanupTask | None = None


class IssueCountsDto(BaseModel):
    critical: int
    criticalRepeated: int
    major: int
    majorRepeated: int
    minor: int
    minorRepeated: int
    neutral: int
    neutralRepeated: int


class JobCreateRemoteFileDto(BaseModel):
    connectorToken: str
    remoteFolder: str | None = None
    remoteFileName: str
    remoteFileNameRegex: bool | None = None
    continuous: bool | None = None


class JobNonTranslatableSettingsV3Dto(BaseModel):
    preTranslateNonTranslatables: bool | None = Field(
        True, description="Pre-translate non-translatables. Default: true"
    )
    confirm100PercentMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for: 100% non-translatables. Default: false",
    )
    lock100PercentMatches: bool | None = Field(
        False, description="Lock section: 100% non-translatables. Default: false"
    )


class JobPartPatchResultDto(BaseModel):
    updated: int | None = Field(
        None, description="Number of successfully updated job parts"
    )
    errors: List[ErrorDetailDtoV3] | None = Field(
        None, description="Errors and their counts encountered during the update"
    )


class JobRemoteFileReference(BaseModel):
    humanReadableFolder: str | None = None
    humanReadableFileName: str | None = None
    encodedFolder: str | None = None
    encodedFileName: str | None = None


class JobTranslationMemorySettingsV3Dto(BaseModel):
    useTranslationMemory: bool | None = Field(
        True, description="Pre-translate from translation memory. Default: true"
    )
    translationMemoryThreshold: confloat(ge=0.0, le=1.01) | None = Field(
        None, description="Pre-translation threshold percent. Default: 0.7"
    )
    confirm100PercentMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for: 100% translation memory matches. Default: false",
    )
    confirm101PercentMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for: 101% translation memory matches. Default: false",
    )
    lock100PercentMatches: bool | None = Field(
        False,
        description="Lock section: 100% translation memory matches. Default: false",
    )
    lock101PercentMatches: bool | None = Field(
        False,
        description="Lock section: 101% translation memory matches. Default: false",
    )


class JobWidgetReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None


class JsonSettingsDto(BaseModel):
    tagRegexp: str | None = None
    htmlSubFilter: bool | None = Field(True, description="Default: true")
    icuSubFilter: bool | None = Field(False, description="Default: false")
    excludeKeyRegexp: str | None = None
    includeKeyRegexp: str | None = None
    contextNotePath: str | None = None
    maxLenPath: str | None = None
    contextKeyPath: str | None = None


class Origin(str, Enum):
    HUMAN = "HUMAN"


class LanguageDto2(BaseModel):
    code: str | None = None
    name: str | None = None
    rfc: str | None = None
    android: str | None = None
    androidBcp: str | None = None


class LanguageListDto(BaseModel):
    languages: List[LanguageDto2]


class LanguageMetadata(BaseModel):
    termsCount: int | None = None


class LanguageMetadata1(BaseModel):
    segmentsCount: int | None = None


class LoginDto(BaseModel):
    userName: str
    password: str
    code: str | None = Field(
        None, description="Required only for 2-factor authentication"
    )


class LoginOtherDto(BaseModel):
    userName: str


class LoginOtherV3Dto(BaseModel):
    userUid: str | None = Field(
        None, description="When not filled, default user of identity will be logged in"
    )
    userName: str


class LoginToSessionDto(BaseModel):
    userName: str
    password: str
    rememberMe: bool | None = None


class LoginToSessionV3Dto(BaseModel):
    userUid: str | None = Field(
        None, description="When not filled, default user of identity will be logged in"
    )
    userName: str
    password: str
    rememberMe: bool | None = None
    twoFactorCode: int | None = Field(
        None,
        description="Two-factor authentication code. Required if two-factor authentication is enabled",
    )
    captchaCode: str | None = None


class LoginV3Dto(BaseModel):
    userUid: str | None = Field(
        None, description="When not filled, default user of identity will be logged in"
    )
    userName: str
    password: str
    code: str | None = Field(
        None, description="Required only for 2-factor authentication"
    )


class LoginWithAppleDto(BaseModel):
    codeOrRefreshToken: str


class LoginWithGoogleDto(BaseModel):
    idToken: str


class LqaErrorCategoryDto(BaseModel):
    errorCategoryId: int | None = None
    name: str | None = None
    enabled: bool | None = None
    errorCategories: List[LqaErrorCategoryDto] | None = None


class LqaReportLinkDto(BaseModel):
    url: str | None = Field(None, description="Link of the report")
    expires: AwareDatetime | None = Field(None, description="When link expires")
    size: int | None = Field(None, description="Size of the linked file in bytes")


class LqaSeverityDto(BaseModel):
    severityId: int | None = None
    name: str | None = None
    weight: int | None = None


class MacSettingsDto(BaseModel):
    htmlSubfilter: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    icuSubFilter: bool | None = Field(None, description="Default: `false`")


class MachineTranslateResponse(BaseModel):
    translations: List[str] | None = None


class MachineTranslateSettingsLangsDto(BaseModel):
    id: str | None = Field(None, description="Id")
    sourceLang: str | None = Field(
        None, description="Source language for CUSTOMIZABLE engine"
    )
    targetLangs: List[str] | None = Field(
        None, description="List of target languages for the CUSTOMIZABLE engine"
    )


class MachineTranslateSettingsPbmDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    baseName: str | None = None
    name: str | None = None
    type: str | None = None
    default_: bool | None = None
    includeTags: bool | None = None
    mtQualityEstimation: bool | None = None
    args: Dict[str, str] | None = None
    payForMtPossible: bool | None = None
    payForMtActive: bool | None = None
    charCount: int | None = None
    sharingSettings: int | None = None
    langs: MachineTranslateSettingsLangsDto | None = None


class MachineTranslateSettingsReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    type: str | None = None


class MachineTranslateSettingsSimpleDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    baseName: str | None = None
    name: str | None = None
    type: str | None = None
    category: str | None = None
    enabled: bool | None = None
    glossarySupported: bool | None = None


class MachineTranslateStatusDto(BaseModel):
    uid: str | None = None
    ok: bool | None = None
    error: str | None = None


class Match(BaseModel):
    beginIndex: int | None = None
    text: str | None = None


class MatchCounts101Dto(BaseModel):
    match100: CountsDto | None = None
    match95: CountsDto | None = None
    match85: CountsDto | None = None
    match75: CountsDto | None = None
    match50: CountsDto | None = None
    match0: CountsDto | None = None
    match101: CountsDto | None = None


class MatchCounts101Dto2(BaseModel):
    match100: CountsDto2 | None = None
    match95: CountsDto2 | None = None
    match85: CountsDto2 | None = None
    match75: CountsDto2 | None = None
    match50: CountsDto2 | None = None
    match0: CountsDto2 | None = None
    match101: CountsDto2 | None = None


class MatchCounts101Dto3(BaseModel):
    match100: CountsDto3 | None = None
    match95: CountsDto3 | None = None
    match85: CountsDto3 | None = None
    match75: CountsDto3 | None = None
    match50: CountsDto3 | None = None
    match0: CountsDto3 | None = None
    match101: CountsDto3 | None = None


class MatchCountsDto(BaseModel):
    match100: CountsDto | None = None
    match95: CountsDto | None = None
    match85: CountsDto | None = None
    match75: CountsDto | None = None
    match50: CountsDto | None = None
    match0: CountsDto | None = None


class MatchCountsDto2(BaseModel):
    match100: CountsDto2 | None = None
    match95: CountsDto2 | None = None
    match85: CountsDto2 | None = None
    match75: CountsDto2 | None = None
    match50: CountsDto2 | None = None
    match0: CountsDto2 | None = None


class MatchCountsDto3(BaseModel):
    match100: CountsDto3 | None = None
    match95: CountsDto3 | None = None
    match85: CountsDto3 | None = None
    match75: CountsDto3 | None = None
    match50: CountsDto3 | None = None
    match0: CountsDto3 | None = None


class MatchCountsNTDto(BaseModel):
    match100: CountsDto2 | None = None
    match99: CountsDto2 | None = None


class MatchCountsNTDtoV1(BaseModel):
    match100: CountsDto | None = None
    match99: CountsDto | None = None


class MatchCountsNTDto2(BaseModel):
    match100: CountsDto3 | None = None
    match95: CountsDto3 | None = None
    match85: CountsDto3 | None = None
    match75: CountsDto3 | None = None
    match50: CountsDto3 | None = None
    match0: CountsDto3 | None = None


class MemTransMachineTranslateSettingsDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    baseName: str | None = None
    name: str | None = None
    type: str | None = None
    category: str | None = None
    default_: bool | None = None
    includeTags: bool | None = None
    mtQualityEstimation: bool | None = None
    enabled: bool | None = None
    glossarySupported: bool | None = None
    args: Dict[str, str] | None = None
    langs: MachineTranslateSettingsLangsDto | None = None
    charCount: int | None = Field(
        None, description="Unknown value is represented by value: -1"
    )


class MetadataOptionReference(BaseModel):
    uid: str | None = None
    value: str | None = None


class MetadataReference(BaseModel):
    uid: str | None = None
    fieldName: str | None = None
    value: str | None = None
    options: List[MetadataOptionReference] | None = None


class MetadataResponse(BaseModel):
    languages: List[str] | None = None
    termsCount: int | None = None
    metadataByLanguage: Dict[str, LanguageMetadata] | None = None


class MetadataResponse2(BaseModel):
    segmentsCount: int | None = None
    deduplicatedSegmentsCount: int | None = None
    metadataByLanguage: Dict[str, LanguageMetadata1] | None = None


class MetadataTbDto(BaseModel):
    termsCount: int | None = None
    metadataByLanguage: Dict[str, int] | None = None


class MifSettingsDto(BaseModel):
    extractBodyPages: bool | None = Field(True, description="Default: true")
    extractReferencePages: bool | None = Field(False, description="Default: false")
    extractMasterPages: bool | None = Field(True, description="Default: true")
    extractHiddenPages: bool | None = Field(False, description="Default: false")
    extractVariables: bool | None = Field(False, description="Default: false")
    extractIndexMarkers: bool | None = Field(True, description="Default: true")
    extractLinks: bool | None = Field(False, description="Default: false")
    extractXRefDef: bool | None = Field(False, description="Default: false")
    extractPgfNumFormat: bool | None = Field(True, description="Default: true")
    extractCustomReferencePages: bool | None = Field(True, description="Default: true")
    extractDefaultReferencePages: bool | None = Field(
        False, description="Default: false"
    )
    extractUsedVariables: bool | None = Field(True, description="Default: true")
    extractHiddenCondText: bool | None = Field(False, description="Default: false")
    extractUsedXRefDef: bool | None = Field(True, description="Default: true")
    extractUsedPgfNumFormat: bool | None = Field(True, description="Default: true")
    tagRegexp: str | None = None


class MisspelledWord(BaseModel):
    word: str | None = None
    offset: int | None = None


class MisspelledWordDto(BaseModel):
    word: str | None = None
    offset: int | None = None


class MultipartFile(BaseModel):
    name: str | None = None
    bytes: List[str] | None = None
    empty: bool | None = None
    size: int | None = None
    inputStream: InputStream | None = None
    originalFilename: str | None = None
    contentType: str | None = None


class Name(BaseModel):
    givenName: str
    familyName: str


class NameDto(BaseModel):
    id: str | None = None
    name: str | None = None


class NetRateSchemeEdit(BaseModel):
    name: constr(min_length=1, max_length=255)
    rates: DiscountSettingsDto | None = None
    defaultScheme: bool | None = None


class NetRateSchemeWorkflowStepCreate(BaseModel):
    workflowStep: IdReference
    rates: DiscountSettingsDto | None = None


class NetRateSchemeWorkflowStepEdit(BaseModel):
    rates: DiscountSettingsDto | None = None


class NonTranslatableSettingsDto5(BaseModel):
    preTranslateNonTranslatables: bool | None = Field(
        False, description="Pre-translate non-translatables. Default: false"
    )
    confirm100PercentMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for: 100% non-translatables. Default: false",
    )
    lock100PercentMatches: bool | None = Field(
        False, description="Lock section: 100% non-translatables. Default: false"
    )
    nonTranslatablesInEditors: bool | None = Field(
        None, description="If non-translatables are enabled in Editors."
    )


class NotificationDto(BaseModel):
    uid: str | None = None
    seen: bool | None = None
    dateCreated: AwareDatetime | None = None
    dateSeen: AwareDatetime | None = None
    projectUid: str | None = None
    jobPartUid: str | None = None
    commentUid: str | None = None
    messageBody: str | None = None
    messageTitle: str | None = None


class NotifyProviderDto(BaseModel):
    organizationEmailTemplate: IdReference
    notificationIntervalInMinutes: conint(ge=0, le=1440) | None = None


class Number(BaseModel):
    pass


class ObjectReference(BaseModel):
    pass


class OrganizationReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None


class OrganizationReference2(BaseModel):
    uid: str | None = None
    name: str | None = None


class UserCreateDtoPortalMember(AbstractUserCreateDto):
    role: Literal["PORTAL_MEMBER"] = "PORTAL_MEMBER"


class UserEditDtoPortalMember(AbstractUserEditDto):
    role: Literal["PORTAL_MEMBER"] = "PORTAL_MEMBER"


class PassFailThresholdDto(BaseModel):
    minScorePercentage: float = Field(
        ...,
        description="Minimum allowed LQA score in percentage in line with MQM scoring (1 - penalties/word-count)",
        examples=[99],
    )


class PhpSettingsDto(BaseModel):
    tagRegexp: str | None = None
    htmlSubFilter: bool | None = Field(False, description="Default: false")


class Position(BaseModel):
    beginIndex: int | None = None
    endIndex: int | None = None


class AnalyseSettingsDtoPostAnalyse(AbstractAnalyseSettingsDto):
    transMemoryPostEditing: bool | None = Field(False, description="Default: false")
    nonTranslatablePostEditing: bool | None = Field(False, description="Default: false")
    machineTranslatePostEditing: bool | None = Field(
        False, description="Default: false"
    )
    type: Literal["PostAnalyse"] = "PostAnalyse"


class PptSettingsDto(BaseModel):
    hiddenSlides: bool | None = Field(False, description="Default: false")
    other: bool | None = Field(False, description="Default: false")
    notes: bool | None = Field(False, description="Default: false")
    masterSlides: bool | None = Field(False, description="Default: false")


class AnalyseSettingsDtoPreAnalyse(AbstractAnalyseSettingsDto):
    includeFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    separateFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    includeNonTranslatables: bool | None = Field(False, description="Default: false")
    includeMachineTranslationMatches: bool | None = Field(
        False, description="Default: false"
    )
    skipMtScoreThreshold: float | None = Field(
        None,
        description="Used only for Default analysis. Threshold above which the MT suggestions are not used. Default: value from PreTranslate settings",
    )
    type: Literal["PreAnalyse"] = "PreAnalyse"


class PriceListReference(BaseModel):
    id: str | None = None
    name: str | None = None
    uid: str | None = None


class PriceSet(BaseModel):
    sourceLang: str | None = None
    targetLang: str | None = None
    prices: Dict[str, float] | None = None
    minimumPrice: float | None = None


class ProgressDto(BaseModel):
    totalCount: int | None = None
    finishedCount: int | None = None
    overdueCount: int | None = None


class ProgressDtoV2(BaseModel):
    totalCount: int | None = None
    finishedCount: int | None = None
    overdueCount: int | None = None


class ProgressReference(BaseModel):
    totalCount: int | None = None
    finishedCount: int | None = None
    overdueCount: int | None = None
    finishedRatio: float | None = None
    overdueRatio: float | None = None


class ProjectReference(BaseModel):
    name: str | None = None
    uid: str | None = None


class ProjectReferenceFilesRequestDto(BaseModel):
    referenceFiles: List[IdReference]


class ProjectTemplateNotifyProviderDto(BaseModel):
    organizationEmailTemplate: ObjectReference
    notificationIntervalInMinutes: conint(ge=0, le=1440) | None = None


class ProjectTermBaseReference(BaseModel):
    id: str | None = None
    termBase: ObjectReference | None = None
    name: str | None = None
    writeMode: bool | None = None
    targetLang: str | None = None
    readMode: bool | None = None
    workflowStep: ObjectReference | None = None


class ProjectTranslationMemoryReference(BaseModel):
    id: str | None = None
    transMem: ObjectReference | None = None
    name: str | None = None
    workflowStep: ObjectReference | None = None
    targetLang: str | None = None
    penalty: float | None = None
    readMode: bool | None = None


class ProjectWorkflowSettingsDto(BaseModel):
    completeUnassigned: bool | None = None
    propagateTranslationsToLowerWfDuringUpdateSource: bool | None = None


class ProjectWorkflowSettingsReference(BaseModel):
    propagateTranslationsToLowerWfDuringUpdateSource: bool | None = None


class ProjectWorkflowSettingsV2Dto(BaseModel):
    completeUnassigned: bool | None = None
    propagateTranslationsToLowerWfDuringUpdateSource: bool | None = None


class ProjectWorkflowStepDto(BaseModel):
    id: int | None = None
    abbreviation: str | None = None
    name: str | None = None
    workflowLevel: int | None = None
    workflowStep: ObjectReference | None = None
    lqaProfileUid: str | None = None


class ProjectWorkflowStepReference(BaseModel):
    name: str | None = None
    id: str | None = None
    order: int | None = None
    workflowLevel: int | None = None


class PropertiesSettingsDto(BaseModel):
    tagRegexp: str | None = None


class ProviderReference(BaseModel):
    type: str
    id: str | None = None
    uid: str | None = None


class ProviderReference2(BaseModel):
    uid: str | None = None
    names: List[str] | None = None
    type: str | None = None
    anonymized: bool | None = None
    deleted: bool | None = None
    active: bool | None = None


class Providers2(BaseModel):
    all: List[ProviderReference] | None = None
    relevant: List[ProviderReference] | None = None


class PsdSettingsDto(BaseModel):
    extractHiddenLayers: bool | None = Field(True, description="Default: true")
    extractLockedLayers: bool | None = Field(True, description="Default: true")
    tagRegexp: str | None = None


class PseudoTranslateSettingsDto3(BaseModel):
    replacement: constr(min_length=1, max_length=10) | None = Field(
        None, description="Pseudo-translate using"
    )
    pseudoTranslateIntersperse: bool | None = Field(
        None, description="Mix with source text. Default value: true"
    )
    prefix: str | None = None
    suffix: str | None = None
    pseudoTranslateSubstitution: constr(min_length=0, max_length=100) | None = Field(
        None,
        description="Comma separated list of character map. Example: aá,Bβ,cć,DĎ,eë",
    )
    keyHashPrefixLen: conint(ge=0, le=18) | None = None
    length: confloat(ge=0.1, le=2.0) | None = Field(
        None,
        description="Target segment length (%). Supported values: 0.1, 0.5 ... 1.5, 2.0",
    )


class QualityAssuranceDto(BaseModel):
    segmentsCount: int | None = None
    warningsCount: int | None = None
    ignoredWarningsCount: int | None = None


class QuarkTagSettingsDto(BaseModel):
    removeKerningTrackingTags: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None


class Query(BaseModel):
    query: str | None = None
    lang: str | None = None


class QuoteUnitsDto(BaseModel):
    analyseLanguagePart: IdReference
    value: confloat(ge=0.0) | None = None


class QuoteWorkflowSettingDto(BaseModel):
    workflowStep: IdReference
    units: List[QuoteUnitsDto] | None = Field(None, max_length=100, min_length=0)


class Role15(str, Enum):
    PARENT = "PARENT"


class ReferenceCorrelation(BaseModel):
    uid: str | None = None
    role: Role15 | None = None


class ReferenceFileAccessDto(BaseModel):
    canCreate: bool | None = None


class RegexpCheckRuleDtoV2(BaseModel):
    description: str | None = None
    sourceRegexp: str | None = None
    targetRegexp: str | None = None
    id: str | None = None
    ignorable: bool | None = None
    instant: bool | None = None


class RegexpCheckRuleDtoV4(BaseModel):
    description: str | None = None
    sourceRegexp: str | None = None
    targetRegexp: str | None = None
    id: str | None = None
    ignorable: bool | None = None
    instant: bool | None = None


class RemoteUploadedFileDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    size: int | None = None
    type: str | None = None
    url: str | None = None


class RepetitionsSettingsDto4(BaseModel):
    autoPropagateRepetitions: bool | None = Field(
        False, description="Propagate repetitions. Default: false"
    )
    confirmRepetitions: bool | None = Field(
        False,
        description="Set segment status to confirmed for: Repetitions. Default: false",
    )
    autoPropagateToLockedRepetitions: bool | None = Field(
        False,
        description="Changes in 1st repetition propagate upon confirmation into subsequent locked repetitions. Default: false",
    )
    lockSubsequentRepetitions: bool | None = Field(
        False,
        description="If auto-propagated subsequent repetitions should be locked. Default: false",
    )


class ResxSettingsDto(BaseModel):
    tagRegexp: str | None = None
    htmlSubFilter: bool | None = None


class ReviewProviderDto(BaseModel):
    uid: str | None = None
    organizationUid: str | None = None


class UserCreateDtoSubmitter(AbstractUserCreateDto):
    automationWidgets: List[IdReference] | None = Field(
        None,
        description="If no automation widgets are assigned in request the default automation widgets will be assigned instead",
    )
    projectViewCreatedByOtherSubmitters: bool | None = Field(
        False, description="View projects created by other Submitters. Default: false"
    )
    role: Literal["SUBMITTER"] = "SUBMITTER"


class UserEditDtoSubmitter(AbstractUserEditDto):
    automationWidgets: List[IdReference]
    projectViewCreatedByOtherSubmitters: bool | None = Field(
        False, description="View projects created by other Submitters. Default: false"
    )
    role: Literal["SUBMITTER"] = "SUBMITTER"


class SchemaExtension(BaseModel):
    schema_: str | None = Field(None, alias="schema")
    required: bool | None = None


class ScimMeta(BaseModel):
    created: AwareDatetime | None = None
    location: str | None = None


class ScimResourceTypeSchema(BaseModel):
    schemas: List[str] | None = None
    id: str | None = None
    name: str | None = None
    endpoint: str | None = None
    description: str | None = None
    schema_: str | None = Field(None, alias="schema")
    schemaExtensions: List[SchemaExtension] | None = None


class ScimUserCoreDto(BaseModel):
    schemas: List[str] | None = Field(
        None, examples=['[ "urn:ietf:params:scim:schemas:core:2.0:User" ]']
    )
    id: str | None = None
    userName: str
    name: Name
    active: bool | None = Field(True, description="Default: true")
    emails: List[Email] = Field(..., max_length=2147483647, min_length=1)
    meta: ScimMeta | None = None


class ScoringResultIssueCountsDto(BaseModel):
    neutral: int | None = None
    neutralRepeated: int | None = None
    minor: int | None = None
    minorRepeated: int | None = None
    major: int | None = None
    majorRepeated: int | None = None
    critical: int | None = None
    criticalRepeated: int | None = None


class SdlXlfSettingsDto(BaseModel):
    icuSubFilter: bool | None = Field(False, description="Default: false")
    skipImportRules: str | None = Field(None, description="Default: translate=no")
    importAsConfirmedRules: str | None = None
    importAsLockedRules: str | None = Field(None, description="Default: locked=true")
    exportAttrsWhenConfirmedAndLocked: str | None = Field(
        None, description="Default: locked=true"
    )
    exportAttrsWhenConfirmedAndNotLocked: str | None = None
    exportAttrsWhenNotConfirmedAndLocked: str | None = Field(
        None, description="Default: locked=true"
    )
    exportAttrsWhenNotConfirmedAndNotLocked: str | None = None
    saveConfirmedSegments: bool | None = Field(True, description="Default: true")
    tagRegexp: str | None = None


class SearchTMByJobRequestDtoV3(BaseModel):
    query: str
    reverse: bool | None = Field(False, description="Default: false")
    scoreThreshold: confloat(ge=0.0, le=1.01) | None = Field(
        None, description="Default: 0.0"
    )
    maxResults: conint(ge=1, le=100) | None = Field(None, description="Default: 15")


class SearchTMClientDto(BaseModel):
    id: int | None = None
    name: str | None = None


class SearchTMClientDtoV3(BaseModel):
    id: int | None = None
    name: str | None = None


class SearchTMDomainDto(BaseModel):
    id: int | None = None
    name: str | None = None


class SearchTMDomainDtoV3(BaseModel):
    id: int | None = None
    name: str | None = None


class SearchTMProjectDto(BaseModel):
    id: int | None = None
    uid: str | None = None
    name: str | None = None


class SearchTMProjectDtoV3(BaseModel):
    id: int | None = None
    uid: str | None = None
    name: str | None = None


class SearchTMSubDomainDto(BaseModel):
    id: int | None = None
    name: str | None = None


class SearchTMSubDomainDtoV3(BaseModel):
    id: int | None = None
    name: str | None = None


class SearchTMTransMemoryDto(BaseModel):
    uid: str | None = None
    id: str | None = None
    name: str | None = None
    reverse: bool | None = None


class SearchTMTransMemoryDtoV3(BaseModel):
    uid: str | None = None
    id: str | None = None
    name: str | None = None
    reverse: bool | None = None


class SearchTbByJobRequestDto(BaseModel):
    query: str
    count: int | None = Field(None, description="Default: 15")
    offset: int | None = Field(None, description="Default: 0")
    reverse: bool | None = Field(False, description="Default: false")


class SearchTbInTextByJobRequestDto(BaseModel):
    text: str
    reverse: bool | None = Field(False, description="Default: false")
    zeroLengthSeparator: str | None = None


class SecuritySettingsReference(BaseModel):
    canEdit: bool | None = None
    canEditDueDate: bool | None = None
    canDelete: bool | None = None


class SegRuleReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    language: str | None = None
    name: str | None = None
    filename: str | None = None
    primary: bool | None = None


class SegmentReference(BaseModel):
    uid: str | None = None


class SegmentWarningDto(BaseModel):
    id: str | None = None
    ignored: bool | None = None
    type: str
    repetitionGroupId: str | None = None


class SegmentWarningsDto(BaseModel):
    segmentId: str | None = None
    warnings: List[SegmentWarningDto] | None = None
    ignoredChecks: List[str] | None = None


class SegmentsCountsDto(BaseModel):
    allConfirmed: bool | None = None
    charsCount: int | None = None
    completedCharsCount: int | None = None
    confirmedCharsCount: int | None = None
    confirmedLockedCharsCount: int | None = None
    lockedCharsCount: int | None = None
    segmentsCount: int | None = None
    completedSegmentsCount: int | None = None
    lockedSegmentsCount: int | None = None
    segmentGroupsCount: int | None = None
    translatedSegmentsCount: int | None = None
    translatedLockedSegmentsCount: int | None = None
    nonEmptySegmentGroupsCount: int | None = None
    wordsCount: int | None = None
    completedWordsCount: int | None = None
    confirmedWordsCount: int | None = None
    confirmedLockedWordsCount: int | None = None
    lockedWordsCount: int | None = None
    addedSegments: int | None = None
    addedWords: int | None = None
    machineTranslationPostEditedSegmentsCount: int | None = None
    machineTranslationRelevantSegmentsCount: int | None = None
    qualityAssurance: QualityAssuranceDto | None = None
    qualityAssuranceResolved: bool | None = None


class Type38(str, Enum):
    ProfessionalTranslation = "ProfessionalTranslation"


class ServiceListEntryDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    publicName: str | None = None
    type: Type38 | None = None


class SetFinancialSettingsDto(BaseModel):
    netRateScheme: IdReference | None = None
    priceList: IdReference | None = None


class SetProjectTemplateTermBaseDto(BaseModel):
    readTermBases: List[IdReference] | None = None
    writeTermBase: IdReference | None = None
    qualityAssuranceTermBases: List[IdReference] | None = None
    targetLang: str | None = None
    workflowStep: IdReference | None = None


class SetTermBaseDto(BaseModel):
    readTermBases: List[IdReference] | None = None
    writeTermBase: IdReference | None = None
    qualityAssuranceTermBases: List[IdReference] | None = None
    targetLang: str | None = None


class SettingsReference(BaseModel):
    securitySettings: SecuritySettingsReference | None = None


class SeverityDto(BaseModel):
    code: int | None = Field(None, description="Code of the severity category")
    value: float | None = Field(None, description="Allowed values 0.0-100,000.0")


class SegmentWarningDtoSourceTargetRegexp(SegmentWarningDto):
    description: str | None = None
    type: Literal["SourceTargetRegexp"] = "SourceTargetRegexp"


class SpellCheckRequestDto(BaseModel):
    lang: str
    texts: List[str]
    referenceTexts: List[str] | None = None
    zeroLengthSeparator: str | None = None


class SegmentWarningDtoSpellCheck(SegmentWarningDto):
    misspelledWords: List[MisspelledWordDto] | None = None
    type: Literal["SpellCheck"] = "SpellCheck"


class SplitJobActionDto(BaseModel):
    segmentOrdinals: List[int] | None = Field(None, max_length=2147483647, min_length=1)
    partCount: int | None = None
    partSize: int | None = None
    wordCount: int | None = None
    byDocumentPart: bool | None = Field(
        None, description="Can be used only for PowerPoint files"
    )
    splitAllWorkflowSteps: bool | None = Field(
        False, description="Split in all workflow steps (default: false)"
    )


class SubDomainEditDto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None


class SubDomainReference(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class SubDomainReference3(BaseModel):
    uid: str | None = None
    name: str | None = None


class SubDomainReference4(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None


class SubstituteDto(BaseModel):
    source: str
    target: str


class SubstituteDtoV2(BaseModel):
    source: constr(min_length=1, max_length=1)
    target: constr(min_length=1, max_length=1)


class SuggestRequestDto(BaseModel):
    lang: str
    words: List[str]
    referenceTexts: List[str] | None = None


class Suggestion(BaseModel):
    text: str | None = None


class SuggestionDto2(BaseModel):
    word: str | None = None
    distance: int | None = None


class Supported(BaseModel):
    supported: bool | None = None


class TagMetadata(BaseModel):
    id: str | None = None
    type: str | None = None
    content: str | None = None
    transAttributes: str | None = None


class TagMetadataDto(BaseModel):
    id: str | None = None
    type: str | None = None
    content: str | None = None
    transAttributes: str | None = None


class TargetFileWarningsDto(BaseModel):
    warnings: List[str] | None = None


class TargetLanguageDto(BaseModel):
    language: str


class SegmentWarningDtoTargetSourceIdentical(SegmentWarningDto):
    type: Literal["TargetSourceIdentical"] = "TargetSourceIdentical"


class Term(BaseModel):
    text: str | None = None
    preferred: bool | None = None


class TermBaseCreateDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    langs: List[str] = Field(..., max_length=2147483647, min_length=1)
    client: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    businessUnit: IdReference | None = None
    owner: IdReference | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    sourceUrl: str | None = None
    readonly: bool | None = None


class TermBaseSearchResultDto(BaseModel):
    id: int | None = None
    uid: str | None = None
    name: str | None = None
    readonly: bool | None = None
    sourceUrl: str | None = None


class TermBaseUpdateDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    langs: List[str] = Field(..., max_length=2147483647, min_length=1)
    client: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    businessUnit: IdReference | None = None
    owner: IdReference | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    sourceUrl: str | None = None


class SegmentWarningDtoTerminology(SegmentWarningDto):
    missingTerms: List[str] | None = None
    forbiddenTerms: List[str] | None = None
    type: Literal["Terminology"] = "Terminology"


class ToggleableWeightDto(BaseModel):
    enabled: bool | None = Field(
        None, description="If this error category is enabled, default false"
    )
    weight: float | None = Field(
        None, description="Weight of this error category (0.1 - 99.9)", examples=[1]
    )
    code: int | None = Field(None, description="Code of the error category")


class SegmentWarningDtoTrailingPunctuation(SegmentWarningDto):
    srcPosition: Position | None = None
    srcEndPunctuation: str | None = None
    tgtPosition: Position | None = None
    tgtEndPunctuation: str | None = None
    suggestedTgtEndPunctuation: str | None = None
    type: Literal["TrailingPunctuation"] = "TrailingPunctuation"


class SegmentWarningDtoTrailingSpace(SegmentWarningDto):
    type: Literal["TrailingSpace"] = "TrailingSpace"


class TransMemoryCreateDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    sourceLang: str
    targetLangs: List[str]
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    note: constr(min_length=0, max_length=4096) | None = None


class TransMemoryEditDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    targetLangs: List[str] = Field(
        ..., description="New target languages to add. No languages can be removed"
    )
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    owner: IdReference | None = None
    note: constr(min_length=0, max_length=4096) | None = None


class TransMemoryReferenceDtoV2(BaseModel):
    internalId: int | None = None
    uid: str
    name: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None


class TranslationDto(BaseModel):
    lang: str
    text: str


class SegmentWarningDtoTranslationLength(SegmentWarningDto):
    type: Literal["TranslationLength"] = "TranslationLength"


class TranslationMemorySettingsDto5(BaseModel):
    useTranslationMemory: bool | None = Field(
        False, description="Pre-translate from translation memory. Default: false"
    )
    translationMemoryThreshold: confloat(ge=0.0, le=1.01) | None = Field(
        None, description="Pre-translation threshold percent"
    )
    confirm100PercentMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for: 100% translation memory matches. Default: false",
    )
    confirm101PercentMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for: 101% translation memory matches. Default: false",
    )
    lock100PercentMatches: bool | None = Field(
        False,
        description="Lock section: 100% translation memory matches. Default: false",
    )
    lock101PercentMatches: bool | None = Field(
        False,
        description="Lock section: 101% translation memory matches. Default: false",
    )


class TranslationPriceSetBulkDeleteDto(BaseModel):
    sourceLanguages: List[str] | None = None
    targetLanguages: List[str] | None = None


class TranslationPriceSetBulkMinimumPricesDto(BaseModel):
    sourceLanguages: List[str] | None = None
    targetLanguages: List[str] | None = None
    minimumPrice: float | None = None


class TranslationPriceSetBulkPricesDto(BaseModel):
    sourceLanguages: List[str] | None = None
    targetLanguages: List[str] | None = None
    price: float | None = None
    workflowSteps: List[IdReference] | None = Field(None, max_length=15, min_length=0)


class TranslationPriceSetCreateDto(BaseModel):
    sourceLanguages: List[str] = Field(..., max_length=100, min_length=1)
    targetLanguages: List[str] = Field(..., max_length=100, min_length=1)


class TranslationRequestDto(BaseModel):
    sourceTexts: List[str] = Field(..., max_length=2147483647, min_length=1)


class TranslationRequestExtendedDto(BaseModel):
    sourceTexts: List[str] = Field(..., max_length=2147483647, min_length=1)
    from_: str = Field(..., alias="from")
    to: str
    filename: str | None = None


class TranslationResourcesDto(BaseModel):
    machineTranslateSettings: MachineTranslateSettingsReference | None = None
    translationMemories: List[ProjectTranslationMemoryReference] | None = None
    termBases: List[ProjectTermBaseReference] | None = None


class TranslationSegmentsReferenceV2(BaseModel):
    confirmed: bool | None = Field(
        None,
        description="Remove confirmed (true), unconfirmed (false) or both segments (null). Default: null",
    )
    locked: bool | None = Field(
        False,
        description="Remove locked (true), unlocked (false) or both segments (null). Default: false",
    )


class TtxSettingsDto(BaseModel):
    saveConfirmedSegments: bool | None = Field(True, description="Default: true")


class TxtSettingsDto(BaseModel):
    tagRegexp: str | None = None
    translatableTextRegexp: str | None = None
    contextKey: str | None = None
    regexpCapturingGroups: bool | None = Field(False, description="Default: false")


class TypesDto(BaseModel):
    types: List[str] | None = None


class ProviderReferenceUser(ProviderReference):
    userName: str | None = None
    firstName: str | None = None
    lastName: str | None = None
    email: str | None = None
    active: bool | None = None
    type: Literal["USER"] = "USER"


class UidReference(BaseModel):
    uid: str


class SegmentWarningDtoUnmodifiedFuzzyTranslationMTNT(SegmentWarningDto):
    transOrigin: str | None = None
    type: Literal["UnmodifiedFuzzyTranslationMTNT"] = "UnmodifiedFuzzyTranslationMTNT"


class SegmentWarningDtoUnmodifiedFuzzyTranslationTM(SegmentWarningDto):
    transOrigin: str | None = None
    type: Literal["UnmodifiedFuzzyTranslationTM"] = "UnmodifiedFuzzyTranslationTM"


class SegmentWarningDtoUnmodifiedFuzzyTranslation(SegmentWarningDto):
    transOrigin: str | None = None
    type: Literal["UnmodifiedFuzzyTranslation"] = "UnmodifiedFuzzyTranslation"


class SegmentWarningDtoUnresolvedComment(SegmentWarningDto):
    type: Literal["UnresolvedComment"] = "UnresolvedComment"


class SegmentWarningDtoUnresolvedConversation(SegmentWarningDto):
    type: Literal["UnresolvedConversation"] = "UnresolvedConversation"


class UpdateCustomFieldInstanceDto(BaseModel):
    selectedOptions: List[UidReference] | None = None
    value: constr(min_length=0, max_length=4096) | None = None


class UpdateCustomFieldInstanceWithUidDto(BaseModel):
    customFieldInstance: UidReference
    customField: UidReference | None = None
    selectedOptions: List[UidReference] | None = None
    value: constr(min_length=0, max_length=4096) | None = None


class UpdateIgnoredWarning(BaseModel):
    id: str


class UpdateIgnoredWarning2(BaseModel):
    id: str


class UploadBilingualFileRequestDto(BaseModel):
    file: MultipartFile


class UploadResultDto(BaseModel):
    id: str | None = None
    name: str | None = None
    folder: str | None = None
    encodedName: str | None = None
    size: int | None = None
    error: str | None = None
    asyncTaskId: str | None = None
    errors: ConnectorErrorsDto | None = None


class UploadedFileDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    size: int | None = None
    type: str | None = None


class User(BaseModel):
    id: int


class UserPasswordEditDto(BaseModel):
    password: constr(min_length=8, max_length=255)


class UserReference4(BaseModel):
    uid: str | None = None
    username: str | None = None
    firstName: str | None = None
    lastName: str | None = None
    organizationUid: str | None = None


class UserStatisticsDto(BaseModel):
    date: AwareDatetime | None = None
    ipAddress: str | None = None
    ipCountry: str | None = None
    userAgent: str | None = None


class UserStatisticsListDto(BaseModel):
    userStatistics: List[UserStatisticsDto]


class ProviderReferenceVendor(ProviderReference):
    name: str | None = None
    defaultProjectOwnerId: int | None = None
    type: Literal["VENDOR"] = "VENDOR"


class VendorReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None


class VendorSecuritySettingsDto(BaseModel):
    canChangeSharedJobDueDateEnabled: bool | None = Field(
        None, description="Default: `false`"
    )
    canChangeSharedJobDueDate: List[UidReference] | None = None
    jobVendorsMayUploadReferences: bool | None = Field(
        None, description="Default: `false`"
    )


class VendorUserReference(BaseModel):
    uid: str | None = None
    vendorUid: str | None = None
    username: str | None = None
    firstName: str | None = None
    lastName: str | None = None
    organization: OrganizationReference2 | None = None


class VerityWeightsDto(BaseModel):
    verity: ToggleableWeightDto | None = None
    cultureSpecificReference: ToggleableWeightDto | None = None


class WebEditorLinkDtoV2(BaseModel):
    url: str | None = None
    warnings: List[ErrorDetailDtoV2] | None = None


class WildCardSearchByJobRequestDtoV3(BaseModel):
    query: str
    reverse: bool | None = Field(False, description="Default: false")
    count: conint(ge=1, le=50) | None = None
    offset: int | None = None


class WildCardSearchRequestDto(BaseModel):
    query: str | None = None
    sourceLang: str
    targetLangs: List[str] | None = None
    count: conint(ge=1, le=50) | None = None
    offset: int | None = None
    sourceLangs: List[str] | None = None


class WorkflowChangesDto(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)


class WorkflowStepDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    abbr: str | None = None
    order: int | None = None
    lqaEnabled: bool | None = None


class WorkflowStepReference(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None
    order: int | None = None
    lqaEnabled: bool | None = None


class WorkflowStepReferenceV2(BaseModel):
    name: str | None = None
    uid: str | None = None
    id: str | None = None
    order: int | None = None
    lqaEnabled: bool | None = None


class WorkflowStepReferenceV3(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None
    order: int | None = None
    lqaEnabled: bool | None = None


class WorkflowStepReference2(BaseModel):
    uid: str | None = None
    name: str | None = None
    abbreviation: str | None = None
    order: int | None = None
    lqaEnabled: bool | None = None


class Xlf2SettingsDto(BaseModel):
    icuSubFilter: bool | None = Field(False, description="Default: false")
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    importNotes: bool | None = Field(True, description="Default: true")
    saveConfirmedSegments: bool | None = Field(True, description="Default: true")
    segmentation: bool | None = Field(True, description="Default: true")
    lineBreakTags: bool | None = Field(False, description="Default: false")
    preserveWhitespace: bool | None = Field(True, description="Default: true")
    copySourceToTargetIfNotImported: bool | None = Field(
        True, description="Default: true"
    )
    respectTranslateAttr: bool | None = Field(True, description="Default: true")
    skipImportRules: str | None = None
    importAsConfirmedRules: str | None = Field(None, description="Default: state=final")
    importAsLockedRules: str | None = None
    exportAttrsWhenConfirmedAndLocked: str | None = Field(
        None, description="Default: state=final"
    )
    exportAttrsWhenConfirmedAndNotLocked: str | None = Field(
        None, description="Default: state=final"
    )
    exportAttrsWhenNotConfirmedAndLocked: str | None = None
    exportAttrsWhenNotConfirmedAndNotLocked: str | None = None
    contextKeyXPath: str | None = None
    preserveCharEntities: str | None = None
    xslUrl: str | None = None
    xslFile: str | None = Field(
        None, description="UID of uploaded XSL file, overrides xslUrl"
    )
    tagRegexp: str | None = None
    updateTargetLanguage: bool | None = Field(False, description="Default: false")


class XlfSettingsDto(BaseModel):
    icuSubFilter: bool | None = Field(False, description="Default: false")
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    importNotes: bool | None = Field(True, description="Default: true")
    segmentation: bool | None = Field(True, description="Default: true")
    skipImportRules: str | None = Field(
        None,
        description="Default: translate=no; examples: translate=no;approved=no;state=needs-adaptation",
    )
    importAsConfirmedRules: str | None = Field(
        None, description="Multiple rules must be separated by semicolon"
    )
    importAsLockedRules: str | None = None
    exportAttrsWhenConfirmedAndLocked: str | None = None
    exportAttrsWhenConfirmedAndNotLocked: str | None = None
    exportAttrsWhenNotConfirmedAndLocked: str | None = None
    exportAttrsWhenNotConfirmedAndNotLocked: str | None = None
    saveConfirmedSegments: bool | None = Field(True, description="Default: true")
    lineBreakTags: bool | None = Field(False, description="Default: false")
    preserveWhitespace: bool | None = Field(True, description="Default: true")
    contextType: str | None = None
    preserveCharEntities: str | None = None
    copySourceToTargetIfNotImported: bool | None = Field(
        True, description="Default: true"
    )
    importXPath: str | None = None
    importAsConfirmedXPath: str | None = None
    importAsLockedXPath: str | None = None
    xslUrl: str | None = None
    xslFile: str | None = Field(
        None, description="UID of uploaded XSL file, overrides xslUrl"
    )
    tagRegexp: str | None = None
    updateTargetLanguage: bool | None = Field(False, description="Default: false")


class AnalyseSettingsDtoPreAnalyseTargetOrCompare(AbstractAnalyseSettingsDto):
    transMemoryPostEditing: bool | None = Field(False, description="Default: false")
    nonTranslatablePostEditing: bool | None = Field(False, description="Default: false")
    machineTranslatePostEditing: bool | None = Field(
        False, description="Default: false"
    )
    includeFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    separateFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    includeNonTranslatables: bool | None = Field(False, description="Default: false")
    includeMachineTranslationMatches: bool | None = Field(
        False, description="Default: false"
    )
    skipMtScoreThreshold: float | None = Field(
        None,
        description="Used only for Default analysis. Threshold above which the MT suggestions are not used. Default: value from PreTranslate settings",
    )
    type: Literal["PreAnalyseTarget", "Compare"]


class AnalyseSettingsDtoUnion(
    RootModel[
        AnalyseSettingsDtoPostAnalyse
        | AnalyseSettingsDtoPreAnalyse
        | AnalyseSettingsDtoPreAnalyseTargetOrCompare
    ]
):
    root: (
        AnalyseSettingsDtoPostAnalyse
        | AnalyseSettingsDtoPreAnalyse
        | AnalyseSettingsDtoPreAnalyseTargetOrCompare
    ) = Field(..., discriminator="type", title="AnalyseSettingsDtoUnion")


class ProviderReferenceUnion(
    RootModel[ProviderReferenceUser | ProviderReferenceVendor]
):
    root: ProviderReferenceUser | ProviderReferenceVendor = Field(
        ..., discriminator="type", title="ProviderReferenceUnion"
    )


class DashboardSettingEnum(str, Enum):
    ALL_DATA = "ALL_DATA"
    NO_DASHBOARD = "NO_DASHBOARD"
    OWN_DATA = "OWN_DATA"


class JobStatusEnum(str, Enum):
    ACCEPTED_BY_VENDOR = "ACCEPTED_BY_VENDOR"
    ASSIGNED = "ASSIGNED"
    CANCELLED = "CANCELLED"
    COMPLETED = "COMPLETED"
    COMPLETED_BY_VENDOR = "COMPLETED_BY_VENDOR"
    DECLINED_BY_VENDOR = "DECLINED_BY_VENDOR"
    NEW = "NEW"


class AnalyseReferenceEnum(str, Enum):
    Compare = "Compare"
    ContinuousPostAnalyse = "ContinuousPostAnalyse"
    ContinuousPreAnalyse = "ContinuousPreAnalyse"
    PostAnalyse = "PostAnalyse"
    PreAnalyse = "PreAnalyse"
    PreAnalyseProvider = "PreAnalyseProvider"
    PreAnalyseTarget = "PreAnalyseTarget"


class AsyncActionEnum(str, Enum):
    ADOPT_SEGMENT_DATA = "ADOPT_SEGMENT_DATA"
    ADOPT_SEGMENT_SET_DATA = "ADOPT_SEGMENT_SET_DATA"
    ALIGN = "ALIGN"
    ASYNC_TRANSLATE = "ASYNC_TRANSLATE"
    AUTO_LQA = "AUTO_LQA"
    CLEAR_TM = "CLEAR_TM"
    COMPARE_ANALYSE = "COMPARE_ANALYSE"
    CONTINUOUS_POST_ANALYSE = "CONTINUOUS_POST_ANALYSE"
    CONTINUOUS_PRE_ANALYSE = "CONTINUOUS_PRE_ANALYSE"
    CREATE_PROJECT = "CREATE_PROJECT"
    DELETE_TM = "DELETE_TM"
    EXPORT_COMPLETE_FILE = "EXPORT_COMPLETE_FILE"
    EXPORT_TMX = "EXPORT_TMX"
    EXPORT_TMX_BY_QUERY = "EXPORT_TMX_BY_QUERY"
    EXTRACT_CLEANED_TMS = "EXTRACT_CLEANED_TMS"
    FILE_FLOW_CONVERTER_IMPORT = "FILE_FLOW_CONVERTER_IMPORT"
    FILE_FLOW_MT_PRETRANSLATE = "FILE_FLOW_MT_PRETRANSLATE"
    FILE_FLOW_QUALITY_ESTIMATION = "FILE_FLOW_QUALITY_ESTIMATION"
    GLOSSARY_DELETE = "GLOSSARY_DELETE"
    GLOSSARY_PUT = "GLOSSARY_PUT"
    IMPORT_ANNOTATIONS = "IMPORT_ANNOTATIONS"
    IMPORT_FILE = "IMPORT_FILE"
    IMPORT_JOB = "IMPORT_JOB"
    IMPORT_MXLF_INTO_TM = "IMPORT_MXLF_INTO_TM"
    IMPORT_TBX = "IMPORT_TBX"
    IMPORT_TBX_TB3 = "IMPORT_TBX_TB3"
    IMPORT_TMX = "IMPORT_TMX"
    INSERT_INTO_TM = "INSERT_INTO_TM"
    PARENT_ANALYSE = "PARENT_ANALYSE"
    POST_ANALYSE = "POST_ANALYSE"
    PRE_ANALYSE = "PRE_ANALYSE"
    PRE_TRANSLATE = "PRE_TRANSLATE"
    QA = "QA"
    QA_V3 = "QA_V3"
    UPDATE_CONTINUOUS_JOB = "UPDATE_CONTINUOUS_JOB"
    UPDATE_SOURCE = "UPDATE_SOURCE"
    UPDATE_TARGET = "UPDATE_TARGET"


class CreateAnalyseAsyncV2Enum(str, Enum):
    Compare = "Compare"
    PostAnalyse = "PostAnalyse"
    PreAnalyse = "PreAnalyse"


class CustomFieldTypeEnum(str, Enum):
    DATE = "DATE"
    MULTI_SELECT = "MULTI_SELECT"
    NUMBER = "NUMBER"
    SINGLE_SELECT = "SINGLE_SELECT"
    STRING = "STRING"
    URL = "URL"


class EntityTypeEnum(str, Enum):
    JOB = "JOB"
    PROJECT = "PROJECT"


class AnalyseTypeEnum(str, Enum):
    Compare = "Compare"
    PostAnalyse = "PostAnalyse"
    PreAnalyse = "PreAnalyse"
    PreAnalyseTarget = "PreAnalyseTarget"


class LqaConversationStatusEnum(str, Enum):
    resolved = "resolved"
    unresolved = "unresolved"


class ImportStatusEnum(str, Enum):
    ERROR = "ERROR"
    OK = "OK"
    RUNNING = "RUNNING"


class JobStatusEnum2(str, Enum):
    ACCEPTED = "ACCEPTED"
    CANCELLED = "CANCELLED"
    COMPLETED = "COMPLETED"
    DECLINED = "DECLINED"
    DELIVERED = "DELIVERED"
    EMAILED = "EMAILED"
    NEW = "NEW"
    REJECTED = "REJECTED"


class JobMachineTranslationSettingsV3Enum(str, Enum):
    APPLY_MT_ABOVE_THRESHOLD = "APPLY_MT_ABOVE_THRESHOLD"
    COMPARE_AND_BEST_MATCH = "COMPARE_AND_BEST_MATCH"


class MentionGroupTypeEnum(str, Enum):
    GUESTS = "GUESTS"
    JOB = "JOB"
    OWNERS = "OWNERS"
    PROVIDERS = "PROVIDERS"
    WORKFLOW_STEP = "WORKFLOW_STEP"


class UserRoleRefEnum(str, Enum):
    ADMIN = "ADMIN"
    GUEST = "GUEST"
    LINGUIST = "LINGUIST"
    PORTAL_MEMBER = "PORTAL_MEMBER"
    PROJECT_MANAGER = "PROJECT_MANAGER"
    SUBMITTER = "SUBMITTER"
    SYS_ADMIN = "SYS_ADMIN"
    SYS_ADMIN_READ = "SYS_ADMIN_READ"


class DelimiterTypeEnum(str, Enum):
    COMMA = "COMMA"
    OTHER = "OTHER"
    SEMICOLON = "SEMICOLON"
    TAB = "TAB"


class NonEmptySegmentActionEnum(str, Enum):
    CONFIRM = "CONFIRM"
    CONFIRM_LOCK = "CONFIRM_LOCK"
    LOCK = "LOCK"
    NONE = "NONE"


class PoSegmentMatchStatusEnum(str, Enum):
    FUZZY = "FUZZY"
    NONFUZZY = "NONFUZZY"


class QualityChecksEnum(str, Enum):
    AbsoluteLength = "AbsoluteLength"
    CustomQA = "CustomQA"
    EmptyPairTags = "EmptyPairTags"
    EmptyTagContent = "EmptyTagContent"
    EmptyTranslation = "EmptyTranslation"
    ExtraNumbersV3 = "ExtraNumbersV3"
    ForbiddenString = "ForbiddenString"
    ForbiddenTerm = "ForbiddenTerm"
    Formatting = "Formatting"
    FuzzyInconsistencySourceTarget = "FuzzyInconsistencySourceTarget"
    FuzzyInconsistencyTargetSource = "FuzzyInconsistencyTargetSource"
    InconsistentTagContent = "InconsistentTagContent"
    InconsistentTranslationSourceTarget = "InconsistentTranslationSourceTarget"
    InconsistentTranslationTargetSource = "InconsistentTranslationTargetSource"
    JoinTags = "JoinTags"
    LeadingAndTrailingSpaces = "LeadingAndTrailingSpaces"
    LeadingSpaces = "LeadingSpaces"
    Malformed = "Malformed"
    MissingNonTranslatableAnnotation = "MissingNonTranslatableAnnotation"
    MissingNumbersV3 = "MissingNumbersV3"
    Moravia = "Moravia"
    MultipleSpacesV3 = "MultipleSpacesV3"
    NestedTags = "NestedTags"
    NewerAtLowerLevel = "NewerAtLowerLevel"
    NonConformingTerm = "NonConformingTerm"
    NotConfirmed = "NotConfirmed"
    RelativeLength = "RelativeLength"
    RepeatedWord = "RepeatedWord"
    SourceOrTargetRegexp = "SourceOrTargetRegexp"
    SpellCheck = "SpellCheck"
    TargetSourceIdentical = "TargetSourceIdentical"
    TrailingPunctuation = "TrailingPunctuation"
    TrailingSpaces = "TrailingSpaces"
    TranslationLength = "TranslationLength"
    UnmodifiedFuzzyTranslation = "UnmodifiedFuzzyTranslation"
    UnmodifiedFuzzyTranslationMTNT = "UnmodifiedFuzzyTranslationMTNT"
    UnmodifiedFuzzyTranslationTM = "UnmodifiedFuzzyTranslationTM"
    UnresolvedComment = "UnresolvedComment"
    UnresolvedConversation = "UnresolvedConversation"
    Terminology = "Terminology"
    MissingNumbers = "MissingNumbers"
    RepeatedWords = "RepeatedWords"
    MultipleSpaces = "MultipleSpaces"


class QuoteStatusEnum(str, Enum):
    APPROVED = "APPROVED"
    DECLINED = "DECLINED"
    DRAFT = "DRAFT"
    FOR_APPROVAL = "FOR_APPROVAL"
    NEW = "NEW"


class BillingUnitEnum(str, Enum):
    Character = "Character"
    Hour = "Hour"
    Page = "Page"
    Word = "Word"


class QuoteTypeEnum(str, Enum):
    BUYER = "BUYER"
    PROVIDER = "PROVIDER"


class AssessmentResultEnum(str, Enum):
    FAIL = "FAIL"
    PASS = "PASS"


class TermStatusEnum(str, Enum):
    Approved = "Approved"
    New = "New"


class TermTypeEnum(str, Enum):
    ABBREVIATION = "ABBREVIATION"
    ACRONYM = "ACRONYM"
    FULL_FORM = "FULL_FORM"
    PHRASE = "PHRASE"
    SHORT_FORM = "SHORT_FORM"
    VARIANT = "VARIANT"


class TermPartOfSpeechEnum(str, Enum):
    ADJECTIVE = "ADJECTIVE"
    ADVERB = "ADVERB"
    NOUN = "NOUN"
    VERB = "VERB"


class TermGenderEnum(str, Enum):
    FEMININE = "FEMININE"
    MASCULINE = "MASCULINE"
    NEUTRAL = "NEUTRAL"


class TermNumberEnum(str, Enum):
    PLURAL = "PLURAL"
    SINGULAR = "SINGULAR"
    UNCOUNTABLE = "UNCOUNTABLE"


class CustomFileTypeEnum(str, Enum):
    html = "html"
    json = "json"
    multiling_xml = "multiling_xml"
    txt = "txt"
    xml = "xml"


class WebHookEventEnum(str, Enum):
    ANALYSIS_CREATED = "ANALYSIS_CREATED"
    ASYNC_REQUEST_FINISHED = "ASYNC_REQUEST_FINISHED"
    CONTINUOUS_JOB_UPDATED = "CONTINUOUS_JOB_UPDATED"
    JOB_ASSIGNED = "JOB_ASSIGNED"
    JOB_AUTO_LQA_FINISHED = "JOB_AUTO_LQA_FINISHED"
    JOB_CREATED = "JOB_CREATED"
    JOB_CUSTOM_FIELDS_UPDATED = "JOB_CUSTOM_FIELDS_UPDATED"
    JOB_DELETED = "JOB_DELETED"
    JOB_DUE_DATE_CHANGED = "JOB_DUE_DATE_CHANGED"
    JOB_EXPORTED = "JOB_EXPORTED"
    JOB_METADATA_UPDATED = "JOB_METADATA_UPDATED"
    JOB_STATUS_CHANGED = "JOB_STATUS_CHANGED"
    JOB_TARGET_UPDATED = "JOB_TARGET_UPDATED"
    JOB_UNEXPORTED = "JOB_UNEXPORTED"
    JOB_UNSHARED = "JOB_UNSHARED"
    JOB_UPDATED = "JOB_UPDATED"
    PRE_TRANSLATION_FINISHED = "PRE_TRANSLATION_FINISHED"
    PROJECT_CREATED = "PROJECT_CREATED"
    PROJECT_DELETED = "PROJECT_DELETED"
    PROJECT_DUE_DATE_CHANGED = "PROJECT_DUE_DATE_CHANGED"
    PROJECT_METADATA_UPDATED = "PROJECT_METADATA_UPDATED"
    PROJECT_STATUS_CHANGED = "PROJECT_STATUS_CHANGED"
    PROJECT_TEMPLATE_CREATED = "PROJECT_TEMPLATE_CREATED"
    PROJECT_TEMPLATE_DELETED = "PROJECT_TEMPLATE_DELETED"
    PROJECT_TEMPLATE_UPDATED = "PROJECT_TEMPLATE_UPDATED"
    PROJECT_UNSHARED = "PROJECT_UNSHARED"
    RAW_MT_CONVERTER_IMPORT_FINISHED = "RAW_MT_CONVERTER_IMPORT_FINISHED"
    RAW_MT_PRE_TRANSLATION_FINISHED = "RAW_MT_PRE_TRANSLATION_FINISHED"
    RAW_MT_QUALITY_ESTIMATION_FINISHED = "RAW_MT_QUALITY_ESTIMATION_FINISHED"
    SHARED_PROJECT_ASSIGNED = "SHARED_PROJECT_ASSIGNED"
    TERM_BASE_CONCEPT_CREATED = "TERM_BASE_CONCEPT_CREATED"
    TERM_BASE_CONCEPT_DELETED = "TERM_BASE_CONCEPT_DELETED"
    TERM_BASE_CONCEPT_UPDATED = "TERM_BASE_CONCEPT_UPDATED"
    TERM_BASE_IMPORTED = "TERM_BASE_IMPORTED"
    TERM_BASE_TERM_CREATED = "TERM_BASE_TERM_CREATED"
    TERM_BASE_TERM_DELETED = "TERM_BASE_TERM_DELETED"
    TERM_BASE_TERM_UPDATED = "TERM_BASE_TERM_UPDATED"


class WebHookSecretTokenTypeEnum(str, Enum):
    AUTHORIZATION = "AUTHORIZATION"
    X_MEMSOURCE_TOKEN = "X_MEMSOURCE_TOKEN"


class WebHookStatusEnum(str, Enum):
    DISABLED = "DISABLED"
    ENABLED = "ENABLED"


class QACheckDtoV2NameEnum(str, Enum):
    absoluteTargetLength = "absoluteTargetLength"
    emptyPairTags = "emptyPairTags"
    emptyTagContent = "emptyTagContent"
    emptyTarget = "emptyTarget"
    endPunctuation = "endPunctuation"
    excludeLockedSegments = "excludeLockedSegments"
    extraNumbers = "extraNumbers"
    forbiddenStringsEnabled = "forbiddenStringsEnabled"
    forbiddenTerms = "forbiddenTerms"
    ignoreInAllWorkflowSteps = "ignoreInAllWorkflowSteps"
    ignoreNotApprovedTerms = "ignoreNotApprovedTerms"
    inconsistentFormatting = "inconsistentFormatting"
    inconsistentTagContent = "inconsistentTagContent"
    inconsistentTranslation = "inconsistentTranslation"
    joinMarksInconsistency = "joinMarksInconsistency"
    leadingAndTrailingSpaces = "leadingAndTrailingSpaces"
    malformed = "malformed"
    missingNumber = "missingNumber"
    moravia = "moravia"
    multipleSpaces = "multipleSpaces"
    nestedTags = "nestedTags"
    newerAtLowerLevel = "newerAtLowerLevel"
    nonConformingTerms = "nonConformingTerms"
    regexp = "regexp"
    relativeTargetLength = "relativeTargetLength"
    repeatedWords = "repeatedWords"
    segmentNotConfirmed = "segmentNotConfirmed"
    spellCheck = "spellCheck"
    strictJobStatus = "strictJobStatus"
    targetLength = "targetLength"
    targetLengthPerSegment = "targetLengthPerSegment"
    targetLengthPercent = "targetLengthPercent"
    targetSourceIdentical = "targetSourceIdentical"
    unmodifiedFuzzyTranslation = "unmodifiedFuzzyTranslation"
    unmodifiedFuzzyTranslationMTNT = "unmodifiedFuzzyTranslationMTNT"
    unmodifiedFuzzyTranslationTM = "unmodifiedFuzzyTranslationTM"
    unresolvedComment = "unresolvedComment"


class AvailabilityEnum(str, Enum):
    DISABLED_IN_ALL_WORKFLOW_STEPS = "DISABLED_IN_ALL_WORKFLOW_STEPS"
    DISABLED_IN_CURRENT_WORKFLOW_STEP = "DISABLED_IN_CURRENT_WORKFLOW_STEP"
    ENABLED = "ENABLED"
    NOT_AVAILABLE = "NOT_AVAILABLE"


class OriginEnum(str, Enum):
    AI = "AI"
    HUMAN = "HUMAN"


class AssessmentDetailModeEnum(str, Enum):
    ISSUES = "ISSUES"
    ISSUES_AND_SCORE = "ISSUES_AND_SCORE"


class AssessmentDetailStatusEnum(str, Enum):
    EDITED = "EDITED"
    FINISHED = "FINISHED"
    FINISHED_WITH_EDITING = "FINISHED_WITH_EDITING"
    NOT_STARTED = "NOT_STARTED"
    STARTED = "STARTED"


class ActionEnum(str, Enum):
    APC_DOWNLOAD = "APC_DOWNLOAD"
    APC_UPLOAD = "APC_UPLOAD"
    API_DOWNLOAD = "API_DOWNLOAD"
    API_UPLOAD = "API_UPLOAD"
    CJ_DOWNLOAD = "CJ_DOWNLOAD"
    CJ_UPLOAD = "CJ_UPLOAD"
    GUI_DOWNLOAD = "GUI_DOWNLOAD"
    GUI_REIMPORT = "GUI_REIMPORT"
    GUI_REIMPORT_TARGET = "GUI_REIMPORT_TARGET"
    GUI_UPLOAD = "GUI_UPLOAD"
    SUBMITTER_PORTAL_DOWNLOAD = "SUBMITTER_PORTAL_DOWNLOAD"


class AttributeTypeEnum(str, Enum):
    BINARY = "BINARY"
    BOOLEAN = "BOOLEAN"
    COMPLEX = "COMPLEX"
    DATE_TIME = "DATE_TIME"
    DECIMAL = "DECIMAL"
    INTEGER = "INTEGER"
    REFERENCE = "REFERENCE"
    STRING = "STRING"


class MutabilityEnum(str, Enum):
    IMMUTABLE = "IMMUTABLE"
    READ_ONLY = "READ_ONLY"
    READ_WRITE = "READ_WRITE"
    WRITE_ONLY = "WRITE_ONLY"


class ReturnedEnum(str, Enum):
    ALWAYS = "ALWAYS"
    DEFAULT = "DEFAULT"
    NEVER = "NEVER"
    REQUEST = "REQUEST"


class UniquenessEnum(str, Enum):
    GLOBAL = "GLOBAL"
    NONE = "NONE"
    SERVER = "SERVER"


class OutputFormatEnum(str, Enum):
    TSV = "TSV"
    TXT = "TXT"


class StateEnum(str, Enum):
    Diff = "Diff"
    Miss = "Miss"


class ConnectorAsyncTaskStateStatusEnum(str, Enum):
    CONVERTER_ERROR = "CONVERTER_ERROR"
    ERROR = "ERROR"
    NEW = "NEW"
    SUCCESS = "SUCCESS"


class TaskTypeEnum(str, Enum):
    DOWNLOAD = "DOWNLOAD"
    REIMPORT = "REIMPORT"
    REIMPORT_TARGET = "REIMPORT_TARGET"
    UPLOAD = "UPLOAD"


class TaskProcessingTypeEnum(str, Enum):
    APC = "APC"
    API = "API"
    CJ = "CJ"
    GUI = "GUI"
    SUBMITTER_PORTAL = "SUBMITTER_PORTAL"


class ConnectorTypeEnum(str, Enum):
    AEM_PLUGIN = "AEM_PLUGIN"
    AMAZON_S3 = "AMAZON_S3"
    AZURE = "AZURE"
    BITBUCKET = "BITBUCKET"
    BITBUCKETSERVER = "BITBUCKETSERVER"
    BLUEPRINT = "BLUEPRINT"
    BOX = "BOX"
    BRAZE = "BRAZE"
    CONFLUENCE = "CONFLUENCE"
    CONTENTFUL = "CONTENTFUL"
    CONTENTFUL2 = "CONTENTFUL2"
    CONTENTFULENTRYLEVEL = "CONTENTFULENTRYLEVEL"
    CONTENTSTACK = "CONTENTSTACK"
    DROPBOX = "DROPBOX"
    DRUPAL = "DRUPAL"
    DRUPAL_PLUGIN = "DRUPAL_PLUGIN"
    FTP = "FTP"
    GIT = "GIT"
    GITHUB = "GITHUB"
    GITLAB = "GITLAB"
    GOOGLE = "GOOGLE"
    HELPSCOUT = "HELPSCOUT"
    HUBSPOT = "HUBSPOT"
    JOOMLA = "JOOMLA"
    KENTICO = "KENTICO"
    KENTICO_KONTENT = "KENTICO_KONTENT"
    MAGENTO = "MAGENTO"
    MARKETO = "MARKETO"
    ONEDRIVE = "ONEDRIVE"
    OPTIMIZELY = "OPTIMIZELY"
    PARDOT = "PARDOT"
    PHRASE = "PHRASE"
    SALESFORCE = "SALESFORCE"
    SFTP = "SFTP"
    SHAREPOINT = "SHAREPOINT"
    SITECORE = "SITECORE"
    TRIDION = "TRIDION"
    TYPO3 = "TYPO3"
    VERBIS = "VERBIS"
    WORDPRESS = "WORDPRESS"
    ZENDESK = "ZENDESK"


class FileFormatEnum(str, Enum):
    android_string = "android_string"
    auto_detect = "auto-detect"
    chrome_json = "chrome_json"
    csv = "csv"
    desktop_entry = "desktop_entry"
    dita = "dita"
    doc = "doc"
    docbook = "docbook"
    dtd = "dtd"
    epub = "epub"
    html = "html"
    icml = "icml"
    idml = "idml"
    joomla_ini = "joomla_ini"
    json = "json"
    mac_strings = "mac_strings"
    magento_csv = "magento_csv"
    md = "md"
    mif = "mif"
    mozilla_properties = "mozilla_properties"
    mqxliff = "mqxliff"
    multiling_xls = "multiling_xls"
    multiling_xml = "multiling_xml"
    pdf = "pdf"
    php = "php"
    plain_text = "plain_text"
    plist = "plist"
    po = "po"
    ppt = "ppt"
    properties = "properties"
    psd = "psd"
    resjson = "resjson"
    resx = "resx"
    sbv = "sbv"
    sdlxlif = "sdlxlif"
    srt = "srt"
    sub = "sub"
    svg = "svg"
    tag = "tag"
    tmx = "tmx"
    ts = "ts"
    ttx = "ttx"
    vtt = "vtt"
    wiki = "wiki"
    windows_rc = "windows_rc"
    wpxliff = "wpxliff"
    xlf = "xlf"
    xlf2 = "xlf2"
    xls = "xls"
    xml = "xml"
    xml_properties = "xml_properties"
    yaml = "yaml"


class LevelEnum(str, Enum):
    PRO = "PRO"
    STANDARD = "STANDARD"


class DueInEnum(str, Enum):
    IN_24_HOURS = "IN_24_HOURS"
    IN_3_DAYS = "IN_3_DAYS"
    IN_4_HOURS = "IN_4_HOURS"
    IN_8_HOURS = "IN_8_HOURS"
    OVERDUE = "OVERDUE"


class JobRoleTypeEnum(str, Enum):
    GUEST = "GUEST"
    JOB_OWNER = "JOB_OWNER"
    PROJECT_OWNER = "PROJECT_OWNER"
    PROVIDER = "PROVIDER"


class OrganizationTypeEnum(str, Enum):
    BUYER = "BUYER"
    VENDOR = "VENDOR"


class RepeatedEnum(str, Enum):
    NOT_REPEATED = "NOT_REPEATED"
    REPEATED = "REPEATED"


class LqaReportRecipientTypeEnum(str, Enum):
    ORGANIZATION = "ORGANIZATION"
    USER = "USER"


class FlavorEnum(str, Enum):
    GITHUB = "GITHUB"
    PHP = "PHP"
    PLAIN = "PLAIN"


class MentionTypeEnum(str, Enum):
    GROUP = "GROUP"
    USER = "USER"


class MetadataFieldTypeEnum(str, Enum):
    CLIENT = "CLIENT"
    DOMAIN = "DOMAIN"
    FILENAME = "FILENAME"
    SUBDOMAIN = "SUBDOMAIN"


class DirectionEnum(str, Enum):
    ASC = "ASC"
    DESC = "DESC"


class OrganizationEmailTemplateTypeEnum(str, Enum):
    AutomatedProjectCreated = "AutomatedProjectCreated"
    AutomatedProjectSourceUpdated = "AutomatedProjectSourceUpdated"
    AutomatedProjectStatusChanged = "AutomatedProjectStatusChanged"
    CmsJobRejected = "CmsJobRejected"
    CmsQuoteReady = "CmsQuoteReady"
    CmsWorkCompleted = "CmsWorkCompleted"
    JobAssigned = "JobAssigned"
    JobRejected = "JobRejected"
    JobStatusChanged = "JobStatusChanged"
    JobWidgetProjectCompleted = "JobWidgetProjectCompleted"
    JobWidgetProjectCreated = "JobWidgetProjectCreated"
    JobWidgetProjectQuotePreparationFailure = "JobWidgetProjectQuotePreparationFailure"
    JobWidgetProjectQuotePrepared = "JobWidgetProjectQuotePrepared"
    LQA_SHARE_REPORT = "LQA_SHARE_REPORT"
    LoginInfo = "LoginInfo"
    NextWorkflowStep = "NextWorkflowStep"
    ProjectTransferredToBuyer = "ProjectTransferredToBuyer"
    QUOTE_STATUS_CHANGED = "QUOTE_STATUS_CHANGED"
    QUOTE_UPDATED = "QUOTE_UPDATED"
    SharedProjectAssigned = "SharedProjectAssigned"
    SharedProjectStatusChanged = "SharedProjectStatusChanged"


class FilterEnum(str, Enum):
    DEFAULT = "DEFAULT"
    TRANS_PDF = "TRANS_PDF"


class ContextKeySuffixTypeEnum(str, Enum):
    MSGCTXT = "MSGCTXT"
    MSGCTXT_AND_MSGID = "MSGCTXT_AND_MSGID"
    MSGCTXT_OR_MSGID = "MSGCTXT_OR_MSGID"
    MSGID = "MSGID"


class SegmentFiltersEnum(str, Enum):
    LOCKED = "LOCKED"
    NOT_LOCKED = "NOT_LOCKED"


class PreviewUrlTypeEnum(str, Enum):
    ORIGINAL = "ORIGINAL"
    PDF = "PDF"


class ContextTypeEnum(str, Enum):
    AUTO = "AUTO"
    NO_CONTEXT = "NO_CONTEXT"
    PREV_AND_NEXT_SEGMENT = "PREV_AND_NEXT_SEGMENT"
    SEGMENT_KEY = "SEGMENT_KEY"


class CellFlowEnum(str, Enum):
    DownLeft = "DownLeft"
    DownRight = "DownRight"
    LeftDown = "LeftDown"
    RightDown = "RightDown"


class RulesFormatEnum(str, Enum):
    PLAIN = "PLAIN"
    XPATH = "XPATH"


class LocaleFormatEnum(str, Enum):
    ANDROID_QUALIFIER = "ANDROID_QUALIFIER"
    ANDROID_QUALIFIER_BCP = "ANDROID_QUALIFIER_BCP"
    MEMSOURCE = "MEMSOURCE"
    RFC_5646 = "RFC_5646"


class UserCreateDtoAdmin(AbstractUserCreateDto):
    role: Literal["ADMIN"] = "ADMIN"


class UserEditDtoAdmin(AbstractUserEditDto):
    role: Literal["ADMIN"] = "ADMIN"


class SegmentWarningDtoAbsoluteTranslationLength(SegmentWarningDto):
    limit: str | None = None
    type: Literal["AbsoluteTranslationLength"] = "AbsoluteTranslationLength"


class AccuracyWeightsDto(BaseModel):
    accuracy: ToggleableWeightDto | None = None
    addition: ToggleableWeightDto | None = None
    omission: ToggleableWeightDto | None = None
    mistranslation: ToggleableWeightDto | None = None
    underTranslation: ToggleableWeightDto | None = None
    untranslated: ToggleableWeightDto | None = None
    improperTmMatch: ToggleableWeightDto | None = None
    overTranslation: ToggleableWeightDto | None = None


class AddWorkflowStepsDto(BaseModel):
    workflowSteps: List[IdReference] | None = Field(
        None, max_length=2147483647, min_length=1
    )


class AnalyseRecalculateRequestDto(BaseModel):
    analyses: List[IdReference] = Field(..., max_length=100, min_length=1)
    callbackUrl: str | None = None


class AnalyseSettingsDto(BaseModel):
    type: AnalyseTypeEnum | None = None
    includeFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    separateFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    includeNonTranslatables: bool | None = Field(False, description="Default: false")
    includeMachineTranslationMatches: bool | None = Field(
        False, description="Default: false"
    )
    includeConfirmedSegments: bool | None = Field(False, description="Default: false")
    includeNotConfirmedSegments: bool | None = Field(
        False, description="Default: false"
    )
    includeNumbers: bool | None = Field(False, description="Default: false")
    includeLockedSegments: bool | None = Field(False, description="Default: false")
    countSourceUnits: bool | None = Field(False, description="Default: false")
    includeTransMemory: bool | None = Field(False, description="Default: false")
    namingPattern: str | None = None
    analyzeByLanguage: bool | None = Field(False, description="Default: false")
    analyzeByProvider: bool | None = Field(False, description="Default: false")
    allowAutomaticPostAnalysis: bool | None = Field(
        False,
        description="If automatic post analysis should be created after update source. Default: false",
    )
    transMemoryPostEditing: bool | None = Field(False, description="Default: false")
    nonTranslatablePostEditing: bool | None = Field(False, description="Default: false")
    machineTranslatePostEditing: bool | None = Field(
        False, description="Default: false"
    )
    skipMtScoreThreshold: float | None = Field(
        None,
        description="Used only for Default analysis. Threshold above which the MT suggestions are not used. Default: value from PreTranslate settings",
    )


class AssessmentRequestDto(BaseModel):
    jobParts: List[UidReference] = Field(
        ...,
        description="UIDs of the corresponding job parts",
        max_length=100,
        min_length=1,
    )


class AssessmentResultDto(BaseModel):
    jobPart: UidReference | None = None
    status: AssessmentResultEnum | None = None
    score: float | None = Field(None, description="LQA score in percentage")
    issueCounts: IssueCountsDto | None = None


class AssessmentResultsDto(BaseModel):
    results: List[AssessmentResultDto]


class AssignVendorDto(BaseModel):
    vendor: IdReference | None = None
    dateDue: AwareDatetime | None = None


class AssignmentPerTargetLangDto(BaseModel):
    targetLang: str | None = None
    providers: List[ProviderReference] | None = None


class AsyncExportTMByQueryDto(BaseModel):
    asyncRequest: ObjectReference | None = None
    transMemory: ObjectReference | None = None
    exportTargetLangs: List[str] | None = None
    queries: List[Query] | None = None


class AsyncExportTMDto(BaseModel):
    transMemory: ObjectReference | None = None
    exportTargetLangs: List[str] | None = None


class AsyncRequestReference(BaseModel):
    id: str | None = None
    dateCreated: AwareDatetime | None = None
    action: AsyncActionEnum | None = None


class AsyncRequestStatusDto(BaseModel):
    concurrentRequests: ConcurrentRequestsDto | None = None


class AsyncResponseDto(BaseModel):
    dateCreated: AwareDatetime | None = None
    errorCode: str | None = None
    errorDesc: str | None = None
    errorDetails: List[ErrorDetailDto] | None = None
    warnings: List[ErrorDetailDto] | None = None
    acceptedSegmentsCount: int | None = None


class AsyncResponseV2Dto(BaseModel):
    dateCreated: AwareDatetime | None = None
    errorCode: str | None = None
    errorDesc: str | None = None
    errorDetails: List[ErrorDetailDtoV2] | None = None
    warnings: List[ErrorDetailDtoV2] | None = None


class Attribute(BaseModel):
    name: str | None = None
    type: AttributeTypeEnum | None = None
    subAttributes: List[Attribute] | None = None
    multiValued: bool | None = None
    description: str | None = None
    required: bool | None = None
    caseExact: bool | None = None
    mutability: MutabilityEnum | None = None
    returned: ReturnedEnum | None = None
    uniqueness: UniquenessEnum | None = None


class AutomatedProjectSettingsDto(BaseModel):
    id: str | None = None
    name: str | None = None
    organization: NameDto | None = None
    active: bool | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    connector: NameDto | None = None
    remoteFolder: str | None = None


class BulkDeleteAnalyseDto(BaseModel):
    analyses: List[IdReference] = Field(..., max_length=100, min_length=1)
    purge: bool | None = Field(False, description="Default: false")


class BulkDeleteTmDto(BaseModel):
    tms: List[UidReference] = Field(..., max_length=100, min_length=1)
    purge: bool | None = Field(False, description="Default: false")


class BulkEditAnalyseV2Dto(BaseModel):
    analyses: List[IdReference] = Field(..., max_length=100, min_length=1)
    name: constr(min_length=0, max_length=255) | None = None
    provider: ProviderReference | None = None
    netRateScheme: UidReference | None = None


class BuyerEditDto(BaseModel):
    defaultProjectOwner: IdReference | None = None


class CheckResponse(BaseModel):
    text: str | None = None
    misspelledWords: List[MisspelledWord] | None = None


class CleanedTransMemoriesDto(BaseModel):
    uids: List[str]
    outputFormat: OutputFormatEnum | None = None
    preserveRatio: confloat(le=1.0, gt=0.0) | None = None
    targetLangs: List[str] | None = None


class ClientEditDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    externalId: constr(min_length=0, max_length=255) | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    displayNoteInProject: bool | None = Field(False, description="Default: false")
    priceList: IdReference | None = None
    netRateScheme: IdReference | None = None


class ComparedSegmentDto(BaseModel):
    uid: str | None = None
    state: StateEnum | None = None


class ComparedSegmentsDto(BaseModel):
    segments: List[ComparedSegmentDto] | None = None


class ConceptDtov2(BaseModel):
    id: str | None = None
    definition: str | None = None
    domain: str | None = None
    subDomains: List[str] | None = None
    url: str | None = None
    note: str | None = None
    customFields: List[CustomFieldValueDto] | None = None


class ConceptEditDto(BaseModel):
    domain: UidReference | None = None
    subdomains: List[UidReference] | None = None
    definition: str | None = None
    url: str | None = None
    conceptNote: str | None = None
    customFields: List[CustomFieldValueDto] | None = None


class ConceptListReference(BaseModel):
    concepts: List[IdReference] = Field(..., max_length=100, min_length=1)


class ConceptWithMetadataDto(BaseModel):
    id: str | None = None
    domain: DomainReference | None = None
    subdomains: List[SubDomainReference] | None = None
    url: str | None = None
    definition: str | None = None
    conceptNote: str | None = None
    customFields: List[CustomFieldValueDto] | None = None


class ConnectorAsyncTaskStateDto(BaseModel):
    id: str | None = None
    jobUid: str | None = None
    status: ConnectorAsyncTaskStateStatusEnum | None = None
    taskType: TaskTypeEnum | None = None
    taskProcessingType: TaskProcessingTypeEnum | None = None
    jobFileName: str | None = None
    targetLang: str | None = None
    dateCreated: AwareDatetime | None = None
    dateProcessed: AwareDatetime | None = None
    errorMessage: str | None = None


class ConnectorDto(BaseModel):
    id: str | None = None
    name: str | None = None
    type: ConnectorTypeEnum | None = None
    organization: NameDto | None = None
    createdBy: NameDto | None = None
    createdAt: AwareDatetime | None = None
    localToken: str | None = None
    automatedProjectSettings: List[AutomatedProjectSettingsDto] | None = None


class ConnectorListDto(BaseModel):
    connectors: List[ConnectorDto] | None = None
    totalCount: int | None = None


class CreateAnalyseListAsyncDto(BaseModel):
    jobs: List[UidReference] = Field(
        ...,
        description="Job uids of jobs from the same project",
        max_length=100,
        min_length=1,
    )
    type: CreateAnalyseAsyncV2Enum | None = None
    includeFuzzyRepetitions: bool | None = Field(True, description="Default: true")
    separateFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    includeConfirmedSegments: bool | None = Field(True, description="Default: true")
    includeNumbers: bool | None = Field(True, description="Default: true")
    includeLockedSegments: bool | None = Field(True, description="Default: true")
    countSourceUnits: bool | None = Field(True, description="Default: true")
    includeTransMemory: bool | None = Field(
        True, description="Default: true. Works only for type=PreAnalyse."
    )
    includeNonTranslatables: bool | None = Field(
        False, description="Default: false. Works only for type=PreAnalyse."
    )
    includeMachineTranslationMatches: bool | None = Field(
        False, description="Default: false. Works only for type=PreAnalyse."
    )
    transMemoryPostEditing: bool | None = Field(
        False, description="Default: false. Works only for type=PostAnalyse."
    )
    nonTranslatablePostEditing: bool | None = Field(
        False, description="Default: false. Works only for type=PostAnalyse."
    )
    machineTranslatePostEditing: bool | None = Field(
        False, description="Default: false. Works only for type=PostAnalyse."
    )
    name: constr(min_length=0, max_length=255) | None = None
    netRateScheme: IdReference | None = None
    compareWorkflowLevel: conint(ge=1, le=15) | None = Field(
        None, description="Required for type=Compare"
    )
    useProjectAnalysisSettings: bool | None = Field(
        False,
        description="Default: false. Use default project settings. Will be overwritten with setting sent\n        in the API call.",
    )
    skipMtScoreThreshold: float | None = Field(
        None,
        description="Used only for Default analysis. Threshold above which the MT suggestions are not used. Default: value from PreTranslate settings",
    )
    callbackUrl: str | None = None


class CreateCustomFieldDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    allowedEntities: List[EntityTypeEnum]
    options: List[str] | None = None
    type: CustomFieldTypeEnum | None = None
    required: bool | None = None
    description: constr(min_length=0, max_length=500) | None = None


class CreateCustomFieldInstanceDto(BaseModel):
    customField: UidReference
    selectedOptions: List[UidReference] | None = None
    value: constr(min_length=0, max_length=4096) | None = None


class CreateCustomFieldInstancesDto(BaseModel):
    customFieldInstances: List[CreateCustomFieldInstanceDto] | None = None


class CreateEditDiscountSchemeDto(BaseModel):
    name: constr(min_length=1, max_length=255)
    rates: DiscountSettingsDto | None = None
    defaultScheme: bool | None = None
    workflowStepNetSchemes: List[NetRateSchemeWorkflowStepCreate] | None = None


class CreateProjectFromTemplateAsyncV2Dto(BaseModel):
    name: constr(min_length=0, max_length=255)
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    workflowSteps: List[IdReference] | None = None
    dateDue: AwareDatetime | None = None
    note: str | None = None
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    costCenter: IdReference | None = None
    callbackUrl: str | None = None


class CreateProjectFromTemplateV2Dto(BaseModel):
    name: constr(min_length=0, max_length=255)
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    workflowSteps: List[IdReference] | None = None
    dateDue: AwareDatetime | None = None
    note: str | None = None
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    costCenter: IdReference | None = None


class CreateProjectTemplateReferenceFilesRequest(BaseModel):
    file: List[MultipartFile] | None = Field(
        None, description="Files with appropriate `Content-Type` header"
    )
    json_: CreateProjectTemplateReferenceFileNoteDto | None = Field(None, alias="json")


class CreateReferenceFilesRequest(BaseModel):
    file: List[MultipartFile] | None = Field(
        None, description="Files with appropriate `Content-Type` header"
    )
    json_: CreateReferenceFileNoteDto | None = Field(None, alias="json")


class CreateVendorDto(BaseModel):
    vendorToken: str
    netRateScheme: UidReference | None = None
    priceList: UidReference | None = None
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    clients: List[UidReference] | None = None
    domains: List[UidReference] | None = None
    subDomains: List[UidReference] | None = None
    workflowSteps: List[UidReference] | None = None


class CreateWebEditorLinkDtoV2(BaseModel):
    jobs: List[UidReference] = Field(
        ...,
        description="Maximum supported number of jobs is 260",
        max_length=2147483647,
        min_length=1,
    )


class CreateWebHookDto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None
    url: str
    events: List[WebHookEventEnum]
    secretToken: constr(min_length=0, max_length=255) | None = None
    secretTokenType: WebHookSecretTokenTypeEnum | None = None
    hidden: bool | None = Field(None, description="Default: `false`")
    status: WebHookStatusEnum | None = None


class CsvSettingsDto(BaseModel):
    delimiter: str | None = Field(None, description="Default: ,")
    delimiterType: DelimiterTypeEnum | None = None
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    importColumns: str | None = None
    contextNoteColumns: str | None = None
    contextKeyColumn: str | None = None
    maxLenColumn: str | None = None
    importRows: str | None = None


class CustomFieldInstanceApiDto(BaseModel):
    customField: UidReference | None = None
    selectedOptions: List[UidReference] | None = None
    value: constr(min_length=0, max_length=4096) | None = None


class CustomFieldInstanceApiV3Dto(BaseModel):
    customField: UidReference | None = None
    selectedOptions: List[UidReference] | None = None
    value: constr(min_length=0, max_length=4096) | None = None


class SegmentWarningDtoCustomQA(SegmentWarningDto):
    message: str | None = None
    subType: str | None = None
    srcPosition: Position | None = None
    tgtPosition: Position | None = None
    type: Literal["CustomQA"] = "CustomQA"


class DataDto(BaseModel):
    available: bool | None = None
    all: CountsDto2 | None = None
    repetitions: CountsDto2 | None = None
    transMemoryMatches: MatchCounts101Dto2 | None = None
    machineTranslationMatches: MatchCountsDto2 | None = None
    nonTranslatablesMatches: MatchCountsNTDto | None = None


class DataDtoV1(BaseModel):
    available: bool | None = None
    all: CountsDto | None = None
    repetitions: CountsDto | None = None
    transMemoryMatches: MatchCounts101Dto | None = None
    machineTranslationMatches: MatchCountsDto | None = None
    nonTranslatablesMatches: MatchCountsNTDtoV1 | None = None
    internalFuzzyMatches: MatchCountsDto | None = None


class DataDto2(BaseModel):
    available: bool | None = None
    estimate: bool | None = None
    all: CountsDto3 | None = None
    repetitions: CountsDto3 | None = None
    transMemoryMatches: MatchCounts101Dto3 | None = None
    machineTranslationMatches: MatchCountsDto3 | None = None
    nonTranslatablesMatches: MatchCountsNTDto2 | None = None
    internalFuzzyMatches: MatchCountsDto3 | None = None


class DeleteCustomFileTypeDto(BaseModel):
    customFileTypes: List[UidReference]


class DeleteServicesDto(BaseModel):
    services: List[UidReference]


class DeleteVendorsDto(BaseModel):
    vendors: List[UidReference]


class DesignWeightsDto(BaseModel):
    design: ToggleableWeightDto | None = None
    length: ToggleableWeightDto | None = None
    localFormatting: ToggleableWeightDto | None = None
    markup: ToggleableWeightDto | None = None
    missingText: ToggleableWeightDto | None = None
    truncation: ToggleableWeightDto | None = None


class DiscountSchemeCreateDto(BaseModel):
    name: constr(min_length=1, max_length=255)
    rates: DiscountSettingsDto | None = None
    defaultScheme: bool | None = None
    workflowStepNetSchemes: List[NetRateSchemeWorkflowStepCreate] | None = None


class EditAnalyseSettingsDto(BaseModel):
    type: AnalyseTypeEnum | None = None
    includeFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    separateFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    includeNonTranslatables: bool | None = Field(False, description="Default: false")
    includeMachineTranslationMatches: bool | None = Field(
        False, description="Default: false"
    )
    includeConfirmedSegments: bool | None = Field(False, description="Default: false")
    includeNotConfirmedSegments: bool | None = Field(
        False, description="Default: false"
    )
    includeNumbers: bool | None = Field(False, description="Default: false")
    includeLockedSegments: bool | None = Field(False, description="Default: false")
    transMemoryPostEditing: bool | None = Field(False, description="Default: false")
    nonTranslatablePostEditing: bool | None = Field(False, description="Default: false")
    machineTranslatePostEditing: bool | None = Field(
        False, description="Default: false"
    )
    countSourceUnits: bool | None = Field(False, description="Default: false")
    includeTransMemory: bool | None = Field(False, description="Default: false")
    namingPattern: constr(min_length=0, max_length=255) | None = None
    analyzeByLanguage: bool | None = Field(
        False, description="Mutually exclusive with analyzeByProvider. Default: false"
    )
    analyzeByProvider: bool | None = Field(
        True, description="Mutually exclusive with analyzeByLanguage. Default: true"
    )
    allowAutomaticPostAnalysis: bool | None = Field(False, description="Default: false")
    skipMtScoreThreshold: float | None = Field(
        None,
        description="Used only for Default analysis. Threshold above which the MT suggestions are not used. Default: value from PreTranslate settings",
    )


class EditAnalyseV2Dto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None
    provider: ProviderReference | None = None
    netRateScheme: UidReference | None = None


class EditPlainConversationDto(BaseModel):
    status: LqaConversationStatusEnum | None = None
    correlation: ReferenceCorrelation | None = None


class EditProjectMTSettPerLangDto(BaseModel):
    targetLang: str
    machineTranslateSettings: IdReference | None = None


class EditProjectMTSettPerLangListDto(BaseModel):
    mtSettingsPerLangList: List[EditProjectMTSettPerLangDto] | None = None


class EditProjectMTSettingsDto(BaseModel):
    machineTranslateSettings: IdReference | None = None


class EditProjectSecuritySettingsDtoV2(BaseModel):
    downloadEnabled: bool | None = Field(None, description="Default: `false`")
    webEditorEnabledForLinguists: bool | None = Field(
        None, description="Default: `false`"
    )
    showUserDataToLinguists: bool | None = Field(None, description="Default: `false`")
    emailNotifications: bool | None = Field(None, description="Default: `false`")
    strictWorkflowFinish: bool | None = Field(None, description="Default: `false`")
    useVendors: bool | None = Field(None, description="Default: `false`")
    linguistsMayEditLockedSegments: bool | None = Field(
        None, description="Default: `false`"
    )
    usersMaySetAutoPropagation: bool | None = Field(None, description="Default: `true`")
    allowLoadingExternalContentInEditors: bool | None = Field(
        None, description="Default: `true`"
    )
    allowLoadingIframes: bool | None = Field(None, description="Default: `false`")
    linguistsMayEditSource: bool | None = Field(None, description="Default: `true`")
    linguistsMayEditTagContent: bool | None = Field(None, description="Default: `true`")
    linguistsMayDownloadLqaReport: bool | None = Field(
        None, description="Default: `true`"
    )
    usernamesDisplayedInLqaReport: bool | None = Field(
        None, description="Default: `true`"
    )
    userMaySetInstantQA: bool | None = Field(None, description="Default: `true`")
    triggerWebhooks: bool | None = Field(None, description="Default: `true`")
    notifyJobOwnerStatusChanged: bool | None = Field(
        None, description="Default: `false`"
    )
    vendors: VendorSecuritySettingsDto | None = None
    allowedDomains: List[str] | None = None


class EmailQuotesRequestDto(BaseModel):
    quotes: List[UidReference]
    subject: str
    body: str
    cc: str | None = None
    bcc: str | None = None


class SegmentWarningDtoEmptyPairTags(SegmentWarningDto):
    type: Literal["EmptyPairTags"] = "EmptyPairTags"


class SegmentWarningDtoEmptyTagContent(SegmentWarningDto):
    type: Literal["EmptyTagContent"] = "EmptyTagContent"


class SegmentWarningDtoEmptyTranslation(SegmentWarningDto):
    type: Literal["EmptyTranslation"] = "EmptyTranslation"


class EnabledQualityChecksDto(BaseModel):
    enabledChecks: List[QualityChecksEnum] | None = None


class ExportByQueryDto(BaseModel):
    exportTargetLangs: List[str]
    queries: List[str]
    queryLangs: List[str]
    createdAtMin: AwareDatetime | None = None
    createdAtMax: AwareDatetime | None = None
    modifiedAtMin: AwareDatetime | None = None
    modifiedAtMax: AwareDatetime | None = None
    createdBy: IdReference | None = None
    modifiedBy: IdReference | None = None
    filename: str | None = None
    project: UidReference | None = None
    callbackUrl: str | None = None


class SegmentWarningDtoExtraNumbersV3(SegmentWarningDto):
    number: str | None = None
    positions: List[Position] | None = None
    type: Literal["ExtraNumbersV3"] = "ExtraNumbersV3"


class SegmentWarningDtoExtraNumbers(SegmentWarningDto):
    extraNumbers: List[str] | None = None
    type: Literal["ExtraNumbers"] = "ExtraNumbers"


class FindConversationsDto(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)
    since: str | None = None
    includeDeleted: bool | None = Field(False, description="Default: false")


class FluencyWeightsDto(BaseModel):
    fluency: ToggleableWeightDto | None = None
    punctuation: ToggleableWeightDto | None = None
    spelling: ToggleableWeightDto | None = None
    grammar: ToggleableWeightDto | None = None
    grammaticalRegister: ToggleableWeightDto | None = None
    inconsistency: ToggleableWeightDto | None = None
    crossReference: ToggleableWeightDto | None = None
    characterEncoding: ToggleableWeightDto | None = None


class SegmentWarningDtoForbiddenString(SegmentWarningDto):
    forbiddenString: str | None = None
    positions: List[Position] | None = None
    type: Literal["ForbiddenString"] = "ForbiddenString"


class SegmentWarningDtoForbiddenTerm(SegmentWarningDto):
    term: str | None = None
    positions: List[Position] | None = None
    sourceTerms: List[Term] | None = None
    type: Literal["ForbiddenTerm"] = "ForbiddenTerm"


class SegmentWarningDtoFormatting(SegmentWarningDto):
    type: Literal["Formatting"] = "Formatting"


class SegmentWarningDtoFuzzyInconsistency(SegmentWarningDto):
    segmentIds: List[str] | None = None
    type: Literal["FuzzyInconsistency"] = "FuzzyInconsistency"


class UserCreateDtoGuest(AbstractUserCreateDto):
    client: UidReference
    enableMT: bool | None = Field(True, description="Enable MT. Default: true")
    projectViewOther: bool | None = Field(
        True, description="View projects created by other users. Default: true"
    )
    projectViewOtherLinguist: bool | None = Field(
        True, description="Show provider names. Default: true"
    )
    projectViewOtherEditor: bool | None = Field(
        True, description="Edit jobs in Phrase CAT editor. Default: true"
    )
    transMemoryViewOther: bool | None = Field(
        True, description="View TMs created by other users. Default: true"
    )
    transMemoryEditOther: bool | None = Field(
        True, description="Modify TMs created by other users. Default: true"
    )
    transMemoryExportOther: bool | None = Field(
        True, description="Export TMs created by other users. Default: true"
    )
    transMemoryImportOther: bool | None = Field(
        True, description="Import into TMs created by other users. Default: true"
    )
    termBaseViewOther: bool | None = Field(
        True, description="View TBs created by other users. Default: true"
    )
    termBaseEditOther: bool | None = Field(
        True, description="Modify TBs created by other users. Default: true"
    )
    termBaseExportOther: bool | None = Field(
        True, description="Export TBs created by other users. Default: true"
    )
    termBaseImportOther: bool | None = Field(
        True, description="Import into TBs created by other users. Default: true"
    )
    termBaseApproveOther: bool | None = Field(
        True, description="Approve terms in TBs created by other users. Default: true"
    )
    role: Literal["GUEST"] = "GUEST"


class UserEditDtoGuest(AbstractUserEditDto):
    client: UidReference
    enableMT: bool | None = Field(True, description="Enable MT. Default: true")
    projectViewOther: bool | None = Field(
        True, description="View projects created by other users. Default: true"
    )
    projectViewOtherLinguist: bool | None = Field(
        True, description="Show provider names. Default: true"
    )
    projectViewOtherEditor: bool | None = Field(
        True, description="Edit jobs in Phrase CAT editor. Default: true"
    )
    transMemoryViewOther: bool | None = Field(
        True, description="View TMs created by other users. Default: true"
    )
    transMemoryEditOther: bool | None = Field(
        True, description="Modify TMs created by other users. Default: true"
    )
    transMemoryExportOther: bool | None = Field(
        True, description="Export TMs created by other users. Default: true"
    )
    transMemoryImportOther: bool | None = Field(
        True, description="Import into TMs created by other users. Default: true"
    )
    termBaseViewOther: bool | None = Field(
        True, description="View TBs created by other users. Default: true"
    )
    termBaseEditOther: bool | None = Field(
        True, description="Modify TBs created by other users. Default: true"
    )
    termBaseExportOther: bool | None = Field(
        True, description="Export TBs created by other users. Default: true"
    )
    termBaseImportOther: bool | None = Field(
        True, description="Import into TBs created by other users. Default: true"
    )
    termBaseApproveOther: bool | None = Field(
        True, description="Approve terms in TBs created by other users. Default: true"
    )
    role: Literal["GUEST"] = "GUEST"


class GetBilingualFileDto(BaseModel):
    jobs: List[UidReference] | None = Field(None, max_length=1000, min_length=1)


class GlossaryEditDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    langs: List[str] = Field(..., max_length=2147483647, min_length=1)
    owner: IdReference | None = None


class HumanTranslateJobsDto(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)
    humanTranslateSettings: IdReference
    comment: str | None = None
    glossaryId: str | None = None
    usePreferredTranslators: bool | None = None
    level: LevelEnum | None = None
    callbackUrl: str | None = None


class IdmUserReference(BaseModel):
    firstName: str | None = None
    lastName: str | None = None
    userName: str | None = None
    email: str | None = None
    role: UserRoleRefEnum | None = None
    id: str | None = None
    uid: str | None = None
    suiteIdentifier: str | None = None


class ImportStatusDto(BaseModel):
    status: ImportStatusEnum | None = None
    errorMessage: str | None = None


class ImportStatusDtoV2(BaseModel):
    status: ImportStatusEnum | None = None
    errorMessage: str | None = None


class SegmentWarningDtoInconsistentTagContent(SegmentWarningDto):
    type: Literal["InconsistentTagContent"] = "InconsistentTagContent"


class SegmentWarningDtoInconsistentTranslation(SegmentWarningDto):
    segmentId: str | None = None
    type: Literal["InconsistentTranslation"] = "InconsistentTranslation"


class JobExportActionDto(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=1000, min_length=1)


class JobExportResponseDto(BaseModel):
    jobs: List[UidReference] | None = None


class JobFilterDto(BaseModel):
    project: UidReference
    workflowStep: IdReference | None = None
    filename: str | None = None
    sourcePath: str | None = None
    statuses: List[JobStatusEnum2] | None = None
    targetLangs: List[str] | None = None
    dueIn: DueInEnum | None = None
    dateDue: AwareDatetime | None = None
    provider: ProviderReference | None = None
    jobOwner: UidReference | None = None


class JobMachineTranslationSettingsV3Dto(BaseModel):
    useMachineTranslation: bool | None = Field(
        True, description="Pre-translate from machine translation. Default: true"
    )
    machineTranslationBehavior: JobMachineTranslationSettingsV3Enum | None = None
    lock100PercentMatches: bool | None = Field(
        False,
        description="Lock section: 100% machine translation suggestions. Default: false, use lockMtThreshold to override the threshold",
    )
    lockMtThreshold: confloat(ge=0.0, le=100.0) | None = Field(
        None,
        description="Segment locking based on machine translation suggestions with QPS above threshold. Default: 100%, used in combination with lock100PercentMatches",
    )
    confirmMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for:\n                machine translation suggestions above `confirmMatchesThreshold`. Default: false",
    )
    confirmMatchesThreshold: confloat(ge=0.0, le=1.0) | None = Field(
        None, description="Machine translation suggestions percent. Default: `1.0`"
    )
    useAltTransOnly: bool | None = Field(
        False,
        description="Do not put machine translations to target and use alt-trans fields (alt-trans in mxlf).\nDefault: false",
    )
    mtSuggestOnlyTmBelow: bool | None = Field(
        True,
        description="Suggest MT only for segments with a TM match below. Default: true",
    )
    mtSuggestOnlyTmBelowThreshold: confloat(ge=0.0, le=1.01) | None = Field(
        None,
        description="Suggest MT only for segments with a TM match below threshold. Default: 1.0",
    )


class JobPartDeleteReferences(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)


class JobPartPatchSingleDto(BaseModel):
    status: JobStatusEnum2 | None = None
    dateDue: AwareDatetime | None = None
    providers: List[ProviderReference] | None = None


class JobPartReadyDeleteTranslationFilterDto(BaseModel):
    filename: str | None = None
    statuses: List[str] | None = None
    targetLang: str | None = None
    provider: ProviderReference | None = None
    owner: UidReference | None = None
    dateDue: AwareDatetime | None = None
    dueInHours: int | None = None
    overdue: bool | None = None


class JobPartReadyReferences(BaseModel):
    jobs: List[UidReference] | None = Field(None, max_length=100, min_length=1)


class JobPartReadyReferences2(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)


class JobPartReference(BaseModel):
    uid: str | None = None
    status: JobStatusEnum2 | None = None
    providers: List[ProviderReference] | None = None
    targetLang: str | None = None
    workflowLevel: int | None = None
    workflowStep: WorkflowStepReference | None = None
    filename: str | None = None
    dateDue: AwareDatetime | None = None
    dateCreated: AwareDatetime | None = None
    updateSourceDate: AwareDatetime | None = None
    imported: bool | None = None
    jobAssignedEmailTemplate: ObjectReference | None = None
    notificationIntervalInMinutes: int | None = None
    continuous: bool | None = None
    sourceFileUid: str | None = None


class JobPartReferences(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)


class JobPartSegmentsDtoV3(BaseModel):
    job: UidReference
    segments: List[str]


class JobPartUpdateBatchDto(BaseModel):
    jobs: List[UidReference] | None = Field(None, max_length=100, min_length=1)
    status: JobStatusEnum2
    dateDue: AwareDatetime | None = None
    providers: List[ProviderReference] | None = None


class JobPartUpdateSingleDto(BaseModel):
    status: JobStatusEnum2
    dateDue: AwareDatetime | None = None
    providers: List[ProviderReference] | None = None


class JobPartUpdateSourceDto(BaseModel):
    uid: str | None = None
    status: JobStatusEnum2 | None = None
    targetLang: str | None = None
    filename: str | None = None
    workflowLevel: int | None = None
    workflowStep: WorkflowStepReference | None = None


class JobPartsDto(BaseModel):
    jobs: List[JobPartReference] | None = None


class JobStatusChangeActionDto(BaseModel):
    requestedStatus: JobStatusEnum2 | None = None
    notifyOwner: bool | None = Field(
        False,
        description="Default: false; Both project owner and job owner are notified;\n                    the parameter is subordinated to notification settings in the project",
    )
    propagateStatus: bool | None = Field(
        False,
        description="Default: false;\n        Controls both job status and email notifications to previous/next provider",
    )


class JobUpdateSourceResponseDto(BaseModel):
    asyncRequest: AsyncRequestReference | None = None
    jobs: List[JobPartUpdateSourceDto] | None = None


class SegmentWarningDtoJoinTags(SegmentWarningDto):
    sourceTagsCount: int | None = None
    translationTagsCount: int | None = None
    type: Literal["JoinTags"] = "JoinTags"


class UserCreateDtoLinguist(AbstractUserCreateDto):
    editAllTermsInTB: bool | None = Field(
        False, description="Edit all terms in TB. Default: false"
    )
    editTranslationsInTM: bool | None = Field(
        False, description="Edit translations in TM. Default: false"
    )
    enableMT: bool | None = Field(True, description="Enable MT. Default: true")
    mayRejectJobs: bool | None = Field(False, description="Reject jobs. Default: false")
    mayCompleteUnconfirmedJobs: bool | None = Field(
        False, description="Complete unconfirmed jobs. Default: false"
    )
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    workflowSteps: List[UidReference] | None = None
    clients: List[UidReference] | None = None
    domains: List[UidReference] | None = None
    subDomains: List[UidReference] | None = None
    netRateScheme: UidReference | None = None
    translationPriceList: UidReference | None = None
    role: Literal["LINGUIST"] = "LINGUIST"


class UserEditDtoLinguist(AbstractUserEditDto):
    editAllTermsInTB: bool | None = Field(
        False, description="Edit all terms in TB. Default: false"
    )
    editTranslationsInTM: bool | None = Field(
        False, description="Edit translations in TM. Default: false"
    )
    enableMT: bool | None = Field(True, description="Enable MT. Default: true")
    mayRejectJobs: bool | None = Field(False, description="Reject jobs. Default: false")
    mayCompleteUnconfirmedJobs: bool | None = Field(
        False, description="Complete unconfirmed jobs. Default: false"
    )
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    workflowSteps: List[UidReference] | None = None
    clients: List[UidReference] | None = None
    domains: List[UidReference] | None = None
    subDomains: List[UidReference] | None = None
    netRateScheme: UidReference | None = None
    translationPriceList: UidReference | None = None
    role: Literal["LINGUIST"] = "LINGUIST"


class SegmentWarningDtoLeadingAndTrailingSpaces(SegmentWarningDto):
    srcPosition: Position | None = None
    srcWhitespaces: str | None = None
    tgtPosition: Position | None = None
    tgtWhitespaces: str | None = None
    suggestion: Suggestion | None = None
    type: Literal["LeadingAndTrailingSpaces"] = "LeadingAndTrailingSpaces"


class LocaleConventionWeightsDto(BaseModel):
    localeConvention: ToggleableWeightDto | None = None
    addressFormat: ToggleableWeightDto | None = None
    dateFormat: ToggleableWeightDto | None = None
    currencyFormat: ToggleableWeightDto | None = None
    measurementFormat: ToggleableWeightDto | None = None
    shortcutKey: ToggleableWeightDto | None = None
    telephoneFormat: ToggleableWeightDto | None = None


class LoginUserDto(BaseModel):
    user: IdmUserReference | None = None
    csrfToken: str | None = None
    organization: OrganizationReference | None = None
    edition: EditionDto | None = None
    features: FeaturesDto | None = None


class LqaProfilesForWsV2Dto(BaseModel):
    workflowStep: IdReference | None = None
    lqaProfile: UidReference | None = None


class LqaProfilesForWsV3Dto(BaseModel):
    workflowStep: IdReference | None = None
    lqaProfile: UidReference | None = None


class LqaReportEmailRequestDto(BaseModel):
    jobParts: List[UidReference] = Field(
        ...,
        description="JobParts for which the LQA reports should be sent",
        max_length=100,
        min_length=0,
    )
    recipientUsers: List[UidReference] = Field(..., max_length=100, min_length=0)
    ccAddress: str | None = None
    bccAddress: str | None = None
    message: str | None = Field(
        None,
        description="Must not be empty if `organizationEmailTemplate` is not null.",
    )
    subject: constr(min_length=1, max_length=2147483647) | None = None
    organizationEmailTemplate: UidReference | None = None


class LqaReportRecipientDto(BaseModel):
    type: LqaReportRecipientTypeEnum | None = None
    userUid: str | None = None
    username: str | None = None
    firstName: str | None = None
    lastName: str | None = None
    organizationName: str | None = None
    email: str | None = None


class LqaSettingsDto(BaseModel):
    enabled: bool | None = None
    severities: List[LqaSeverityDto] | None = None
    categories: List[LqaErrorCategoryDto] | None = None


class MTSettingsPerLanguageReference(BaseModel):
    targetLang: str | None = Field(
        None, description="mtSettings is set for whole project if targetLang == null"
    )
    machineTranslateSettings: MachineTranslateSettingsReference | None = None


class MachineTranslateSettingsDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    baseName: str | None = None
    name: str | None = None
    type: str | None = None
    category: str | None = None
    default_: bool | None = None
    includeTags: bool | None = None
    mtQualityEstimation: bool | None = None
    enabled: bool | None = None
    args: Dict[str, str] | None = None
    langs: MachineTranslateSettingsLangsDto | None = None


class MachineTranslationSettingsDto5(BaseModel):
    useMachineTranslation: bool | None = Field(
        False, description="Pre-translate from machine translation. Default: false"
    )
    machineTranslationBehavior: JobMachineTranslationSettingsV3Enum | None = None
    lock100PercentMatches: bool | None = Field(
        False,
        description="Lock section: 100% machine translation suggestions. Default: false, use lockMtThreshold to override the threshold",
    )
    lockMtThreshold: confloat(ge=0.0, le=100.0) | None = Field(
        None,
        description="Segment locking based on machine translation suggestions with QPS above threshold. Default: 100%, used in combination with lock100PercentMatches",
    )
    confirmMatches: bool | None = Field(
        False,
        description="Set segment status to confirmed for:\n                machine translation suggestions above `confirmMatchesThreshold`. Default: false",
    )
    confirmMatchesThreshold: confloat(ge=0.0, le=1.0) | None = Field(
        None, description="Machine translation suggestions percent. Default: `1.0`"
    )
    useAltTransOnly: bool | None = Field(
        False,
        description="Do not put machine translations to target and use alt-trans fields (alt-trans in mxlf).\nDefault: false",
    )
    mtQeMatchesInEditors: bool | None = Field(
        False,
        description="Display quality-estimated machine translation suggestions in the CAT Editor. Default: false",
    )
    mtForTMAbove100: bool | None = Field(
        False,
        description="Use machine translation for segments with a TM match of 100% or more. Default: false",
    )
    mtSuggestOnlyTmBelow: bool | None = Field(
        True,
        description="Suggest MT only for segments with a TM match below. Default: true",
    )
    mtSuggestOnlyTmBelowThreshold: confloat(ge=0.0, le=1.01) | None = Field(
        None,
        description="Suggest MT only for segments with a TM match below threshold. Default: 1.0",
    )


class SegmentWarningDtoMalformed(SegmentWarningDto):
    message: str | None = None
    type: Literal["Malformed"] = "Malformed"


class MdSettingsDto(BaseModel):
    hardLineBreaksSegments: bool | None = Field(True, description="Default: true")
    preserveWhiteSpaces: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    customElements: str | None = None
    ignoredBlockPrefixes: str | None = None
    flavor: FlavorEnum | None = None
    processJekyllFrontMatter: bool | None = Field(False, description="Default: false")
    extractCodeBlocks: bool | None = Field(True, description="Default: true")
    notEscapedCharacters: str | None = None
    excludeCodeElements: bool | None = Field(False, description="Default: false")


class MentionableGroupDto(BaseModel):
    groupType: MentionGroupTypeEnum | None = None
    groupName: str | None = None
    groupReference: UidReference | None = None


class MetadataField(BaseModel):
    type: MetadataFieldTypeEnum | None = None


class MetadataPrioritySettingsDto(BaseModel):
    prioritizedFields: List[MetadataField] | None = None


class SegmentWarningDtoMissingNonTranslatableAnnotation(SegmentWarningDto):
    text: str | None = None
    beginIndexes: List[int] | None = None
    type: Literal["MissingNonTranslatableAnnotation"] = (
        "MissingNonTranslatableAnnotation"
    )


class SegmentWarningDtoMissingNumbersV3(SegmentWarningDto):
    number: str | None = None
    positions: List[Position] | None = None
    type: Literal["MissingNumbersV3"] = "MissingNumbersV3"


class SegmentWarningDtoMissingNumbers(SegmentWarningDto):
    missingNumbers: List[str] | None = None
    type: Literal["MissingNumbers"] = "MissingNumbers"


class SegmentWarningDtoMoravia(SegmentWarningDto):
    message: str | None = None
    subType: str | None = None
    type: Literal["Moravia"] = "Moravia"


class MultilingualCsvSettingsDto(BaseModel):
    sourceColumns: str | None = None
    targetColumns: str | None = None
    contextNoteColumns: str | None = None
    contextKeyColumns: str | None = None
    tagRegexp: str | None = None
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    segmentation: bool | None = Field(True, description="Default: true")
    delimiter: constr(min_length=0, max_length=255) | None = Field(
        None, description="Default: ,"
    )
    delimiterType: DelimiterTypeEnum | None = None
    importRows: str | None = None
    maxLenColumns: str | None = None
    allTargetColumns: Dict[str, str] | None = Field(
        None, description='Format: "language":"column"; example: {"en": "A", "sk": "B"}'
    )
    nonEmptySegmentAction: NonEmptySegmentActionEnum | None = None
    saveConfirmedSegmentsToTm: bool | None = None


class MultilingualXlsSettingsDto(BaseModel):
    sourceColumn: str | None = None
    targetColumns: Dict[str, str] | None = Field(
        None, description='Format: "language":"column"; example: {"en": "A", "sk": "B"}'
    )
    contextNoteColumn: str | None = None
    contextKeyColumn: str | None = None
    tagRegexp: str | None = None
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    segmentation: bool | None = Field(True, description="Default: true")
    importRows: str | None = None
    maxLenColumn: str | None = None
    nonEmptySegmentAction: NonEmptySegmentActionEnum | None = None
    saveConfirmedSegmentsToTm: bool | None = None


class MultilingualXmlSettingsDto(BaseModel):
    translatableElementsXPath: str | None = None
    sourceElementsXPath: str | None = None
    targetElementsXPaths: Dict[str, str] | None = Field(
        None,
        description='\'Format: "language":"xpath";\n            example = \'{"en": "tuv[@lang=\'en\']/seg", "sk": "tuv[@lang=\'sk\']/seg"}',
    )
    inlineElementsNonTranslatableXPath: str | None = None
    tagRegexp: str | None = None
    segmentation: bool | None = Field(None, description="Default: `true`")
    htmlSubFilter: bool | None = Field(None, description="Default: `false`")
    contextKeyXPath: str | None = None
    contextNoteXPath: str | None = None
    maxLenXPath: str | None = None
    preserveWhitespace: bool | None = Field(None, description="Default: `false`")
    preserveCharEntities: str | None = None
    xslUrl: str | None = None
    xslFile: str | None = Field(
        None, description="UID of uploaded XSL file, overrides xslUrl"
    )
    nonEmptySegmentAction: NonEmptySegmentActionEnum | None = None
    saveConfirmedSegmentsToTm: bool | None = None
    icuSubFilter: bool | None = Field(None, description="Default: `false`")


class SegmentWarningDtoMultipleSpacesV3(SegmentWarningDto):
    spaces: str | None = None
    positions: List[Position] | None = None
    type: Literal["MultipleSpacesV3"] = "MultipleSpacesV3"


class SegmentWarningDtoMultipleSpaces(SegmentWarningDto):
    type: Literal["MultipleSpaces"] = "MultipleSpaces"


class SegmentWarningDtoNestedTags(SegmentWarningDto):
    misplacedTargetTag: str | None = None
    type: Literal["NestedTags"] = "NestedTags"


class NetRateSchemeWorkflowStep(BaseModel):
    id: str | None = None
    workflowStep: WorkflowStepReference | None = None
    rates: DiscountSettingsDto | None = None


class NetRateSchemeWorkflowStepReference(BaseModel):
    id: str | None = None
    workflowStep: WorkflowStepReference | None = None


class SegmentWarningDtoNewerAtLowerLevel(SegmentWarningDto):
    type: Literal["NewerAtLowerLevel"] = "NewerAtLowerLevel"


class SegmentWarningDtoNonConformingTerm(SegmentWarningDto):
    term: str | None = None
    positions: List[Position] | None = None
    suggestedTargetTerms: List[Term] | None = None
    type: Literal["NonConformingTerm"] = "NonConformingTerm"


class SegmentWarningDtoNotConfirmed(SegmentWarningDto):
    type: Literal["NotConfirmed"] = "NotConfirmed"


class NotifyJobPartsRequestDto(BaseModel):
    jobs: List[UidReference]
    emailTemplate: IdReference
    cc: List[str] | None = None
    bcc: List[str] | None = None


class Order(BaseModel):
    direction: DirectionEnum | None = None
    property: str | None = None


class OrganizationEmailTemplateDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    type: OrganizationEmailTemplateTypeEnum | None = None
    name: str | None = None
    subject: str | None = None
    body: str | None = None
    ccAddress: str | None = None
    bccAddress: str | None = None


class OtherWeightsDto(BaseModel):
    other: ToggleableWeightDto | None = None


class UserCreateDtoProjectManager(AbstractUserCreateDto):
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    workflowSteps: List[UidReference] | None = None
    clients: List[UidReference] | None = None
    domains: List[UidReference] | None = None
    subDomains: List[UidReference] | None = None
    projectCreate: bool | None = Field(
        True, description="Enable project creation. Default: true"
    )
    projectViewOther: bool | None = Field(
        True, description="View projects created by other users. Default: true"
    )
    projectEditOther: bool | None = Field(
        True, description="Modify projects created by other users. Default: true"
    )
    projectDeleteOther: bool | None = Field(
        True, description="Delete projects created by other users. Default: true"
    )
    projectClients: List[UidReference] | None = Field(
        None, description="Access projects of a selected clients only"
    )
    projectBusinessUnits: List[UidReference] | None = Field(
        None, description="Access projects of selected business units only"
    )
    projectTemplateCreate: bool | None = Field(
        True, description="Enable project templates creation. Default: true"
    )
    projectTemplateViewOther: bool | None = Field(
        True, description="View project templates created by other users. Default: true"
    )
    projectTemplateEditOther: bool | None = Field(
        True,
        description="Modify project templates created by other users. Default: true",
    )
    projectTemplateDeleteOther: bool | None = Field(
        True,
        description="Delete project templates created by other users. Default: true",
    )
    projectTemplateClients: List[UidReference] | None = Field(
        None, description="Access project templates of a selected clients only"
    )
    projectTemplateBusinessUnits: List[UidReference] | None = Field(
        None, description="Access project templates of selected business units only"
    )
    transMemoryCreate: bool | None = Field(
        True, description="Enable TMs creation. Default: true"
    )
    transMemoryViewOther: bool | None = Field(
        True, description="View TMs created by other users. Default: true"
    )
    transMemoryEditOther: bool | None = Field(
        True, description="Modify TMs created by other users. Default: true"
    )
    transMemoryDeleteOther: bool | None = Field(
        True, description="Delete TMs created by other users. Default: true"
    )
    transMemoryExportOther: bool | None = Field(
        True, description="Export TMs created by other users. Default: true"
    )
    transMemoryImportOther: bool | None = Field(
        True, description="Import into TMs created by other users. Default: true"
    )
    transMemoryClients: List[UidReference] | None = Field(
        None, description="Access TMs of a selected clients only"
    )
    transMemoryBusinessUnits: List[UidReference] | None = Field(
        None, description="Access TMs of selected business units only"
    )
    termBaseCreate: bool | None = Field(
        True, description="Enable TBs creation. Default: true"
    )
    termBaseViewOther: bool | None = Field(
        True, description="View TBs created by other users. Default: true"
    )
    termBaseEditOther: bool | None = Field(
        True, description="Modify TBs created by other users. Default: true"
    )
    termBaseDeleteOther: bool | None = Field(
        True, description="Delete TBs created by other users. Default: true"
    )
    termBaseExportOther: bool | None = Field(
        True, description="Export TBs created by other users. Default: true"
    )
    termBaseImportOther: bool | None = Field(
        True, description="Import into TBs created by other users. Default: true"
    )
    termBaseApproveOther: bool | None = Field(
        True, description="Approve terms in TBs created by other users. Default: true"
    )
    termBaseClients: List[UidReference] | None = Field(
        None, description="Access TBs of a selected clients only"
    )
    termBaseBusinessUnits: List[UidReference] | None = Field(
        None, description="Access TBs of selected business units only"
    )
    userCreate: bool | None = Field(
        True, description="Enable users creation. Default: true"
    )
    userViewOther: bool | None = Field(
        True, description="View users created by other users. Default: true"
    )
    userEditOther: bool | None = Field(
        True, description="Modify users created by other users. Default: true"
    )
    userDeleteOther: bool | None = Field(
        True, description="Delete users created by other users. Default: true"
    )
    clientDomainSubDomainCreate: bool | None = Field(
        True, description="Enable clients, domains, subdomains creation. Default: true"
    )
    clientDomainSubDomainViewOther: bool | None = Field(
        True,
        description="View clients, domains, subdomains created by other users. Default: true",
    )
    clientDomainSubDomainEditOther: bool | None = Field(
        True,
        description="Modify clients, domains, subdomains created by other users. Default: true",
    )
    clientDomainSubDomainDeleteOther: bool | None = Field(
        True,
        description="Delete clients, domains, subdomains created by other users. Default: true",
    )
    vendorCreate: bool | None = Field(
        True, description="Enable Vendors creation. Default: true"
    )
    vendorViewOther: bool | None = Field(
        True, description="View Vendors created by other users. Default: true"
    )
    vendorEditOther: bool | None = Field(
        True, description="Modify Vendors created by other users. Default: true"
    )
    vendorDeleteOther: bool | None = Field(
        True, description="Delete Vendors created by other users. Default: true"
    )
    dashboardSetting: DashboardSettingEnum | None = None
    setupServer: bool | None = Field(
        True, description="Modify setup's server settings. Default: true"
    )
    role: Literal["PROJECT_MANAGER"] = "PROJECT_MANAGER"


class UserEditDtoProjectManager(AbstractUserEditDto):
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    workflowSteps: List[UidReference] | None = None
    clients: List[UidReference] | None = None
    domains: List[UidReference] | None = None
    subDomains: List[UidReference] | None = None
    projectCreate: bool | None = Field(
        True, description="Enable project creation. Default: true"
    )
    projectViewOther: bool | None = Field(
        True, description="View projects created by other users. Default: true"
    )
    projectEditOther: bool | None = Field(
        True, description="Modify projects created by other users. Default: true"
    )
    projectDeleteOther: bool | None = Field(
        True, description="Delete projects created by other users. Default: true"
    )
    projectClients: List[UidReference] | None = Field(
        None, description="Access projects of a selected clients only"
    )
    projectBusinessUnits: List[UidReference] | None = Field(
        None, description="Access projects of selected business units only"
    )
    projectTemplateCreate: bool | None = Field(
        True, description="Enable project templates creation. Default: true"
    )
    projectTemplateViewOther: bool | None = Field(
        True, description="View project templates created by other users. Default: true"
    )
    projectTemplateEditOther: bool | None = Field(
        True,
        description="Modify project templates created by other users. Default: true",
    )
    projectTemplateDeleteOther: bool | None = Field(
        True,
        description="Delete project templates created by other users. Default: true",
    )
    projectTemplateClients: List[UidReference] | None = Field(
        None, description="Access project templates of a selected clients only"
    )
    projectTemplateBusinessUnits: List[UidReference] | None = Field(
        None, description="Access project templates of selected business units only"
    )
    transMemoryCreate: bool | None = Field(
        True, description="Enable TMs creation. Default: true"
    )
    transMemoryViewOther: bool | None = Field(
        True, description="View TMs created by other users. Default: true"
    )
    transMemoryEditOther: bool | None = Field(
        True, description="Modify TMs created by other users. Default: true"
    )
    transMemoryDeleteOther: bool | None = Field(
        True, description="Delete TMs created by other users. Default: true"
    )
    transMemoryExportOther: bool | None = Field(
        True, description="Export TMs created by other users. Default: true"
    )
    transMemoryImportOther: bool | None = Field(
        True, description="Import into TMs created by other users. Default: true"
    )
    transMemoryClients: List[UidReference] | None = Field(
        None, description="Access TMs of a selected clients only"
    )
    transMemoryBusinessUnits: List[UidReference] | None = Field(
        None, description="Access TMs of selected business units only"
    )
    termBaseCreate: bool | None = Field(
        True, description="Enable TBs creation. Default: true"
    )
    termBaseViewOther: bool | None = Field(
        True, description="View TBs created by other users. Default: true"
    )
    termBaseEditOther: bool | None = Field(
        True, description="Modify TBs created by other users. Default: true"
    )
    termBaseDeleteOther: bool | None = Field(
        True, description="Delete TBs created by other users. Default: true"
    )
    termBaseExportOther: bool | None = Field(
        True, description="Export TBs created by other users. Default: true"
    )
    termBaseImportOther: bool | None = Field(
        True, description="Import into TBs created by other users. Default: true"
    )
    termBaseApproveOther: bool | None = Field(
        True, description="Approve terms in TBs created by other users. Default: true"
    )
    termBaseClients: List[UidReference] | None = Field(
        None, description="Access TBs of a selected clients only"
    )
    termBaseBusinessUnits: List[UidReference] | None = Field(
        None, description="Access TBs of selected business units only"
    )
    userCreate: bool | None = Field(
        True, description="Enable users creation. Default: true"
    )
    userViewOther: bool | None = Field(
        True, description="View users created by other users. Default: true"
    )
    userEditOther: bool | None = Field(
        True, description="Modify users created by other users. Default: true"
    )
    userDeleteOther: bool | None = Field(
        True, description="Delete users created by other users. Default: true"
    )
    clientDomainSubDomainCreate: bool | None = Field(
        True, description="Enable clients, domains, subdomains creation. Default: true"
    )
    clientDomainSubDomainViewOther: bool | None = Field(
        True,
        description="View clients, domains, subdomains created by other users. Default: true",
    )
    clientDomainSubDomainEditOther: bool | None = Field(
        True,
        description="Modify clients, domains, subdomains created by other users. Default: true",
    )
    clientDomainSubDomainDeleteOther: bool | None = Field(
        True,
        description="Delete clients, domains, subdomains created by other users. Default: true",
    )
    vendorCreate: bool | None = Field(
        True, description="Enable Vendors creation. Default: true"
    )
    vendorViewOther: bool | None = Field(
        True, description="View Vendors created by other users. Default: true"
    )
    vendorEditOther: bool | None = Field(
        True, description="Modify Vendors created by other users. Default: true"
    )
    vendorDeleteOther: bool | None = Field(
        True, description="Delete Vendors created by other users. Default: true"
    )
    dashboardSetting: DashboardSettingEnum | None = None
    setupServer: bool | None = Field(
        True, description="Modify setup's server settings. Default: true"
    )
    role: Literal["PROJECT_MANAGER"] = "PROJECT_MANAGER"


class PdfSettingsDto(BaseModel):
    filter: FilterEnum | None = None


class PenaltyPointsDto(BaseModel):
    neutral: SeverityDto | None = None
    minor: SeverityDto | None = None
    major: SeverityDto | None = None
    critical: SeverityDto | None = None


class PlainReferences(BaseModel):
    taskId: str | None = None
    jobPartUid: str | None = None
    transGroupId: conint(ge=0)
    segmentId: str
    conversationTitle: str | None = None
    conversationTitleOffset: conint(ge=0) | None = None
    commentedText: str | None = None
    correlation: ReferenceCorrelation | None = None


class PoSettingsDto(BaseModel):
    tagRegexp: str | None = None
    exportMultiline: bool | None = Field(True, description="Default: true")
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    segment: bool | None = Field(False, description="Default: false")
    markupSubFilterTranslatable: str | None = None
    markupSubFilterNonTranslatable: str | None = None
    contextKeySuffixType: ContextKeySuffixTypeEnum | None = None
    saveConfirmedSegments: bool | None = None
    importSetSegmentConfirmedWhen: PoSegmentMatchStatusEnum | None = None
    importSetSegmentLockedWhen: PoSegmentMatchStatusEnum | None = None
    exportConfirmedLocked: PoSegmentMatchStatusEnum | None = None
    exportConfirmedNotLocked: PoSegmentMatchStatusEnum | None = None
    exportNotConfirmedLocked: PoSegmentMatchStatusEnum | None = None
    exportNotConfirmedNotLocked: PoSegmentMatchStatusEnum | None = None
    icuSubFilter: bool | None = Field(None, description="Default: `false`")
    updateHeader: bool | None = Field(None, description="Default: `false`")


class PreTranslateJobSettingsV3Dto(BaseModel):
    autoPropagateRepetitions: bool | None = Field(
        False, description="Propagate repetitions. Default: false"
    )
    confirmRepetitions: bool | None = Field(
        False,
        description="Set segment status to confirmed for: Repetitions. Default: false",
    )
    setJobStatusCompleted: bool | None = Field(
        False,
        description="Pre-translate & set job to completed: Set job to completed once pre-translated. Default: false",
    )
    setJobStatusCompletedWhenConfirmed: bool | None = Field(
        False,
        description="Pre-translate & set job to completed when all segments confirmed:\nSet job to completed once pre-translated and all segments are confirmed. Default: false",
    )
    setProjectStatusCompleted: bool | None = Field(
        False,
        description="Pre-translate & set job to completed: Set project to completed once all jobs pre-translated.\n        Default: false",
    )
    overwriteExistingTranslations: bool | None = Field(
        False,
        description="Overwrite existing translations in target segments. Default: false",
    )
    translationMemorySettings: JobTranslationMemorySettingsV3Dto | None = None
    machineTranslationSettings: JobMachineTranslationSettingsV3Dto | None = None
    nonTranslatableSettings: JobNonTranslatableSettingsV3Dto | None = None


class PreTranslateJobsV3Dto(BaseModel):
    jobs: List[UidReference] = Field(
        ..., description="Jobs to be pre-translated", max_length=100, min_length=1
    )
    segmentFilters: List[SegmentFiltersEnum] | None = None
    useProjectPreTranslateSettings: bool | None = Field(
        None,
        description="If pre-translate settings from project should be used.\nIf true, preTranslateSettings values are ignored. Default: `false`",
    )
    callbackUrl: str | None = None
    preTranslateSettings: PreTranslateJobSettingsV3Dto | None = None


class PreTranslateSettingsV4Dto(BaseModel):
    preTranslateOnJobCreation: bool | None = Field(
        False,
        description="Pre-translate & set job to completed: Pre-translate on job creation. Default: false",
    )
    setJobStatusCompleted: bool | None = Field(
        False,
        description="Pre-translate & set job to completed: Set job to completed once pre-translated. Default: false",
    )
    setJobStatusCompletedWhenConfirmed: bool | None = Field(
        False,
        description="Pre-translate & set job to completed when all segments confirmed:\nSet job to completed once pre-translated and all segments are confirmed. Default: false",
    )
    setProjectStatusCompleted: bool | None = Field(
        False,
        description="Pre-translate & set job to completed: Set project to completed once all jobs pre-translated.\n        Default: false",
    )
    overwriteExistingTranslations: bool | None = Field(
        False,
        description="Overwrite existing translations in target segments. Default: false",
    )
    translationMemorySettings: TranslationMemorySettingsDto5 | None = None
    machineTranslationSettings: MachineTranslationSettingsDto5 | None = None
    nonTranslatableSettings: NonTranslatableSettingsDto5 | None = None
    repetitionsSettings: RepetitionsSettingsDto4 | None = None
    pseudoTranslateSettings: PseudoTranslateSettingsDto3 | None = None


class PreviewUrlDto(BaseModel):
    type: PreviewUrlTypeEnum | None = None
    url: str | None = None


class PreviewUrlsDto(BaseModel):
    previews: List[PreviewUrlDto] | None = None


class PreviousWorkflowDto(BaseModel):
    completed: bool | None = None
    counts: SegmentsCountsDto | None = None


class PriceRow(BaseModel):
    rowNum: int | None = None
    price: PriceSet | None = None
    errors: List[str] | None = None


class ProjectJobPartsDto(BaseModel):
    jobs: List[JobPartReference] | None = None
    project: ProjectReference | None = None


class ProjectMTSettingsPerLangDto(BaseModel):
    targetLang: str
    machineTranslateSettings: UidReference | None = None


class ProjectReference2(BaseModel):
    uid: str | None = None
    innerId: int | None = None
    name: str | None = None
    businessUnit: BusinessUnitReference2 | None = None
    domain: DomainReference3 | None = None
    subDomain: SubDomainReference3 | None = None
    client: ClientReference3 | None = None
    costCenter: CostCenterReference2 | None = None
    dueDate: AwareDatetime | None = None
    createdDate: AwareDatetime | None = None
    createdBy: UserReference4 | None = None
    owner: UserReference4 | None = None
    vendor: VendorUserReference | None = None
    purchaseOrder: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    status: str | None = None
    progress: ProgressReference | None = None
    metadata: List[MetadataReference] | None = None
    note: str | None = None
    deleted: bool | None = None
    archived: bool | None = None


class ProjectSecuritySettingsDtoV2(BaseModel):
    downloadEnabled: bool | None = None
    webEditorEnabledForLinguists: bool | None = None
    showUserDataToLinguists: bool | None = None
    emailNotifications: bool | None = None
    strictWorkflowFinish: bool | None = None
    useVendors: bool | None = None
    linguistsMayEditLockedSegments: bool | None = None
    usersMaySetAutoPropagation: bool | None = None
    allowLoadingExternalContentInEditors: bool | None = None
    allowLoadingIframes: bool | None = None
    linguistsMayEditSource: bool | None = None
    linguistsMayEditTagContent: bool | None = None
    linguistsMayDownloadLqaReport: bool | None = None
    usernamesDisplayedInLqaReport: bool | None = None
    userMaySetInstantQA: bool | None = None
    triggerWebhooks: bool | None = None
    notifyJobOwnerStatusChanged: bool | None = None
    vendors: VendorSecuritySettingsDto | None = None
    allowedDomains: List[str] | None = None


class ProjectTemplateCreateActionDto(BaseModel):
    project: UidReference
    name: constr(min_length=0, max_length=255)
    importSettings: UidReference | None = None
    useDynamicTitle: bool | None = None
    dynamicTitle: constr(min_length=0, max_length=255) | None = None


class ProjectTemplateReferenceFilesRequestDto(BaseModel):
    referenceFiles: List[UidReference]


class ProjectTemplateWorkflowSettingsAssignedToDto(BaseModel):
    targetLang: str | None = None
    providers: List[ProviderReference] | None = None


class ProjectTemplateWorkflowSettingsDto(BaseModel):
    workflowStep: WorkflowStepReference | None = None
    assignedTo: List[ProjectTemplateWorkflowSettingsAssignedToDto] | None = None


class ProjectWorkflowStepDtoV2(BaseModel):
    id: int | None = None
    abbreviation: str | None = None
    name: str | None = None
    workflowLevel: int | None = None
    workflowStep: WorkflowStepReferenceV2 | None = None


class ProjectWorkflowStepListDtoV2(BaseModel):
    projectWorkflowSteps: List[ProjectWorkflowStepDtoV2] | None = None


class ProtectedUserReference(BaseModel):
    firstName: str | None = None
    lastName: str | None = None
    userName: str | None = None
    email: str | None = None
    role: UserRoleRefEnum | None = None
    id: str | None = None
    uid: str | None = None


class ProviderListDtoV2(BaseModel):
    providers: Providers2 | None = None


class ProvidersPerLanguage(BaseModel):
    targetLang: str | None = None
    providers: List[ProviderReference] | None = None
    assignedUsers: List[User] | None = None


class PseudoTranslateActionDto(BaseModel):
    replacement: constr(min_length=1, max_length=10) | None = None
    prefix: str | None = None
    suffix: str | None = None
    length: float | None = None
    keyHashPrefixLen: conint(ge=0, le=18) | None = None
    substitution: List[SubstituteDto] | None = Field(None, max_length=100, min_length=1)


class PseudoTranslateActionDtoV2(BaseModel):
    replacement: str | None = None
    prefix: str | None = None
    suffix: str | None = None
    length: float | None = None
    keyHashPrefixLen: conint(ge=0, le=18) | None = None
    substitution: List[SubstituteDtoV2] | None = Field(
        None, max_length=2147483647, min_length=0
    )
    intersperse: bool | None = None


class PseudoTranslateWrapperDto(BaseModel):
    jobParts: JobPartReadyReferences2
    pseudoTranslate: PseudoTranslateActionDtoV2


class QACheckDtoV2(BaseModel):
    type: str
    name: QACheckDtoV2NameEnum


class QASettingsDtoV2(BaseModel):
    checks: List[QACheckDtoV2] | None = None


class QualityAssuranceChecksDtoV2(BaseModel):
    forbiddenStrings: List[str] | None = None
    enabledChecks: List[EnabledCheckDtoV2] | None = Field(
        None,
        description="enabledChecks",
        examples=[
            '\n   [\n      {\n         "checkerType":"EmptyTranslation",\n         "ignorable":false\n      },\n      {\n         "checkerType":"TrailingPunctuation",\n         "ignorable":false\n      },\n      {\n         "checkerType":"Formatting",\n         "ignorable":false\n      },\n      {\n         "checkerType":"JoinTags",\n         "ignorable":false\n      },\n      {\n         "checkerType":"MissingNumbers",\n         "ignorable":false\n      },\n      {\n         "checkerType":"MultipleSpaces",\n         "ignorable":false\n      },\n      {\n         "checkerType":"NonConformingTerm",\n         "ignorable":false\n      },\n      {\n         "checkerType":"NotConfirmed",\n         "ignorable":false\n      },\n      {\n         "checkerType":"TranslationLength",\n         "ignorable":false\n      },\n      {\n         "checkerType": "AbsoluteLength",\n         "ignorable": false\n      },\n      {\n         "checkerType": "RelativeLength",\n         "ignorable": false\n      },\n      {\n         "checkerType":"EmptyPairTags",\n         "ignorable":false\n      },\n      {\n         "checkerType":"InconsistentTranslationTargetSource",\n         "ignorable":true\n      },\n      {\n         "checkerType":"InconsistentTranslationSourceTarget",\n         "ignorable":true\n      },\n      {\n         "checkerType":"ForbiddenString",\n         "ignorable":false\n      },\n      {\n         "checkerType":"SpellCheck",\n         "ignorable":false\n      },\n      {\n         "checkerType":"RepeatedWords",\n         "ignorable":false\n      },\n      {\n         "checkerType":"InconsistentTagContent",\n         "ignorable":false\n      },\n      {\n         "checkerType":"EmptyTagContent",\n         "ignorable":false\n      },\n      {\n         "checkerType":"Malformed",\n         "ignorable":false\n      },\n      {\n         "checkerType":"ForbiddenTerm",\n         "ignorable":false\n      },\n      {\n         "checkerType":"NewerAtLowerLevel",\n         "ignorable":false\n      },\n      {\n         "checkerType":"LeadingAndTrailingSpaces",\n         "ignorable":false\n      },\n      {\n         "checkerType":"TargetSourceIdentical",\n         "ignorable":false\n      },\n      {\n         "checkerType":"SourceOrTargetRegexp"\n      },\n      {\n         "checkerType":"UnmodifiedFuzzyTranslationTM",\n         "ignorable":true\n      },\n      {\n         "checkerType":"UnmodifiedFuzzyTranslationMTNT",\n         "ignorable":true\n      },\n      {\n         "checkerType":"Moravia",\n         "ignorable":false,\n         "context": {"moraviaProfileId": "MoraviaProfileIdValue"}\n      },\n      {\n         "checkerType":"ExtraNumbers",\n         "ignorable":true\n      },\n      {\n         "checkerType":"UnresolvedConversation",\n         "ignorable":false\n      },\n      {\n         "checkerType":"NestedTags",\n         "ignorable":false\n      },\n      {\n         "checkerType":"FuzzyInconsistency",\n         "ignorable":true\n      }\n   ]\n'
        ],
    )
    excludeLockedSegments: bool | None = None
    userCanSetInstantQA: bool | None = None
    strictJobStatus: bool | None = None
    regexpRules: List[RegexpCheckRuleDtoV2] | None = None


class QualityAssuranceChecksDtoV4(BaseModel):
    forbiddenStrings: List[str] | None = None
    enabledChecks: List[EnabledCheckDtoV4] | None = None
    excludeLockedSegments: bool | None = None
    userCanSetInstantQA: bool | None = None
    strictJobStatus: bool | None = None
    regexpRules: List[RegexpCheckRuleDtoV4] | None = None


class QualityAssuranceResponseDto(BaseModel):
    segmentWarnings: List[SegmentWarningsDto] | None = None
    finished: bool | None = None


class QualityAssuranceRunDtoV3(BaseModel):
    initialSegment: SegmentReference | None = None
    maxQaWarningsCount: conint(ge=1, le=1000) | None = Field(
        None,
        description="Maximum number of QA warnings in result, default: 100. For efficiency reasons QA\nwarnings are processed with minimum segments chunk size 10, therefore slightly more warnings are returned.",
    )
    warningTypes: List[QualityChecksEnum] | None = Field(
        None, max_length=100, min_length=0
    )


class QualityAssuranceSegmentsRunDtoV3(BaseModel):
    jobsAndSegments: List[JobPartSegmentsDtoV3] = Field(
        ..., max_length=100, min_length=1
    )
    warningTypes: List[QualityChecksEnum] | None = Field(
        None,
        description="When empty only fast checks run",
        max_length=100,
        min_length=0,
    )
    maxQaWarningsCount: conint(ge=1, le=1000) | None = Field(
        None,
        description="Maximum number of QA warnings in result, default: 100. For efficiency reasons QA\nwarnings are processed with minimum segments chunk size 10, therefore slightly more warnings are returned.",
    )


class QuoteCreateV2Dto(BaseModel):
    name: constr(min_length=0, max_length=255)
    project: UidReference
    analyse: IdReference
    priceList: IdReference
    netRateScheme: IdReference | None = None
    provider: ProviderReference | None = None
    workflowSettings: List[QuoteWorkflowSettingDto] | None = None
    units: List[QuoteUnitsDto] | None = None
    additionalSteps: List[str] | None = None


class QACheckDtoV2Regex(QACheckDtoV2):
    rules: List[RegexpCheckRuleDtoV2] | None = None
    type: Literal["REGEX"] = "REGEX"


class SegmentWarningDtoRelativeTranslationLength(SegmentWarningDto):
    limit: str | None = None
    type: Literal["RelativeTranslationLength"] = "RelativeTranslationLength"


class SegmentWarningDtoRepeatedWord(SegmentWarningDto):
    word: str | None = None
    positions: List[Position] | None = None
    type: Literal["RepeatedWord"] = "RepeatedWord"


class SegmentWarningDtoRepeatedWords(SegmentWarningDto):
    repeatedWords: List[str] | None = None
    type: Literal["RepeatedWords"] = "RepeatedWords"


class ReplayRequestDto(BaseModel):
    webhookCalls: List[UidReference] | None = None


class RunAutoLqaDto(BaseModel):
    jobParts: List[UidReference] | None = Field(None, max_length=100, min_length=1)
    projectWorkflowStep: IdReference | None = None


class QACheckDtoV2String(QACheckDtoV2):
    ignorable: bool | None = None
    enabled: bool | None = None
    value: str | None = None
    instant: bool | None = None
    lock: bool | None = None
    type: Literal["STRING"] = "STRING"


class ScimResourceSchema(BaseModel):
    id: str | None = None
    name: str | None = None
    description: str | None = None
    attributes: List[Attribute] | None = None


class ScoringResultDto(BaseModel):
    jobPartUid: str | None = None
    score: float | None = None
    status: AssessmentResultEnum | None = None
    overallFeedback: str | None = None
    issueCounts: ScoringResultIssueCountsDto | None = None


class SearchJobsRequestDto(BaseModel):
    jobs: List[UidReference] = Field(
        ..., description="Max: 50 records", max_length=50, min_length=1
    )


class SearchRequestDto(BaseModel):
    query: str
    sourceLang: str
    targetLangs: List[str] | None = None
    previousSegment: str | None = None
    nextSegment: str | None = None
    tagMetadata: List[TagMetadataDto] | None = None
    trimQuery: bool | None = Field(
        True,
        description="Remove leading and trailing whitespace from query. Default: true",
    )
    phraseQuery: bool | None = Field(
        True, description="Return both wildcard and exact search results. Default: true"
    )


class SearchTMByJobRequestDto(BaseModel):
    segment: str
    workflowLevel: conint(ge=1, le=15) | None = None
    scoreThreshold: confloat(ge=0.0, le=1.01) | None = None
    previousSegment: str | None = None
    nextSegment: str | None = None
    contextKey: str | None = None
    maxSegments: conint(ge=0, le=5) | None = Field(None, description="Default: 5")
    maxSubSegments: conint(ge=0, le=5) | None = Field(None, description="Default: 5")
    tagMetadata: List[TagMetadataDto] | None = None


class SearchTMRequestDto(BaseModel):
    segment: str
    workflowLevel: conint(ge=1, le=15) | None = None
    scoreThreshold: confloat(ge=0.0, le=1.01) | None = None
    previousSegment: str | None = None
    nextSegment: str | None = None
    contextKey: str | None = None
    maxSegments: conint(ge=0, le=5) | None = Field(None, description="Default: 5")
    maxSubSegments: conint(ge=0, le=5) | None = Field(None, description="Default: 5")
    tagMetadata: List[TagMetadataDto] | None = None
    targetLangs: List[str] = Field(..., max_length=2147483647, min_length=1)


class SegmentDto(BaseModel):
    targetLang: str
    sourceSegment: str
    targetSegment: str
    previousSourceSegment: str | None = None
    nextSourceSegment: str | None = None
    sourceTagMetadata: List[TagMetadataDto] | None = None
    targetTagMetadata: List[TagMetadataDto] | None = None


class SegmentationRuleDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: constr(min_length=0, max_length=255)
    locale: str | None = None
    language: str | None = None
    primary: bool | None = Field(False, description="Default: false")
    filename: constr(min_length=0, max_length=255)
    dateCreated: AwareDatetime | None = None
    createdBy: ProtectedUserReference | None = None


class SegmentsCountsResponseDto(BaseModel):
    jobPartUid: str | None = None
    counts: SegmentsCountsDto | None = None
    previousWorkflow: PreviousWorkflowDto | None = None


class SegmentsCountsResponseListDto(BaseModel):
    segmentsCountsResults: List[SegmentsCountsResponseDto] | None = None


class ServiceProviderConfigDto(BaseModel):
    authenticationSchemes: List[AuthSchema] | None = None
    schemas: List[str] | None = None
    patch: Supported | None = None
    bulk: Supported | None = None
    filter: Supported | None = None
    changePassword: Supported | None = None
    sort: Supported | None = None
    etag: Supported | None = None
    xmlDataFormat: Supported | None = None


class SetProjectStatusDto(BaseModel):
    status: JobStatusEnum


class SetProjectTemplateTransMemoryV2Dto(BaseModel):
    transMemory: UidReference
    readMode: bool | None = Field(False, description="Default: false")
    writeMode: bool | None = Field(
        False,
        description="Can be set only for Translation Memory with read == true.<br/>\n        Max 2 write TMs allowed per project.<br/>\n        Default: false",
    )
    penalty: confloat(ge=0.0, le=100.0) | None = None
    applyPenaltyTo101Only: bool | None = Field(
        False, description="Can be set only for penalty == 1<br/>Default: false"
    )
    order: int | None = None


class SetProjectTransMemoryV3Dto(BaseModel):
    transMemory: UidReference
    readMode: bool | None = Field(False, description="Default: false")
    writeMode: bool | None = Field(
        False,
        description="Can be set only for Translation Memory with read == true.<br/>\n        Max 2 write TMs allowed per project.<br/>\n        Default: false",
    )
    penalty: confloat(ge=0.0, le=100.0) | None = None
    applyPenaltyTo101Only: bool | None = Field(
        False, description="Can be set only for penalty == 1<br/>Default: false"
    )
    order: int | None = None


class Sort(BaseModel):
    orders: List[Order] | None = None


class SpellCheckResponseDto(BaseModel):
    spellCheckResults: List[CheckResponse] | None = None


class StyleWeightsDto(BaseModel):
    style: ToggleableWeightDto | None = None
    awkward: ToggleableWeightDto | None = None
    companyStyle: ToggleableWeightDto | None = None
    inconsistentStyle: ToggleableWeightDto | None = None
    thirdPartyStyle: ToggleableWeightDto | None = None
    unidiomatic: ToggleableWeightDto | None = None


class SuggestResponse(BaseModel):
    word: str | None = None
    suggestions: List[SuggestionDto2] | None = None


class SuggestResponseDto(BaseModel):
    suggestResults: List[SuggestResponse] | None = None


class TMMatchSettingsDto(BaseModel):
    contextType: ContextTypeEnum | None = None
    prevOrNextSegment: bool | None = Field(False, description="Default: false")
    penalizeMultiContextMatch: bool | None = Field(False, description="Default: false")
    ignoreTagMetadata: bool | None = Field(True, description="Default: true")
    metadataPriority: MetadataPrioritySettingsDto | None = None


class TaskMappingDto(BaseModel):
    taskId: str | None = None
    workflowLevel: str | None = None
    resourcePath: str | None = None
    project: UidReference | None = None
    job: UidReference | None = None


class TermBaseSearchRequestDto(BaseModel):
    targetLangs: List[str]
    sourceLang: str
    query: str
    status: TermStatusEnum | None = None


class TermCreateByJobDto(BaseModel):
    text: str
    caseSensitive: bool | None = Field(False, description="Default: false")
    exactMatch: bool | None = Field(False, description="Default: false")
    forbidden: bool | None = Field(False, description="Default: false")
    preferred: bool | None = Field(False, description="Default: false")
    usage: str | None = None
    note: str | None = None
    shortTranslation: str | None = None
    termType: TermTypeEnum | None = None
    partOfSpeech: TermPartOfSpeechEnum | None = None
    gender: TermGenderEnum | None = None
    number: TermNumberEnum | None = None


class TermCreateDto(BaseModel):
    text: str
    lang: str
    caseSensitive: bool | None = Field(False, description="Default: false")
    exactMatch: bool | None = Field(False, description="Default: false")
    forbidden: bool | None = Field(False, description="Default: false")
    preferred: bool | None = Field(False, description="Default: false")
    status: TermStatusEnum | None = None
    conceptId: str | None = None
    usage: str | None = None
    note: str | None = None
    shortTranslation: str | None = None
    termType: TermTypeEnum | None = None
    partOfSpeech: TermPartOfSpeechEnum | None = None
    gender: TermGenderEnum | None = None
    number: TermNumberEnum | None = None
    customFields: List[CustomFieldValueDto] | None = None


class TermEditDto(BaseModel):
    text: str
    lang: str | None = None
    caseSensitive: bool | None = Field(False, description="Default: false")
    exactMatch: bool | None = Field(False, description="Default: false")
    forbidden: bool | None = Field(False, description="Default: false")
    preferred: bool | None = Field(False, description="Default: false")
    status: TermStatusEnum | None = None
    usage: str | None = None
    note: str | None = None
    shortTranslation: str | None = None
    termType: TermTypeEnum | None = None
    partOfSpeech: TermPartOfSpeechEnum | None = None
    gender: TermGenderEnum | None = None
    number: TermNumberEnum | None = None
    customFields: List[CustomFieldValueDto] | None = None


class TerminologyWeightsDto(BaseModel):
    terminology: ToggleableWeightDto | None = None
    inconsistentWithTb: ToggleableWeightDto | None = None
    inconsistentUseOfTerminology: ToggleableWeightDto | None = None


class TranslationPriceDto(BaseModel):
    workflowStep: WorkflowStepDto | None = None
    price: float | None = None


class TranslationPriceListCreateDto(BaseModel):
    name: str
    currencyCode: str
    billingUnit: BillingUnitEnum | None = None
    isDefault: bool | None = Field(False, description="Default: false")


class TranslationPriceSetDto(BaseModel):
    sourceLang: str | None = None
    targetLang: str | None = None
    minimumPrice: float | None = None
    prices: List[TranslationPriceDto] | None = None


class TranslationPriceSetListDto(BaseModel):
    priceSets: List[TranslationPriceSetDto] | None = None


class UpdateCustomFieldDto(BaseModel):
    name: constr(min_length=0, max_length=255)
    allowedEntities: List[EntityTypeEnum]
    required: bool | None = None
    description: constr(min_length=0, max_length=500) | None = None
    addOptions: List[str] | None = None
    removeOptions: List[UidReference] | None = None
    deprecateOptions: List[UidReference] | None = None
    undeprecateOptions: List[UidReference] | None = None


class UpdateCustomFieldInstancesDto(BaseModel):
    addInstances: List[CreateCustomFieldInstanceDto] | None = None
    removeInstances: List[UidReference] | None = None
    updateInstances: List[UpdateCustomFieldInstanceWithUidDto] | None = None


class UpdateIgnoredChecksDto(BaseModel):
    segment: SegmentReference
    warningTypes: List[QualityChecksEnum] = Field(..., max_length=100, min_length=1)


class UpdateIgnoredSegment(BaseModel):
    uid: str
    warnings: List[UpdateIgnoredWarning] = Field(..., max_length=100, min_length=1)


class UpdateIgnoredSegment2(BaseModel):
    uid: str
    warnings: List[UpdateIgnoredWarning2] = Field(..., max_length=100, min_length=1)


class UpdateIgnoredWarningsDto(BaseModel):
    segments: List[UpdateIgnoredSegment] = Field(..., max_length=500, min_length=1)


class UserReference(BaseModel):
    firstName: str | None = None
    lastName: str | None = None
    userName: str | None = None
    email: str | None = None
    role: UserRoleRefEnum | None = None
    id: str | None = None
    uid: str | None = None


class UserReference2(BaseModel):
    firstName: str | None = None
    lastName: str | None = None
    userName: str | None = None
    email: str | None = None
    role: UserRoleRefEnum | None = None
    id: str | None = None
    uid: str | None = None


class UserReferencesDto(BaseModel):
    users: List[UserReference] | None = None


class QACheckDtoV2Void(QACheckDtoV2):
    ignorable: bool | None = None
    enabled: bool | None = None
    instant: bool | None = None
    lock: bool | None = None
    type: Literal["VOID"] = "VOID"


class WebHookDtoV2(BaseModel):
    name: str | None = None
    id: str | None = None
    uid: str | None = None
    url: str
    events: List[WebHookEventEnum] | None = None
    secretToken: constr(min_length=1, max_length=255) | None = None
    secretTokenType: WebHookSecretTokenTypeEnum | None = None
    hidden: bool | None = Field(False, description="Default: false")
    status: WebHookStatusEnum | None = None
    failedAttempts: int | None = None
    created: AwareDatetime | None = None
    createdBy: UserReference | None = None
    lastModified: AwareDatetime | None = None
    lastModifiedBy: UserReference | None = None


class WebhookCallDto(BaseModel):
    uid: str | None = None
    parentUid: str | None = None
    eventUid: str | None = None
    webhookSettings: UidReference | None = None
    createdAt: AwareDatetime | None = None
    url: str | None = None
    forced: bool | None = None
    lastForcedAt: AwareDatetime | None = None
    body: str | None = None
    triggerEvent: WebHookEventEnum | None = None
    retryAttempt: int | None = None
    statusCode: int | None = None
    errorMessage: str | None = None


class WebhookPreviewDto(BaseModel):
    event: WebHookEventEnum | None = None
    preview: str | None = None


class WebhookPreviewsDto(BaseModel):
    previews: List[WebhookPreviewDto] | None = None


class WorkflowStepConfiguration(BaseModel):
    id: str | None = None
    assignments: List[ProvidersPerLanguage]
    due: AwareDatetime | None = Field(None, description="Use ISO 8601 date format.")
    notifyProvider: NotifyProviderDto | None = None


class WorkflowStepSettingsDto(BaseModel):
    workflowStep: WorkflowStepReference | None = None
    assignedTo: List[ProjectTemplateWorkflowSettingsAssignedToDto] | None = None
    notifyProvider: ProjectTemplateNotifyProviderDto | None = None
    lqaProfile: UidReference | None = None


class WorkflowStepSettingsEditDto(BaseModel):
    workflowStep: IdReference | None = None
    assignedTo: List[ProjectTemplateWorkflowSettingsAssignedToDto] | None = None
    notifyProvider: NotifyProviderDto | None = None
    lqaProfile: UidReference | None = None


class WorkflowStepSettingsEditV2Dto(BaseModel):
    workflowStep: IdReference | None = None
    assignedTo: List[ProjectTemplateWorkflowSettingsAssignedToDto] | None = None
    notifyProvider: NotifyProviderDto | None = None
    lqaProfile: UidReference | None = None


class XlsSettingsDto(BaseModel):
    sheetNames: bool | None = Field(False, description="Default: false")
    hidden: bool | None = Field(False, description="Default: false")
    comments: bool | None = Field(False, description="Default: false")
    other: bool | None = Field(False, description="Default: false")
    cellFlow: CellFlowEnum | None = None
    htmlSubfilter: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    specifiedColumns: str | None = None


class XmlAssistantProfileListDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    description: str | None = None
    createdAt: AwareDatetime | None = None
    createdBy: ProtectedUserReference | None = None
    updatedAt: AwareDatetime | None = None
    updatedBy: ProtectedUserReference | None = None


class XmlSettingsDto(BaseModel):
    rulesFormat: RulesFormatEnum | None = None
    includeElementsPlain: str | None = Field(
        None, description='Default: `"*"`, example: `"para,heading"`'
    )
    excludeElementsPlain: str | None = Field(
        None, description='Example: `"script,par"`'
    )
    includeAttributesPlain: str | None = Field(None, description='Example: `"title"`')
    excludeAttributesPlain: str | None = Field(
        None, description='Example: `"lang,href"`'
    )
    inlineElementsNonTranslatablePlain: str | None = Field(
        None, description='Example: `"tt,b"`'
    )
    inlineElementsPlain: str | None = None
    inlineElementsAutoPlain: bool | None = Field(None, description="Default: `false`")
    htmlSubfilterElementsPlain: str | None = Field(
        None, description='Example: `"tt,b"`'
    )
    entities: bool | None = Field(None, description="Default: `false`")
    lockElementsPlain: str | None = None
    lockAttributesPlain: str | None = None
    includeXPath: str | None = None
    inlineElementsXpath: str | None = None
    inlineElementsNonTranslatableXPath: str | None = None
    inlineElementsAutoXPath: bool | None = Field(None, description="Default: `false`")
    htmlSubfilterElementsXpath: str | None = None
    lockXPath: str | None = None
    segmentation: bool | None = Field(None, description="Default: `true`")
    tagRegexp: str | None = None
    contextNoteXpath: str | None = None
    maxLenXPath: str | None = None
    preserveWhitespaceXPath: str | None = None
    preserveCharEntities: str | None = None
    contextKeyXPath: str | None = None
    xslUrl: str | None = None
    xslFile: str | None = Field(
        None, description="UID of uploaded XSL file, overrides `xslUrl`"
    )
    importComments: bool | None = Field(None, description="Default: `true`")
    icuSubFilter: bool | None = Field(None, description="Default: `false`")
    assistantProfile: str | None = None
    segmentationExcludedElementsXpath: str | None = None
    segmentationExclude: bool | None = Field(None, description="Default: `false`")
    expandEntities: bool | None = Field(None, description="Default: `false`")


class YamlSettingsDto(BaseModel):
    htmlSubFilter: bool | None = Field(False, description="Default: false")
    tagRegexp: str | None = None
    includeKeyRegexp: str | None = None
    excludeValueRegexp: str | None = None
    contextPath: str | None = None
    contextKeyPath: str | None = None
    markdownSubfilter: bool | None = Field(False, description="Default: false")
    updateRootElementLang: bool | None = Field(False, description="Default: false")
    localeFormat: LocaleFormatEnum | None = None
    indentEmptyLinesInString: bool | None = Field(True, description="Default: true")
    icuSubFilter: bool | None = Field(None, description="Default: `false`")


class UserCreateDto(
    RootModel[
        UserCreateDtoAdmin
        | UserCreateDtoGuest
        | UserCreateDtoLinguist
        | UserCreateDtoPortalMember
        | UserCreateDtoProjectManager
        | UserCreateDtoSubmitter
    ]
):
    root: (
        UserCreateDtoAdmin
        | UserCreateDtoGuest
        | UserCreateDtoLinguist
        | UserCreateDtoPortalMember
        | UserCreateDtoProjectManager
        | UserCreateDtoSubmitter
    ) = Field(..., discriminator="role", title="UserCreateDto")


class UserEditDto(
    RootModel[
        UserEditDtoAdmin
        | UserEditDtoGuest
        | UserEditDtoLinguist
        | UserEditDtoPortalMember
        | UserEditDtoProjectManager
        | UserEditDtoSubmitter
    ]
):
    root: (
        UserEditDtoAdmin
        | UserEditDtoGuest
        | UserEditDtoLinguist
        | UserEditDtoPortalMember
        | UserEditDtoProjectManager
        | UserEditDtoSubmitter
    ) = Field(..., discriminator="role", title="UserEditDto")


class SegmentWarningDtoUnion(
    RootModel[
        SegmentWarningDtoAbsoluteTranslationLength
        | SegmentWarningDtoCustomQA
        | SegmentWarningDtoEmptyPairTags
        | SegmentWarningDtoEmptyTagContent
        | SegmentWarningDtoEmptyTranslation
        | SegmentWarningDtoExtraNumbersV3
        | SegmentWarningDtoExtraNumbers
        | SegmentWarningDtoForbiddenString
        | SegmentWarningDtoForbiddenTerm
        | SegmentWarningDtoFormatting
        | SegmentWarningDtoFuzzyInconsistency
        | SegmentWarningDtoInconsistentTagContent
        | SegmentWarningDtoInconsistentTranslation
        | SegmentWarningDtoJoinTags
        | SegmentWarningDtoLeadingAndTrailingSpaces
        | SegmentWarningDtoMalformed
        | SegmentWarningDtoMissingNonTranslatableAnnotation
        | SegmentWarningDtoMissingNumbersV3
        | SegmentWarningDtoMissingNumbers
        | SegmentWarningDtoMoravia
        | SegmentWarningDtoMultipleSpacesV3
        | SegmentWarningDtoMultipleSpaces
        | SegmentWarningDtoNestedTags
        | SegmentWarningDtoNewerAtLowerLevel
        | SegmentWarningDtoNonConformingTerm
        | SegmentWarningDtoNotConfirmed
        | SegmentWarningDtoRelativeTranslationLength
        | SegmentWarningDtoRepeatedWord
        | SegmentWarningDtoRepeatedWords
        | SegmentWarningDtoSourceTargetRegexp
        | SegmentWarningDtoSpellCheck
        | SegmentWarningDtoTargetSourceIdentical
        | SegmentWarningDtoTerminology
        | SegmentWarningDtoTrailingPunctuation
        | SegmentWarningDtoTrailingSpace
        | SegmentWarningDtoTranslationLength
        | SegmentWarningDtoUnmodifiedFuzzyTranslationMTNT
        | SegmentWarningDtoUnmodifiedFuzzyTranslationTM
        | SegmentWarningDtoUnmodifiedFuzzyTranslation
        | SegmentWarningDtoUnresolvedComment
        | SegmentWarningDtoUnresolvedConversation
    ]
):
    root: (
        SegmentWarningDtoAbsoluteTranslationLength
        | SegmentWarningDtoCustomQA
        | SegmentWarningDtoEmptyPairTags
        | SegmentWarningDtoEmptyTagContent
        | SegmentWarningDtoEmptyTranslation
        | SegmentWarningDtoExtraNumbersV3
        | SegmentWarningDtoExtraNumbers
        | SegmentWarningDtoForbiddenString
        | SegmentWarningDtoForbiddenTerm
        | SegmentWarningDtoFormatting
        | SegmentWarningDtoFuzzyInconsistency
        | SegmentWarningDtoInconsistentTagContent
        | SegmentWarningDtoInconsistentTranslation
        | SegmentWarningDtoJoinTags
        | SegmentWarningDtoLeadingAndTrailingSpaces
        | SegmentWarningDtoMalformed
        | SegmentWarningDtoMissingNonTranslatableAnnotation
        | SegmentWarningDtoMissingNumbersV3
        | SegmentWarningDtoMissingNumbers
        | SegmentWarningDtoMoravia
        | SegmentWarningDtoMultipleSpacesV3
        | SegmentWarningDtoMultipleSpaces
        | SegmentWarningDtoNestedTags
        | SegmentWarningDtoNewerAtLowerLevel
        | SegmentWarningDtoNonConformingTerm
        | SegmentWarningDtoNotConfirmed
        | SegmentWarningDtoRelativeTranslationLength
        | SegmentWarningDtoRepeatedWord
        | SegmentWarningDtoRepeatedWords
        | SegmentWarningDtoSourceTargetRegexp
        | SegmentWarningDtoSpellCheck
        | SegmentWarningDtoTargetSourceIdentical
        | SegmentWarningDtoTerminology
        | SegmentWarningDtoTrailingPunctuation
        | SegmentWarningDtoTrailingSpace
        | SegmentWarningDtoTranslationLength
        | SegmentWarningDtoUnmodifiedFuzzyTranslationMTNT
        | SegmentWarningDtoUnmodifiedFuzzyTranslationTM
        | SegmentWarningDtoUnmodifiedFuzzyTranslation
        | SegmentWarningDtoUnresolvedComment
        | SegmentWarningDtoUnresolvedConversation
    ) = Field(..., discriminator="type", title="SegmentWarningDtoUnion")


class AnalyseJobDto(BaseModel):
    uid: str | None = None
    filename: str | None = None
    data: DataDtoV1 | None = None
    discountedData: DataDtoV1 | None = None


class AnalyseLanguagePartDto(BaseModel):
    id: str | None = None
    sourceLang: str | None = None
    targetLang: str | None = None
    data: DataDtoV1 | None = None
    discountedData: DataDtoV1 | None = None
    jobs: List[AnalyseJobReference] | None = Field(
        None,
        description='Max of 100 jobs returned, use "List jobs of analyses" to get all',
    )


class AnalyseLanguagePartV2Dto(BaseModel):
    id: str | None = None
    sourceLang: str | None = None
    targetLang: str | None = None
    data: DataDto | None = None
    discountedData: DataDto | None = None
    jobs: List[AnalyseJobReference] | None = Field(
        None,
        description='Max of 100 jobs returned, use "List jobs of analyses" to get all',
    )


class AnalyseLanguagePartV3Dto(BaseModel):
    id: str | None = None
    sourceLang: str | None = None
    targetLang: str | None = None
    data: DataDto2 | None = None
    discountedData: DataDto2 | None = None
    jobs: List[AnalyseJobReference] | None = Field(
        None,
        description='Max of 100 jobs returned, use "List jobs of analyses" to get all',
    )
    transMemories: List[TransMemoryReferenceDtoV2] | None = None


class AssignedJobDto(BaseModel):
    uid: str | None = None
    innerId: str | None = None
    filename: str | None = None
    dateDue: AwareDatetime | None = None
    dateCreated: AwareDatetime | None = None
    status: JobStatusEnum2 | None = None
    targetLang: str | None = None
    sourceLang: str | None = None
    project: ProjectReference | None = None
    workflowStep: ProjectWorkflowStepReference | None = None
    importStatus: ImportStatusDto | None = None
    imported: bool | None = None


class AsyncFileOpResponseDto(BaseModel):
    id: str | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    fileName: str | None = None
    action: ActionEnum | None = None


class AsyncRequestDto(BaseModel):
    id: str | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    action: AsyncActionEnum | None = None
    asyncResponse: AsyncResponseDto | None = None
    parent: AsyncRequestDto | None = None
    project: ProjectReference | None = None


class AsyncRequestV2Dto(BaseModel):
    id: str | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    action: AsyncActionEnum | None = None
    asyncResponse: AsyncResponseV2Dto | None = None
    parent: AsyncRequestV2Dto | None = None
    project: ProjectReference | None = None


class AsyncRequestWrapperDto(BaseModel):
    asyncRequest: AsyncRequestDto | None = None


class AsyncRequestWrapperV2Dto(BaseModel):
    asyncRequest: AsyncRequestV2Dto | None = None
    reference: AsyncRequestReferenceDto | None = None


class BackgroundTasksTbDto(BaseModel):
    status: str | None = None
    finishedDataText: str | None = None
    asyncRequest: AsyncRequestDto | None = None
    lastTaskString: str | None = None
    metadata: MetadataResponse | None = None
    lastTaskOk: str | None = None
    lastTaskError: str | None = None
    lastTaskErrorHtml: str | None = None
    dateCreated: AwareDatetime | None = None
    dateFinished: AwareDatetime | None = None


class BackgroundTasksTmDto(BaseModel):
    status: str | None = None
    finishedDataText: str | None = None
    asyncRequest: AsyncRequestDto | None = None
    lastTaskString: str | None = None
    metadata: MetadataResponse2 | None = None
    lastTaskOk: str | None = None
    lastTaskError: str | None = None
    lastTaskErrorHtml: str | None = None


class BusinessUnitDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    createdBy: ProtectedUserReference | None = None


class BuyerDto(BaseModel):
    uid: str | None = None
    defaultProjectOwner: UserReference2 | None = None
    vendorOrganization: OrganizationReference | None = None


class ConceptListResponseDto(BaseModel):
    concepts: List[ConceptWithMetadataDto] | None = None
    totalCount: int | None = None


class ConnectorAsyncTaskStatesDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ConnectorAsyncTaskStateDto] | None = None
    sort: Sort | None = None
    successCount: int | None = None
    errorCount: int | None = None
    projectUid: str | None = None
    projectName: str | None = None


class CostCenterDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    createdBy: UserReference | None = None


class CreateAnalyseAsyncV2Dto(BaseModel):
    jobs: List[UidReference] = Field(
        ...,
        description="Job uids of jobs from the same project",
        max_length=50000,
        min_length=1,
    )
    jobFilter: JobFilterDto | None = None
    type: CreateAnalyseAsyncV2Enum | None = None
    includeFuzzyRepetitions: bool | None = Field(True, description="Default: true")
    separateFuzzyRepetitions: bool | None = Field(False, description="Default: false")
    includeConfirmedSegments: bool | None = Field(True, description="Default: true")
    includeNotConfirmedSegments: bool | None = Field(True, description="Default: true")
    includeNumbers: bool | None = Field(True, description="Default: true")
    includeLockedSegments: bool | None = Field(True, description="Default: true")
    countSourceUnits: bool | None = Field(True, description="Default: true")
    includeTransMemory: bool | None = Field(
        True, description="Default: true. Works only for type=PreAnalyse."
    )
    includeNonTranslatables: bool | None = Field(
        False, description="Default: false. Works only for type=PreAnalyse."
    )
    includeMachineTranslationMatches: bool | None = Field(
        False, description="Default: false. Works only for type=PreAnalyse."
    )
    transMemoryPostEditing: bool | None = Field(
        False, description="Default: false. Works only for type=PostAnalyse."
    )
    nonTranslatablePostEditing: bool | None = Field(
        False, description="Default: false. Works only for type=PostAnalyse."
    )
    machineTranslatePostEditing: bool | None = Field(
        False, description="Default: false. Works only for type=PostAnalyse."
    )
    analyzeByProvider: bool | None = Field(
        False, description="Default: false.", examples=[False]
    )
    analyzeByLanguage: bool | None = Field(
        False, description="Default: false.", examples=[False]
    )
    name: constr(min_length=0, max_length=255) | None = None
    netRateScheme: IdReference | None = None
    compareWorkflowLevel: conint(ge=1, le=15) | None = Field(
        None, description="Required for type=Compare"
    )
    useProjectAnalysisSettings: bool | None = Field(
        False,
        description="Default: false. Use default project settings. Will be overwritten with setting sent\n        in the API call.",
    )
    callbackUrl: str | None = None
    provider: ProviderReference | None = None
    skipMtScoreThreshold: float | None = Field(
        None,
        description="Used only for Default analysis. Threshold above which the MT suggestions are not used. Default: value from PreTranslate settings",
    )


class CreatePlainConversationDto(BaseModel):
    comment: AddCommentDto | None = None
    references: PlainReferences


class CreateProjectV3Dto(BaseModel):
    name: constr(min_length=0, max_length=255)
    sourceLang: str
    targetLangs: List[str]
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    costCenter: IdReference | None = None
    purchaseOrder: constr(min_length=0, max_length=255) | None = None
    workflowSteps: List[IdReference] | None = None
    dateDue: AwareDatetime | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    lqaProfiles: List[LqaProfilesForWsV2Dto] | None = Field(
        None, description="Lqa profiles that will be added to workflow steps"
    )
    customFields: List[CustomFieldInstanceApiDto] | None = Field(
        None, description="Custom fields for project"
    )
    fileHandover: bool | None = Field(False, description="Default: false")
    propagateTranslationsToLowerWfDuringUpdateSource: bool | None = Field(
        False, description="Default: false"
    )


class CreateTermsDto(BaseModel):
    sourceTerm: TermCreateByJobDto
    targetTerm: TermCreateByJobDto


class CustomFieldDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    type: CustomFieldTypeEnum | None = None
    allowedEntities: List[EntityTypeEnum] | None = None
    options: CustomFieldOptionsTruncatedDto | None = None
    createdAt: AwareDatetime | None = None
    createdBy: UserReference | None = None
    lastModified: AwareDatetime | None = None
    lastModifiedBy: UserReference | None = None
    requiredFrom: AwareDatetime | None = None
    required: bool | None = None
    description: str | None = None


class CustomFieldInstanceDto(BaseModel):
    uid: str | None = None
    customField: CustomFieldDto | None = None
    selectedOptions: List[CustomFieldOptionDto] | None = None
    value: str | None = None
    createdAt: AwareDatetime | None = None
    createdBy: UidReference | None = None
    updatedAt: AwareDatetime | None = None
    updatedBy: UidReference | None = None


class CustomFieldInstancesDto(BaseModel):
    customFieldInstances: List[CustomFieldInstanceDto] | None = None


class DiscountSchemeReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None


class DiscountSchemeReference3(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference2 | None = None


class DomainDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    createdBy: UserReference | None = None


class EditProjectV2Dto(BaseModel):
    name: constr(min_length=0, max_length=255)
    status: JobStatusEnum | None = None
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    owner: IdReference | None = None
    purchaseOrder: constr(min_length=0, max_length=255) | None = None
    dateDue: AwareDatetime | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    fileHandover: bool | None = Field(False, description="Default: false")
    propagateTranslationsToLowerWfDuringUpdateSource: bool | None = Field(
        False, description="Default: false"
    )
    lqaProfiles: List[LqaProfilesForWsV2Dto] | None = Field(
        None, description="Lqa profiles that will be added to workflow steps"
    )
    archived: bool | None = Field(False, description="Default: false")
    customFields: List[CustomFieldInstanceApiDto] | None = Field(
        None, description="Custom fields for project"
    )


class EditProjectV3Dto(BaseModel):
    name: constr(min_length=0, max_length=255)
    status: JobStatusEnum | None = None
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    costCenter: IdReference | None = None
    subDomain: IdReference | None = None
    owner: IdReference | None = None
    purchaseOrder: constr(min_length=0, max_length=255) | None = None
    dateDue: AwareDatetime | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    fileHandover: bool | None = Field(False, description="Default: false")
    propagateTranslationsToLowerWfDuringUpdateSource: bool | None = Field(
        False, description="Default: false"
    )
    lqaProfiles: List[LqaProfilesForWsV3Dto] | None = Field(
        None, description="Lqa profiles that will be added to workflow steps"
    )
    archived: bool | None = Field(False, description="Default: false")
    customFields: List[CustomFieldInstanceApiV3Dto] | None = Field(
        None, description="Custom fields for project"
    )


class ErrorCategoriesDto(BaseModel):
    accuracy: AccuracyWeightsDto | None = None
    fluency: FluencyWeightsDto | None = None
    terminology: TerminologyWeightsDto | None = None
    style: StyleWeightsDto | None = None
    localeConvention: LocaleConventionWeightsDto | None = None
    verity: VerityWeightsDto | None = None
    design: DesignWeightsDto | None = None
    other: OtherWeightsDto | None = None


class FileImportSettingsCreateDto(BaseModel):
    inputCharset: str | None = None
    outputCharset: str | None = None
    zipCharset: str | None = None
    fileFormat: FileFormatEnum | None = None
    autodetectMultilingualFiles: bool | None = Field(
        True,
        description="Try to use multilingual variants for auto-detected CSV and Excel files. Default: true",
    )
    targetLength: bool | None = Field(False, description="Default: false")
    targetLengthMax: int | None = Field(None, description="default: 1000")
    targetLengthPercent: bool | None = Field(False, description="Default: false")
    targetLengthPercentValue: float | None = Field(None, description="default: 130")
    segmentationRuleId: int | None = None
    targetSegmentationRuleId: int | None = None
    android: AndroidSettingsDto | None = None
    csv: CsvSettingsDto | None = None
    dita: DitaSettingsDto | None = None
    docBook: DocBookSettingsDto | None = None
    doc: DocSettingsDto | None = None
    html: HtmlSettingsDto | None = None
    idml: IdmlSettingsDto | None = None
    json_: JsonSettingsDto | None = Field(None, alias="json")
    mac: MacSettingsDto | None = None
    md: MdSettingsDto | None = None
    mif: MifSettingsDto | None = None
    multilingualXls: MultilingualXlsSettingsDto | None = None
    multilingualCsv: MultilingualCsvSettingsDto | None = None
    multilingualXml: MultilingualXmlSettingsDto | None = None
    pdf: PdfSettingsDto | None = None
    php: PhpSettingsDto | None = None
    po: PoSettingsDto | None = None
    ppt: PptSettingsDto | None = None
    properties: PropertiesSettingsDto | None = None
    psd: PsdSettingsDto | None = None
    quarkTag: QuarkTagSettingsDto | None = None
    resx: ResxSettingsDto | None = None
    sdlXlf: SdlXlfSettingsDto | None = None
    tmMatch: TMMatchSettingsDto | None = None
    ttx: TtxSettingsDto | None = None
    txt: TxtSettingsDto | None = None
    xlf2: Xlf2SettingsDto | None = None
    xlf: XlfSettingsDto | None = None
    xls: XlsSettingsDto | None = None
    xml: XmlSettingsDto | None = None
    yaml: YamlSettingsDto | None = None
    asciidoc: AsciidocSettingsDto | None = None


class FileImportSettingsDto(BaseModel):
    inputCharset: str | None = None
    outputCharset: str | None = None
    zipCharset: str | None = None
    fileFormat: str | None = None
    autodetectMultilingualFiles: bool | None = None
    targetLength: bool | None = None
    targetLengthMax: int | None = None
    targetLengthPercent: bool | None = None
    targetLengthPercentValue: float | None = None
    android: AndroidSettingsDto | None = None
    idml: IdmlSettingsDto | None = None
    xls: XlsSettingsDto | None = None
    multilingualXml: MultilingualXmlSettingsDto | None = None
    php: PhpSettingsDto | None = None
    resx: ResxSettingsDto | None = None
    json_: JsonSettingsDto | None = Field(None, alias="json")
    html: HtmlSettingsDto | None = None
    multilingualXls: MultilingualXlsSettingsDto | None = None
    multilingualCsv: MultilingualCsvSettingsDto | None = None
    csv: CsvSettingsDto | None = None
    txt: TxtSettingsDto | None = None
    xlf2: Xlf2SettingsDto | None = None
    quarkTag: QuarkTagSettingsDto | None = None
    pdf: PdfSettingsDto | None = None
    tmMatch: TMMatchSettingsDto | None = None
    xml: XmlSettingsDto | None = None
    mif: MifSettingsDto | None = None
    properties: PropertiesSettingsDto | None = None
    doc: DocSettingsDto | None = None
    xlf: XlfSettingsDto | None = None
    sdlXlf: SdlXlfSettingsDto | None = None
    ttx: TtxSettingsDto | None = None
    ppt: PptSettingsDto | None = None
    yaml: YamlSettingsDto | None = None
    dita: DitaSettingsDto | None = None
    docBook: DocBookSettingsDto | None = None
    po: PoSettingsDto | None = None
    mac: MacSettingsDto | None = None
    md: MdSettingsDto | None = None
    psd: PsdSettingsDto | None = None
    asciidoc: AsciidocSettingsDto | None = None
    segRule: SegRuleReference | None = None
    targetSegRule: SegRuleReference | None = None


class ImportSettingsCreateDto(BaseModel):
    name: str
    fileImportSettings: FileImportSettingsCreateDto


class ImportSettingsDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    fileImportSettings: FileImportSettingsDto | None = None


class ImportSettingsEditDto(BaseModel):
    uid: str
    name: str
    fileImportSettings: FileImportSettingsCreateDto


class ImportSettingsReference(BaseModel):
    uid: str | None = None
    name: str | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None


class JobCreateRequestDto(BaseModel):
    targetLangs: List[str]
    due: AwareDatetime | None = Field(
        None,
        description="only use for projects without workflows; otherwise specify in the workflowSettings object. Use ISO 8601 date format.",
    )
    workflowSettings: List[WorkflowStepConfiguration] | None = None
    assignments: List[ProvidersPerLanguage] | None = Field(
        None,
        description="only use for projects without workflows; otherwise specify in the workflowSettings object",
    )
    importSettings: UidReference | None = None
    useProjectFileImportSettings: bool | None = Field(
        False, description="Default: false"
    )
    preTranslate: bool | None = None
    semanticMarkup: bool | None = None
    notifyProvider: NotifyProviderDto | None = None
    callbackUrl: str | None = None
    path: constr(min_length=0, max_length=255) | None = None
    remoteFile: JobCreateRemoteFileDto | None = None
    jobPreviewPackageFileUidRef: UidReference | None = None
    xmlAssistantProfile: UidReference | None = None


class JobListDto(BaseModel):
    unsupportedFiles: List[str] | None = None
    jobs: List[JobPartReference] | None = None
    asyncRequest: AsyncRequestReference | None = None


class JobPartPatchBatchDto(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=100, min_length=1)
    status: JobStatusEnum2 | None = None
    dateDue: AwareDatetime | None = None
    clearDateDue: bool | None = None
    providers: List[ProviderReference] | None = None
    customFields: UpdateCustomFieldInstancesDto | None = None


class JobPartReadyDeleteTranslationDto(BaseModel):
    jobs: List[UidReference] | None = Field(None, max_length=100, min_length=1)
    deleteSettings: TranslationSegmentsReferenceV2 | None = None
    forAllJobs: bool | None = Field(
        False,
        description="Set true if you want to delete translations for all jobs from project from specific workflow step.\n               Default: false",
    )
    workflowLevel: int | None = Field(
        None, description="Specifies workflow level for all jobs"
    )
    filter: JobPartReadyDeleteTranslationFilterDto | None = None


class JobPartReferenceV2(BaseModel):
    uid: str | None = None
    innerId: str | None = Field(
        None,
        description="InnerId is a sequential number of a job in a project.\n            Jobs created from the same file share the same innerId across workflow steps",
    )
    status: JobStatusEnum2 | None = None
    providers: List[ProviderReference] | None = None
    targetLang: str | None = None
    workflowStep: ProjectWorkflowStepReference | None = None
    filename: str | None = None
    originalFileDirectory: str | None = None
    dateDue: AwareDatetime | None = None
    dateCreated: AwareDatetime | None = None
    importStatus: ImportStatusDtoV2 | None = None
    continuous: bool | None = None
    sourceFileUid: str | None = None
    split: bool | None = None
    serverTaskId: str | None = None
    owner: UserReference | None = None
    remoteFile: JobRemoteFileReference | None = None
    imported: bool | None = Field(False, description="Default: false")


class JobPartStatusChangeDto(BaseModel):
    status: JobStatusEnum2 | None = None
    changedDate: AwareDatetime | None = None
    changedBy: UserReference | None = None


class JobPartStatusChangesDto(BaseModel):
    statusChanges: List[JobPartStatusChangeDto] | None = None


class JobPreviewPackageDto(BaseModel):
    uid: str | None = None
    fileUid: str | None = None
    fileName: str | None = None
    organizationRef: OrganizationReference2 | None = None
    projectUidRef: UidReference | None = None
    taskId: str | None = None
    jobUidRef: UidReference | None = None
    createdByRef: UserReference2 | None = None
    dateCreated: AwareDatetime | None = None


class JobReference(BaseModel):
    uid: str | None = None
    jobUid: str | None = None
    filename: str | None = None
    sourceLocale: str | None = None
    targetLocale: str | None = None
    sourceLang: str | None = None
    targetLang: str | None = None
    wordCount: int | None = None
    progress: int | None = None
    level: int | None = None
    dueDate: AwareDatetime | None = None
    createdDate: AwareDatetime | None = None
    jobCreatedDate: AwareDatetime | None = None
    lastModifiedDate: AwareDatetime | None = None
    status: str | None = None
    project: ProjectReference2 | None = None
    createdBy: UserReference4 | None = None
    owner: UserReference4 | None = None
    providers: List[ProviderReference2] | None = None
    workflowStep: WorkflowStepReference2 | None = None
    continuous: bool | None = None
    lqaScore: bool | None = None
    settings: SettingsReference | None = None
    warnings: List[str] | None = None
    errors: ErrorsReference | None = None
    jobMetadata: List[MetadataReference] | None = None


class JobRoleDto(BaseModel):
    type: JobRoleTypeEnum
    workflowStep: ProjectWorkflowStepDtoV2 | None = None
    organizationType: OrganizationTypeEnum | None = None


class JobSegmentDto(BaseModel):
    id: str | None = None
    source: str | None = None
    translation: str | None = None
    createdAt: int | None = None
    modifiedAt: int | None = None
    createdBy: UserReference | None = None
    modifiedBy: UserReference | None = None
    workflowLevel: int | None = None
    workflowStep: WorkflowStepDto | None = None


class LastLoginDto(BaseModel):
    user: UserReference | None = None
    lastLoginDate: AwareDatetime | None = None


class LoginResponseDto(BaseModel):
    user: UserReference | None = None
    token: str | None = None
    expires: AwareDatetime | None = None
    lastInvalidateAllSessionsPerformed: AwareDatetime | None = None


class LoginResponseV3Dto(BaseModel):
    user: UserReference | None = None
    token: str | None = None
    expires: AwareDatetime | None = None
    lastInvalidateAllSessionsPerformed: AwareDatetime | None = None


class LoginToSessionResponseDto(BaseModel):
    user: UserReference | None = None
    cookie: str | None = None
    csrfToken: str | None = None


class LoginToSessionResponseV3Dto(BaseModel):
    user: UserReference | None = None
    cookie: str | None = None
    csrfToken: str | None = None


class LqaProfileAssessmentDto(BaseModel):
    uid: str = Field(..., description="UID of the profile", examples=["string"])
    name: str = Field(..., description="Name of the profile")
    errorCategories: ErrorCategoriesDto
    penaltyPoints: PenaltyPointsDto
    passFailThreshold: PassFailThresholdDto
    isDefault: bool = Field(
        ..., description="If profile is set as default for organization"
    )
    dateCreated: AwareDatetime
    organization: UidReference


class LqaProfileDetailDto(BaseModel):
    uid: str = Field(..., description="UID of the profile", examples=["string"])
    name: str = Field(..., description="Name of the profile")
    errorCategories: ErrorCategoriesDto
    penaltyPoints: PenaltyPointsDto
    passFailThreshold: PassFailThresholdDto
    isDefault: bool = Field(
        ..., description="If profile is set as default for organization"
    )
    createdBy: UserReference
    dateCreated: AwareDatetime
    organization: UidReference


class LqaProfileReferenceDto(BaseModel):
    uid: str = Field(..., description="UID of the profile", examples=["string"])
    name: str = Field(..., description="Name of the profile")
    isDefault: bool = Field(
        ..., description="If profile is set as default for organization"
    )
    createdBy: UserReference
    dateCreated: AwareDatetime = Field(..., description="When profile was created")
    organization: UidReference


class QACheckDtoV2Moravia(QACheckDtoV2):
    enabled: bool | None = None
    profile: str | None = None
    ignorable: bool | None = None
    instant: bool | None = None
    type: Literal["MORAVIA"] = "MORAVIA"


class MTSettingsPerLanguageDto(BaseModel):
    targetLang: str | None = Field(
        None, description="mtSettings is set for whole project if targetLang == null"
    )
    machineTranslateSettings: MachineTranslateSettingsDto | None = None


class MTSettingsPerLanguageListDto(BaseModel):
    mtSettingsPerLangList: List[MTSettingsPerLanguageDto] | None = None


class MemsourceTranslateProfileDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None
    locked: bool | None = None
    memsourceTranslate: MemTransMachineTranslateSettingsDto | None = None
    projects: List[ProjectReference] | None = None
    projectsCount: int | None = None
    projectTemplatesCount: int | None = None
    engines: List[MachineTranslateSettingsSimpleDto] | None = None
    glossaries: List[GlossarySimpleDto] | None = None
    shape: str | None = None


class MemsourceTranslateProfileSimpleDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None
    memsourceTranslate: MemTransMachineTranslateSettingsDto | None = None
    locked: bool | None = None


class MentionableUserDto(BaseModel):
    firstName: str | None = None
    lastName: str | None = None
    userName: str | None = None
    email: str | None = None
    role: UserRoleRefEnum | None = None
    id: str | None = None
    uid: str | None = None
    unavailable: bool | None = None
    jobRoles: List[JobRoleDto] | None = None


class QACheckDtoV2Number(QACheckDtoV2):
    ignorable: bool | None = None
    enabled: bool | None = None
    value: Number | None = None
    instant: bool | None = None
    lock: bool | None = None
    type: Literal["NUMBER"] = "NUMBER"


class NetRateScheme(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    defaultScheme: bool | None = None
    organization: OrganizationReference | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None
    workflowStepNetSchemes: List[NetRateSchemeWorkflowStepReference] | None = None
    rates: DiscountSettingsDto | None = None


class NetRateSchemeReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    isDefault: bool | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None


class PageDtoAdditionalWorkflowStepDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[AdditionalWorkflowStepDto] | None = None
    sort: Sort | None = None


class PageDtoAnalyseJobDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[AnalyseJobDto] | None = None
    sort: Sort | None = None


class PageDtoAssignedJobDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[AssignedJobDto] | None = None
    sort: Sort | None = None


class PageDtoAsyncRequestDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[AsyncRequestDto] | None = None
    sort: Sort | None = None


class PageDtoBusinessUnitDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[BusinessUnitDto] | None = None
    sort: Sort | None = None


class PageDtoBuyerDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[BuyerDto] | None = None
    sort: Sort | None = None


class PageDtoCostCenterDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[CostCenterDto] | None = None
    sort: Sort | None = None


class PageDtoCustomFieldDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[CustomFieldDto] | None = None
    sort: Sort | None = None


class PageDtoCustomFieldInstanceDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[CustomFieldInstanceDto] | None = None
    sort: Sort | None = None


class PageDtoCustomFieldOptionDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[CustomFieldOptionDto] | None = None
    sort: Sort | None = None


class PageDtoDomainDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[DomainDto] | None = None
    sort: Sort | None = None


class PageDtoImportSettingsReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ImportSettingsReference] | None = None
    sort: Sort | None = None


class PageDtoJobPartReferenceV2(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[JobPartReferenceV2] | None = None
    sort: Sort | None = None


class PageDtoLastLoginDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[LastLoginDto] | None = None
    sort: Sort | None = None


class PageDtoLqaProfileReferenceDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[LqaProfileReferenceDto] | None = None
    sort: Sort | None = None


class PageDtoLqaReportRecipientDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[LqaReportRecipientDto] | None = None
    sort: Sort | None = None


class PageDtoMachineTranslateSettingsPbmDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[MachineTranslateSettingsPbmDto] | None = None
    sort: Sort | None = None


class PageDtoMemsourceTranslateProfileDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[MemsourceTranslateProfileDto] | None = None
    sort: Sort | None = None


class PageDtoNetRateSchemeReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[NetRateSchemeReference] | None = None
    sort: Sort | None = None


class PageDtoNetRateSchemeWorkflowStepReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[NetRateSchemeWorkflowStepReference] | None = None
    sort: Sort | None = None


class PageDtoOrganizationEmailTemplateDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[OrganizationEmailTemplateDto] | None = None
    sort: Sort | None = None


class PageDtoProjectReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ProjectReference2] | None = None
    sort: Sort | None = None


class PageDtoProviderReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ProviderReference] | None = None
    sort: Sort | None = None


class PageDtoSegmentationRuleDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[SegmentationRuleDto] | None = None
    sort: Sort | None = None


class PageDtoServiceListEntryDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ServiceListEntryDto] | None = None
    sort: Sort | None = None


class PageDtoString(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[str] | None = None
    sort: Sort | None = None


class PageDtoTranslationPriceSetDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[TranslationPriceSetDto] | None = None
    sort: Sort | None = None


class PageDtoUploadedFileDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[UploadedFileDto] | None = None
    sort: Sort | None = None


class PageDtoUserReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[UserReference] | None = None
    sort: Sort | None = None


class PageDtoWebHookDtoV2(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[WebHookDtoV2] | None = None
    sort: Sort | None = None


class PageDtoWebhookCallDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[WebhookCallDto] | None = None
    sort: Sort | None = None


class PageDtoWorkflowStepDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[WorkflowStepDto] | None = None
    sort: Sort | None = None


class PageDtoWorkflowStepReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[WorkflowStepReference] | None = None
    sort: Sort | None = None


class PageDtoXmlAssistantProfileListDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[XmlAssistantProfileListDto] | None = None
    sort: Sort | None = None


class PageRequest(BaseModel):
    pageNumber: int | None = None
    pageSize: int | None = None
    sort: Sort | None = None


class PageWithResponseTsDtoNotificationDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[NotificationDto] | None = None
    sort: Sort | None = None
    responseTimestamp: AwareDatetime | None = None


class PatchProjectDto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None
    status: JobStatusEnum | None = None
    client: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    owner: IdReference | None = None
    purchaseOrder: constr(min_length=0, max_length=255) | None = None
    dateDue: AwareDatetime | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    machineTranslateSettings: UidReference | None = None
    machineTranslateSettingsPerLangs: List[ProjectMTSettingsPerLangDto] | None = None
    archived: bool | None = None


class PriceListForImport(BaseModel):
    rows: List[PriceRow] | None = None
    importedPriceRows: List[PriceRow] | None = None


class ProjectTemplate(BaseModel):
    id: str | None = None
    uid: str | None = None
    templateName: str | None = None
    name: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    note: str | None = None
    useDynamicTitle: bool | None = None
    dynamicTitle: str | None = None
    owner: UserReference | None = None
    client: ClientReference | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    vendor: VendorReference | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    modifiedBy: UserReference | None = None
    dateModified: AwareDatetime | None = Field(
        None,
        description="Deprecated - use dateTimeModified field instead",
        examples=['{ "epochSeconds": 1624619701, "nano": 0 }'],
    )
    dateTimeModified: AwareDatetime | None = None
    workflowSteps: List[WorkflowStepDto] | None = None
    workflowSettings: List[WorkflowStepSettingsDto] | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsDto | None = None
    businessUnit: BusinessUnitReference | None = None
    notifyProviders: ProjectTemplateNotifyProviderDto | None = None
    assignedTo: List[AssignmentPerTargetLangDto] | None = None
    importSettings: UidReference | None = None


class ProjectTemplateDto(BaseModel):
    id: str | None = None
    name: str | None = None
    templateName: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    workflowSettings: List[ProjectTemplateWorkflowSettingsDto] | None = None


class ProjectTemplateEditDto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None
    templateName: constr(min_length=0, max_length=255)
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    useDynamicTitle: bool | None = None
    dynamicTitle: constr(min_length=0, max_length=255) | None = None
    notifyProvider: NotifyProviderDto | None = None
    workFlowSettings: List[WorkflowStepSettingsEditDto] | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsDto | None = None
    client: IdReference | None = None
    costCenter: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    vendor: IdReference | None = None
    importSettings: UidReference | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    fileHandover: bool | None = Field(False, description="Default: false")
    assignedTo: List[ProjectTemplateWorkflowSettingsAssignedToDto] | None = Field(
        None,
        description="only use for projects without workflows; otherwise specify in the workflowSettings object",
    )


class ProjectTemplateEditV2Dto(BaseModel):
    name: constr(min_length=0, max_length=255) | None = None
    templateName: constr(min_length=0, max_length=255)
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    useDynamicTitle: bool | None = None
    dynamicTitle: constr(min_length=0, max_length=255) | None = None
    notifyProvider: NotifyProviderDto | None = None
    workFlowSettings: List[WorkflowStepSettingsEditV2Dto] | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsV2Dto | None = None
    client: IdReference | None = None
    costCenter: IdReference | None = None
    businessUnit: IdReference | None = None
    domain: IdReference | None = None
    subDomain: IdReference | None = None
    vendor: IdReference | None = None
    importSettings: UidReference | None = None
    note: constr(min_length=0, max_length=4096) | None = None
    owner: IdReference | None = None
    fileHandover: bool | None = Field(False, description="Default: false")
    assignedTo: List[ProjectTemplateWorkflowSettingsAssignedToDto] | None = Field(
        None,
        description="only use for projects without workflows; otherwise specify in the workflowSettings object",
    )


class ProjectTemplateReference(BaseModel):
    templateName: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    id: str | None = None
    uid: str | None = None
    owner: UserReference | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    costCenter: CostCenterReference | None = None
    businessUnit: BusinessUnitReference | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsReference | None = None
    workflowSteps: List[WorkflowStepReference] | None = None
    note: str | None = None
    client: ClientReference | None = None


class ProjectTemplateReferenceFileReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    filename: str | None = None
    note: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None


class ProjectTemplateReferenceFilesDto(BaseModel):
    referenceFiles: List[ProjectTemplateReferenceFileReference] | None = None


class QualityAssuranceBatchRunDtoV3(BaseModel):
    jobs: List[UidReference] = Field(..., max_length=500, min_length=1)
    settings: QualityAssuranceRunDtoV3 | None = None
    maxQaWarningsCount: conint(ge=1, le=1000) | None = Field(
        None,
        description="Maximum number of QA warnings in result, default: 100. For efficiency reasons QA\nwarnings are processed with minimum segments chunk size 10, therefore slightly more warnings are returned.",
    )


class QuoteDto(BaseModel):
    id: int | None = None
    uid: str | None = None
    name: str | None = None
    status: QuoteStatusEnum | None = None
    currency: str | None = None
    billingUnit: BillingUnitEnum | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    totalPrice: float | None = None
    netRateScheme: NetRateSchemeReference | None = None
    priceList: PriceListReference | None = None
    workflowStepList: List[WorkflowStepReference] | None = None
    provider: ProviderReference | None = None
    customerEmail: str | None = None
    quoteType: QuoteTypeEnum | None = None
    editable: bool | None = None
    outdated: bool | None = None
    analyseUid: str | None = None
    innerId: int | None = None


class QuoteV2Dto(BaseModel):
    id: int | None = None
    uid: str | None = None
    name: str | None = None
    status: QuoteStatusEnum | None = None
    currency: str | None = None
    billingUnit: BillingUnitEnum | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    totalPrice: float | None = None
    netRateScheme: NetRateSchemeReference | None = None
    priceList: PriceListReference | None = None
    workflowStepList: List[WorkflowStepReference] | None = None
    provider: ProviderReference | None = None
    customerEmail: str | None = None
    quoteType: QuoteTypeEnum | None = None
    editable: bool | None = None
    outdated: bool | None = None
    additionalSteps: List[AdditionalWorkflowStepV2Dto] | None = None


class ReferenceFileReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    filename: str | None = None
    note: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None


class ReferenceFilesDto(BaseModel):
    referenceFiles: List[ReferenceFileReference] | None = None


class SearchTMSegmentDto(BaseModel):
    id: str | None = None
    text: str | None = None
    lang: str | None = None
    rtl: bool | None = None
    modifiedAt: int | None = None
    createdAt: int | None = None
    modifiedBy: UserReference | None = None
    createdBy: UserReference | None = None
    filename: str | None = None
    project: SearchTMProjectDto | None = None
    client: SearchTMClientDto | None = None
    domain: SearchTMDomainDto | None = None
    subDomain: SearchTMSubDomainDto | None = None
    tagMetadata: List[TagMetadata] | None = None
    previousSegment: str | None = None
    nextSegment: str | None = None
    key: str | None = None


class SearchTMSegmentDtoV3(BaseModel):
    id: str | None = None
    text: str | None = None
    lang: str | None = None
    rtl: bool | None = None
    modifiedAt: int | None = None
    createdAt: int | None = None
    modifiedBy: UserReference | None = None
    createdBy: UserReference | None = None
    filename: str | None = None
    project: SearchTMProjectDtoV3 | None = None
    client: SearchTMClientDtoV3 | None = None
    domain: SearchTMDomainDtoV3 | None = None
    subDomain: SearchTMSubDomainDtoV3 | None = None
    tagMetadata: List[TagMetadata] | None = None
    previousSegment: str | None = None
    nextSegment: str | None = None
    key: str | None = None
    targetNote: str | None = None


class SegmentListDto(BaseModel):
    segments: List[JobSegmentDto] | None = None


class SegmentationRulesOwnersDto(BaseModel):
    owners: List[UserReference] | None = None


class SetContextPTTransMemoriesV2Dto(BaseModel):
    transMemories: List[SetProjectTemplateTransMemoryV2Dto]
    targetLang: str | None = Field(
        None,
        description="Set translation memory only for the specific project target language",
    )
    workflowStep: UidReference | None = None
    orderEnabled: bool | None = Field(False, description="Default: false")


class SetContextTransMemoriesDtoV3Dto(BaseModel):
    transMemories: List[SetProjectTransMemoryV3Dto]
    targetLang: str | None = Field(
        None,
        description="Set translation memory only for the specific project target language",
    )
    workflowStep: UidReference | None = None
    orderEnabled: bool | None = Field(False, description="Default: false")


class SetProjectTemplateTransMemoriesV2Dto(BaseModel):
    dataPerContext: List[SetContextPTTransMemoriesV2Dto]


class SetProjectTransMemoriesV3Dto(BaseModel):
    dataPerContext: List[SetContextTransMemoriesDtoV3Dto]


class StatusDto(BaseModel):
    name: LqaConversationStatusEnum | None = None
    by: MentionableUserDto | None = None
    date: AwareDatetime | None = None


class SubDomainDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    createdBy: UserReference | None = None


class TermBaseDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    internalId: int | None = None
    name: str
    langs: List[str] | None = None
    client: ClientReference | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    businessUnit: BusinessUnitReference | None = None
    createdBy: UserReference | None = None
    owner: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    note: str | None = None
    canShow: bool | None = None
    readonly: bool | None = None
    userAllowedOperations: List[str] | None = None
    sourceUrl: str | None = None


class TermDto(BaseModel):
    id: str | None = None
    text: str
    lang: str | None = None
    rtl: bool | None = None
    modifiedAt: AwareDatetime | None = None
    createdAt: AwareDatetime | None = None
    modifiedBy: UserReference | None = None
    createdBy: UserReference | None = None
    caseSensitive: bool | None = None
    exactMatch: bool | None = None
    forbidden: bool | None = None
    preferred: bool | None = None
    status: TermStatusEnum | None = None
    conceptId: str | None = None
    usage: str | None = None
    note: str | None = None
    writable: bool | None = None
    shortTranslation: str | None = None
    termType: str | None = None
    partOfSpeech: str | None = None
    gender: str | None = None
    number: str | None = None
    definition: str | None = None
    domain: str | None = None
    subDomains: List[str] | None = None
    url: str | None = None
    conceptNote: str | None = None
    customFields: List[CustomFieldValueDto] | None = None


class TermPairDto(BaseModel):
    sourceTerm: TermDto
    targetTerm: TermDto


class TermV2Dto2(BaseModel):
    id: str | None = None
    text: str
    lang: str | None = None
    rtl: bool | None = None
    modifiedAt: AwareDatetime | None = None
    createdAt: AwareDatetime | None = None
    modifiedBy: UserReference | None = None
    createdBy: UserReference | None = None
    caseSensitive: bool | None = None
    exactMatch: bool | None = None
    forbidden: bool | None = None
    preferred: bool | None = None
    status: TermStatusEnum | None = None
    conceptId: str | None = None
    usage: str | None = None
    note: str | None = None
    writable: bool | None = None
    shortTranslation: str | None = None
    termType: TermTypeEnum | None = None
    partOfSpeech: TermPartOfSpeechEnum | None = None
    gender: TermGenderEnum | None = None
    number: TermNumberEnum | None = None
    customFields: List[CustomFieldValueDto] | None = None


class TransMemoryDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    internalId: int | None = None
    name: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    client: ClientReference | None = None
    businessUnit: BusinessUnitReference | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    note: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None
    owner: UserReference | None = None


class TransMemoryDtoV2(BaseModel):
    id: str | None = None
    uid: str | None = None
    internalId: int | None = None
    name: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    client: ClientReference | None = None
    businessUnit: BusinessUnitReference | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    note: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None
    owner: UserReference | None = None
    relatedProjectsCount: int | None = None
    collaboratorsCount: int | None = None
    canEdit: bool | None = None


class TransMemoryDtoV3(BaseModel):
    id: str | None = None
    uid: str | None = None
    internalId: int | None = None
    name: str | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    client: ClientReference | None = None
    businessUnit: BusinessUnitReference | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    note: str | None = None
    dateCreated: AwareDatetime | None = None
    createdBy: UserReference | None = None


class TranslationPriceListDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    dateCreated: AwareDatetime | None = None
    name: str
    currencyCode: str | None = None
    billingUnit: BillingUnitEnum | None = None
    isDefault: bool | None = None
    priceSets: List[TranslationPriceSetDto] | None = None


class UpdateCustomFileTypeDto(BaseModel):
    name: str | None = None
    filenamePattern: str | None = None
    type: CustomFileTypeEnum | None = None
    fileImportSettings: FileImportSettingsCreateDto | None = None


class UpdateIgnoredJobPartSegment(BaseModel):
    jobPartUid: str
    segments: List[UpdateIgnoredSegment2] = Field(..., max_length=500, min_length=1)


class UpdateIgnoredWarningsDto2(BaseModel):
    jobParts: List[UpdateIgnoredJobPartSegment] = Field(
        ..., max_length=500, min_length=1
    )


class UpdateLqaProfileDto(BaseModel):
    name: constr(min_length=1, max_length=255)
    errorCategories: ErrorCategoriesDto
    penaltyPoints: PenaltyPointsDto | None = None
    passFailThreshold: PassFailThresholdDto | None = None


class UserDetailsDtoV3(BaseModel):
    uid: constr(min_length=0, max_length=255)
    id: int
    userName: constr(min_length=0, max_length=255)
    firstName: constr(min_length=0, max_length=255)
    lastName: constr(min_length=0, max_length=255)
    email: constr(min_length=0, max_length=255)
    dateCreated: AwareDatetime | None = None
    dateDeleted: AwareDatetime | None = None
    createdBy: UserReference2 | None = None
    role: str
    assignableRoles: List[str] | None = None
    timezone: constr(min_length=0, max_length=255)
    note: constr(min_length=0, max_length=4096) | None = None
    receiveNewsletter: bool | None = None
    active: bool | None = None
    pendingEmailChange: bool | None = Field(
        None, description="If user has email change pending (new email not verified)"
    )
    twoFactorAuthEnabled: bool | None = Field(
        None, description="If user has 2FA key configured"
    )
    credentialsReadonly: bool | None = Field(
        None, description="If user credentials are readonly due to SSO"
    )
    lastLogin: AwareDatetime | None = None
    editorVersion: str | None = None
    jobsInProgress: int | None = None


class UserDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    userName: str | None = None
    firstName: str | None = None
    lastName: str | None = None
    email: str | None = None
    dateCreated: AwareDatetime | None = None
    dateDeleted: AwareDatetime | None = None
    createdBy: UserReference | None = None
    role: UserRoleRefEnum | None = None
    timezone: str | None = None
    note: str | None = None
    terminologist: bool | None = None
    sourceLangs: List[str] | None = None
    targetLangs: List[str] | None = None
    active: bool | None = None
    priceList: PriceListReference | None = None
    netRateScheme: DiscountSchemeReference | None = None
    anonymized: bool | None = None


class VendorDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    vendorToken: str | None = None
    priceList: PriceListReference | None = None
    netRateScheme: DiscountSchemeReference | None = None
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    clients: List[ClientReference] | None = None
    domains: List[DomainReference] | None = None
    subDomains: List[SubDomainReference] | None = None
    workflowSteps: List[WorkflowStepReference] | None = None


class QACheckDtoV2Union(
    RootModel[
        QACheckDtoV2Moravia
        | QACheckDtoV2Number
        | QACheckDtoV2Regex
        | QACheckDtoV2String
        | QACheckDtoV2Void
    ]
):
    root: (
        QACheckDtoV2Moravia
        | QACheckDtoV2Number
        | QACheckDtoV2Regex
        | QACheckDtoV2String
        | QACheckDtoV2Void
    ) = Field(..., discriminator="type", title="QACheckDtoV2Union")


class UserDetailsDtoV3Admin(UserDetailsDtoV3):
    role: Literal["ADMIN"] = "ADMIN"


class AbstractProjectDto(BaseModel):
    uid: str | None = None
    internalId: int | None = None
    id: str | None = None
    name: str | None = None
    dateCreated: AwareDatetime | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    owner: UserReference | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    references: List[ReferenceFileReference] | None = None
    mtSettingsPerLanguageList: List[MTSettingsPerLanguageReference] | None = None
    userRole: str = Field(..., description="Response differs based on user's role")


class AbstractProjectDtoV2(BaseModel):
    uid: str | None = None
    internalId: int | None = None
    id: str | None = None
    name: str | None = None
    dateCreated: AwareDatetime | None = None
    domain: DomainReference | None = None
    subDomain: SubDomainReference | None = None
    owner: UserReference | None = None
    sourceLang: str | None = None
    targetLangs: List[str] | None = None
    references: List[ReferenceFileReference] | None = None
    mtSettingsPerLanguageList: List[MTSettingsPerLanguageReference] | None = None
    status: JobStatusEnum | None = None
    userRole: str | None = Field(
        None, description="Response differs based on user's role"
    )


class AnalyseReference(BaseModel):
    id: str | None = None
    uid: str | None = None
    innerId: str | None = None
    type: AnalyseReferenceEnum | None = None
    name: str | None = None
    provider: ProviderReference | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    netRateScheme: NetRateSchemeReference | None = None
    analyseLanguageParts: List[AnalyseLanguagePartReference] | None = None
    outdated: bool | None = None
    importStatus: ImportStatusDto | None = None
    pureWarnings: List[str] | None = None


class AnalyseV2Dto(BaseModel):
    id: str | None = None
    uid: str | None = None
    type: AnalyseReferenceEnum | None = None
    name: str | None = None
    provider: ProviderReference | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    netRateScheme: NetRateSchemeReference | None = None
    analyseLanguageParts: List[AnalyseLanguagePartV2Dto] | None = None


class AnalyseV3Dto(BaseModel):
    id: str | None = None
    uid: str | None = None
    innerId: int | None = None
    type: AnalyseReferenceEnum | None = None
    name: str | None = None
    provider: ProviderReference | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    netRateScheme: NetRateSchemeReference | None = None
    canChangeNetRateScheme: bool | None = None
    analyseLanguageParts: List[AnalyseLanguagePartV3Dto] | None = None
    settings: AbstractAnalyseSettingsDto | None = None
    outdated: bool | None = None
    importStatus: ImportStatusDto | None = None
    pureWarnings: List[str] | None = None
    project: ProjectReference | None = None


class AnalysesV2Dto(BaseModel):
    analyses: List[AnalyseV2Dto] | None = None


class AssessmentBasicDto(BaseModel):
    lqaProfile: LqaProfileAssessmentDto | None = None
    startedDate: AwareDatetime | None = Field(
        None, description="When assessment started or empty if it was not yet"
    )


class AssessmentDetailDto(BaseModel):
    jobPartUid: str | None = Field(None, description="UID of the corresponding job")
    assessmentJobPartUid: str | None = Field(
        None,
        description="UID of job corresponding to the assessment. Null when assessment not found",
    )
    requestedJobPartUid: str | None = Field(
        None, description="The originally requested job UID"
    )
    workflowStep: WorkflowStepDto | None = None
    reportCanBeDownloaded: bool | None = Field(
        None,
        description="If Assessment report/scorecard is ready and can be downloaded, user's rights are considered",
    )
    lqaEnabled: bool | None = Field(
        None, description="If LQA is enabled and configured for this job"
    )
    availability: AvailabilityEnum | None = None
    lqaProfile: LqaProfileAssessmentDto | None = None
    startedDate: AwareDatetime | None = Field(
        None, description="When assessment was started (or empty)"
    )
    finishedDate: AwareDatetime | None = Field(
        None, description="When assessment was finished (or empty)"
    )
    editedDate: AwareDatetime | None = Field(
        None, description="When assessment was edited after previous finish (or empty)"
    )
    assessmentResult: AssessmentResultDto | None = None
    overallFeedback: str | None = Field(
        None, description="Overall feedback from the LQA reviewer"
    )
    translationProvider: UidReference | None = None
    reviewProvider: ReviewProviderDto | None = None
    origin: OriginEnum | None = None
    mode: AssessmentDetailModeEnum | None = None
    status: AssessmentDetailStatusEnum | None = None


class AssessmentDetailsDto(BaseModel):
    assessmentDetails: List[AssessmentDetailDto] | None = None


class AssignableTemplatesDto(BaseModel):
    assignableTemplates: List[ProjectTemplateDto] | None = None


class AsyncAnalyseResponseDto(BaseModel):
    asyncRequest: AsyncRequestDto | None = None
    analyse: ObjectReference | None = None


class AsyncAnalyseResponseV2Dto(BaseModel):
    asyncRequest: AsyncRequestV2Dto | None = None
    analyse: ObjectReference | None = None


class AsyncExportTMByQueryResponseDto(BaseModel):
    asyncRequest: AsyncRequestDto | None = None
    asyncExport: AsyncExportTMByQueryDto | None = None


class AsyncExportTMResponseDto(BaseModel):
    asyncRequest: AsyncRequestV2Dto | None = None
    asyncExport: AsyncExportTMDto | None = None


class ProjectDtoBuyer(AbstractProjectDto):
    shared: bool | None = Field(False, description="Default: false")
    progress: ProgressDto | None = None
    client: ClientReference | None = None
    costCenter: CostCenterReference | None = None
    businessUnit: BusinessUnitReference | None = None
    dateDue: AwareDatetime | None = None
    status: JobStatusEnum | None = None
    purchaseOrder: str | None = None
    isPublishedOnJobBoard: bool | None = Field(False, description="Default: false")
    note: str | None = None
    createdBy: UserReference | None = None
    qualityAssuranceSettings: ObjectReference | None = None
    workflowSteps: List[ProjectWorkflowStepDto] | None = None
    analyseSettings: ObjectReference | None = None
    accessSettings: ObjectReference | None = None
    financialSettings: ObjectReference | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsReference | None = None
    archived: bool | None = None
    dateArchived: AwareDatetime | None = None
    archivedBy: UserReference | None = None
    vendorOwner: ProviderReferenceUser | None = None
    vendor: VendorReference | None = None
    userRole: Literal["Buyer"] = "Buyer"


class ClientDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    name: str | None = None
    externalId: str | None = None
    note: str | None = None
    displayNoteInProject: bool | None = Field(False, description="Default: false")
    priceList: PriceListReference | None = None
    netRateScheme: NetRateSchemeReference | None = None
    createdBy: UserReference | None = None


class ConceptDto(BaseModel):
    id: str | None = None
    writable: bool | None = None
    terms: List[List[TermDto]] | None = None


class CreateCustomFileTypeDto(BaseModel):
    name: str
    filenamePattern: str
    type: CustomFileTypeEnum
    fileImportSettings: FileImportSettingsCreateDto | None = None


class CreateLqaProfileDto(BaseModel):
    name: constr(min_length=1, max_length=255)
    errorCategories: ErrorCategoriesDto
    penaltyPoints: PenaltyPointsDto | None = None
    passFailThreshold: PassFailThresholdDto | None = None


class CustomFileTypeDto(BaseModel):
    uid: str | None = None
    name: str | None = None
    filenamePattern: str | None = None
    type: str | None = None
    createdBy: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    fileImportSettings: FileImportSettingsDto | None = None
    supportsContinuousJob: bool | None = None


class FinancialSettingsDto(BaseModel):
    netRateScheme: NetRateSchemeReference | None = None
    priceList: PriceListReference | None = None


class FindConversationsForProjectDto(BaseModel):
    jobPartUidRef: UidReference
    since: str | None = Field(
        None,
        description="Filtered by createdAt date time in ISO 8601 UTC format",
        examples=["2024-07-21T10:15:27.819Z"],
    )
    includeDeleted: bool | None = Field(
        False, description="Include conversations flagged for deletion. Default: false"
    )
    status: str | None = Field(
        None, description='Filter current status for values "resolved" or "unresolved"'
    )
    text: str | None = Field(
        None,
        description="Case insensitive search in the lqa description and conversation comments",
    )
    mentionedUid: str | None = Field(
        None, description="Search a single user uid in mentions"
    )
    pageRequest: PageRequest | None = None


class UserDetailsDtoV3Guest(UserDetailsDtoV3):
    client: ClientReference4
    enableMT: bool | None = None
    projectViewOther: bool | None = None
    projectViewOtherLinguist: bool | None = None
    projectViewOtherEditor: bool | None = None
    transMemoryViewOther: bool | None = None
    transMemoryEditOther: bool | None = None
    transMemoryExportOther: bool | None = None
    transMemoryImportOther: bool | None = None
    termBaseViewOther: bool | None = None
    termBaseEditOther: bool | None = None
    termBaseExportOther: bool | None = None
    termBaseImportOther: bool | None = None
    termBaseApproveOther: bool | None = None
    role: Literal["GUEST"] = "GUEST"


class GlossaryDto(BaseModel):
    id: str | None = None
    uid: str | None = None
    internalId: int | None = None
    name: str
    langs: List[str] | None = None
    createdBy: UserReference | None = None
    owner: UserReference | None = None
    dateCreated: AwareDatetime | None = None
    profileCount: int | None = None
    active: bool | None = None
    profiles: List[MemsourceTranslateProfileSimpleDto] | None = None


class JobPartExtendedDto(BaseModel):
    uid: str | None = None
    innerId: str | None = Field(
        None,
        description="InnerId is a sequential number of a job in a project. Jobs created from the same file share the same innerId across workflow steps.",
    )
    status: JobStatusEnum2 | None = None
    providers: List[ProviderReference] | None = None
    sourceLang: str | None = None
    targetLang: str | None = None
    workflowLevel: int | None = None
    workflowStep: ProjectWorkflowStepReference | None = None
    filename: str | None = None
    dateDue: AwareDatetime | None = None
    wordsCount: int | None = None
    beginIndex: int | None = None
    endIndex: int | None = None
    isParentJobSplit: bool | None = None
    updateSourceDate: AwareDatetime | None = None
    updateTargetDate: AwareDatetime | None = None
    dateCreated: AwareDatetime | None = None
    jobReference: JobReference | None = None
    project: ProjectReference | None = None
    lastWorkflowLevel: int | None = None
    workUnit: ObjectReference | None = None
    importStatus: ImportStatusDto | None = None
    imported: bool | None = None
    continuous: bool | None = None
    continuousJobInfo: ContinuousJobInfoDto | None = None
    originalFileDirectory: str | None = None
    serverTaskId: str | None = None


class UserDetailsDtoV3Linguist(UserDetailsDtoV3):
    editAllTermsInTB: bool | None = None
    editTranslationsInTM: bool | None = None
    enableMT: bool | None = None
    mayRejectJobs: bool | None = None
    mayCompleteUnconfirmedJobs: bool | None = None
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    workflowSteps: List[WorkflowStepReferenceV3] | None = None
    clients: List[ClientReference4] | None = None
    domains: List[DomainReference4] | None = None
    subDomains: List[SubDomainReference4] | None = None
    netRateScheme: DiscountSchemeReference3 | None = None
    translationPriceList: PriceListReference | None = None
    role: Literal["LINGUIST"] = "LINGUIST"


class LQAReference(BaseModel):
    errorCategoryId: conint(ge=1)
    severityId: conint(ge=1)
    user: IdReference | None = None
    originator: MentionableUserDto | None = None
    repeated: RepeatedEnum | None = None
    origin: Origin | None = None


class LQAReferences(BaseModel):
    taskId: str | None = None
    jobPartUid: str | None = None
    transGroupId: conint(ge=0)
    segmentId: str
    conversationTitle: str | None = None
    conversationTitleOffset: conint(ge=0) | None = None
    commentedText: str | None = None
    correlation: ReferenceCorrelation | None = None
    lqa: List[LQAReference] = Field(..., max_length=1, min_length=1)


class ProjectDtoLinguist(AbstractProjectDto):
    userRole: Literal["Linguist"] = "Linguist"


class MentionDto(BaseModel):
    mentionType: MentionTypeEnum
    mentionGroupType: MentionGroupTypeEnum | None = None
    uidReference: UidReference | None = None
    userReferences: List[MentionableUserDto] | None = None
    mentionableGroup: MentionableGroupDto | None = None
    tag: str | None = None


class UserDetailsDtoV3PortalMember(UserDetailsDtoV3):
    projectViewOther: bool | None = None
    projectClients: List[ClientReference4] | None = None
    transMemoryViewOther: bool | None = None
    transMemoryEditOther: bool | None = None
    transMemoryExportOther: bool | None = None
    transMemoryImportOther: bool | None = None
    transMemoryClients: List[ClientReference4] | None = None
    termBaseViewOther: bool | None = None
    termBaseEditOther: bool | None = None
    termBaseExportOther: bool | None = None
    termBaseImportOther: bool | None = None
    termBaseApproveOther: bool | None = None
    termBaseClients: List[ClientReference4] | None = None
    role: Literal["PORTAL_MEMBER"] = "PORTAL_MEMBER"


class UserDetailsDtoV3ProjectManager(UserDetailsDtoV3):
    sourceLocales: List[str] | None = None
    targetLocales: List[str] | None = None
    workflowSteps: List[WorkflowStepReferenceV3] | None = None
    clients: List[ClientReference4] | None = None
    domains: List[DomainReference4] | None = None
    subDomains: List[SubDomainReference4] | None = None
    projectCreate: bool | None = None
    projectViewOther: bool | None = None
    projectEditOther: bool | None = None
    projectDeleteOther: bool | None = None
    projectClients: List[ClientReference4] | None = None
    projectBusinessUnits: List[BusinessUnitReference3] | None = None
    projectTemplateCreate: bool | None = None
    projectTemplateViewOther: bool | None = None
    projectTemplateEditOther: bool | None = None
    projectTemplateDeleteOther: bool | None = None
    projectTemplateClients: List[ClientReference4] | None = None
    projectTemplateBusinessUnits: List[BusinessUnitReference3] | None = None
    transMemoryCreate: bool | None = None
    transMemoryViewOther: bool | None = None
    transMemoryEditOther: bool | None = None
    transMemoryDeleteOther: bool | None = None
    transMemoryExportOther: bool | None = None
    transMemoryImportOther: bool | None = None
    transMemoryClients: List[ClientReference4] | None = None
    transMemoryBusinessUnits: List[BusinessUnitReference3] | None = None
    termBaseCreate: bool | None = None
    termBaseViewOther: bool | None = None
    termBaseEditOther: bool | None = None
    termBaseDeleteOther: bool | None = None
    termBaseExportOther: bool | None = None
    termBaseImportOther: bool | None = None
    termBaseApproveOther: bool | None = None
    termBaseClients: List[ClientReference4] | None = None
    termBaseBusinessUnits: List[BusinessUnitReference3] | None = None
    userCreate: bool | None = None
    userViewOther: bool | None = None
    userEditOther: bool | None = None
    userDeleteOther: bool | None = None
    clientDomainSubDomainCreate: bool | None = None
    clientDomainSubDomainViewOther: bool | None = None
    clientDomainSubDomainEditOther: bool | None = None
    clientDomainSubDomainDeleteOther: bool | None = None
    vendorCreate: bool | None = None
    vendorViewOther: bool | None = None
    vendorEditOther: bool | None = None
    vendorDeleteOther: bool | None = None
    dashboardSetting: str | None = None
    setupServer: bool | None = None
    role: Literal["PROJECT_MANAGER"] = "PROJECT_MANAGER"


class PageDtoAbstractProjectDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[AbstractProjectDto] | None = None
    sort: Sort | None = None


class PageDtoAnalyseReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[AnalyseReference] | None = None
    sort: Sort | None = None


class PageDtoClientDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ClientDto] | None = None
    sort: Sort | None = None


class PageDtoCustomFileTypeDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[CustomFileTypeDto] | None = None
    sort: Sort | None = None


class PageDtoGlossaryDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[GlossaryDto] | None = None
    sort: Sort | None = None


class PageDtoProjectTemplateReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ProjectTemplateReference] | None = None
    sort: Sort | None = None


class PageDtoProjectTemplateReferenceFileReference(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ProjectTemplateReferenceFileReference] | None = None
    sort: Sort | None = None


class PageDtoQuoteDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[QuoteDto] | None = None
    sort: Sort | None = None


class PageDtoSubDomainDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[SubDomainDto] | None = None
    sort: Sort | None = None


class PageDtoTermBaseDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[TermBaseDto] | None = None
    sort: Sort | None = None


class PageDtoTransMemoryDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[TransMemoryDto] | None = None
    sort: Sort | None = None


class PageDtoTranslationPriceListDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[TranslationPriceListDto] | None = None
    sort: Sort | None = None


class PageDtoUserDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[UserDto] | None = None
    sort: Sort | None = None


class PageDtoVendorDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[VendorDto] | None = None
    sort: Sort | None = None


class ProjectTemplateTermBaseDto(BaseModel):
    targetLocale: str | None = None
    workflowStep: WorkflowStepReference | None = None
    readMode: bool | None = None
    writeMode: bool | None = None
    termBase: TermBaseDto | None = None
    qualityAssurance: bool | None = None


class ProjectTemplateTermBaseListDto(BaseModel):
    termBases: List[ProjectTemplateTermBaseDto] | None = None


class ProjectTemplateTransMemoryDtoV3(BaseModel):
    targetLocale: str | None = None
    workflowStep: WorkflowStepReferenceV3 | None = None
    readMode: bool | None = None
    writeMode: bool | None = None
    transMemory: TransMemoryDtoV3 | None = None
    penalty: float | None = None
    applyPenaltyTo101Only: bool | None = None
    order: int | None = None


class ProjectTemplateTransMemoryListDtoV3(BaseModel):
    transMemories: List[ProjectTemplateTransMemoryDtoV3] | None = None


class ProjectTemplateTransMemoryV2Dto(BaseModel):
    targetLocale: str | None = None
    workflowStep: WorkflowStepReferenceV2 | None = None
    readMode: bool | None = None
    writeMode: bool | None = None
    transMemory: TransMemoryDtoV2 | None = None
    penalty: float | None = None
    applyPenaltyTo101Only: bool | None = None
    order: int | None = None


class ProjectTermBaseDto(BaseModel):
    targetLocale: str | None = None
    workflowStep: WorkflowStepReference | None = None
    readMode: bool | None = None
    writeMode: bool | None = None
    termBase: TermBaseDto | None = None
    qualityAssurance: bool | None = None


class ProjectTermBaseListDto(BaseModel):
    termBases: List[ProjectTermBaseDto] | None = None


class ProjectTransMemoryDtoV3(BaseModel):
    transMemory: TransMemoryDtoV3 | None = None
    penalty: float | None = None
    applyPenaltyTo101Only: bool | None = None
    targetLocale: str | None = None
    workflowStep: WorkflowStepReferenceV3 | None = None
    readMode: bool | None = None
    writeMode: bool | None = None
    order: int | None = None


class ProjectTransMemoryListDtoV3(BaseModel):
    transMemories: List[ProjectTransMemoryDtoV3] | None = None


class ReferenceFilePageDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[ReferenceFileReference] | None = None
    sort: Sort | None = None
    access: ReferenceFileAccessDto | None = None


class UserDetailsDtoV3Submitter(UserDetailsDtoV3):
    automationWidgets: List[JobWidgetReference]
    projectViewCreatedByOtherSubmitters: bool | None = None
    role: Literal["SUBMITTER"] = "SUBMITTER"


class SearchInTextResponse2Dto(BaseModel):
    termBase: TermBaseSearchResultDto | None = None
    sourceTerm: TermV2Dto2 | None = None
    concept: ConceptDtov2 | None = None
    translationTerms: List[TermV2Dto2] | None = None
    subTerm: bool | None = None
    matches: List[Match] | None = None


class SearchInTextResponseList2Dto(BaseModel):
    searchResults: List[SearchInTextResponse2Dto] | None = None


class SearchJobsDto(BaseModel):
    jobs: List[JobPartExtendedDto] | None = None


class SearchResponseTbDto(BaseModel):
    termBase: TermBaseDto | None = None
    conceptId: str | None = None
    sourceTerm: TermDto | None = None
    translationTerms: List[TermDto] | None = None


class SearchTMResponseDto(BaseModel):
    segmentId: str | None = None
    source: SearchTMSegmentDto | None = None
    translations: List[SearchTMSegmentDto] | None = None
    transMemory: SearchTMTransMemoryDto | None = None
    grossScore: float | None = None
    score: float | None = None
    subSegment: bool | None = None


class SearchTMResponseDtoV3(BaseModel):
    segmentId: str | None = None
    source: SearchTMSegmentDtoV3 | None = None
    translations: List[SearchTMSegmentDtoV3] | None = None
    transMemory: SearchTMTransMemoryDtoV3 | None = None
    grossScore: float | None = None
    score: float | None = None
    subSegment: bool | None = None


class SearchTbResponseDto(BaseModel):
    termBase: TermBaseSearchResultDto | None = None
    concept: ConceptDtov2 | None = None
    sourceTerm: TermV2Dto2 | None = None
    translationTerms: List[TermV2Dto2] | None = None


class SearchTbResponseListDto(BaseModel):
    searchResults: List[SearchTbResponseDto] | None = None


class ProjectDtoVendor(AbstractProjectDto):
    shared: bool | None = Field(False, description="Default: false")
    progress: ProgressDto | None = None
    client: ClientReference | None = None
    costCenter: CostCenterReference | None = None
    businessUnit: BusinessUnitReference | None = None
    dateDue: AwareDatetime | None = None
    status: JobStatusEnum | None = None
    purchaseOrder: str | None = None
    isPublishedOnJobBoard: bool | None = Field(False, description="Default: false")
    note: str | None = None
    createdBy: UserReference | None = None
    qualityAssuranceSettings: ObjectReference | None = None
    workflowSteps: List[ProjectWorkflowStepDto] | None = None
    analyseSettings: ObjectReference | None = None
    accessSettings: ObjectReference | None = None
    financialSettings: ObjectReference | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsReference | None = None
    archived: bool | None = None
    dateArchived: AwareDatetime | None = None
    archivedBy: UserReference | None = None
    buyerOwner: ProviderReferenceUser | None = None
    buyer: BuyerReference | None = None
    userRole: Literal["Vendor"] = "Vendor"


class ProjectDtoProjectManagerOrAdmin(AbstractProjectDto):
    shared: bool | None = Field(False, description="Default: false")
    progress: ProgressDto | None = None
    client: ClientReference | None = None
    costCenter: CostCenterReference | None = None
    businessUnit: BusinessUnitReference | None = None
    dateDue: AwareDatetime | None = None
    status: JobStatusEnum | None = None
    purchaseOrder: str | None = None
    isPublishedOnJobBoard: bool | None = Field(False, description="Default: false")
    note: str | None = None
    createdBy: UserReference | None = None
    qualityAssuranceSettings: ObjectReference | None = None
    workflowSteps: List[ProjectWorkflowStepDto] | None = None
    analyseSettings: ObjectReference | None = None
    accessSettings: ObjectReference | None = None
    financialSettings: ObjectReference | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsReference | None = None
    archived: bool | None = None
    dateArchived: AwareDatetime | None = None
    archivedBy: UserReference | None = None
    userRole: Literal["PROJECT_MANAGER", "ADMIN"]


class ProjectDtoV2AdminOrProjectManager(AbstractProjectDtoV2):
    shared: bool | None = Field(False, description="Default: false")
    progress: ProgressDtoV2 | None = None
    client: ClientReference | None = None
    costCenter: CostCenterReference | None = None
    businessUnit: BusinessUnitReference | None = None
    dateDue: AwareDatetime | None = None
    purchaseOrder: str | None = None
    isPublishedOnJobBoard: bool | None = Field(False, description="Default: false")
    note: str | None = None
    createdBy: UserReference | None = None
    qualityAssuranceSettings: ObjectReference | None = None
    workflowSteps: List[ProjectWorkflowStepDtoV2] | None = None
    analyseSettings: ObjectReference | None = None
    accessSettings: ObjectReference | None = None
    financialSettings: ObjectReference | None = None
    projectWorkflowSettings: ProjectWorkflowSettingsReference | None = None
    userRole: Literal["ADMIN", "PROJECT_MANAGER"]


class ProjectDtoV2Linguist(AbstractProjectDtoV2):
    userRole: Literal["LINGUIST"] = "LINGUIST"


class UserDetailsDtoV3Union(
    RootModel[
        UserDetailsDtoV3Admin
        | UserDetailsDtoV3Guest
        | UserDetailsDtoV3Linguist
        | UserDetailsDtoV3PortalMember
        | UserDetailsDtoV3ProjectManager
        | UserDetailsDtoV3Submitter
    ]
):
    root: (
        UserDetailsDtoV3Admin
        | UserDetailsDtoV3Guest
        | UserDetailsDtoV3Linguist
        | UserDetailsDtoV3PortalMember
        | UserDetailsDtoV3ProjectManager
        | UserDetailsDtoV3Submitter
    ) = Field(..., discriminator="role", title="UserDetailsDtoV3Union")


class ProjectDto(
    RootModel[
        ProjectDtoBuyer
        | ProjectDtoLinguist
        | ProjectDtoVendor
        | ProjectDtoProjectManagerOrAdmin
    ]
):
    root: (
        ProjectDtoBuyer
        | ProjectDtoLinguist
        | ProjectDtoVendor
        | ProjectDtoProjectManagerOrAdmin
    ) = Field(..., discriminator="userRole", title="ProjectDto")


class ProjectDtoV2(RootModel[ProjectDtoV2AdminOrProjectManager | ProjectDtoV2Linguist]):
    root: ProjectDtoV2AdminOrProjectManager | ProjectDtoV2Linguist = Field(
        ..., discriminator="userRole", title="ProjectDtoV2"
    )


class AnalyseRecalculateResponseDto(BaseModel):
    analyses: List[AsyncAnalyseResponseDto] | None = None


class AsyncAnalyseListResponseDto(BaseModel):
    analyses: List[AsyncAnalyseResponseDto] | None = None


class AsyncAnalyseListResponseV2Dto(BaseModel):
    asyncRequests: List[AsyncAnalyseResponseV2Dto] | None = None


class BrowseResponseListDto(BaseModel):
    searchResults: List[ConceptDto] | None = None


class CommentDto(BaseModel):
    id: str | None = None
    text: str | None = None
    createdBy: MentionableUserDto | None = None
    dateCreated: AwareDatetime | None = None
    dateModified: AwareDatetime | None = None
    mentions: List[MentionDto] | None = None


class CommonConversationDto(BaseModel):
    id: str | None = None
    type: str = Field(
        ..., description="Field references differs based on the Conversation Type."
    )
    dateCreated: AwareDatetime | None = None
    dateModified: AwareDatetime | None = None
    dateEdited: AwareDatetime | None = None
    createdBy: MentionableUserDto | None = None
    comments: List[CommentDto] | None = None
    status: StatusDto | None = None
    deleted: bool | None = None


class ConversationListDto(BaseModel):
    conversations: List[CommonConversationDto] | None = None


class CreateLqaConversationDto(BaseModel):
    lqaDescription: str | None = None
    references: LQAReferences


class EditLqaConversationDto(BaseModel):
    lqaDescription: str | None = None
    lqa: List[LQAReference] = Field(..., max_length=1, min_length=0)
    status: LqaConversationStatusEnum | None = None
    correlation: ReferenceCorrelation | None = None


class CommonConversationDtoLqa(CommonConversationDto):
    references: LQAReferences | None = None
    lqaDescription: str | None = None
    type: Literal["LQA"] = "LQA"


class LQAConversationDto(BaseModel):
    id: str | None = None
    type: str | None = Field(None, description="LQA")
    dateCreated: AwareDatetime | None = None
    dateModified: AwareDatetime | None = None
    dateEdited: AwareDatetime | None = None
    createdBy: MentionableUserDto | None = None
    comments: List[CommentDto] | None = None
    status: StatusDto | None = None
    deleted: bool | None = None
    references: LQAReferences | None = None
    lqaDescription: str | None = None


class LQAConversationsListDto(BaseModel):
    conversations: List[LQAConversationDto] | None = None


class PageDtoCommonConversationDto(BaseModel):
    totalElements: int | None = None
    totalPages: int | None = None
    pageSize: int | None = None
    pageNumber: int | None = None
    numberOfElements: int | None = None
    content: List[CommonConversationDto] | None = None
    sort: Sort | None = None


class PlainConversationDto(BaseModel):
    id: str | None = None
    type: str | None = Field(None, description="SEGMENT_TARGET")
    dateCreated: AwareDatetime | None = None
    dateModified: AwareDatetime | None = None
    dateEdited: AwareDatetime | None = None
    createdBy: MentionableUserDto | None = None
    comments: List[CommentDto] | None = None
    status: StatusDto | None = None
    deleted: bool | None = None
    references: PlainReferences | None = None


class PlainConversationsListDto(BaseModel):
    conversations: List[PlainConversationDto] | None = None


class ProjectTemplateTransMemoryListV2Dto(BaseModel):
    transMemories: List[ProjectTemplateTransMemoryV2Dto] | None = None


class CommonConversationDtoSegmentTarget(CommonConversationDto):
    references: PlainReferences | None = None
    type: Literal["SEGMENT_TARGET"] = "SEGMENT_TARGET"


class SearchResponseListTbDto(BaseModel):
    searchResults: List[SearchResponseTbDto] | None = None


class SearchResponseListTmDto(BaseModel):
    searchResults: List[SearchTMResponseDto] | None = None


class SearchResponseListTmDtoV3(BaseModel):
    searchResults: List[SearchTMResponseDtoV3] | None = None


class CommonConversationDtoUnion(
    RootModel[CommonConversationDtoLqa | CommonConversationDtoSegmentTarget]
):
    root: CommonConversationDtoLqa | CommonConversationDtoSegmentTarget = Field(
        ..., discriminator="type", title="CommonConversationDtoUnion"
    )


class AddLqaCommentResultDto(BaseModel):
    id: str | None = Field(None, description="ID of created comment")
    conversation: LQAConversationDto | None = None


class AddPlainCommentResultDto(BaseModel):
    id: str | None = Field(None, description="ID of created comment")
    conversation: PlainConversationDto | None = None


LqaErrorCategoryDto.model_rebuild()
Attribute.model_rebuild()
AsyncRequestDto.model_rebuild()
AsyncRequestV2Dto.model_rebuild()
