# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at https://mozilla.org/MPL/2.0/.
#
# by HacKan (https://hackan.net), 2020-2025.
# This software is provided as-is. You are free to use, share, modify
# and share modifications under the terms of that license, even with
# proprietary code. Attribution is not required to share but is
# appreciated.
"""Blake2Signer: use BLAKE in keyed hashing mode to sign and verify signed data.

The goal of this module is to provide an easy-to-use way to securely sign data and the
main use case is to sign cookies, using BLAKE in keyed hashing mode (read more
about that in https://docs.python.org/3/library/hashlib.html#keyed-hashing). There
are much better packages for other or more general use cases, such as itsdangerous,
Django's Signer, pypaseto, pyjwt, etc. Refer to them if you find this module
lacking features and/or create an issue in the repo to request for it.

Canonical repository: https://gitlab.com/hackancuba/blake2signer

If you think of something else, have questions, concerns or great ideas, please
feel free to contact me.
If you use this code in your app, I would greatly appreciate a "thumbs up"
and to share your use case and implementation :)

See examples and more info in the README.
"""

from . import errors
from .bases import Blake2Signature
from .bases import Blake2SignatureDump
from .signers import Blake2SerializerSigner
from .signers import Blake2Signer
from .signers import Blake2TimestampSigner
from .utils import generate_secret

__version__ = '4.0.0'

__all__ = (
    'Blake2SerializerSigner',
    'Blake2Signature',
    'Blake2SignatureDump',
    'Blake2Signer',
    'Blake2TimestampSigner',
    'errors',
    'generate_secret',
)
