# This file is auto-generated by scripts/generate_stubs.py.
# Do not edit this file directly.

from typing import Any, Dict, List, Optional, Set, Tuple, Union

import symengine as se
import sympy as sp

import QuPRS

class Register:
    def __init__(
        self, size: int | None = None, name: str | None = None, bits=None
    ) -> None:
        """Initialize self.  See help(type(self)) for accurate signature."""
        ...

    def __repr__(self) -> str:
        """Return repr(self)."""
        ...

    @property
    def name(self) -> str:
        """"""
        ...

    @property
    def size(self) -> int:
        """"""
        ...

    def __len__(self):
        """"""
        ...

    def __getitem__(self, key: int):
        """"""
        ...

class F:
    def __init__(self, *regs, data=None, bits=None) -> None:
        """Initialize self.  See help(type(self)) for accurate signature."""
        ...

    def __repr__(self) -> str:
        """Return repr(self)."""
        ...

    def __hash__(self) -> int:
        """Return hash(self)."""
        ...

    def __eq__(self, other: object) -> bool:
        """Return self==value."""
        ...

    @property
    def regs(self) -> Any:
        """"""
        ...

    @property
    def bits(self) -> Any:
        """"""
        ...

    @property
    def data(self) -> Any:
        """"""
        ...

    def __len__(self):
        """"""
        ...

    def __getitem__(self, key: int | se.Symbol | str):
        """"""
        ...

    def sub(self, arg1, arg2):
        """"""
        ...

    def update(self, key: int | se.Symbol | str, value):
        """"""
        ...

    def update_data(self, data):
        """"""
        ...

    def items(self):
        """"""
        ...

class PathSum:
    """
    Core class for PathSum.

    Includes initialization, basic properties, constructors, and the compose method. All
    quantum gate, reduction, and statistics_manager functionalities are dynamically
    added from external modules.
    """

    def __init__(
        self,
        P: se.Expr,
        f: F,
        pathvar: frozenset | set = frozenset(),
        stats: QuPRS.pathsum.statistics.StatisticsManager | None = None,
    ) -> None:
        """Initialize self.  See help(type(self)) for accurate signature."""
        ...

    def __repr__(self) -> str:
        """Return repr(self)."""
        ...

    def __hash__(self) -> int:
        """Return hash(self)."""
        ...

    def __eq__(self, other: object) -> bool:
        """Return self==value."""
        ...

    @property
    def regs(self) -> tuple:
        """"""
        ...

    @property
    def bits(self) -> tuple:
        """"""
        ...

    @property
    def P(self) -> se.Expr:
        """"""
        ...

    @property
    def f(self) -> F:
        """"""
        ...

    @property
    def pathvar(self) -> frozenset:
        """"""
        ...

    @property
    def num_qubits(self) -> int:
        """"""
        ...

    @property
    def num_pathvar(self) -> int:
        """"""
        ...

    @property
    def stats(self) -> QuPRS.pathsum.statistics.StatisticsManager:
        """"""
        ...

    def get_reduction_counts(self) -> dict:
        """Get a copy of all reduction rule counts for this instance."""
        ...

    def get_reduction_count(self, key: str) -> int:
        """Get the count for a specific reduction rule for this instance."""
        ...

    def get_reduction_hitrate(self) -> float:
        """Calculate the hit rate of reduction rules for this instance."""
        ...

    def reset_reduction_counts(self):
        """Reset all reduction rule counts for this instance to 0."""
        ...

    def set_reduction_switch(self, value: bool) -> None:
        """Set the reduction switch for this instance."""
        ...

    def is_reduction_enabled(self) -> bool:
        """Check if reduction is enabled for this instance."""
        ...

    @staticmethod
    def QuantumCircuit(
        *regs: Register | int, initial_state: bool | list | tuple = None
    ) -> "PathSum":
        """"""
        ...

    @staticmethod
    def load_from_qasm_file(
        filename: str, initial_state: bool | list | tuple = None
    ) -> "PathSum":
        """"""
        ...

    @staticmethod
    def load_from_qasm_str(
        program: str, initial_state: bool | list | tuple = None
    ) -> "PathSum":
        """"""
        ...

    def compose(self, other_pathsum: "PathSum") -> "PathSum":
        """"""
        ...

    def reduction(pathsum: "'PathSum'") -> "'PathSum'":
        """
        Apply simplification rules to a PathSum object.
        This logic is extracted from the original PathSum.reduction method.
        """
        ...
    # --- Dynamically Injected Gate Methods ---

    def CRk(
        self,
        k: "int",
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CRK gate to the specified qubit.

        Args:
            k (int): The integer parameter for the controlled rotation.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CRK gate.
        """
        ...

    def CRkdg(
        self,
        k: "int",
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CRKDG gate to the specified qubit.

        Args:
            k (int): The integer parameter for the controlled rotation.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CRKDG gate.
        """
        ...

    def ccx(
        self,
        control_qubit1: "int | str | se.Symbol",
        control_qubit2: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CCX gate to the specified qubit.

        Args:
            control_qubit1 (int | str | se.Symbol): The first control qubit.
            control_qubit2 (int | str | se.Symbol): The second control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CCX gate.
        """
        ...

    def ch(
        self,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CH gate to the specified qubit.

        Args:
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CH gate.
        """
        ...

    def cp(
        self,
        theta,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CP gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CP gate.
        """
        ...

    def crx(
        self,
        theta,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CRX gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CRX gate.
        """
        ...

    def cry(
        self,
        theta,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CRY gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CRY gate.
        """
        ...

    def crz(
        self,
        theta,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CRZ gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CRZ gate.
        """
        ...

    def cu(
        self,
        theta,
        phi,
        lam,
        gamma,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CU gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            phi (Any): The rotation angle phi in radians.
            lam (Any): The rotation angle lambda in radians.
            gamma (Any): The global phase factor.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CU gate.
        """
        ...

    def cu1(
        self,
        theta,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CU1 gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CU1 gate.
        """
        ...

    def cu3(
        self,
        theta,
        phi,
        lam,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CU3 gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            phi (Any): The rotation angle phi in radians.
            lam (Any): The rotation angle lambda in radians.
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CU3 gate.
        """
        ...

    def cx(
        self,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CX gate to the specified qubit.

        Args:
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CX gate.
        """
        ...

    def cy(
        self,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CY gate to the specified qubit.

        Args:
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CY gate.
        """
        ...

    def cz(
        self,
        control_qubit: "int | str | se.Symbol",
        target_qubit: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the CZ gate to the specified qubit.

        Args:
            control_qubit (int | str | se.Symbol): The control qubit.
            target_qubit (int | str | se.Symbol): The target qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the CZ gate.
        """
        ...

    def h(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the H gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the H gate.
        """
        ...

    def id(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the ID gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the ID gate.
        """
        ...

    def mcx(
        self, *qubits: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the MCX gate to the specified qubit.

        Args:
            qubits (int | str | se.Symbol): A list of qubits to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the MCX gate.
        """
        ...

    def p(
        self, theta, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the P gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the P gate.
        """
        ...

    def rx(
        self, theta, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the RX gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the RX gate.
        """
        ...

    def ry(
        self, theta, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the RY gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the RY gate.
        """
        ...

    def rz(
        self, theta, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the RZ gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the RZ gate.
        """
        ...

    def s(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the S gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the S gate.
        """
        ...

    def sdg(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the SDG gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the SDG gate.
        """
        ...

    def swap(
        self,
        qubit1: "int | str | se.Symbol",
        qubit2: "int | str | se.Symbol",
        is_bra: "bool" = False,
    ) -> "PathSum":
        """
        Applies the SWAP gate to the specified qubit.

        Args:
            qubit1 (int | str | se.Symbol): The first qubit.
            qubit2 (int | str | se.Symbol): The second qubit.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the SWAP gate.
        """
        ...

    def sx(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the SX gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the SX gate.
        """
        ...

    def sxdg(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the SXDG gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the SXDG gate.
        """
        ...

    def t(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the T gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the T gate.
        """
        ...

    def tdg(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the TDG gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the TDG gate.
        """
        ...

    def u(
        self, theta, phi, lam, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the U gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            phi (Any): The rotation angle phi in radians.
            lam (Any): The rotation angle lambda in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the U gate.
        """
        ...

    def u1(
        self, theta, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the U1 gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the U1 gate.
        """
        ...

    def u2(
        self, phi, lam, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the U2 gate to the specified qubit.

        Args:
            phi (Any): The rotation angle phi in radians.
            lam (Any): The rotation angle lambda in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the U2 gate.
        """
        ...

    def u3(
        self, theta, phi, lam, qubit: "int | str | se.Symbol", is_bra: "bool" = False
    ) -> "PathSum":
        """
        Applies the U3 gate to the specified qubit.

        Args:
            theta (Any): The rotation angle theta in radians.
            phi (Any): The rotation angle phi in radians.
            lam (Any): The rotation angle lambda in radians.
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the U3 gate.
        """
        ...

    def x(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the X gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the X gate.
        """
        ...

    def y(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the Y gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the Y gate.
        """
        ...

    def z(self, qubit: "int | str | se.Symbol", is_bra: "bool" = False) -> "PathSum":
        """
        Applies the Z gate to the specified qubit.

        Args:
            qubit (int | str | se.Symbol): The qubit to which the gate is applied.
            is_bra (bool): Whether the input is a bra state. Defaults to False.

        Returns:
            PathSum: The resulting PathSum object after applying the Z gate.
        """
        ...
