// This file is @generated by prost-build.
///
/// _RecordInfo, _RequestInfo: extra info for all records and requests
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RecordInfo {
    #[prost(string, tag = "1")]
    pub stream_id: ::prost::alloc::string::String,
    #[prost(string, tag = "100")]
    pub tracelog_id: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RequestInfo {
    #[prost(string, tag = "1")]
    pub stream_id: ::prost::alloc::string::String,
}
///
/// _ResultInfo: extra info for all results
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResultInfo {
    #[prost(string, tag = "100")]
    pub tracelog_id: ::prost::alloc::string::String,
}
///
/// Telemetry
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TelemetryRecord {
    #[prost(message, optional, tag = "1")]
    pub imports_init: ::core::option::Option<Imports>,
    #[prost(message, optional, tag = "2")]
    pub imports_finish: ::core::option::Option<Imports>,
    #[prost(message, optional, tag = "3")]
    pub feature: ::core::option::Option<Feature>,
    #[prost(string, tag = "4")]
    pub python_version: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub cli_version: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub huggingface_version: ::prost::alloc::string::String,
    /// string  framework = 7;
    #[prost(message, optional, tag = "8")]
    pub env: ::core::option::Option<Env>,
    #[prost(message, optional, tag = "9")]
    pub label: ::core::option::Option<Labels>,
    #[prost(message, optional, tag = "10")]
    pub deprecated: ::core::option::Option<Deprecated>,
    #[prost(message, optional, tag = "11")]
    pub issues: ::core::option::Option<Issues>,
    #[prost(string, tag = "12")]
    pub core_version: ::prost::alloc::string::String,
    #[prost(string, tag = "13")]
    pub platform: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TelemetryResult {}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Imports {
    #[prost(bool, tag = "1")]
    pub torch: bool,
    #[prost(bool, tag = "2")]
    pub keras: bool,
    #[prost(bool, tag = "3")]
    pub tensorflow: bool,
    #[prost(bool, tag = "4")]
    pub fastai: bool,
    #[prost(bool, tag = "5")]
    pub sklearn: bool,
    #[prost(bool, tag = "6")]
    pub xgboost: bool,
    #[prost(bool, tag = "7")]
    pub catboost: bool,
    #[prost(bool, tag = "8")]
    pub lightgbm: bool,
    #[prost(bool, tag = "9")]
    pub pytorch_lightning: bool,
    #[prost(bool, tag = "10")]
    pub ignite: bool,
    #[prost(bool, tag = "11")]
    pub transformers: bool,
    #[prost(bool, tag = "12")]
    pub jax: bool,
    #[prost(bool, tag = "13")]
    pub metaflow: bool,
    #[prost(bool, tag = "14")]
    pub allennlp: bool,
    #[prost(bool, tag = "15")]
    pub autogluon: bool,
    #[prost(bool, tag = "16")]
    pub autokeras: bool,
    #[prost(bool, tag = "18")]
    pub catalyst: bool,
    #[prost(bool, tag = "21")]
    pub deepchem: bool,
    #[prost(bool, tag = "22")]
    pub deepctr: bool,
    #[prost(bool, tag = "28")]
    pub pycaret: bool,
    #[prost(bool, tag = "29")]
    pub pytorchvideo: bool,
    #[prost(bool, tag = "30")]
    pub ray: bool,
    #[prost(bool, tag = "31")]
    pub simpletransformers: bool,
    #[prost(bool, tag = "32")]
    pub skorch: bool,
    #[prost(bool, tag = "33")]
    pub spacy: bool,
    #[prost(bool, tag = "34")]
    pub flash: bool,
    #[prost(bool, tag = "35")]
    pub optuna: bool,
    #[prost(bool, tag = "36")]
    pub recbole: bool,
    #[prost(bool, tag = "37")]
    pub mmcv: bool,
    #[prost(bool, tag = "38")]
    pub mmdet: bool,
    #[prost(bool, tag = "39")]
    pub torchdrug: bool,
    #[prost(bool, tag = "40")]
    pub torchtext: bool,
    #[prost(bool, tag = "41")]
    pub torchvision: bool,
    #[prost(bool, tag = "42")]
    pub elegy: bool,
    #[prost(bool, tag = "43")]
    pub detectron2: bool,
    #[prost(bool, tag = "44")]
    pub flair: bool,
    #[prost(bool, tag = "45")]
    pub flax: bool,
    #[prost(bool, tag = "46")]
    pub syft: bool,
    #[prost(bool, tag = "47")]
    pub tts: bool,
    #[prost(bool, tag = "48")]
    pub monai: bool,
    #[prost(bool, tag = "49")]
    pub huggingface_hub: bool,
    #[prost(bool, tag = "50")]
    pub hydra: bool,
    #[prost(bool, tag = "51")]
    pub datasets: bool,
    #[prost(bool, tag = "52")]
    pub sacred: bool,
    #[prost(bool, tag = "53")]
    pub joblib: bool,
    #[prost(bool, tag = "54")]
    pub dask: bool,
    #[prost(bool, tag = "56")]
    pub paddleocr: bool,
    #[prost(bool, tag = "57")]
    pub ppdet: bool,
    #[prost(bool, tag = "58")]
    pub paddleseg: bool,
    #[prost(bool, tag = "59")]
    pub paddlenlp: bool,
    #[prost(bool, tag = "60")]
    pub mmseg: bool,
    #[prost(bool, tag = "61")]
    pub mmocr: bool,
    #[prost(bool, tag = "62")]
    pub mmcls: bool,
    #[prost(bool, tag = "63")]
    pub timm: bool,
    #[prost(bool, tag = "64")]
    pub fairseq: bool,
    #[prost(bool, tag = "65")]
    pub deepchecks: bool,
    #[prost(bool, tag = "66")]
    pub composer: bool,
    #[prost(bool, tag = "67")]
    pub sparseml: bool,
    #[prost(bool, tag = "68")]
    pub anomalib: bool,
    #[prost(bool, tag = "69")]
    pub zenml: bool,
    #[prost(bool, tag = "70")]
    pub colossalai: bool,
    #[prost(bool, tag = "71")]
    pub accelerate: bool,
    #[prost(bool, tag = "72")]
    pub merlin: bool,
    #[prost(bool, tag = "73")]
    pub nanodet: bool,
    #[prost(bool, tag = "74")]
    pub segmentation_models_pytorch: bool,
    #[prost(bool, tag = "75")]
    pub sentence_transformers: bool,
    #[prost(bool, tag = "76")]
    pub dgl: bool,
    #[prost(bool, tag = "77")]
    pub torch_geometric: bool,
    #[prost(bool, tag = "78")]
    pub jina: bool,
    #[prost(bool, tag = "79")]
    pub kornia: bool,
    #[prost(bool, tag = "80")]
    pub albumentations: bool,
    #[prost(bool, tag = "81")]
    pub keras_cv: bool,
    #[prost(bool, tag = "82")]
    pub mmengine: bool,
    #[prost(bool, tag = "83")]
    pub diffusers: bool,
    #[prost(bool, tag = "84")]
    pub trl: bool,
    #[prost(bool, tag = "85")]
    pub trlx: bool,
    #[prost(bool, tag = "86")]
    pub langchain: bool,
    #[prost(bool, tag = "87")]
    pub llama_index: bool,
    #[prost(bool, tag = "88")]
    pub stability_sdk: bool,
    #[prost(bool, tag = "89")]
    pub prefect: bool,
    #[prost(bool, tag = "90")]
    pub prefect_ray: bool,
    /// pinecone-client
    #[prost(bool, tag = "91")]
    pub pinecone: bool,
    #[prost(bool, tag = "92")]
    pub chromadb: bool,
    /// weaviate-client
    #[prost(bool, tag = "93")]
    pub weaviate: bool,
    #[prost(bool, tag = "94")]
    pub promptlayer: bool,
    #[prost(bool, tag = "95")]
    pub openai: bool,
    #[prost(bool, tag = "96")]
    pub cohere: bool,
    #[prost(bool, tag = "97")]
    pub anthropic: bool,
    #[prost(bool, tag = "98")]
    pub peft: bool,
    #[prost(bool, tag = "99")]
    pub optimum: bool,
    #[prost(bool, tag = "100")]
    pub evaluate: bool,
    #[prost(bool, tag = "101")]
    pub langflow: bool,
    /// keras-core
    #[prost(bool, tag = "102")]
    pub keras_core: bool,
    /// lightning-fabric
    #[prost(bool, tag = "103")]
    pub lightning_fabric: bool,
    /// curated-transformers
    #[prost(bool, tag = "104")]
    pub curated_transformers: bool,
    #[prost(bool, tag = "105")]
    pub orjson: bool,
    /// lightning, formerly pytorch-lightning
    #[prost(bool, tag = "106")]
    pub lightning: bool,
    #[prost(bool, tag = "107")]
    pub dspy: bool,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Feature {
    /// wandb.watch() called
    #[prost(bool, tag = "1")]
    pub watch: bool,
    /// wandb.finish() called
    #[prost(bool, tag = "2")]
    pub finish: bool,
    /// wandb.save() called
    #[prost(bool, tag = "3")]
    pub save: bool,
    /// offline run was synced
    #[prost(bool, tag = "4")]
    pub offline: bool,
    /// run was resumed
    #[prost(bool, tag = "5")]
    pub resumed: bool,
    /// grpc-server (java integration)
    #[prost(bool, tag = "6")]
    pub grpc: bool,
    /// define_metric() called
    #[prost(bool, tag = "7")]
    pub metric: bool,
    /// Keras WandbCallback used
    #[prost(bool, tag = "8")]
    pub keras: bool,
    /// User is using sagemaker
    #[prost(bool, tag = "9")]
    pub sagemaker: bool,
    /// Artifact(incremental=True) used
    #[prost(bool, tag = "10")]
    pub artifact_incremental: bool,
    /// Using metaflow integration
    #[prost(bool, tag = "11")]
    pub metaflow: bool,
    /// Using prodigy integration
    #[prost(bool, tag = "12")]
    pub prodigy: bool,
    /// users set run name from wandb.init
    #[prost(bool, tag = "13")]
    pub set_init_name: bool,
    /// users set run id from wandb.init
    #[prost(bool, tag = "14")]
    pub set_init_id: bool,
    /// users set tags within wandb.init
    #[prost(bool, tag = "15")]
    pub set_init_tags: bool,
    /// users set run config in wandb.init
    #[prost(bool, tag = "16")]
    pub set_init_config: bool,
    /// user sets run name via wandb.run.name = ...
    #[prost(bool, tag = "17")]
    pub set_run_name: bool,
    /// user sets run name via wandb.run.tags = ...
    #[prost(bool, tag = "18")]
    pub set_run_tags: bool,
    /// users set key in run config via run.config.key
    #[prost(bool, tag = "19")]
    pub set_config_item: bool,
    /// or run.config\["key"\]
    ///
    /// run is created through wandb launch
    #[prost(bool, tag = "20")]
    pub launch: bool,
    /// wandb.profiler.torch_trace_handler() called
    #[prost(bool, tag = "21")]
    pub torch_profiler_trace: bool,
    /// Using stable_baselines3 integration
    #[prost(bool, tag = "22")]
    pub sb3: bool,
    /// wandb.init() called in the same process returning previous run
    #[prost(bool, tag = "24")]
    pub init_return_run: bool,
    /// lightgbm callback used
    #[prost(bool, tag = "25")]
    pub lightgbm_wandb_callback: bool,
    /// lightgbm log summary used
    #[prost(bool, tag = "26")]
    pub lightgbm_log_summary: bool,
    /// catboost callback used
    #[prost(bool, tag = "27")]
    pub catboost_wandb_callback: bool,
    /// catboost log summary used
    #[prost(bool, tag = "28")]
    pub catboost_log_summary: bool,
    /// wandb.tensorflow.log or wandb.tensorboard.log used
    #[prost(bool, tag = "29")]
    pub tensorboard_log: bool,
    /// wandb.tensorflow.WandbHook used
    #[prost(bool, tag = "30")]
    pub estimator_hook: bool,
    /// xgboost callback used
    #[prost(bool, tag = "31")]
    pub xgboost_wandb_callback: bool,
    /// xgboost old callback used (to be depreciated)
    #[prost(bool, tag = "32")]
    pub xgboost_old_wandb_callback: bool,
    /// attach to a run in another process
    #[prost(bool, tag = "33")]
    pub attach: bool,
    /// wandb.tensorboard.patch(...)
    #[prost(bool, tag = "34")]
    pub tensorboard_patch: bool,
    /// wandb.init(sync_tensorboard=True)
    #[prost(bool, tag = "35")]
    pub tensorboard_sync: bool,
    /// wandb.integration.kfp.wandb_log
    #[prost(bool, tag = "36")]
    pub kfp_wandb_log: bool,
    /// Run might have been overwritten
    #[prost(bool, tag = "37")]
    pub maybe_run_overwrite: bool,
    /// Keras WandbMetricsLogger used
    #[prost(bool, tag = "38")]
    pub keras_metrics_logger: bool,
    /// Keras WandbModelCheckpoint used
    #[prost(bool, tag = "39")]
    pub keras_model_checkpoint: bool,
    /// Keras WandbEvalCallback used
    #[prost(bool, tag = "40")]
    pub keras_wandb_eval_callback: bool,
    /// Hit flow control threshold
    #[prost(bool, tag = "41")]
    pub flow_control_overflow: bool,
    /// Run was synced with wandb sync
    #[prost(bool, tag = "42")]
    pub sync: bool,
    /// Flow control disabled by user
    #[prost(bool, tag = "43")]
    pub flow_control_disabled: bool,
    /// Flow control customized by user
    #[prost(bool, tag = "44")]
    pub flow_control_custom: bool,
    /// Consuming metrics from an OpenMetrics endpoint
    #[prost(bool, tag = "46")]
    pub open_metrics: bool,
    /// Ultralytics YOLOv8 integration callbacks used
    #[prost(bool, tag = "47")]
    pub ultralytics_yolov8: bool,
    /// Using Import API for MLFlow
    #[prost(bool, tag = "48")]
    pub importer_mlflow: bool,
    /// Using wandb sync for tfevent files
    #[prost(bool, tag = "49")]
    pub sync_tfevents: bool,
    /// Async file uploads enabled by user
    #[prost(bool, tag = "50")]
    pub async_uploads: bool,
    /// OpenAI autolog used
    #[prost(bool, tag = "51")]
    pub openai_autolog: bool,
    /// Langchain wandb tracer callback used
    #[prost(bool, tag = "52")]
    pub langchain_tracer: bool,
    /// Cohere autolog used
    #[prost(bool, tag = "53")]
    pub cohere_autolog: bool,
    /// HuggingFace Autologging
    #[prost(bool, tag = "54")]
    pub hf_pipeline_autolog: bool,
    /// Using c wandb library
    #[prost(bool, tag = "56")]
    pub lib_c: bool,
    /// Using cpp wandb library
    #[prost(bool, tag = "57")]
    pub lib_cpp: bool,
    /// Using openai finetuning WandbLogger
    #[prost(bool, tag = "58")]
    pub openai_finetuning: bool,
    /// Using Diffusers autologger
    #[prost(bool, tag = "59")]
    pub diffusers_autolog: bool,
    /// Using Lightning Fabric logger
    #[prost(bool, tag = "60")]
    pub lightning_fabric_logger: bool,
    /// step was set in wandb.log
    #[prost(bool, tag = "61")]
    pub set_step_log: bool,
    /// summary was set by the user
    #[prost(bool, tag = "62")]
    pub set_summary: bool,
    /// summary arg passed to define_metric
    #[prost(bool, tag = "63")]
    pub metric_summary: bool,
    /// goal arg passed to define_metric
    #[prost(bool, tag = "64")]
    pub metric_goal: bool,
    /// hidden arg passed to define_metric
    #[prost(bool, tag = "65")]
    pub metric_hidden: bool,
    /// step_sync arg passed to define_metric
    #[prost(bool, tag = "66")]
    pub metric_step_sync: bool,
    /// shared mode was added in wandb.Settings
    #[prost(bool, tag = "67")]
    pub shared_mode: bool,
    /// server-side derived summary computation was enabled
    #[prost(bool, tag = "68")]
    pub server_side_derived_summary: bool,
    /// User set the x_label value
    #[prost(bool, tag = "69")]
    pub user_provided_label: bool,
    /// DCGM profiling was enabled
    #[prost(bool, tag = "70")]
    pub dcgm_profiling_enabled: bool,
    /// User created a forked run
    #[prost(bool, tag = "71")]
    pub fork_mode: bool,
    /// User created a rewound run
    #[prost(bool, tag = "72")]
    pub rewind_mode: bool,
    /// User using WandbDSPyCallback
    #[prost(bool, tag = "73")]
    pub dspy_callback: bool,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Env {
    /// jupyter env detected
    #[prost(bool, tag = "1")]
    pub jupyter: bool,
    /// kaggle env detected
    #[prost(bool, tag = "2")]
    pub kaggle: bool,
    /// windows detected
    #[prost(bool, tag = "3")]
    pub windows: bool,
    /// apple silicon M1 gpu found
    #[prost(bool, tag = "4")]
    pub m1_gpu: bool,
    /// AWS Trainium env detected
    #[prost(bool, tag = "10")]
    pub trainium: bool,
    /// pex env detected
    #[prost(bool, tag = "11")]
    pub pex: bool,
    /// colab env detected
    #[prost(bool, tag = "12")]
    pub colab: bool,
    /// ipython env detected
    #[prost(bool, tag = "13")]
    pub ipython: bool,
    /// running in AWS Lambda
    #[prost(bool, tag = "14")]
    pub aws_lambda: bool,
    /// AMD GPU detected
    #[prost(bool, tag = "15")]
    pub amd_gpu: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Labels {
    /// code identification
    #[prost(string, tag = "1")]
    pub code_string: ::prost::alloc::string::String,
    /// repo identification
    #[prost(string, tag = "2")]
    pub repo_string: ::prost::alloc::string::String,
    /// code version
    #[prost(string, tag = "3")]
    pub code_version: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Deprecated {
    /// wandb.integration.keras.WandbCallback(data_type=...) called
    #[prost(bool, tag = "1")]
    pub keras_callback_data_type: bool,
    /// wandb.plots.* called
    #[prost(bool, tag = "5")]
    pub plots: bool,
    /// wandb.init(config_include_keys=...) called
    #[prost(bool, tag = "7")]
    pub init_config_include_keys: bool,
    /// wandb.init(config_exclude_keys=...) called
    #[prost(bool, tag = "8")]
    pub init_config_exclude_keys: bool,
    /// wandb.integration.keras.WandbCallback(save_model=True) called
    #[prost(bool, tag = "9")]
    pub keras_callback_save_model: bool,
    /// wandb.integration.langchain.WandbTracer called
    #[prost(bool, tag = "10")]
    pub langchain_tracer: bool,
    /// wandb.sdk.artifacts.artifact.Artifact.get_path(...) called
    #[prost(bool, tag = "11")]
    pub artifact_get_path: bool,
    /// wandb.sdk.artifacts.artifact_manifest_entry.ArtifactManifestEntry.name() called
    #[prost(bool, tag = "12")]
    pub artifactmanifestentry_name: bool,
    /// wandb.Api().artifact_versions(...) called
    #[prost(bool, tag = "13")]
    pub api_artifact_versions: bool,
    /// wandb.sdk.artifact_collection.ArtifactCollection.change_type(...) called
    #[prost(bool, tag = "14")]
    pub artifact_collection_change_type: bool,
    /// wandb.run.define_metric() called with summary="copy"
    #[prost(bool, tag = "15")]
    pub run_define_metric_copy: bool,
    /// wandb.sdk.lib.disabled.RunDisabled used
    #[prost(bool, tag = "16")]
    pub run_disabled: bool,
    /// wandb.integration.keras.WandbCallback used
    #[prost(bool, tag = "17")]
    pub keras_callback: bool,
    /// wandb.run.define_metric() called with summary="best" and goal="maximize/minimize"
    #[prost(bool, tag = "18")]
    pub run_define_metric_best_goal: bool,
    /// wandb.run.finish(quiet=...) called
    #[prost(bool, tag = "19")]
    pub run_finish_quiet: bool,
    /// reinit setting set to a boolean value
    #[prost(bool, tag = "20")]
    pub run_reinit_bool: bool,
    /// wandb.run.get_url() called
    #[prost(bool, tag = "21")]
    pub run_get_url: bool,
    /// wandb.run.project_name() called
    #[prost(bool, tag = "22")]
    pub run_project_name: bool,
    /// wandb.run.get_project_url() called
    #[prost(bool, tag = "23")]
    pub run_get_project_url: bool,
    /// wandb.run.get_sweep_url() called
    #[prost(bool, tag = "24")]
    pub run_get_sweep_url: bool,
    /// wandb.run.use_artifact(use_as=...) called
    #[prost(bool, tag = "25")]
    pub run_use_artifact_use_as: bool,
    /// wandb.sdk.artifacts.artifact.Artifact.use_as() called
    #[prost(bool, tag = "26")]
    pub artifact_use_as: bool,
    /// wandb.sdk.artifacts.artifact.Artifact(use_as=...) called
    #[prost(bool, tag = "27")]
    pub artifact_init_use_as: bool,
    /// wandb.beta.workflows.log_model() called
    #[prost(bool, tag = "28")]
    pub beta_workflows_log_model: bool,
    /// wandb.beta.workflows.use_model() called
    #[prost(bool, tag = "29")]
    pub beta_workflows_use_model: bool,
    /// wandb.beta.workflows.link_model() called
    #[prost(bool, tag = "30")]
    pub beta_workflows_link_model: bool,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Issues {
    /// validation warnings for settings
    #[prost(bool, tag = "1")]
    pub settings_validation_warnings: bool,
    /// unexpected settings init args
    #[prost(bool, tag = "2")]
    pub settings_unexpected_args: bool,
    /// settings preprocessing warnings
    #[prost(bool, tag = "3")]
    pub settings_preprocessing_warnings: bool,
}
///
/// Record: joined record for message passing and persistence
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Record {
    #[prost(int64, tag = "1")]
    pub num: i64,
    #[prost(message, optional, tag = "16")]
    pub control: ::core::option::Option<Control>,
    #[prost(string, tag = "19")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
    #[prost(
        oneof = "record::RecordType",
        tags = "2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 17, 18, 20, 21, 22, 23, 24, 25, 26, 100"
    )]
    pub record_type: ::core::option::Option<record::RecordType>,
}
/// Nested message and enum types in `Record`.
pub mod record {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum RecordType {
        /// Low numbers for more frequent data
        #[prost(message, tag = "2")]
        History(super::HistoryRecord),
        #[prost(message, tag = "3")]
        Summary(super::SummaryRecord),
        #[prost(message, tag = "4")]
        Output(super::OutputRecord),
        #[prost(message, tag = "5")]
        Config(super::ConfigRecord),
        #[prost(message, tag = "6")]
        Files(super::FilesRecord),
        #[prost(message, tag = "7")]
        Stats(super::StatsRecord),
        #[prost(message, tag = "8")]
        Artifact(super::ArtifactRecord),
        #[prost(message, tag = "9")]
        Tbrecord(super::TbRecord),
        #[prost(message, tag = "10")]
        Alert(super::AlertRecord),
        #[prost(message, tag = "11")]
        Telemetry(super::TelemetryRecord),
        #[prost(message, tag = "12")]
        Metric(super::MetricRecord),
        #[prost(message, tag = "13")]
        OutputRaw(super::OutputRawRecord),
        /// Higher numbers for less frequent data
        #[prost(message, tag = "17")]
        Run(super::RunRecord),
        #[prost(message, tag = "18")]
        Exit(super::RunExitRecord),
        #[prost(message, tag = "20")]
        Final(super::FinalRecord),
        #[prost(message, tag = "21")]
        Header(super::HeaderRecord),
        #[prost(message, tag = "22")]
        Footer(super::FooterRecord),
        #[prost(message, tag = "23")]
        Preempting(super::RunPreemptingRecord),
        /// Removed but kept to avoid panics in `wandb sync`.
        #[prost(message, tag = "24")]
        NoopLinkArtifact(()),
        #[prost(message, tag = "25")]
        UseArtifact(super::UseArtifactRecord),
        #[prost(message, tag = "26")]
        Environment(super::EnvironmentRecord),
        /// request field does not belong here longterm
        #[prost(message, tag = "100")]
        Request(super::Request),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Control {
    /// record is expecting a result
    #[prost(bool, tag = "1")]
    pub req_resp: bool,
    /// should not be persisted or synchronized
    #[prost(bool, tag = "2")]
    pub local: bool,
    /// used by service transport to identify correct stream
    #[prost(string, tag = "3")]
    pub relay_id: ::prost::alloc::string::String,
    /// mailbox slot
    #[prost(string, tag = "4")]
    pub mailbox_slot: ::prost::alloc::string::String,
    /// message to sender
    #[prost(bool, tag = "5")]
    pub always_send: bool,
    /// message should be passed to flow control
    #[prost(bool, tag = "6")]
    pub flow_control: bool,
    /// end of message offset of this written message
    #[prost(int64, tag = "7")]
    pub end_offset: i64,
    /// connection id
    #[prost(string, tag = "8")]
    pub connection_id: ::prost::alloc::string::String,
}
///
/// Result: all results
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Result {
    #[prost(message, optional, tag = "16")]
    pub control: ::core::option::Option<Control>,
    #[prost(string, tag = "24")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<ResultInfo>,
    #[prost(oneof = "result::ResultType", tags = "17, 18, 20, 21, 22, 23, 100")]
    pub result_type: ::core::option::Option<result::ResultType>,
}
/// Nested message and enum types in `Result`.
pub mod result {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ResultType {
        #[prost(message, tag = "17")]
        RunResult(super::RunUpdateResult),
        #[prost(message, tag = "18")]
        ExitResult(super::RunExitResult),
        #[prost(message, tag = "20")]
        LogResult(super::HistoryResult),
        #[prost(message, tag = "21")]
        SummaryResult(super::SummaryResult),
        #[prost(message, tag = "22")]
        OutputResult(super::OutputResult),
        #[prost(message, tag = "23")]
        ConfigResult(super::ConfigResult),
        /// response field does not belong here longterm
        #[prost(message, tag = "100")]
        Response(super::Response),
    }
}
///
/// FinalRecord
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FinalRecord {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
///
/// Version definition
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VersionInfo {
    /// The version of the SDK backend that produced the data
    #[prost(string, tag = "1")]
    pub producer: ::prost::alloc::string::String,
    /// Minimum version of the wandb server that can read the data
    #[prost(string, tag = "2")]
    pub min_consumer: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
///
/// HeaderRecord
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HeaderRecord {
    #[prost(message, optional, tag = "1")]
    pub version_info: ::core::option::Option<VersionInfo>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
///
/// FooterRecord
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FooterRecord {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
/// A point in a run from which another run can be branched.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BranchPoint {
    /// The ID of the run to branch from.
    #[prost(string, tag = "1")]
    pub run: ::prost::alloc::string::String,
    /// The value of the metric to branch at.
    #[prost(double, tag = "2")]
    pub value: f64,
    /// The name of the metric to use to find a branch point.
    #[prost(string, tag = "3")]
    pub metric: ::prost::alloc::string::String,
}
///
/// RunRecord: wandb/sdk/wandb_run/Run
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunRecord {
    #[prost(string, tag = "1")]
    pub run_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub entity: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub project: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub config: ::core::option::Option<ConfigRecord>,
    #[prost(message, optional, tag = "5")]
    pub summary: ::core::option::Option<SummaryRecord>,
    #[prost(string, tag = "6")]
    pub run_group: ::prost::alloc::string::String,
    #[prost(string, tag = "7")]
    pub job_type: ::prost::alloc::string::String,
    #[prost(string, tag = "8")]
    pub display_name: ::prost::alloc::string::String,
    #[prost(string, tag = "9")]
    pub notes: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "10")]
    pub tags: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "11")]
    pub settings: ::core::option::Option<SettingsRecord>,
    #[prost(string, tag = "12")]
    pub sweep_id: ::prost::alloc::string::String,
    #[prost(string, tag = "13")]
    pub host: ::prost::alloc::string::String,
    #[prost(int64, tag = "14")]
    pub starting_step: i64,
    #[prost(string, tag = "16")]
    pub storage_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "17")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(bool, tag = "18")]
    pub resumed: bool,
    #[prost(message, optional, tag = "19")]
    pub telemetry: ::core::option::Option<TelemetryRecord>,
    #[prost(int32, tag = "20")]
    pub runtime: i32,
    #[prost(message, optional, tag = "21")]
    pub git: ::core::option::Option<GitRepoRecord>,
    #[prost(bool, tag = "22")]
    pub forked: bool,
    /// Information about the source if this is a fork or rewind of another run.
    #[prost(message, optional, tag = "23")]
    pub branch_point: ::core::option::Option<BranchPoint>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GitRepoRecord {
    #[prost(string, tag = "1")]
    pub remote_url: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub commit: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunUpdateResult {
    #[prost(message, optional, tag = "1")]
    pub run: ::core::option::Option<RunRecord>,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<ErrorInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ErrorInfo {
    #[prost(string, tag = "1")]
    pub message: ::prost::alloc::string::String,
    #[prost(enumeration = "error_info::ErrorCode", tag = "2")]
    pub code: i32,
}
/// Nested message and enum types in `ErrorInfo`.
pub mod error_info {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum ErrorCode {
        Unknown = 0,
        Communication = 1,
        Authentication = 2,
        Usage = 3,
        Unsupported = 4,
    }
    impl ErrorCode {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unknown => "UNKNOWN",
                Self::Communication => "COMMUNICATION",
                Self::Authentication => "AUTHENTICATION",
                Self::Usage => "USAGE",
                Self::Unsupported => "UNSUPPORTED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNKNOWN" => Some(Self::Unknown),
                "COMMUNICATION" => Some(Self::Communication),
                "AUTHENTICATION" => Some(Self::Authentication),
                "USAGE" => Some(Self::Usage),
                "UNSUPPORTED" => Some(Self::Unsupported),
                _ => None,
            }
        }
    }
}
///
/// RunExitRecord: exit status of process
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunExitRecord {
    #[prost(int32, tag = "1")]
    pub exit_code: i32,
    #[prost(int32, tag = "2")]
    pub runtime: i32,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RunExitResult {}
///
/// RunPreemptingRecord: run being preempted
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunPreemptingRecord {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RunPreemptingResult {}
///
/// SettingsRecord: wandb/sdk/wandb_settings/Settings
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SettingsRecord {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<SettingsItem>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SettingsItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, tag = "16")]
    pub value_json: ::prost::alloc::string::String,
}
///
/// HistoryRecord: wandb/sdk/wandb_history/History
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct HistoryStep {
    #[prost(int64, tag = "1")]
    pub num: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HistoryRecord {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<HistoryItem>,
    #[prost(message, optional, tag = "2")]
    pub step: ::core::option::Option<HistoryStep>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
///
/// HistoryItem:
///
/// key and nested_key are mutually exclusive. Only one of them should be set.
/// key is supposedly more performant than nested_key, so nested_key should be
/// only used for nested keys.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HistoryItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub nested_key: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "16")]
    pub value_json: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct HistoryResult {}
///
/// OutputRecord: console output
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OutputRecord {
    #[prost(enumeration = "output_record::OutputType", tag = "1")]
    pub output_type: i32,
    #[prost(message, optional, tag = "2")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "3")]
    pub line: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
/// Nested message and enum types in `OutputRecord`.
pub mod output_record {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum OutputType {
        Stderr = 0,
        Stdout = 1,
    }
    impl OutputType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Stderr => "STDERR",
                Self::Stdout => "STDOUT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "STDERR" => Some(Self::Stderr),
                "STDOUT" => Some(Self::Stdout),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct OutputResult {}
///
/// OutputRawRecord: raw console output
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OutputRawRecord {
    #[prost(enumeration = "output_raw_record::OutputType", tag = "1")]
    pub output_type: i32,
    #[prost(message, optional, tag = "2")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "3")]
    pub line: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
/// Nested message and enum types in `OutputRawRecord`.
pub mod output_raw_record {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum OutputType {
        Stderr = 0,
        Stdout = 1,
    }
    impl OutputType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Stderr => "STDERR",
                Self::Stdout => "STDOUT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "STDERR" => Some(Self::Stderr),
                "STDOUT" => Some(Self::Stdout),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct OutputRawResult {}
///
/// MetricRecord: wandb/sdk/wandb_metric/Metric
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MetricRecord {
    /// only name or globname is set
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub glob_name: ::prost::alloc::string::String,
    /// step metric index can be used instead of step_metric when
    /// MetricRecord is encoded in a list of MetricRecords
    #[prost(string, tag = "4")]
    pub step_metric: ::prost::alloc::string::String,
    /// one-based array index
    #[prost(int32, tag = "5")]
    pub step_metric_index: i32,
    #[prost(message, optional, tag = "6")]
    pub options: ::core::option::Option<MetricOptions>,
    #[prost(message, optional, tag = "7")]
    pub summary: ::core::option::Option<MetricSummary>,
    #[prost(enumeration = "metric_record::MetricGoal", tag = "8")]
    pub goal: i32,
    #[prost(message, optional, tag = "9")]
    pub control: ::core::option::Option<MetricControl>,
    #[prost(bool, tag = "10")]
    pub expanded_from_glob: bool,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
/// Nested message and enum types in `MetricRecord`.
pub mod metric_record {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum MetricGoal {
        GoalUnset = 0,
        GoalMinimize = 1,
        GoalMaximize = 2,
    }
    impl MetricGoal {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::GoalUnset => "GOAL_UNSET",
                Self::GoalMinimize => "GOAL_MINIMIZE",
                Self::GoalMaximize => "GOAL_MAXIMIZE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "GOAL_UNSET" => Some(Self::GoalUnset),
                "GOAL_MINIMIZE" => Some(Self::GoalMinimize),
                "GOAL_MAXIMIZE" => Some(Self::GoalMaximize),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MetricResult {}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MetricOptions {
    #[prost(bool, tag = "1")]
    pub step_sync: bool,
    #[prost(bool, tag = "2")]
    pub hidden: bool,
    /// metric explicitly defined (not from glob match or step metric)
    #[prost(bool, tag = "3")]
    pub defined: bool,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MetricControl {
    #[prost(bool, tag = "1")]
    pub overwrite: bool,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MetricSummary {
    #[prost(bool, tag = "1")]
    pub min: bool,
    #[prost(bool, tag = "2")]
    pub max: bool,
    #[prost(bool, tag = "3")]
    pub mean: bool,
    #[prost(bool, tag = "4")]
    pub best: bool,
    #[prost(bool, tag = "5")]
    pub last: bool,
    #[prost(bool, tag = "6")]
    pub none: bool,
    #[prost(bool, tag = "7")]
    pub copy: bool,
    #[prost(bool, tag = "8")]
    pub first: bool,
}
///
/// ConfigRecord: wandb/sdk/wandb_config/Config
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConfigRecord {
    #[prost(message, repeated, tag = "1")]
    pub update: ::prost::alloc::vec::Vec<ConfigItem>,
    #[prost(message, repeated, tag = "2")]
    pub remove: ::prost::alloc::vec::Vec<ConfigItem>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
///
/// ConfigItem:
///
/// key and nested_key are mutually exclusive. Only one of them should be set.
/// key is supposedly more performant than nested_key, so nested_key should be
/// only used for nested keys.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConfigItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub nested_key: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "16")]
    pub value_json: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ConfigResult {}
///
/// SummaryRecord: wandb/sdk/wandb_summary/Summary
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SummaryRecord {
    #[prost(message, repeated, tag = "1")]
    pub update: ::prost::alloc::vec::Vec<SummaryItem>,
    #[prost(message, repeated, tag = "2")]
    pub remove: ::prost::alloc::vec::Vec<SummaryItem>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
///
/// SummaryItem:
///
/// key and nested_key are mutually exclusive. Only one of them should be set.
/// key is supposedly more performant than nested_key, so nested_key should be
/// only used for nested keys.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SummaryItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub nested_key: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "16")]
    pub value_json: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SummaryResult {}
/// Files added to a run, such as through run.save().
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FilesRecord {
    #[prost(message, repeated, tag = "1")]
    pub files: ::prost::alloc::vec::Vec<FilesItem>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
/// One or more files being saved with a run.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FilesItem {
    /// A path or Unix glob relative to the run's files directory.
    #[prost(string, tag = "1")]
    pub path: ::prost::alloc::string::String,
    /// When to upload the file.
    #[prost(enumeration = "files_item::PolicyType", tag = "2")]
    pub policy: i32,
    /// What kind of file it is.
    #[prost(enumeration = "files_item::FileType", tag = "3")]
    pub r#type: i32,
}
/// Nested message and enum types in `FilesItem`.
pub mod files_item {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum PolicyType {
        /// Upload the file immediately.
        Now = 0,
        /// Upload the file during run.finish().
        End = 1,
        /// Re-upload the file continuously as it changes.
        Live = 2,
    }
    impl PolicyType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Now => "NOW",
                Self::End => "END",
                Self::Live => "LIVE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "NOW" => Some(Self::Now),
                "END" => Some(Self::End),
                "LIVE" => Some(Self::Live),
                _ => None,
            }
        }
    }
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum FileType {
        Other = 0,
        Wandb = 1,
        Media = 2,
        Artifact = 3,
    }
    impl FileType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Other => "OTHER",
                Self::Wandb => "WANDB",
                Self::Media => "MEDIA",
                Self::Artifact => "ARTIFACT",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OTHER" => Some(Self::Other),
                "WANDB" => Some(Self::Wandb),
                "MEDIA" => Some(Self::Media),
                "ARTIFACT" => Some(Self::Artifact),
                _ => None,
            }
        }
    }
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FilesResult {}
///
/// StatsRecord: system metrics
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatsRecord {
    #[prost(enumeration = "stats_record::StatsType", tag = "1")]
    pub stats_type: i32,
    #[prost(message, optional, tag = "2")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, repeated, tag = "3")]
    pub item: ::prost::alloc::vec::Vec<StatsItem>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
/// Nested message and enum types in `StatsRecord`.
pub mod stats_record {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum StatsType {
        System = 0,
    }
    impl StatsType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::System => "SYSTEM",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SYSTEM" => Some(Self::System),
                _ => None,
            }
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatsItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, tag = "16")]
    pub value_json: ::prost::alloc::string::String,
}
///
/// ArtifactRecord: track artifacts
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArtifactRecord {
    #[prost(string, tag = "1")]
    pub run_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub project: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub entity: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub r#type: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub digest: ::prost::alloc::string::String,
    #[prost(string, tag = "7")]
    pub description: ::prost::alloc::string::String,
    #[prost(string, tag = "8")]
    pub metadata: ::prost::alloc::string::String,
    #[prost(bool, tag = "9")]
    pub user_created: bool,
    #[prost(bool, tag = "10")]
    pub use_after_commit: bool,
    #[prost(string, repeated, tag = "11")]
    pub aliases: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "12")]
    pub manifest: ::core::option::Option<ArtifactManifest>,
    #[prost(string, tag = "13")]
    pub distributed_id: ::prost::alloc::string::String,
    #[prost(bool, tag = "14")]
    pub finalize: bool,
    #[prost(string, tag = "15")]
    pub client_id: ::prost::alloc::string::String,
    #[prost(string, tag = "16")]
    pub sequence_client_id: ::prost::alloc::string::String,
    #[prost(string, tag = "17")]
    pub base_id: ::prost::alloc::string::String,
    #[prost(int64, tag = "18")]
    pub ttl_duration_seconds: i64,
    #[prost(string, repeated, tag = "19")]
    pub tags: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(bool, tag = "100")]
    pub incremental_beta1: bool,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArtifactManifest {
    #[prost(int32, tag = "1")]
    pub version: i32,
    #[prost(string, tag = "2")]
    pub storage_policy: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "3")]
    pub storage_policy_config: ::prost::alloc::vec::Vec<StoragePolicyConfigItem>,
    /// Only one of {contents, manifest_file_path} should be set.
    #[prost(message, repeated, tag = "4")]
    pub contents: ::prost::alloc::vec::Vec<ArtifactManifestEntry>,
    /// `manifest_file_path` is used for manifests that approach the 2GiB message limit.
    /// It should point to a gzipped, line-delimited JSON file containing manifest entries.
    #[prost(string, tag = "5")]
    pub manifest_file_path: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArtifactManifestEntry {
    #[prost(string, tag = "1")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub digest: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub r#ref: ::prost::alloc::string::String,
    #[prost(int64, tag = "4")]
    pub size: i64,
    #[prost(string, tag = "5")]
    pub mimetype: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub local_path: ::prost::alloc::string::String,
    #[prost(string, tag = "7")]
    pub birth_artifact_id: ::prost::alloc::string::String,
    /// Whether to avoid copying/moving files to the cache while uploading.
    #[prost(bool, tag = "8")]
    pub skip_cache: bool,
    #[prost(message, repeated, tag = "16")]
    pub extra: ::prost::alloc::vec::Vec<ExtraItem>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExtraItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub value_json: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StoragePolicyConfigItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub value_json: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ArtifactResult {}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct LinkArtifactResult {}
///
/// LinkArtifactRequest: link artifact to portfolio
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LinkArtifactRequest {
    #[prost(string, tag = "1")]
    pub client_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub server_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub portfolio_name: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub portfolio_entity: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub portfolio_project: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "6")]
    pub portfolio_aliases: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "7")]
    pub portfolio_organization: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LinkArtifactResponse {
    #[prost(string, tag = "1")]
    pub error_message: ::prost::alloc::string::String,
    #[prost(int32, optional, tag = "2")]
    pub version_index: ::core::option::Option<i32>,
}
/// Indicates a directory of TensorBoard tfevents files to sync with the run.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TbRecord {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
    /// A directory containing tfevents files to watch.
    ///
    /// This may be an absolute or relative path.
    #[prost(string, tag = "1")]
    pub log_dir: ::prost::alloc::string::String,
    /// An optional path to an ancestor of `log_dir` used for namespacing.
    ///
    /// This may be an absolute or relative path.
    ///
    /// If set, then each event from tfevents files under `log_dir` is
    /// prefixed by the file's path relative to this directory. Additionally,
    /// if `save` is true, then each file's upload path is also its path
    /// relative to `root_dir`.
    ///
    /// For example, with `root_dir` set as "tb/logs" and `log_dir` as
    /// "tb/logs/train":
    ///
    /// * Files are uploaded to "train/events.out.tfevents"
    /// * A tfevents value tagged "epoch_loss" is logged as "train/epoch_loss"
    ///
    /// If this is unset, then it is inferred using unspecified rules.
    #[prost(string, tag = "3")]
    pub root_dir: ::prost::alloc::string::String,
    /// Whether to save tfevents files with the run.
    ///
    /// When true, this uploads the tfevents files, enabling the "TensorBoard"
    /// tab in W&B.
    #[prost(bool, tag = "2")]
    pub save: bool,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TbResult {}
///
/// AlertRecord: store alert notifications
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AlertRecord {
    #[prost(string, tag = "1")]
    pub title: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub text: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub level: ::prost::alloc::string::String,
    #[prost(int64, tag = "4")]
    pub wait_duration: i64,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct AlertResult {}
///
/// Request: all non persistent messages
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Request {
    #[prost(
        oneof = "request::RequestType",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 20, 21, 23, 24, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 77, 78, 79, 81, 82, 83, 1000"
    )]
    pub request_type: ::core::option::Option<request::RequestType>,
}
/// Nested message and enum types in `Request`.
pub mod request {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum RequestType {
        #[prost(message, tag = "1")]
        StopStatus(super::StopStatusRequest),
        #[prost(message, tag = "2")]
        NetworkStatus(super::NetworkStatusRequest),
        #[prost(message, tag = "3")]
        Defer(super::DeferRequest),
        #[prost(message, tag = "4")]
        GetSummary(super::GetSummaryRequest),
        #[prost(message, tag = "5")]
        Login(super::LoginRequest),
        #[prost(message, tag = "6")]
        Pause(super::PauseRequest),
        #[prost(message, tag = "7")]
        Resume(super::ResumeRequest),
        #[prost(message, tag = "8")]
        PollExit(super::PollExitRequest),
        #[prost(message, tag = "9")]
        SampledHistory(super::SampledHistoryRequest),
        #[prost(message, tag = "10")]
        PartialHistory(super::PartialHistoryRequest),
        #[prost(message, tag = "11")]
        RunStart(super::RunStartRequest),
        #[prost(message, tag = "12")]
        CheckVersion(super::CheckVersionRequest),
        #[prost(message, tag = "13")]
        LogArtifact(super::LogArtifactRequest),
        #[prost(message, tag = "14")]
        DownloadArtifact(super::DownloadArtifactRequest),
        #[prost(message, tag = "17")]
        Keepalive(super::KeepaliveRequest),
        #[prost(message, tag = "18")]
        ServerFeature(super::ServerFeatureRequest),
        #[prost(message, tag = "20")]
        RunStatus(super::RunStatusRequest),
        #[prost(message, tag = "21")]
        Cancel(super::CancelRequest),
        #[prost(message, tag = "23")]
        InternalMessages(super::InternalMessagesRequest),
        #[prost(message, tag = "24")]
        PythonPackages(super::PythonPackagesRequest),
        #[prost(message, tag = "64")]
        Shutdown(super::ShutdownRequest),
        #[prost(message, tag = "65")]
        Attach(super::AttachRequest),
        #[prost(message, tag = "66")]
        Status(super::StatusRequest),
        #[prost(message, tag = "67")]
        ServerInfo(super::ServerInfoRequest),
        #[prost(message, tag = "68")]
        SenderMark(super::SenderMarkRequest),
        #[prost(message, tag = "69")]
        SenderRead(super::SenderReadRequest),
        #[prost(message, tag = "70")]
        StatusReport(super::StatusReportRequest),
        #[prost(message, tag = "71")]
        SummaryRecord(super::SummaryRecordRequest),
        #[prost(message, tag = "72")]
        TelemetryRecord(super::TelemetryRecordRequest),
        #[prost(message, tag = "73")]
        JobInfo(super::JobInfoRequest),
        #[prost(message, tag = "74")]
        GetSystemMetrics(super::GetSystemMetricsRequest),
        #[prost(message, tag = "77")]
        JobInput(super::JobInputRequest),
        #[prost(message, tag = "78")]
        LinkArtifact(super::LinkArtifactRequest),
        #[prost(message, tag = "79")]
        RunFinishWithoutExit(super::RunFinishWithoutExitRequest),
        #[prost(message, tag = "81")]
        SyncFinish(super::SyncFinishRequest),
        /// Requests information about tasks the service is performing.
        #[prost(message, tag = "82")]
        Operations(super::OperationStatsRequest),
        /// Requests collecting information about the system environment and resources.
        #[prost(message, tag = "83")]
        ProbeSystemInfo(super::ProbeSystemInfoRequest),
        #[prost(message, tag = "1000")]
        TestInject(super::TestInjectRequest),
    }
}
///
/// Response: all non persistent responses to Requests
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Response {
    #[prost(
        oneof = "response::ResponseType",
        tags = "18, 19, 20, 24, 25, 26, 27, 28, 29, 30, 31, 32, 35, 36, 37, 64, 65, 66, 67, 68, 69, 71, 70, 72, 74, 1000"
    )]
    pub response_type: ::core::option::Option<response::ResponseType>,
}
/// Nested message and enum types in `Response`.
pub mod response {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ResponseType {
        #[prost(message, tag = "18")]
        KeepaliveResponse(super::KeepaliveResponse),
        #[prost(message, tag = "19")]
        StopStatusResponse(super::StopStatusResponse),
        #[prost(message, tag = "20")]
        NetworkStatusResponse(super::NetworkStatusResponse),
        #[prost(message, tag = "24")]
        LoginResponse(super::LoginResponse),
        #[prost(message, tag = "25")]
        GetSummaryResponse(super::GetSummaryResponse),
        #[prost(message, tag = "26")]
        PollExitResponse(super::PollExitResponse),
        #[prost(message, tag = "27")]
        SampledHistoryResponse(super::SampledHistoryResponse),
        #[prost(message, tag = "28")]
        RunStartResponse(super::RunStartResponse),
        #[prost(message, tag = "29")]
        CheckVersionResponse(super::CheckVersionResponse),
        #[prost(message, tag = "30")]
        LogArtifactResponse(super::LogArtifactResponse),
        #[prost(message, tag = "31")]
        DownloadArtifactResponse(super::DownloadArtifactResponse),
        #[prost(message, tag = "32")]
        ServerFeatureResponse(super::ServerFeatureResponse),
        #[prost(message, tag = "35")]
        RunStatusResponse(super::RunStatusResponse),
        #[prost(message, tag = "36")]
        CancelResponse(super::CancelResponse),
        #[prost(message, tag = "37")]
        InternalMessagesResponse(super::InternalMessagesResponse),
        #[prost(message, tag = "64")]
        ShutdownResponse(super::ShutdownResponse),
        #[prost(message, tag = "65")]
        AttachResponse(super::AttachResponse),
        #[prost(message, tag = "66")]
        StatusResponse(super::StatusResponse),
        #[prost(message, tag = "67")]
        ServerInfoResponse(super::ServerInfoResponse),
        #[prost(message, tag = "68")]
        JobInfoResponse(super::JobInfoResponse),
        #[prost(message, tag = "69")]
        GetSystemMetricsResponse(super::GetSystemMetricsResponse),
        #[prost(message, tag = "71")]
        LinkArtifactResponse(super::LinkArtifactResponse),
        #[prost(message, tag = "70")]
        SyncResponse(super::SyncResponse),
        #[prost(message, tag = "72")]
        RunFinishWithoutExitResponse(super::RunFinishWithoutExitResponse),
        #[prost(message, tag = "74")]
        OperationsResponse(super::OperationStatsResponse),
        #[prost(message, tag = "1000")]
        TestInjectResponse(super::TestInjectResponse),
    }
}
///
/// DeferRequest: internal message to defer work
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DeferRequest {
    /// Internal message, no _info field needed
    #[prost(enumeration = "defer_request::DeferState", tag = "1")]
    pub state: i32,
}
/// Nested message and enum types in `DeferRequest`.
pub mod defer_request {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum DeferState {
        Begin = 0,
        FlushRun = 1,
        FlushStats = 2,
        FlushPartialHistory = 3,
        FlushTb = 4,
        FlushSum = 5,
        FlushDebouncer = 6,
        FlushOutput = 7,
        FlushJob = 8,
        FlushDir = 9,
        FlushFp = 10,
        JoinFp = 11,
        FlushFs = 12,
        FlushFinal = 13,
        End = 14,
    }
    impl DeferState {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Begin => "BEGIN",
                Self::FlushRun => "FLUSH_RUN",
                Self::FlushStats => "FLUSH_STATS",
                Self::FlushPartialHistory => "FLUSH_PARTIAL_HISTORY",
                Self::FlushTb => "FLUSH_TB",
                Self::FlushSum => "FLUSH_SUM",
                Self::FlushDebouncer => "FLUSH_DEBOUNCER",
                Self::FlushOutput => "FLUSH_OUTPUT",
                Self::FlushJob => "FLUSH_JOB",
                Self::FlushDir => "FLUSH_DIR",
                Self::FlushFp => "FLUSH_FP",
                Self::JoinFp => "JOIN_FP",
                Self::FlushFs => "FLUSH_FS",
                Self::FlushFinal => "FLUSH_FINAL",
                Self::End => "END",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "BEGIN" => Some(Self::Begin),
                "FLUSH_RUN" => Some(Self::FlushRun),
                "FLUSH_STATS" => Some(Self::FlushStats),
                "FLUSH_PARTIAL_HISTORY" => Some(Self::FlushPartialHistory),
                "FLUSH_TB" => Some(Self::FlushTb),
                "FLUSH_SUM" => Some(Self::FlushSum),
                "FLUSH_DEBOUNCER" => Some(Self::FlushDebouncer),
                "FLUSH_OUTPUT" => Some(Self::FlushOutput),
                "FLUSH_JOB" => Some(Self::FlushJob),
                "FLUSH_DIR" => Some(Self::FlushDir),
                "FLUSH_FP" => Some(Self::FlushFp),
                "JOIN_FP" => Some(Self::JoinFp),
                "FLUSH_FS" => Some(Self::FlushFs),
                "FLUSH_FINAL" => Some(Self::FlushFinal),
                "END" => Some(Self::End),
                _ => None,
            }
        }
    }
}
///
/// PauseRequest: internal message to pause the heartbeat
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PauseRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PauseResponse {}
///
/// ResumeRequest: internal message to resume the heartbeat
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResumeRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ResumeResponse {}
/// Old request, no longer used for logging in (if it ever was).
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LoginRequest {
    #[prost(string, tag = "1")]
    pub api_key: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LoginResponse {
    #[prost(string, tag = "1")]
    pub active_entity: ::prost::alloc::string::String,
}
///
/// GetSummaryRequest: request consolidated summary
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSummaryRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSummaryResponse {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<SummaryItem>,
}
///
/// GetSystemMetrics: request system metrics
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSystemMetricsRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SystemMetricSample {
    #[prost(message, optional, tag = "1")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(float, tag = "2")]
    pub value: f32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SystemMetricsBuffer {
    #[prost(message, repeated, tag = "1")]
    pub record: ::prost::alloc::vec::Vec<SystemMetricSample>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetSystemMetricsResponse {
    #[prost(map = "string, message", tag = "1")]
    pub system_metrics: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        SystemMetricsBuffer,
    >,
}
///
/// StatusRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StatusRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StatusResponse {
    #[prost(bool, tag = "1")]
    pub run_should_stop: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StopStatusRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StopStatusResponse {
    #[prost(bool, tag = "1")]
    pub run_should_stop: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NetworkStatusRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NetworkStatusResponse {
    #[prost(message, repeated, tag = "1")]
    pub network_responses: ::prost::alloc::vec::Vec<HttpResponse>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HttpResponse {
    #[prost(int32, tag = "1")]
    pub http_status_code: i32,
    #[prost(string, tag = "2")]
    pub http_response_text: ::prost::alloc::string::String,
}
///
/// InternalMessagesRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InternalMessagesRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InternalMessagesResponse {
    #[prost(message, optional, tag = "1")]
    pub messages: ::core::option::Option<InternalMessages>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InternalMessages {
    #[prost(string, repeated, tag = "1")]
    pub warning: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
///
/// PollExitRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PollExitRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PollExitResponse {
    #[prost(bool, tag = "1")]
    pub done: bool,
    #[prost(message, optional, tag = "2")]
    pub exit_result: ::core::option::Option<RunExitResult>,
    #[prost(message, optional, tag = "3")]
    pub pusher_stats: ::core::option::Option<FilePusherStats>,
    #[prost(message, optional, tag = "4")]
    pub file_counts: ::core::option::Option<FileCounts>,
    #[prost(message, optional, tag = "5")]
    pub operation_stats: ::core::option::Option<OperationStats>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OperationStatsRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OperationStatsResponse {
    #[prost(message, optional, tag = "1")]
    pub operation_stats: ::core::option::Option<OperationStats>,
}
/// Information about ongoing operations in the internal process.
///
/// This is printed in the console to help the user estimate how long
/// they have to wait for a run to finish, and why.
///
/// For example, it may be displayed like this:
///
/// wandb: (41s) uploading artifact my-dataset (13/68 files)
/// wandb:   (1.0s) my-dataset-14.h5 (1.2 MB / 100 MB)
/// wandb:   (0.2s) my-dataset-15.h5 (43 MB / 100 MB)
/// wandb: (24s) uploading history, summary, console logs
/// wandb:   retrying HTTP 500 in 13s; attempt 22/10085 - see logs
/// wandb: + 7 more tasks
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OperationStats {
    /// The ongoing operations sorted by usefulness for the user to see.
    ///
    /// This may not contain all operations, but it may also contain more than can
    /// be displayed in the terminal.
    #[prost(message, repeated, tag = "1")]
    pub operations: ::prost::alloc::vec::Vec<Operation>,
    /// The actual total number of ongoing operations.
    ///
    /// This is at least the number of items in `operations`, but could be more.
    #[prost(int64, tag = "2")]
    pub total_operations: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Operation {
    /// A short description for the operation.
    ///
    /// For top-level operations, it should be a present continuous verb phrase,
    /// such as "uploading artifact my-dataset".
    ///
    /// For subtasks, it should be as short as possible while making sense in
    /// the parent operation's context, such as "my_dataset.h5" for a file upload
    /// subtask that's part of an artifact upload operation.
    ///
    /// This does not start with a capital letter and does not end in punctuation.
    #[prost(string, tag = "1")]
    pub desc: ::prost::alloc::string::String,
    /// The number of seconds the operation has been running for.
    #[prost(double, tag = "2")]
    pub runtime_seconds: f64,
    /// A short description of the operation's progress.
    ///
    /// Examples:
    ///    - "3.1 MB / 100 MB"
    ///    - "4/5 files"
    #[prost(string, tag = "3")]
    pub progress: ::prost::alloc::string::String,
    /// A short message describing the operation's latest problem.
    ///
    /// This does not start with a capital letter and does not end in punctuation.
    ///
    /// Example: "retrying HTTP 500 error".
    #[prost(string, tag = "4")]
    pub error_status: ::prost::alloc::string::String,
    /// The top few most interesting subtasks for this operation.
    #[prost(message, repeated, tag = "5")]
    pub subtasks: ::prost::alloc::vec::Vec<Operation>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SenderMarkRequest {}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SyncFinishRequest {}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SyncResponse {
    #[prost(string, tag = "1")]
    pub url: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<ErrorInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SenderReadRequest {
    #[prost(int64, tag = "1")]
    pub start_offset: i64,
    /// TODO: implement cancel for paused ops
    /// repeated string cancel_list = 3;
    #[prost(int64, tag = "2")]
    pub final_offset: i64,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct StatusReportRequest {
    #[prost(int64, tag = "1")]
    pub record_num: i64,
    #[prost(int64, tag = "2")]
    pub sent_offset: i64,
    #[prost(message, optional, tag = "3")]
    pub sync_time: ::core::option::Option<::prost_types::Timestamp>,
}
///
/// Requests wrapping Records
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SummaryRecordRequest {
    #[prost(message, optional, tag = "1")]
    pub summary: ::core::option::Option<SummaryRecord>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TelemetryRecordRequest {
    #[prost(message, optional, tag = "1")]
    pub telemetry: ::core::option::Option<TelemetryRecord>,
}
///
/// ServerInfoRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerInfoRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerInfoResponse {
    #[prost(message, optional, tag = "1")]
    pub local_info: ::core::option::Option<LocalInfo>,
    #[prost(message, optional, tag = "2")]
    pub server_messages: ::core::option::Option<ServerMessages>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerMessages {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<ServerMessage>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerMessage {
    #[prost(string, tag = "1")]
    pub plain_text: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub utf_text: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub html_text: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub r#type: ::prost::alloc::string::String,
    #[prost(int32, tag = "5")]
    pub level: i32,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FileCounts {
    #[prost(int32, tag = "1")]
    pub wandb_count: i32,
    #[prost(int32, tag = "2")]
    pub media_count: i32,
    #[prost(int32, tag = "3")]
    pub artifact_count: i32,
    #[prost(int32, tag = "4")]
    pub other_count: i32,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FilePusherStats {
    #[prost(int64, tag = "1")]
    pub uploaded_bytes: i64,
    #[prost(int64, tag = "2")]
    pub total_bytes: i64,
    #[prost(int64, tag = "3")]
    pub deduped_bytes: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FilesUploaded {
    #[prost(string, repeated, tag = "1")]
    pub files: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FileTransferInfoRequest {
    #[prost(enumeration = "file_transfer_info_request::TransferType", tag = "1")]
    pub r#type: i32,
    #[prost(string, tag = "2")]
    pub path: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub url: ::prost::alloc::string::String,
    #[prost(int64, tag = "4")]
    pub size: i64,
    #[prost(int64, tag = "5")]
    pub processed: i64,
    #[prost(message, optional, tag = "6")]
    pub file_counts: ::core::option::Option<FileCounts>,
}
/// Nested message and enum types in `FileTransferInfoRequest`.
pub mod file_transfer_info_request {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum TransferType {
        Upload = 0,
        Download = 1,
    }
    impl TransferType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Upload => "Upload",
                Self::Download => "Download",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "Upload" => Some(Self::Upload),
                "Download" => Some(Self::Download),
                _ => None,
            }
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LocalInfo {
    #[prost(string, tag = "1")]
    pub version: ::prost::alloc::string::String,
    #[prost(bool, tag = "2")]
    pub out_of_date: bool,
}
///
/// ShutdownRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShutdownRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ShutdownResponse {}
///
/// AttachRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachRequest {
    #[prost(string, tag = "20")]
    pub attach_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AttachResponse {
    #[prost(message, optional, tag = "1")]
    pub run: ::core::option::Option<RunRecord>,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<ErrorInfo>,
}
///
/// TestInjectRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TestInjectRequest {
    #[prost(bool, tag = "1")]
    pub handler_exc: bool,
    #[prost(bool, tag = "2")]
    pub handler_exit: bool,
    #[prost(bool, tag = "3")]
    pub handler_abort: bool,
    #[prost(bool, tag = "4")]
    pub sender_exc: bool,
    #[prost(bool, tag = "5")]
    pub sender_exit: bool,
    #[prost(bool, tag = "6")]
    pub sender_abort: bool,
    #[prost(bool, tag = "7")]
    pub req_exc: bool,
    #[prost(bool, tag = "8")]
    pub req_exit: bool,
    #[prost(bool, tag = "9")]
    pub req_abort: bool,
    #[prost(bool, tag = "10")]
    pub resp_exc: bool,
    #[prost(bool, tag = "11")]
    pub resp_exit: bool,
    #[prost(bool, tag = "12")]
    pub resp_abort: bool,
    #[prost(bool, tag = "13")]
    pub msg_drop: bool,
    #[prost(bool, tag = "14")]
    pub msg_hang: bool,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TestInjectResponse {}
///
/// PartialHistoryRequest:
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct HistoryAction {
    #[prost(bool, tag = "1")]
    pub flush: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartialHistoryRequest {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<HistoryItem>,
    #[prost(message, optional, tag = "2")]
    pub step: ::core::option::Option<HistoryStep>,
    #[prost(message, optional, tag = "3")]
    pub action: ::core::option::Option<HistoryAction>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PartialHistoryResponse {}
///
/// SampledHistoryRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SampledHistoryRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
///
/// SampledHistoryItem:
///
/// key and nested_key are mutually exclusive. Only one of them should be set.
/// key is supposedly more performant than nested_key, so nested_key should be
/// only used for nested keys.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SampledHistoryItem {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub nested_key: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(float, repeated, tag = "3")]
    pub values_float: ::prost::alloc::vec::Vec<f32>,
    #[prost(int64, repeated, tag = "4")]
    pub values_int: ::prost::alloc::vec::Vec<i64>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SampledHistoryResponse {
    #[prost(message, repeated, tag = "1")]
    pub item: ::prost::alloc::vec::Vec<SampledHistoryItem>,
}
///
/// RunStatusRequest:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunStatusRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RunStatusResponse {
    #[prost(int64, tag = "1")]
    pub sync_items_total: i64,
    #[prost(int64, tag = "2")]
    pub sync_items_pending: i64,
    /// TODO(flowcontrol): can we give the user an indication of step position
    /// int64 sync_history_step = 3;
    /// google.protobuf.Timestamp sync_history_time = 4;
    #[prost(message, optional, tag = "3")]
    pub sync_time: ::core::option::Option<::prost_types::Timestamp>,
}
///
/// RunStartRequest: start the run
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunStartRequest {
    #[prost(message, optional, tag = "1")]
    pub run: ::core::option::Option<RunRecord>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RunStartResponse {}
///
/// RunFinishWithoutExitRequest: finish the run without updating the exit status on the server
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunFinishWithoutExitRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct RunFinishWithoutExitResponse {}
///
/// CheckVersion:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CheckVersionRequest {
    #[prost(string, tag = "1")]
    pub current_version: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CheckVersionResponse {
    #[prost(string, tag = "1")]
    pub upgrade_message: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub yank_message: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub delete_message: ::prost::alloc::string::String,
}
///
/// JobInfo:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JobInfoRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JobInfoResponse {
    #[prost(string, tag = "1")]
    pub sequence_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub version: ::prost::alloc::string::String,
}
///
/// LogArtifact:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogArtifactRequest {
    #[prost(message, optional, tag = "1")]
    pub artifact: ::core::option::Option<ArtifactRecord>,
    #[prost(int64, tag = "2")]
    pub history_step: i64,
    #[prost(string, tag = "3")]
    pub staging_dir: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogArtifactResponse {
    #[prost(string, tag = "1")]
    pub artifact_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub error_message: ::prost::alloc::string::String,
}
///
/// DownloadArtifact:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DownloadArtifactRequest {
    #[prost(string, tag = "1")]
    pub artifact_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub download_root: ::prost::alloc::string::String,
    #[prost(bool, tag = "4")]
    pub allow_missing_references: bool,
    #[prost(bool, tag = "5")]
    pub skip_cache: bool,
    #[prost(string, tag = "6")]
    pub path_prefix: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DownloadArtifactResponse {
    #[prost(string, tag = "1")]
    pub error_message: ::prost::alloc::string::String,
}
///
/// Keepalive:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct KeepaliveRequest {
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct KeepaliveResponse {}
///
/// Job info specific for Partial -> Job upgrade
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ArtifactInfo {
    #[prost(string, tag = "1")]
    pub artifact: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub entrypoint: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(bool, tag = "3")]
    pub notebook: bool,
    #[prost(string, tag = "4")]
    pub build_context: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub dockerfile: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GitInfo {
    #[prost(string, tag = "1")]
    pub remote: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub commit: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GitSource {
    #[prost(message, optional, tag = "1")]
    pub git_info: ::core::option::Option<GitInfo>,
    #[prost(string, repeated, tag = "2")]
    pub entrypoint: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(bool, tag = "3")]
    pub notebook: bool,
    #[prost(string, tag = "4")]
    pub build_context: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub dockerfile: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ImageSource {
    #[prost(string, tag = "1")]
    pub image: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Source {
    #[prost(message, optional, tag = "1")]
    pub git: ::core::option::Option<GitSource>,
    #[prost(message, optional, tag = "2")]
    pub artifact: ::core::option::Option<ArtifactInfo>,
    #[prost(message, optional, tag = "3")]
    pub image: ::core::option::Option<ImageSource>,
}
///
/// Mirrors JobSourceDict:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JobSource {
    #[prost(string, tag = "1")]
    pub version: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub source_type: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub source: ::core::option::Option<Source>,
    #[prost(string, tag = "4")]
    pub runtime: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartialJobArtifact {
    #[prost(string, tag = "1")]
    pub job_name: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub source_info: ::core::option::Option<JobSource>,
}
///
/// UseArtifact:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UseArtifactRecord {
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub r#type: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub partial: ::core::option::Option<PartialJobArtifact>,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct UseArtifactResult {}
///
/// Cancel:
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CancelRequest {
    /// mailbox slot
    #[prost(string, tag = "1")]
    pub cancel_slot: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CancelResponse {}
///
/// Run environment including system, hardware, software, and execution parameters.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ProbeSystemInfoRequest {}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct DiskInfo {
    #[prost(uint64, tag = "1")]
    pub total: u64,
    #[prost(uint64, tag = "2")]
    pub used: u64,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct MemoryInfo {
    #[prost(uint64, tag = "1")]
    pub total: u64,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct CpuInfo {
    #[prost(uint32, tag = "1")]
    pub count: u32,
    #[prost(uint32, tag = "2")]
    pub count_logical: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AppleInfo {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint32, tag = "2")]
    pub ecpu_cores: u32,
    #[prost(uint32, tag = "3")]
    pub pcpu_cores: u32,
    #[prost(uint32, tag = "4")]
    pub gpu_cores: u32,
    #[prost(uint32, tag = "5")]
    pub memory_gb: u32,
    #[prost(uint64, tag = "6")]
    pub swap_total_bytes: u64,
    #[prost(uint64, tag = "7")]
    pub ram_total_bytes: u64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuNvidiaInfo {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub memory_total: u64,
    #[prost(uint32, tag = "3")]
    pub cuda_cores: u32,
    #[prost(string, tag = "4")]
    pub architecture: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub uuid: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuAmdInfo {
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub unique_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub vbios_version: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub performance_level: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub gpu_overdrive: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub gpu_memory_overdrive: ::prost::alloc::string::String,
    #[prost(string, tag = "7")]
    pub max_power: ::prost::alloc::string::String,
    #[prost(string, tag = "8")]
    pub series: ::prost::alloc::string::String,
    #[prost(string, tag = "9")]
    pub model: ::prost::alloc::string::String,
    #[prost(string, tag = "10")]
    pub vendor: ::prost::alloc::string::String,
    #[prost(string, tag = "11")]
    pub sku: ::prost::alloc::string::String,
    #[prost(string, tag = "12")]
    pub sclk_range: ::prost::alloc::string::String,
    #[prost(string, tag = "13")]
    pub mclk_range: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TrainiumInfo {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub vendor: ::prost::alloc::string::String,
    #[prost(uint32, tag = "3")]
    pub neuron_device_count: u32,
    #[prost(uint32, tag = "4")]
    pub neuroncore_per_device_count: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TpuInfo {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint32, tag = "2")]
    pub hbm_gib: u32,
    #[prost(uint32, tag = "3")]
    pub devices_per_chip: u32,
    #[prost(uint32, tag = "4")]
    pub count: u32,
}
/// CoreWeaveInfo stores information about a CoreWeave compute environment.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CoreWeaveInfo {
    #[prost(string, tag = "1")]
    pub cluster_name: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub org_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub region: ::prost::alloc::string::String,
}
/// EnvironmentRecord stores a snapshot of the system, hardware, software,
/// and execution parameters captured at a run writer initialization.
///
/// A single W&B Run can have multiple "writers" that contribute data to the run.
/// Examples include:
///    - Multiple processes logging to the same run in a distributed training setup
///      (`wandb.init(id="<run-id>", mode="shared")`)
///    - Resuming a previous run (`wandb.init(id="<run-id>", resume="must")`),
///      which creates a new writer session, potentially on a different machine.
///
/// Because each writer can have a distinct environment (e.g., different OS,
/// hardware, or git state), this record is associated with that writer's
/// unique `writer_id` to preserve its specific context.
///
/// The environment and system metadata captured by this specific writer.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EnvironmentRecord {
    /// Operating system, e.g., "macOS-14.4.1-arm64-arm-64bit".
    #[prost(string, tag = "1")]
    pub os: ::prost::alloc::string::String,
    /// Version of the Python interpreter, e.g., "3.11.8".
    #[prost(string, tag = "2")]
    pub python: ::prost::alloc::string::String,
    /// Timestamp when the writer started.
    #[prost(message, optional, tag = "3")]
    pub started_at: ::core::option::Option<::prost_types::Timestamp>,
    /// Docker image ID, if running in a Docker container.
    #[prost(string, tag = "4")]
    pub docker: ::prost::alloc::string::String,
    /// Command-line arguments passed to the script.
    #[prost(string, repeated, tag = "5")]
    pub args: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// The name of the program or script being executed.
    #[prost(string, tag = "6")]
    pub program: ::prost::alloc::string::String,
    /// Path to the program or script.
    #[prost(string, tag = "7")]
    pub code_path: ::prost::alloc::string::String,
    /// The local filesystem path to the code being executed.
    #[prost(string, tag = "8")]
    pub code_path_local: ::prost::alloc::string::String,
    /// Information about the Git repository, if applicable.
    #[prost(message, optional, tag = "9")]
    pub git: ::core::option::Option<GitRepoRecord>,
    /// Email of the logged-in user.
    #[prost(string, tag = "10")]
    pub email: ::prost::alloc::string::String,
    /// Root directory where the script was executed.
    #[prost(string, tag = "11")]
    pub root: ::prost::alloc::string::String,
    /// Hostname of the machine.
    #[prost(string, tag = "12")]
    pub host: ::prost::alloc::string::String,
    /// Username of the user running the script.
    #[prost(string, tag = "13")]
    pub username: ::prost::alloc::string::String,
    /// Path to the executable that is running the script (e.g., path to python).
    #[prost(string, tag = "14")]
    pub executable: ::prost::alloc::string::String,
    /// URL of the Colab notebook, if running in Google Colab.
    #[prost(string, tag = "15")]
    pub colab: ::prost::alloc::string::String,
    /// Number of physical CPU cores.
    #[prost(uint32, tag = "16")]
    pub cpu_count: u32,
    /// Number of logical CPU cores.
    #[prost(uint32, tag = "17")]
    pub cpu_count_logical: u32,
    /// Primary GPU type or name.
    #[prost(string, tag = "18")]
    pub gpu_type: ::prost::alloc::string::String,
    /// Total number of GPUs.
    #[prost(uint32, tag = "19")]
    pub gpu_count: u32,
    /// Detailed information about mounted disk volumes.
    #[prost(map = "string, message", tag = "20")]
    pub disk: ::std::collections::HashMap<::prost::alloc::string::String, DiskInfo>,
    /// Information about system memory.
    #[prost(message, optional, tag = "21")]
    pub memory: ::core::option::Option<MemoryInfo>,
    /// CPU information.
    #[prost(message, optional, tag = "22")]
    pub cpu: ::core::option::Option<CpuInfo>,
    /// Information specific to Apple Silicon hardware.
    #[prost(message, optional, tag = "23")]
    pub apple: ::core::option::Option<AppleInfo>,
    /// Detailed information for each NVIDIA GPU.
    #[prost(message, repeated, tag = "24")]
    pub gpu_nvidia: ::prost::alloc::vec::Vec<GpuNvidiaInfo>,
    /// Version of the CUDA toolkit, if available.
    #[prost(string, tag = "25")]
    pub cuda_version: ::prost::alloc::string::String,
    /// Detailed information for each AMD GPU.
    #[prost(message, repeated, tag = "26")]
    pub gpu_amd: ::prost::alloc::vec::Vec<GpuAmdInfo>,
    /// Information from the Slurm workload manager, if present.
    #[prost(map = "string, string", tag = "27")]
    pub slurm: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Information about AWS Trainium hardware.
    #[prost(message, optional, tag = "28")]
    pub trainium: ::core::option::Option<TrainiumInfo>,
    /// Information about Google TPU hardware.
    #[prost(message, optional, tag = "29")]
    pub tpu: ::core::option::Option<TpuInfo>,
    /// Information about CoreWeave cloud environment.
    #[prost(message, optional, tag = "30")]
    pub coreweave: ::core::option::Option<CoreWeaveInfo>,
    /// A unique identifier for this writer session.
    ///
    /// This ID distinguishes this writer's metadata from that of other writers
    /// that may be contributing to the same run.
    #[prost(string, tag = "199")]
    pub writer_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RecordInfo>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PythonPackagesRequest {
    #[prost(message, repeated, tag = "1")]
    pub package: ::prost::alloc::vec::Vec<python_packages_request::PythonPackage>,
}
/// Nested message and enum types in `PythonPackagesRequest`.
pub mod python_packages_request {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct PythonPackage {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(string, tag = "2")]
        pub version: ::prost::alloc::string::String,
    }
}
/// Path within nested configuration object.
///
/// The path is a list of strings, each string is a key in a nested configuration
/// dict. These paths are used to filter subtrees in and out of the config
/// before we capture a schema. This gives users the ability to limit which
/// parts of the config are exposed as inputs to a job.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JobInputPath {
    #[prost(string, repeated, tag = "1")]
    pub path: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Specifies a source for job inputs.
///
/// The source is either the run config (wandb.config) or a config file.
/// If a config file is specified, the file path is relative to
/// <run-files-dir>/configs.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JobInputSource {
    #[prost(oneof = "job_input_source::Source", tags = "1, 2")]
    pub source: ::core::option::Option<job_input_source::Source>,
}
/// Nested message and enum types in `JobInputSource`.
pub mod job_input_source {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct RunConfigSource {}
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ConfigFileSource {
        #[prost(string, tag = "1")]
        pub path: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Source {
        #[prost(message, tag = "1")]
        RunConfig(RunConfigSource),
        #[prost(message, tag = "2")]
        File(ConfigFileSource),
    }
}
/// Specifies a new source for job inputs.
///
/// source tells us where this config is coming from and therefore how it can
/// be patched in future runs.
///
/// If include_paths is not empty, then endpoints of the config not prefixed by
/// an include path will be ignored.
///
/// If exclude_paths is not empty, then endpoints of the config prefixed by an
/// exclude path will be ignored.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JobInputRequest {
    #[prost(message, optional, tag = "1")]
    pub input_source: ::core::option::Option<JobInputSource>,
    #[prost(message, repeated, tag = "2")]
    pub include_paths: ::prost::alloc::vec::Vec<JobInputPath>,
    #[prost(message, repeated, tag = "3")]
    pub exclude_paths: ::prost::alloc::vec::Vec<JobInputPath>,
    #[prost(string, tag = "4")]
    pub input_schema: ::prost::alloc::string::String,
}
/// *
/// A request to the backend process for the features supported by the server.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerFeatureRequest {
    #[prost(enumeration = "ServerFeature", tag = "1")]
    pub feature: i32,
    #[prost(message, optional, tag = "200")]
    pub info: ::core::option::Option<RequestInfo>,
}
/// *
/// A response to a ServerFeatureRequest with the status of each requested feature.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerFeatureResponse {
    #[prost(message, optional, tag = "1")]
    pub feature: ::core::option::Option<ServerFeatureItem>,
}
/// *
/// The feature details to be requested in a ServerFeatureRequest.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ServerFeatureItem {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(bool, tag = "2")]
    pub enabled: bool,
}
/// *
/// Server features are features that the server supports.
/// This name should match the name of the feature defined in the backend server.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ServerFeature {
    /// Indicates that the server supports recieving an array of filenames as metadata.
    LargeFilenames = 0,
    /// Indicates that the server supports adding tags to artifacts.
    ArtifactTags = 1,
    /// Indicates that the server supports client IDs for artifact reference urls.
    ClientIds = 2,
    /// Indicates that the server supports searching for artifacts in a registry.
    ArtifactRegistrySearch = 3,
    /// Indicates that the server supports structured console logs.
    StructuredConsoleLogs = 4,
    /// Indicates that the server supports querying for files on artifact collection memberships.
    ArtifactCollectionMembershipFiles = 5,
    /// Indicates that the server supports downloading files with additional artifact collection memberships context in the
    /// url.
    ArtifactCollectionMembershipFileDownloadHandler = 6,
    /// Indicates that the server supports passing the artifact's entity and project to the useArtifact mutation.
    UseArtifactWithEntityAndProjectInformation = 7,
    /// Indicates that the server supports expanding defined metric globs on the server side.
    ExpandDefinedMetricGlobs = 8,
    /// Indicates that the server supports automation event RUN_METRIC.
    AutomationEventRunMetric = 9,
    /// Indicates that the server supports automation event RUN_METRIC_CHANGE.
    AutomationEventRunMetricChange = 10,
    /// Indicates that the server supports automation action NO_OP.
    AutomationActionNoOp = 11,
    /// Indicates that the server supports including artifact types in registry creation.
    IncludeArtifactTypesInRegistryCreation = 12,
    /// Indicates that the server supports querying for a artifact collection membership on the project.
    ProjectArtifactCollectionMembership = 13,
    /// Indicates that the server supports returning an artifact collection membership in the response of a linkArtifact
    /// mutation.
    ArtifactMembershipInLinkArtifactResponse = 14,
}
impl ServerFeature {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::LargeFilenames => "LARGE_FILENAMES",
            Self::ArtifactTags => "ARTIFACT_TAGS",
            Self::ClientIds => "CLIENT_IDS",
            Self::ArtifactRegistrySearch => "ARTIFACT_REGISTRY_SEARCH",
            Self::StructuredConsoleLogs => "STRUCTURED_CONSOLE_LOGS",
            Self::ArtifactCollectionMembershipFiles => {
                "ARTIFACT_COLLECTION_MEMBERSHIP_FILES"
            }
            Self::ArtifactCollectionMembershipFileDownloadHandler => {
                "ARTIFACT_COLLECTION_MEMBERSHIP_FILE_DOWNLOAD_HANDLER"
            }
            Self::UseArtifactWithEntityAndProjectInformation => {
                "USE_ARTIFACT_WITH_ENTITY_AND_PROJECT_INFORMATION"
            }
            Self::ExpandDefinedMetricGlobs => "EXPAND_DEFINED_METRIC_GLOBS",
            Self::AutomationEventRunMetric => "AUTOMATION_EVENT_RUN_METRIC",
            Self::AutomationEventRunMetricChange => "AUTOMATION_EVENT_RUN_METRIC_CHANGE",
            Self::AutomationActionNoOp => "AUTOMATION_ACTION_NO_OP",
            Self::IncludeArtifactTypesInRegistryCreation => {
                "INCLUDE_ARTIFACT_TYPES_IN_REGISTRY_CREATION"
            }
            Self::ProjectArtifactCollectionMembership => {
                "PROJECT_ARTIFACT_COLLECTION_MEMBERSHIP"
            }
            Self::ArtifactMembershipInLinkArtifactResponse => {
                "ARTIFACT_MEMBERSHIP_IN_LINK_ARTIFACT_RESPONSE"
            }
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "LARGE_FILENAMES" => Some(Self::LargeFilenames),
            "ARTIFACT_TAGS" => Some(Self::ArtifactTags),
            "CLIENT_IDS" => Some(Self::ClientIds),
            "ARTIFACT_REGISTRY_SEARCH" => Some(Self::ArtifactRegistrySearch),
            "STRUCTURED_CONSOLE_LOGS" => Some(Self::StructuredConsoleLogs),
            "ARTIFACT_COLLECTION_MEMBERSHIP_FILES" => {
                Some(Self::ArtifactCollectionMembershipFiles)
            }
            "ARTIFACT_COLLECTION_MEMBERSHIP_FILE_DOWNLOAD_HANDLER" => {
                Some(Self::ArtifactCollectionMembershipFileDownloadHandler)
            }
            "USE_ARTIFACT_WITH_ENTITY_AND_PROJECT_INFORMATION" => {
                Some(Self::UseArtifactWithEntityAndProjectInformation)
            }
            "EXPAND_DEFINED_METRIC_GLOBS" => Some(Self::ExpandDefinedMetricGlobs),
            "AUTOMATION_EVENT_RUN_METRIC" => Some(Self::AutomationEventRunMetric),
            "AUTOMATION_EVENT_RUN_METRIC_CHANGE" => {
                Some(Self::AutomationEventRunMetricChange)
            }
            "AUTOMATION_ACTION_NO_OP" => Some(Self::AutomationActionNoOp),
            "INCLUDE_ARTIFACT_TYPES_IN_REGISTRY_CREATION" => {
                Some(Self::IncludeArtifactTypesInRegistryCreation)
            }
            "PROJECT_ARTIFACT_COLLECTION_MEMBERSHIP" => {
                Some(Self::ProjectArtifactCollectionMembership)
            }
            "ARTIFACT_MEMBERSHIP_IN_LINK_ARTIFACT_RESPONSE" => {
                Some(Self::ArtifactMembershipInLinkArtifactResponse)
            }
            _ => None,
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetStatsRequest {
    /// Capture the system metrics for the process with this PID, in addition to
    /// system-wide metrics.
    #[prost(int32, tag = "1")]
    pub pid: i32,
    /// GPU device IDs to capture metrics for.
    ///
    /// Should be 0-indexed and match those reported by the CUDA/ROCm runtime environment.
    /// If not set, metrics for all GPUs will be captured.
    #[prost(int32, repeated, tag = "2")]
    pub gpu_device_ids: ::prost::alloc::vec::Vec<i32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetStatsResponse {
    /// System metrics.
    #[prost(message, optional, tag = "1")]
    pub record: ::core::option::Option<Record>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct GetMetadataRequest {}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetMetadataResponse {
    /// Static metadata about the system.
    #[prost(message, optional, tag = "1")]
    pub record: ::core::option::Option<Record>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TearDownRequest {}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct TearDownResponse {}
/// Generated client implementations.
pub mod system_monitor_service_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// SystemMonitorService gRPC service.
    ///
    /// This service is used to collect system metrics from the host machine.
    #[derive(Debug, Clone)]
    pub struct SystemMonitorServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl SystemMonitorServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> SystemMonitorServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> SystemMonitorServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            SystemMonitorServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// GetStats samples system metrics.
        pub async fn get_stats(
            &mut self,
            request: impl tonic::IntoRequest<super::GetStatsRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetStatsResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/wandb_internal.SystemMonitorService/GetStats",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("wandb_internal.SystemMonitorService", "GetStats"),
                );
            self.inner.unary(req, path, codec).await
        }
        /// GetMetadata returns static metadata about the system.
        pub async fn get_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::GetMetadataRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetMetadataResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/wandb_internal.SystemMonitorService/GetMetadata",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("wandb_internal.SystemMonitorService", "GetMetadata"),
                );
            self.inner.unary(req, path, codec).await
        }
        /// TearDown instructs the system monitor to shut down.
        pub async fn tear_down(
            &mut self,
            request: impl tonic::IntoRequest<super::TearDownRequest>,
        ) -> std::result::Result<
            tonic::Response<super::TearDownResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/wandb_internal.SystemMonitorService/TearDown",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("wandb_internal.SystemMonitorService", "TearDown"),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod system_monitor_service_server {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with SystemMonitorServiceServer.
    #[async_trait]
    pub trait SystemMonitorService: std::marker::Send + std::marker::Sync + 'static {
        /// GetStats samples system metrics.
        async fn get_stats(
            &self,
            request: tonic::Request<super::GetStatsRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetStatsResponse>,
            tonic::Status,
        >;
        /// GetMetadata returns static metadata about the system.
        async fn get_metadata(
            &self,
            request: tonic::Request<super::GetMetadataRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetMetadataResponse>,
            tonic::Status,
        >;
        /// TearDown instructs the system monitor to shut down.
        async fn tear_down(
            &self,
            request: tonic::Request<super::TearDownRequest>,
        ) -> std::result::Result<
            tonic::Response<super::TearDownResponse>,
            tonic::Status,
        >;
    }
    /// SystemMonitorService gRPC service.
    ///
    /// This service is used to collect system metrics from the host machine.
    #[derive(Debug)]
    pub struct SystemMonitorServiceServer<T> {
        inner: Arc<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    impl<T> SystemMonitorServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>>
    for SystemMonitorServiceServer<T>
    where
        T: SystemMonitorService,
        B: Body + std::marker::Send + 'static,
        B::Error: Into<StdError> + std::marker::Send + 'static,
    {
        type Response = http::Response<tonic::body::Body>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            match req.uri().path() {
                "/wandb_internal.SystemMonitorService/GetStats" => {
                    #[allow(non_camel_case_types)]
                    struct GetStatsSvc<T: SystemMonitorService>(pub Arc<T>);
                    impl<
                        T: SystemMonitorService,
                    > tonic::server::UnaryService<super::GetStatsRequest>
                    for GetStatsSvc<T> {
                        type Response = super::GetStatsResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GetStatsRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SystemMonitorService>::get_stats(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetStatsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/wandb_internal.SystemMonitorService/GetMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct GetMetadataSvc<T: SystemMonitorService>(pub Arc<T>);
                    impl<
                        T: SystemMonitorService,
                    > tonic::server::UnaryService<super::GetMetadataRequest>
                    for GetMetadataSvc<T> {
                        type Response = super::GetMetadataResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GetMetadataRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SystemMonitorService>::get_metadata(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = GetMetadataSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/wandb_internal.SystemMonitorService/TearDown" => {
                    #[allow(non_camel_case_types)]
                    struct TearDownSvc<T: SystemMonitorService>(pub Arc<T>);
                    impl<
                        T: SystemMonitorService,
                    > tonic::server::UnaryService<super::TearDownRequest>
                    for TearDownSvc<T> {
                        type Response = super::TearDownResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::TearDownRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as SystemMonitorService>::tear_down(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = TearDownSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        let mut response = http::Response::new(
                            tonic::body::Body::default(),
                        );
                        let headers = response.headers_mut();
                        headers
                            .insert(
                                tonic::Status::GRPC_STATUS,
                                (tonic::Code::Unimplemented as i32).into(),
                            );
                        headers
                            .insert(
                                http::header::CONTENT_TYPE,
                                tonic::metadata::GRPC_CONTENT_TYPE,
                            );
                        Ok(response)
                    })
                }
            }
        }
    }
    impl<T> Clone for SystemMonitorServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    /// Generated gRPC service name
    pub const SERVICE_NAME: &str = "wandb_internal.SystemMonitorService";
    impl<T> tonic::server::NamedService for SystemMonitorServiceServer<T> {
        const NAME: &'static str = SERVICE_NAME;
    }
}
