# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAllocationsResult',
    'AwaitableGetAllocationsResult',
    'get_allocations',
    'get_allocations_output',
]

@pulumi.output_type
class GetAllocationsResult:
    """
    A collection of values returned by getAllocations.
    """
    def __init__(__self__, allocations=None, filter=None, id=None, namespace=None, prefix=None):
        if allocations and not isinstance(allocations, list):
            raise TypeError("Expected argument 'allocations' to be a list")
        pulumi.set(__self__, "allocations", allocations)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def allocations(self) -> Sequence['outputs.GetAllocationsAllocationResult']:
        """
        `(list of allocations)` - A list of allocations matching the
        search criteria.
        """
        return pulumi.get(self, "allocations")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        `(string)` - The namespace the allocation belongs to.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix")


class AwaitableGetAllocationsResult(GetAllocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAllocationsResult(
            allocations=self.allocations,
            filter=self.filter,
            id=self.id,
            namespace=self.namespace,
            prefix=self.prefix)


def get_allocations(filter: Optional[_builtins.str] = None,
                    namespace: Optional[_builtins.str] = None,
                    prefix: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAllocationsResult:
    """
    Retrieve a list of allocations from Nomad.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_allocations(filter="JobID == \\"example\\"")
    ```


    :param _builtins.str filter: `(string: <optional>)` - Specifies the
           [expression][nomad_api_filter] used to filter the results.
    :param _builtins.str namespace: `(string: <optional>)` - Specifies the namespace to search for
           allocations in.
    :param _builtins.str prefix: `(string: <optional>)` - Specifies a string to filter allocations
           based on an ID prefix.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['namespace'] = namespace
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nomad:index/getAllocations:getAllocations', __args__, opts=opts, typ=GetAllocationsResult).value

    return AwaitableGetAllocationsResult(
        allocations=pulumi.get(__ret__, 'allocations'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        prefix=pulumi.get(__ret__, 'prefix'))
def get_allocations_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAllocationsResult]:
    """
    Retrieve a list of allocations from Nomad.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.get_allocations(filter="JobID == \\"example\\"")
    ```


    :param _builtins.str filter: `(string: <optional>)` - Specifies the
           [expression][nomad_api_filter] used to filter the results.
    :param _builtins.str namespace: `(string: <optional>)` - Specifies the namespace to search for
           allocations in.
    :param _builtins.str prefix: `(string: <optional>)` - Specifies a string to filter allocations
           based on an ID prefix.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['namespace'] = namespace
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nomad:index/getAllocations:getAllocations', __args__, opts=opts, typ=GetAllocationsResult)
    return __ret__.apply(lambda __response__: GetAllocationsResult(
        allocations=pulumi.get(__response__, 'allocations'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        prefix=pulumi.get(__response__, 'prefix')))
