# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetVariableResult',
    'AwaitableGetVariableResult',
    'get_variable',
    'get_variable_output',
]

@pulumi.output_type
class GetVariableResult:
    """
    A collection of values returned by getVariable.
    """
    def __init__(__self__, id=None, items=None, namespace=None, path=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, dict):
            raise TypeError("Expected argument 'items' to be a dict")
        pulumi.set(__self__, "items", items)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Mapping[str, _builtins.str]:
        """
        `(map[string]string)` - Map of items in the variable.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        `(string)` - The namespace in which the variable exists.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        `(string)` - The path at which the variable exists.
        """
        return pulumi.get(self, "path")


class AwaitableGetVariableResult(GetVariableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVariableResult(
            id=self.id,
            items=self.items,
            namespace=self.namespace,
            path=self.path)


def get_variable(namespace: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVariableResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.Variable("example", path="path/of/existing/variable")
    ```


    :param _builtins.str namespace: `(string: "default")` - The namepsace in which the variable exists.
    :param _builtins.str path: `(string)` - Path to the existing variable.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nomad:index/getVariable:getVariable', __args__, opts=opts, typ=GetVariableResult).value

    return AwaitableGetVariableResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        namespace=pulumi.get(__ret__, 'namespace'),
        path=pulumi.get(__ret__, 'path'))
def get_variable_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        path: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVariableResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_nomad as nomad

    example = nomad.Variable("example", path="path/of/existing/variable")
    ```


    :param _builtins.str namespace: `(string: "default")` - The namepsace in which the variable exists.
    :param _builtins.str path: `(string)` - Path to the existing variable.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nomad:index/getVariable:getVariable', __args__, opts=opts, typ=GetVariableResult)
    return __ret__.apply(lambda __response__: GetVariableResult(
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        namespace=pulumi.get(__response__, 'namespace'),
        path=pulumi.get(__response__, 'path')))
