# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AclAuthMethodConfig',
    'AclAuthMethodConfigOidcClientAssertion',
    'AclAuthMethodConfigOidcClientAssertionPrivateKey',
    'AclPolicyJobAcl',
    'AclRolePolicy',
    'AclTokenRole',
    'CsiVolumeCapability',
    'CsiVolumeMountOptions',
    'CsiVolumeRegistrationCapability',
    'CsiVolumeRegistrationMountOptions',
    'CsiVolumeRegistrationTopology',
    'CsiVolumeRegistrationTopologyRequest',
    'CsiVolumeRegistrationTopologyRequestRequired',
    'CsiVolumeRegistrationTopologyRequestRequiredTopology',
    'CsiVolumeTopology',
    'CsiVolumeTopologyRequest',
    'CsiVolumeTopologyRequestPreferred',
    'CsiVolumeTopologyRequestPreferredTopology',
    'CsiVolumeTopologyRequestRequired',
    'CsiVolumeTopologyRequestRequiredTopology',
    'DynamicHostVolumeCapability',
    'DynamicHostVolumeConstraint',
    'DynamicHostVolumeRegistrationCapability',
    'DynamicHostVolumeRegistrationConstraint',
    'ExternalVolumeCapability',
    'ExternalVolumeMountOptions',
    'ExternalVolumeTopology',
    'ExternalVolumeTopologyRequest',
    'ExternalVolumeTopologyRequestPreferred',
    'ExternalVolumeTopologyRequestPreferredTopology',
    'ExternalVolumeTopologyRequestRequired',
    'ExternalVolumeTopologyRequestRequiredTopology',
    'JobHcl2',
    'JobTaskGroup',
    'JobTaskGroupTask',
    'JobTaskGroupTaskVolumeMount',
    'JobTaskGroupVolume',
    'NamespaceCapabilities',
    'NamespaceNodePoolConfig',
    'NodePoolSchedulerConfig',
    'QuoteSpecificationLimit',
    'QuoteSpecificationLimitRegionLimit',
    'VolumeCapability',
    'VolumeMountOptions',
    'VolumeTopology',
    'VolumeTopologyRequest',
    'VolumeTopologyRequestRequired',
    'VolumeTopologyRequestRequiredTopology',
    'GetAclPoliciesPolicyResult',
    'GetAclRolePolicyResult',
    'GetAclRolesAclRoleResult',
    'GetAclRolesAclRolePolicyResult',
    'GetAclTokenRoleResult',
    'GetAclTokensAclTokenResult',
    'GetAclTokensAclTokenRoleResult',
    'GetAllocationsAllocationResult',
    'GetDynamicHostVolumeCapabilityResult',
    'GetDynamicHostVolumeConstraintResult',
    'GetJobConstraintResult',
    'GetJobPeriodicConfigResult',
    'GetJobTaskGroupResult',
    'GetJobTaskGroupTaskResult',
    'GetJobTaskGroupTaskVolumeMountResult',
    'GetJobTaskGroupVolumeResult',
    'GetJwksKeyResult',
    'GetNamespaceCapabilityResult',
    'GetNamespaceNodePoolConfigResult',
    'GetNodePoolSchedulerConfigResult',
    'GetNodePoolsNodePoolResult',
    'GetNodePoolsNodePoolSchedulerConfigResult',
    'GetPluginNodeResult',
    'GetScalingPoliciesPolicyResult',
]

@pulumi.output_type
class AclAuthMethodConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRedirectUris":
            suggest = "allowed_redirect_uris"
        elif key == "boundAudiences":
            suggest = "bound_audiences"
        elif key == "boundIssuers":
            suggest = "bound_issuers"
        elif key == "claimMappings":
            suggest = "claim_mappings"
        elif key == "clockSkewLeeway":
            suggest = "clock_skew_leeway"
        elif key == "discoveryCaPems":
            suggest = "discovery_ca_pems"
        elif key == "expirationLeeway":
            suggest = "expiration_leeway"
        elif key == "jwksCaCert":
            suggest = "jwks_ca_cert"
        elif key == "jwksUrl":
            suggest = "jwks_url"
        elif key == "jwtValidationPubKeys":
            suggest = "jwt_validation_pub_keys"
        elif key == "listClaimMappings":
            suggest = "list_claim_mappings"
        elif key == "notBeforeLeeway":
            suggest = "not_before_leeway"
        elif key == "oidcClientAssertion":
            suggest = "oidc_client_assertion"
        elif key == "oidcClientId":
            suggest = "oidc_client_id"
        elif key == "oidcClientSecret":
            suggest = "oidc_client_secret"
        elif key == "oidcDisableUserinfo":
            suggest = "oidc_disable_userinfo"
        elif key == "oidcDiscoveryUrl":
            suggest = "oidc_discovery_url"
        elif key == "oidcEnablePkce":
            suggest = "oidc_enable_pkce"
        elif key == "oidcScopes":
            suggest = "oidc_scopes"
        elif key == "signingAlgs":
            suggest = "signing_algs"
        elif key == "verboseLogging":
            suggest = "verbose_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAuthMethodConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAuthMethodConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAuthMethodConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_redirect_uris: Optional[Sequence[_builtins.str]] = None,
                 bound_audiences: Optional[Sequence[_builtins.str]] = None,
                 bound_issuers: Optional[Sequence[_builtins.str]] = None,
                 claim_mappings: Optional[Mapping[str, _builtins.str]] = None,
                 clock_skew_leeway: Optional[_builtins.str] = None,
                 discovery_ca_pems: Optional[Sequence[_builtins.str]] = None,
                 expiration_leeway: Optional[_builtins.str] = None,
                 jwks_ca_cert: Optional[_builtins.str] = None,
                 jwks_url: Optional[_builtins.str] = None,
                 jwt_validation_pub_keys: Optional[Sequence[_builtins.str]] = None,
                 list_claim_mappings: Optional[Mapping[str, _builtins.str]] = None,
                 not_before_leeway: Optional[_builtins.str] = None,
                 oidc_client_assertion: Optional['outputs.AclAuthMethodConfigOidcClientAssertion'] = None,
                 oidc_client_id: Optional[_builtins.str] = None,
                 oidc_client_secret: Optional[_builtins.str] = None,
                 oidc_disable_userinfo: Optional[_builtins.bool] = None,
                 oidc_discovery_url: Optional[_builtins.str] = None,
                 oidc_enable_pkce: Optional[_builtins.bool] = None,
                 oidc_scopes: Optional[Sequence[_builtins.str]] = None,
                 signing_algs: Optional[Sequence[_builtins.str]] = None,
                 verbose_logging: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] allowed_redirect_uris: `([]string: <optional>)` - A list of allowed values
               that can be used for the redirect URI.
        :param Sequence[_builtins.str] bound_audiences: `([]string: <optional>)` - List of auth claims that are
               valid for login.
        :param Sequence[_builtins.str] bound_issuers: `([]string: <optional>)` - The value against which to match
               the iss claim in a JWT.
        :param Mapping[str, _builtins.str] claim_mappings: Mappings of claims (key) that will be copied to a metadata field (value).
        :param _builtins.str clock_skew_leeway: `(string: <optional>)` - Duration of leeway when validating
               all claims in the form of a time duration such as "5m" or "1h".
        :param Sequence[_builtins.str] discovery_ca_pems: `([]string: <optional>)` - PEM encoded CA certs for use
               by the TLS client used to talk with the OIDC Discovery URL.
        :param _builtins.str expiration_leeway: `(string: <optional>)` - Duration of leeway when validating
               expiration of a JWT in the form of a time duration such as "5m" or "1h".
        :param _builtins.str jwks_ca_cert: `(string: <optional>)` - PEM encoded CA cert for use by the 
               TLS client used to talk with the JWKS server.
        :param _builtins.str jwks_url: `(string: <optional>)` - JSON Web Key Sets url for authenticating
               signatures.
        :param Sequence[_builtins.str] jwt_validation_pub_keys: `([]string: <optional>)` - List of PEM-encoded 
               public keys to use to authenticate signatures locally.
        :param Mapping[str, _builtins.str] list_claim_mappings: Mappings of list claims (key) that will be copied to a metadata field (value).
        :param _builtins.str not_before_leeway: `(string: <optional>)` - Duration of leeway when validating
               not before values of a token in the form of a time duration such as "5m" or "1h".
        :param 'AclAuthMethodConfigOidcClientAssertionArgs' oidc_client_assertion: `(OIDCClientAssertion: <optional>)` - Optionally
               send a signed JWT ("[private key jwt][]") as a client assertion to the OIDC
               provider. Browse to the [OIDC concepts][concepts-assertions] page to learn
               more.
        :param _builtins.str oidc_client_id: `(string: <optional>)` - The OAuth Client ID configured
               with the OIDC provider.
        :param _builtins.str oidc_client_secret: `(string: <optional>)` - The OAuth Client Secret
               configured with the OIDC provider.
        :param _builtins.bool oidc_disable_userinfo: `(bool: false)` - When set to `true`, Nomad will
               not make a request to the identity provider to get OIDC `UserInfo`.
               You may wish to set this if your identity provider doesn't send any
               additional claims from the `UserInfo` endpoint.
        :param _builtins.str oidc_discovery_url: `(string: <optional>)` - The OIDC Discovery URL,
               without any .well-known component (base path).
        :param _builtins.bool oidc_enable_pkce: `(bool: false)` - When set to `true`, Nomad will include
               [PKCE][] verification in the auth flow. Even with PKCE enabled in Nomad,
               you may still need to enable it in your OIDC provider.
        :param Sequence[_builtins.str] oidc_scopes: `([]string: <optional>)` - List of OIDC scopes.
        :param Sequence[_builtins.str] signing_algs: `([]string: <optional>)` - A list of supported signing
               algorithms.
        :param _builtins.bool verbose_logging: Enable OIDC verbose logging on the Nomad server.
        """
        if allowed_redirect_uris is not None:
            pulumi.set(__self__, "allowed_redirect_uris", allowed_redirect_uris)
        if bound_audiences is not None:
            pulumi.set(__self__, "bound_audiences", bound_audiences)
        if bound_issuers is not None:
            pulumi.set(__self__, "bound_issuers", bound_issuers)
        if claim_mappings is not None:
            pulumi.set(__self__, "claim_mappings", claim_mappings)
        if clock_skew_leeway is not None:
            pulumi.set(__self__, "clock_skew_leeway", clock_skew_leeway)
        if discovery_ca_pems is not None:
            pulumi.set(__self__, "discovery_ca_pems", discovery_ca_pems)
        if expiration_leeway is not None:
            pulumi.set(__self__, "expiration_leeway", expiration_leeway)
        if jwks_ca_cert is not None:
            pulumi.set(__self__, "jwks_ca_cert", jwks_ca_cert)
        if jwks_url is not None:
            pulumi.set(__self__, "jwks_url", jwks_url)
        if jwt_validation_pub_keys is not None:
            pulumi.set(__self__, "jwt_validation_pub_keys", jwt_validation_pub_keys)
        if list_claim_mappings is not None:
            pulumi.set(__self__, "list_claim_mappings", list_claim_mappings)
        if not_before_leeway is not None:
            pulumi.set(__self__, "not_before_leeway", not_before_leeway)
        if oidc_client_assertion is not None:
            pulumi.set(__self__, "oidc_client_assertion", oidc_client_assertion)
        if oidc_client_id is not None:
            pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        if oidc_client_secret is not None:
            pulumi.set(__self__, "oidc_client_secret", oidc_client_secret)
        if oidc_disable_userinfo is not None:
            pulumi.set(__self__, "oidc_disable_userinfo", oidc_disable_userinfo)
        if oidc_discovery_url is not None:
            pulumi.set(__self__, "oidc_discovery_url", oidc_discovery_url)
        if oidc_enable_pkce is not None:
            pulumi.set(__self__, "oidc_enable_pkce", oidc_enable_pkce)
        if oidc_scopes is not None:
            pulumi.set(__self__, "oidc_scopes", oidc_scopes)
        if signing_algs is not None:
            pulumi.set(__self__, "signing_algs", signing_algs)
        if verbose_logging is not None:
            pulumi.set(__self__, "verbose_logging", verbose_logging)

    @_builtins.property
    @pulumi.getter(name="allowedRedirectUris")
    def allowed_redirect_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - A list of allowed values
        that can be used for the redirect URI.
        """
        return pulumi.get(self, "allowed_redirect_uris")

    @_builtins.property
    @pulumi.getter(name="boundAudiences")
    def bound_audiences(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - List of auth claims that are
        valid for login.
        """
        return pulumi.get(self, "bound_audiences")

    @_builtins.property
    @pulumi.getter(name="boundIssuers")
    def bound_issuers(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - The value against which to match
        the iss claim in a JWT.
        """
        return pulumi.get(self, "bound_issuers")

    @_builtins.property
    @pulumi.getter(name="claimMappings")
    def claim_mappings(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mappings of claims (key) that will be copied to a metadata field (value).
        """
        return pulumi.get(self, "claim_mappings")

    @_builtins.property
    @pulumi.getter(name="clockSkewLeeway")
    def clock_skew_leeway(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - Duration of leeway when validating
        all claims in the form of a time duration such as "5m" or "1h".
        """
        return pulumi.get(self, "clock_skew_leeway")

    @_builtins.property
    @pulumi.getter(name="discoveryCaPems")
    def discovery_ca_pems(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - PEM encoded CA certs for use
        by the TLS client used to talk with the OIDC Discovery URL.
        """
        return pulumi.get(self, "discovery_ca_pems")

    @_builtins.property
    @pulumi.getter(name="expirationLeeway")
    def expiration_leeway(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - Duration of leeway when validating
        expiration of a JWT in the form of a time duration such as "5m" or "1h".
        """
        return pulumi.get(self, "expiration_leeway")

    @_builtins.property
    @pulumi.getter(name="jwksCaCert")
    def jwks_ca_cert(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - PEM encoded CA cert for use by the 
        TLS client used to talk with the JWKS server.
        """
        return pulumi.get(self, "jwks_ca_cert")

    @_builtins.property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - JSON Web Key Sets url for authenticating
        signatures.
        """
        return pulumi.get(self, "jwks_url")

    @_builtins.property
    @pulumi.getter(name="jwtValidationPubKeys")
    def jwt_validation_pub_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - List of PEM-encoded 
        public keys to use to authenticate signatures locally.
        """
        return pulumi.get(self, "jwt_validation_pub_keys")

    @_builtins.property
    @pulumi.getter(name="listClaimMappings")
    def list_claim_mappings(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Mappings of list claims (key) that will be copied to a metadata field (value).
        """
        return pulumi.get(self, "list_claim_mappings")

    @_builtins.property
    @pulumi.getter(name="notBeforeLeeway")
    def not_before_leeway(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - Duration of leeway when validating
        not before values of a token in the form of a time duration such as "5m" or "1h".
        """
        return pulumi.get(self, "not_before_leeway")

    @_builtins.property
    @pulumi.getter(name="oidcClientAssertion")
    def oidc_client_assertion(self) -> Optional['outputs.AclAuthMethodConfigOidcClientAssertion']:
        """
        `(OIDCClientAssertion: <optional>)` - Optionally
        send a signed JWT ("[private key jwt][]") as a client assertion to the OIDC
        provider. Browse to the [OIDC concepts][concepts-assertions] page to learn
        more.
        """
        return pulumi.get(self, "oidc_client_assertion")

    @_builtins.property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - The OAuth Client ID configured
        with the OIDC provider.
        """
        return pulumi.get(self, "oidc_client_id")

    @_builtins.property
    @pulumi.getter(name="oidcClientSecret")
    def oidc_client_secret(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - The OAuth Client Secret
        configured with the OIDC provider.
        """
        return pulumi.get(self, "oidc_client_secret")

    @_builtins.property
    @pulumi.getter(name="oidcDisableUserinfo")
    def oidc_disable_userinfo(self) -> Optional[_builtins.bool]:
        """
        `(bool: false)` - When set to `true`, Nomad will
        not make a request to the identity provider to get OIDC `UserInfo`.
        You may wish to set this if your identity provider doesn't send any
        additional claims from the `UserInfo` endpoint.
        """
        return pulumi.get(self, "oidc_disable_userinfo")

    @_builtins.property
    @pulumi.getter(name="oidcDiscoveryUrl")
    def oidc_discovery_url(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - The OIDC Discovery URL,
        without any .well-known component (base path).
        """
        return pulumi.get(self, "oidc_discovery_url")

    @_builtins.property
    @pulumi.getter(name="oidcEnablePkce")
    def oidc_enable_pkce(self) -> Optional[_builtins.bool]:
        """
        `(bool: false)` - When set to `true`, Nomad will include
        [PKCE][] verification in the auth flow. Even with PKCE enabled in Nomad,
        you may still need to enable it in your OIDC provider.
        """
        return pulumi.get(self, "oidc_enable_pkce")

    @_builtins.property
    @pulumi.getter(name="oidcScopes")
    def oidc_scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - List of OIDC scopes.
        """
        return pulumi.get(self, "oidc_scopes")

    @_builtins.property
    @pulumi.getter(name="signingAlgs")
    def signing_algs(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - A list of supported signing
        algorithms.
        """
        return pulumi.get(self, "signing_algs")

    @_builtins.property
    @pulumi.getter(name="verboseLogging")
    def verbose_logging(self) -> Optional[_builtins.bool]:
        """
        Enable OIDC verbose logging on the Nomad server.
        """
        return pulumi.get(self, "verbose_logging")


@pulumi.output_type
class AclAuthMethodConfigOidcClientAssertion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "extraHeaders":
            suggest = "extra_headers"
        elif key == "keyAlgorithm":
            suggest = "key_algorithm"
        elif key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAuthMethodConfigOidcClientAssertion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAuthMethodConfigOidcClientAssertion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAuthMethodConfigOidcClientAssertion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: _builtins.str,
                 audiences: Optional[Sequence[_builtins.str]] = None,
                 extra_headers: Optional[Mapping[str, _builtins.str]] = None,
                 key_algorithm: Optional[_builtins.str] = None,
                 private_key: Optional['outputs.AclAuthMethodConfigOidcClientAssertionPrivateKey'] = None):
        """
        :param _builtins.str key_source: `(string: <required>)` - Specifies where to get the private
               key to sign the JWT.
               Available sources:
               - "nomad": Use current active key in Nomad's keyring
               - "private_key": Use key material in the `private_key` field
               - "client_secret": Use the `oidc_client_secret` as an HMAC key
        :param Sequence[_builtins.str] audiences: `([]string: optional)` - Who processes the assertion.
               Defaults to the auth method's `oidc_discovery_url`.
        :param Mapping[str, _builtins.str] extra_headers: `(map[string]string: optional)` - Add to the JWT headers,
               alongside "kid" and "type". Setting the "kid" header here is not allowed;
               use `private_key.key_id`.
        :param _builtins.str key_algorithm: `(string: <optional>)` is the key's algorithm.
               Its default values are based on the `key_source`:
               - "nomad": "RS256"; this is from Nomad's keyring and must not be changed
               - "private_key": "RS256"; must be RS256, RS384, or RS512
               - "client_secret": "HS256"; must be HS256, HS384, or HS512
        :param 'AclAuthMethodConfigOidcClientAssertionPrivateKeyArgs' private_key: `(OIDCClientAssertionKey: <optional>)` - External key
               to sign the JWT. `key_source` must be "private_key" to enable this.
        """
        pulumi.set(__self__, "key_source", key_source)
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if extra_headers is not None:
            pulumi.set(__self__, "extra_headers", extra_headers)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @_builtins.property
    @pulumi.getter(name="keySource")
    def key_source(self) -> _builtins.str:
        """
        `(string: <required>)` - Specifies where to get the private
        key to sign the JWT.
        Available sources:
        - "nomad": Use current active key in Nomad's keyring
        - "private_key": Use key material in the `private_key` field
        - "client_secret": Use the `oidc_client_secret` as an HMAC key
        """
        return pulumi.get(self, "key_source")

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: optional)` - Who processes the assertion.
        Defaults to the auth method's `oidc_discovery_url`.
        """
        return pulumi.get(self, "audiences")

    @_builtins.property
    @pulumi.getter(name="extraHeaders")
    def extra_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        `(map[string]string: optional)` - Add to the JWT headers,
        alongside "kid" and "type". Setting the "kid" header here is not allowed;
        use `private_key.key_id`.
        """
        return pulumi.get(self, "extra_headers")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` is the key's algorithm.
        Its default values are based on the `key_source`:
        - "nomad": "RS256"; this is from Nomad's keyring and must not be changed
        - "private_key": "RS256"; must be RS256, RS384, or RS512
        - "client_secret": "HS256"; must be HS256, HS384, or HS512
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional['outputs.AclAuthMethodConfigOidcClientAssertionPrivateKey']:
        """
        `(OIDCClientAssertionKey: <optional>)` - External key
        to sign the JWT. `key_source` must be "private_key" to enable this.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class AclAuthMethodConfigOidcClientAssertionPrivateKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyIdHeader":
            suggest = "key_id_header"
        elif key == "pemCert":
            suggest = "pem_cert"
        elif key == "pemCertFile":
            suggest = "pem_cert_file"
        elif key == "pemKey":
            suggest = "pem_key"
        elif key == "pemKeyFile":
            suggest = "pem_key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclAuthMethodConfigOidcClientAssertionPrivateKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclAuthMethodConfigOidcClientAssertionPrivateKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclAuthMethodConfigOidcClientAssertionPrivateKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[_builtins.str] = None,
                 key_id_header: Optional[_builtins.str] = None,
                 pem_cert: Optional[_builtins.str] = None,
                 pem_cert_file: Optional[_builtins.str] = None,
                 pem_key: Optional[_builtins.str] = None,
                 pem_key_file: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: `(string: optional)` - Becomes the JWT's "kid" header.
               Mutually exclusive with `pem_cert` and `pem_cert_file`.
               Allowed `key_id_header` values: "kid" (the default)
        :param _builtins.str key_id_header: `(string: optional)` - Which header the provider uses
               to find the public key to verify the signed JWT.
               The default and allowed values depend on whether you set `key_id`,
               `pem_cert`, or `pem_cert_file`. You must set exactly one of those
               options, so refer to them for their requirements.
        :param _builtins.str pem_cert: `(string: optional)` - An x509 certificate, signed by the
               private key or a CA, in pem format. Nomad uses this certificate to
               derive an [x5t#S256][] (or [x5t][]) key_id.
               Mutually exclusive with `pem_cert_file` and `key_id`.
               Allowed `key_id_header` values: "x5t", "x5t#S256" (default "x5t#S256")
        :param _builtins.str pem_cert_file: `(string: optional)` - An absolute path to an x509
               certificate on Nomad servers' disk, signed by the private key or a CA,
               in pem format.
               Nomad uses this certificate to derive an [x5t#S256][] (or [x5t][])
               header. Mutually exclusive with `pem_cert` and key_id.
               Allowed `key_id_header` values: "x5t", "x5t#S256" (default "x5t#S256")
        :param _builtins.str pem_key: `(string: <optional>)` - An RSA private key, in pem format.
               It is used to sign the JWT. Mutually exclusive with `pem_key`.
        :param _builtins.str pem_key_file: `(string: optional)` - An absolute path to a private key
               on Nomad servers' disk, in pem format. It is used to sign the JWT.
               Mutually exclusive with `pem_key_file`.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_id_header is not None:
            pulumi.set(__self__, "key_id_header", key_id_header)
        if pem_cert is not None:
            pulumi.set(__self__, "pem_cert", pem_cert)
        if pem_cert_file is not None:
            pulumi.set(__self__, "pem_cert_file", pem_cert_file)
        if pem_key is not None:
            pulumi.set(__self__, "pem_key", pem_key)
        if pem_key_file is not None:
            pulumi.set(__self__, "pem_key_file", pem_key_file)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - Becomes the JWT's "kid" header.
        Mutually exclusive with `pem_cert` and `pem_cert_file`.
        Allowed `key_id_header` values: "kid" (the default)
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyIdHeader")
    def key_id_header(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - Which header the provider uses
        to find the public key to verify the signed JWT.
        The default and allowed values depend on whether you set `key_id`,
        `pem_cert`, or `pem_cert_file`. You must set exactly one of those
        options, so refer to them for their requirements.
        """
        return pulumi.get(self, "key_id_header")

    @_builtins.property
    @pulumi.getter(name="pemCert")
    def pem_cert(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - An x509 certificate, signed by the
        private key or a CA, in pem format. Nomad uses this certificate to
        derive an [x5t#S256][] (or [x5t][]) key_id.
        Mutually exclusive with `pem_cert_file` and `key_id`.
        Allowed `key_id_header` values: "x5t", "x5t#S256" (default "x5t#S256")
        """
        return pulumi.get(self, "pem_cert")

    @_builtins.property
    @pulumi.getter(name="pemCertFile")
    def pem_cert_file(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - An absolute path to an x509
        certificate on Nomad servers' disk, signed by the private key or a CA,
        in pem format.
        Nomad uses this certificate to derive an [x5t#S256][] (or [x5t][])
        header. Mutually exclusive with `pem_cert` and key_id.
        Allowed `key_id_header` values: "x5t", "x5t#S256" (default "x5t#S256")
        """
        return pulumi.get(self, "pem_cert_file")

    @_builtins.property
    @pulumi.getter(name="pemKey")
    def pem_key(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - An RSA private key, in pem format.
        It is used to sign the JWT. Mutually exclusive with `pem_key`.
        """
        return pulumi.get(self, "pem_key")

    @_builtins.property
    @pulumi.getter(name="pemKeyFile")
    def pem_key_file(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - An absolute path to a private key
        on Nomad servers' disk, in pem format. It is used to sign the JWT.
        Mutually exclusive with `pem_key_file`.
        """
        return pulumi.get(self, "pem_key_file")


@pulumi.output_type
class AclPolicyJobAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclPolicyJobAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclPolicyJobAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclPolicyJobAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: _builtins.str,
                 group: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 task: Optional[_builtins.str] = None):
        """
        :param _builtins.str job_id: Job
        :param _builtins.str group: Group
        :param _builtins.str namespace: Namespace
        :param _builtins.str task: Task
        """
        pulumi.set(__self__, "job_id", job_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if task is not None:
            pulumi.set(__self__, "task", task)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        """
        Job
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        Group
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        Namespace
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def task(self) -> Optional[_builtins.str]:
        """
        Task
        """
        return pulumi.get(self, "task")


@pulumi.output_type
class AclRolePolicy(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: `(string: <required>)` - A human-friendly name for this ACL Role.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string: <required>)` - A human-friendly name for this ACL Role.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AclTokenRole(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the ACL role to link.
        :param _builtins.str name: `(string: "")` - A human-friendly name for this token.
        """
        pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the ACL role to link.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        `(string: "")` - A human-friendly name for this token.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CsiVolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param _builtins.str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class CsiVolumeMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 mount_flags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str fs_type: `(string: optional)` - The file system type.
        :param Sequence[_builtins.str] mount_flags: `[]string: optional` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[_builtins.str]]:
        """
        `[]string: optional` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class CsiVolumeRegistrationCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeRegistrationCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeRegistrationCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeRegistrationCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param _builtins.str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class CsiVolumeRegistrationMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsiVolumeRegistrationMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsiVolumeRegistrationMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsiVolumeRegistrationMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 mount_flags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str fs_type: `(string: <optional>)` - The file system type.
        :param Sequence[_builtins.str] mount_flags: `([]string: <optional>)` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class CsiVolumeRegistrationTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeRegistrationTopologyRequest(dict):
    def __init__(__self__, *,
                 required: Optional['outputs.CsiVolumeRegistrationTopologyRequestRequired'] = None):
        """
        :param 'CsiVolumeRegistrationTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional['outputs.CsiVolumeRegistrationTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class CsiVolumeRegistrationTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.CsiVolumeRegistrationTopologyRequestRequiredTopology']):
        """
        :param Sequence['CsiVolumeRegistrationTopologyRequestRequiredTopologyArgs'] topologies: Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.CsiVolumeRegistrationTopologyRequestRequiredTopology']:
        """
        Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class CsiVolumeRegistrationTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] segments: Define attributes for the topology request.
        """
        pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Mapping[str, _builtins.str]:
        """
        Define attributes for the topology request.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeTopologyRequest(dict):
    def __init__(__self__, *,
                 preferred: Optional['outputs.CsiVolumeTopologyRequestPreferred'] = None,
                 required: Optional['outputs.CsiVolumeTopologyRequestRequired'] = None):
        """
        :param 'CsiVolumeTopologyRequestPreferredArgs' preferred: `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        :param 'CsiVolumeTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if preferred is not None:
            pulumi.set(__self__, "preferred", preferred)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def preferred(self) -> Optional['outputs.CsiVolumeTopologyRequestPreferred']:
        """
        `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        """
        return pulumi.get(self, "preferred")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional['outputs.CsiVolumeTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class CsiVolumeTopologyRequestPreferred(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.CsiVolumeTopologyRequestPreferredTopology']):
        """
        :param Sequence['CsiVolumeTopologyRequestPreferredTopologyArgs'] topologies: Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.CsiVolumeTopologyRequestPreferredTopology']:
        """
        Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class CsiVolumeTopologyRequestPreferredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] segments: Define the attributes for the topology request.
        """
        pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Mapping[str, _builtins.str]:
        """
        Define the attributes for the topology request.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class CsiVolumeTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.CsiVolumeTopologyRequestRequiredTopology']):
        """
        :param Sequence['CsiVolumeTopologyRequestRequiredTopologyArgs'] topologies: Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.CsiVolumeTopologyRequestRequiredTopology']:
        """
        Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class CsiVolumeTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] segments: Define the attributes for the topology request.
        """
        pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Mapping[str, _builtins.str]:
        """
        Define the attributes for the topology request.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class DynamicHostVolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicHostVolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicHostVolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicHostVolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string)` - How the volume can be mounted by
               allocations. Refer to the [`access_mode`][] documentation for details.
        :param _builtins.str attachment_mode: `(string)` - The storage API that will be used by the
               volume. Refer to the [`attachment_mode`][] documentation.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string)` - How the volume can be mounted by
        allocations. Refer to the [`access_mode`][] documentation for details.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string)` - The storage API that will be used by the
        volume. Refer to the [`attachment_mode`][] documentation.
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class DynamicHostVolumeConstraint(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 operator: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str attribute: `(string)` - The [node attribute][] to check for the constraint.
        :param _builtins.str operator: `(string)`- The operator to use in the comparison.
        :param _builtins.str value: `(string)` - The value of the attribute to compare against.
        """
        pulumi.set(__self__, "attribute", attribute)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        `(string)` - The [node attribute][] to check for the constraint.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        `(string)`- The operator to use in the comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        `(string)` - The value of the attribute to compare against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DynamicHostVolumeRegistrationCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicHostVolumeRegistrationCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicHostVolumeRegistrationCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicHostVolumeRegistrationCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string)` - How the volume can be mounted by
               allocations. Refer to the [`access_mode`][] documentation for details.
        :param _builtins.str attachment_mode: `(string)` - The storage API that will be used by the
               volume. Refer to the [`attachment_mode`][] documentation.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string)` - How the volume can be mounted by
        allocations. Refer to the [`access_mode`][] documentation for details.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string)` - The storage API that will be used by the
        volume. Refer to the [`attachment_mode`][] documentation.
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class DynamicHostVolumeRegistrationConstraint(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 operator: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str attribute: An attribute to check to constrain volume placement
        :param _builtins.str operator: The operator to use for comparison
        :param _builtins.str value: The requested value of the attribute
        """
        pulumi.set(__self__, "attribute", attribute)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        An attribute to check to constrain volume placement
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The requested value of the attribute
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ExternalVolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalVolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalVolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalVolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param _builtins.str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class ExternalVolumeMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalVolumeMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalVolumeMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalVolumeMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 mount_flags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str fs_type: `(string: optional)` - The file system type.
        :param Sequence[_builtins.str] mount_flags: `[]string: optional` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        `(string: optional)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[_builtins.str]]:
        """
        `[]string: optional` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class ExternalVolumeTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class ExternalVolumeTopologyRequest(dict):
    def __init__(__self__, *,
                 preferred: Optional['outputs.ExternalVolumeTopologyRequestPreferred'] = None,
                 required: Optional['outputs.ExternalVolumeTopologyRequestRequired'] = None):
        """
        :param 'ExternalVolumeTopologyRequestPreferredArgs' preferred: `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        :param 'ExternalVolumeTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if preferred is not None:
            pulumi.set(__self__, "preferred", preferred)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def preferred(self) -> Optional['outputs.ExternalVolumeTopologyRequestPreferred']:
        """
        `(``Topology``: <optional>)` - Preferred topologies indicate that the volume should be created in a location accessible from some of the listed topologies.
        """
        return pulumi.get(self, "preferred")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional['outputs.ExternalVolumeTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class ExternalVolumeTopologyRequestPreferred(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.ExternalVolumeTopologyRequestPreferredTopology']):
        """
        :param Sequence['ExternalVolumeTopologyRequestPreferredTopologyArgs'] topologies: Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.ExternalVolumeTopologyRequestPreferredTopology']:
        """
        Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class ExternalVolumeTopologyRequestPreferredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] segments: Define the attributes for the topology request.
        """
        pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Mapping[str, _builtins.str]:
        """
        Define the attributes for the topology request.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class ExternalVolumeTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.ExternalVolumeTopologyRequestRequiredTopology']):
        """
        :param Sequence['ExternalVolumeTopologyRequestRequiredTopologyArgs'] topologies: Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.ExternalVolumeTopologyRequestRequiredTopology']:
        """
        Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class ExternalVolumeTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] segments: Define the attributes for the topology request.
        """
        pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Mapping[str, _builtins.str]:
        """
        Define the attributes for the topology request.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class JobHcl2(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowFs":
            suggest = "allow_fs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobHcl2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobHcl2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobHcl2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_fs: Optional[_builtins.bool] = None,
                 vars: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.bool allow_fs: `(boolean: false)` - Set this to `true` to be able to use
               HCL2 filesystem functions
        :param Mapping[str, _builtins.str] vars: Additional variables to use when templating the job with HCL2
        """
        if allow_fs is not None:
            pulumi.set(__self__, "allow_fs", allow_fs)
        if vars is not None:
            pulumi.set(__self__, "vars", vars)

    @_builtins.property
    @pulumi.getter(name="allowFs")
    def allow_fs(self) -> Optional[_builtins.bool]:
        """
        `(boolean: false)` - Set this to `true` to be able to use
        HCL2 filesystem functions
        """
        return pulumi.get(self, "allow_fs")

    @_builtins.property
    @pulumi.getter
    def vars(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Additional variables to use when templating the job with HCL2
        """
        return pulumi.get(self, "vars")


@pulumi.output_type
class JobTaskGroup(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 meta: Optional[Mapping[str, _builtins.str]] = None,
                 name: Optional[_builtins.str] = None,
                 tasks: Optional[Sequence['outputs.JobTaskGroupTask']] = None,
                 volumes: Optional[Sequence['outputs.JobTaskGroupVolume']] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Optional[Sequence['outputs.JobTaskGroupTask']]:
        return pulumi.get(self, "tasks")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobTaskGroupVolume']]:
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobTaskGroupTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTaskGroupTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTaskGroupTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTaskGroupTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: Optional[_builtins.str] = None,
                 meta: Optional[Mapping[str, _builtins.str]] = None,
                 name: Optional[_builtins.str] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTaskGroupTaskVolumeMount']] = None):
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTaskGroupTaskVolumeMount']]:
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobTaskGroupTaskVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTaskGroupTaskVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTaskGroupTaskVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTaskGroupTaskVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume: Optional[_builtins.str] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def volume(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "volume")


@pulumi.output_type
class JobTaskGroupVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTaskGroupVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTaskGroupVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTaskGroupVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 source: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class NamespaceCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledNetworkModes":
            suggest = "disabled_network_modes"
        elif key == "disabledTaskDrivers":
            suggest = "disabled_task_drivers"
        elif key == "enabledNetworkModes":
            suggest = "enabled_network_modes"
        elif key == "enabledTaskDrivers":
            suggest = "enabled_task_drivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_network_modes: Optional[Sequence[_builtins.str]] = None,
                 disabled_task_drivers: Optional[Sequence[_builtins.str]] = None,
                 enabled_network_modes: Optional[Sequence[_builtins.str]] = None,
                 enabled_task_drivers: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] disabled_network_modes: `([]string: <optional>)` - Network modes disabled for the namespace.
        :param Sequence[_builtins.str] disabled_task_drivers: `([]string: <optional>)` - Task drivers disabled for the namespace.
        :param Sequence[_builtins.str] enabled_network_modes: `([]string: <optional>)` - Network modes enabled for the namespace.
        :param Sequence[_builtins.str] enabled_task_drivers: `([]string: <optional>)` - Task drivers enabled for the namespace.
        """
        if disabled_network_modes is not None:
            pulumi.set(__self__, "disabled_network_modes", disabled_network_modes)
        if disabled_task_drivers is not None:
            pulumi.set(__self__, "disabled_task_drivers", disabled_task_drivers)
        if enabled_network_modes is not None:
            pulumi.set(__self__, "enabled_network_modes", enabled_network_modes)
        if enabled_task_drivers is not None:
            pulumi.set(__self__, "enabled_task_drivers", enabled_task_drivers)

    @_builtins.property
    @pulumi.getter(name="disabledNetworkModes")
    def disabled_network_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - Network modes disabled for the namespace.
        """
        return pulumi.get(self, "disabled_network_modes")

    @_builtins.property
    @pulumi.getter(name="disabledTaskDrivers")
    def disabled_task_drivers(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - Task drivers disabled for the namespace.
        """
        return pulumi.get(self, "disabled_task_drivers")

    @_builtins.property
    @pulumi.getter(name="enabledNetworkModes")
    def enabled_network_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - Network modes enabled for the namespace.
        """
        return pulumi.get(self, "enabled_network_modes")

    @_builtins.property
    @pulumi.getter(name="enabledTaskDrivers")
    def enabled_task_drivers(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - Task drivers enabled for the namespace.
        """
        return pulumi.get(self, "enabled_task_drivers")


@pulumi.output_type
class NamespaceNodePoolConfig(dict):
    def __init__(__self__, *,
                 alloweds: Optional[Sequence[_builtins.str]] = None,
                 default: Optional[_builtins.str] = None,
                 denieds: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] alloweds: `([]string: <optional>)` - The list of node pools that are allowed to be used in this namespace.
        :param _builtins.str default: `(string: <optional>)` - The default node pool for jobs that don't define one.
        :param Sequence[_builtins.str] denieds: `([]string: <optional>)` - The list of node pools that are not allowed to be used in this namespace.
        """
        if alloweds is not None:
            pulumi.set(__self__, "alloweds", alloweds)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if denieds is not None:
            pulumi.set(__self__, "denieds", denieds)

    @_builtins.property
    @pulumi.getter
    def alloweds(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - The list of node pools that are allowed to be used in this namespace.
        """
        return pulumi.get(self, "alloweds")

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - The default node pool for jobs that don't define one.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def denieds(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - The list of node pools that are not allowed to be used in this namespace.
        """
        return pulumi.get(self, "denieds")


@pulumi.output_type
class NodePoolSchedulerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryOversubscription":
            suggest = "memory_oversubscription"
        elif key == "schedulerAlgorithm":
            suggest = "scheduler_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolSchedulerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolSchedulerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolSchedulerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_oversubscription: Optional[_builtins.str] = None,
                 scheduler_algorithm: Optional[_builtins.str] = None):
        """
        :param _builtins.str memory_oversubscription: `(string)` - Whether or not memory
               oversubscription is enabled in the node pool. Possible values are
               `"enabled"` or `"disabled"`. If not defined the global cluster
               configuration is used.
               
               > This option differs from Nomad, where it's represented as a boolean, to
               allow distinguishing between memory oversubscription being disabled in the
               node pool and this property not being set.
        :param _builtins.str scheduler_algorithm: `(string)` - The scheduler algorithm used in the node
               pool. Possible values are `binpack` or `spread`. If not defined the global
               cluster configuration is used.
        """
        if memory_oversubscription is not None:
            pulumi.set(__self__, "memory_oversubscription", memory_oversubscription)
        if scheduler_algorithm is not None:
            pulumi.set(__self__, "scheduler_algorithm", scheduler_algorithm)

    @_builtins.property
    @pulumi.getter(name="memoryOversubscription")
    def memory_oversubscription(self) -> Optional[_builtins.str]:
        """
        `(string)` - Whether or not memory
        oversubscription is enabled in the node pool. Possible values are
        `"enabled"` or `"disabled"`. If not defined the global cluster
        configuration is used.

        > This option differs from Nomad, where it's represented as a boolean, to
        allow distinguishing between memory oversubscription being disabled in the
        node pool and this property not being set.
        """
        return pulumi.get(self, "memory_oversubscription")

    @_builtins.property
    @pulumi.getter(name="schedulerAlgorithm")
    def scheduler_algorithm(self) -> Optional[_builtins.str]:
        """
        `(string)` - The scheduler algorithm used in the node
        pool. Possible values are `binpack` or `spread`. If not defined the global
        cluster configuration is used.
        """
        return pulumi.get(self, "scheduler_algorithm")


@pulumi.output_type
class QuoteSpecificationLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionLimit":
            suggest = "region_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuoteSpecificationLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuoteSpecificationLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuoteSpecificationLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: _builtins.str,
                 region_limit: 'outputs.QuoteSpecificationLimitRegionLimit'):
        """
        :param _builtins.str region: `(string: <required>)` - The region these limits should apply to.
        :param 'QuoteSpecificationLimitRegionLimitArgs' region_limit: `(block: <required>)` - The limits to enforce. This block
               may only be specified once in the `limits` block. Its structure is
               documented below.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "region_limit", region_limit)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        `(string: <required>)` - The region these limits should apply to.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionLimit")
    def region_limit(self) -> 'outputs.QuoteSpecificationLimitRegionLimit':
        """
        `(block: <required>)` - The limits to enforce. This block
        may only be specified once in the `limits` block. Its structure is
        documented below.
        """
        return pulumi.get(self, "region_limit")


@pulumi.output_type
class QuoteSpecificationLimitRegionLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryMb":
            suggest = "memory_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuoteSpecificationLimitRegionLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuoteSpecificationLimitRegionLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuoteSpecificationLimitRegionLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[_builtins.int] = None,
                 memory_mb: Optional[_builtins.int] = None):
        """
        :param _builtins.int cpu: `(int: 0)` - The amount of CPU to limit allocations to. A value of zero
               is treated as unlimited, and a negative value is treated as fully disallowed.
        :param _builtins.int memory_mb: `(int: 0)` - The amount of memory (in megabytes) to limit
               allocations to. A value of zero is treated as unlimited, and a negative value
               is treated as fully disallowed.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_mb is not None:
            pulumi.set(__self__, "memory_mb", memory_mb)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.int]:
        """
        `(int: 0)` - The amount of CPU to limit allocations to. A value of zero
        is treated as unlimited, and a negative value is treated as fully disallowed.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> Optional[_builtins.int]:
        """
        `(int: 0)` - The amount of memory (in megabytes) to limit
        allocations to. A value of zero is treated as unlimited, and a negative value
        is treated as fully disallowed.
        """
        return pulumi.get(self, "memory_mb")


@pulumi.output_type
class VolumeCapability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "attachmentMode":
            suggest = "attachment_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeCapability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeCapability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeCapability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
               - `single-node-reader-only`
               - `single-node-writer`
               - `multi-node-reader-only`
               - `multi-node-single-writer`
               - `multi-node-multi-writer`
        :param _builtins.str attachment_mode: `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
               - `block-device`
               - `file-system`
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - Defines whether a volume should be available concurrently. Possible values are:
        - `single-node-reader-only`
        - `single-node-writer`
        - `multi-node-reader-only`
        - `multi-node-single-writer`
        - `multi-node-multi-writer`
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string: <required>)` - The storage API that will be used by the volume. Possible values are:
        - `block-device`
        - `file-system`
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class VolumeMountOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "mountFlags":
            suggest = "mount_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 mount_flags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str fs_type: `(string: <optional>)` - The file system type.
        :param Sequence[_builtins.str] mount_flags: `([]string: <optional>)` - The flags passed to `mount`.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if mount_flags is not None:
            pulumi.set(__self__, "mount_flags", mount_flags)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        `(string: <optional>)` - The file system type.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="mountFlags")
    def mount_flags(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string: <optional>)` - The flags passed to `mount`.
        """
        return pulumi.get(self, "mount_flags")


@pulumi.output_type
class VolumeTopology(dict):
    def __init__(__self__, *,
                 segments: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] segments: `(map[string]string)` - Define the attributes for the topology request.
               
               In addition to the above arguments, the following attributes are exported and
               can be referenced:
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        `(map[string]string)` - Define the attributes for the topology request.

        In addition to the above arguments, the following attributes are exported and
        can be referenced:
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class VolumeTopologyRequest(dict):
    def __init__(__self__, *,
                 required: Optional['outputs.VolumeTopologyRequestRequired'] = None):
        """
        :param 'VolumeTopologyRequestRequiredArgs' required: `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        if required is not None:
            pulumi.set(__self__, "required", required)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional['outputs.VolumeTopologyRequestRequired']:
        """
        `(``Topology``: <optional>)` - Required topologies indicate that the volume must be created in a location accessible from all the listed topologies.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class VolumeTopologyRequestRequired(dict):
    def __init__(__self__, *,
                 topologies: Sequence['outputs.VolumeTopologyRequestRequiredTopology']):
        """
        :param Sequence['VolumeTopologyRequestRequiredTopologyArgs'] topologies: Defines the location for the volume.
        """
        pulumi.set(__self__, "topologies", topologies)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.VolumeTopologyRequestRequiredTopology']:
        """
        Defines the location for the volume.
        """
        return pulumi.get(self, "topologies")


@pulumi.output_type
class VolumeTopologyRequestRequiredTopology(dict):
    def __init__(__self__, *,
                 segments: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] segments: Define attributes for the topology request.
        """
        pulumi.set(__self__, "segments", segments)

    @_builtins.property
    @pulumi.getter
    def segments(self) -> Mapping[str, _builtins.str]:
        """
        Define attributes for the topology request.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class GetAclPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: `(string)` - the description of the ACL Policy.
        :param _builtins.str name: `(string)` - the name of the ACL Policy.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        `(string)` - the description of the ACL Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` - the name of the ACL Policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclRolePolicyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: `(string)` - Unique name of the ACL role.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` - Unique name of the ACL role.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclRolesAclRoleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 policies: Sequence['outputs.GetAclRolesAclRolePolicyResult']):
        """
        :param _builtins.str description: `(string)` - The description of the ACL Role.
        :param _builtins.str id: `(string)` - The ACL Role unique identifier.
        :param _builtins.str name: `(string)` - Unique name of the ACL role.
        :param Sequence['GetAclRolesAclRolePolicyArgs'] policies: `(set)` - The policies applied to the role.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        `(string)` - The description of the ACL Role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        `(string)` - The ACL Role unique identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` - Unique name of the ACL role.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAclRolesAclRolePolicyResult']:
        """
        `(set)` - The policies applied to the role.
        """
        return pulumi.get(self, "policies")


@pulumi.output_type
class GetAclRolesAclRolePolicyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: `(string)` - Unique name of the ACL role.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` - Unique name of the ACL role.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclTokenRoleResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of the ACL role.
        :param _builtins.str name: `(string)` Non-sensitive identifier for this token.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the ACL role.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` Non-sensitive identifier for this token.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAclTokensAclTokenResult(dict):
    def __init__(__self__, *,
                 accessor_id: _builtins.str,
                 create_time: _builtins.str,
                 expiration_time: _builtins.str,
                 global_: _builtins.bool,
                 name: _builtins.str,
                 policies: Sequence[_builtins.str],
                 roles: Sequence['outputs.GetAclTokensAclTokenRoleResult'],
                 type: _builtins.str):
        """
        :param _builtins.str accessor_id: `(TypeString)` Non-sensitive identifier for the token.
        :param _builtins.str create_time: `(string)` Date and time the token was created at.
        :param _builtins.str expiration_time: `(string)` - The timestamp after which the token is
               considered expired and eligible for destruction.
        :param _builtins.bool global_: `(bool)` Whether the token is replicated to all regions.
        :param _builtins.str name: `(TypeString)` The name of the token.
        :param Sequence[_builtins.str] policies: `(list of strings)` The list of policies attached to the token.
        :param Sequence['GetAclTokensAclTokenRoleArgs'] roles: `(set: [])` - The list of roles attached to the token. Each entry has
               `name` and `id` attributes.
        :param _builtins.str type: `(TypeString)` The type of the token.
        """
        pulumi.set(__self__, "accessor_id", accessor_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "global_", global_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policies", policies)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accessorId")
    def accessor_id(self) -> _builtins.str:
        """
        `(TypeString)` Non-sensitive identifier for the token.
        """
        return pulumi.get(self, "accessor_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        `(string)` Date and time the token was created at.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        `(string)` - The timestamp after which the token is
        considered expired and eligible for destruction.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> _builtins.bool:
        """
        `(bool)` Whether the token is replicated to all regions.
        """
        return pulumi.get(self, "global_")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(TypeString)` The name of the token.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence[_builtins.str]:
        """
        `(list of strings)` The list of policies attached to the token.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetAclTokensAclTokenRoleResult']:
        """
        `(set: [])` - The list of roles attached to the token. Each entry has
        `name` and `id` attributes.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        `(TypeString)` The type of the token.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAclTokensAclTokenRoleResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of the ACL role.
        :param _builtins.str name: `(TypeString)` The name of the token.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the ACL role.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(TypeString)` The name of the token.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAllocationsAllocationResult(dict):
    def __init__(__self__, *,
                 client_status: _builtins.str,
                 create_index: _builtins.int,
                 create_time: _builtins.int,
                 desired_status: _builtins.str,
                 eval_id: _builtins.str,
                 followup_eval_id: _builtins.str,
                 id: _builtins.str,
                 job_id: _builtins.str,
                 job_type: _builtins.str,
                 job_version: _builtins.int,
                 modify_index: _builtins.int,
                 modify_time: _builtins.int,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 next_allocation: _builtins.str,
                 node_id: _builtins.str,
                 node_name: _builtins.str,
                 preempted_by_allocation: _builtins.str,
                 task_group: _builtins.str):
        """
        :param _builtins.str client_status: `(string)` - The current client status of the allocation.
        :param _builtins.int create_index: `(int)` - The Raft index in which the allocation was created.
        :param _builtins.int create_time: `(int)` - The timestamp of when the allocation was created.
        :param _builtins.str desired_status: `(string)` - The current desired status of the allocation.
        :param _builtins.str eval_id: `(string)` - The ID of the evaluation that generated the allocation.
        :param _builtins.str followup_eval_id: `(string)` - The ID of the evaluation that succeeds the allocation evaluation.
        :param _builtins.str id: `(string)` - The ID of the allocation.
        :param _builtins.str job_id: `(string)` - The ID of the job related to the allocation.
        :param _builtins.str job_type: `(string)` - The type of the job related to the allocation.
        :param _builtins.int job_version: `(int)` - The version of the job that generated the allocation.
        :param _builtins.int modify_index: `(int)` - The Raft index in which the allocation was last modified.
        :param _builtins.int modify_time: `(int)` - The timestamp of when the allocation was last modified.
        :param _builtins.str name: `(string)` - The name of the allocation.
        :param _builtins.str namespace: `(string: <optional>)` - Specifies the namespace to search for
               allocations in.
        :param _builtins.str next_allocation: `(string)` - The ID of the allocation that succeeds the allocation.
        :param _builtins.str node_id: `(string)` - The ID of the node to which the allocation was scheduled.
        :param _builtins.str node_name: `(string)` - The ID of the node to which the allocation was scheduled.
        :param _builtins.str preempted_by_allocation: `(string)` - The ID of the allocation that preempted the allocation.
        :param _builtins.str task_group: `(string)` - The job task group related to the allocation.
        """
        pulumi.set(__self__, "client_status", client_status)
        pulumi.set(__self__, "create_index", create_index)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "desired_status", desired_status)
        pulumi.set(__self__, "eval_id", eval_id)
        pulumi.set(__self__, "followup_eval_id", followup_eval_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "job_version", job_version)
        pulumi.set(__self__, "modify_index", modify_index)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "next_allocation", next_allocation)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "preempted_by_allocation", preempted_by_allocation)
        pulumi.set(__self__, "task_group", task_group)

    @_builtins.property
    @pulumi.getter(name="clientStatus")
    def client_status(self) -> _builtins.str:
        """
        `(string)` - The current client status of the allocation.
        """
        return pulumi.get(self, "client_status")

    @_builtins.property
    @pulumi.getter(name="createIndex")
    def create_index(self) -> _builtins.int:
        """
        `(int)` - The Raft index in which the allocation was created.
        """
        return pulumi.get(self, "create_index")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        `(int)` - The timestamp of when the allocation was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> _builtins.str:
        """
        `(string)` - The current desired status of the allocation.
        """
        return pulumi.get(self, "desired_status")

    @_builtins.property
    @pulumi.getter(name="evalId")
    def eval_id(self) -> _builtins.str:
        """
        `(string)` - The ID of the evaluation that generated the allocation.
        """
        return pulumi.get(self, "eval_id")

    @_builtins.property
    @pulumi.getter(name="followupEvalId")
    def followup_eval_id(self) -> _builtins.str:
        """
        `(string)` - The ID of the evaluation that succeeds the allocation evaluation.
        """
        return pulumi.get(self, "followup_eval_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        `(string)` - The ID of the allocation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        """
        `(string)` - The ID of the job related to the allocation.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> _builtins.str:
        """
        `(string)` - The type of the job related to the allocation.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="jobVersion")
    def job_version(self) -> _builtins.int:
        """
        `(int)` - The version of the job that generated the allocation.
        """
        return pulumi.get(self, "job_version")

    @_builtins.property
    @pulumi.getter(name="modifyIndex")
    def modify_index(self) -> _builtins.int:
        """
        `(int)` - The Raft index in which the allocation was last modified.
        """
        return pulumi.get(self, "modify_index")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.int:
        """
        `(int)` - The timestamp of when the allocation was last modified.
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` - The name of the allocation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        `(string: <optional>)` - Specifies the namespace to search for
        allocations in.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nextAllocation")
    def next_allocation(self) -> _builtins.str:
        """
        `(string)` - The ID of the allocation that succeeds the allocation.
        """
        return pulumi.get(self, "next_allocation")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        `(string)` - The ID of the node to which the allocation was scheduled.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> _builtins.str:
        """
        `(string)` - The ID of the node to which the allocation was scheduled.
        """
        return pulumi.get(self, "node_name")

    @_builtins.property
    @pulumi.getter(name="preemptedByAllocation")
    def preempted_by_allocation(self) -> _builtins.str:
        """
        `(string)` - The ID of the allocation that preempted the allocation.
        """
        return pulumi.get(self, "preempted_by_allocation")

    @_builtins.property
    @pulumi.getter(name="taskGroup")
    def task_group(self) -> _builtins.str:
        """
        `(string)` - The job task group related to the allocation.
        """
        return pulumi.get(self, "task_group")


@pulumi.output_type
class GetDynamicHostVolumeCapabilityResult(dict):
    def __init__(__self__, *,
                 access_mode: _builtins.str,
                 attachment_mode: _builtins.str):
        """
        :param _builtins.str access_mode: `(string)` - How the volume can be mounted by
               allocations. Refer to the [`access_mode`][] documentation for details.
        :param _builtins.str attachment_mode: `(string)` - The storage API that will be used by the
               volume. Refer to the [`attachment_mode`][] documentation.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "attachment_mode", attachment_mode)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> _builtins.str:
        """
        `(string)` - How the volume can be mounted by
        allocations. Refer to the [`access_mode`][] documentation for details.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="attachmentMode")
    def attachment_mode(self) -> _builtins.str:
        """
        `(string)` - The storage API that will be used by the
        volume. Refer to the [`attachment_mode`][] documentation.
        """
        return pulumi.get(self, "attachment_mode")


@pulumi.output_type
class GetDynamicHostVolumeConstraintResult(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 operator: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str attribute: `(string)` - The [node attribute][] to check for the constraint.
        :param _builtins.str operator: `(string)`- The operator to use in the comparison.
        :param _builtins.str value: `(string)` - The value of the attribute to compare against.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        `(string)` - The [node attribute][] to check for the constraint.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        `(string)`- The operator to use in the comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        `(string)` - The value of the attribute to compare against.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetJobConstraintResult(dict):
    def __init__(__self__, *,
                 ltarget: _builtins.str,
                 operand: _builtins.str,
                 rtarget: _builtins.str):
        """
        :param _builtins.str ltarget: `(string)` Attribute being constrained.
        :param _builtins.str operand: `(string)` Operator used to compare the attribute to the constraint.
        :param _builtins.str rtarget: `(string)` Constraint value.
        """
        pulumi.set(__self__, "ltarget", ltarget)
        pulumi.set(__self__, "operand", operand)
        pulumi.set(__self__, "rtarget", rtarget)

    @_builtins.property
    @pulumi.getter
    def ltarget(self) -> _builtins.str:
        """
        `(string)` Attribute being constrained.
        """
        return pulumi.get(self, "ltarget")

    @_builtins.property
    @pulumi.getter
    def operand(self) -> _builtins.str:
        """
        `(string)` Operator used to compare the attribute to the constraint.
        """
        return pulumi.get(self, "operand")

    @_builtins.property
    @pulumi.getter
    def rtarget(self) -> _builtins.str:
        """
        `(string)` Constraint value.
        """
        return pulumi.get(self, "rtarget")


@pulumi.output_type
class GetJobPeriodicConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 prohibit_overlap: _builtins.bool,
                 spec: _builtins.str,
                 spec_type: _builtins.str,
                 timezone: _builtins.str):
        """
        :param _builtins.bool enabled: `(boolean)` If periodic scheduling is enabled for the specified job.
        :param _builtins.bool prohibit_overlap: `(boolean)`  If the specified job should wait until previous instances of the job have completed.
        :param _builtins.str spec: `(string)`
        :param _builtins.str spec_type: `(string)`
        :param _builtins.str timezone: `(string)` Time zone to evaluate the next launch interval against.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prohibit_overlap", prohibit_overlap)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "spec_type", spec_type)
        pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        `(boolean)` If periodic scheduling is enabled for the specified job.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="prohibitOverlap")
    def prohibit_overlap(self) -> _builtins.bool:
        """
        `(boolean)`  If the specified job should wait until previous instances of the job have completed.
        """
        return pulumi.get(self, "prohibit_overlap")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        `(string)`
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> _builtins.str:
        """
        `(string)`
        """
        return pulumi.get(self, "spec_type")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        `(string)` Time zone to evaluate the next launch interval against.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetJobTaskGroupResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 meta: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 tasks: Sequence['outputs.GetJobTaskGroupTaskResult'],
                 volumes: Sequence['outputs.GetJobTaskGroupVolumeResult']):
        """
        :param _builtins.str name: `(string)` Name of the job.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` Name of the job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetJobTaskGroupTaskResult']:
        return pulumi.get(self, "tasks")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetJobTaskGroupVolumeResult']:
        return pulumi.get(self, "volumes")


@pulumi.output_type
class GetJobTaskGroupTaskResult(dict):
    def __init__(__self__, *,
                 driver: _builtins.str,
                 meta: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 volume_mounts: Sequence['outputs.GetJobTaskGroupTaskVolumeMountResult']):
        """
        :param _builtins.str name: `(string)` Name of the job.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` Name of the job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetJobTaskGroupTaskVolumeMountResult']:
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GetJobTaskGroupTaskVolumeMountResult(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 read_only: _builtins.bool,
                 volume: _builtins.str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "volume", volume)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def volume(self) -> _builtins.str:
        return pulumi.get(self, "volume")


@pulumi.output_type
class GetJobTaskGroupVolumeResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 read_only: _builtins.bool,
                 source: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: `(string)` Name of the job.
        :param _builtins.str type: `(string)` Scheduler type used during job creation.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` Name of the job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        `(string)` Scheduler type used during job creation.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJwksKeyResult(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 exponent: _builtins.str,
                 key_id: _builtins.str,
                 key_type: _builtins.str,
                 key_use: _builtins.str,
                 modulus: _builtins.str):
        """
        :param _builtins.str algorithm: `(string)` - JWK field `alg`
        :param _builtins.str exponent: `(string)` - JWK field `e`
        :param _builtins.str key_id: `(string)` - JWK field `kid`
        :param _builtins.str key_type: `(string)` - JWK field `kty`
        :param _builtins.str key_use: `(string)` - JWK field `use`
        :param _builtins.str modulus: `(string)` - JWK field `n`
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "key_use", key_use)
        pulumi.set(__self__, "modulus", modulus)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        `(string)` - JWK field `alg`
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def exponent(self) -> _builtins.str:
        """
        `(string)` - JWK field `e`
        """
        return pulumi.get(self, "exponent")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        `(string)` - JWK field `kid`
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> _builtins.str:
        """
        `(string)` - JWK field `kty`
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="keyUse")
    def key_use(self) -> _builtins.str:
        """
        `(string)` - JWK field `use`
        """
        return pulumi.get(self, "key_use")

    @_builtins.property
    @pulumi.getter
    def modulus(self) -> _builtins.str:
        """
        `(string)` - JWK field `n`
        """
        return pulumi.get(self, "modulus")


@pulumi.output_type
class GetNamespaceCapabilityResult(dict):
    def __init__(__self__, *,
                 disabled_network_modes: Optional[Sequence[_builtins.str]] = None,
                 disabled_task_drivers: Optional[Sequence[_builtins.str]] = None,
                 enabled_network_modes: Optional[Sequence[_builtins.str]] = None,
                 enabled_task_drivers: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] disabled_network_modes: `([]string)` - Network modes disabled for the namespace.
        :param Sequence[_builtins.str] disabled_task_drivers: `([]string)` - Task drivers disabled for the namespace.
        :param Sequence[_builtins.str] enabled_network_modes: `([]string)` - Network modes enabled for the namespace.
        :param Sequence[_builtins.str] enabled_task_drivers: `([]string)` - Task drivers enabled for the namespace.
        """
        if disabled_network_modes is not None:
            pulumi.set(__self__, "disabled_network_modes", disabled_network_modes)
        if disabled_task_drivers is not None:
            pulumi.set(__self__, "disabled_task_drivers", disabled_task_drivers)
        if enabled_network_modes is not None:
            pulumi.set(__self__, "enabled_network_modes", enabled_network_modes)
        if enabled_task_drivers is not None:
            pulumi.set(__self__, "enabled_task_drivers", enabled_task_drivers)

    @_builtins.property
    @pulumi.getter(name="disabledNetworkModes")
    def disabled_network_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string)` - Network modes disabled for the namespace.
        """
        return pulumi.get(self, "disabled_network_modes")

    @_builtins.property
    @pulumi.getter(name="disabledTaskDrivers")
    def disabled_task_drivers(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string)` - Task drivers disabled for the namespace.
        """
        return pulumi.get(self, "disabled_task_drivers")

    @_builtins.property
    @pulumi.getter(name="enabledNetworkModes")
    def enabled_network_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string)` - Network modes enabled for the namespace.
        """
        return pulumi.get(self, "enabled_network_modes")

    @_builtins.property
    @pulumi.getter(name="enabledTaskDrivers")
    def enabled_task_drivers(self) -> Optional[Sequence[_builtins.str]]:
        """
        `([]string)` - Task drivers enabled for the namespace.
        """
        return pulumi.get(self, "enabled_task_drivers")


@pulumi.output_type
class GetNamespaceNodePoolConfigResult(dict):
    def __init__(__self__, *,
                 alloweds: Sequence[_builtins.str],
                 default: _builtins.str,
                 denieds: Sequence[_builtins.str]):
        pulumi.set(__self__, "alloweds", alloweds)
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "denieds", denieds)

    @_builtins.property
    @pulumi.getter
    def alloweds(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "alloweds")

    @_builtins.property
    @pulumi.getter
    def default(self) -> _builtins.str:
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def denieds(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "denieds")


@pulumi.output_type
class GetNodePoolSchedulerConfigResult(dict):
    def __init__(__self__, *,
                 memory_oversubscription: _builtins.str,
                 scheduler_algorithm: _builtins.str):
        """
        :param _builtins.str memory_oversubscription: `(string)` - Whether or not memory
               oversubscription is enabled in the node pool. If empty or not defined the
               global cluster configuration is used.
        :param _builtins.str scheduler_algorithm: `(string)` - The scheduler algorithm used in the node
               pool. If empty or not defined the global cluster configuration is used.
        """
        pulumi.set(__self__, "memory_oversubscription", memory_oversubscription)
        pulumi.set(__self__, "scheduler_algorithm", scheduler_algorithm)

    @_builtins.property
    @pulumi.getter(name="memoryOversubscription")
    def memory_oversubscription(self) -> _builtins.str:
        """
        `(string)` - Whether or not memory
        oversubscription is enabled in the node pool. If empty or not defined the
        global cluster configuration is used.
        """
        return pulumi.get(self, "memory_oversubscription")

    @_builtins.property
    @pulumi.getter(name="schedulerAlgorithm")
    def scheduler_algorithm(self) -> _builtins.str:
        """
        `(string)` - The scheduler algorithm used in the node
        pool. If empty or not defined the global cluster configuration is used.
        """
        return pulumi.get(self, "scheduler_algorithm")


@pulumi.output_type
class GetNodePoolsNodePoolResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 meta: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 scheduler_configs: Sequence['outputs.GetNodePoolsNodePoolSchedulerConfigResult']):
        """
        :param _builtins.str description: `(string)` - The description of the node pool.
        :param Mapping[str, _builtins.str] meta: `(map[string]string)` - Arbitrary KV metadata associated with the
               node pool.
        :param _builtins.str name: `(string)` - The name of the node pool.
        :param Sequence['GetNodePoolsNodePoolSchedulerConfigArgs'] scheduler_configs: `(block)` - Scheduler configuration for the node pool.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "meta", meta)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scheduler_configs", scheduler_configs)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        `(string)` - The description of the node pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Mapping[str, _builtins.str]:
        """
        `(map[string]string)` - Arbitrary KV metadata associated with the
        node pool.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        `(string)` - The name of the node pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="schedulerConfigs")
    def scheduler_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolSchedulerConfigResult']:
        """
        `(block)` - Scheduler configuration for the node pool.
        """
        return pulumi.get(self, "scheduler_configs")


@pulumi.output_type
class GetNodePoolsNodePoolSchedulerConfigResult(dict):
    def __init__(__self__, *,
                 memory_oversubscription: _builtins.str,
                 scheduler_algorithm: _builtins.str):
        """
        :param _builtins.str memory_oversubscription: `(string)` - Whether or not memory
               oversubscription is enabled in the node pool. If empty or not defined the
               global cluster configuration is used.
        :param _builtins.str scheduler_algorithm: `(string)` - The scheduler algorithm used in the node
               pool. If empty or not defined the global cluster configuration is used.
        """
        pulumi.set(__self__, "memory_oversubscription", memory_oversubscription)
        pulumi.set(__self__, "scheduler_algorithm", scheduler_algorithm)

    @_builtins.property
    @pulumi.getter(name="memoryOversubscription")
    def memory_oversubscription(self) -> _builtins.str:
        """
        `(string)` - Whether or not memory
        oversubscription is enabled in the node pool. If empty or not defined the
        global cluster configuration is used.
        """
        return pulumi.get(self, "memory_oversubscription")

    @_builtins.property
    @pulumi.getter(name="schedulerAlgorithm")
    def scheduler_algorithm(self) -> _builtins.str:
        """
        `(string)` - The scheduler algorithm used in the node
        pool. If empty or not defined the global cluster configuration is used.
        """
        return pulumi.get(self, "scheduler_algorithm")


@pulumi.output_type
class GetPluginNodeResult(dict):
    def __init__(__self__, *,
                 healthy: _builtins.bool,
                 healthy_description: _builtins.str,
                 name: _builtins.str):
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "healthy_description", healthy_description)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def healthy(self) -> _builtins.bool:
        return pulumi.get(self, "healthy")

    @_builtins.property
    @pulumi.getter(name="healthyDescription")
    def healthy_description(self) -> _builtins.str:
        return pulumi.get(self, "healthy_description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetScalingPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 id: _builtins.str,
                 target: Mapping[str, _builtins.str],
                 type: _builtins.str):
        """
        :param _builtins.bool enabled: `(boolean)` - Whether or not the scaling policy is enabled.
        :param _builtins.str id: `(string)` - The scaling policy ID.
        :param Mapping[str, _builtins.str] target: `(map[string]string)` - The scaling policy target.
        :param _builtins.str type: `(string)` - An optional string to filter scaling policies based on policy type. If not provided, policies of all types are returned.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        `(boolean)` - Whether or not the scaling policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        `(string)` - The scaling policy ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Mapping[str, _builtins.str]:
        """
        `(map[string]string)` - The scaling policy target.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        `(string)` - An optional string to filter scaling policies based on policy type. If not provided, policies of all types are returned.
        """
        return pulumi.get(self, "type")


