# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_jwt: Optional[pulumi.Input['ProviderAuthJwtArgs']] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]] = None,
                 http_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_env_vars: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_verify: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] address: URL of the root of the target Nomad agent.
        :param pulumi.Input['ProviderAuthJwtArgs'] auth_jwt: Authenticates to Nomad using a JWT authentication method.
        :param pulumi.Input[_builtins.str] ca_file: A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[_builtins.str] ca_pem: PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[_builtins.str] cert_file: A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[_builtins.str] cert_pem: PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]] headers: The headers to send with each Nomad request.
        :param pulumi.Input[_builtins.str] http_auth: HTTP basic auth configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] ignore_env_vars: A set of environment variables that are ignored by the provider when configuring the Nomad API client.
        :param pulumi.Input[_builtins.str] key_file: A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[_builtins.str] key_pem: PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[_builtins.str] region: Region of the target Nomad agent.
        :param pulumi.Input[_builtins.str] secret_id: ACL token secret for API requests.
        :param pulumi.Input[_builtins.bool] skip_verify: Skip TLS verification on client side.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auth_jwt is not None:
            pulumi.set(__self__, "auth_jwt", auth_jwt)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if ca_pem is not None:
            pulumi.set(__self__, "ca_pem", ca_pem)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if cert_pem is not None:
            pulumi.set(__self__, "cert_pem", cert_pem)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_auth is not None:
            pulumi.set(__self__, "http_auth", http_auth)
        if ignore_env_vars is not None:
            pulumi.set(__self__, "ignore_env_vars", ignore_env_vars)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if key_pem is not None:
            pulumi.set(__self__, "key_pem", key_pem)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if skip_verify is not None:
            pulumi.set(__self__, "skip_verify", skip_verify)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the root of the target Nomad agent.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="authJwt")
    def auth_jwt(self) -> Optional[pulumi.Input['ProviderAuthJwtArgs']]:
        """
        Authenticates to Nomad using a JWT authentication method.
        """
        return pulumi.get(self, "auth_jwt")

    @auth_jwt.setter
    def auth_jwt(self, value: Optional[pulumi.Input['ProviderAuthJwtArgs']]):
        pulumi.set(self, "auth_jwt", value)

    @_builtins.property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_file", value)

    @_builtins.property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_pem")

    @ca_pem.setter
    def ca_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_pem", value)

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_file")

    @cert_file.setter
    def cert_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_file", value)

    @_builtins.property
    @pulumi.getter(name="certPem")
    def cert_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_pem")

    @cert_pem.setter
    def cert_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_pem", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]:
        """
        The headers to send with each Nomad request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="httpAuth")
    def http_auth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP basic auth configuration.
        """
        return pulumi.get(self, "http_auth")

    @http_auth.setter
    def http_auth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_auth", value)

    @_builtins.property
    @pulumi.getter(name="ignoreEnvVars")
    def ignore_env_vars(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]:
        """
        A set of environment variables that are ignored by the provider when configuring the Nomad API client.
        """
        return pulumi.get(self, "ignore_env_vars")

    @ignore_env_vars.setter
    def ignore_env_vars(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]]):
        pulumi.set(self, "ignore_env_vars", value)

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_file", value)

    @_builtins.property
    @pulumi.getter(name="keyPem")
    def key_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_pem")

    @key_pem.setter
    def key_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pem", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the target Nomad agent.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ACL token secret for API requests.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter(name="skipVerify")
    def skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip TLS verification on client side.
        """
        return pulumi.get(self, "skip_verify")

    @skip_verify.setter
    def skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_verify", value)


@pulumi.type_token("pulumi:providers:nomad")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_jwt: Optional[pulumi.Input[Union['ProviderAuthJwtArgs', 'ProviderAuthJwtArgsDict']]] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderHeaderArgs', 'ProviderHeaderArgsDict']]]]] = None,
                 http_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_env_vars: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the nomad package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: URL of the root of the target Nomad agent.
        :param pulumi.Input[Union['ProviderAuthJwtArgs', 'ProviderAuthJwtArgsDict']] auth_jwt: Authenticates to Nomad using a JWT authentication method.
        :param pulumi.Input[_builtins.str] ca_file: A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[_builtins.str] ca_pem: PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[_builtins.str] cert_file: A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[_builtins.str] cert_pem: PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProviderHeaderArgs', 'ProviderHeaderArgsDict']]]] headers: The headers to send with each Nomad request.
        :param pulumi.Input[_builtins.str] http_auth: HTTP basic auth configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]] ignore_env_vars: A set of environment variables that are ignored by the provider when configuring the Nomad API client.
        :param pulumi.Input[_builtins.str] key_file: A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[_builtins.str] key_pem: PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[_builtins.str] region: Region of the target Nomad agent.
        :param pulumi.Input[_builtins.str] secret_id: ACL token secret for API requests.
        :param pulumi.Input[_builtins.bool] skip_verify: Skip TLS verification on client side.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the nomad package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_jwt: Optional[pulumi.Input[Union['ProviderAuthJwtArgs', 'ProviderAuthJwtArgsDict']]] = None,
                 ca_file: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_file: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderHeaderArgs', 'ProviderHeaderArgsDict']]]]] = None,
                 http_auth: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_env_vars: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.bool]]]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["auth_jwt"] = pulumi.Output.from_input(auth_jwt).apply(pulumi.runtime.to_json) if auth_jwt is not None else None
            __props__.__dict__["ca_file"] = ca_file
            __props__.__dict__["ca_pem"] = ca_pem
            __props__.__dict__["cert_file"] = cert_file
            __props__.__dict__["cert_pem"] = cert_pem
            __props__.__dict__["headers"] = pulumi.Output.secret(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            __props__.__dict__["http_auth"] = http_auth
            __props__.__dict__["ignore_env_vars"] = pulumi.Output.from_input(ignore_env_vars).apply(pulumi.runtime.to_json) if ignore_env_vars is not None else None
            __props__.__dict__["key_file"] = key_file
            __props__.__dict__["key_pem"] = key_pem
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["skip_verify"] = pulumi.Output.from_input(skip_verify).apply(pulumi.runtime.to_json) if skip_verify is not None else None
        super(Provider, __self__).__init__(
            'nomad',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of the root of the target Nomad agent.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_file")

    @_builtins.property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_pem")

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_file")

    @_builtins.property
    @pulumi.getter(name="certPem")
    def cert_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_pem")

    @_builtins.property
    @pulumi.getter(name="httpAuth")
    def http_auth(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        HTTP basic auth configuration.
        """
        return pulumi.get(self, "http_auth")

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_file")

    @_builtins.property
    @pulumi.getter(name="keyPem")
    def key_pem(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_pem")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Region of the target Nomad agent.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ACL token secret for API requests.
        """
        return pulumi.get(self, "secret_id")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:nomad/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

