from decimal import Decimal
from time import time
from threading import Timer

def throttle(wait):
    """ Decorator that prevents a function from being called
        more than once every wait period. """
    def decorator(fn):
        time_of_last_call = 0
        scheduled, timer = False, None
        new_args, new_kwargs = None, None
        def throttled(*args, **kwargs):
            nonlocal new_args, new_kwargs, time_of_last_call, scheduled, timer
            def call_it():
                nonlocal new_args, new_kwargs, time_of_last_call, scheduled, timer
                time_of_last_call = time()
                fn(*new_args, **new_kwargs)
                scheduled = False
            time_since_last_call = time() - time_of_last_call
            new_args, new_kwargs = args, kwargs
            if not scheduled:
                scheduled = True
                new_wait = max(0, wait - time_since_last_call)
                timer = Timer(new_wait, call_it)
                timer.start()
        return throttled
    return decorator

#=====================================================================
def count_decimal_places(value: float) -> int:
    # Convert via string to preserve user input formatting
    d = Decimal(str(value)).normalize()
    # Negative exponent means decimal places
    return abs(d.as_tuple().exponent)

#=====================================================================
def can_convert(value, target_type):
    try:
        target_type(value)
        return True
    except (ValueError, TypeError):
        return False