# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.job import Job
from .raw_client import AsyncRawJobsClient, RawJobsClient


class JobsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJobsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        source_id: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        ascending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Job]:
        """
        List all jobs.
        TODO (cliandy): implementation for pagination

        Parameters
        ----------
        source_id : typing.Optional[str]
            Only list jobs associated with the source.

        before : typing.Optional[str]
            Cursor for pagination

        after : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Limit for pagination

        ascending : typing.Optional[bool]
            Whether to sort jobs oldest to newest (True, default) or newest to oldest (False)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Job]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.jobs.list()
        """
        _response = self._raw_client.list(
            source_id=source_id,
            before=before,
            after=after,
            limit=limit,
            ascending=ascending,
            request_options=request_options,
        )
        return _response.data

    def list_active(
        self,
        *,
        source_id: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        ascending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Job]:
        """
        List all active jobs.

        Parameters
        ----------
        source_id : typing.Optional[str]
            Only list jobs associated with the source.

        before : typing.Optional[str]
            Cursor for pagination

        after : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Limit for pagination

        ascending : typing.Optional[bool]
            Whether to sort jobs oldest to newest (True, default) or newest to oldest (False)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Job]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.jobs.list_active()
        """
        _response = self._raw_client.list_active(
            source_id=source_id,
            before=before,
            after=after,
            limit=limit,
            ascending=ascending,
            request_options=request_options,
        )
        return _response.data

    def retrieve(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Job:
        """
        Get the status of a job.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Job
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.jobs.retrieve(
            job_id="job_id",
        )
        """
        _response = self._raw_client.retrieve(job_id, request_options=request_options)
        return _response.data

    def delete(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Job:
        """
        Delete a job by its job_id.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Job
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.jobs.delete(
            job_id="job_id",
        )
        """
        _response = self._raw_client.delete(job_id, request_options=request_options)
        return _response.data

    def cancel_job(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Job:
        """
        Cancel a job by its job_id.

        This endpoint marks a job as cancelled, which will cause any associated
        agent execution to terminate as soon as possible.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Job
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.jobs.cancel_job(
            job_id="job_id",
        )
        """
        _response = self._raw_client.cancel_job(job_id, request_options=request_options)
        return _response.data


class AsyncJobsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJobsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        source_id: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        ascending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Job]:
        """
        List all jobs.
        TODO (cliandy): implementation for pagination

        Parameters
        ----------
        source_id : typing.Optional[str]
            Only list jobs associated with the source.

        before : typing.Optional[str]
            Cursor for pagination

        after : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Limit for pagination

        ascending : typing.Optional[bool]
            Whether to sort jobs oldest to newest (True, default) or newest to oldest (False)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Job]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            source_id=source_id,
            before=before,
            after=after,
            limit=limit,
            ascending=ascending,
            request_options=request_options,
        )
        return _response.data

    async def list_active(
        self,
        *,
        source_id: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        ascending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Job]:
        """
        List all active jobs.

        Parameters
        ----------
        source_id : typing.Optional[str]
            Only list jobs associated with the source.

        before : typing.Optional[str]
            Cursor for pagination

        after : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Limit for pagination

        ascending : typing.Optional[bool]
            Whether to sort jobs oldest to newest (True, default) or newest to oldest (False)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Job]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.list_active()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_active(
            source_id=source_id,
            before=before,
            after=after,
            limit=limit,
            ascending=ascending,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Job:
        """
        Get the status of a job.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Job
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.retrieve(
                job_id="job_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(job_id, request_options=request_options)
        return _response.data

    async def delete(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Job:
        """
        Delete a job by its job_id.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Job
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.delete(
                job_id="job_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(job_id, request_options=request_options)
        return _response.data

    async def cancel_job(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Job:
        """
        Cancel a job by its job_id.

        This endpoint marks a job as cancelled, which will cause any associated
        agent execution to terminate as soon as possible.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Job
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.jobs.cancel_job(
                job_id="job_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_job(job_id, request_options=request_options)
        return _response.data
