# This file was auto-generated by Fern from our API Definition.

import typing

from ... import core
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.duplicate_file_handling import DuplicateFileHandling
from ...types.file_metadata import FileMetadata
from .raw_client import AsyncRawFilesClient, RawFilesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFilesClient
        """
        return self._raw_client

    def upload(
        self,
        source_id: str,
        *,
        file: core.File,
        duplicate_handling: typing.Optional[DuplicateFileHandling] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileMetadata:
        """
        Upload a file to a data source.

        Parameters
        ----------
        source_id : str

        file : core.File
            See core.File for more documentation

        duplicate_handling : typing.Optional[DuplicateFileHandling]
            How to handle duplicate filenames

        name : typing.Optional[str]
            Optional custom name to override the uploaded file's name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileMetadata
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.sources.files.upload(
            source_id="source_id",
        )
        """
        _response = self._raw_client.upload(
            source_id, file=file, duplicate_handling=duplicate_handling, name=name, request_options=request_options
        )
        return _response.data

    def list(
        self,
        source_id: str,
        *,
        limit: typing.Optional[int] = None,
        after: typing.Optional[str] = None,
        include_content: typing.Optional[bool] = None,
        check_status_updates: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[FileMetadata]:
        """
        List paginated files associated with a data source.

        Parameters
        ----------
        source_id : str

        limit : typing.Optional[int]
            Number of files to return

        after : typing.Optional[str]
            Pagination cursor to fetch the next set of results

        include_content : typing.Optional[bool]
            Whether to include full file content

        check_status_updates : typing.Optional[bool]
            Whether to check and update file processing status (from the vector db service). If False, will not fetch and update the status, which may lead to performance gains.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[FileMetadata]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.sources.files.list(
            source_id="source_id",
        )
        """
        _response = self._raw_client.list(
            source_id,
            limit=limit,
            after=after,
            include_content=include_content,
            check_status_updates=check_status_updates,
            request_options=request_options,
        )
        return _response.data

    def delete(self, source_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a data source.

        Parameters
        ----------
        source_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.sources.files.delete(
            source_id="source_id",
            file_id="file_id",
        )
        """
        _response = self._raw_client.delete(source_id, file_id, request_options=request_options)
        return _response.data


class AsyncFilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFilesClient
        """
        return self._raw_client

    async def upload(
        self,
        source_id: str,
        *,
        file: core.File,
        duplicate_handling: typing.Optional[DuplicateFileHandling] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileMetadata:
        """
        Upload a file to a data source.

        Parameters
        ----------
        source_id : str

        file : core.File
            See core.File for more documentation

        duplicate_handling : typing.Optional[DuplicateFileHandling]
            How to handle duplicate filenames

        name : typing.Optional[str]
            Optional custom name to override the uploaded file's name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileMetadata
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sources.files.upload(
                source_id="source_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upload(
            source_id, file=file, duplicate_handling=duplicate_handling, name=name, request_options=request_options
        )
        return _response.data

    async def list(
        self,
        source_id: str,
        *,
        limit: typing.Optional[int] = None,
        after: typing.Optional[str] = None,
        include_content: typing.Optional[bool] = None,
        check_status_updates: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[FileMetadata]:
        """
        List paginated files associated with a data source.

        Parameters
        ----------
        source_id : str

        limit : typing.Optional[int]
            Number of files to return

        after : typing.Optional[str]
            Pagination cursor to fetch the next set of results

        include_content : typing.Optional[bool]
            Whether to include full file content

        check_status_updates : typing.Optional[bool]
            Whether to check and update file processing status (from the vector db service). If False, will not fetch and update the status, which may lead to performance gains.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[FileMetadata]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sources.files.list(
                source_id="source_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            source_id,
            limit=limit,
            after=after,
            include_content=include_content,
            check_status_updates=check_status_updates,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, source_id: str, file_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a data source.

        Parameters
        ----------
        source_id : str

        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sources.files.delete(
                source_id="source_id",
                file_id="file_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(source_id, file_id, request_options=request_options)
        return _response.data
