# This file was auto-generated by Fern from our API Definition.

import contextlib
import json
import typing
from json.decoder import JSONDecodeError

import httpx_sse
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.action_model import ActionModel
from ..types.app_model import AppModel
from ..types.http_validation_error import HttpValidationError
from ..types.mcp_tool import McpTool
from ..types.npm_requirement import NpmRequirement
from ..types.pip_requirement import PipRequirement
from ..types.tool import Tool
from ..types.tool_return_message import ToolReturnMessage
from .types.add_mcp_server_request import AddMcpServerRequest
from .types.add_mcp_server_response_item import AddMcpServerResponseItem
from .types.connect_mcp_server_request import ConnectMcpServerRequest
from .types.delete_mcp_server_response_item import DeleteMcpServerResponseItem
from .types.list_mcp_servers_response_value import ListMcpServersResponseValue
from .types.streaming_response import StreamingResponse
from .types.test_mcp_server_request import TestMcpServerRequest
from .types.update_mcp_server_request import UpdateMcpServerRequest
from .types.update_mcp_server_response import UpdateMcpServerResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def retrieve(self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Tool]:
        """
        Get a tool by ID

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Tool]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/{jsonable_encoder(tool_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Delete a tool by name

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/{jsonable_encoder(tool_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    construct_type(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def modify(
        self,
        tool_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        source_code: typing.Optional[str] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        return_char_limit: typing.Optional[int] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Tool]:
        """
        Update an existing tool

        Parameters
        ----------
        tool_id : str

        description : typing.Optional[str]
            The description of the tool.

        tags : typing.Optional[typing.Sequence[str]]
            Metadata tags.

        source_code : typing.Optional[str]
            The source code of the function.

        source_type : typing.Optional[str]
            The type of the source code.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        return_char_limit : typing.Optional[int]
            The maximum number of characters in the response.

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A dictionary of additional metadata for the tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Tool]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/{jsonable_encoder(tool_id)}",
            method="PATCH",
            json={
                "description": description,
                "tags": tags,
                "source_code": source_code,
                "source_type": source_type,
                "json_schema": json_schema,
                "args_json_schema": args_json_schema,
                "return_char_limit": return_char_limit,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
                "metadata_": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def count(
        self,
        *,
        include_base_tools: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[int]:
        """
        Get a count of all tools available to agents belonging to the org of the user.

        Parameters
        ----------
        include_base_tools : typing.Optional[bool]
            Include built-in Letta tools in the count

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[int]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/count",
            method="GET",
            params={
                "include_base_tools": include_base_tools,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    int,
                    construct_type(
                        type_=int,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list(
        self,
        *,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[Tool]]:
        """
        Get a list of all tools available to agents belonging to the org of the user

        Parameters
        ----------
        after : typing.Optional[str]

        limit : typing.Optional[int]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Tool]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/",
            method="GET",
            params={
                "after": after,
                "limit": limit,
                "name": name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Tool],
                    construct_type(
                        type_=typing.List[Tool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        source_code: str,
        description: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        return_char_limit: typing.Optional[int] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Tool]:
        """
        Create a new tool

        Parameters
        ----------
        source_code : str
            The source code of the function.

        description : typing.Optional[str]
            The description of the tool.

        tags : typing.Optional[typing.Sequence[str]]
            Metadata tags.

        source_type : typing.Optional[str]
            The source type of the function.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        return_char_limit : typing.Optional[int]
            The maximum number of characters in the response.

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Tool]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/",
            method="POST",
            json={
                "description": description,
                "tags": tags,
                "source_code": source_code,
                "source_type": source_type,
                "json_schema": json_schema,
                "args_json_schema": args_json_schema,
                "return_char_limit": return_char_limit,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert(
        self,
        *,
        source_code: str,
        description: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        return_char_limit: typing.Optional[int] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Tool]:
        """
        Create or update a tool

        Parameters
        ----------
        source_code : str
            The source code of the function.

        description : typing.Optional[str]
            The description of the tool.

        tags : typing.Optional[typing.Sequence[str]]
            Metadata tags.

        source_type : typing.Optional[str]
            The source type of the function.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        return_char_limit : typing.Optional[int]
            The maximum number of characters in the response.

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Tool]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/",
            method="PUT",
            json={
                "description": description,
                "tags": tags,
                "source_code": source_code,
                "source_type": source_type,
                "json_schema": json_schema,
                "args_json_schema": args_json_schema,
                "return_char_limit": return_char_limit,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upsert_base_tools(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[Tool]]:
        """
        Upsert base tools

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Tool]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/add-base-tools",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Tool],
                    construct_type(
                        type_=typing.List[Tool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def run_tool_from_source(
        self,
        *,
        source_code: str,
        args: typing.Dict[str, typing.Optional[typing.Any]],
        env_vars: typing.Optional[typing.Dict[str, str]] = OMIT,
        name: typing.Optional[str] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ToolReturnMessage]:
        """
        Attempt to build a tool from source, then run it on the provided arguments

        Parameters
        ----------
        source_code : str
            The source code of the function.

        args : typing.Dict[str, typing.Optional[typing.Any]]
            The arguments to pass to the tool.

        env_vars : typing.Optional[typing.Dict[str, str]]
            The environment variables to pass to the tool.

        name : typing.Optional[str]
            The name of the tool to run.

        source_type : typing.Optional[str]
            The type of the source code.

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ToolReturnMessage]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/run",
            method="POST",
            json={
                "source_code": source_code,
                "args": args,
                "env_vars": env_vars,
                "name": name,
                "source_type": source_type,
                "args_json_schema": args_json_schema,
                "json_schema": json_schema,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolReturnMessage,
                    construct_type(
                        type_=ToolReturnMessage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_composio_apps(
        self, *, user_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[AppModel]]:
        """
        Get a list of all Composio apps

        Parameters
        ----------
        user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[AppModel]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/composio/apps",
            method="GET",
            headers={
                "user-id": str(user_id) if user_id is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[AppModel],
                    construct_type(
                        type_=typing.List[AppModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_composio_actions_by_app(
        self, composio_app_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ActionModel]]:
        """
        Get a list of all Composio actions for a specific app

        Parameters
        ----------
        composio_app_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ActionModel]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/composio/apps/{jsonable_encoder(composio_app_name)}/actions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ActionModel],
                    construct_type(
                        type_=typing.List[ActionModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_composio_tool(
        self, composio_action_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Tool]:
        """
        Add a new Composio tool by action name (Composio refers to each tool as an `Action`)

        Parameters
        ----------
        composio_action_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Tool]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/composio/{jsonable_encoder(composio_action_name)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_mcp_servers(
        self, *, user_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Dict[str, ListMcpServersResponseValue]]:
        """
        Get a list of all configured MCP servers

        Parameters
        ----------
        user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Dict[str, ListMcpServersResponseValue]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/mcp/servers",
            method="GET",
            headers={
                "user-id": str(user_id) if user_id is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, ListMcpServersResponseValue],
                    construct_type(
                        type_=typing.Dict[str, ListMcpServersResponseValue],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_mcp_server(
        self, *, request: AddMcpServerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[AddMcpServerResponseItem]]:
        """
        Add a new MCP server to the Letta MCP server config

        Parameters
        ----------
        request : AddMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[AddMcpServerResponseItem]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/mcp/servers",
            method="PUT",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=AddMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[AddMcpServerResponseItem],
                    construct_type(
                        type_=typing.List[AddMcpServerResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_mcp_tools_by_server(
        self, mcp_server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[McpTool]]:
        """
        Get a list of all tools for a specific MCP server

        Parameters
        ----------
        mcp_server_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[McpTool]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}/tools",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[McpTool],
                    construct_type(
                        type_=typing.List[McpTool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_mcp_tool(
        self, mcp_server_name: str, mcp_tool_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Tool]:
        """
        Register a new MCP tool as a Letta server by MCP server + tool name

        Parameters
        ----------
        mcp_server_name : str

        mcp_tool_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Tool]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}/{jsonable_encoder(mcp_tool_name)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_mcp_server(
        self, mcp_server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[DeleteMcpServerResponseItem]]:
        """
        Delete a MCP server configuration

        Parameters
        ----------
        mcp_server_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[DeleteMcpServerResponseItem]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[DeleteMcpServerResponseItem],
                    construct_type(
                        type_=typing.List[DeleteMcpServerResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_mcp_server(
        self,
        mcp_server_name: str,
        *,
        request: UpdateMcpServerRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateMcpServerResponse]:
        """
        Update an existing MCP server configuration

        Parameters
        ----------
        mcp_server_name : str

        request : UpdateMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateMcpServerResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}",
            method="PATCH",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=UpdateMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateMcpServerResponse,
                    construct_type(
                        type_=UpdateMcpServerResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def test_mcp_server(
        self, *, request: TestMcpServerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Test connection to an MCP server without adding it.
        Returns the list of available tools if successful.

        Parameters
        ----------
        request : TestMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/tools/mcp/servers/test",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=TestMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    construct_type(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def connect_mcp_server(
        self, *, request: ConnectMcpServerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[StreamingResponse]]]:
        """
        Connect to an MCP server with support for OAuth via SSE.
        Returns a stream of events handling authorization state and exchange if OAuth is required.

        Parameters
        ----------
        request : ConnectMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[HttpResponse[typing.Iterator[StreamingResponse]]]
            Successful response
        """
        with self._client_wrapper.httpx_client.stream(
            "v1/tools/mcp/servers/connect",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=ConnectMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[StreamingResponse]]:
                try:
                    if 200 <= _response.status_code < 300:

                        def _iter():
                            _event_source = httpx_sse.EventSource(_response)
                            for _sse in _event_source.iter_sse():
                                if _sse.data == None:
                                    return
                                try:
                                    yield typing.cast(
                                        StreamingResponse,
                                        construct_type(
                                            type_=StreamingResponse,  # type: ignore
                                            object_=json.loads(_sse.data),
                                        ),
                                    )
                                except Exception:
                                    pass
                            return

                        return HttpResponse(response=_response, data=_iter())
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                construct_type(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()


class AsyncRawToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def retrieve(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Tool]:
        """
        Get a tool by ID

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Tool]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/{jsonable_encoder(tool_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Delete a tool by name

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/{jsonable_encoder(tool_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    construct_type(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def modify(
        self,
        tool_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        source_code: typing.Optional[str] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        return_char_limit: typing.Optional[int] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Tool]:
        """
        Update an existing tool

        Parameters
        ----------
        tool_id : str

        description : typing.Optional[str]
            The description of the tool.

        tags : typing.Optional[typing.Sequence[str]]
            Metadata tags.

        source_code : typing.Optional[str]
            The source code of the function.

        source_type : typing.Optional[str]
            The type of the source code.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        return_char_limit : typing.Optional[int]
            The maximum number of characters in the response.

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A dictionary of additional metadata for the tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Tool]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/{jsonable_encoder(tool_id)}",
            method="PATCH",
            json={
                "description": description,
                "tags": tags,
                "source_code": source_code,
                "source_type": source_type,
                "json_schema": json_schema,
                "args_json_schema": args_json_schema,
                "return_char_limit": return_char_limit,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
                "metadata_": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def count(
        self,
        *,
        include_base_tools: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[int]:
        """
        Get a count of all tools available to agents belonging to the org of the user.

        Parameters
        ----------
        include_base_tools : typing.Optional[bool]
            Include built-in Letta tools in the count

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[int]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/count",
            method="GET",
            params={
                "include_base_tools": include_base_tools,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    int,
                    construct_type(
                        type_=int,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list(
        self,
        *,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[Tool]]:
        """
        Get a list of all tools available to agents belonging to the org of the user

        Parameters
        ----------
        after : typing.Optional[str]

        limit : typing.Optional[int]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Tool]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/",
            method="GET",
            params={
                "after": after,
                "limit": limit,
                "name": name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Tool],
                    construct_type(
                        type_=typing.List[Tool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        source_code: str,
        description: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        return_char_limit: typing.Optional[int] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Tool]:
        """
        Create a new tool

        Parameters
        ----------
        source_code : str
            The source code of the function.

        description : typing.Optional[str]
            The description of the tool.

        tags : typing.Optional[typing.Sequence[str]]
            Metadata tags.

        source_type : typing.Optional[str]
            The source type of the function.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        return_char_limit : typing.Optional[int]
            The maximum number of characters in the response.

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Tool]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/",
            method="POST",
            json={
                "description": description,
                "tags": tags,
                "source_code": source_code,
                "source_type": source_type,
                "json_schema": json_schema,
                "args_json_schema": args_json_schema,
                "return_char_limit": return_char_limit,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert(
        self,
        *,
        source_code: str,
        description: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        return_char_limit: typing.Optional[int] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Tool]:
        """
        Create or update a tool

        Parameters
        ----------
        source_code : str
            The source code of the function.

        description : typing.Optional[str]
            The description of the tool.

        tags : typing.Optional[typing.Sequence[str]]
            Metadata tags.

        source_type : typing.Optional[str]
            The source type of the function.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        return_char_limit : typing.Optional[int]
            The maximum number of characters in the response.

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Tool]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/",
            method="PUT",
            json={
                "description": description,
                "tags": tags,
                "source_code": source_code,
                "source_type": source_type,
                "json_schema": json_schema,
                "args_json_schema": args_json_schema,
                "return_char_limit": return_char_limit,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upsert_base_tools(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[Tool]]:
        """
        Upsert base tools

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Tool]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/add-base-tools",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Tool],
                    construct_type(
                        type_=typing.List[Tool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def run_tool_from_source(
        self,
        *,
        source_code: str,
        args: typing.Dict[str, typing.Optional[typing.Any]],
        env_vars: typing.Optional[typing.Dict[str, str]] = OMIT,
        name: typing.Optional[str] = OMIT,
        source_type: typing.Optional[str] = OMIT,
        args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        pip_requirements: typing.Optional[typing.Sequence[PipRequirement]] = OMIT,
        npm_requirements: typing.Optional[typing.Sequence[NpmRequirement]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ToolReturnMessage]:
        """
        Attempt to build a tool from source, then run it on the provided arguments

        Parameters
        ----------
        source_code : str
            The source code of the function.

        args : typing.Dict[str, typing.Optional[typing.Any]]
            The arguments to pass to the tool.

        env_vars : typing.Optional[typing.Dict[str, str]]
            The environment variables to pass to the tool.

        name : typing.Optional[str]
            The name of the tool to run.

        source_type : typing.Optional[str]
            The type of the source code.

        args_json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The args JSON schema of the function.

        json_schema : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The JSON schema of the function (auto-generated from source_code if not provided)

        pip_requirements : typing.Optional[typing.Sequence[PipRequirement]]
            Optional list of pip packages required by this tool.

        npm_requirements : typing.Optional[typing.Sequence[NpmRequirement]]
            Optional list of npm packages required by this tool.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ToolReturnMessage]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/run",
            method="POST",
            json={
                "source_code": source_code,
                "args": args,
                "env_vars": env_vars,
                "name": name,
                "source_type": source_type,
                "args_json_schema": args_json_schema,
                "json_schema": json_schema,
                "pip_requirements": convert_and_respect_annotation_metadata(
                    object_=pip_requirements, annotation=typing.Sequence[PipRequirement], direction="write"
                ),
                "npm_requirements": convert_and_respect_annotation_metadata(
                    object_=npm_requirements, annotation=typing.Sequence[NpmRequirement], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolReturnMessage,
                    construct_type(
                        type_=ToolReturnMessage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_composio_apps(
        self, *, user_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[AppModel]]:
        """
        Get a list of all Composio apps

        Parameters
        ----------
        user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[AppModel]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/composio/apps",
            method="GET",
            headers={
                "user-id": str(user_id) if user_id is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[AppModel],
                    construct_type(
                        type_=typing.List[AppModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_composio_actions_by_app(
        self, composio_app_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ActionModel]]:
        """
        Get a list of all Composio actions for a specific app

        Parameters
        ----------
        composio_app_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ActionModel]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/composio/apps/{jsonable_encoder(composio_app_name)}/actions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ActionModel],
                    construct_type(
                        type_=typing.List[ActionModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_composio_tool(
        self, composio_action_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Tool]:
        """
        Add a new Composio tool by action name (Composio refers to each tool as an `Action`)

        Parameters
        ----------
        composio_action_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Tool]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/composio/{jsonable_encoder(composio_action_name)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_mcp_servers(
        self, *, user_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Dict[str, ListMcpServersResponseValue]]:
        """
        Get a list of all configured MCP servers

        Parameters
        ----------
        user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Dict[str, ListMcpServersResponseValue]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/mcp/servers",
            method="GET",
            headers={
                "user-id": str(user_id) if user_id is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Dict[str, ListMcpServersResponseValue],
                    construct_type(
                        type_=typing.Dict[str, ListMcpServersResponseValue],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_mcp_server(
        self, *, request: AddMcpServerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[AddMcpServerResponseItem]]:
        """
        Add a new MCP server to the Letta MCP server config

        Parameters
        ----------
        request : AddMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[AddMcpServerResponseItem]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/mcp/servers",
            method="PUT",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=AddMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[AddMcpServerResponseItem],
                    construct_type(
                        type_=typing.List[AddMcpServerResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_mcp_tools_by_server(
        self, mcp_server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[McpTool]]:
        """
        Get a list of all tools for a specific MCP server

        Parameters
        ----------
        mcp_server_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[McpTool]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}/tools",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[McpTool],
                    construct_type(
                        type_=typing.List[McpTool],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_mcp_tool(
        self, mcp_server_name: str, mcp_tool_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Tool]:
        """
        Register a new MCP tool as a Letta server by MCP server + tool name

        Parameters
        ----------
        mcp_server_name : str

        mcp_tool_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Tool]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}/{jsonable_encoder(mcp_tool_name)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Tool,
                    construct_type(
                        type_=Tool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_mcp_server(
        self, mcp_server_name: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[DeleteMcpServerResponseItem]]:
        """
        Delete a MCP server configuration

        Parameters
        ----------
        mcp_server_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[DeleteMcpServerResponseItem]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[DeleteMcpServerResponseItem],
                    construct_type(
                        type_=typing.List[DeleteMcpServerResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_mcp_server(
        self,
        mcp_server_name: str,
        *,
        request: UpdateMcpServerRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateMcpServerResponse]:
        """
        Update an existing MCP server configuration

        Parameters
        ----------
        mcp_server_name : str

        request : UpdateMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateMcpServerResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/tools/mcp/servers/{jsonable_encoder(mcp_server_name)}",
            method="PATCH",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=UpdateMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateMcpServerResponse,
                    construct_type(
                        type_=UpdateMcpServerResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def test_mcp_server(
        self, *, request: TestMcpServerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Test connection to an MCP server without adding it.
        Returns the list of available tools if successful.

        Parameters
        ----------
        request : TestMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/tools/mcp/servers/test",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=TestMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    construct_type(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def connect_mcp_server(
        self, *, request: ConnectMcpServerRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[StreamingResponse]]]:
        """
        Connect to an MCP server with support for OAuth via SSE.
        Returns a stream of events handling authorization state and exchange if OAuth is required.

        Parameters
        ----------
        request : ConnectMcpServerRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[StreamingResponse]]]
            Successful response
        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/tools/mcp/servers/connect",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=ConnectMcpServerRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[StreamingResponse]]:
                try:
                    if 200 <= _response.status_code < 300:

                        async def _iter():
                            _event_source = httpx_sse.EventSource(_response)
                            async for _sse in _event_source.aiter_sse():
                                if _sse.data == None:
                                    return
                                try:
                                    yield typing.cast(
                                        StreamingResponse,
                                        construct_type(
                                            type_=StreamingResponse,  # type: ignore
                                            object_=json.loads(_sse.data),
                                        ),
                                    )
                                except Exception:
                                    pass
                            return

                        return AsyncHttpResponse(response=_response, data=_iter())
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                construct_type(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()
