# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .job_status import JobStatus
from .job_type import JobType


class BatchJob(UncheckedBaseModel):
    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The unix timestamp of when the job was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    status: typing.Optional[JobStatus] = pydantic.Field(default=None)
    """
    The status of the job.
    """

    completed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The unix timestamp of when the job was completed.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The metadata of the job.
    """

    job_type: typing.Optional[JobType] = None
    callback_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    If set, POST to this URL when the job completes.
    """

    callback_sent_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the callback was last attempted.
    """

    callback_status_code: typing.Optional[int] = pydantic.Field(default=None)
    """
    HTTP status code returned by the callback endpoint.
    """

    callback_error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional error message from attempting to POST the callback endpoint.
    """

    ttft_ns: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time to first token for a run in nanoseconds
    """

    total_duration_ns: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total run duration in nanoseconds
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Job
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
