# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .message_create_content import MessageCreateContent
from .message_create_role import MessageCreateRole


class MessageCreate(UncheckedBaseModel):
    """
    Request to create a message
    """

    role: MessageCreateRole = pydantic.Field()
    """
    The role of the participant.
    """

    content: MessageCreateContent = pydantic.Field()
    """
    The content of the message.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the participant.
    """

    otid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The offline threading id associated with this message
    """

    sender_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the sender of the message, can be an identity id or agent id
    """

    batch_item_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the LLMBatchItem that this message is associated with
    """

    group_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The multi-agent group that the message was sent in
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
