# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .embedding_config import EmbeddingConfig


class Passage(UncheckedBaseModel):
    """
    Representation of a passage, which is stored in archival memory.

    Parameters:
        text (str): The text of the passage.
        embedding (List[float]): The embedding of the passage.
        embedding_config (EmbeddingConfig): The embedding configuration used by the passage.
        created_at (datetime): The creation date of the passage.
        organization_id (str): The unique identifier of the organization associated with the passage.
        archive_id (str): The unique identifier of the archive containing this passage.
        source_id (str): The data source of the passage.
        file_id (str): The unique identifier of the file associated with the passage.
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The creation date of the passage.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    is_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this passage is deleted or not.
    """

    archive_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the archive containing this passage.
    """

    source_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The data source of the passage.
    """

    file_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the file associated with the passage.
    """

    file_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the file (only for source passages).
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The metadata of the passage.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Passage
    """

    text: str = pydantic.Field()
    """
    The text of the passage.
    """

    embedding: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    The embedding of the passage.
    """

    embedding_config: typing.Optional[EmbeddingConfig] = pydantic.Field(default=None)
    """
    The embedding configuration used by the passage.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
