# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class StepMetrics(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The id of the step this metric belongs to (matches steps.id).
    """

    provider_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the provider.
    """

    job_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the job.
    """

    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the agent.
    """

    llm_request_ns: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time spent on LLM requests in nanoseconds.
    """

    tool_execution_ns: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time spent on tool execution in nanoseconds.
    """

    step_ns: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total time for the step in nanoseconds.
    """

    base_template_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The base template ID that the step belongs to (cloud only).
    """

    template_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The template ID that the step belongs to (cloud only).
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The project that the step belongs to (cloud only).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
