# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElastigroupArgs', 'Elastigroup']

@pulumi.input_type
class ElastigroupArgs:
    def __init__(__self__, *,
                 fallback_to_ondemand: pulumi.Input[bool],
                 orientation: pulumi.Input[str],
                 product: pulumi.Input[str],
                 security_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_devices_mode: Optional[pulumi.Input[str]] = None,
                 capacity_unit: Optional[pulumi.Input[str]] = None,
                 consider_od_pricing: Optional[pulumi.Input[bool]] = None,
                 cpu_credits: Optional[pulumi.Input[str]] = None,
                 cpu_options: Optional[pulumi.Input['ElastigroupCpuOptionsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 draining_timeout: Optional[pulumi.Input[int]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elastic_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_monitoring: Optional[pulumi.Input[bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEphemeralBlockDeviceArgs']]]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]]] = None,
                 immediate_od_recover_threshold: Optional[pulumi.Input[int]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[str]] = None,
                 instance_types_preferred_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_weights: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]]] = None,
                 integration_beanstalk: Optional[pulumi.Input['ElastigroupIntegrationBeanstalkArgs']] = None,
                 integration_codedeploy: Optional[pulumi.Input['ElastigroupIntegrationCodedeployArgs']] = None,
                 integration_docker_swarm: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']] = None,
                 integration_ecs: Optional[pulumi.Input['ElastigroupIntegrationEcsArgs']] = None,
                 integration_gitlab: Optional[pulumi.Input['ElastigroupIntegrationGitlabArgs']] = None,
                 integration_kubernetes: Optional[pulumi.Input['ElastigroupIntegrationKubernetesArgs']] = None,
                 integration_mesosphere: Optional[pulumi.Input['ElastigroupIntegrationMesosphereArgs']] = None,
                 integration_nomad: Optional[pulumi.Input['ElastigroupIntegrationNomadArgs']] = None,
                 integration_rancher: Optional[pulumi.Input['ElastigroupIntegrationRancherArgs']] = None,
                 integration_route53: Optional[pulumi.Input['ElastigroupIntegrationRoute53Args']] = None,
                 itfs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupItfArgs']]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 lifetime_period: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input['ElastigroupLoggingArgs']] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metadata_options: Optional[pulumi.Input['ElastigroupMetadataOptionsArgs']] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 minimum_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 multiple_metrics: Optional[pulumi.Input['ElastigroupMultipleMetricsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]] = None,
                 on_demand_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ondemand_count: Optional[pulumi.Input[int]] = None,
                 persist_block_devices: Optional[pulumi.Input[bool]] = None,
                 persist_private_ip: Optional[pulumi.Input[bool]] = None,
                 persist_root_device: Optional[pulumi.Input[bool]] = None,
                 placement_tenancy: Optional[pulumi.Input[str]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]]] = None,
                 restrict_single_az: Optional[pulumi.Input[bool]] = None,
                 revert_to_spot: Optional[pulumi.Input['ElastigroupRevertToSpotArgs']] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]] = None,
                 scaling_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]]] = None,
                 scaling_target_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingTargetPolicyArgs']]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]] = None,
                 shutdown_script: Optional[pulumi.Input[str]] = None,
                 signals: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSignalArgs']]]] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 stateful_deallocation: Optional[pulumi.Input['ElastigroupStatefulDeallocationArgs']] = None,
                 stateful_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupStatefulInstanceActionArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_policy: Optional[pulumi.Input['ElastigroupUpdatePolicyArgs']] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 utilize_commitments: Optional[pulumi.Input[bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[bool]] = None,
                 wait_for_capacity: Optional[pulumi.Input[int]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Elastigroup resource.
        :param pulumi.Input[bool] fallback_to_ondemand: In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        :param pulumi.Input[str] orientation: Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
               For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of associated security group IDS.
        :param pulumi.Input[bool] auto_healing: Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
               Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
               `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        :param pulumi.Input[str] capacity_unit: The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        :param pulumi.Input[str] cpu_credits: Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        :param pulumi.Input['ElastigroupCpuOptionsArgs'] cpu_options: The CPU options for the instances that are launched within the group:
        :param pulumi.Input[str] description: The group description.
        :param pulumi.Input[int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elastic_ips: A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        :param pulumi.Input[bool] enable_monitoring: Indicates whether monitoring is enabled for the instance.
        :param pulumi.Input[int] health_check_grace_period: The amount of time, in seconds, after the instance has launched to starts and check its health.
        :param pulumi.Input[str] health_check_type: The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        :param pulumi.Input[int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: The ID of the AMI used to launch the instance.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]] images: An array of image objects. 
               Note: Elastigroup can be configured with either imageId or images, but not both.
        :param pulumi.Input[str] instance_types_ondemand: The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_preferred_spots: Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_spots: One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]] instance_types_weights: List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        :param pulumi.Input[str] key_name: The key name that should be used for the instance.
        :param pulumi.Input['ElastigroupLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input['ElastigroupMetadataOptionsArgs'] metadata_options: Data that used to configure or manage the running instances:
        :param pulumi.Input[int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[int] minimum_instance_lifetime: Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        :param pulumi.Input[str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_demand_types: Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        :param pulumi.Input[int] ondemand_count: Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        :param pulumi.Input[str] placement_tenancy: Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_availability_zones: The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
               Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        :param pulumi.Input[str] region: The AWS region your group will be created in.
               Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]] resource_requirements: Required instance attributes. Instance types will be selected based on these requirements.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]] resource_tag_specifications: User will specify which resources should be tagged with group tags.
        :param pulumi.Input[bool] restrict_single_az: Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        :param pulumi.Input['ElastigroupRevertToSpotArgs'] revert_to_spot: Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]] scaling_strategies: Set termination policy.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of Strings of subnet identifiers.
               Note: When this parameter is set, `availability_zones` should be left unused.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_data: The user data to provide when launching the instance.
        :param pulumi.Input[bool] utilize_reserved_instances: In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        :param pulumi.Input[int] wait_for_capacity: Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        :param pulumi.Input[int] wait_for_capacity_timeout: Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        pulumi.set(__self__, "orientation", orientation)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "security_groups", security_groups)
        if auto_healing is not None:
            pulumi.set(__self__, "auto_healing", auto_healing)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if block_devices_mode is not None:
            pulumi.set(__self__, "block_devices_mode", block_devices_mode)
        if capacity_unit is not None:
            pulumi.set(__self__, "capacity_unit", capacity_unit)
        if consider_od_pricing is not None:
            pulumi.set(__self__, "consider_od_pricing", consider_od_pricing)
        if cpu_credits is not None:
            pulumi.set(__self__, "cpu_credits", cpu_credits)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if elastic_ips is not None:
            pulumi.set(__self__, "elastic_ips", elastic_ips)
        if elastic_load_balancers is not None:
            pulumi.set(__self__, "elastic_load_balancers", elastic_load_balancers)
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_unhealthy_duration_before_replacement is not None:
            pulumi.set(__self__, "health_check_unhealthy_duration_before_replacement", health_check_unhealthy_duration_before_replacement)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if immediate_od_recover_threshold is not None:
            pulumi.set(__self__, "immediate_od_recover_threshold", immediate_od_recover_threshold)
        if instance_types_ondemand is not None:
            pulumi.set(__self__, "instance_types_ondemand", instance_types_ondemand)
        if instance_types_preferred_spots is not None:
            pulumi.set(__self__, "instance_types_preferred_spots", instance_types_preferred_spots)
        if instance_types_spots is not None:
            pulumi.set(__self__, "instance_types_spots", instance_types_spots)
        if instance_types_weights is not None:
            pulumi.set(__self__, "instance_types_weights", instance_types_weights)
        if integration_beanstalk is not None:
            pulumi.set(__self__, "integration_beanstalk", integration_beanstalk)
        if integration_codedeploy is not None:
            pulumi.set(__self__, "integration_codedeploy", integration_codedeploy)
        if integration_docker_swarm is not None:
            pulumi.set(__self__, "integration_docker_swarm", integration_docker_swarm)
        if integration_ecs is not None:
            pulumi.set(__self__, "integration_ecs", integration_ecs)
        if integration_gitlab is not None:
            pulumi.set(__self__, "integration_gitlab", integration_gitlab)
        if integration_kubernetes is not None:
            pulumi.set(__self__, "integration_kubernetes", integration_kubernetes)
        if integration_mesosphere is not None:
            pulumi.set(__self__, "integration_mesosphere", integration_mesosphere)
        if integration_nomad is not None:
            pulumi.set(__self__, "integration_nomad", integration_nomad)
        if integration_rancher is not None:
            pulumi.set(__self__, "integration_rancher", integration_rancher)
        if integration_route53 is not None:
            pulumi.set(__self__, "integration_route53", integration_route53)
        if itfs is not None:
            pulumi.set(__self__, "itfs", itfs)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if lifetime_period is not None:
            pulumi.set(__self__, "lifetime_period", lifetime_period)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if minimum_instance_lifetime is not None:
            pulumi.set(__self__, "minimum_instance_lifetime", minimum_instance_lifetime)
        if multiple_metrics is not None:
            pulumi.set(__self__, "multiple_metrics", multiple_metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if on_demand_types is not None:
            pulumi.set(__self__, "on_demand_types", on_demand_types)
        if ondemand_count is not None:
            pulumi.set(__self__, "ondemand_count", ondemand_count)
        if persist_block_devices is not None:
            pulumi.set(__self__, "persist_block_devices", persist_block_devices)
        if persist_private_ip is not None:
            pulumi.set(__self__, "persist_private_ip", persist_private_ip)
        if persist_root_device is not None:
            pulumi.set(__self__, "persist_root_device", persist_root_device)
        if placement_tenancy is not None:
            pulumi.set(__self__, "placement_tenancy", placement_tenancy)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if resource_tag_specifications is not None:
            pulumi.set(__self__, "resource_tag_specifications", resource_tag_specifications)
        if restrict_single_az is not None:
            pulumi.set(__self__, "restrict_single_az", restrict_single_az)
        if revert_to_spot is not None:
            pulumi.set(__self__, "revert_to_spot", revert_to_spot)
        if scaling_down_policies is not None:
            pulumi.set(__self__, "scaling_down_policies", scaling_down_policies)
        if scaling_strategies is not None:
            pulumi.set(__self__, "scaling_strategies", scaling_strategies)
        if scaling_target_policies is not None:
            pulumi.set(__self__, "scaling_target_policies", scaling_target_policies)
        if scaling_up_policies is not None:
            pulumi.set(__self__, "scaling_up_policies", scaling_up_policies)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if shutdown_script is not None:
            pulumi.set(__self__, "shutdown_script", shutdown_script)
        if signals is not None:
            pulumi.set(__self__, "signals", signals)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if stateful_deallocation is not None:
            pulumi.set(__self__, "stateful_deallocation", stateful_deallocation)
        if stateful_instance_actions is not None:
            pulumi.set(__self__, "stateful_instance_actions", stateful_instance_actions)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)
        if wait_for_capacity is not None:
            pulumi.set(__self__, "wait_for_capacity", wait_for_capacity)
        if wait_for_capacity_timeout is not None:
            pulumi.set(__self__, "wait_for_capacity_timeout", wait_for_capacity_timeout)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Input[bool]:
        """
        In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: pulumi.Input[bool]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def orientation(self) -> pulumi.Input[str]:
        """
        Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        """
        return pulumi.get(self, "orientation")

    @orientation.setter
    def orientation(self, value: pulumi.Input[str]):
        pulumi.set(self, "orientation", value)

    @property
    @pulumi.getter
    def product(self) -> pulumi.Input[str]:
        """
        Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
        For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[str]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of associated security group IDS.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        """
        return pulumi.get(self, "auto_healing")

    @auto_healing.setter
    def auto_healing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_healing", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
        Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
        `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="blockDevicesMode")
    def block_devices_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "block_devices_mode")

    @block_devices_mode.setter
    def block_devices_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_devices_mode", value)

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        """
        return pulumi.get(self, "capacity_unit")

    @capacity_unit.setter
    def capacity_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_unit", value)

    @property
    @pulumi.getter(name="considerOdPricing")
    def consider_od_pricing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "consider_od_pricing")

    @consider_od_pricing.setter
    def consider_od_pricing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consider_od_pricing", value)

    @property
    @pulumi.getter(name="cpuCredits")
    def cpu_credits(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        """
        return pulumi.get(self, "cpu_credits")

    @cpu_credits.setter
    def cpu_credits(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_credits", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['ElastigroupCpuOptionsArgs']]:
        """
        The CPU options for the instances that are launched within the group:
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['ElastigroupCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of instances the group should have at any time.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "draining_timeout", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEbsBlockDeviceArgs']]]]:
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="elasticIps")
    def elastic_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        """
        return pulumi.get(self, "elastic_ips")

    @elastic_ips.setter
    def elastic_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elastic_ips", value)

    @property
    @pulumi.getter(name="elasticLoadBalancers")
    def elastic_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "elastic_load_balancers")

    @elastic_load_balancers.setter
    def elastic_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elastic_load_balancers", value)

    @property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether monitoring is enabled for the instance.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEphemeralBlockDeviceArgs']]]]:
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, after the instance has launched to starts and check its health.
        """
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        """
        return pulumi.get(self, "health_check_unhealthy_duration_before_replacement")

    @health_check_unhealthy_duration_before_replacement.setter
    def health_check_unhealthy_duration_before_replacement(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_unhealthy_duration_before_replacement", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN or name of an IAM instance profile to associate with launched instances.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AMI used to launch the instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]]]:
        """
        An array of image objects. 
        Note: Elastigroup can be configured with either imageId or images, but not both.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="immediateOdRecoverThreshold")
    def immediate_od_recover_threshold(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "immediate_od_recover_threshold")

    @immediate_od_recover_threshold.setter
    def immediate_od_recover_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "immediate_od_recover_threshold", value)

    @property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        """
        return pulumi.get(self, "instance_types_ondemand")

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_types_ondemand", value)

    @property
    @pulumi.getter(name="instanceTypesPreferredSpots")
    def instance_types_preferred_spots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        """
        return pulumi.get(self, "instance_types_preferred_spots")

    @instance_types_preferred_spots.setter
    def instance_types_preferred_spots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types_preferred_spots", value)

    @property
    @pulumi.getter(name="instanceTypesSpots")
    def instance_types_spots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        """
        return pulumi.get(self, "instance_types_spots")

    @instance_types_spots.setter
    def instance_types_spots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types_spots", value)

    @property
    @pulumi.getter(name="instanceTypesWeights")
    def instance_types_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]]]:
        """
        List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        """
        return pulumi.get(self, "instance_types_weights")

    @instance_types_weights.setter
    def instance_types_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]]]):
        pulumi.set(self, "instance_types_weights", value)

    @property
    @pulumi.getter(name="integrationBeanstalk")
    def integration_beanstalk(self) -> Optional[pulumi.Input['ElastigroupIntegrationBeanstalkArgs']]:
        return pulumi.get(self, "integration_beanstalk")

    @integration_beanstalk.setter
    def integration_beanstalk(self, value: Optional[pulumi.Input['ElastigroupIntegrationBeanstalkArgs']]):
        pulumi.set(self, "integration_beanstalk", value)

    @property
    @pulumi.getter(name="integrationCodedeploy")
    def integration_codedeploy(self) -> Optional[pulumi.Input['ElastigroupIntegrationCodedeployArgs']]:
        return pulumi.get(self, "integration_codedeploy")

    @integration_codedeploy.setter
    def integration_codedeploy(self, value: Optional[pulumi.Input['ElastigroupIntegrationCodedeployArgs']]):
        pulumi.set(self, "integration_codedeploy", value)

    @property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]:
        return pulumi.get(self, "integration_docker_swarm")

    @integration_docker_swarm.setter
    def integration_docker_swarm(self, value: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]):
        pulumi.set(self, "integration_docker_swarm", value)

    @property
    @pulumi.getter(name="integrationEcs")
    def integration_ecs(self) -> Optional[pulumi.Input['ElastigroupIntegrationEcsArgs']]:
        return pulumi.get(self, "integration_ecs")

    @integration_ecs.setter
    def integration_ecs(self, value: Optional[pulumi.Input['ElastigroupIntegrationEcsArgs']]):
        pulumi.set(self, "integration_ecs", value)

    @property
    @pulumi.getter(name="integrationGitlab")
    def integration_gitlab(self) -> Optional[pulumi.Input['ElastigroupIntegrationGitlabArgs']]:
        return pulumi.get(self, "integration_gitlab")

    @integration_gitlab.setter
    def integration_gitlab(self, value: Optional[pulumi.Input['ElastigroupIntegrationGitlabArgs']]):
        pulumi.set(self, "integration_gitlab", value)

    @property
    @pulumi.getter(name="integrationKubernetes")
    def integration_kubernetes(self) -> Optional[pulumi.Input['ElastigroupIntegrationKubernetesArgs']]:
        return pulumi.get(self, "integration_kubernetes")

    @integration_kubernetes.setter
    def integration_kubernetes(self, value: Optional[pulumi.Input['ElastigroupIntegrationKubernetesArgs']]):
        pulumi.set(self, "integration_kubernetes", value)

    @property
    @pulumi.getter(name="integrationMesosphere")
    def integration_mesosphere(self) -> Optional[pulumi.Input['ElastigroupIntegrationMesosphereArgs']]:
        return pulumi.get(self, "integration_mesosphere")

    @integration_mesosphere.setter
    def integration_mesosphere(self, value: Optional[pulumi.Input['ElastigroupIntegrationMesosphereArgs']]):
        pulumi.set(self, "integration_mesosphere", value)

    @property
    @pulumi.getter(name="integrationNomad")
    def integration_nomad(self) -> Optional[pulumi.Input['ElastigroupIntegrationNomadArgs']]:
        return pulumi.get(self, "integration_nomad")

    @integration_nomad.setter
    def integration_nomad(self, value: Optional[pulumi.Input['ElastigroupIntegrationNomadArgs']]):
        pulumi.set(self, "integration_nomad", value)

    @property
    @pulumi.getter(name="integrationRancher")
    def integration_rancher(self) -> Optional[pulumi.Input['ElastigroupIntegrationRancherArgs']]:
        return pulumi.get(self, "integration_rancher")

    @integration_rancher.setter
    def integration_rancher(self, value: Optional[pulumi.Input['ElastigroupIntegrationRancherArgs']]):
        pulumi.set(self, "integration_rancher", value)

    @property
    @pulumi.getter(name="integrationRoute53")
    def integration_route53(self) -> Optional[pulumi.Input['ElastigroupIntegrationRoute53Args']]:
        return pulumi.get(self, "integration_route53")

    @integration_route53.setter
    def integration_route53(self, value: Optional[pulumi.Input['ElastigroupIntegrationRoute53Args']]):
        pulumi.set(self, "integration_route53", value)

    @property
    @pulumi.getter
    def itfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupItfArgs']]]]:
        return pulumi.get(self, "itfs")

    @itfs.setter
    def itfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupItfArgs']]]]):
        pulumi.set(self, "itfs", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The key name that should be used for the instance.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="lifetimePeriod")
    def lifetime_period(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "lifetime_period")

    @lifetime_period.setter
    def lifetime_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifetime_period", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['ElastigroupLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['ElastigroupLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances the group should have at any time.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['ElastigroupMetadataOptionsArgs']]:
        """
        Data that used to configure or manage the running instances:
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['ElastigroupMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of instances the group should have at any time.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minimumInstanceLifetime")
    def minimum_instance_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        """
        return pulumi.get(self, "minimum_instance_lifetime")

    @minimum_instance_lifetime.setter
    def minimum_instance_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_instance_lifetime", value)

    @property
    @pulumi.getter(name="multipleMetrics")
    def multiple_metrics(self) -> Optional[pulumi.Input['ElastigroupMultipleMetricsArgs']]:
        return pulumi.get(self, "multiple_metrics")

    @multiple_metrics.setter
    def multiple_metrics(self, value: Optional[pulumi.Input['ElastigroupMultipleMetricsArgs']]):
        pulumi.set(self, "multiple_metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]:
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="onDemandTypes")
    def on_demand_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        """
        return pulumi.get(self, "on_demand_types")

    @on_demand_types.setter
    def on_demand_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "on_demand_types", value)

    @property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        """
        return pulumi.get(self, "ondemand_count")

    @ondemand_count.setter
    def ondemand_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ondemand_count", value)

    @property
    @pulumi.getter(name="persistBlockDevices")
    def persist_block_devices(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "persist_block_devices")

    @persist_block_devices.setter
    def persist_block_devices(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "persist_block_devices", value)

    @property
    @pulumi.getter(name="persistPrivateIp")
    def persist_private_ip(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "persist_private_ip")

    @persist_private_ip.setter
    def persist_private_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "persist_private_ip", value)

    @property
    @pulumi.getter(name="persistRootDevice")
    def persist_root_device(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "persist_root_device")

    @persist_root_device.setter
    def persist_root_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "persist_root_device", value)

    @property
    @pulumi.getter(name="placementTenancy")
    def placement_tenancy(self) -> Optional[pulumi.Input[str]]:
        """
        Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        """
        return pulumi.get(self, "placement_tenancy")

    @placement_tenancy.setter
    def placement_tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_tenancy", value)

    @property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
        Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_availability_zones", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS region your group will be created in.
        Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]]]:
        """
        Required instance attributes. Instance types will be selected based on these requirements.
        """
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter(name="resourceTagSpecifications")
    def resource_tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]]]:
        """
        User will specify which resources should be tagged with group tags.
        """
        return pulumi.get(self, "resource_tag_specifications")

    @resource_tag_specifications.setter
    def resource_tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]]]):
        pulumi.set(self, "resource_tag_specifications", value)

    @property
    @pulumi.getter(name="restrictSingleAz")
    def restrict_single_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        """
        return pulumi.get(self, "restrict_single_az")

    @restrict_single_az.setter
    def restrict_single_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restrict_single_az", value)

    @property
    @pulumi.getter(name="revertToSpot")
    def revert_to_spot(self) -> Optional[pulumi.Input['ElastigroupRevertToSpotArgs']]:
        """
        Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        """
        return pulumi.get(self, "revert_to_spot")

    @revert_to_spot.setter
    def revert_to_spot(self, value: Optional[pulumi.Input['ElastigroupRevertToSpotArgs']]):
        pulumi.set(self, "revert_to_spot", value)

    @property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]:
        return pulumi.get(self, "scaling_down_policies")

    @scaling_down_policies.setter
    def scaling_down_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]):
        pulumi.set(self, "scaling_down_policies", value)

    @property
    @pulumi.getter(name="scalingStrategies")
    def scaling_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]]]:
        """
        Set termination policy.
        """
        return pulumi.get(self, "scaling_strategies")

    @scaling_strategies.setter
    def scaling_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]]]):
        pulumi.set(self, "scaling_strategies", value)

    @property
    @pulumi.getter(name="scalingTargetPolicies")
    def scaling_target_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingTargetPolicyArgs']]]]:
        return pulumi.get(self, "scaling_target_policies")

    @scaling_target_policies.setter
    def scaling_target_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingTargetPolicyArgs']]]]):
        pulumi.set(self, "scaling_target_policies", value)

    @property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]:
        return pulumi.get(self, "scaling_up_policies")

    @scaling_up_policies.setter
    def scaling_up_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]):
        pulumi.set(self, "scaling_up_policies", value)

    @property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]:
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        """
        return pulumi.get(self, "shutdown_script")

    @shutdown_script.setter
    def shutdown_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_script", value)

    @property
    @pulumi.getter
    def signals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSignalArgs']]]]:
        return pulumi.get(self, "signals")

    @signals.setter
    def signals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSignalArgs']]]]):
        pulumi.set(self, "signals", value)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of Spot instances that would spin up from the `desired_capacity` number.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_percentage", value)

    @property
    @pulumi.getter(name="statefulDeallocation")
    def stateful_deallocation(self) -> Optional[pulumi.Input['ElastigroupStatefulDeallocationArgs']]:
        return pulumi.get(self, "stateful_deallocation")

    @stateful_deallocation.setter
    def stateful_deallocation(self, value: Optional[pulumi.Input['ElastigroupStatefulDeallocationArgs']]):
        pulumi.set(self, "stateful_deallocation", value)

    @property
    @pulumi.getter(name="statefulInstanceActions")
    def stateful_instance_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupStatefulInstanceActionArgs']]]]:
        return pulumi.get(self, "stateful_instance_actions")

    @stateful_instance_actions.setter
    def stateful_instance_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupStatefulInstanceActionArgs']]]]):
        pulumi.set(self, "stateful_instance_actions", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Strings of subnet identifiers.
        Note: When this parameter is set, `availability_zones` should be left unused.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]]]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['ElastigroupUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['ElastigroupUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The user data to provide when launching the instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "utilize_commitments")

    @utilize_commitments.setter
    def utilize_commitments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "utilize_commitments", value)

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "utilize_reserved_instances", value)

    @property
    @pulumi.getter(name="waitForCapacity")
    def wait_for_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        """
        return pulumi.get(self, "wait_for_capacity")

    @wait_for_capacity.setter
    def wait_for_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_capacity", value)

    @property
    @pulumi.getter(name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        return pulumi.get(self, "wait_for_capacity_timeout")

    @wait_for_capacity_timeout.setter
    def wait_for_capacity_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_capacity_timeout", value)


@pulumi.input_type
class _ElastigroupState:
    def __init__(__self__, *,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_devices_mode: Optional[pulumi.Input[str]] = None,
                 capacity_unit: Optional[pulumi.Input[str]] = None,
                 consider_od_pricing: Optional[pulumi.Input[bool]] = None,
                 cpu_credits: Optional[pulumi.Input[str]] = None,
                 cpu_options: Optional[pulumi.Input['ElastigroupCpuOptionsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 draining_timeout: Optional[pulumi.Input[int]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elastic_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_monitoring: Optional[pulumi.Input[bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEphemeralBlockDeviceArgs']]]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]]] = None,
                 immediate_od_recover_threshold: Optional[pulumi.Input[int]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[str]] = None,
                 instance_types_preferred_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_weights: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]]] = None,
                 integration_beanstalk: Optional[pulumi.Input['ElastigroupIntegrationBeanstalkArgs']] = None,
                 integration_codedeploy: Optional[pulumi.Input['ElastigroupIntegrationCodedeployArgs']] = None,
                 integration_docker_swarm: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']] = None,
                 integration_ecs: Optional[pulumi.Input['ElastigroupIntegrationEcsArgs']] = None,
                 integration_gitlab: Optional[pulumi.Input['ElastigroupIntegrationGitlabArgs']] = None,
                 integration_kubernetes: Optional[pulumi.Input['ElastigroupIntegrationKubernetesArgs']] = None,
                 integration_mesosphere: Optional[pulumi.Input['ElastigroupIntegrationMesosphereArgs']] = None,
                 integration_nomad: Optional[pulumi.Input['ElastigroupIntegrationNomadArgs']] = None,
                 integration_rancher: Optional[pulumi.Input['ElastigroupIntegrationRancherArgs']] = None,
                 integration_route53: Optional[pulumi.Input['ElastigroupIntegrationRoute53Args']] = None,
                 itfs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupItfArgs']]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 lifetime_period: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input['ElastigroupLoggingArgs']] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metadata_options: Optional[pulumi.Input['ElastigroupMetadataOptionsArgs']] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 minimum_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 multiple_metrics: Optional[pulumi.Input['ElastigroupMultipleMetricsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]] = None,
                 on_demand_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ondemand_count: Optional[pulumi.Input[int]] = None,
                 orientation: Optional[pulumi.Input[str]] = None,
                 persist_block_devices: Optional[pulumi.Input[bool]] = None,
                 persist_private_ip: Optional[pulumi.Input[bool]] = None,
                 persist_root_device: Optional[pulumi.Input[bool]] = None,
                 placement_tenancy: Optional[pulumi.Input[str]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]]] = None,
                 restrict_single_az: Optional[pulumi.Input[bool]] = None,
                 revert_to_spot: Optional[pulumi.Input['ElastigroupRevertToSpotArgs']] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]] = None,
                 scaling_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]]] = None,
                 scaling_target_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingTargetPolicyArgs']]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shutdown_script: Optional[pulumi.Input[str]] = None,
                 signals: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSignalArgs']]]] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 stateful_deallocation: Optional[pulumi.Input['ElastigroupStatefulDeallocationArgs']] = None,
                 stateful_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupStatefulInstanceActionArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_policy: Optional[pulumi.Input['ElastigroupUpdatePolicyArgs']] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 utilize_commitments: Optional[pulumi.Input[bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[bool]] = None,
                 wait_for_capacity: Optional[pulumi.Input[int]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Elastigroup resources.
        :param pulumi.Input[bool] auto_healing: Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
               Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
               `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        :param pulumi.Input[str] capacity_unit: The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        :param pulumi.Input[str] cpu_credits: Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        :param pulumi.Input['ElastigroupCpuOptionsArgs'] cpu_options: The CPU options for the instances that are launched within the group:
        :param pulumi.Input[str] description: The group description.
        :param pulumi.Input[int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elastic_ips: A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        :param pulumi.Input[bool] enable_monitoring: Indicates whether monitoring is enabled for the instance.
        :param pulumi.Input[bool] fallback_to_ondemand: In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        :param pulumi.Input[int] health_check_grace_period: The amount of time, in seconds, after the instance has launched to starts and check its health.
        :param pulumi.Input[str] health_check_type: The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        :param pulumi.Input[int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: The ID of the AMI used to launch the instance.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]] images: An array of image objects. 
               Note: Elastigroup can be configured with either imageId or images, but not both.
        :param pulumi.Input[str] instance_types_ondemand: The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_preferred_spots: Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_spots: One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]] instance_types_weights: List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        :param pulumi.Input[str] key_name: The key name that should be used for the instance.
        :param pulumi.Input['ElastigroupLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input['ElastigroupMetadataOptionsArgs'] metadata_options: Data that used to configure or manage the running instances:
        :param pulumi.Input[int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[int] minimum_instance_lifetime: Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        :param pulumi.Input[str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_demand_types: Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        :param pulumi.Input[int] ondemand_count: Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        :param pulumi.Input[str] orientation: Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        :param pulumi.Input[str] placement_tenancy: Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_availability_zones: The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
               Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
               For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        :param pulumi.Input[str] region: The AWS region your group will be created in.
               Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]] resource_requirements: Required instance attributes. Instance types will be selected based on these requirements.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]] resource_tag_specifications: User will specify which resources should be tagged with group tags.
        :param pulumi.Input[bool] restrict_single_az: Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        :param pulumi.Input['ElastigroupRevertToSpotArgs'] revert_to_spot: Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]] scaling_strategies: Set termination policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of associated security group IDS.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of Strings of subnet identifiers.
               Note: When this parameter is set, `availability_zones` should be left unused.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_data: The user data to provide when launching the instance.
        :param pulumi.Input[bool] utilize_reserved_instances: In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        :param pulumi.Input[int] wait_for_capacity: Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        :param pulumi.Input[int] wait_for_capacity_timeout: Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        if auto_healing is not None:
            pulumi.set(__self__, "auto_healing", auto_healing)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if block_devices_mode is not None:
            pulumi.set(__self__, "block_devices_mode", block_devices_mode)
        if capacity_unit is not None:
            pulumi.set(__self__, "capacity_unit", capacity_unit)
        if consider_od_pricing is not None:
            pulumi.set(__self__, "consider_od_pricing", consider_od_pricing)
        if cpu_credits is not None:
            pulumi.set(__self__, "cpu_credits", cpu_credits)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if elastic_ips is not None:
            pulumi.set(__self__, "elastic_ips", elastic_ips)
        if elastic_load_balancers is not None:
            pulumi.set(__self__, "elastic_load_balancers", elastic_load_balancers)
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_unhealthy_duration_before_replacement is not None:
            pulumi.set(__self__, "health_check_unhealthy_duration_before_replacement", health_check_unhealthy_duration_before_replacement)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if immediate_od_recover_threshold is not None:
            pulumi.set(__self__, "immediate_od_recover_threshold", immediate_od_recover_threshold)
        if instance_types_ondemand is not None:
            pulumi.set(__self__, "instance_types_ondemand", instance_types_ondemand)
        if instance_types_preferred_spots is not None:
            pulumi.set(__self__, "instance_types_preferred_spots", instance_types_preferred_spots)
        if instance_types_spots is not None:
            pulumi.set(__self__, "instance_types_spots", instance_types_spots)
        if instance_types_weights is not None:
            pulumi.set(__self__, "instance_types_weights", instance_types_weights)
        if integration_beanstalk is not None:
            pulumi.set(__self__, "integration_beanstalk", integration_beanstalk)
        if integration_codedeploy is not None:
            pulumi.set(__self__, "integration_codedeploy", integration_codedeploy)
        if integration_docker_swarm is not None:
            pulumi.set(__self__, "integration_docker_swarm", integration_docker_swarm)
        if integration_ecs is not None:
            pulumi.set(__self__, "integration_ecs", integration_ecs)
        if integration_gitlab is not None:
            pulumi.set(__self__, "integration_gitlab", integration_gitlab)
        if integration_kubernetes is not None:
            pulumi.set(__self__, "integration_kubernetes", integration_kubernetes)
        if integration_mesosphere is not None:
            pulumi.set(__self__, "integration_mesosphere", integration_mesosphere)
        if integration_nomad is not None:
            pulumi.set(__self__, "integration_nomad", integration_nomad)
        if integration_rancher is not None:
            pulumi.set(__self__, "integration_rancher", integration_rancher)
        if integration_route53 is not None:
            pulumi.set(__self__, "integration_route53", integration_route53)
        if itfs is not None:
            pulumi.set(__self__, "itfs", itfs)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if lifetime_period is not None:
            pulumi.set(__self__, "lifetime_period", lifetime_period)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if minimum_instance_lifetime is not None:
            pulumi.set(__self__, "minimum_instance_lifetime", minimum_instance_lifetime)
        if multiple_metrics is not None:
            pulumi.set(__self__, "multiple_metrics", multiple_metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if on_demand_types is not None:
            pulumi.set(__self__, "on_demand_types", on_demand_types)
        if ondemand_count is not None:
            pulumi.set(__self__, "ondemand_count", ondemand_count)
        if orientation is not None:
            pulumi.set(__self__, "orientation", orientation)
        if persist_block_devices is not None:
            pulumi.set(__self__, "persist_block_devices", persist_block_devices)
        if persist_private_ip is not None:
            pulumi.set(__self__, "persist_private_ip", persist_private_ip)
        if persist_root_device is not None:
            pulumi.set(__self__, "persist_root_device", persist_root_device)
        if placement_tenancy is not None:
            pulumi.set(__self__, "placement_tenancy", placement_tenancy)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if resource_tag_specifications is not None:
            pulumi.set(__self__, "resource_tag_specifications", resource_tag_specifications)
        if restrict_single_az is not None:
            pulumi.set(__self__, "restrict_single_az", restrict_single_az)
        if revert_to_spot is not None:
            pulumi.set(__self__, "revert_to_spot", revert_to_spot)
        if scaling_down_policies is not None:
            pulumi.set(__self__, "scaling_down_policies", scaling_down_policies)
        if scaling_strategies is not None:
            pulumi.set(__self__, "scaling_strategies", scaling_strategies)
        if scaling_target_policies is not None:
            pulumi.set(__self__, "scaling_target_policies", scaling_target_policies)
        if scaling_up_policies is not None:
            pulumi.set(__self__, "scaling_up_policies", scaling_up_policies)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if shutdown_script is not None:
            pulumi.set(__self__, "shutdown_script", shutdown_script)
        if signals is not None:
            pulumi.set(__self__, "signals", signals)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if stateful_deallocation is not None:
            pulumi.set(__self__, "stateful_deallocation", stateful_deallocation)
        if stateful_instance_actions is not None:
            pulumi.set(__self__, "stateful_instance_actions", stateful_instance_actions)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)
        if wait_for_capacity is not None:
            pulumi.set(__self__, "wait_for_capacity", wait_for_capacity)
        if wait_for_capacity_timeout is not None:
            pulumi.set(__self__, "wait_for_capacity_timeout", wait_for_capacity_timeout)

    @property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        """
        return pulumi.get(self, "auto_healing")

    @auto_healing.setter
    def auto_healing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_healing", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
        Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
        `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="blockDevicesMode")
    def block_devices_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "block_devices_mode")

    @block_devices_mode.setter
    def block_devices_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_devices_mode", value)

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        """
        return pulumi.get(self, "capacity_unit")

    @capacity_unit.setter
    def capacity_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_unit", value)

    @property
    @pulumi.getter(name="considerOdPricing")
    def consider_od_pricing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "consider_od_pricing")

    @consider_od_pricing.setter
    def consider_od_pricing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consider_od_pricing", value)

    @property
    @pulumi.getter(name="cpuCredits")
    def cpu_credits(self) -> Optional[pulumi.Input[str]]:
        """
        Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        """
        return pulumi.get(self, "cpu_credits")

    @cpu_credits.setter
    def cpu_credits(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_credits", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['ElastigroupCpuOptionsArgs']]:
        """
        The CPU options for the instances that are launched within the group:
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['ElastigroupCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of instances the group should have at any time.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "draining_timeout", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEbsBlockDeviceArgs']]]]:
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="elasticIps")
    def elastic_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        """
        return pulumi.get(self, "elastic_ips")

    @elastic_ips.setter
    def elastic_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elastic_ips", value)

    @property
    @pulumi.getter(name="elasticLoadBalancers")
    def elastic_load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "elastic_load_balancers")

    @elastic_load_balancers.setter
    def elastic_load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elastic_load_balancers", value)

    @property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether monitoring is enabled for the instance.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEphemeralBlockDeviceArgs']]]]:
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[bool]]:
        """
        In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, after the instance has launched to starts and check its health.
        """
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        """
        return pulumi.get(self, "health_check_unhealthy_duration_before_replacement")

    @health_check_unhealthy_duration_before_replacement.setter
    def health_check_unhealthy_duration_before_replacement(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_unhealthy_duration_before_replacement", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN or name of an IAM instance profile to associate with launched instances.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AMI used to launch the instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]]]:
        """
        An array of image objects. 
        Note: Elastigroup can be configured with either imageId or images, but not both.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="immediateOdRecoverThreshold")
    def immediate_od_recover_threshold(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "immediate_od_recover_threshold")

    @immediate_od_recover_threshold.setter
    def immediate_od_recover_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "immediate_od_recover_threshold", value)

    @property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        """
        return pulumi.get(self, "instance_types_ondemand")

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_types_ondemand", value)

    @property
    @pulumi.getter(name="instanceTypesPreferredSpots")
    def instance_types_preferred_spots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        """
        return pulumi.get(self, "instance_types_preferred_spots")

    @instance_types_preferred_spots.setter
    def instance_types_preferred_spots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types_preferred_spots", value)

    @property
    @pulumi.getter(name="instanceTypesSpots")
    def instance_types_spots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        """
        return pulumi.get(self, "instance_types_spots")

    @instance_types_spots.setter
    def instance_types_spots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types_spots", value)

    @property
    @pulumi.getter(name="instanceTypesWeights")
    def instance_types_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]]]:
        """
        List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        """
        return pulumi.get(self, "instance_types_weights")

    @instance_types_weights.setter
    def instance_types_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesWeightArgs']]]]):
        pulumi.set(self, "instance_types_weights", value)

    @property
    @pulumi.getter(name="integrationBeanstalk")
    def integration_beanstalk(self) -> Optional[pulumi.Input['ElastigroupIntegrationBeanstalkArgs']]:
        return pulumi.get(self, "integration_beanstalk")

    @integration_beanstalk.setter
    def integration_beanstalk(self, value: Optional[pulumi.Input['ElastigroupIntegrationBeanstalkArgs']]):
        pulumi.set(self, "integration_beanstalk", value)

    @property
    @pulumi.getter(name="integrationCodedeploy")
    def integration_codedeploy(self) -> Optional[pulumi.Input['ElastigroupIntegrationCodedeployArgs']]:
        return pulumi.get(self, "integration_codedeploy")

    @integration_codedeploy.setter
    def integration_codedeploy(self, value: Optional[pulumi.Input['ElastigroupIntegrationCodedeployArgs']]):
        pulumi.set(self, "integration_codedeploy", value)

    @property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]:
        return pulumi.get(self, "integration_docker_swarm")

    @integration_docker_swarm.setter
    def integration_docker_swarm(self, value: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]):
        pulumi.set(self, "integration_docker_swarm", value)

    @property
    @pulumi.getter(name="integrationEcs")
    def integration_ecs(self) -> Optional[pulumi.Input['ElastigroupIntegrationEcsArgs']]:
        return pulumi.get(self, "integration_ecs")

    @integration_ecs.setter
    def integration_ecs(self, value: Optional[pulumi.Input['ElastigroupIntegrationEcsArgs']]):
        pulumi.set(self, "integration_ecs", value)

    @property
    @pulumi.getter(name="integrationGitlab")
    def integration_gitlab(self) -> Optional[pulumi.Input['ElastigroupIntegrationGitlabArgs']]:
        return pulumi.get(self, "integration_gitlab")

    @integration_gitlab.setter
    def integration_gitlab(self, value: Optional[pulumi.Input['ElastigroupIntegrationGitlabArgs']]):
        pulumi.set(self, "integration_gitlab", value)

    @property
    @pulumi.getter(name="integrationKubernetes")
    def integration_kubernetes(self) -> Optional[pulumi.Input['ElastigroupIntegrationKubernetesArgs']]:
        return pulumi.get(self, "integration_kubernetes")

    @integration_kubernetes.setter
    def integration_kubernetes(self, value: Optional[pulumi.Input['ElastigroupIntegrationKubernetesArgs']]):
        pulumi.set(self, "integration_kubernetes", value)

    @property
    @pulumi.getter(name="integrationMesosphere")
    def integration_mesosphere(self) -> Optional[pulumi.Input['ElastigroupIntegrationMesosphereArgs']]:
        return pulumi.get(self, "integration_mesosphere")

    @integration_mesosphere.setter
    def integration_mesosphere(self, value: Optional[pulumi.Input['ElastigroupIntegrationMesosphereArgs']]):
        pulumi.set(self, "integration_mesosphere", value)

    @property
    @pulumi.getter(name="integrationNomad")
    def integration_nomad(self) -> Optional[pulumi.Input['ElastigroupIntegrationNomadArgs']]:
        return pulumi.get(self, "integration_nomad")

    @integration_nomad.setter
    def integration_nomad(self, value: Optional[pulumi.Input['ElastigroupIntegrationNomadArgs']]):
        pulumi.set(self, "integration_nomad", value)

    @property
    @pulumi.getter(name="integrationRancher")
    def integration_rancher(self) -> Optional[pulumi.Input['ElastigroupIntegrationRancherArgs']]:
        return pulumi.get(self, "integration_rancher")

    @integration_rancher.setter
    def integration_rancher(self, value: Optional[pulumi.Input['ElastigroupIntegrationRancherArgs']]):
        pulumi.set(self, "integration_rancher", value)

    @property
    @pulumi.getter(name="integrationRoute53")
    def integration_route53(self) -> Optional[pulumi.Input['ElastigroupIntegrationRoute53Args']]:
        return pulumi.get(self, "integration_route53")

    @integration_route53.setter
    def integration_route53(self, value: Optional[pulumi.Input['ElastigroupIntegrationRoute53Args']]):
        pulumi.set(self, "integration_route53", value)

    @property
    @pulumi.getter
    def itfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupItfArgs']]]]:
        return pulumi.get(self, "itfs")

    @itfs.setter
    def itfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupItfArgs']]]]):
        pulumi.set(self, "itfs", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The key name that should be used for the instance.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="lifetimePeriod")
    def lifetime_period(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "lifetime_period")

    @lifetime_period.setter
    def lifetime_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifetime_period", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['ElastigroupLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['ElastigroupLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances the group should have at any time.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['ElastigroupMetadataOptionsArgs']]:
        """
        Data that used to configure or manage the running instances:
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['ElastigroupMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of instances the group should have at any time.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minimumInstanceLifetime")
    def minimum_instance_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        """
        return pulumi.get(self, "minimum_instance_lifetime")

    @minimum_instance_lifetime.setter
    def minimum_instance_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minimum_instance_lifetime", value)

    @property
    @pulumi.getter(name="multipleMetrics")
    def multiple_metrics(self) -> Optional[pulumi.Input['ElastigroupMultipleMetricsArgs']]:
        return pulumi.get(self, "multiple_metrics")

    @multiple_metrics.setter
    def multiple_metrics(self, value: Optional[pulumi.Input['ElastigroupMultipleMetricsArgs']]):
        pulumi.set(self, "multiple_metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]:
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="onDemandTypes")
    def on_demand_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        """
        return pulumi.get(self, "on_demand_types")

    @on_demand_types.setter
    def on_demand_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "on_demand_types", value)

    @property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        """
        return pulumi.get(self, "ondemand_count")

    @ondemand_count.setter
    def ondemand_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ondemand_count", value)

    @property
    @pulumi.getter
    def orientation(self) -> Optional[pulumi.Input[str]]:
        """
        Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        """
        return pulumi.get(self, "orientation")

    @orientation.setter
    def orientation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "orientation", value)

    @property
    @pulumi.getter(name="persistBlockDevices")
    def persist_block_devices(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "persist_block_devices")

    @persist_block_devices.setter
    def persist_block_devices(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "persist_block_devices", value)

    @property
    @pulumi.getter(name="persistPrivateIp")
    def persist_private_ip(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "persist_private_ip")

    @persist_private_ip.setter
    def persist_private_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "persist_private_ip", value)

    @property
    @pulumi.getter(name="persistRootDevice")
    def persist_root_device(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "persist_root_device")

    @persist_root_device.setter
    def persist_root_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "persist_root_device", value)

    @property
    @pulumi.getter(name="placementTenancy")
    def placement_tenancy(self) -> Optional[pulumi.Input[str]]:
        """
        Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        """
        return pulumi.get(self, "placement_tenancy")

    @placement_tenancy.setter
    def placement_tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_tenancy", value)

    @property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
        Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_availability_zones", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
        For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS region your group will be created in.
        Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]]]:
        """
        Required instance attributes. Instance types will be selected based on these requirements.
        """
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceRequirementArgs']]]]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter(name="resourceTagSpecifications")
    def resource_tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]]]:
        """
        User will specify which resources should be tagged with group tags.
        """
        return pulumi.get(self, "resource_tag_specifications")

    @resource_tag_specifications.setter
    def resource_tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupResourceTagSpecificationArgs']]]]):
        pulumi.set(self, "resource_tag_specifications", value)

    @property
    @pulumi.getter(name="restrictSingleAz")
    def restrict_single_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        """
        return pulumi.get(self, "restrict_single_az")

    @restrict_single_az.setter
    def restrict_single_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restrict_single_az", value)

    @property
    @pulumi.getter(name="revertToSpot")
    def revert_to_spot(self) -> Optional[pulumi.Input['ElastigroupRevertToSpotArgs']]:
        """
        Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        """
        return pulumi.get(self, "revert_to_spot")

    @revert_to_spot.setter
    def revert_to_spot(self, value: Optional[pulumi.Input['ElastigroupRevertToSpotArgs']]):
        pulumi.set(self, "revert_to_spot", value)

    @property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]:
        return pulumi.get(self, "scaling_down_policies")

    @scaling_down_policies.setter
    def scaling_down_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]):
        pulumi.set(self, "scaling_down_policies", value)

    @property
    @pulumi.getter(name="scalingStrategies")
    def scaling_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]]]:
        """
        Set termination policy.
        """
        return pulumi.get(self, "scaling_strategies")

    @scaling_strategies.setter
    def scaling_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingStrategyArgs']]]]):
        pulumi.set(self, "scaling_strategies", value)

    @property
    @pulumi.getter(name="scalingTargetPolicies")
    def scaling_target_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingTargetPolicyArgs']]]]:
        return pulumi.get(self, "scaling_target_policies")

    @scaling_target_policies.setter
    def scaling_target_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingTargetPolicyArgs']]]]):
        pulumi.set(self, "scaling_target_policies", value)

    @property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]:
        return pulumi.get(self, "scaling_up_policies")

    @scaling_up_policies.setter
    def scaling_up_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]):
        pulumi.set(self, "scaling_up_policies", value)

    @property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]:
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of associated security group IDS.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> Optional[pulumi.Input[str]]:
        """
        The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        """
        return pulumi.get(self, "shutdown_script")

    @shutdown_script.setter
    def shutdown_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shutdown_script", value)

    @property
    @pulumi.getter
    def signals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSignalArgs']]]]:
        return pulumi.get(self, "signals")

    @signals.setter
    def signals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSignalArgs']]]]):
        pulumi.set(self, "signals", value)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of Spot instances that would spin up from the `desired_capacity` number.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_percentage", value)

    @property
    @pulumi.getter(name="statefulDeallocation")
    def stateful_deallocation(self) -> Optional[pulumi.Input['ElastigroupStatefulDeallocationArgs']]:
        return pulumi.get(self, "stateful_deallocation")

    @stateful_deallocation.setter
    def stateful_deallocation(self, value: Optional[pulumi.Input['ElastigroupStatefulDeallocationArgs']]):
        pulumi.set(self, "stateful_deallocation", value)

    @property
    @pulumi.getter(name="statefulInstanceActions")
    def stateful_instance_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupStatefulInstanceActionArgs']]]]:
        return pulumi.get(self, "stateful_instance_actions")

    @stateful_instance_actions.setter
    def stateful_instance_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupStatefulInstanceActionArgs']]]]):
        pulumi.set(self, "stateful_instance_actions", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Strings of subnet identifiers.
        Note: When this parameter is set, `availability_zones` should be left unused.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]]]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['ElastigroupUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['ElastigroupUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The user data to provide when launching the instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "utilize_commitments")

    @utilize_commitments.setter
    def utilize_commitments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "utilize_commitments", value)

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[pulumi.Input[bool]]:
        """
        In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "utilize_reserved_instances", value)

    @property
    @pulumi.getter(name="waitForCapacity")
    def wait_for_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        """
        return pulumi.get(self, "wait_for_capacity")

    @wait_for_capacity.setter
    def wait_for_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_capacity", value)

    @property
    @pulumi.getter(name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        return pulumi.get(self, "wait_for_capacity_timeout")

    @wait_for_capacity_timeout.setter
    def wait_for_capacity_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_capacity_timeout", value)


class Elastigroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_devices_mode: Optional[pulumi.Input[str]] = None,
                 capacity_unit: Optional[pulumi.Input[str]] = None,
                 consider_od_pricing: Optional[pulumi.Input[bool]] = None,
                 cpu_credits: Optional[pulumi.Input[str]] = None,
                 cpu_options: Optional[pulumi.Input[Union['ElastigroupCpuOptionsArgs', 'ElastigroupCpuOptionsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 draining_timeout: Optional[pulumi.Input[int]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupEbsBlockDeviceArgs', 'ElastigroupEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elastic_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_monitoring: Optional[pulumi.Input[bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupEphemeralBlockDeviceArgs', 'ElastigroupEphemeralBlockDeviceArgsDict']]]]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupImageArgs', 'ElastigroupImageArgsDict']]]]] = None,
                 immediate_od_recover_threshold: Optional[pulumi.Input[int]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[str]] = None,
                 instance_types_preferred_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_weights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesWeightArgs', 'ElastigroupInstanceTypesWeightArgsDict']]]]] = None,
                 integration_beanstalk: Optional[pulumi.Input[Union['ElastigroupIntegrationBeanstalkArgs', 'ElastigroupIntegrationBeanstalkArgsDict']]] = None,
                 integration_codedeploy: Optional[pulumi.Input[Union['ElastigroupIntegrationCodedeployArgs', 'ElastigroupIntegrationCodedeployArgsDict']]] = None,
                 integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
                 integration_ecs: Optional[pulumi.Input[Union['ElastigroupIntegrationEcsArgs', 'ElastigroupIntegrationEcsArgsDict']]] = None,
                 integration_gitlab: Optional[pulumi.Input[Union['ElastigroupIntegrationGitlabArgs', 'ElastigroupIntegrationGitlabArgsDict']]] = None,
                 integration_kubernetes: Optional[pulumi.Input[Union['ElastigroupIntegrationKubernetesArgs', 'ElastigroupIntegrationKubernetesArgsDict']]] = None,
                 integration_mesosphere: Optional[pulumi.Input[Union['ElastigroupIntegrationMesosphereArgs', 'ElastigroupIntegrationMesosphereArgsDict']]] = None,
                 integration_nomad: Optional[pulumi.Input[Union['ElastigroupIntegrationNomadArgs', 'ElastigroupIntegrationNomadArgsDict']]] = None,
                 integration_rancher: Optional[pulumi.Input[Union['ElastigroupIntegrationRancherArgs', 'ElastigroupIntegrationRancherArgsDict']]] = None,
                 integration_route53: Optional[pulumi.Input[Union['ElastigroupIntegrationRoute53Args', 'ElastigroupIntegrationRoute53ArgsDict']]] = None,
                 itfs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupItfArgs', 'ElastigroupItfArgsDict']]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 lifetime_period: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[Union['ElastigroupLoggingArgs', 'ElastigroupLoggingArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metadata_options: Optional[pulumi.Input[Union['ElastigroupMetadataOptionsArgs', 'ElastigroupMetadataOptionsArgsDict']]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 minimum_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 multiple_metrics: Optional[pulumi.Input[Union['ElastigroupMultipleMetricsArgs', 'ElastigroupMultipleMetricsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
                 on_demand_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ondemand_count: Optional[pulumi.Input[int]] = None,
                 orientation: Optional[pulumi.Input[str]] = None,
                 persist_block_devices: Optional[pulumi.Input[bool]] = None,
                 persist_private_ip: Optional[pulumi.Input[bool]] = None,
                 persist_root_device: Optional[pulumi.Input[bool]] = None,
                 placement_tenancy: Optional[pulumi.Input[str]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceRequirementArgs', 'ElastigroupResourceRequirementArgsDict']]]]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceTagSpecificationArgs', 'ElastigroupResourceTagSpecificationArgsDict']]]]] = None,
                 restrict_single_az: Optional[pulumi.Input[bool]] = None,
                 revert_to_spot: Optional[pulumi.Input[Union['ElastigroupRevertToSpotArgs', 'ElastigroupRevertToSpotArgsDict']]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
                 scaling_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingStrategyArgs', 'ElastigroupScalingStrategyArgsDict']]]]] = None,
                 scaling_target_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingTargetPolicyArgs', 'ElastigroupScalingTargetPolicyArgsDict']]]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScheduledTaskArgs', 'ElastigroupScheduledTaskArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shutdown_script: Optional[pulumi.Input[str]] = None,
                 signals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSignalArgs', 'ElastigroupSignalArgsDict']]]]] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 stateful_deallocation: Optional[pulumi.Input[Union['ElastigroupStatefulDeallocationArgs', 'ElastigroupStatefulDeallocationArgsDict']]] = None,
                 stateful_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupStatefulInstanceActionArgs', 'ElastigroupStatefulInstanceActionArgsDict']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupTagArgs', 'ElastigroupTagArgsDict']]]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['ElastigroupUpdatePolicyArgs', 'ElastigroupUpdatePolicyArgsDict']]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 utilize_commitments: Optional[pulumi.Input[bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[bool]] = None,
                 wait_for_capacity: Optional[pulumi.Input[int]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Spotinst AWS group resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        # Create an Elastigroup
        default_elastigroup = spotinst.aws.Elastigroup("default-elastigroup",
            name="default-elastigroup",
            description="created by Pulumi",
            product="Linux/UNIX",
            max_size=0,
            min_size=0,
            desired_capacity=0,
            capacity_unit="weight",
            region="us-west-2",
            subnet_ids=[
                "sb-123456",
                "sb-456789",
            ],
            image_id="ami-a27d8fda",
            iam_instance_profile="iam-profile",
            key_name="my-key.ssh",
            security_groups=["sg-123456"],
            user_data="echo hello world",
            enable_monitoring=False,
            ebs_optimized=False,
            placement_tenancy="default",
            metadata_options={
                "http_tokens": "optional",
                "http_put_response_hop_limit": 10,
                "instance_metadata_tags": "enabled",
            },
            cpu_options={
                "threads_per_core": 1,
            },
            instance_types_ondemand="m3.2xlarge",
            instance_types_spots=[
                "m3.xlarge",
                "m3.2xlarge",
            ],
            instance_types_preferred_spots=["m3.xlarge"],
            on_demand_types=["c3.large"],
            instance_types_weights=[
                {
                    "instance_type": "m3.xlarge",
                    "weight": 10,
                },
                {
                    "instance_type": "m3.2xlarge",
                    "weight": 16,
                },
            ],
            resource_requirements=[{
                "excluded_instance_families": [
                    "a",
                    "m",
                ],
                "excluded_instance_types": ["m3.large"],
                "excluded_instance_generations": [
                    "1",
                    "2",
                ],
                "required_gpu_minimum": 1,
                "required_gpu_maximum": 16,
                "required_memory_minimum": 1,
                "required_memory_maximum": 512,
                "required_vcpu_minimum": 1,
                "required_vcpu_maximum": 64,
            }],
            orientation="balanced",
            fallback_to_ondemand=False,
            cpu_credits="unlimited",
            minimum_instance_lifetime=12,
            wait_for_capacity=5,
            wait_for_capacity_timeout=300,
            scaling_strategies=[{
                "terminate_at_end_of_billing_hour": True,
                "termination_policy": "default",
            }],
            scaling_up_policies=[{
                "policy_name": "Default Scaling Up Policy",
                "metric_name": "DefaultQueuesDepth",
                "statistic": "average",
                "unit": "none",
                "adjustment": "1",
                "namespace": "custom",
                "threshold": 100,
                "period": 60,
                "evaluation_periods": 5,
                "cooldown": 300,
            }],
            scaling_down_policies=[{
                "policy_name": "Default Scaling Down Policy",
                "metric_name": "DefaultQueuesDepth",
                "statistic": "average",
                "unit": "none",
                "adjustment": "1",
                "namespace": "custom",
                "threshold": 10,
                "period": 60,
                "evaluation_periods": 10,
                "cooldown": 300,
            }],
            tags=[
                {
                    "key": "Env",
                    "value": "production",
                },
                {
                    "key": "Name",
                    "value": "default-production",
                },
                {
                    "key": "Project",
                    "value": "app_v2",
                },
            ],
            resource_tag_specifications=[{
                "should_tag_enis": True,
                "should_tag_volumes": True,
                "should_tag_snapshots": True,
                "should_tag_amis": True,
            }],
            logging={
                "export": {
                    "s3s": [{
                        "id": "di-123456",
                    }],
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_healing: Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
               Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
               `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        :param pulumi.Input[str] capacity_unit: The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        :param pulumi.Input[str] cpu_credits: Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[Union['ElastigroupCpuOptionsArgs', 'ElastigroupCpuOptionsArgsDict']] cpu_options: The CPU options for the instances that are launched within the group:
        :param pulumi.Input[str] description: The group description.
        :param pulumi.Input[int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elastic_ips: A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        :param pulumi.Input[bool] enable_monitoring: Indicates whether monitoring is enabled for the instance.
        :param pulumi.Input[bool] fallback_to_ondemand: In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        :param pulumi.Input[int] health_check_grace_period: The amount of time, in seconds, after the instance has launched to starts and check its health.
        :param pulumi.Input[str] health_check_type: The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        :param pulumi.Input[int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: The ID of the AMI used to launch the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupImageArgs', 'ElastigroupImageArgsDict']]]] images: An array of image objects. 
               Note: Elastigroup can be configured with either imageId or images, but not both.
        :param pulumi.Input[str] instance_types_ondemand: The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_preferred_spots: Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_spots: One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesWeightArgs', 'ElastigroupInstanceTypesWeightArgsDict']]]] instance_types_weights: List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        :param pulumi.Input[str] key_name: The key name that should be used for the instance.
        :param pulumi.Input[Union['ElastigroupLoggingArgs', 'ElastigroupLoggingArgsDict']] logging: Logging configuration.
        :param pulumi.Input[int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[Union['ElastigroupMetadataOptionsArgs', 'ElastigroupMetadataOptionsArgsDict']] metadata_options: Data that used to configure or manage the running instances:
        :param pulumi.Input[int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[int] minimum_instance_lifetime: Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        :param pulumi.Input[str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_demand_types: Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        :param pulumi.Input[int] ondemand_count: Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        :param pulumi.Input[str] orientation: Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        :param pulumi.Input[str] placement_tenancy: Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_availability_zones: The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
               Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
               For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        :param pulumi.Input[str] region: The AWS region your group will be created in.
               Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceRequirementArgs', 'ElastigroupResourceRequirementArgsDict']]]] resource_requirements: Required instance attributes. Instance types will be selected based on these requirements.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceTagSpecificationArgs', 'ElastigroupResourceTagSpecificationArgsDict']]]] resource_tag_specifications: User will specify which resources should be tagged with group tags.
        :param pulumi.Input[bool] restrict_single_az: Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        :param pulumi.Input[Union['ElastigroupRevertToSpotArgs', 'ElastigroupRevertToSpotArgsDict']] revert_to_spot: Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingStrategyArgs', 'ElastigroupScalingStrategyArgsDict']]]] scaling_strategies: Set termination policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of associated security group IDS.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of Strings of subnet identifiers.
               Note: When this parameter is set, `availability_zones` should be left unused.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupTagArgs', 'ElastigroupTagArgsDict']]]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_data: The user data to provide when launching the instance.
        :param pulumi.Input[bool] utilize_reserved_instances: In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        :param pulumi.Input[int] wait_for_capacity: Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        :param pulumi.Input[int] wait_for_capacity_timeout: Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElastigroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Spotinst AWS group resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        # Create an Elastigroup
        default_elastigroup = spotinst.aws.Elastigroup("default-elastigroup",
            name="default-elastigroup",
            description="created by Pulumi",
            product="Linux/UNIX",
            max_size=0,
            min_size=0,
            desired_capacity=0,
            capacity_unit="weight",
            region="us-west-2",
            subnet_ids=[
                "sb-123456",
                "sb-456789",
            ],
            image_id="ami-a27d8fda",
            iam_instance_profile="iam-profile",
            key_name="my-key.ssh",
            security_groups=["sg-123456"],
            user_data="echo hello world",
            enable_monitoring=False,
            ebs_optimized=False,
            placement_tenancy="default",
            metadata_options={
                "http_tokens": "optional",
                "http_put_response_hop_limit": 10,
                "instance_metadata_tags": "enabled",
            },
            cpu_options={
                "threads_per_core": 1,
            },
            instance_types_ondemand="m3.2xlarge",
            instance_types_spots=[
                "m3.xlarge",
                "m3.2xlarge",
            ],
            instance_types_preferred_spots=["m3.xlarge"],
            on_demand_types=["c3.large"],
            instance_types_weights=[
                {
                    "instance_type": "m3.xlarge",
                    "weight": 10,
                },
                {
                    "instance_type": "m3.2xlarge",
                    "weight": 16,
                },
            ],
            resource_requirements=[{
                "excluded_instance_families": [
                    "a",
                    "m",
                ],
                "excluded_instance_types": ["m3.large"],
                "excluded_instance_generations": [
                    "1",
                    "2",
                ],
                "required_gpu_minimum": 1,
                "required_gpu_maximum": 16,
                "required_memory_minimum": 1,
                "required_memory_maximum": 512,
                "required_vcpu_minimum": 1,
                "required_vcpu_maximum": 64,
            }],
            orientation="balanced",
            fallback_to_ondemand=False,
            cpu_credits="unlimited",
            minimum_instance_lifetime=12,
            wait_for_capacity=5,
            wait_for_capacity_timeout=300,
            scaling_strategies=[{
                "terminate_at_end_of_billing_hour": True,
                "termination_policy": "default",
            }],
            scaling_up_policies=[{
                "policy_name": "Default Scaling Up Policy",
                "metric_name": "DefaultQueuesDepth",
                "statistic": "average",
                "unit": "none",
                "adjustment": "1",
                "namespace": "custom",
                "threshold": 100,
                "period": 60,
                "evaluation_periods": 5,
                "cooldown": 300,
            }],
            scaling_down_policies=[{
                "policy_name": "Default Scaling Down Policy",
                "metric_name": "DefaultQueuesDepth",
                "statistic": "average",
                "unit": "none",
                "adjustment": "1",
                "namespace": "custom",
                "threshold": 10,
                "period": 60,
                "evaluation_periods": 10,
                "cooldown": 300,
            }],
            tags=[
                {
                    "key": "Env",
                    "value": "production",
                },
                {
                    "key": "Name",
                    "value": "default-production",
                },
                {
                    "key": "Project",
                    "value": "app_v2",
                },
            ],
            resource_tag_specifications=[{
                "should_tag_enis": True,
                "should_tag_volumes": True,
                "should_tag_snapshots": True,
                "should_tag_amis": True,
            }],
            logging={
                "export": {
                    "s3s": [{
                        "id": "di-123456",
                    }],
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param ElastigroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElastigroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_healing: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 block_devices_mode: Optional[pulumi.Input[str]] = None,
                 capacity_unit: Optional[pulumi.Input[str]] = None,
                 consider_od_pricing: Optional[pulumi.Input[bool]] = None,
                 cpu_credits: Optional[pulumi.Input[str]] = None,
                 cpu_options: Optional[pulumi.Input[Union['ElastigroupCpuOptionsArgs', 'ElastigroupCpuOptionsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 draining_timeout: Optional[pulumi.Input[int]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupEbsBlockDeviceArgs', 'ElastigroupEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 elastic_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_monitoring: Optional[pulumi.Input[bool]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupEphemeralBlockDeviceArgs', 'ElastigroupEphemeralBlockDeviceArgsDict']]]]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[int]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupImageArgs', 'ElastigroupImageArgsDict']]]]] = None,
                 immediate_od_recover_threshold: Optional[pulumi.Input[int]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[str]] = None,
                 instance_types_preferred_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_types_weights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesWeightArgs', 'ElastigroupInstanceTypesWeightArgsDict']]]]] = None,
                 integration_beanstalk: Optional[pulumi.Input[Union['ElastigroupIntegrationBeanstalkArgs', 'ElastigroupIntegrationBeanstalkArgsDict']]] = None,
                 integration_codedeploy: Optional[pulumi.Input[Union['ElastigroupIntegrationCodedeployArgs', 'ElastigroupIntegrationCodedeployArgsDict']]] = None,
                 integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
                 integration_ecs: Optional[pulumi.Input[Union['ElastigroupIntegrationEcsArgs', 'ElastigroupIntegrationEcsArgsDict']]] = None,
                 integration_gitlab: Optional[pulumi.Input[Union['ElastigroupIntegrationGitlabArgs', 'ElastigroupIntegrationGitlabArgsDict']]] = None,
                 integration_kubernetes: Optional[pulumi.Input[Union['ElastigroupIntegrationKubernetesArgs', 'ElastigroupIntegrationKubernetesArgsDict']]] = None,
                 integration_mesosphere: Optional[pulumi.Input[Union['ElastigroupIntegrationMesosphereArgs', 'ElastigroupIntegrationMesosphereArgsDict']]] = None,
                 integration_nomad: Optional[pulumi.Input[Union['ElastigroupIntegrationNomadArgs', 'ElastigroupIntegrationNomadArgsDict']]] = None,
                 integration_rancher: Optional[pulumi.Input[Union['ElastigroupIntegrationRancherArgs', 'ElastigroupIntegrationRancherArgsDict']]] = None,
                 integration_route53: Optional[pulumi.Input[Union['ElastigroupIntegrationRoute53Args', 'ElastigroupIntegrationRoute53ArgsDict']]] = None,
                 itfs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupItfArgs', 'ElastigroupItfArgsDict']]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 lifetime_period: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[Union['ElastigroupLoggingArgs', 'ElastigroupLoggingArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metadata_options: Optional[pulumi.Input[Union['ElastigroupMetadataOptionsArgs', 'ElastigroupMetadataOptionsArgsDict']]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 minimum_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 multiple_metrics: Optional[pulumi.Input[Union['ElastigroupMultipleMetricsArgs', 'ElastigroupMultipleMetricsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
                 on_demand_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ondemand_count: Optional[pulumi.Input[int]] = None,
                 orientation: Optional[pulumi.Input[str]] = None,
                 persist_block_devices: Optional[pulumi.Input[bool]] = None,
                 persist_private_ip: Optional[pulumi.Input[bool]] = None,
                 persist_root_device: Optional[pulumi.Input[bool]] = None,
                 placement_tenancy: Optional[pulumi.Input[str]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceRequirementArgs', 'ElastigroupResourceRequirementArgsDict']]]]] = None,
                 resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceTagSpecificationArgs', 'ElastigroupResourceTagSpecificationArgsDict']]]]] = None,
                 restrict_single_az: Optional[pulumi.Input[bool]] = None,
                 revert_to_spot: Optional[pulumi.Input[Union['ElastigroupRevertToSpotArgs', 'ElastigroupRevertToSpotArgsDict']]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
                 scaling_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingStrategyArgs', 'ElastigroupScalingStrategyArgsDict']]]]] = None,
                 scaling_target_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingTargetPolicyArgs', 'ElastigroupScalingTargetPolicyArgsDict']]]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScheduledTaskArgs', 'ElastigroupScheduledTaskArgsDict']]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shutdown_script: Optional[pulumi.Input[str]] = None,
                 signals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSignalArgs', 'ElastigroupSignalArgsDict']]]]] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 stateful_deallocation: Optional[pulumi.Input[Union['ElastigroupStatefulDeallocationArgs', 'ElastigroupStatefulDeallocationArgsDict']]] = None,
                 stateful_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupStatefulInstanceActionArgs', 'ElastigroupStatefulInstanceActionArgsDict']]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupTagArgs', 'ElastigroupTagArgsDict']]]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['ElastigroupUpdatePolicyArgs', 'ElastigroupUpdatePolicyArgsDict']]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 utilize_commitments: Optional[pulumi.Input[bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[bool]] = None,
                 wait_for_capacity: Optional[pulumi.Input[int]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElastigroupArgs.__new__(ElastigroupArgs)

            __props__.__dict__["auto_healing"] = auto_healing
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["block_devices_mode"] = block_devices_mode
            __props__.__dict__["capacity_unit"] = capacity_unit
            __props__.__dict__["consider_od_pricing"] = consider_od_pricing
            __props__.__dict__["cpu_credits"] = cpu_credits
            __props__.__dict__["cpu_options"] = cpu_options
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["draining_timeout"] = draining_timeout
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["elastic_ips"] = elastic_ips
            __props__.__dict__["elastic_load_balancers"] = elastic_load_balancers
            __props__.__dict__["enable_monitoring"] = enable_monitoring
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            if fallback_to_ondemand is None and not opts.urn:
                raise TypeError("Missing required property 'fallback_to_ondemand'")
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["health_check_grace_period"] = health_check_grace_period
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["health_check_unhealthy_duration_before_replacement"] = health_check_unhealthy_duration_before_replacement
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["images"] = images
            __props__.__dict__["immediate_od_recover_threshold"] = immediate_od_recover_threshold
            __props__.__dict__["instance_types_ondemand"] = instance_types_ondemand
            __props__.__dict__["instance_types_preferred_spots"] = instance_types_preferred_spots
            __props__.__dict__["instance_types_spots"] = instance_types_spots
            __props__.__dict__["instance_types_weights"] = instance_types_weights
            __props__.__dict__["integration_beanstalk"] = integration_beanstalk
            __props__.__dict__["integration_codedeploy"] = integration_codedeploy
            __props__.__dict__["integration_docker_swarm"] = integration_docker_swarm
            __props__.__dict__["integration_ecs"] = integration_ecs
            __props__.__dict__["integration_gitlab"] = integration_gitlab
            __props__.__dict__["integration_kubernetes"] = integration_kubernetes
            __props__.__dict__["integration_mesosphere"] = integration_mesosphere
            __props__.__dict__["integration_nomad"] = integration_nomad
            __props__.__dict__["integration_rancher"] = integration_rancher
            __props__.__dict__["integration_route53"] = integration_route53
            __props__.__dict__["itfs"] = itfs
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["lifetime_period"] = lifetime_period
            __props__.__dict__["logging"] = logging
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["minimum_instance_lifetime"] = minimum_instance_lifetime
            __props__.__dict__["multiple_metrics"] = multiple_metrics
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["on_demand_types"] = on_demand_types
            __props__.__dict__["ondemand_count"] = ondemand_count
            if orientation is None and not opts.urn:
                raise TypeError("Missing required property 'orientation'")
            __props__.__dict__["orientation"] = orientation
            __props__.__dict__["persist_block_devices"] = persist_block_devices
            __props__.__dict__["persist_private_ip"] = persist_private_ip
            __props__.__dict__["persist_root_device"] = persist_root_device
            __props__.__dict__["placement_tenancy"] = placement_tenancy
            __props__.__dict__["preferred_availability_zones"] = preferred_availability_zones
            __props__.__dict__["private_ips"] = private_ips
            if product is None and not opts.urn:
                raise TypeError("Missing required property 'product'")
            __props__.__dict__["product"] = product
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_requirements"] = resource_requirements
            __props__.__dict__["resource_tag_specifications"] = resource_tag_specifications
            __props__.__dict__["restrict_single_az"] = restrict_single_az
            __props__.__dict__["revert_to_spot"] = revert_to_spot
            __props__.__dict__["scaling_down_policies"] = scaling_down_policies
            __props__.__dict__["scaling_strategies"] = scaling_strategies
            __props__.__dict__["scaling_target_policies"] = scaling_target_policies
            __props__.__dict__["scaling_up_policies"] = scaling_up_policies
            __props__.__dict__["scheduled_tasks"] = scheduled_tasks
            if security_groups is None and not opts.urn:
                raise TypeError("Missing required property 'security_groups'")
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["shutdown_script"] = shutdown_script
            __props__.__dict__["signals"] = signals
            __props__.__dict__["spot_percentage"] = spot_percentage
            __props__.__dict__["stateful_deallocation"] = stateful_deallocation
            __props__.__dict__["stateful_instance_actions"] = stateful_instance_actions
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_group_arns"] = target_group_arns
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["utilize_commitments"] = utilize_commitments
            __props__.__dict__["utilize_reserved_instances"] = utilize_reserved_instances
            __props__.__dict__["wait_for_capacity"] = wait_for_capacity
            __props__.__dict__["wait_for_capacity_timeout"] = wait_for_capacity_timeout
        super(Elastigroup, __self__).__init__(
            'spotinst:aws/elastigroup:Elastigroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_healing: Optional[pulumi.Input[bool]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            block_devices_mode: Optional[pulumi.Input[str]] = None,
            capacity_unit: Optional[pulumi.Input[str]] = None,
            consider_od_pricing: Optional[pulumi.Input[bool]] = None,
            cpu_credits: Optional[pulumi.Input[str]] = None,
            cpu_options: Optional[pulumi.Input[Union['ElastigroupCpuOptionsArgs', 'ElastigroupCpuOptionsArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            desired_capacity: Optional[pulumi.Input[int]] = None,
            draining_timeout: Optional[pulumi.Input[int]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupEbsBlockDeviceArgs', 'ElastigroupEbsBlockDeviceArgsDict']]]]] = None,
            ebs_optimized: Optional[pulumi.Input[bool]] = None,
            elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            elastic_load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_monitoring: Optional[pulumi.Input[bool]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupEphemeralBlockDeviceArgs', 'ElastigroupEphemeralBlockDeviceArgsDict']]]]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
            health_check_grace_period: Optional[pulumi.Input[int]] = None,
            health_check_type: Optional[pulumi.Input[str]] = None,
            health_check_unhealthy_duration_before_replacement: Optional[pulumi.Input[int]] = None,
            iam_instance_profile: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupImageArgs', 'ElastigroupImageArgsDict']]]]] = None,
            immediate_od_recover_threshold: Optional[pulumi.Input[int]] = None,
            instance_types_ondemand: Optional[pulumi.Input[str]] = None,
            instance_types_preferred_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            instance_types_spots: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            instance_types_weights: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesWeightArgs', 'ElastigroupInstanceTypesWeightArgsDict']]]]] = None,
            integration_beanstalk: Optional[pulumi.Input[Union['ElastigroupIntegrationBeanstalkArgs', 'ElastigroupIntegrationBeanstalkArgsDict']]] = None,
            integration_codedeploy: Optional[pulumi.Input[Union['ElastigroupIntegrationCodedeployArgs', 'ElastigroupIntegrationCodedeployArgsDict']]] = None,
            integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
            integration_ecs: Optional[pulumi.Input[Union['ElastigroupIntegrationEcsArgs', 'ElastigroupIntegrationEcsArgsDict']]] = None,
            integration_gitlab: Optional[pulumi.Input[Union['ElastigroupIntegrationGitlabArgs', 'ElastigroupIntegrationGitlabArgsDict']]] = None,
            integration_kubernetes: Optional[pulumi.Input[Union['ElastigroupIntegrationKubernetesArgs', 'ElastigroupIntegrationKubernetesArgsDict']]] = None,
            integration_mesosphere: Optional[pulumi.Input[Union['ElastigroupIntegrationMesosphereArgs', 'ElastigroupIntegrationMesosphereArgsDict']]] = None,
            integration_nomad: Optional[pulumi.Input[Union['ElastigroupIntegrationNomadArgs', 'ElastigroupIntegrationNomadArgsDict']]] = None,
            integration_rancher: Optional[pulumi.Input[Union['ElastigroupIntegrationRancherArgs', 'ElastigroupIntegrationRancherArgsDict']]] = None,
            integration_route53: Optional[pulumi.Input[Union['ElastigroupIntegrationRoute53Args', 'ElastigroupIntegrationRoute53ArgsDict']]] = None,
            itfs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupItfArgs', 'ElastigroupItfArgsDict']]]]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            lifetime_period: Optional[pulumi.Input[str]] = None,
            logging: Optional[pulumi.Input[Union['ElastigroupLoggingArgs', 'ElastigroupLoggingArgsDict']]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            metadata_options: Optional[pulumi.Input[Union['ElastigroupMetadataOptionsArgs', 'ElastigroupMetadataOptionsArgsDict']]] = None,
            min_size: Optional[pulumi.Input[int]] = None,
            minimum_instance_lifetime: Optional[pulumi.Input[int]] = None,
            multiple_metrics: Optional[pulumi.Input[Union['ElastigroupMultipleMetricsArgs', 'ElastigroupMultipleMetricsArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
            on_demand_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ondemand_count: Optional[pulumi.Input[int]] = None,
            orientation: Optional[pulumi.Input[str]] = None,
            persist_block_devices: Optional[pulumi.Input[bool]] = None,
            persist_private_ip: Optional[pulumi.Input[bool]] = None,
            persist_root_device: Optional[pulumi.Input[bool]] = None,
            placement_tenancy: Optional[pulumi.Input[str]] = None,
            preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            product: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resource_requirements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceRequirementArgs', 'ElastigroupResourceRequirementArgsDict']]]]] = None,
            resource_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceTagSpecificationArgs', 'ElastigroupResourceTagSpecificationArgsDict']]]]] = None,
            restrict_single_az: Optional[pulumi.Input[bool]] = None,
            revert_to_spot: Optional[pulumi.Input[Union['ElastigroupRevertToSpotArgs', 'ElastigroupRevertToSpotArgsDict']]] = None,
            scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
            scaling_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingStrategyArgs', 'ElastigroupScalingStrategyArgsDict']]]]] = None,
            scaling_target_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingTargetPolicyArgs', 'ElastigroupScalingTargetPolicyArgsDict']]]]] = None,
            scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
            scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScheduledTaskArgs', 'ElastigroupScheduledTaskArgsDict']]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            shutdown_script: Optional[pulumi.Input[str]] = None,
            signals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSignalArgs', 'ElastigroupSignalArgsDict']]]]] = None,
            spot_percentage: Optional[pulumi.Input[int]] = None,
            stateful_deallocation: Optional[pulumi.Input[Union['ElastigroupStatefulDeallocationArgs', 'ElastigroupStatefulDeallocationArgsDict']]] = None,
            stateful_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupStatefulInstanceActionArgs', 'ElastigroupStatefulInstanceActionArgsDict']]]]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupTagArgs', 'ElastigroupTagArgsDict']]]]] = None,
            target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            update_policy: Optional[pulumi.Input[Union['ElastigroupUpdatePolicyArgs', 'ElastigroupUpdatePolicyArgsDict']]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            utilize_commitments: Optional[pulumi.Input[bool]] = None,
            utilize_reserved_instances: Optional[pulumi.Input[bool]] = None,
            wait_for_capacity: Optional[pulumi.Input[int]] = None,
            wait_for_capacity_timeout: Optional[pulumi.Input[int]] = None) -> 'Elastigroup':
        """
        Get an existing Elastigroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_healing: Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
               Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
               `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        :param pulumi.Input[str] capacity_unit: The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        :param pulumi.Input[str] cpu_credits: Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[Union['ElastigroupCpuOptionsArgs', 'ElastigroupCpuOptionsArgsDict']] cpu_options: The CPU options for the instances that are launched within the group:
        :param pulumi.Input[str] description: The group description.
        :param pulumi.Input[int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elastic_ips: A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        :param pulumi.Input[bool] enable_monitoring: Indicates whether monitoring is enabled for the instance.
        :param pulumi.Input[bool] fallback_to_ondemand: In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        :param pulumi.Input[int] health_check_grace_period: The amount of time, in seconds, after the instance has launched to starts and check its health.
        :param pulumi.Input[str] health_check_type: The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        :param pulumi.Input[int] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: The ID of the AMI used to launch the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupImageArgs', 'ElastigroupImageArgsDict']]]] images: An array of image objects. 
               Note: Elastigroup can be configured with either imageId or images, but not both.
        :param pulumi.Input[str] instance_types_ondemand: The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_preferred_spots: Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types_spots: One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesWeightArgs', 'ElastigroupInstanceTypesWeightArgsDict']]]] instance_types_weights: List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        :param pulumi.Input[str] key_name: The key name that should be used for the instance.
        :param pulumi.Input[Union['ElastigroupLoggingArgs', 'ElastigroupLoggingArgsDict']] logging: Logging configuration.
        :param pulumi.Input[int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[Union['ElastigroupMetadataOptionsArgs', 'ElastigroupMetadataOptionsArgsDict']] metadata_options: Data that used to configure or manage the running instances:
        :param pulumi.Input[int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[int] minimum_instance_lifetime: Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        :param pulumi.Input[str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] on_demand_types: Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        :param pulumi.Input[int] ondemand_count: Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        :param pulumi.Input[str] orientation: Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        :param pulumi.Input[str] placement_tenancy: Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_availability_zones: The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
               Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
               For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        :param pulumi.Input[str] region: The AWS region your group will be created in.
               Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceRequirementArgs', 'ElastigroupResourceRequirementArgsDict']]]] resource_requirements: Required instance attributes. Instance types will be selected based on these requirements.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupResourceTagSpecificationArgs', 'ElastigroupResourceTagSpecificationArgsDict']]]] resource_tag_specifications: User will specify which resources should be tagged with group tags.
        :param pulumi.Input[bool] restrict_single_az: Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        :param pulumi.Input[Union['ElastigroupRevertToSpotArgs', 'ElastigroupRevertToSpotArgsDict']] revert_to_spot: Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingStrategyArgs', 'ElastigroupScalingStrategyArgsDict']]]] scaling_strategies: Set termination policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: A list of associated security group IDS.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of Strings of subnet identifiers.
               Note: When this parameter is set, `availability_zones` should be left unused.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupTagArgs', 'ElastigroupTagArgsDict']]]] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_data: The user data to provide when launching the instance.
        :param pulumi.Input[bool] utilize_reserved_instances: In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        :param pulumi.Input[int] wait_for_capacity: Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        :param pulumi.Input[int] wait_for_capacity_timeout: Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElastigroupState.__new__(_ElastigroupState)

        __props__.__dict__["auto_healing"] = auto_healing
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["block_devices_mode"] = block_devices_mode
        __props__.__dict__["capacity_unit"] = capacity_unit
        __props__.__dict__["consider_od_pricing"] = consider_od_pricing
        __props__.__dict__["cpu_credits"] = cpu_credits
        __props__.__dict__["cpu_options"] = cpu_options
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["draining_timeout"] = draining_timeout
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["elastic_ips"] = elastic_ips
        __props__.__dict__["elastic_load_balancers"] = elastic_load_balancers
        __props__.__dict__["enable_monitoring"] = enable_monitoring
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["health_check_grace_period"] = health_check_grace_period
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["health_check_unhealthy_duration_before_replacement"] = health_check_unhealthy_duration_before_replacement
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["images"] = images
        __props__.__dict__["immediate_od_recover_threshold"] = immediate_od_recover_threshold
        __props__.__dict__["instance_types_ondemand"] = instance_types_ondemand
        __props__.__dict__["instance_types_preferred_spots"] = instance_types_preferred_spots
        __props__.__dict__["instance_types_spots"] = instance_types_spots
        __props__.__dict__["instance_types_weights"] = instance_types_weights
        __props__.__dict__["integration_beanstalk"] = integration_beanstalk
        __props__.__dict__["integration_codedeploy"] = integration_codedeploy
        __props__.__dict__["integration_docker_swarm"] = integration_docker_swarm
        __props__.__dict__["integration_ecs"] = integration_ecs
        __props__.__dict__["integration_gitlab"] = integration_gitlab
        __props__.__dict__["integration_kubernetes"] = integration_kubernetes
        __props__.__dict__["integration_mesosphere"] = integration_mesosphere
        __props__.__dict__["integration_nomad"] = integration_nomad
        __props__.__dict__["integration_rancher"] = integration_rancher
        __props__.__dict__["integration_route53"] = integration_route53
        __props__.__dict__["itfs"] = itfs
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["lifetime_period"] = lifetime_period
        __props__.__dict__["logging"] = logging
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["minimum_instance_lifetime"] = minimum_instance_lifetime
        __props__.__dict__["multiple_metrics"] = multiple_metrics
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["on_demand_types"] = on_demand_types
        __props__.__dict__["ondemand_count"] = ondemand_count
        __props__.__dict__["orientation"] = orientation
        __props__.__dict__["persist_block_devices"] = persist_block_devices
        __props__.__dict__["persist_private_ip"] = persist_private_ip
        __props__.__dict__["persist_root_device"] = persist_root_device
        __props__.__dict__["placement_tenancy"] = placement_tenancy
        __props__.__dict__["preferred_availability_zones"] = preferred_availability_zones
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["product"] = product
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_requirements"] = resource_requirements
        __props__.__dict__["resource_tag_specifications"] = resource_tag_specifications
        __props__.__dict__["restrict_single_az"] = restrict_single_az
        __props__.__dict__["revert_to_spot"] = revert_to_spot
        __props__.__dict__["scaling_down_policies"] = scaling_down_policies
        __props__.__dict__["scaling_strategies"] = scaling_strategies
        __props__.__dict__["scaling_target_policies"] = scaling_target_policies
        __props__.__dict__["scaling_up_policies"] = scaling_up_policies
        __props__.__dict__["scheduled_tasks"] = scheduled_tasks
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["shutdown_script"] = shutdown_script
        __props__.__dict__["signals"] = signals
        __props__.__dict__["spot_percentage"] = spot_percentage
        __props__.__dict__["stateful_deallocation"] = stateful_deallocation
        __props__.__dict__["stateful_instance_actions"] = stateful_instance_actions
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_group_arns"] = target_group_arns
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["utilize_commitments"] = utilize_commitments
        __props__.__dict__["utilize_reserved_instances"] = utilize_reserved_instances
        __props__.__dict__["wait_for_capacity"] = wait_for_capacity
        __props__.__dict__["wait_for_capacity_timeout"] = wait_for_capacity_timeout
        return Elastigroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> pulumi.Output[Optional[bool]]:
        """
        Auto-healing replacement won't be triggered if this parameter value is "false". In a case of a stateful group - no recycling will start if this parameter value is "false".
        """
        return pulumi.get(self, "auto_healing")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
        Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
        `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="blockDevicesMode")
    def block_devices_mode(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "block_devices_mode")

    @property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> pulumi.Output[str]:
        """
        The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs. Valid values: `instance`, `weight`.
        """
        return pulumi.get(self, "capacity_unit")

    @property
    @pulumi.getter(name="considerOdPricing")
    def consider_od_pricing(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "consider_od_pricing")

    @property
    @pulumi.getter(name="cpuCredits")
    def cpu_credits(self) -> pulumi.Output[Optional[str]]:
        """
        Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        """
        return pulumi.get(self, "cpu_credits")

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> pulumi.Output[Optional['outputs.ElastigroupCpuOptions']]:
        """
        The CPU options for the instances that are launched within the group:
        """
        return pulumi.get(self, "cpu_options")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The desired number of instances the group should have at any time.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> pulumi.Output[int]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupEbsBlockDevice']]]:
        return pulumi.get(self, "ebs_block_devices")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[bool]:
        """
        Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="elasticIps")
    def elastic_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        """
        return pulumi.get(self, "elastic_ips")

    @property
    @pulumi.getter(name="elasticLoadBalancers")
    def elastic_load_balancers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "elastic_load_balancers")

    @property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether monitoring is enabled for the instance.
        """
        return pulumi.get(self, "enable_monitoring")

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupEphemeralBlockDevice']]]:
        return pulumi.get(self, "ephemeral_block_devices")

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[bool]:
        """
        In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time, in seconds, after the instance has launched to starts and check its health.
        """
        return pulumi.get(self, "health_check_grace_period")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[Optional[str]]:
        """
        The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"EC2"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="healthCheckUnhealthyDurationBeforeReplacement")
    def health_check_unhealthy_duration_before_replacement(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        """
        return pulumi.get(self, "health_check_unhealthy_duration_before_replacement")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN or name of an IAM instance profile to associate with launched instances.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the AMI used to launch the instance.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def images(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupImage']]]:
        """
        An array of image objects. 
        Note: Elastigroup can be configured with either imageId or images, but not both.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="immediateOdRecoverThreshold")
    def immediate_od_recover_threshold(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "immediate_od_recover_threshold")

    @property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> pulumi.Output[Optional[str]]:
        """
        The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        """
        return pulumi.get(self, "instance_types_ondemand")

    @property
    @pulumi.getter(name="instanceTypesPreferredSpots")
    def instance_types_preferred_spots(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        """
        return pulumi.get(self, "instance_types_preferred_spots")

    @property
    @pulumi.getter(name="instanceTypesSpots")
    def instance_types_spots(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        One or more instance types. Note: Cannot be defined if 'resourceRequirements' is defined.
        """
        return pulumi.get(self, "instance_types_spots")

    @property
    @pulumi.getter(name="instanceTypesWeights")
    def instance_types_weights(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupInstanceTypesWeight']]]:
        """
        List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        """
        return pulumi.get(self, "instance_types_weights")

    @property
    @pulumi.getter(name="integrationBeanstalk")
    def integration_beanstalk(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationBeanstalk']]:
        return pulumi.get(self, "integration_beanstalk")

    @property
    @pulumi.getter(name="integrationCodedeploy")
    def integration_codedeploy(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationCodedeploy']]:
        return pulumi.get(self, "integration_codedeploy")

    @property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationDockerSwarm']]:
        return pulumi.get(self, "integration_docker_swarm")

    @property
    @pulumi.getter(name="integrationEcs")
    def integration_ecs(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationEcs']]:
        return pulumi.get(self, "integration_ecs")

    @property
    @pulumi.getter(name="integrationGitlab")
    def integration_gitlab(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationGitlab']]:
        return pulumi.get(self, "integration_gitlab")

    @property
    @pulumi.getter(name="integrationKubernetes")
    def integration_kubernetes(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationKubernetes']]:
        return pulumi.get(self, "integration_kubernetes")

    @property
    @pulumi.getter(name="integrationMesosphere")
    def integration_mesosphere(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationMesosphere']]:
        return pulumi.get(self, "integration_mesosphere")

    @property
    @pulumi.getter(name="integrationNomad")
    def integration_nomad(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationNomad']]:
        return pulumi.get(self, "integration_nomad")

    @property
    @pulumi.getter(name="integrationRancher")
    def integration_rancher(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationRancher']]:
        return pulumi.get(self, "integration_rancher")

    @property
    @pulumi.getter(name="integrationRoute53")
    def integration_route53(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationRoute53']]:
        return pulumi.get(self, "integration_route53")

    @property
    @pulumi.getter
    def itfs(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupItf']]]:
        return pulumi.get(self, "itfs")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The key name that should be used for the instance.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="lifetimePeriod")
    def lifetime_period(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "lifetime_period")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.ElastigroupLogging']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[int]:
        """
        The maximum number of instances the group should have at any time.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output[Optional['outputs.ElastigroupMetadataOptions']]:
        """
        Data that used to configure or manage the running instances:
        """
        return pulumi.get(self, "metadata_options")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[int]:
        """
        The minimum number of instances the group should have at any time.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minimumInstanceLifetime")
    def minimum_instance_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        Defines the preferred minimum instance lifetime in hours. Markets which comply with this preference will be prioritized. Optional values: 1, 3, 6, 12, 24.
        """
        return pulumi.get(self, "minimum_instance_lifetime")

    @property
    @pulumi.getter(name="multipleMetrics")
    def multiple_metrics(self) -> pulumi.Output[Optional['outputs.ElastigroupMultipleMetrics']]:
        return pulumi.get(self, "multiple_metrics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupNetworkInterface']]]:
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="onDemandTypes")
    def on_demand_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Available ondemand instance types. Note: Either ondemand or onDemandTypes must be defined, but not both.
        """
        return pulumi.get(self, "on_demand_types")

    @property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> pulumi.Output[Optional[int]]:
        """
        Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        """
        return pulumi.get(self, "ondemand_count")

    @property
    @pulumi.getter
    def orientation(self) -> pulumi.Output[str]:
        """
        Select a prediction strategy. Valid values: `balanced`, `costOriented`, `equalAzDistribution`, `availabilityOriented`. You can read more in our documentation.
        """
        return pulumi.get(self, "orientation")

    @property
    @pulumi.getter(name="persistBlockDevices")
    def persist_block_devices(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "persist_block_devices")

    @property
    @pulumi.getter(name="persistPrivateIp")
    def persist_private_ip(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "persist_private_ip")

    @property
    @pulumi.getter(name="persistRootDevice")
    def persist_root_device(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "persist_root_device")

    @property
    @pulumi.getter(name="placementTenancy")
    def placement_tenancy(self) -> pulumi.Output[Optional[str]]:
        """
        Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used. Valid values: "default", "dedicated" .
        """
        return pulumi.get(self, "placement_tenancy")

    @property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
        Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter
    def product(self) -> pulumi.Output[str]:
        """
        Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
        For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS region your group will be created in.
        Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupResourceRequirement']]]:
        """
        Required instance attributes. Instance types will be selected based on these requirements.
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter(name="resourceTagSpecifications")
    def resource_tag_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupResourceTagSpecification']]]:
        """
        User will specify which resources should be tagged with group tags.
        """
        return pulumi.get(self, "resource_tag_specifications")

    @property
    @pulumi.getter(name="restrictSingleAz")
    def restrict_single_az(self) -> pulumi.Output[Optional[bool]]:
        """
        Elastigroup will automatically scale your instances in the most available and cost efficient availability zone. Every evaluation will be done when there are no active instances in the group.
        """
        return pulumi.get(self, "restrict_single_az")

    @property
    @pulumi.getter(name="revertToSpot")
    def revert_to_spot(self) -> pulumi.Output[Optional['outputs.ElastigroupRevertToSpot']]:
        """
        Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        """
        return pulumi.get(self, "revert_to_spot")

    @property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingDownPolicy']]]:
        return pulumi.get(self, "scaling_down_policies")

    @property
    @pulumi.getter(name="scalingStrategies")
    def scaling_strategies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingStrategy']]]:
        """
        Set termination policy.
        """
        return pulumi.get(self, "scaling_strategies")

    @property
    @pulumi.getter(name="scalingTargetPolicies")
    def scaling_target_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingTargetPolicy']]]:
        return pulumi.get(self, "scaling_target_policies")

    @property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingUpPolicy']]]:
        return pulumi.get(self, "scaling_up_policies")

    @property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScheduledTask']]]:
        return pulumi.get(self, "scheduled_tasks")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of associated security group IDS.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> pulumi.Output[Optional[str]]:
        """
        The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        """
        return pulumi.get(self, "shutdown_script")

    @property
    @pulumi.getter
    def signals(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupSignal']]]:
        return pulumi.get(self, "signals")

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> pulumi.Output[Optional[int]]:
        """
        The percentage of Spot instances that would spin up from the `desired_capacity` number.
        """
        return pulumi.get(self, "spot_percentage")

    @property
    @pulumi.getter(name="statefulDeallocation")
    def stateful_deallocation(self) -> pulumi.Output[Optional['outputs.ElastigroupStatefulDeallocation']]:
        return pulumi.get(self, "stateful_deallocation")

    @property
    @pulumi.getter(name="statefulInstanceActions")
    def stateful_instance_actions(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupStatefulInstanceAction']]]:
        return pulumi.get(self, "stateful_instance_actions")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Strings of subnet identifiers.
        Note: When this parameter is set, `availability_zones` should be left unused.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupTag']]]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.ElastigroupUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        The user data to provide when launching the instance.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "utilize_commitments")

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> pulumi.Output[Optional[bool]]:
        """
        In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @property
    @pulumi.getter(name="waitForCapacity")
    def wait_for_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        """
        return pulumi.get(self, "wait_for_capacity")

    @property
    @pulumi.getter(name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment.
        """
        return pulumi.get(self, "wait_for_capacity_timeout")

