# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BeanstalkDeploymentPreferences',
    'BeanstalkDeploymentPreferencesStrategy',
    'BeanstalkManagedActions',
    'BeanstalkManagedActionsPlatformUpdate',
    'BeanstalkScheduledTask',
    'ElastigroupCpuOptions',
    'ElastigroupEbsBlockDevice',
    'ElastigroupEbsBlockDeviceDynamicIops',
    'ElastigroupEbsBlockDeviceDynamicVolumeSize',
    'ElastigroupEphemeralBlockDevice',
    'ElastigroupImage',
    'ElastigroupImageImage',
    'ElastigroupInstanceTypesWeight',
    'ElastigroupIntegrationBeanstalk',
    'ElastigroupIntegrationBeanstalkDeploymentPreferences',
    'ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy',
    'ElastigroupIntegrationBeanstalkManagedActions',
    'ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate',
    'ElastigroupIntegrationCodedeploy',
    'ElastigroupIntegrationCodedeployDeploymentGroup',
    'ElastigroupIntegrationDockerSwarm',
    'ElastigroupIntegrationDockerSwarmAutoscaleDown',
    'ElastigroupIntegrationDockerSwarmAutoscaleHeadroom',
    'ElastigroupIntegrationEcs',
    'ElastigroupIntegrationEcsAutoscaleAttribute',
    'ElastigroupIntegrationEcsAutoscaleDown',
    'ElastigroupIntegrationEcsAutoscaleHeadroom',
    'ElastigroupIntegrationEcsBatch',
    'ElastigroupIntegrationGitlab',
    'ElastigroupIntegrationGitlabRunner',
    'ElastigroupIntegrationKubernetes',
    'ElastigroupIntegrationKubernetesAutoscaleDown',
    'ElastigroupIntegrationKubernetesAutoscaleHeadroom',
    'ElastigroupIntegrationKubernetesAutoscaleLabel',
    'ElastigroupIntegrationMesosphere',
    'ElastigroupIntegrationNomad',
    'ElastigroupIntegrationNomadAutoscaleConstraint',
    'ElastigroupIntegrationNomadAutoscaleDown',
    'ElastigroupIntegrationNomadAutoscaleHeadroom',
    'ElastigroupIntegrationRancher',
    'ElastigroupIntegrationRoute53',
    'ElastigroupIntegrationRoute53Domain',
    'ElastigroupIntegrationRoute53DomainRecordSet',
    'ElastigroupItf',
    'ElastigroupItfDefaultStaticTargetGroup',
    'ElastigroupItfLoadBalancer',
    'ElastigroupItfLoadBalancerListenerRule',
    'ElastigroupItfLoadBalancerListenerRuleStaticTargetGroup',
    'ElastigroupItfTargetGroupConfig',
    'ElastigroupItfTargetGroupConfigMatcher',
    'ElastigroupItfTargetGroupConfigTag',
    'ElastigroupLogging',
    'ElastigroupLoggingExport',
    'ElastigroupLoggingExportS3',
    'ElastigroupMetadataOptions',
    'ElastigroupMultipleMetrics',
    'ElastigroupMultipleMetricsExpression',
    'ElastigroupMultipleMetricsMetric',
    'ElastigroupMultipleMetricsMetricDimension',
    'ElastigroupNetworkInterface',
    'ElastigroupResourceRequirement',
    'ElastigroupResourceTagSpecification',
    'ElastigroupRevertToSpot',
    'ElastigroupScalingDownPolicy',
    'ElastigroupScalingDownPolicyDimension',
    'ElastigroupScalingDownPolicyStepAdjustment',
    'ElastigroupScalingDownPolicyStepAdjustmentAction',
    'ElastigroupScalingStrategy',
    'ElastigroupScalingTargetPolicy',
    'ElastigroupScalingTargetPolicyDimension',
    'ElastigroupScalingUpPolicy',
    'ElastigroupScalingUpPolicyDimension',
    'ElastigroupScalingUpPolicyStepAdjustment',
    'ElastigroupScalingUpPolicyStepAdjustmentAction',
    'ElastigroupScheduledTask',
    'ElastigroupSignal',
    'ElastigroupStatefulDeallocation',
    'ElastigroupStatefulInstanceAction',
    'ElastigroupTag',
    'ElastigroupUpdatePolicy',
    'ElastigroupUpdatePolicyRollConfig',
    'ElastigroupUpdatePolicyRollConfigStrategy',
    'ElastigroupUpdatePolicyRollConfigStrategyOnFailure',
    'ManagedInstanceBlockDeviceMapping',
    'ManagedInstanceBlockDeviceMappingEbs',
    'ManagedInstanceDelete',
    'ManagedInstanceIntegrationRoute53',
    'ManagedInstanceIntegrationRoute53Domain',
    'ManagedInstanceIntegrationRoute53DomainRecordSet',
    'ManagedInstanceLoadBalancer',
    'ManagedInstanceManagedInstanceAction',
    'ManagedInstanceMetadataOptions',
    'ManagedInstanceNetworkInterface',
    'ManagedInstanceResourceTagSpecification',
    'ManagedInstanceRevertToSpot',
    'ManagedInstanceScheduledTask',
    'ManagedInstanceTag',
    'MrScalarApplication',
    'MrScalarBootstrapActionsFile',
    'MrScalarConfigurationsFile',
    'MrScalarCoreEbsBlockDevice',
    'MrScalarCoreScalingDownPolicy',
    'MrScalarCoreScalingUpPolicy',
    'MrScalarInstanceWeight',
    'MrScalarMasterEbsBlockDevice',
    'MrScalarProvisioningTimeout',
    'MrScalarScheduledTask',
    'MrScalarStepsFile',
    'MrScalarTag',
    'MrScalarTaskEbsBlockDevice',
    'MrScalarTaskScalingDownPolicy',
    'MrScalarTaskScalingUpPolicy',
    'MrScalarTerminationPolicy',
    'MrScalarTerminationPolicyStatement',
    'OceanAttachLoadBalancer',
    'OceanAutoscaler',
    'OceanAutoscalerAutoscaleDown',
    'OceanAutoscalerAutoscaleHeadroom',
    'OceanAutoscalerResourceLimits',
    'OceanBlockDeviceMapping',
    'OceanBlockDeviceMappingEbs',
    'OceanBlockDeviceMappingEbsDynamicIops',
    'OceanBlockDeviceMappingEbsDynamicVolumeSize',
    'OceanClusterOrientation',
    'OceanDetachLoadBalancer',
    'OceanFilters',
    'OceanInstanceMetadataOptions',
    'OceanLaunchSpecAutoscaleDown',
    'OceanLaunchSpecAutoscaleHeadroom',
    'OceanLaunchSpecAutoscaleHeadroomsAutomatic',
    'OceanLaunchSpecBlockDeviceMapping',
    'OceanLaunchSpecBlockDeviceMappingEbs',
    'OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize',
    'OceanLaunchSpecCreateOptions',
    'OceanLaunchSpecDeleteOptions',
    'OceanLaunchSpecElasticIpPool',
    'OceanLaunchSpecElasticIpPoolTagSelector',
    'OceanLaunchSpecEphemeralStorage',
    'OceanLaunchSpecImage',
    'OceanLaunchSpecInstanceMetadataOptions',
    'OceanLaunchSpecInstanceTypesFilters',
    'OceanLaunchSpecLabel',
    'OceanLaunchSpecResourceLimit',
    'OceanLaunchSpecSchedulingShutdownHours',
    'OceanLaunchSpecSchedulingTask',
    'OceanLaunchSpecSchedulingTaskTaskHeadroom',
    'OceanLaunchSpecStrategy',
    'OceanLaunchSpecTag',
    'OceanLaunchSpecTaint',
    'OceanLaunchSpecUpdatePolicy',
    'OceanLaunchSpecUpdatePolicyRollConfig',
    'OceanLoadBalancer',
    'OceanLogging',
    'OceanLoggingExport',
    'OceanLoggingExportS3',
    'OceanResourceTagSpecification',
    'OceanScheduledTask',
    'OceanScheduledTaskShutdownHours',
    'OceanScheduledTaskTask',
    'OceanScheduledTaskTaskParameters',
    'OceanScheduledTaskTaskParametersAmiAutoUpdate',
    'OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll',
    'OceanScheduledTaskTaskParametersParametersClusterRoll',
    'OceanTag',
    'OceanUpdatePolicy',
    'OceanUpdatePolicyRollConfig',
    'SuspensionSuspension',
]

@pulumi.output_type
class BeanstalkDeploymentPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticRoll":
            suggest = "automatic_roll"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BeanstalkDeploymentPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BeanstalkDeploymentPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BeanstalkDeploymentPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_roll: Optional[bool] = None,
                 batch_size_percentage: Optional[int] = None,
                 grace_period: Optional[int] = None,
                 strategies: Optional[Sequence['outputs.BeanstalkDeploymentPreferencesStrategy']] = None):
        """
        :param bool automatic_roll: Should roll perform automatically
        :param int batch_size_percentage: Percent size of each batch
        :param int grace_period: Amount of time to wait between batches
        :param Sequence['BeanstalkDeploymentPreferencesStrategyArgs'] strategies: Strategy parameters
        """
        if automatic_roll is not None:
            pulumi.set(__self__, "automatic_roll", automatic_roll)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)

    @property
    @pulumi.getter(name="automaticRoll")
    def automatic_roll(self) -> Optional[bool]:
        """
        Should roll perform automatically
        """
        return pulumi.get(self, "automatic_roll")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[int]:
        """
        Percent size of each batch
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[int]:
        """
        Amount of time to wait between batches
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter
    def strategies(self) -> Optional[Sequence['outputs.BeanstalkDeploymentPreferencesStrategy']]:
        """
        Strategy parameters
        """
        return pulumi.get(self, "strategies")


@pulumi.output_type
class BeanstalkDeploymentPreferencesStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldDrainInstances":
            suggest = "should_drain_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BeanstalkDeploymentPreferencesStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BeanstalkDeploymentPreferencesStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BeanstalkDeploymentPreferencesStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 should_drain_instances: Optional[bool] = None):
        """
        :param str action: Action to take
        :param bool should_drain_instances: Bool value if to wait to drain instance
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if should_drain_instances is not None:
            pulumi.set(__self__, "should_drain_instances", should_drain_instances)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Action to take
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="shouldDrainInstances")
    def should_drain_instances(self) -> Optional[bool]:
        """
        Bool value if to wait to drain instance
        """
        return pulumi.get(self, "should_drain_instances")


@pulumi.output_type
class BeanstalkManagedActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "platformUpdate":
            suggest = "platform_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BeanstalkManagedActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BeanstalkManagedActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BeanstalkManagedActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 platform_update: Optional['outputs.BeanstalkManagedActionsPlatformUpdate'] = None):
        """
        :param 'BeanstalkManagedActionsPlatformUpdateArgs' platform_update: Platform Update parameters
        """
        if platform_update is not None:
            pulumi.set(__self__, "platform_update", platform_update)

    @property
    @pulumi.getter(name="platformUpdate")
    def platform_update(self) -> Optional['outputs.BeanstalkManagedActionsPlatformUpdate']:
        """
        Platform Update parameters
        """
        return pulumi.get(self, "platform_update")


@pulumi.output_type
class BeanstalkManagedActionsPlatformUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"
        elif key == "timeWindow":
            suggest = "time_window"
        elif key == "updateLevel":
            suggest = "update_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BeanstalkManagedActionsPlatformUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BeanstalkManagedActionsPlatformUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BeanstalkManagedActionsPlatformUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: Optional[str] = None,
                 time_window: Optional[str] = None,
                 update_level: Optional[str] = None):
        """
        :param str perform_at: Actions to perform (options: timeWindow, never)
        :param str time_window: Time Window for when action occurs ex. Mon:23:50-Tue:00:20
        :param str update_level: Level to update
        """
        if perform_at is not None:
            pulumi.set(__self__, "perform_at", perform_at)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)
        if update_level is not None:
            pulumi.set(__self__, "update_level", update_level)

    @property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> Optional[str]:
        """
        Actions to perform (options: timeWindow, never)
        """
        return pulumi.get(self, "perform_at")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[str]:
        """
        Time Window for when action occurs ex. Mon:23:50-Tue:00:20
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter(name="updateLevel")
    def update_level(self) -> Optional[str]:
        """
        Level to update
        """
        return pulumi.get(self, "update_level")


@pulumi.output_type
class BeanstalkScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "adjustmentPercentage":
            suggest = "adjustment_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "cronExpression":
            suggest = "cron_expression"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "scaleMaxCapacity":
            suggest = "scale_max_capacity"
        elif key == "scaleMinCapacity":
            suggest = "scale_min_capacity"
        elif key == "scaleTargetCapacity":
            suggest = "scale_target_capacity"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BeanstalkScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BeanstalkScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BeanstalkScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 adjustment: Optional[str] = None,
                 adjustment_percentage: Optional[str] = None,
                 batch_size_percentage: Optional[str] = None,
                 cron_expression: Optional[str] = None,
                 frequency: Optional[str] = None,
                 grace_period: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 max_capacity: Optional[str] = None,
                 min_capacity: Optional[str] = None,
                 scale_max_capacity: Optional[str] = None,
                 scale_min_capacity: Optional[str] = None,
                 scale_target_capacity: Optional[str] = None,
                 start_time: Optional[str] = None,
                 target_capacity: Optional[str] = None):
        """
        :param str task_type: The task type to run. Supported task types are: `"scale"`, `"backup_ami"`, `"roll"`, `"scaleUp"`, `"percentageScaleUp"`, `"scaleDown"`, `"percentageScaleDown"`, `"statefulUpdateCapacity"`.
        :param str adjustment: The number of instances to add or remove.
        :param str adjustment_percentage: The percentage of instances to add or remove.
               
               Usage:
        :param str batch_size_percentage: The percentage size of each batch in the scheduled deployment roll.
        :param str cron_expression: A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        :param str frequency: The recurrence frequency to run this task. Supported values are `"hourly"`, `"daily"`, `"weekly"` and `"continuous"`.
        :param str grace_period: The period of time (seconds) to wait before checking a batch's health after it's deployment.
        :param bool is_enabled: Setting the task to being enabled or disabled.
        :param str max_capacity: The maximum number of instances the group should have.
        :param str min_capacity: The minimum number of instances the group should have.
        :param str scale_max_capacity: The maximum number of instances the group should have.
        :param str scale_min_capacity: The minimum number of instances the group should have.
        :param str scale_target_capacity: The desired number of instances the group should have.
        :param str start_time: Set a start time for one time tasks.
        :param str target_capacity: The desired number of instances the group should have.
        """
        pulumi.set(__self__, "task_type", task_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if adjustment_percentage is not None:
            pulumi.set(__self__, "adjustment_percentage", adjustment_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if scale_max_capacity is not None:
            pulumi.set(__self__, "scale_max_capacity", scale_max_capacity)
        if scale_min_capacity is not None:
            pulumi.set(__self__, "scale_min_capacity", scale_min_capacity)
        if scale_target_capacity is not None:
            pulumi.set(__self__, "scale_target_capacity", scale_target_capacity)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        The task type to run. Supported task types are: `"scale"`, `"backup_ami"`, `"roll"`, `"scaleUp"`, `"percentageScaleUp"`, `"scaleDown"`, `"percentageScaleDown"`, `"statefulUpdateCapacity"`.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add or remove.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter(name="adjustmentPercentage")
    def adjustment_percentage(self) -> Optional[str]:
        """
        The percentage of instances to add or remove.

        Usage:
        """
        return pulumi.get(self, "adjustment_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[str]:
        """
        The percentage size of each batch in the scheduled deployment roll.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[str]:
        """
        A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        The recurrence frequency to run this task. Supported values are `"hourly"`, `"daily"`, `"weekly"` and `"continuous"`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[str]:
        """
        The period of time (seconds) to wait before checking a batch's health after it's deployment.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Setting the task to being enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[str]:
        """
        The maximum number of instances the group should have.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[str]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="scaleMaxCapacity")
    def scale_max_capacity(self) -> Optional[str]:
        """
        The maximum number of instances the group should have.
        """
        return pulumi.get(self, "scale_max_capacity")

    @property
    @pulumi.getter(name="scaleMinCapacity")
    def scale_min_capacity(self) -> Optional[str]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "scale_min_capacity")

    @property
    @pulumi.getter(name="scaleTargetCapacity")
    def scale_target_capacity(self) -> Optional[str]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "scale_target_capacity")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Set a start time for one time tasks.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[str]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ElastigroupCpuOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threadsPerCore":
            suggest = "threads_per_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupCpuOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupCpuOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupCpuOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 threads_per_core: int):
        """
        :param int threads_per_core: The ability to define the number of threads per core in instances that allow this.
        """
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> int:
        """
        The ability to define the number of threads per core in instances that allow this.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class ElastigroupEbsBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "dynamicIops":
            suggest = "dynamic_iops"
        elif key == "dynamicVolumeSize":
            suggest = "dynamic_volume_size"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupEbsBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupEbsBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupEbsBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 delete_on_termination: Optional[bool] = None,
                 dynamic_iops: Optional['outputs.ElastigroupEbsBlockDeviceDynamicIops'] = None,
                 dynamic_volume_size: Optional['outputs.ElastigroupEbsBlockDeviceDynamicVolumeSize'] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 throughput: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        """
        :param str device_name: The name of the device to mount.
        :param bool delete_on_termination: Whether the volume should be destroyed on instance termination.
        :param 'ElastigroupEbsBlockDeviceDynamicIopsArgs' dynamic_iops: Set dynamic IOPS properties. When using this object, you cannot use the `iops` object. You must use one or the other.
        :param 'ElastigroupEbsBlockDeviceDynamicVolumeSizeArgs' dynamic_volume_size: Set dynamic volume size properties. When using this object, you cannot use `volume_size`. You must use one or the other.
        :param bool encrypted: Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param int iops: The amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `"io1"`.
        :param str kms_key_id: ID for a user managed CMK under which the EBS Volume is encrypted
        :param str snapshot_id: The Snapshot ID to mount.
        :param int throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        :param int volume_size: The size of the volume in gigabytes.
        :param str volume_type: The type of volume. Can be `"standard"`, `"gp2"`, `"gp3"`, `"io1"`, `"st1"` or `"sc1"`.
        """
        pulumi.set(__self__, "device_name", device_name)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_iops is not None:
            pulumi.set(__self__, "dynamic_iops", dynamic_iops)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The name of the device to mount.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Whether the volume should be destroyed on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="dynamicIops")
    def dynamic_iops(self) -> Optional['outputs.ElastigroupEbsBlockDeviceDynamicIops']:
        """
        Set dynamic IOPS properties. When using this object, you cannot use the `iops` object. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_iops")

    @property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional['outputs.ElastigroupEbsBlockDeviceDynamicVolumeSize']:
        """
        Set dynamic volume size properties. When using this object, you cannot use `volume_size`. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `"io1"`.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        ID for a user managed CMK under which the EBS Volume is encrypted
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The Snapshot ID to mount.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        The type of volume. Can be `"standard"`, `"gp2"`, `"gp3"`, `"io1"`, `"st1"` or `"sc1"`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ElastigroupEbsBlockDeviceDynamicIops(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupEbsBlockDeviceDynamicIops. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupEbsBlockDeviceDynamicIops.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupEbsBlockDeviceDynamicIops.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: Optional[int] = None,
                 resource: Optional[str] = None,
                 size_per_resource_unit: Optional[int] = None):
        """
        :param int base_size: Initial size for IOPS.
        :param str resource: Type of resource, valid values: `"CPU", "MEMORY"`.
        :param int size_per_resource_unit: Additional size per resource unit (in IOPS).
               
               Modifying any `ebs_block_device` currently requires resource replacement.
               
               Usage:
        """
        if base_size is not None:
            pulumi.set(__self__, "base_size", base_size)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if size_per_resource_unit is not None:
            pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> Optional[int]:
        """
        Initial size for IOPS.
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        Type of resource, valid values: `"CPU", "MEMORY"`.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> Optional[int]:
        """
        Additional size per resource unit (in IOPS).

        Modifying any `ebs_block_device` currently requires resource replacement.

        Usage:
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class ElastigroupEbsBlockDeviceDynamicVolumeSize(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupEbsBlockDeviceDynamicVolumeSize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupEbsBlockDeviceDynamicVolumeSize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupEbsBlockDeviceDynamicVolumeSize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: Optional[int] = None,
                 resource: Optional[str] = None,
                 size_per_resource_unit: Optional[int] = None):
        """
        :param int base_size: Initial size for volume.
        :param str resource: Type of resource, valid values: `"CPU", "MEMORY"`.
        :param int size_per_resource_unit: Additional size per resource unit (in GB).
        """
        if base_size is not None:
            pulumi.set(__self__, "base_size", base_size)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if size_per_resource_unit is not None:
            pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> Optional[int]:
        """
        Initial size for volume.
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        Type of resource, valid values: `"CPU", "MEMORY"`.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> Optional[int]:
        """
        Additional size per resource unit (in GB).
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class ElastigroupEphemeralBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupEphemeralBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupEphemeralBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupEphemeralBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 virtual_name: str):
        """
        :param str device_name: The name of the block device to mount on the instance.
        :param str virtual_name: The [Instance Store Device Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames)
               (e.g. `"ephemeral0"`).
               
               Usage:
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The name of the block device to mount on the instance.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> str:
        """
        The [Instance Store Device Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames)
        (e.g. `"ephemeral0"`).

        Usage:
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class ElastigroupImage(dict):
    def __init__(__self__, *,
                 images: Sequence['outputs.ElastigroupImageImage']):
        pulumi.set(__self__, "images", images)

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.ElastigroupImageImage']:
        return pulumi.get(self, "images")


@pulumi.output_type
class ElastigroupImageImage(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The group ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The group ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ElastigroupInstanceTypesWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupInstanceTypesWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupInstanceTypesWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupInstanceTypesWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 weight: int):
        """
        :param str instance_type: Name of instance type (String).
        :param int weight: Weight per instance type (Integer).
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Name of instance type (String).
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Weight per instance type (Integer).
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ElastigroupIntegrationBeanstalk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentPreferences":
            suggest = "deployment_preferences"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "managedActions":
            suggest = "managed_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationBeanstalk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationBeanstalk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationBeanstalk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_preferences: Optional['outputs.ElastigroupIntegrationBeanstalkDeploymentPreferences'] = None,
                 environment_id: Optional[str] = None,
                 managed_actions: Optional['outputs.ElastigroupIntegrationBeanstalkManagedActions'] = None):
        """
        :param 'ElastigroupIntegrationBeanstalkDeploymentPreferencesArgs' deployment_preferences: Preferences when performing a roll
        :param 'ElastigroupIntegrationBeanstalkManagedActionsArgs' managed_actions: Managed Actions parameters
        """
        if deployment_preferences is not None:
            pulumi.set(__self__, "deployment_preferences", deployment_preferences)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if managed_actions is not None:
            pulumi.set(__self__, "managed_actions", managed_actions)

    @property
    @pulumi.getter(name="deploymentPreferences")
    def deployment_preferences(self) -> Optional['outputs.ElastigroupIntegrationBeanstalkDeploymentPreferences']:
        """
        Preferences when performing a roll
        """
        return pulumi.get(self, "deployment_preferences")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="managedActions")
    def managed_actions(self) -> Optional['outputs.ElastigroupIntegrationBeanstalkManagedActions']:
        """
        Managed Actions parameters
        """
        return pulumi.get(self, "managed_actions")


@pulumi.output_type
class ElastigroupIntegrationBeanstalkDeploymentPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticRoll":
            suggest = "automatic_roll"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationBeanstalkDeploymentPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationBeanstalkDeploymentPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationBeanstalkDeploymentPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_roll: Optional[bool] = None,
                 batch_size_percentage: Optional[int] = None,
                 grace_period: Optional[int] = None,
                 strategy: Optional['outputs.ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy'] = None):
        """
        :param bool automatic_roll: Should roll perform automatically
        """
        if automatic_roll is not None:
            pulumi.set(__self__, "automatic_roll", automatic_roll)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="automaticRoll")
    def automatic_roll(self) -> Optional[bool]:
        """
        Should roll perform automatically
        """
        return pulumi.get(self, "automatic_roll")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[int]:
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[int]:
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy']:
        return pulumi.get(self, "strategy")


@pulumi.output_type
class ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldDrainInstances":
            suggest = "should_drain_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationBeanstalkDeploymentPreferencesStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 should_drain_instances: Optional[bool] = None):
        if action is not None:
            pulumi.set(__self__, "action", action)
        if should_drain_instances is not None:
            pulumi.set(__self__, "should_drain_instances", should_drain_instances)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="shouldDrainInstances")
    def should_drain_instances(self) -> Optional[bool]:
        return pulumi.get(self, "should_drain_instances")


@pulumi.output_type
class ElastigroupIntegrationBeanstalkManagedActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "platformUpdate":
            suggest = "platform_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationBeanstalkManagedActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationBeanstalkManagedActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationBeanstalkManagedActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 platform_update: Optional['outputs.ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate'] = None):
        """
        :param 'ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdateArgs' platform_update: Platform Update parameters
        """
        if platform_update is not None:
            pulumi.set(__self__, "platform_update", platform_update)

    @property
    @pulumi.getter(name="platformUpdate")
    def platform_update(self) -> Optional['outputs.ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate']:
        """
        Platform Update parameters
        """
        return pulumi.get(self, "platform_update")


@pulumi.output_type
class ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"
        elif key == "timeWindow":
            suggest = "time_window"
        elif key == "updateLevel":
            suggest = "update_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationBeanstalkManagedActionsPlatformUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: Optional[str] = None,
                 time_window: Optional[str] = None,
                 update_level: Optional[str] = None):
        """
        :param str time_window: Time Window for when action occurs ex. Mon:23:50-Tue:00:20
        :param str update_level: Level to update
               
               Usage:
        """
        if perform_at is not None:
            pulumi.set(__self__, "perform_at", perform_at)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)
        if update_level is not None:
            pulumi.set(__self__, "update_level", update_level)

    @property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> Optional[str]:
        return pulumi.get(self, "perform_at")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[str]:
        """
        Time Window for when action occurs ex. Mon:23:50-Tue:00:20
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter(name="updateLevel")
    def update_level(self) -> Optional[str]:
        """
        Level to update

        Usage:
        """
        return pulumi.get(self, "update_level")


@pulumi.output_type
class ElastigroupIntegrationCodedeploy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cleanupOnFailure":
            suggest = "cleanup_on_failure"
        elif key == "deploymentGroups":
            suggest = "deployment_groups"
        elif key == "terminateInstanceOnFailure":
            suggest = "terminate_instance_on_failure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationCodedeploy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationCodedeploy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationCodedeploy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cleanup_on_failure: bool,
                 deployment_groups: Sequence['outputs.ElastigroupIntegrationCodedeployDeploymentGroup'],
                 terminate_instance_on_failure: bool):
        """
        :param bool cleanup_on_failure: Cleanup automatically after a failed deploy.
        :param Sequence['ElastigroupIntegrationCodedeployDeploymentGroupArgs'] deployment_groups: Specify the deployment groups details.
        :param bool terminate_instance_on_failure: Terminate the instance automatically after a failed deploy.
        """
        pulumi.set(__self__, "cleanup_on_failure", cleanup_on_failure)
        pulumi.set(__self__, "deployment_groups", deployment_groups)
        pulumi.set(__self__, "terminate_instance_on_failure", terminate_instance_on_failure)

    @property
    @pulumi.getter(name="cleanupOnFailure")
    def cleanup_on_failure(self) -> bool:
        """
        Cleanup automatically after a failed deploy.
        """
        return pulumi.get(self, "cleanup_on_failure")

    @property
    @pulumi.getter(name="deploymentGroups")
    def deployment_groups(self) -> Sequence['outputs.ElastigroupIntegrationCodedeployDeploymentGroup']:
        """
        Specify the deployment groups details.
        """
        return pulumi.get(self, "deployment_groups")

    @property
    @pulumi.getter(name="terminateInstanceOnFailure")
    def terminate_instance_on_failure(self) -> bool:
        """
        Terminate the instance automatically after a failed deploy.
        """
        return pulumi.get(self, "terminate_instance_on_failure")


@pulumi.output_type
class ElastigroupIntegrationCodedeployDeploymentGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationName":
            suggest = "application_name"
        elif key == "deploymentGroupName":
            suggest = "deployment_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationCodedeployDeploymentGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationCodedeployDeploymentGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationCodedeployDeploymentGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_name: str,
                 deployment_group_name: str):
        """
        :param str application_name: The application name.
        :param str deployment_group_name: The deployment group name.
               
               Usage:
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "deployment_group_name", deployment_group_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> str:
        """
        The application name.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="deploymentGroupName")
    def deployment_group_name(self) -> str:
        """
        The deployment group name.

        Usage:
        """
        return pulumi.get(self, "deployment_group_name")


@pulumi.output_type
class ElastigroupIntegrationDockerSwarm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterHost":
            suggest = "master_host"
        elif key == "masterPort":
            suggest = "master_port"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationDockerSwarm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationDockerSwarm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationDockerSwarm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_host: str,
                 master_port: int,
                 autoscale_cooldown: Optional[int] = None,
                 autoscale_down: Optional['outputs.ElastigroupIntegrationDockerSwarmAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.ElastigroupIntegrationDockerSwarmAutoscaleHeadroom'] = None,
                 autoscale_is_enabled: Optional[bool] = None):
        pulumi.set(__self__, "master_host", master_host)
        pulumi.set(__self__, "master_port", master_port)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)

    @property
    @pulumi.getter(name="masterHost")
    def master_host(self) -> str:
        return pulumi.get(self, "master_host")

    @property
    @pulumi.getter(name="masterPort")
    def master_port(self) -> int:
        return pulumi.get(self, "master_port")

    @property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[int]:
        return pulumi.get(self, "autoscale_cooldown")

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.ElastigroupIntegrationDockerSwarmAutoscaleDown']:
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.ElastigroupIntegrationDockerSwarmAutoscaleHeadroom']:
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_enabled")


@pulumi.output_type
class ElastigroupIntegrationDockerSwarmAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationDockerSwarmAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationDockerSwarmAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationDockerSwarmAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[int] = None,
                 max_scale_down_percentage: Optional[float] = None):
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[float]:
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class ElastigroupIntegrationDockerSwarmAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationDockerSwarmAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationDockerSwarmAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationDockerSwarmAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None,
                 num_of_units: Optional[int] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[int]:
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class ElastigroupIntegrationEcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "autoscaleAttributes":
            suggest = "autoscale_attributes"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsAutoConfig":
            suggest = "autoscale_is_auto_config"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"
        elif key == "autoscaleScaleDownNonServiceTasks":
            suggest = "autoscale_scale_down_non_service_tasks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationEcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationEcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationEcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: str,
                 autoscale_attributes: Optional[Sequence['outputs.ElastigroupIntegrationEcsAutoscaleAttribute']] = None,
                 autoscale_cooldown: Optional[int] = None,
                 autoscale_down: Optional['outputs.ElastigroupIntegrationEcsAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.ElastigroupIntegrationEcsAutoscaleHeadroom'] = None,
                 autoscale_is_auto_config: Optional[bool] = None,
                 autoscale_is_enabled: Optional[bool] = None,
                 autoscale_scale_down_non_service_tasks: Optional[bool] = None,
                 batch: Optional['outputs.ElastigroupIntegrationEcsBatch'] = None):
        """
        :param str cluster_name: The name of the EC2 Container Service cluster.
        :param Sequence['ElastigroupIntegrationEcsAutoscaleAttributeArgs'] autoscale_attributes: A key/value mapping of tags to assign to the resource.
        :param bool autoscale_scale_down_non_service_tasks: Determines whether to scale down non-service tasks.
        :param 'ElastigroupIntegrationEcsBatchArgs' batch: Batch configuration object:
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        if autoscale_attributes is not None:
            pulumi.set(__self__, "autoscale_attributes", autoscale_attributes)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_auto_config is not None:
            pulumi.set(__self__, "autoscale_is_auto_config", autoscale_is_auto_config)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if autoscale_scale_down_non_service_tasks is not None:
            pulumi.set(__self__, "autoscale_scale_down_non_service_tasks", autoscale_scale_down_non_service_tasks)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of the EC2 Container Service cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="autoscaleAttributes")
    def autoscale_attributes(self) -> Optional[Sequence['outputs.ElastigroupIntegrationEcsAutoscaleAttribute']]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "autoscale_attributes")

    @property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[int]:
        return pulumi.get(self, "autoscale_cooldown")

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.ElastigroupIntegrationEcsAutoscaleDown']:
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.ElastigroupIntegrationEcsAutoscaleHeadroom']:
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_auto_config")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_enabled")

    @property
    @pulumi.getter(name="autoscaleScaleDownNonServiceTasks")
    def autoscale_scale_down_non_service_tasks(self) -> Optional[bool]:
        """
        Determines whether to scale down non-service tasks.
        """
        return pulumi.get(self, "autoscale_scale_down_non_service_tasks")

    @property
    @pulumi.getter
    def batch(self) -> Optional['outputs.ElastigroupIntegrationEcsBatch']:
        """
        Batch configuration object:
        """
        return pulumi.get(self, "batch")


@pulumi.output_type
class ElastigroupIntegrationEcsAutoscaleAttribute(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupIntegrationEcsAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationEcsAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationEcsAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationEcsAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[int] = None,
                 max_scale_down_percentage: Optional[float] = None):
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[float]:
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class ElastigroupIntegrationEcsAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationEcsAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationEcsAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationEcsAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None,
                 num_of_units: Optional[int] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[int]:
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class ElastigroupIntegrationEcsBatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobQueueNames":
            suggest = "job_queue_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationEcsBatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationEcsBatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationEcsBatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_queue_names: Sequence[str]):
        """
        :param Sequence[str] job_queue_names: Array of strings.
               
               Usage:
        """
        pulumi.set(__self__, "job_queue_names", job_queue_names)

    @property
    @pulumi.getter(name="jobQueueNames")
    def job_queue_names(self) -> Sequence[str]:
        """
        Array of strings.

        Usage:
        """
        return pulumi.get(self, "job_queue_names")


@pulumi.output_type
class ElastigroupIntegrationGitlab(dict):
    def __init__(__self__, *,
                 runner: Optional['outputs.ElastigroupIntegrationGitlabRunner'] = None):
        """
        :param 'ElastigroupIntegrationGitlabRunnerArgs' runner: Settings for Gitlab runner.
        """
        if runner is not None:
            pulumi.set(__self__, "runner", runner)

    @property
    @pulumi.getter
    def runner(self) -> Optional['outputs.ElastigroupIntegrationGitlabRunner']:
        """
        Settings for Gitlab runner.
        """
        return pulumi.get(self, "runner")


@pulumi.output_type
class ElastigroupIntegrationGitlabRunner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGitlabRunner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGitlabRunner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGitlabRunner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: Optional[bool] = None):
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class ElastigroupIntegrationKubernetes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServer":
            suggest = "api_server"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsAutoConfig":
            suggest = "autoscale_is_auto_config"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"
        elif key == "autoscaleLabels":
            suggest = "autoscale_labels"
        elif key == "clusterIdentifier":
            suggest = "cluster_identifier"
        elif key == "integrationMode":
            suggest = "integration_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationKubernetes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationKubernetes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationKubernetes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server: Optional[str] = None,
                 autoscale_cooldown: Optional[int] = None,
                 autoscale_down: Optional['outputs.ElastigroupIntegrationKubernetesAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.ElastigroupIntegrationKubernetesAutoscaleHeadroom'] = None,
                 autoscale_is_auto_config: Optional[bool] = None,
                 autoscale_is_enabled: Optional[bool] = None,
                 autoscale_labels: Optional[Sequence['outputs.ElastigroupIntegrationKubernetesAutoscaleLabel']] = None,
                 cluster_identifier: Optional[str] = None,
                 integration_mode: Optional[str] = None,
                 token: Optional[str] = None):
        """
        :param Sequence['ElastigroupIntegrationKubernetesAutoscaleLabelArgs'] autoscale_labels: A key/value mapping of tags to assign to the resource.
               
               Usage:
        :param str integration_mode: Valid values: `"saas"`, `"pod"`.
        :param str token: Kubernetes Token
        """
        if api_server is not None:
            pulumi.set(__self__, "api_server", api_server)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_auto_config is not None:
            pulumi.set(__self__, "autoscale_is_auto_config", autoscale_is_auto_config)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if autoscale_labels is not None:
            pulumi.set(__self__, "autoscale_labels", autoscale_labels)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if integration_mode is not None:
            pulumi.set(__self__, "integration_mode", integration_mode)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="apiServer")
    def api_server(self) -> Optional[str]:
        return pulumi.get(self, "api_server")

    @property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[int]:
        return pulumi.get(self, "autoscale_cooldown")

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.ElastigroupIntegrationKubernetesAutoscaleDown']:
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.ElastigroupIntegrationKubernetesAutoscaleHeadroom']:
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_auto_config")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_enabled")

    @property
    @pulumi.getter(name="autoscaleLabels")
    def autoscale_labels(self) -> Optional[Sequence['outputs.ElastigroupIntegrationKubernetesAutoscaleLabel']]:
        """
        A key/value mapping of tags to assign to the resource.

        Usage:
        """
        return pulumi.get(self, "autoscale_labels")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[str]:
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="integrationMode")
    def integration_mode(self) -> Optional[str]:
        """
        Valid values: `"saas"`, `"pod"`.
        """
        return pulumi.get(self, "integration_mode")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Kubernetes Token
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ElastigroupIntegrationKubernetesAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationKubernetesAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationKubernetesAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationKubernetesAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[int] = None,
                 max_scale_down_percentage: Optional[float] = None):
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[float]:
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class ElastigroupIntegrationKubernetesAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationKubernetesAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationKubernetesAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationKubernetesAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None,
                 num_of_units: Optional[int] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[int]:
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class ElastigroupIntegrationKubernetesAutoscaleLabel(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupIntegrationMesosphere(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServer":
            suggest = "api_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationMesosphere. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationMesosphere.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationMesosphere.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server: str):
        pulumi.set(__self__, "api_server", api_server)

    @property
    @pulumi.getter(name="apiServer")
    def api_server(self) -> str:
        return pulumi.get(self, "api_server")


@pulumi.output_type
class ElastigroupIntegrationNomad(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterHost":
            suggest = "master_host"
        elif key == "masterPort":
            suggest = "master_port"
        elif key == "aclToken":
            suggest = "acl_token"
        elif key == "autoscaleConstraints":
            suggest = "autoscale_constraints"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationNomad. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationNomad.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationNomad.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_host: str,
                 master_port: int,
                 acl_token: Optional[str] = None,
                 autoscale_constraints: Optional[Sequence['outputs.ElastigroupIntegrationNomadAutoscaleConstraint']] = None,
                 autoscale_cooldown: Optional[int] = None,
                 autoscale_down: Optional['outputs.ElastigroupIntegrationNomadAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.ElastigroupIntegrationNomadAutoscaleHeadroom'] = None,
                 autoscale_is_enabled: Optional[bool] = None):
        """
        :param str acl_token: Nomad ACL Token
        :param Sequence['ElastigroupIntegrationNomadAutoscaleConstraintArgs'] autoscale_constraints: A key/value mapping of tags to assign to the resource.
               
               Usage:
        """
        pulumi.set(__self__, "master_host", master_host)
        pulumi.set(__self__, "master_port", master_port)
        if acl_token is not None:
            pulumi.set(__self__, "acl_token", acl_token)
        if autoscale_constraints is not None:
            pulumi.set(__self__, "autoscale_constraints", autoscale_constraints)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)

    @property
    @pulumi.getter(name="masterHost")
    def master_host(self) -> str:
        return pulumi.get(self, "master_host")

    @property
    @pulumi.getter(name="masterPort")
    def master_port(self) -> int:
        return pulumi.get(self, "master_port")

    @property
    @pulumi.getter(name="aclToken")
    def acl_token(self) -> Optional[str]:
        """
        Nomad ACL Token
        """
        return pulumi.get(self, "acl_token")

    @property
    @pulumi.getter(name="autoscaleConstraints")
    def autoscale_constraints(self) -> Optional[Sequence['outputs.ElastigroupIntegrationNomadAutoscaleConstraint']]:
        """
        A key/value mapping of tags to assign to the resource.

        Usage:
        """
        return pulumi.get(self, "autoscale_constraints")

    @property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[int]:
        return pulumi.get(self, "autoscale_cooldown")

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.ElastigroupIntegrationNomadAutoscaleDown']:
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.ElastigroupIntegrationNomadAutoscaleHeadroom']:
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_enabled")


@pulumi.output_type
class ElastigroupIntegrationNomadAutoscaleConstraint(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupIntegrationNomadAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationNomadAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationNomadAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationNomadAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[int] = None):
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")


@pulumi.output_type
class ElastigroupIntegrationNomadAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationNomadAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationNomadAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationNomadAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None,
                 num_of_units: Optional[int] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[int]:
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class ElastigroupIntegrationRancher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "masterHost":
            suggest = "master_host"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationRancher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationRancher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationRancher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 master_host: str,
                 secret_key: str,
                 version: Optional[str] = None):
        """
        :param str access_key: The access key of the Rancher API.
        :param str secret_key: The secret key of the Rancher API.
        :param str version: The Rancher version. Must be `"1"` or `"2"`. If this field is omitted, it’s assumed that the Rancher cluster is version 1. Note that Kubernetes is required when using Rancher version 2^.
               Usage:
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "master_host", master_host)
        pulumi.set(__self__, "secret_key", secret_key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        The access key of the Rancher API.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="masterHost")
    def master_host(self) -> str:
        return pulumi.get(self, "master_host")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key of the Rancher API.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The Rancher version. Must be `"1"` or `"2"`. If this field is omitted, it’s assumed that the Rancher cluster is version 1. Note that Kubernetes is required when using Rancher version 2^.
        Usage:
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ElastigroupIntegrationRoute53(dict):
    def __init__(__self__, *,
                 domains: Sequence['outputs.ElastigroupIntegrationRoute53Domain']):
        """
        :param Sequence['ElastigroupIntegrationRoute53DomainArgs'] domains: Collection of one or more domains to register.
        """
        pulumi.set(__self__, "domains", domains)

    @property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.ElastigroupIntegrationRoute53Domain']:
        """
        Collection of one or more domains to register.
        """
        return pulumi.get(self, "domains")


@pulumi.output_type
class ElastigroupIntegrationRoute53Domain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostedZoneId":
            suggest = "hosted_zone_id"
        elif key == "recordSets":
            suggest = "record_sets"
        elif key == "recordSetType":
            suggest = "record_set_type"
        elif key == "spotinstAcctId":
            suggest = "spotinst_acct_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationRoute53Domain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationRoute53Domain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationRoute53Domain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosted_zone_id: str,
                 record_sets: Sequence['outputs.ElastigroupIntegrationRoute53DomainRecordSet'],
                 record_set_type: Optional[str] = None,
                 spotinst_acct_id: Optional[str] = None):
        """
        :param str hosted_zone_id: The id associated with a hosted zone.
        :param Sequence['ElastigroupIntegrationRoute53DomainRecordSetArgs'] record_sets: Collection of records containing authoritative DNS information for the specified domain name.
        :param str record_set_type: The type of the record set. Valid values: `"a"`, `"cname"`.
        :param str spotinst_acct_id: The Spotinst account ID that is linked to the AWS account that holds the Route 53 Hosted Zone ID. The default is the user Spotinst account provided as a URL parameter.
        """
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        pulumi.set(__self__, "record_sets", record_sets)
        if record_set_type is not None:
            pulumi.set(__self__, "record_set_type", record_set_type)
        if spotinst_acct_id is not None:
            pulumi.set(__self__, "spotinst_acct_id", spotinst_acct_id)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> str:
        """
        The id associated with a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="recordSets")
    def record_sets(self) -> Sequence['outputs.ElastigroupIntegrationRoute53DomainRecordSet']:
        """
        Collection of records containing authoritative DNS information for the specified domain name.
        """
        return pulumi.get(self, "record_sets")

    @property
    @pulumi.getter(name="recordSetType")
    def record_set_type(self) -> Optional[str]:
        """
        The type of the record set. Valid values: `"a"`, `"cname"`.
        """
        return pulumi.get(self, "record_set_type")

    @property
    @pulumi.getter(name="spotinstAcctId")
    def spotinst_acct_id(self) -> Optional[str]:
        """
        The Spotinst account ID that is linked to the AWS account that holds the Route 53 Hosted Zone ID. The default is the user Spotinst account provided as a URL parameter.
        """
        return pulumi.get(self, "spotinst_acct_id")


@pulumi.output_type
class ElastigroupIntegrationRoute53DomainRecordSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePublicDns":
            suggest = "use_public_dns"
        elif key == "usePublicIp":
            suggest = "use_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationRoute53DomainRecordSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationRoute53DomainRecordSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationRoute53DomainRecordSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 use_public_dns: Optional[bool] = None,
                 use_public_ip: Optional[bool] = None):
        """
        :param str name: The group name.
        :param bool use_public_dns: Designates whether the DNS address should be exposed to connections outside the VPC.
               
               Usage:
        :param bool use_public_ip: Designates whether the IP address should be exposed to connections outside the VPC.
        """
        pulumi.set(__self__, "name", name)
        if use_public_dns is not None:
            pulumi.set(__self__, "use_public_dns", use_public_dns)
        if use_public_ip is not None:
            pulumi.set(__self__, "use_public_ip", use_public_ip)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="usePublicDns")
    def use_public_dns(self) -> Optional[bool]:
        """
        Designates whether the DNS address should be exposed to connections outside the VPC.

        Usage:
        """
        return pulumi.get(self, "use_public_dns")

    @property
    @pulumi.getter(name="usePublicIp")
    def use_public_ip(self) -> Optional[bool]:
        """
        Designates whether the IP address should be exposed to connections outside the VPC.
        """
        return pulumi.get(self, "use_public_ip")


@pulumi.output_type
class ElastigroupItf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedTargetGroups":
            suggest = "fixed_target_groups"
        elif key == "loadBalancers":
            suggest = "load_balancers"
        elif key == "targetGroupConfigs":
            suggest = "target_group_configs"
        elif key == "weightStrategy":
            suggest = "weight_strategy"
        elif key == "defaultStaticTargetGroup":
            suggest = "default_static_target_group"
        elif key == "migrationHealthinessThreshold":
            suggest = "migration_healthiness_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupItf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupItf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupItf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_target_groups: bool,
                 load_balancers: Sequence['outputs.ElastigroupItfLoadBalancer'],
                 target_group_configs: Sequence['outputs.ElastigroupItfTargetGroupConfig'],
                 weight_strategy: str,
                 default_static_target_group: Optional['outputs.ElastigroupItfDefaultStaticTargetGroup'] = None,
                 migration_healthiness_threshold: Optional[int] = None):
        pulumi.set(__self__, "fixed_target_groups", fixed_target_groups)
        pulumi.set(__self__, "load_balancers", load_balancers)
        pulumi.set(__self__, "target_group_configs", target_group_configs)
        pulumi.set(__self__, "weight_strategy", weight_strategy)
        if default_static_target_group is not None:
            pulumi.set(__self__, "default_static_target_group", default_static_target_group)
        if migration_healthiness_threshold is not None:
            pulumi.set(__self__, "migration_healthiness_threshold", migration_healthiness_threshold)

    @property
    @pulumi.getter(name="fixedTargetGroups")
    def fixed_target_groups(self) -> bool:
        return pulumi.get(self, "fixed_target_groups")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Sequence['outputs.ElastigroupItfLoadBalancer']:
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="targetGroupConfigs")
    def target_group_configs(self) -> Sequence['outputs.ElastigroupItfTargetGroupConfig']:
        return pulumi.get(self, "target_group_configs")

    @property
    @pulumi.getter(name="weightStrategy")
    def weight_strategy(self) -> str:
        return pulumi.get(self, "weight_strategy")

    @property
    @pulumi.getter(name="defaultStaticTargetGroup")
    def default_static_target_group(self) -> Optional['outputs.ElastigroupItfDefaultStaticTargetGroup']:
        return pulumi.get(self, "default_static_target_group")

    @property
    @pulumi.getter(name="migrationHealthinessThreshold")
    def migration_healthiness_threshold(self) -> Optional[int]:
        return pulumi.get(self, "migration_healthiness_threshold")


@pulumi.output_type
class ElastigroupItfDefaultStaticTargetGroup(dict):
    def __init__(__self__, *,
                 arn: str,
                 percentage: float):
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        return pulumi.get(self, "percentage")


@pulumi.output_type
class ElastigroupItfLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listenerRules":
            suggest = "listener_rules"
        elif key == "loadBalancerArn":
            suggest = "load_balancer_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupItfLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupItfLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupItfLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 listener_rules: Sequence['outputs.ElastigroupItfLoadBalancerListenerRule'],
                 load_balancer_arn: str):
        pulumi.set(__self__, "listener_rules", listener_rules)
        pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)

    @property
    @pulumi.getter(name="listenerRules")
    def listener_rules(self) -> Sequence['outputs.ElastigroupItfLoadBalancerListenerRule']:
        return pulumi.get(self, "listener_rules")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> str:
        return pulumi.get(self, "load_balancer_arn")


@pulumi.output_type
class ElastigroupItfLoadBalancerListenerRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleArn":
            suggest = "rule_arn"
        elif key == "staticTargetGroup":
            suggest = "static_target_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupItfLoadBalancerListenerRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupItfLoadBalancerListenerRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupItfLoadBalancerListenerRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_arn: str,
                 static_target_group: Optional['outputs.ElastigroupItfLoadBalancerListenerRuleStaticTargetGroup'] = None):
        pulumi.set(__self__, "rule_arn", rule_arn)
        if static_target_group is not None:
            pulumi.set(__self__, "static_target_group", static_target_group)

    @property
    @pulumi.getter(name="ruleArn")
    def rule_arn(self) -> str:
        return pulumi.get(self, "rule_arn")

    @property
    @pulumi.getter(name="staticTargetGroup")
    def static_target_group(self) -> Optional['outputs.ElastigroupItfLoadBalancerListenerRuleStaticTargetGroup']:
        return pulumi.get(self, "static_target_group")


@pulumi.output_type
class ElastigroupItfLoadBalancerListenerRuleStaticTargetGroup(dict):
    def __init__(__self__, *,
                 arn: str,
                 percentage: float):
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        return pulumi.get(self, "percentage")


@pulumi.output_type
class ElastigroupItfTargetGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckPath":
            suggest = "health_check_path"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "healthCheckIntervalSeconds":
            suggest = "health_check_interval_seconds"
        elif key == "healthCheckPort":
            suggest = "health_check_port"
        elif key == "healthCheckProtocol":
            suggest = "health_check_protocol"
        elif key == "healthCheckTimeoutSeconds":
            suggest = "health_check_timeout_seconds"
        elif key == "healthyThresholdCount":
            suggest = "healthy_threshold_count"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "unhealthyThresholdCount":
            suggest = "unhealthy_threshold_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupItfTargetGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupItfTargetGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupItfTargetGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_path: str,
                 port: int,
                 protocol: str,
                 vpc_id: str,
                 health_check_interval_seconds: Optional[int] = None,
                 health_check_port: Optional[str] = None,
                 health_check_protocol: Optional[str] = None,
                 health_check_timeout_seconds: Optional[int] = None,
                 healthy_threshold_count: Optional[int] = None,
                 matchers: Optional[Sequence['outputs.ElastigroupItfTargetGroupConfigMatcher']] = None,
                 protocol_version: Optional[str] = None,
                 tags: Optional[Sequence['outputs.ElastigroupItfTargetGroupConfigTag']] = None,
                 unhealthy_threshold_count: Optional[int] = None):
        """
        :param Sequence['ElastigroupItfTargetGroupConfigTagArgs'] tags: A key/value mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "health_check_path", health_check_path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if health_check_timeout_seconds is not None:
            pulumi.set(__self__, "health_check_timeout_seconds", health_check_timeout_seconds)
        if healthy_threshold_count is not None:
            pulumi.set(__self__, "healthy_threshold_count", healthy_threshold_count)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unhealthy_threshold_count is not None:
            pulumi.set(__self__, "unhealthy_threshold_count", unhealthy_threshold_count)

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> str:
        return pulumi.get(self, "health_check_path")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[int]:
        return pulumi.get(self, "health_check_interval_seconds")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[str]:
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[str]:
        return pulumi.get(self, "health_check_protocol")

    @property
    @pulumi.getter(name="healthCheckTimeoutSeconds")
    def health_check_timeout_seconds(self) -> Optional[int]:
        return pulumi.get(self, "health_check_timeout_seconds")

    @property
    @pulumi.getter(name="healthyThresholdCount")
    def healthy_threshold_count(self) -> Optional[int]:
        return pulumi.get(self, "healthy_threshold_count")

    @property
    @pulumi.getter
    def matchers(self) -> Optional[Sequence['outputs.ElastigroupItfTargetGroupConfigMatcher']]:
        return pulumi.get(self, "matchers")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[str]:
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ElastigroupItfTargetGroupConfigTag']]:
        """
        A key/value mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="unhealthyThresholdCount")
    def unhealthy_threshold_count(self) -> Optional[int]:
        return pulumi.get(self, "unhealthy_threshold_count")


@pulumi.output_type
class ElastigroupItfTargetGroupConfigMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "grpcCode":
            suggest = "grpc_code"
        elif key == "httpCode":
            suggest = "http_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupItfTargetGroupConfigMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupItfTargetGroupConfigMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupItfTargetGroupConfigMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grpc_code: Optional[str] = None,
                 http_code: Optional[str] = None):
        if grpc_code is not None:
            pulumi.set(__self__, "grpc_code", grpc_code)
        if http_code is not None:
            pulumi.set(__self__, "http_code", http_code)

    @property
    @pulumi.getter(name="grpcCode")
    def grpc_code(self) -> Optional[str]:
        return pulumi.get(self, "grpc_code")

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> Optional[str]:
        return pulumi.get(self, "http_code")


@pulumi.output_type
class ElastigroupItfTargetGroupConfigTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValue":
            suggest = "tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupItfTargetGroupConfigTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupItfTargetGroupConfigTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupItfTargetGroupConfigTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_key: str,
                 tag_value: Optional[str] = None):
        pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> str:
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[str]:
        return pulumi.get(self, "tag_value")


@pulumi.output_type
class ElastigroupLogging(dict):
    def __init__(__self__, *,
                 export: Optional['outputs.ElastigroupLoggingExport'] = None):
        """
        :param 'ElastigroupLoggingExportArgs' export: Logging Export configuration.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)

    @property
    @pulumi.getter
    def export(self) -> Optional['outputs.ElastigroupLoggingExport']:
        """
        Logging Export configuration.
        """
        return pulumi.get(self, "export")


@pulumi.output_type
class ElastigroupLoggingExport(dict):
    def __init__(__self__, *,
                 s3s: Optional[Sequence['outputs.ElastigroupLoggingExportS3']] = None):
        """
        :param Sequence['ElastigroupLoggingExportS3Args'] s3s: Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        if s3s is not None:
            pulumi.set(__self__, "s3s", s3s)

    @property
    @pulumi.getter
    def s3s(self) -> Optional[Sequence['outputs.ElastigroupLoggingExportS3']]:
        """
        Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        return pulumi.get(self, "s3s")


@pulumi.output_type
class ElastigroupLoggingExportS3(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The identifier of The S3 data integration to export the logs to.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The identifier of The S3 data integration to export the logs to.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ElastigroupMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpTokens":
            suggest = "http_tokens"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"
        elif key == "instanceMetadataTags":
            suggest = "instance_metadata_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_tokens: str,
                 http_put_response_hop_limit: Optional[int] = None,
                 instance_metadata_tags: Optional[str] = None):
        """
        :param str http_tokens: The state of token usage for your instance metadata requests. Valid values: `optional` or `required`.
        :param int http_put_response_hop_limit: The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Valid values: Integers from `1` to `64`.
        :param str instance_metadata_tags: Indicates whether access to instance tags from the instance metadata is enabled or disabled. Can’t be null.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if instance_metadata_tags is not None:
            pulumi.set(__self__, "instance_metadata_tags", instance_metadata_tags)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> str:
        """
        The state of token usage for your instance metadata requests. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[int]:
        """
        The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Valid values: Integers from `1` to `64`.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @property
    @pulumi.getter(name="instanceMetadataTags")
    def instance_metadata_tags(self) -> Optional[str]:
        """
        Indicates whether access to instance tags from the instance metadata is enabled or disabled. Can’t be null.
        """
        return pulumi.get(self, "instance_metadata_tags")


@pulumi.output_type
class ElastigroupMultipleMetrics(dict):
    def __init__(__self__, *,
                 expressions: Optional[Sequence['outputs.ElastigroupMultipleMetricsExpression']] = None,
                 metrics: Optional[Sequence['outputs.ElastigroupMultipleMetricsMetric']] = None):
        """
        :param Sequence['ElastigroupMultipleMetricsExpressionArgs'] expressions: Array of objects (Expression config)
        :param Sequence['ElastigroupMultipleMetricsMetricArgs'] metrics: Array of objects (Metric config)
        """
        if expressions is not None:
            pulumi.set(__self__, "expressions", expressions)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def expressions(self) -> Optional[Sequence['outputs.ElastigroupMultipleMetricsExpression']]:
        """
        Array of objects (Expression config)
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ElastigroupMultipleMetricsMetric']]:
        """
        Array of objects (Metric config)
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class ElastigroupMultipleMetricsExpression(dict):
    def __init__(__self__, *,
                 expression: str,
                 name: str):
        """
        :param str expression: An expression consisting of the metric names listed in the 'metrics' array.
        :param str name: The group name.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        An expression consisting of the metric names listed in the 'metrics' array.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The group name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ElastigroupMultipleMetricsMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "extendedStatistic":
            suggest = "extended_statistic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupMultipleMetricsMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupMultipleMetricsMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupMultipleMetricsMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 name: str,
                 namespace: str,
                 dimensions: Optional[Sequence['outputs.ElastigroupMultipleMetricsMetricDimension']] = None,
                 extended_statistic: Optional[str] = None,
                 statistic: Optional[str] = None,
                 unit: Optional[str] = None):
        """
        :param str name: The group name.
        :param str extended_statistic: Percentile statistic. Valid values: `"p0.1"` - `"p100"`.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if extended_statistic is not None:
            pulumi.set(__self__, "extended_statistic", extended_statistic)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupMultipleMetricsMetricDimension']]:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="extendedStatistic")
    def extended_statistic(self) -> Optional[str]:
        """
        Percentile statistic. Valid values: `"p0.1"` - `"p100"`.
        """
        return pulumi.get(self, "extended_statistic")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        return pulumi.get(self, "unit")


@pulumi.output_type
class ElastigroupMultipleMetricsMetricDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The group name.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceIndex":
            suggest = "device_index"
        elif key == "associateIpv6Address":
            suggest = "associate_ipv6_address"
        elif key == "associatePublicIpAddress":
            suggest = "associate_public_ip_address"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "networkInterfaceId":
            suggest = "network_interface_id"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "secondaryPrivateIpAddressCount":
            suggest = "secondary_private_ip_address_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_index: str,
                 associate_ipv6_address: Optional[bool] = None,
                 associate_public_ip_address: Optional[bool] = None,
                 delete_on_termination: Optional[bool] = None,
                 description: Optional[str] = None,
                 network_interface_id: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 secondary_private_ip_address_count: Optional[str] = None):
        """
        :param str device_index: The index of the device on the instance for the network interface attachment.
        :param bool associate_ipv6_address: Indicates whether to assign IPV6 addresses to your instance. Requires a subnet with IPV6 CIDR block ranges.
               
               Usage:
        :param bool associate_public_ip_address: Indicates whether to assign a public IP address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one.
        :param bool delete_on_termination: If set to true, the interface is deleted when the instance is terminated.
        :param str description: The description of the network interface.
        :param str network_interface_id: The ID of the network interface.
        :param str private_ip_address: The private IP address of the network interface.
        :param str secondary_private_ip_address_count: The number of secondary private IP addresses.
        """
        pulumi.set(__self__, "device_index", device_index)
        if associate_ipv6_address is not None:
            pulumi.set(__self__, "associate_ipv6_address", associate_ipv6_address)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if secondary_private_ip_address_count is not None:
            pulumi.set(__self__, "secondary_private_ip_address_count", secondary_private_ip_address_count)

    @property
    @pulumi.getter(name="deviceIndex")
    def device_index(self) -> str:
        """
        The index of the device on the instance for the network interface attachment.
        """
        return pulumi.get(self, "device_index")

    @property
    @pulumi.getter(name="associateIpv6Address")
    def associate_ipv6_address(self) -> Optional[bool]:
        """
        Indicates whether to assign IPV6 addresses to your instance. Requires a subnet with IPV6 CIDR block ranges.

        Usage:
        """
        return pulumi.get(self, "associate_ipv6_address")

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[bool]:
        """
        Indicates whether to assign a public IP address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        If set to true, the interface is deleted when the instance is terminated.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the network interface.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[str]:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the network interface.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> Optional[str]:
        """
        The number of secondary private IP addresses.
        """
        return pulumi.get(self, "secondary_private_ip_address_count")


@pulumi.output_type
class ElastigroupResourceRequirement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requiredMemoryMaximum":
            suggest = "required_memory_maximum"
        elif key == "requiredMemoryMinimum":
            suggest = "required_memory_minimum"
        elif key == "requiredVcpuMaximum":
            suggest = "required_vcpu_maximum"
        elif key == "requiredVcpuMinimum":
            suggest = "required_vcpu_minimum"
        elif key == "excludedInstanceFamilies":
            suggest = "excluded_instance_families"
        elif key == "excludedInstanceGenerations":
            suggest = "excluded_instance_generations"
        elif key == "excludedInstanceTypes":
            suggest = "excluded_instance_types"
        elif key == "requiredGpuMaximum":
            suggest = "required_gpu_maximum"
        elif key == "requiredGpuMinimum":
            suggest = "required_gpu_minimum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupResourceRequirement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupResourceRequirement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupResourceRequirement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 required_memory_maximum: int,
                 required_memory_minimum: int,
                 required_vcpu_maximum: int,
                 required_vcpu_minimum: int,
                 excluded_instance_families: Optional[Sequence[str]] = None,
                 excluded_instance_generations: Optional[Sequence[str]] = None,
                 excluded_instance_types: Optional[Sequence[str]] = None,
                 required_gpu_maximum: Optional[int] = None,
                 required_gpu_minimum: Optional[int] = None):
        """
        :param int required_memory_maximum: Required maximum instance memory (<=512)
        :param int required_memory_minimum: Required minimum instance memory (>=1)
        :param int required_vcpu_maximum: Required maximum instance vCPU (<=64)
        :param int required_vcpu_minimum: Required minimum instance vCPU (>=1)
        :param Sequence[str] excluded_instance_families: Instance families to exclude
        :param Sequence[str] excluded_instance_generations: Instance generations to exclude
        :param Sequence[str] excluded_instance_types: Instance types to exclude
        :param int required_gpu_maximum: Required maximum instance GPU (<=16)
        :param int required_gpu_minimum: Required minimum instance GPU (>=1)
        """
        pulumi.set(__self__, "required_memory_maximum", required_memory_maximum)
        pulumi.set(__self__, "required_memory_minimum", required_memory_minimum)
        pulumi.set(__self__, "required_vcpu_maximum", required_vcpu_maximum)
        pulumi.set(__self__, "required_vcpu_minimum", required_vcpu_minimum)
        if excluded_instance_families is not None:
            pulumi.set(__self__, "excluded_instance_families", excluded_instance_families)
        if excluded_instance_generations is not None:
            pulumi.set(__self__, "excluded_instance_generations", excluded_instance_generations)
        if excluded_instance_types is not None:
            pulumi.set(__self__, "excluded_instance_types", excluded_instance_types)
        if required_gpu_maximum is not None:
            pulumi.set(__self__, "required_gpu_maximum", required_gpu_maximum)
        if required_gpu_minimum is not None:
            pulumi.set(__self__, "required_gpu_minimum", required_gpu_minimum)

    @property
    @pulumi.getter(name="requiredMemoryMaximum")
    def required_memory_maximum(self) -> int:
        """
        Required maximum instance memory (<=512)
        """
        return pulumi.get(self, "required_memory_maximum")

    @property
    @pulumi.getter(name="requiredMemoryMinimum")
    def required_memory_minimum(self) -> int:
        """
        Required minimum instance memory (>=1)
        """
        return pulumi.get(self, "required_memory_minimum")

    @property
    @pulumi.getter(name="requiredVcpuMaximum")
    def required_vcpu_maximum(self) -> int:
        """
        Required maximum instance vCPU (<=64)
        """
        return pulumi.get(self, "required_vcpu_maximum")

    @property
    @pulumi.getter(name="requiredVcpuMinimum")
    def required_vcpu_minimum(self) -> int:
        """
        Required minimum instance vCPU (>=1)
        """
        return pulumi.get(self, "required_vcpu_minimum")

    @property
    @pulumi.getter(name="excludedInstanceFamilies")
    def excluded_instance_families(self) -> Optional[Sequence[str]]:
        """
        Instance families to exclude
        """
        return pulumi.get(self, "excluded_instance_families")

    @property
    @pulumi.getter(name="excludedInstanceGenerations")
    def excluded_instance_generations(self) -> Optional[Sequence[str]]:
        """
        Instance generations to exclude
        """
        return pulumi.get(self, "excluded_instance_generations")

    @property
    @pulumi.getter(name="excludedInstanceTypes")
    def excluded_instance_types(self) -> Optional[Sequence[str]]:
        """
        Instance types to exclude
        """
        return pulumi.get(self, "excluded_instance_types")

    @property
    @pulumi.getter(name="requiredGpuMaximum")
    def required_gpu_maximum(self) -> Optional[int]:
        """
        Required maximum instance GPU (<=16)
        """
        return pulumi.get(self, "required_gpu_maximum")

    @property
    @pulumi.getter(name="requiredGpuMinimum")
    def required_gpu_minimum(self) -> Optional[int]:
        """
        Required minimum instance GPU (>=1)
        """
        return pulumi.get(self, "required_gpu_minimum")


@pulumi.output_type
class ElastigroupResourceTagSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldTagAmis":
            suggest = "should_tag_amis"
        elif key == "shouldTagEnis":
            suggest = "should_tag_enis"
        elif key == "shouldTagSnapshots":
            suggest = "should_tag_snapshots"
        elif key == "shouldTagVolumes":
            suggest = "should_tag_volumes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupResourceTagSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupResourceTagSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupResourceTagSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_tag_amis: Optional[bool] = None,
                 should_tag_enis: Optional[bool] = None,
                 should_tag_snapshots: Optional[bool] = None,
                 should_tag_volumes: Optional[bool] = None):
        """
        :param bool should_tag_amis: Tag specification for AMI resources.
        :param bool should_tag_enis: Tag specification for ENI resources.
        :param bool should_tag_snapshots: Tag specification for Snapshot resources.
        :param bool should_tag_volumes: Tag specification for Volume resources.
        """
        if should_tag_amis is not None:
            pulumi.set(__self__, "should_tag_amis", should_tag_amis)
        if should_tag_enis is not None:
            pulumi.set(__self__, "should_tag_enis", should_tag_enis)
        if should_tag_snapshots is not None:
            pulumi.set(__self__, "should_tag_snapshots", should_tag_snapshots)
        if should_tag_volumes is not None:
            pulumi.set(__self__, "should_tag_volumes", should_tag_volumes)

    @property
    @pulumi.getter(name="shouldTagAmis")
    def should_tag_amis(self) -> Optional[bool]:
        """
        Tag specification for AMI resources.
        """
        return pulumi.get(self, "should_tag_amis")

    @property
    @pulumi.getter(name="shouldTagEnis")
    def should_tag_enis(self) -> Optional[bool]:
        """
        Tag specification for ENI resources.
        """
        return pulumi.get(self, "should_tag_enis")

    @property
    @pulumi.getter(name="shouldTagSnapshots")
    def should_tag_snapshots(self) -> Optional[bool]:
        """
        Tag specification for Snapshot resources.
        """
        return pulumi.get(self, "should_tag_snapshots")

    @property
    @pulumi.getter(name="shouldTagVolumes")
    def should_tag_volumes(self) -> Optional[bool]:
        """
        Tag specification for Volume resources.
        """
        return pulumi.get(self, "should_tag_volumes")


@pulumi.output_type
class ElastigroupRevertToSpot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"
        elif key == "timeWindows":
            suggest = "time_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupRevertToSpot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupRevertToSpot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupRevertToSpot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: str,
                 time_windows: Optional[Sequence[str]] = None):
        """
        :param str perform_at: In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
        :param Sequence[str] time_windows: Specify a list of time windows for to execute revertToSpot strategy. Time window format: `ddd:hh:mm-ddd:hh:mm`. Example: `Mon:03:00-Wed:02:30`
        """
        pulumi.set(__self__, "perform_at", perform_at)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> str:
        """
        In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
        """
        return pulumi.get(self, "perform_at")

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[Sequence[str]]:
        """
        Specify a list of time windows for to execute revertToSpot strategy. Time window format: `ddd:hh:mm-ddd:hh:mm`. Example: `Mon:03:00-Wed:02:30`
        """
        return pulumi.get(self, "time_windows")


@pulumi.output_type
class ElastigroupScalingDownPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"
        elif key == "stepAdjustments":
            suggest = "step_adjustments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingDownPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingDownPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingDownPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingDownPolicyDimension']] = None,
                 evaluation_periods: Optional[int] = None,
                 is_enabled: Optional[bool] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 source: Optional[str] = None,
                 statistic: Optional[str] = None,
                 step_adjustments: Optional[Sequence['outputs.ElastigroupScalingDownPolicyStepAdjustment']] = None,
                 target: Optional[str] = None,
                 threshold: Optional[float] = None,
                 unit: Optional[str] = None):
        """
        :param str metric_name: The name of the metric, with or without spaces.
        :param str namespace: The namespace for the alarm's associated metric.
        :param str policy_name: The name of the policy.
        :param str action_type: The type of action to perform for scaling. Valid values: `"adjustment"`, `"percentageAdjustment"`, `"setMaxTarget"`, `"setMinTarget"`, `"updateCapacity"`. If a `step_adjustment` object is defined, then it cannot be specified.
        :param str adjustment: The number of instances to add/remove to/from the target capacity when scale is needed. Can be used as advanced expression for scaling of instances to add/remove to/from the target capacity when scale is needed. You can see more information here: Advanced expression. Example value: `"MAX(currCapacity / 5, value * 10)"`
        :param int cooldown: The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.
        :param Sequence['ElastigroupScalingDownPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param int evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param bool is_enabled: Specifies whether the scaling policy described in this block is enabled.
        :param str max_target_capacity: . The number of the desired target (and maximum) capacity
        :param str maximum: The maximal number of instances to have in the group.
        :param str minimum: The minimal number of instances to have in the group.
        :param str operator: The operator to use in order to determine if the scaling policy is applicable. Valid values: `"gt"`, `"gte"`, `"lt"`, `"lte"`.
        :param int period: The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        :param str source: The source of the metric. Valid values: `"cloudWatch"`, `"spectrum"`.
        :param str statistic: The metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        :param str target: The target number of instances to have in the group.
        :param float threshold: The value against which the specified statistic is compared. If a `step_adjustment` object is defined, then it cannot be specified.
        :param str unit: The unit for the alarm's associated metric. Valid values: `"percent`, `"seconds"`, `"microseconds"`, `"milliseconds"`, `"bytes"`, `"kilobytes"`, `"megabytes"`, `"gigabytes"`, `"terabytes"`, `"bits"`, `"kilobits"`, `"megabits"`, `"gigabits"`, `"terabits"`, `"count"`, `"bytes/second"`, `"kilobytes/second"`, `"megabytes/second"`, `"gigabytes/second"`, `"terabytes/second"`, `"bits/second"`, `"kilobits/second"`, `"megabits/second"`, `"gigabits/second"`, `"terabits/second"`, `"count/second"`, `"none"`.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if step_adjustments is not None:
            pulumi.set(__self__, "step_adjustments", step_adjustments)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric, with or without spaces.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace for the alarm's associated metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        The type of action to perform for scaling. Valid values: `"adjustment"`, `"percentageAdjustment"`, `"setMaxTarget"`, `"setMinTarget"`, `"updateCapacity"`. If a `step_adjustment` object is defined, then it cannot be specified.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add/remove to/from the target capacity when scale is needed. Can be used as advanced expression for scaling of instances to add/remove to/from the target capacity when scale is needed. You can see more information here: Advanced expression. Example value: `"MAX(currCapacity / 5, value * 10)"`
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingDownPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether the scaling policy described in this block is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        """
        . The number of the desired target (and maximum) capacity
        """
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        """
        The maximal number of instances to have in the group.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        """
        The minimal number of instances to have in the group.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator to use in order to determine if the scaling policy is applicable. Valid values: `"gt"`, `"gte"`, `"lt"`, `"lte"`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        The source of the metric. Valid values: `"cloudWatch"`, `"spectrum"`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        The metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Optional[Sequence['outputs.ElastigroupScalingDownPolicyStepAdjustment']]:
        return pulumi.get(self, "step_adjustments")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target number of instances to have in the group.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The value against which the specified statistic is compared. If a `step_adjustment` object is defined, then it cannot be specified.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit for the alarm's associated metric. Valid values: `"percent`, `"seconds"`, `"microseconds"`, `"milliseconds"`, `"bytes"`, `"kilobytes"`, `"megabytes"`, `"gigabytes"`, `"terabytes"`, `"bits"`, `"kilobits"`, `"megabits"`, `"gigabits"`, `"terabits"`, `"count"`, `"bytes/second"`, `"kilobytes/second"`, `"megabytes/second"`, `"gigabytes/second"`, `"terabytes/second"`, `"bits/second"`, `"kilobits/second"`, `"megabits/second"`, `"gigabits/second"`, `"terabits/second"`, `"count/second"`, `"none"`.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ElastigroupScalingDownPolicyDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The dimension name.
        :param str value: The dimension value.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The dimension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The dimension value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScalingDownPolicyStepAdjustment(dict):
    def __init__(__self__, *,
                 action: 'outputs.ElastigroupScalingDownPolicyStepAdjustmentAction',
                 threshold: int):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.ElastigroupScalingDownPolicyStepAdjustmentAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def threshold(self) -> int:
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ElastigroupScalingDownPolicyStepAdjustmentAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingDownPolicyStepAdjustmentAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingDownPolicyStepAdjustmentAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingDownPolicyStepAdjustmentAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 adjustment: Optional[str] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 target: Optional[str] = None):
        pulumi.set(__self__, "type", type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")


@pulumi.output_type
class ElastigroupScalingStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "terminateAtEndOfBillingHour":
            suggest = "terminate_at_end_of_billing_hour"
        elif key == "terminationPolicy":
            suggest = "termination_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 terminate_at_end_of_billing_hour: Optional[bool] = None,
                 termination_policy: Optional[str] = None):
        """
        :param bool terminate_at_end_of_billing_hour: Specify whether to terminate instances at the end of each billing hour.
        :param str termination_policy: Determines whether to terminate the newest instances when performing a scaling action. Valid values: `"default"`, `"newestInstance"`.
        """
        if terminate_at_end_of_billing_hour is not None:
            pulumi.set(__self__, "terminate_at_end_of_billing_hour", terminate_at_end_of_billing_hour)
        if termination_policy is not None:
            pulumi.set(__self__, "termination_policy", termination_policy)

    @property
    @pulumi.getter(name="terminateAtEndOfBillingHour")
    def terminate_at_end_of_billing_hour(self) -> Optional[bool]:
        """
        Specify whether to terminate instances at the end of each billing hour.
        """
        return pulumi.get(self, "terminate_at_end_of_billing_hour")

    @property
    @pulumi.getter(name="terminationPolicy")
    def termination_policy(self) -> Optional[str]:
        """
        Determines whether to terminate the newest instances when performing a scaling action. Valid values: `"default"`, `"newestInstance"`.
        """
        return pulumi.get(self, "termination_policy")


@pulumi.output_type
class ElastigroupScalingTargetPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxCapacityPerScale":
            suggest = "max_capacity_per_scale"
        elif key == "predictiveMode":
            suggest = "predictive_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingTargetPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingTargetPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingTargetPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 target: float,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingTargetPolicyDimension']] = None,
                 evaluation_periods: Optional[int] = None,
                 max_capacity_per_scale: Optional[str] = None,
                 period: Optional[int] = None,
                 predictive_mode: Optional[str] = None,
                 source: Optional[str] = None,
                 statistic: Optional[str] = None,
                 unit: Optional[str] = None):
        """
        :param str metric_name: String, the name of the metric, with or without spaces.
        :param str namespace: String, the namespace for the alarm's associated metric.
        :param str policy_name: String, the name of the policy.
        :param float target: The target number of instances to have in the group.
        :param int cooldown: Integer the amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.
        :param Sequence['ElastigroupScalingTargetPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param int evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param str max_capacity_per_scale: String, restrict the maximal number of instances which can be added in each scale-up action.
               
               `scaling_target_policies` support predictive scaling:
        :param int period: The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        :param str predictive_mode: Start a metric prediction process to determine the expected target metric value within the next two days. See [Predictive Autoscaling](https://api.spotinst.com/elastigroup-for-aws/concepts/scaling-concepts/predictive-autoscaling/) documentation for more info. Valid values: `FORECAST_AND_SCALE`, `FORECAST_ONLY`.
               
               Usage:
        :param str source: String, the source of the metric. Valid values: `"cloudWatch"`, `"spectrum"`.
        :param str statistic: String, the metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        :param str unit: String, tThe unit for the alarm's associated metric. Valid values: `"percent`, `"seconds"`, `"microseconds"`, `"milliseconds"`, `"bytes"`, `"kilobytes"`, `"megabytes"`, `"gigabytes"`, `"terabytes"`, `"bits"`, `"kilobits"`, `"megabits"`, `"gigabits"`, `"terabits"`, `"count"`, `"bytes/second"`, `"kilobytes/second"`, `"megabytes/second"`, `"gigabytes/second"`, `"terabytes/second"`, `"bits/second"`, `"kilobits/second"`, `"megabits/second"`, `"gigabits/second"`, `"terabits/second"`, `"count/second"`, `"none"`.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "target", target)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_capacity_per_scale is not None:
            pulumi.set(__self__, "max_capacity_per_scale", max_capacity_per_scale)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if predictive_mode is not None:
            pulumi.set(__self__, "predictive_mode", predictive_mode)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        String, the name of the metric, with or without spaces.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        String, the namespace for the alarm's associated metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        String, the name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def target(self) -> float:
        """
        The target number of instances to have in the group.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        Integer the amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingTargetPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxCapacityPerScale")
    def max_capacity_per_scale(self) -> Optional[str]:
        """
        String, restrict the maximal number of instances which can be added in each scale-up action.

        `scaling_target_policies` support predictive scaling:
        """
        return pulumi.get(self, "max_capacity_per_scale")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="predictiveMode")
    def predictive_mode(self) -> Optional[str]:
        """
        Start a metric prediction process to determine the expected target metric value within the next two days. See [Predictive Autoscaling](https://api.spotinst.com/elastigroup-for-aws/concepts/scaling-concepts/predictive-autoscaling/) documentation for more info. Valid values: `FORECAST_AND_SCALE`, `FORECAST_ONLY`.

        Usage:
        """
        return pulumi.get(self, "predictive_mode")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        String, the source of the metric. Valid values: `"cloudWatch"`, `"spectrum"`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        String, the metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        String, tThe unit for the alarm's associated metric. Valid values: `"percent`, `"seconds"`, `"microseconds"`, `"milliseconds"`, `"bytes"`, `"kilobytes"`, `"megabytes"`, `"gigabytes"`, `"terabytes"`, `"bits"`, `"kilobits"`, `"megabits"`, `"gigabits"`, `"terabits"`, `"count"`, `"bytes/second"`, `"kilobytes/second"`, `"megabytes/second"`, `"gigabytes/second"`, `"terabytes/second"`, `"bits/second"`, `"kilobits/second"`, `"megabits/second"`, `"gigabits/second"`, `"terabits/second"`, `"count/second"`, `"none"`.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ElastigroupScalingTargetPolicyDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: String, the dimension name.
        :param str value: String, the dimension value.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        String, the dimension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        String, the dimension value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScalingUpPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"
        elif key == "stepAdjustments":
            suggest = "step_adjustments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingUpPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingUpPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingUpPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingUpPolicyDimension']] = None,
                 evaluation_periods: Optional[int] = None,
                 is_enabled: Optional[bool] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 source: Optional[str] = None,
                 statistic: Optional[str] = None,
                 step_adjustments: Optional[Sequence['outputs.ElastigroupScalingUpPolicyStepAdjustment']] = None,
                 target: Optional[str] = None,
                 threshold: Optional[float] = None,
                 unit: Optional[str] = None):
        """
        :param str metric_name: The name of the metric, with or without spaces.
        :param str namespace: The namespace for the alarm's associated metric.
        :param str policy_name: The name of the policy.
        :param str action_type: The type of action to perform for scaling. Valid values: `"adjustment"`, `"percentageAdjustment"`, `"setMaxTarget"`, `"setMinTarget"`, `"updateCapacity"`. If a `step_adjustment` object is defined, then it cannot be specified.
        :param str adjustment: The number of instances to add/remove to/from the target capacity when scale is needed. Can be used as advanced expression for scaling of instances to add/remove to/from the target capacity when scale is needed. You can see more information here: Advanced expression. Example value: `"MAX(currCapacity / 5, value * 10)"`
        :param int cooldown: The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.
        :param Sequence['ElastigroupScalingUpPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param int evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param bool is_enabled: Specifies whether the scaling policy described in this block is enabled.
        :param str maximum: The maximal number of instances to have in the group.
        :param str min_target_capacity: . The number of the desired target (and minimum) capacity
        :param str minimum: The minimal number of instances to have in the group.
        :param str operator: The operator to use in order to determine if the scaling policy is applicable. Valid values: `"gt"`, `"gte"`, `"lt"`, `"lte"`.
        :param int period: The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        :param str source: The source of the metric. Valid values: `"cloudWatch"`, `"spectrum"`.
        :param str statistic: The metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        :param str target: The target number of instances to have in the group.
        :param float threshold: The value against which the specified statistic is compared. If a `step_adjustment` object is defined, then it cannot be specified.
        :param str unit: The unit for the alarm's associated metric. Valid values: `"percent`, `"seconds"`, `"microseconds"`, `"milliseconds"`, `"bytes"`, `"kilobytes"`, `"megabytes"`, `"gigabytes"`, `"terabytes"`, `"bits"`, `"kilobits"`, `"megabits"`, `"gigabits"`, `"terabits"`, `"count"`, `"bytes/second"`, `"kilobytes/second"`, `"megabytes/second"`, `"gigabytes/second"`, `"terabytes/second"`, `"bits/second"`, `"kilobits/second"`, `"megabits/second"`, `"gigabits/second"`, `"terabits/second"`, `"count/second"`, `"none"`.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if step_adjustments is not None:
            pulumi.set(__self__, "step_adjustments", step_adjustments)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric, with or without spaces.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace for the alarm's associated metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        The type of action to perform for scaling. Valid values: `"adjustment"`, `"percentageAdjustment"`, `"setMaxTarget"`, `"setMinTarget"`, `"updateCapacity"`. If a `step_adjustment` object is defined, then it cannot be specified.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add/remove to/from the target capacity when scale is needed. Can be used as advanced expression for scaling of instances to add/remove to/from the target capacity when scale is needed. You can see more information here: Advanced expression. Example value: `"MAX(currCapacity / 5, value * 10)"`
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start. If this parameter is not specified, the default cooldown period for the group applies.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingUpPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Specifies whether the scaling policy described in this block is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        """
        The maximal number of instances to have in the group.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        """
        . The number of the desired target (and minimum) capacity
        """
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        """
        The minimal number of instances to have in the group.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator to use in order to determine if the scaling policy is applicable. Valid values: `"gt"`, `"gte"`, `"lt"`, `"lte"`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        The source of the metric. Valid values: `"cloudWatch"`, `"spectrum"`.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        The metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Optional[Sequence['outputs.ElastigroupScalingUpPolicyStepAdjustment']]:
        return pulumi.get(self, "step_adjustments")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target number of instances to have in the group.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The value against which the specified statistic is compared. If a `step_adjustment` object is defined, then it cannot be specified.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit for the alarm's associated metric. Valid values: `"percent`, `"seconds"`, `"microseconds"`, `"milliseconds"`, `"bytes"`, `"kilobytes"`, `"megabytes"`, `"gigabytes"`, `"terabytes"`, `"bits"`, `"kilobits"`, `"megabits"`, `"gigabits"`, `"terabits"`, `"count"`, `"bytes/second"`, `"kilobytes/second"`, `"megabytes/second"`, `"gigabytes/second"`, `"terabytes/second"`, `"bits/second"`, `"kilobits/second"`, `"megabits/second"`, `"gigabits/second"`, `"terabits/second"`, `"count/second"`, `"none"`.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ElastigroupScalingUpPolicyDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The dimension name.
        :param str value: The dimension value.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The dimension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The dimension value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScalingUpPolicyStepAdjustment(dict):
    def __init__(__self__, *,
                 action: 'outputs.ElastigroupScalingUpPolicyStepAdjustmentAction',
                 threshold: int):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.ElastigroupScalingUpPolicyStepAdjustmentAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def threshold(self) -> int:
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ElastigroupScalingUpPolicyStepAdjustmentAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingUpPolicyStepAdjustmentAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingUpPolicyStepAdjustmentAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingUpPolicyStepAdjustmentAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 adjustment: Optional[str] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 target: Optional[str] = None):
        pulumi.set(__self__, "type", type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")


@pulumi.output_type
class ElastigroupScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "adjustmentPercentage":
            suggest = "adjustment_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "cronExpression":
            suggest = "cron_expression"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "scaleMaxCapacity":
            suggest = "scale_max_capacity"
        elif key == "scaleMinCapacity":
            suggest = "scale_min_capacity"
        elif key == "scaleTargetCapacity":
            suggest = "scale_target_capacity"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 adjustment: Optional[str] = None,
                 adjustment_percentage: Optional[str] = None,
                 batch_size_percentage: Optional[str] = None,
                 cron_expression: Optional[str] = None,
                 frequency: Optional[str] = None,
                 grace_period: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 max_capacity: Optional[str] = None,
                 min_capacity: Optional[str] = None,
                 scale_max_capacity: Optional[str] = None,
                 scale_min_capacity: Optional[str] = None,
                 scale_target_capacity: Optional[str] = None,
                 start_time: Optional[str] = None,
                 target_capacity: Optional[str] = None):
        """
        :param str task_type: The task type to run. Supported task types are: `"scale"`, `"backup_ami"`, `"roll"`, `"scaleUp"`, `"percentageScaleUp"`, `"scaleDown"`, `"percentageScaleDown"`, `"statefulUpdateCapacity"`.
        :param str adjustment: The number of instances to add or remove.
        :param str adjustment_percentage: The percentage of instances to add or remove.
               
               Usage:
        :param str batch_size_percentage: The percentage size of each batch in the scheduled deployment roll.
        :param str cron_expression: A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        :param str frequency: The recurrence frequency to run this task. Supported values are `"hourly"`, `"daily"`, `"weekly"` and `"continuous"`.
        :param str grace_period: The period of time (seconds) to wait before checking a batch's health after it's deployment.
        :param bool is_enabled: Setting the task to being enabled or disabled.
        :param str max_capacity: The maximum number of instances the group should have.
        :param str min_capacity: The minimum number of instances the group should have.
        :param str scale_max_capacity: The maximum number of instances the group should have.
        :param str scale_min_capacity: The minimum number of instances the group should have.
        :param str scale_target_capacity: The desired number of instances the group should have.
        :param str start_time: Set a start time for one time tasks.
        :param str target_capacity: The desired number of instances the group should have.
        """
        pulumi.set(__self__, "task_type", task_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if adjustment_percentage is not None:
            pulumi.set(__self__, "adjustment_percentage", adjustment_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if scale_max_capacity is not None:
            pulumi.set(__self__, "scale_max_capacity", scale_max_capacity)
        if scale_min_capacity is not None:
            pulumi.set(__self__, "scale_min_capacity", scale_min_capacity)
        if scale_target_capacity is not None:
            pulumi.set(__self__, "scale_target_capacity", scale_target_capacity)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        The task type to run. Supported task types are: `"scale"`, `"backup_ami"`, `"roll"`, `"scaleUp"`, `"percentageScaleUp"`, `"scaleDown"`, `"percentageScaleDown"`, `"statefulUpdateCapacity"`.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add or remove.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter(name="adjustmentPercentage")
    def adjustment_percentage(self) -> Optional[str]:
        """
        The percentage of instances to add or remove.

        Usage:
        """
        return pulumi.get(self, "adjustment_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[str]:
        """
        The percentage size of each batch in the scheduled deployment roll.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[str]:
        """
        A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        The recurrence frequency to run this task. Supported values are `"hourly"`, `"daily"`, `"weekly"` and `"continuous"`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[str]:
        """
        The period of time (seconds) to wait before checking a batch's health after it's deployment.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Setting the task to being enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[str]:
        """
        The maximum number of instances the group should have.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[str]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="scaleMaxCapacity")
    def scale_max_capacity(self) -> Optional[str]:
        """
        The maximum number of instances the group should have.
        """
        return pulumi.get(self, "scale_max_capacity")

    @property
    @pulumi.getter(name="scaleMinCapacity")
    def scale_min_capacity(self) -> Optional[str]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "scale_min_capacity")

    @property
    @pulumi.getter(name="scaleTargetCapacity")
    def scale_target_capacity(self) -> Optional[str]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "scale_target_capacity")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Set a start time for one time tasks.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[str]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ElastigroupSignal(dict):
    def __init__(__self__, *,
                 name: str,
                 timeout: Optional[int] = None):
        """
        :param str name: The name of the signal defined for the group. Valid Values: `"INSTANCE_READY"`, `"INSTANCE_READY_TO_SHUTDOWN"`
        :param int timeout: The signals defined timeout- default is 40 minutes (1800 seconds).
               
               Usage:
        """
        pulumi.set(__self__, "name", name)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the signal defined for the group. Valid Values: `"INSTANCE_READY"`, `"INSTANCE_READY_TO_SHUTDOWN"`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The signals defined timeout- default is 40 minutes (1800 seconds).

        Usage:
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ElastigroupStatefulDeallocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldDeleteImages":
            suggest = "should_delete_images"
        elif key == "shouldDeleteNetworkInterfaces":
            suggest = "should_delete_network_interfaces"
        elif key == "shouldDeleteSnapshots":
            suggest = "should_delete_snapshots"
        elif key == "shouldDeleteVolumes":
            suggest = "should_delete_volumes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupStatefulDeallocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupStatefulDeallocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupStatefulDeallocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_delete_images: Optional[bool] = None,
                 should_delete_network_interfaces: Optional[bool] = None,
                 should_delete_snapshots: Optional[bool] = None,
                 should_delete_volumes: Optional[bool] = None):
        """
        :param bool should_delete_images: For stateful groups: remove persistent images.
        :param bool should_delete_network_interfaces: For stateful groups: remove network interfaces.
        :param bool should_delete_snapshots: For stateful groups: remove snapshots.
               
               Usage:
        :param bool should_delete_volumes: For stateful groups: remove persistent volumes.
        """
        if should_delete_images is not None:
            pulumi.set(__self__, "should_delete_images", should_delete_images)
        if should_delete_network_interfaces is not None:
            pulumi.set(__self__, "should_delete_network_interfaces", should_delete_network_interfaces)
        if should_delete_snapshots is not None:
            pulumi.set(__self__, "should_delete_snapshots", should_delete_snapshots)
        if should_delete_volumes is not None:
            pulumi.set(__self__, "should_delete_volumes", should_delete_volumes)

    @property
    @pulumi.getter(name="shouldDeleteImages")
    def should_delete_images(self) -> Optional[bool]:
        """
        For stateful groups: remove persistent images.
        """
        return pulumi.get(self, "should_delete_images")

    @property
    @pulumi.getter(name="shouldDeleteNetworkInterfaces")
    def should_delete_network_interfaces(self) -> Optional[bool]:
        """
        For stateful groups: remove network interfaces.
        """
        return pulumi.get(self, "should_delete_network_interfaces")

    @property
    @pulumi.getter(name="shouldDeleteSnapshots")
    def should_delete_snapshots(self) -> Optional[bool]:
        """
        For stateful groups: remove snapshots.

        Usage:
        """
        return pulumi.get(self, "should_delete_snapshots")

    @property
    @pulumi.getter(name="shouldDeleteVolumes")
    def should_delete_volumes(self) -> Optional[bool]:
        """
        For stateful groups: remove persistent volumes.
        """
        return pulumi.get(self, "should_delete_volumes")


@pulumi.output_type
class ElastigroupStatefulInstanceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statefulInstanceId":
            suggest = "stateful_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupStatefulInstanceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupStatefulInstanceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupStatefulInstanceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stateful_instance_id: str,
                 type: str):
        """
        :param str stateful_instance_id: String, Stateful Instance ID on which the action should be performed.
        :param str type: String, Action type. Supported action types: `pause`, `resume`, `recycle`, `deallocate`.
               
               Usage:
        """
        pulumi.set(__self__, "stateful_instance_id", stateful_instance_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="statefulInstanceId")
    def stateful_instance_id(self) -> str:
        """
        String, Stateful Instance ID on which the action should be performed.
        """
        return pulumi.get(self, "stateful_instance_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        String, Action type. Supported action types: `pause`, `resume`, `recycle`, `deallocate`.

        Usage:
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldResumeStateful":
            suggest = "should_resume_stateful"
        elif key == "shouldRoll":
            suggest = "should_roll"
        elif key == "autoApplyTags":
            suggest = "auto_apply_tags"
        elif key == "rollConfig":
            suggest = "roll_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_resume_stateful: bool,
                 should_roll: bool,
                 auto_apply_tags: Optional[bool] = None,
                 roll_config: Optional['outputs.ElastigroupUpdatePolicyRollConfig'] = None):
        """
        :param bool should_resume_stateful: This will apply resuming action for Stateful instances in the Elastigroup upon scale up or capacity changes. Example usage will be for Elastigroups that will have scheduling rules to set a target capacity of 0 instances in the night and automatically restore the same state of the instances in the morning.
        :param bool should_roll: Sets the enablement of the roll option.
        :param bool auto_apply_tags: Enables updates to tags without rolling the group when set to `true`.
        :param 'ElastigroupUpdatePolicyRollConfigArgs' roll_config: While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        pulumi.set(__self__, "should_resume_stateful", should_resume_stateful)
        pulumi.set(__self__, "should_roll", should_roll)
        if auto_apply_tags is not None:
            pulumi.set(__self__, "auto_apply_tags", auto_apply_tags)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @property
    @pulumi.getter(name="shouldResumeStateful")
    def should_resume_stateful(self) -> bool:
        """
        This will apply resuming action for Stateful instances in the Elastigroup upon scale up or capacity changes. Example usage will be for Elastigroups that will have scheduling rules to set a target capacity of 0 instances in the night and automatically restore the same state of the instances in the morning.
        """
        return pulumi.get(self, "should_resume_stateful")

    @property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> bool:
        """
        Sets the enablement of the roll option.
        """
        return pulumi.get(self, "should_roll")

    @property
    @pulumi.getter(name="autoApplyTags")
    def auto_apply_tags(self) -> Optional[bool]:
        """
        Enables updates to tags without rolling the group when set to `true`.
        """
        return pulumi.get(self, "auto_apply_tags")

    @property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional['outputs.ElastigroupUpdatePolicyRollConfig']:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "roll_config")


@pulumi.output_type
class ElastigroupUpdatePolicyRollConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "healthCheckType":
            suggest = "health_check_type"
        elif key == "waitForRollPercentage":
            suggest = "wait_for_roll_percentage"
        elif key == "waitForRollTimeout":
            suggest = "wait_for_roll_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupUpdatePolicyRollConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupUpdatePolicyRollConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupUpdatePolicyRollConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size_percentage: int,
                 grace_period: Optional[int] = None,
                 health_check_type: Optional[str] = None,
                 strategy: Optional['outputs.ElastigroupUpdatePolicyRollConfigStrategy'] = None,
                 wait_for_roll_percentage: Optional[float] = None,
                 wait_for_roll_timeout: Optional[int] = None):
        """
        :param int batch_size_percentage: Sets the percentage of the instances to deploy in each batch.
        :param int grace_period: Sets the grace period for new instances to become healthy.
        :param str health_check_type: Sets the health check type to use. Valid values: `"EC2"`, `"ECS_CLUSTER_INSTANCE"`, `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"NONE"`.
        :param 'ElastigroupUpdatePolicyRollConfigStrategyArgs' strategy: Strategy parameters
        :param float wait_for_roll_percentage: For use with `should_roll`. Sets minimum % of roll required to complete before continuing the plan. Required if `wait_for_roll_timeout` is set.
        :param int wait_for_roll_timeout: For use with `should_roll`. Sets how long to wait for the deployed % of a roll to exceed `wait_for_roll_percentage` before continuing the plan. Required if `wait_for_roll_percentage` is set.
        """
        pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if wait_for_roll_percentage is not None:
            pulumi.set(__self__, "wait_for_roll_percentage", wait_for_roll_percentage)
        if wait_for_roll_timeout is not None:
            pulumi.set(__self__, "wait_for_roll_timeout", wait_for_roll_timeout)

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> int:
        """
        Sets the percentage of the instances to deploy in each batch.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[int]:
        """
        Sets the grace period for new instances to become healthy.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[str]:
        """
        Sets the health check type to use. Valid values: `"EC2"`, `"ECS_CLUSTER_INSTANCE"`, `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"NONE"`.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.ElastigroupUpdatePolicyRollConfigStrategy']:
        """
        Strategy parameters
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="waitForRollPercentage")
    def wait_for_roll_percentage(self) -> Optional[float]:
        """
        For use with `should_roll`. Sets minimum % of roll required to complete before continuing the plan. Required if `wait_for_roll_timeout` is set.
        """
        return pulumi.get(self, "wait_for_roll_percentage")

    @property
    @pulumi.getter(name="waitForRollTimeout")
    def wait_for_roll_timeout(self) -> Optional[int]:
        """
        For use with `should_roll`. Sets how long to wait for the deployed % of a roll to exceed `wait_for_roll_percentage` before continuing the plan. Required if `wait_for_roll_percentage` is set.
        """
        return pulumi.get(self, "wait_for_roll_timeout")


@pulumi.output_type
class ElastigroupUpdatePolicyRollConfigStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "onFailure":
            suggest = "on_failure"
        elif key == "shouldDrainInstances":
            suggest = "should_drain_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupUpdatePolicyRollConfigStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupUpdatePolicyRollConfigStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupUpdatePolicyRollConfigStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 batch_min_healthy_percentage: Optional[int] = None,
                 on_failure: Optional['outputs.ElastigroupUpdatePolicyRollConfigStrategyOnFailure'] = None,
                 should_drain_instances: Optional[bool] = None):
        """
        :param str action: Action to take. Valid values: `REPLACE_SERVER`, `RESTART_SERVER`.
        :param int batch_min_healthy_percentage: Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the deployment will fail. Range `1` - `100`.
        :param 'ElastigroupUpdatePolicyRollConfigStrategyOnFailureArgs' on_failure: Set detach options to the deployment.
        :param bool should_drain_instances: Specify whether to drain incoming TCP connections before terminating a server.
        """
        pulumi.set(__self__, "action", action)
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if should_drain_instances is not None:
            pulumi.set(__self__, "should_drain_instances", should_drain_instances)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action to take. Valid values: `REPLACE_SERVER`, `RESTART_SERVER`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[int]:
        """
        Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the deployment will fail. Range `1` - `100`.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.ElastigroupUpdatePolicyRollConfigStrategyOnFailure']:
        """
        Set detach options to the deployment.
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="shouldDrainInstances")
    def should_drain_instances(self) -> Optional[bool]:
        """
        Specify whether to drain incoming TCP connections before terminating a server.
        """
        return pulumi.get(self, "should_drain_instances")


@pulumi.output_type
class ElastigroupUpdatePolicyRollConfigStrategyOnFailure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "batchNum":
            suggest = "batch_num"
        elif key == "drainingTimeout":
            suggest = "draining_timeout"
        elif key == "shouldDecrementTargetCapacity":
            suggest = "should_decrement_target_capacity"
        elif key == "shouldHandleAllBatches":
            suggest = "should_handle_all_batches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupUpdatePolicyRollConfigStrategyOnFailure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupUpdatePolicyRollConfigStrategyOnFailure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupUpdatePolicyRollConfigStrategyOnFailure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 batch_num: Optional[int] = None,
                 draining_timeout: Optional[int] = None,
                 should_decrement_target_capacity: Optional[bool] = None,
                 should_handle_all_batches: Optional[bool] = None):
        """
        :param str action_type: Sets the action that will take place, Accepted values are: `DETACH_OLD`, `DETACH_NEW`.
        :param int draining_timeout: Indicates (in seconds) the timeout to wait until instance are detached.
        :param bool should_decrement_target_capacity: Decrementing the group target capacity after detaching the instances.
        :param bool should_handle_all_batches: Indicator if the action should apply to all batches of the deployment or only the latest batch.
        """
        pulumi.set(__self__, "action_type", action_type)
        if batch_num is not None:
            pulumi.set(__self__, "batch_num", batch_num)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if should_decrement_target_capacity is not None:
            pulumi.set(__self__, "should_decrement_target_capacity", should_decrement_target_capacity)
        if should_handle_all_batches is not None:
            pulumi.set(__self__, "should_handle_all_batches", should_handle_all_batches)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        Sets the action that will take place, Accepted values are: `DETACH_OLD`, `DETACH_NEW`.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="batchNum")
    def batch_num(self) -> Optional[int]:
        return pulumi.get(self, "batch_num")

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[int]:
        """
        Indicates (in seconds) the timeout to wait until instance are detached.
        """
        return pulumi.get(self, "draining_timeout")

    @property
    @pulumi.getter(name="shouldDecrementTargetCapacity")
    def should_decrement_target_capacity(self) -> Optional[bool]:
        """
        Decrementing the group target capacity after detaching the instances.
        """
        return pulumi.get(self, "should_decrement_target_capacity")

    @property
    @pulumi.getter(name="shouldHandleAllBatches")
    def should_handle_all_batches(self) -> Optional[bool]:
        """
        Indicator if the action should apply to all batches of the deployment or only the latest batch.
        """
        return pulumi.get(self, "should_handle_all_batches")


@pulumi.output_type
class ManagedInstanceBlockDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 ebs: Optional['outputs.ManagedInstanceBlockDeviceMappingEbs'] = None):
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.ManagedInstanceBlockDeviceMappingEbs']:
        return pulumi.get(self, "ebs")


@pulumi.output_type
class ManagedInstanceBlockDeviceMappingEbs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceBlockDeviceMappingEbs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceBlockDeviceMappingEbs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceBlockDeviceMappingEbs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 throughput: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ManagedInstanceDelete(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiBackupShouldDeleteImages":
            suggest = "ami_backup_should_delete_images"
        elif key == "deallocationConfigShouldDeleteImages":
            suggest = "deallocation_config_should_delete_images"
        elif key == "shouldDeleteNetworkInterfaces":
            suggest = "should_delete_network_interfaces"
        elif key == "shouldDeleteSnapshots":
            suggest = "should_delete_snapshots"
        elif key == "shouldDeleteVolumes":
            suggest = "should_delete_volumes"
        elif key == "shouldTerminateInstance":
            suggest = "should_terminate_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceDelete. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceDelete.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceDelete.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_backup_should_delete_images: Optional[bool] = None,
                 deallocation_config_should_delete_images: Optional[bool] = None,
                 should_delete_network_interfaces: Optional[bool] = None,
                 should_delete_snapshots: Optional[bool] = None,
                 should_delete_volumes: Optional[bool] = None,
                 should_terminate_instance: Optional[bool] = None):
        if ami_backup_should_delete_images is not None:
            pulumi.set(__self__, "ami_backup_should_delete_images", ami_backup_should_delete_images)
        if deallocation_config_should_delete_images is not None:
            pulumi.set(__self__, "deallocation_config_should_delete_images", deallocation_config_should_delete_images)
        if should_delete_network_interfaces is not None:
            pulumi.set(__self__, "should_delete_network_interfaces", should_delete_network_interfaces)
        if should_delete_snapshots is not None:
            pulumi.set(__self__, "should_delete_snapshots", should_delete_snapshots)
        if should_delete_volumes is not None:
            pulumi.set(__self__, "should_delete_volumes", should_delete_volumes)
        if should_terminate_instance is not None:
            pulumi.set(__self__, "should_terminate_instance", should_terminate_instance)

    @property
    @pulumi.getter(name="amiBackupShouldDeleteImages")
    def ami_backup_should_delete_images(self) -> Optional[bool]:
        return pulumi.get(self, "ami_backup_should_delete_images")

    @property
    @pulumi.getter(name="deallocationConfigShouldDeleteImages")
    def deallocation_config_should_delete_images(self) -> Optional[bool]:
        return pulumi.get(self, "deallocation_config_should_delete_images")

    @property
    @pulumi.getter(name="shouldDeleteNetworkInterfaces")
    def should_delete_network_interfaces(self) -> Optional[bool]:
        return pulumi.get(self, "should_delete_network_interfaces")

    @property
    @pulumi.getter(name="shouldDeleteSnapshots")
    def should_delete_snapshots(self) -> Optional[bool]:
        return pulumi.get(self, "should_delete_snapshots")

    @property
    @pulumi.getter(name="shouldDeleteVolumes")
    def should_delete_volumes(self) -> Optional[bool]:
        return pulumi.get(self, "should_delete_volumes")

    @property
    @pulumi.getter(name="shouldTerminateInstance")
    def should_terminate_instance(self) -> Optional[bool]:
        return pulumi.get(self, "should_terminate_instance")


@pulumi.output_type
class ManagedInstanceIntegrationRoute53(dict):
    def __init__(__self__, *,
                 domains: Sequence['outputs.ManagedInstanceIntegrationRoute53Domain']):
        pulumi.set(__self__, "domains", domains)

    @property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.ManagedInstanceIntegrationRoute53Domain']:
        return pulumi.get(self, "domains")


@pulumi.output_type
class ManagedInstanceIntegrationRoute53Domain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostedZoneId":
            suggest = "hosted_zone_id"
        elif key == "recordSets":
            suggest = "record_sets"
        elif key == "recordSetType":
            suggest = "record_set_type"
        elif key == "spotinstAcctId":
            suggest = "spotinst_acct_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceIntegrationRoute53Domain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceIntegrationRoute53Domain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceIntegrationRoute53Domain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosted_zone_id: str,
                 record_sets: Sequence['outputs.ManagedInstanceIntegrationRoute53DomainRecordSet'],
                 record_set_type: Optional[str] = None,
                 spotinst_acct_id: Optional[str] = None):
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        pulumi.set(__self__, "record_sets", record_sets)
        if record_set_type is not None:
            pulumi.set(__self__, "record_set_type", record_set_type)
        if spotinst_acct_id is not None:
            pulumi.set(__self__, "spotinst_acct_id", spotinst_acct_id)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> str:
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="recordSets")
    def record_sets(self) -> Sequence['outputs.ManagedInstanceIntegrationRoute53DomainRecordSet']:
        return pulumi.get(self, "record_sets")

    @property
    @pulumi.getter(name="recordSetType")
    def record_set_type(self) -> Optional[str]:
        return pulumi.get(self, "record_set_type")

    @property
    @pulumi.getter(name="spotinstAcctId")
    def spotinst_acct_id(self) -> Optional[str]:
        return pulumi.get(self, "spotinst_acct_id")


@pulumi.output_type
class ManagedInstanceIntegrationRoute53DomainRecordSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePublicDns":
            suggest = "use_public_dns"
        elif key == "usePublicIp":
            suggest = "use_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceIntegrationRoute53DomainRecordSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceIntegrationRoute53DomainRecordSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceIntegrationRoute53DomainRecordSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 use_public_dns: Optional[bool] = None,
                 use_public_ip: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        if use_public_dns is not None:
            pulumi.set(__self__, "use_public_dns", use_public_dns)
        if use_public_ip is not None:
            pulumi.set(__self__, "use_public_ip", use_public_ip)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="usePublicDns")
    def use_public_dns(self) -> Optional[bool]:
        return pulumi.get(self, "use_public_dns")

    @property
    @pulumi.getter(name="usePublicIp")
    def use_public_ip(self) -> Optional[bool]:
        return pulumi.get(self, "use_public_ip")


@pulumi.output_type
class ManagedInstanceLoadBalancer(dict):
    def __init__(__self__, *,
                 type: str,
                 arn: Optional[str] = None,
                 name: Optional[str] = None):
        pulumi.set(__self__, "type", type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class ManagedInstanceManagedInstanceAction(dict):
    def __init__(__self__, *,
                 type: str):
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedInstanceMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpTokens":
            suggest = "http_tokens"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"
        elif key == "instanceMetadataTags":
            suggest = "instance_metadata_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_tokens: str,
                 http_put_response_hop_limit: Optional[int] = None,
                 instance_metadata_tags: Optional[str] = None):
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if instance_metadata_tags is not None:
            pulumi.set(__self__, "instance_metadata_tags", instance_metadata_tags)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> str:
        return pulumi.get(self, "http_tokens")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[int]:
        return pulumi.get(self, "http_put_response_hop_limit")

    @property
    @pulumi.getter(name="instanceMetadataTags")
    def instance_metadata_tags(self) -> Optional[str]:
        return pulumi.get(self, "instance_metadata_tags")


@pulumi.output_type
class ManagedInstanceNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceIndex":
            suggest = "device_index"
        elif key == "associateIpv6Address":
            suggest = "associate_ipv6_address"
        elif key == "associatePublicIpAddress":
            suggest = "associate_public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_index: str,
                 associate_ipv6_address: Optional[bool] = None,
                 associate_public_ip_address: Optional[bool] = None):
        pulumi.set(__self__, "device_index", device_index)
        if associate_ipv6_address is not None:
            pulumi.set(__self__, "associate_ipv6_address", associate_ipv6_address)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)

    @property
    @pulumi.getter(name="deviceIndex")
    def device_index(self) -> str:
        return pulumi.get(self, "device_index")

    @property
    @pulumi.getter(name="associateIpv6Address")
    def associate_ipv6_address(self) -> Optional[bool]:
        return pulumi.get(self, "associate_ipv6_address")

    @property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[bool]:
        return pulumi.get(self, "associate_public_ip_address")


@pulumi.output_type
class ManagedInstanceResourceTagSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldTagAmis":
            suggest = "should_tag_amis"
        elif key == "shouldTagEnis":
            suggest = "should_tag_enis"
        elif key == "shouldTagSnapshots":
            suggest = "should_tag_snapshots"
        elif key == "shouldTagVolumes":
            suggest = "should_tag_volumes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceResourceTagSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceResourceTagSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceResourceTagSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_tag_amis: Optional[bool] = None,
                 should_tag_enis: Optional[bool] = None,
                 should_tag_snapshots: Optional[bool] = None,
                 should_tag_volumes: Optional[bool] = None):
        if should_tag_amis is not None:
            pulumi.set(__self__, "should_tag_amis", should_tag_amis)
        if should_tag_enis is not None:
            pulumi.set(__self__, "should_tag_enis", should_tag_enis)
        if should_tag_snapshots is not None:
            pulumi.set(__self__, "should_tag_snapshots", should_tag_snapshots)
        if should_tag_volumes is not None:
            pulumi.set(__self__, "should_tag_volumes", should_tag_volumes)

    @property
    @pulumi.getter(name="shouldTagAmis")
    def should_tag_amis(self) -> Optional[bool]:
        return pulumi.get(self, "should_tag_amis")

    @property
    @pulumi.getter(name="shouldTagEnis")
    def should_tag_enis(self) -> Optional[bool]:
        return pulumi.get(self, "should_tag_enis")

    @property
    @pulumi.getter(name="shouldTagSnapshots")
    def should_tag_snapshots(self) -> Optional[bool]:
        return pulumi.get(self, "should_tag_snapshots")

    @property
    @pulumi.getter(name="shouldTagVolumes")
    def should_tag_volumes(self) -> Optional[bool]:
        return pulumi.get(self, "should_tag_volumes")


@pulumi.output_type
class ManagedInstanceRevertToSpot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceRevertToSpot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceRevertToSpot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceRevertToSpot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: str):
        pulumi.set(__self__, "perform_at", perform_at)

    @property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> str:
        return pulumi.get(self, "perform_at")


@pulumi.output_type
class ManagedInstanceScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedInstanceScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedInstanceScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedInstanceScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 cron_expression: Optional[str] = None,
                 frequency: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 start_time: Optional[str] = None):
        pulumi.set(__self__, "task_type", task_type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[str]:
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ManagedInstanceTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class MrScalarApplication(dict):
    def __init__(__self__, *,
                 name: str,
                 args: Optional[Sequence[str]] = None,
                 version: Optional[str] = None):
        """
        :param str name: The MrScaler name.
        :param Sequence[str] args: Arguments for EMR to pass to the application.
        :param str version: T he version of the application.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The MrScaler name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments for EMR to pass to the application.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        T he version of the application.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MrScalarBootstrapActionsFile(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class MrScalarConfigurationsFile(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class MrScalarCoreEbsBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeType":
            suggest = "volume_type"
        elif key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarCoreEbsBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarCoreEbsBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarCoreEbsBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gb: int,
                 volume_type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_type", volume_type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> int:
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class MrScalarCoreScalingDownPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarCoreScalingDownPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarCoreScalingDownPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarCoreScalingDownPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 threshold: float,
                 unit: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Mapping[str, str]] = None,
                 evaluation_periods: Optional[int] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 statistic: Optional[str] = None,
                 target: Optional[str] = None):
        """
        :param str policy_name: The name of the policy.
        :param str action_type: The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        :param str adjustment: The number of instances to add/remove to/from the target capacity when scale is needed.
        :param int cooldown: The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        :param Mapping[str, str] dimensions: A mapping of dimensions describing qualities of the metric.
        :param str max_target_capacity: Max target capacity for scale down.
        :param str maximum: The maximum to set when scale is needed.
        :param str min_target_capacity: Min target capacity for scale up.
        :param str minimum: The minimum to set when scale is needed.
        :param str target: The number of instances to set when scale is needed.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add/remove to/from the target capacity when scale is needed.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        """
        Max target capacity for scale down.
        """
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        """
        The maximum to set when scale is needed.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        """
        Min target capacity for scale up.
        """
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        """
        The minimum to set when scale is needed.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The number of instances to set when scale is needed.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MrScalarCoreScalingUpPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarCoreScalingUpPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarCoreScalingUpPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarCoreScalingUpPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 threshold: float,
                 unit: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Mapping[str, str]] = None,
                 evaluation_periods: Optional[int] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 statistic: Optional[str] = None,
                 target: Optional[str] = None):
        """
        :param str policy_name: The name of the policy.
        :param str action_type: The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        :param str adjustment: The number of instances to add/remove to/from the target capacity when scale is needed.
        :param int cooldown: The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        :param Mapping[str, str] dimensions: A mapping of dimensions describing qualities of the metric.
        :param str max_target_capacity: Max target capacity for scale down.
        :param str maximum: The maximum to set when scale is needed.
        :param str min_target_capacity: Min target capacity for scale up.
        :param str minimum: The minimum to set when scale is needed.
        :param str target: The number of instances to set when scale is needed.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add/remove to/from the target capacity when scale is needed.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        """
        Max target capacity for scale down.
        """
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        """
        The maximum to set when scale is needed.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        """
        Min target capacity for scale up.
        """
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        """
        The minimum to set when scale is needed.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The number of instances to set when scale is needed.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MrScalarInstanceWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarInstanceWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarInstanceWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarInstanceWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 weighted_capacity: int):
        """
        :param str instance_type: The type of the instance.
        :param int weighted_capacity: The weight given to the associated instance type.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of the instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> int:
        """
        The weight given to the associated instance type.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class MrScalarMasterEbsBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeType":
            suggest = "volume_type"
        elif key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarMasterEbsBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarMasterEbsBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarMasterEbsBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gb: int,
                 volume_type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_type", volume_type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> int:
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class MrScalarProvisioningTimeout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutAction":
            suggest = "timeout_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarProvisioningTimeout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarProvisioningTimeout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarProvisioningTimeout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeout: int,
                 timeout_action: str):
        """
        :param int timeout: The amount of time (minutes) after which the cluster is automatically terminated if it's still in provisioning status. Minimum: '15'.
        :param str timeout_action: The action to take if the timeout is exceeded. Valid values: `terminate`, `terminateAndRetry`.
        """
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "timeout_action", timeout_action)

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        The amount of time (minutes) after which the cluster is automatically terminated if it's still in provisioning status. Minimum: '15'.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> str:
        """
        The action to take if the timeout is exceeded. Valid values: `terminate`, `terminateAndRetry`.
        """
        return pulumi.get(self, "timeout_action")


@pulumi.output_type
class MrScalarScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceGroupType":
            suggest = "instance_group_type"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "desiredCapacity":
            suggest = "desired_capacity"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron: str,
                 instance_group_type: str,
                 task_type: str,
                 desired_capacity: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 max_capacity: Optional[str] = None,
                 min_capacity: Optional[str] = None):
        """
        :param str cron: A cron expression representing the schedule for the task.
        :param str instance_group_type: Select the EMR instance groups to execute the scheduled task on. Valid values: `task`.
        :param str task_type: The type of task to be scheduled. Valid values: `setCapacity`.
        :param str desired_capacity: New desired capacity for the elastigroup.
        :param bool is_enabled: Enable/Disable the specified scheduling task.
        :param str max_capacity: New max capacity for the elastigroup.
        :param str min_capacity: New min capacity for the elastigroup.
        """
        pulumi.set(__self__, "cron", cron)
        pulumi.set(__self__, "instance_group_type", instance_group_type)
        pulumi.set(__self__, "task_type", task_type)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter
    def cron(self) -> str:
        """
        A cron expression representing the schedule for the task.
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter(name="instanceGroupType")
    def instance_group_type(self) -> str:
        """
        Select the EMR instance groups to execute the scheduled task on. Valid values: `task`.
        """
        return pulumi.get(self, "instance_group_type")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        The type of task to be scheduled. Valid values: `setCapacity`.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[str]:
        """
        New desired capacity for the elastigroup.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Enable/Disable the specified scheduling task.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[str]:
        """
        New max capacity for the elastigroup.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[str]:
        """
        New min capacity for the elastigroup.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class MrScalarStepsFile(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")


@pulumi.output_type
class MrScalarTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str value: Tag value.
               
               <a id="Optional Compute Parameters"></a>
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Tag value.

        <a id="Optional Compute Parameters"></a>
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MrScalarTaskEbsBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGb":
            suggest = "size_in_gb"
        elif key == "volumeType":
            suggest = "volume_type"
        elif key == "volumesPerInstance":
            suggest = "volumes_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarTaskEbsBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarTaskEbsBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarTaskEbsBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gb: int,
                 volume_type: str,
                 iops: Optional[int] = None,
                 volumes_per_instance: Optional[int] = None):
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        pulumi.set(__self__, "volume_type", volume_type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volumes_per_instance is not None:
            pulumi.set(__self__, "volumes_per_instance", volumes_per_instance)

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> int:
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumesPerInstance")
    def volumes_per_instance(self) -> Optional[int]:
        return pulumi.get(self, "volumes_per_instance")


@pulumi.output_type
class MrScalarTaskScalingDownPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarTaskScalingDownPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarTaskScalingDownPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarTaskScalingDownPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 threshold: float,
                 unit: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Mapping[str, str]] = None,
                 evaluation_periods: Optional[int] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 statistic: Optional[str] = None,
                 target: Optional[str] = None):
        """
        :param str policy_name: The name of the policy.
        :param str action_type: The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        :param str adjustment: The number of instances to add/remove to/from the target capacity when scale is needed.
        :param int cooldown: The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        :param Mapping[str, str] dimensions: A mapping of dimensions describing qualities of the metric.
        :param str max_target_capacity: Max target capacity for scale down.
        :param str maximum: The maximum to set when scale is needed.
        :param str min_target_capacity: Min target capacity for scale up.
        :param str minimum: The minimum to set when scale is needed.
        :param str target: The number of instances to set when scale is needed.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add/remove to/from the target capacity when scale is needed.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        """
        Max target capacity for scale down.
        """
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        """
        The maximum to set when scale is needed.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        """
        Min target capacity for scale up.
        """
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        """
        The minimum to set when scale is needed.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The number of instances to set when scale is needed.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MrScalarTaskScalingUpPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "maxTargetCapacity":
            suggest = "max_target_capacity"
        elif key == "minTargetCapacity":
            suggest = "min_target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarTaskScalingUpPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarTaskScalingUpPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarTaskScalingUpPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 threshold: float,
                 unit: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Mapping[str, str]] = None,
                 evaluation_periods: Optional[int] = None,
                 max_target_capacity: Optional[str] = None,
                 maximum: Optional[str] = None,
                 min_target_capacity: Optional[str] = None,
                 minimum: Optional[str] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 statistic: Optional[str] = None,
                 target: Optional[str] = None):
        """
        :param str policy_name: The name of the policy.
        :param str action_type: The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        :param str adjustment: The number of instances to add/remove to/from the target capacity when scale is needed.
        :param int cooldown: The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        :param Mapping[str, str] dimensions: A mapping of dimensions describing qualities of the metric.
        :param str max_target_capacity: Max target capacity for scale down.
        :param str maximum: The maximum to set when scale is needed.
        :param str min_target_capacity: Min target capacity for scale up.
        :param str minimum: The minimum to set when scale is needed.
        :param str target: The number of instances to set when scale is needed.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if max_target_capacity is not None:
            pulumi.set(__self__, "max_target_capacity", max_target_capacity)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_target_capacity is not None:
            pulumi.set(__self__, "min_target_capacity", min_target_capacity)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[str]:
        """
        The number of instances to add/remove to/from the target capacity when scale is needed.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, str]]:
        """
        A mapping of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="maxTargetCapacity")
    def max_target_capacity(self) -> Optional[str]:
        """
        Max target capacity for scale down.
        """
        return pulumi.get(self, "max_target_capacity")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[str]:
        """
        The maximum to set when scale is needed.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minTargetCapacity")
    def min_target_capacity(self) -> Optional[str]:
        """
        Min target capacity for scale up.
        """
        return pulumi.get(self, "min_target_capacity")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[str]:
        """
        The minimum to set when scale is needed.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The number of instances to set when scale is needed.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MrScalarTerminationPolicy(dict):
    def __init__(__self__, *,
                 statements: Sequence['outputs.MrScalarTerminationPolicyStatement']):
        pulumi.set(__self__, "statements", statements)

    @property
    @pulumi.getter
    def statements(self) -> Sequence['outputs.MrScalarTerminationPolicyStatement']:
        return pulumi.get(self, "statements")


@pulumi.output_type
class MrScalarTerminationPolicyStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MrScalarTerminationPolicyStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MrScalarTerminationPolicyStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MrScalarTerminationPolicyStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 threshold: float,
                 evaluation_periods: Optional[int] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 statistic: Optional[str] = None,
                 unit: Optional[str] = None):
        """
        :param str metric_name: The name of the metric in CloudWatch which the statement will be based on.
        :param str namespace: Must contain the value: `AWS/ElasticMapReduce`.
        :param float threshold: The value that the specified statistic is compared to.
        :param int evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param str operator: The operator to use in order to determine if the policy is applicable. Valid values: `gt` | `gte` | `lt` | `lte`
        :param int period: The time window in seconds over which the statistic is applied.
        :param str statistic: The aggregation method of the given metric. Valid Values: `average` | `sum` | `sampleCount` | `maximum` | `minimum`
        :param str unit: The unit for a given metric. Valid Values: `seconds` | `microseconds` | `milliseconds` | `bytes` | `kilobytes` | `megabytes` | `gigabytes` | `terabytes` | `bits` | `kilobits` | `megabits` | `gigabits` | `terabits` | `percent` | `count` | `bytes/second` | `kilobytes/second` | `megabytes/second` | `gigabytes/second` | `terabytes/second` | `bits/second` | `kilobits/second` | `megabits/second` | `gigabits/second` | `terabits/second` | `count/second` | `none`
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "threshold", threshold)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric in CloudWatch which the statement will be based on.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Must contain the value: `AWS/ElasticMapReduce`.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The value that the specified statistic is compared to.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        The number of periods over which data is compared to the specified threshold.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator to use in order to determine if the policy is applicable. Valid values: `gt` | `gte` | `lt` | `lte`
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        The time window in seconds over which the statistic is applied.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        The aggregation method of the given metric. Valid Values: `average` | `sum` | `sampleCount` | `maximum` | `minimum`
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit for a given metric. Valid Values: `seconds` | `microseconds` | `milliseconds` | `bytes` | `kilobytes` | `megabytes` | `gigabytes` | `terabytes` | `bits` | `kilobits` | `megabits` | `gigabits` | `terabits` | `percent` | `count` | `bytes/second` | `kilobytes/second` | `megabytes/second` | `gigabytes/second` | `terabytes/second` | `bits/second` | `kilobits/second` | `megabits/second` | `gigabits/second` | `terabits/second` | `count/second` | `none`
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class OceanAttachLoadBalancer(dict):
    def __init__(__self__, *,
                 type: str,
                 arn: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str type: Type of load balancer to use.
        :param str arn: If type is "TARGET_GROUP" then an ARN is required. Otherwise is not allowed.
        :param str name: If type is "CLASSIC" then a name is required. Otherwise is not allowed.
        """
        pulumi.set(__self__, "type", type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of load balancer to use.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        If type is "TARGET_GROUP" then an ARN is required. Otherwise is not allowed.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        If type is "CLASSIC" then a name is required. Otherwise is not allowed.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OceanAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoHeadroomPercentage":
            suggest = "auto_headroom_percentage"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsAutoConfig":
            suggest = "autoscale_is_auto_config"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"
        elif key == "enableAutomaticAndManualHeadroom":
            suggest = "enable_automatic_and_manual_headroom"
        elif key == "extendedResourceDefinitions":
            suggest = "extended_resource_definitions"
        elif key == "resourceLimits":
            suggest = "resource_limits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_headroom_percentage: Optional[int] = None,
                 autoscale_cooldown: Optional[int] = None,
                 autoscale_down: Optional['outputs.OceanAutoscalerAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.OceanAutoscalerAutoscaleHeadroom'] = None,
                 autoscale_is_auto_config: Optional[bool] = None,
                 autoscale_is_enabled: Optional[bool] = None,
                 enable_automatic_and_manual_headroom: Optional[bool] = None,
                 extended_resource_definitions: Optional[Sequence[str]] = None,
                 resource_limits: Optional['outputs.OceanAutoscalerResourceLimits'] = None):
        """
        :param int auto_headroom_percentage: Set the auto headroom percentage (a number in the range [0, 200]) which controls the percentage of headroom from the cluster. Relevant only when `autoscale_is_auto_config` toggled on.
        :param int autoscale_cooldown: Cooldown period between scaling actions.
        :param 'OceanAutoscalerAutoscaleDownArgs' autoscale_down: Auto Scaling scale down operations.
        :param 'OceanAutoscalerAutoscaleHeadroomArgs' autoscale_headroom: Spare resource capacity management enabling fast assignment of Pods without waiting for new resources to launch.
        :param bool autoscale_is_auto_config: Automatically configure and optimize headroom resources.
        :param bool autoscale_is_enabled: Enable the Ocean Kubernetes Auto Scaler.
        :param bool enable_automatic_and_manual_headroom: enables automatic and manual headroom to work in parallel. When set to false, automatic headroom overrides all other headroom definitions manually configured, whether they are at cluster or VNG level.
        :param Sequence[str] extended_resource_definitions: List of Ocean extended resource definitions to use in this cluster.
        :param 'OceanAutoscalerResourceLimitsArgs' resource_limits: Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        if auto_headroom_percentage is not None:
            pulumi.set(__self__, "auto_headroom_percentage", auto_headroom_percentage)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_auto_config is not None:
            pulumi.set(__self__, "autoscale_is_auto_config", autoscale_is_auto_config)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if enable_automatic_and_manual_headroom is not None:
            pulumi.set(__self__, "enable_automatic_and_manual_headroom", enable_automatic_and_manual_headroom)
        if extended_resource_definitions is not None:
            pulumi.set(__self__, "extended_resource_definitions", extended_resource_definitions)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter(name="autoHeadroomPercentage")
    def auto_headroom_percentage(self) -> Optional[int]:
        """
        Set the auto headroom percentage (a number in the range [0, 200]) which controls the percentage of headroom from the cluster. Relevant only when `autoscale_is_auto_config` toggled on.
        """
        return pulumi.get(self, "auto_headroom_percentage")

    @property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[int]:
        """
        Cooldown period between scaling actions.
        """
        return pulumi.get(self, "autoscale_cooldown")

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.OceanAutoscalerAutoscaleDown']:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.OceanAutoscalerAutoscaleHeadroom']:
        """
        Spare resource capacity management enabling fast assignment of Pods without waiting for new resources to launch.
        """
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(self) -> Optional[bool]:
        """
        Automatically configure and optimize headroom resources.
        """
        return pulumi.get(self, "autoscale_is_auto_config")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[bool]:
        """
        Enable the Ocean Kubernetes Auto Scaler.
        """
        return pulumi.get(self, "autoscale_is_enabled")

    @property
    @pulumi.getter(name="enableAutomaticAndManualHeadroom")
    def enable_automatic_and_manual_headroom(self) -> Optional[bool]:
        """
        enables automatic and manual headroom to work in parallel. When set to false, automatic headroom overrides all other headroom definitions manually configured, whether they are at cluster or VNG level.
        """
        return pulumi.get(self, "enable_automatic_and_manual_headroom")

    @property
    @pulumi.getter(name="extendedResourceDefinitions")
    def extended_resource_definitions(self) -> Optional[Sequence[str]]:
        """
        List of Ocean extended resource definitions to use in this cluster.
        """
        return pulumi.get(self, "extended_resource_definitions")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional['outputs.OceanAutoscalerResourceLimits']:
        """
        Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        return pulumi.get(self, "resource_limits")


@pulumi.output_type
class OceanAutoscalerAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "isAggressiveScaleDownEnabled":
            suggest = "is_aggressive_scale_down_enabled"
        elif key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscalerAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscalerAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscalerAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[int] = None,
                 is_aggressive_scale_down_enabled: Optional[bool] = None,
                 max_scale_down_percentage: Optional[float] = None):
        """
        :param bool is_aggressive_scale_down_enabled: When set to 'true', the Aggressive Scale Down feature is enabled.
        :param float max_scale_down_percentage: Would represent the maximum % to scale-down. Number between 1-100.
        """
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if is_aggressive_scale_down_enabled is not None:
            pulumi.set(__self__, "is_aggressive_scale_down_enabled", is_aggressive_scale_down_enabled)
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="isAggressiveScaleDownEnabled")
    def is_aggressive_scale_down_enabled(self) -> Optional[bool]:
        """
        When set to 'true', the Aggressive Scale Down feature is enabled.
        """
        return pulumi.get(self, "is_aggressive_scale_down_enabled")

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[float]:
        """
        Would represent the maximum % to scale-down. Number between 1-100.
        """
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class OceanAutoscalerAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "gpuPerUnit":
            suggest = "gpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscalerAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscalerAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscalerAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[int] = None,
                 gpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None,
                 num_of_units: Optional[int] = None):
        """
        :param int cpu_per_unit: Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param int gpu_per_unit: Optionally configure the number of GPUs to allocate the headroom.
        :param int memory_per_unit: Optionally configure the amount of memory (MB) to allocate the headroom.
        :param int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if gpu_per_unit is not None:
            pulumi.set(__self__, "gpu_per_unit", gpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        """
        Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="gpuPerUnit")
    def gpu_per_unit(self) -> Optional[int]:
        """
        Optionally configure the number of GPUs to allocate the headroom.
        """
        return pulumi.get(self, "gpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        """
        Optionally configure the amount of memory (MB) to allocate the headroom.
        """
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[int]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class OceanAutoscalerResourceLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxVcpu":
            suggest = "max_vcpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanAutoscalerResourceLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanAutoscalerResourceLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanAutoscalerResourceLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_memory_gib: Optional[int] = None,
                 max_vcpu: Optional[int] = None):
        """
        :param int max_memory_gib: The maximum memory in GiB units that can be allocated to the cluster.
        :param int max_vcpu: The maximum cpu in vCPU units that can be allocated to the cluster.
        """
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[int]:
        """
        The maximum memory in GiB units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[int]:
        """
        The maximum cpu in vCPU units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_vcpu")


@pulumi.output_type
class OceanBlockDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[str] = None,
                 ebs: Optional['outputs.OceanBlockDeviceMappingEbs'] = None):
        """
        :param str device_name: String. Set device name. (Example: `/dev/xvda`).
        :param 'OceanBlockDeviceMappingEbsArgs' ebs: Object. Set Elastic Block Store properties .
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        String. Set device name. (Example: `/dev/xvda`).
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.OceanBlockDeviceMappingEbs']:
        """
        Object. Set Elastic Block Store properties .
        """
        return pulumi.get(self, "ebs")


@pulumi.output_type
class OceanBlockDeviceMappingEbs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "dynamicIops":
            suggest = "dynamic_iops"
        elif key == "dynamicVolumeSize":
            suggest = "dynamic_volume_size"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMappingEbs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMappingEbs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMappingEbs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 dynamic_iops: Optional['outputs.OceanBlockDeviceMappingEbsDynamicIops'] = None,
                 dynamic_volume_size: Optional['outputs.OceanBlockDeviceMappingEbsDynamicVolumeSize'] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 throughput: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        """
        :param bool delete_on_termination: Boolean. Flag to delete the EBS on instance termination.
        :param 'OceanBlockDeviceMappingEbsDynamicIopsArgs' dynamic_iops: Set dynamic IOPS properties. When using this object, you cannot use the `iops` attribute. You must use one or the other.
        :param 'OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs' dynamic_volume_size: Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        :param bool encrypted: Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param int iops: Must be greater than or equal to 0.
        :param str kms_key_id: String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        :param str snapshot_id: (Optional) String. The Snapshot ID to mount by.
        :param int throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = `gp3`.
        :param int volume_size: Int. The size, in GB of the volume.
        :param str volume_type: String. The type of the volume. (Example: `gp2`).
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_iops is not None:
            pulumi.set(__self__, "dynamic_iops", dynamic_iops)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Boolean. Flag to delete the EBS on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="dynamicIops")
    def dynamic_iops(self) -> Optional['outputs.OceanBlockDeviceMappingEbsDynamicIops']:
        """
        Set dynamic IOPS properties. When using this object, you cannot use the `iops` attribute. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_iops")

    @property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional['outputs.OceanBlockDeviceMappingEbsDynamicVolumeSize']:
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        Must be greater than or equal to 0.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        (Optional) String. The Snapshot ID to mount by.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = `gp3`.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        Int. The size, in GB of the volume.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        String. The type of the volume. (Example: `gp2`).
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class OceanBlockDeviceMappingEbsDynamicIops(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMappingEbsDynamicIops. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMappingEbsDynamicIops.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMappingEbsDynamicIops.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: int,
                 resource: str,
                 size_per_resource_unit: int):
        """
        :param int base_size: Initial size for IOPS.
        :param int size_per_resource_unit: Additional size per resource unit (in IOPS). (Example: `baseSize=50`, `sizePerResourceUnit=20`, and an instance with 2 CPU is launched; its IOPS size will be: 90).
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> int:
        """
        Initial size for IOPS.
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> str:
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> int:
        """
        Additional size per resource unit (in IOPS). (Example: `baseSize=50`, `sizePerResourceUnit=20`, and an instance with 2 CPU is launched; its IOPS size will be: 90).
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class OceanBlockDeviceMappingEbsDynamicVolumeSize(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanBlockDeviceMappingEbsDynamicVolumeSize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: int,
                 resource: str,
                 size_per_resource_unit: int):
        """
        :param int base_size: Int. Initial size for volume. (Example: 50)
        :param str resource: String. Resource type to increase volume size dynamically by. (Valid values: `CPU`)
        :param int size_per_resource_unit: Int. Additional size (in GB) per resource unit. (Example: `baseSize=50`, `sizePerResourceUnit=20`, and instance with 2 CPU is launched; its total disk size will be: 90GB).
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> int:
        """
        Int. Initial size for volume. (Example: 50)
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        String. Resource type to increase volume size dynamically by. (Valid values: `CPU`)
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> int:
        """
        Int. Additional size (in GB) per resource unit. (Example: `baseSize=50`, `sizePerResourceUnit=20`, and instance with 2 CPU is launched; its total disk size will be: 90GB).
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class OceanClusterOrientation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityVsCost":
            suggest = "availability_vs_cost"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanClusterOrientation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanClusterOrientation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanClusterOrientation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_vs_cost: Optional[str] = None):
        """
        :param str availability_vs_cost: You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
        if availability_vs_cost is not None:
            pulumi.set(__self__, "availability_vs_cost", availability_vs_cost)

    @property
    @pulumi.getter(name="availabilityVsCost")
    def availability_vs_cost(self) -> Optional[str]:
        """
        You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
        return pulumi.get(self, "availability_vs_cost")


@pulumi.output_type
class OceanDetachLoadBalancer(dict):
    def __init__(__self__, *,
                 type: str,
                 arn: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str type: Type of load balancer to use.
        :param str arn: If type is "TARGET_GROUP" then an ARN is required. Otherwise is not allowed.
        :param str name: If type is "CLASSIC" then a name is required. Otherwise is not allowed.
        """
        pulumi.set(__self__, "type", type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of load balancer to use.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        If type is "TARGET_GROUP" then an ARN is required. Otherwise is not allowed.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        If type is "CLASSIC" then a name is required. Otherwise is not allowed.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OceanFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskTypes":
            suggest = "disk_types"
        elif key == "excludeFamilies":
            suggest = "exclude_families"
        elif key == "excludeMetal":
            suggest = "exclude_metal"
        elif key == "includeFamilies":
            suggest = "include_families"
        elif key == "isEnaSupported":
            suggest = "is_ena_supported"
        elif key == "maxGpu":
            suggest = "max_gpu"
        elif key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxNetworkPerformance":
            suggest = "max_network_performance"
        elif key == "maxVcpu":
            suggest = "max_vcpu"
        elif key == "minEnis":
            suggest = "min_enis"
        elif key == "minGpu":
            suggest = "min_gpu"
        elif key == "minMemoryGib":
            suggest = "min_memory_gib"
        elif key == "minNetworkPerformance":
            suggest = "min_network_performance"
        elif key == "minVcpu":
            suggest = "min_vcpu"
        elif key == "rootDeviceTypes":
            suggest = "root_device_types"
        elif key == "virtualizationTypes":
            suggest = "virtualization_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architectures: Optional[Sequence[str]] = None,
                 categories: Optional[Sequence[str]] = None,
                 disk_types: Optional[Sequence[str]] = None,
                 exclude_families: Optional[Sequence[str]] = None,
                 exclude_metal: Optional[bool] = None,
                 hypervisors: Optional[Sequence[str]] = None,
                 include_families: Optional[Sequence[str]] = None,
                 is_ena_supported: Optional[str] = None,
                 max_gpu: Optional[int] = None,
                 max_memory_gib: Optional[float] = None,
                 max_network_performance: Optional[int] = None,
                 max_vcpu: Optional[int] = None,
                 min_enis: Optional[int] = None,
                 min_gpu: Optional[int] = None,
                 min_memory_gib: Optional[float] = None,
                 min_network_performance: Optional[int] = None,
                 min_vcpu: Optional[int] = None,
                 root_device_types: Optional[Sequence[str]] = None,
                 virtualization_types: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] architectures: The filtered instance types will support at least one of the architectures from this list.
        :param Sequence[str] categories: The filtered instance types will belong to one of the categories types from this list.
        :param Sequence[str] disk_types: The filtered instance types will have one of the disk type from this list.
        :param Sequence[str] exclude_families: Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        :param bool exclude_metal: In case excludeMetal is set to true, metal types will not be available for scaling.
        :param Sequence[str] hypervisors: The filtered instance types will have a hypervisor type from this list.
        :param Sequence[str] include_families: Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        :param str is_ena_supported: Ena is supported or not.
        :param int max_gpu: Maximum total number of GPUs.
        :param int max_network_performance: Maximum Bandwidth in Gib/s of network performance.
        :param int min_enis: Minimum number of network interfaces (ENIs).
        :param int min_gpu: Minimum total number of GPUs.
        :param float min_memory_gib: Minimum amount of Memory (GiB).
        :param int min_network_performance: Minimum Bandwidth in Gib/s of network performance.
        :param int min_vcpu: Minimum number of vcpus available.
        :param Sequence[str] root_device_types: The filtered instance types will have a root device types from this list.
        :param Sequence[str] virtualization_types: The filtered instance types will support at least one of the virtualization types from this list.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)
        if exclude_families is not None:
            pulumi.set(__self__, "exclude_families", exclude_families)
        if exclude_metal is not None:
            pulumi.set(__self__, "exclude_metal", exclude_metal)
        if hypervisors is not None:
            pulumi.set(__self__, "hypervisors", hypervisors)
        if include_families is not None:
            pulumi.set(__self__, "include_families", include_families)
        if is_ena_supported is not None:
            pulumi.set(__self__, "is_ena_supported", is_ena_supported)
        if max_gpu is not None:
            pulumi.set(__self__, "max_gpu", max_gpu)
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_network_performance is not None:
            pulumi.set(__self__, "max_network_performance", max_network_performance)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)
        if min_enis is not None:
            pulumi.set(__self__, "min_enis", min_enis)
        if min_gpu is not None:
            pulumi.set(__self__, "min_gpu", min_gpu)
        if min_memory_gib is not None:
            pulumi.set(__self__, "min_memory_gib", min_memory_gib)
        if min_network_performance is not None:
            pulumi.set(__self__, "min_network_performance", min_network_performance)
        if min_vcpu is not None:
            pulumi.set(__self__, "min_vcpu", min_vcpu)
        if root_device_types is not None:
            pulumi.set(__self__, "root_device_types", root_device_types)
        if virtualization_types is not None:
            pulumi.set(__self__, "virtualization_types", virtualization_types)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will support at least one of the architectures from this list.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will belong to one of the categories types from this list.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will have one of the disk type from this list.
        """
        return pulumi.get(self, "disk_types")

    @property
    @pulumi.getter(name="excludeFamilies")
    def exclude_families(self) -> Optional[Sequence[str]]:
        """
        Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "exclude_families")

    @property
    @pulumi.getter(name="excludeMetal")
    def exclude_metal(self) -> Optional[bool]:
        """
        In case excludeMetal is set to true, metal types will not be available for scaling.
        """
        return pulumi.get(self, "exclude_metal")

    @property
    @pulumi.getter
    def hypervisors(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will have a hypervisor type from this list.
        """
        return pulumi.get(self, "hypervisors")

    @property
    @pulumi.getter(name="includeFamilies")
    def include_families(self) -> Optional[Sequence[str]]:
        """
        Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "include_families")

    @property
    @pulumi.getter(name="isEnaSupported")
    def is_ena_supported(self) -> Optional[str]:
        """
        Ena is supported or not.
        """
        return pulumi.get(self, "is_ena_supported")

    @property
    @pulumi.getter(name="maxGpu")
    def max_gpu(self) -> Optional[int]:
        """
        Maximum total number of GPUs.
        """
        return pulumi.get(self, "max_gpu")

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[float]:
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxNetworkPerformance")
    def max_network_performance(self) -> Optional[int]:
        """
        Maximum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "max_network_performance")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[int]:
        return pulumi.get(self, "max_vcpu")

    @property
    @pulumi.getter(name="minEnis")
    def min_enis(self) -> Optional[int]:
        """
        Minimum number of network interfaces (ENIs).
        """
        return pulumi.get(self, "min_enis")

    @property
    @pulumi.getter(name="minGpu")
    def min_gpu(self) -> Optional[int]:
        """
        Minimum total number of GPUs.
        """
        return pulumi.get(self, "min_gpu")

    @property
    @pulumi.getter(name="minMemoryGib")
    def min_memory_gib(self) -> Optional[float]:
        """
        Minimum amount of Memory (GiB).
        """
        return pulumi.get(self, "min_memory_gib")

    @property
    @pulumi.getter(name="minNetworkPerformance")
    def min_network_performance(self) -> Optional[int]:
        """
        Minimum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "min_network_performance")

    @property
    @pulumi.getter(name="minVcpu")
    def min_vcpu(self) -> Optional[int]:
        """
        Minimum number of vcpus available.
        """
        return pulumi.get(self, "min_vcpu")

    @property
    @pulumi.getter(name="rootDeviceTypes")
    def root_device_types(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will have a root device types from this list.
        """
        return pulumi.get(self, "root_device_types")

    @property
    @pulumi.getter(name="virtualizationTypes")
    def virtualization_types(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will support at least one of the virtualization types from this list.
        """
        return pulumi.get(self, "virtualization_types")


@pulumi.output_type
class OceanInstanceMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpTokens":
            suggest = "http_tokens"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanInstanceMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanInstanceMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanInstanceMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_tokens: str,
                 http_put_response_hop_limit: Optional[int] = None):
        """
        :param str http_tokens: Determines if a signed token is required or not. Valid values: `optional` or `required`.
        :param int http_put_response_hop_limit: An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> str:
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[int]:
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        return pulumi.get(self, "http_put_response_hop_limit")


@pulumi.output_type
class OceanLaunchSpecAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxScaleDownPercentage":
            suggest = "max_scale_down_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_scale_down_percentage: Optional[float] = None):
        """
        :param float max_scale_down_percentage: The maximum percentage allowed to scale down in a single scaling action on the nodes running in a specific VNG. Allowed only if maxScaleDownPercentage is set to null at the cluster level. Number between [0.1-100].
        """
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[float]:
        """
        The maximum percentage allowed to scale down in a single scaling action on the nodes running in a specific VNG. Allowed only if maxScaleDownPercentage is set to null at the cluster level. Number between [0.1-100].
        """
        return pulumi.get(self, "max_scale_down_percentage")


@pulumi.output_type
class OceanLaunchSpecAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numOfUnits":
            suggest = "num_of_units"
        elif key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "gpuPerUnit":
            suggest = "gpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_of_units: int,
                 cpu_per_unit: Optional[int] = None,
                 gpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None):
        """
        :param int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        :param int cpu_per_unit: Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param int gpu_per_unit: Optionally configure the number of GPUS to allocate for each headroom unit.
        :param int memory_per_unit: Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        pulumi.set(__self__, "num_of_units", num_of_units)
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if gpu_per_unit is not None:
            pulumi.set(__self__, "gpu_per_unit", gpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> int:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        """
        return pulumi.get(self, "num_of_units")

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="gpuPerUnit")
    def gpu_per_unit(self) -> Optional[int]:
        """
        Optionally configure the number of GPUS to allocate for each headroom unit.
        """
        return pulumi.get(self, "gpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        return pulumi.get(self, "memory_per_unit")


@pulumi.output_type
class OceanLaunchSpecAutoscaleHeadroomsAutomatic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoHeadroomPercentage":
            suggest = "auto_headroom_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecAutoscaleHeadroomsAutomatic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecAutoscaleHeadroomsAutomatic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecAutoscaleHeadroomsAutomatic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_headroom_percentage: Optional[int] = None):
        """
        :param int auto_headroom_percentage: Number between 0-200 to control the headroom % of the specific Virtual Node Group. Effective when cluster.autoScaler.headroom.automatic.`is_enabled` = true is set on the Ocean cluster.
        """
        if auto_headroom_percentage is not None:
            pulumi.set(__self__, "auto_headroom_percentage", auto_headroom_percentage)

    @property
    @pulumi.getter(name="autoHeadroomPercentage")
    def auto_headroom_percentage(self) -> Optional[int]:
        """
        Number between 0-200 to control the headroom % of the specific Virtual Node Group. Effective when cluster.autoScaler.headroom.automatic.`is_enabled` = true is set on the Ocean cluster.
        """
        return pulumi.get(self, "auto_headroom_percentage")


@pulumi.output_type
class OceanLaunchSpecBlockDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[str] = None,
                 ebs: Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbs'] = None,
                 no_device: Optional[str] = None,
                 virtual_name: Optional[str] = None):
        """
        :param str device_name: String. Set device name. (Example: `/dev/xvda`).
        :param 'OceanLaunchSpecBlockDeviceMappingEbsArgs' ebs: Object. Set Elastic Block Store properties .
        :param str no_device: String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        String. Set device name. (Example: `/dev/xvda`).
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbs']:
        """
        Object. Set Elastic Block Store properties .
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[str]:
        """
        String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[str]:
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class OceanLaunchSpecBlockDeviceMappingEbs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "dynamicVolumeSize":
            suggest = "dynamic_volume_size"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecBlockDeviceMappingEbs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 dynamic_volume_size: Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize'] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 kms_key_id: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 throughput: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        """
        :param bool delete_on_termination: Boolean. Flag to delete the EBS on instance termination.
        :param 'OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs' dynamic_volume_size: Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        :param bool encrypted: Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param int iops: Int. The number of I/O operations per second (IOPS) that the volume supports.
        :param str kms_key_id: String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        :param str snapshot_id: (Optional) String. The Snapshot ID to mount by.
        :param int throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = `gp3`.
        :param int volume_size: Int. The size, in GB of the volume.
        :param str volume_type: String. The type of the volume. (Example: `gp2`).
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Boolean. Flag to delete the EBS on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional['outputs.OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize']:
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        (Optional) String. The Snapshot ID to mount by.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = `gp3`.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        Int. The size, in GB of the volume.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        String. The type of the volume. (Example: `gp2`).
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseSize":
            suggest = "base_size"
        elif key == "sizePerResourceUnit":
            suggest = "size_per_resource_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSize.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_size: int,
                 resource: str,
                 size_per_resource_unit: int):
        """
        :param int base_size: Int. Initial size for volume. (Example: 50)
        :param str resource: String. Resource type to increase volume size dynamically by. (Valid values: `CPU`)
        :param int size_per_resource_unit: Int. Additional size (in GB) per resource unit. (Example: `baseSize=50`, `sizePerResourceUnit=20`, and instance with 2 CPU is launched; its total disk size will be: 90GB)
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> int:
        """
        Int. Initial size for volume. (Example: 50)
        """
        return pulumi.get(self, "base_size")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        String. Resource type to increase volume size dynamically by. (Valid values: `CPU`)
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> int:
        """
        Int. Additional size (in GB) per resource unit. (Example: `baseSize=50`, `sizePerResourceUnit=20`, and instance with 2 CPU is launched; its total disk size will be: 90GB)
        """
        return pulumi.get(self, "size_per_resource_unit")


@pulumi.output_type
class OceanLaunchSpecCreateOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialNodes":
            suggest = "initial_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecCreateOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecCreateOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecCreateOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_nodes: Optional[int] = None):
        """
        :param int initial_nodes: When set to an integer greater than 0, a corresponding amount of nodes will be launched from the created Virtual Node Group. The parameter is recommended in case the use_as_template_only (in aws.Ocean resource) is set to true during Ocean resource creation.
        """
        if initial_nodes is not None:
            pulumi.set(__self__, "initial_nodes", initial_nodes)

    @property
    @pulumi.getter(name="initialNodes")
    def initial_nodes(self) -> Optional[int]:
        """
        When set to an integer greater than 0, a corresponding amount of nodes will be launched from the created Virtual Node Group. The parameter is recommended in case the use_as_template_only (in aws.Ocean resource) is set to true during Ocean resource creation.
        """
        return pulumi.get(self, "initial_nodes")


@pulumi.output_type
class OceanLaunchSpecDeleteOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceDelete":
            suggest = "force_delete"
        elif key == "deleteNodes":
            suggest = "delete_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecDeleteOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecDeleteOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecDeleteOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 force_delete: bool,
                 delete_nodes: Optional[bool] = None):
        """
        :param bool force_delete: When set to `true`, delete even if it is the last Virtual Node Group (also, the default Virtual Node Group must be configured with `useAsTemlateOnly = true`). Should be set at creation or update, but will be used only at deletion.
        :param bool delete_nodes: When set to "true", all instances belonging to the deleted launch specification will be drained, detached, and terminated.
        """
        pulumi.set(__self__, "force_delete", force_delete)
        if delete_nodes is not None:
            pulumi.set(__self__, "delete_nodes", delete_nodes)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> bool:
        """
        When set to `true`, delete even if it is the last Virtual Node Group (also, the default Virtual Node Group must be configured with `useAsTemlateOnly = true`). Should be set at creation or update, but will be used only at deletion.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="deleteNodes")
    def delete_nodes(self) -> Optional[bool]:
        """
        When set to "true", all instances belonging to the deleted launch specification will be drained, detached, and terminated.
        """
        return pulumi.get(self, "delete_nodes")


@pulumi.output_type
class OceanLaunchSpecElasticIpPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagSelector":
            suggest = "tag_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecElasticIpPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecElasticIpPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecElasticIpPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_selector: Optional['outputs.OceanLaunchSpecElasticIpPoolTagSelector'] = None):
        """
        :param 'OceanLaunchSpecElasticIpPoolTagSelectorArgs' tag_selector: A key-value pair, which defines an Elastic IP from the customer pool. Can be null.
        """
        if tag_selector is not None:
            pulumi.set(__self__, "tag_selector", tag_selector)

    @property
    @pulumi.getter(name="tagSelector")
    def tag_selector(self) -> Optional['outputs.OceanLaunchSpecElasticIpPoolTagSelector']:
        """
        A key-value pair, which defines an Elastic IP from the customer pool. Can be null.
        """
        return pulumi.get(self, "tag_selector")


@pulumi.output_type
class OceanLaunchSpecElasticIpPoolTagSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValue":
            suggest = "tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecElasticIpPoolTagSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecElasticIpPoolTagSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecElasticIpPoolTagSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_key: str,
                 tag_value: Optional[str] = None):
        """
        :param str tag_key: Elastic IP tag key. The Virtual Node Group will consider all Elastic IPs tagged with this tag as a part of the Elastic IP pool to use.
        :param str tag_value: Elastic IP tag value. Can be null.
        """
        pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> str:
        """
        Elastic IP tag key. The Virtual Node Group will consider all Elastic IPs tagged with this tag as a part of the Elastic IP pool to use.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[str]:
        """
        Elastic IP tag value. Can be null.
        """
        return pulumi.get(self, "tag_value")


@pulumi.output_type
class OceanLaunchSpecEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorageDeviceName":
            suggest = "ephemeral_storage_device_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ephemeral_storage_device_name: Optional[str] = None):
        """
        :param str ephemeral_storage_device_name: Specify an alternative device name from which ephemeral storage calculations should be derived. This parameter is used when the ephemeral storage should not utilize the root device. Provide the device name configured in the VNG's BDM or AMI's BDM that differs from the default root device.
        """
        if ephemeral_storage_device_name is not None:
            pulumi.set(__self__, "ephemeral_storage_device_name", ephemeral_storage_device_name)

    @property
    @pulumi.getter(name="ephemeralStorageDeviceName")
    def ephemeral_storage_device_name(self) -> Optional[str]:
        """
        Specify an alternative device name from which ephemeral storage calculations should be derived. This parameter is used when the ephemeral storage should not utilize the root device. Provide the device name configured in the VNG's BDM or AMI's BDM that differs from the default root device.
        """
        return pulumi.get(self, "ephemeral_storage_device_name")


@pulumi.output_type
class OceanLaunchSpecImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: Optional[str] = None):
        """
        :param str image_id: Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
        return pulumi.get(self, "image_id")


@pulumi.output_type
class OceanLaunchSpecInstanceMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpTokens":
            suggest = "http_tokens"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecInstanceMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecInstanceMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecInstanceMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_tokens: str,
                 http_put_response_hop_limit: Optional[int] = None):
        """
        :param str http_tokens: Determines if a signed token is required or not. Valid values: `optional` or `required`.
        :param int http_put_response_hop_limit: An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> str:
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[int]:
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        return pulumi.get(self, "http_put_response_hop_limit")


@pulumi.output_type
class OceanLaunchSpecInstanceTypesFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskTypes":
            suggest = "disk_types"
        elif key == "excludeFamilies":
            suggest = "exclude_families"
        elif key == "excludeMetal":
            suggest = "exclude_metal"
        elif key == "includeFamilies":
            suggest = "include_families"
        elif key == "isEnaSupported":
            suggest = "is_ena_supported"
        elif key == "maxGpu":
            suggest = "max_gpu"
        elif key == "maxMemoryGib":
            suggest = "max_memory_gib"
        elif key == "maxNetworkPerformance":
            suggest = "max_network_performance"
        elif key == "maxVcpu":
            suggest = "max_vcpu"
        elif key == "minEnis":
            suggest = "min_enis"
        elif key == "minGpu":
            suggest = "min_gpu"
        elif key == "minMemoryGib":
            suggest = "min_memory_gib"
        elif key == "minNetworkPerformance":
            suggest = "min_network_performance"
        elif key == "minVcpu":
            suggest = "min_vcpu"
        elif key == "rootDeviceTypes":
            suggest = "root_device_types"
        elif key == "virtualizationTypes":
            suggest = "virtualization_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecInstanceTypesFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecInstanceTypesFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecInstanceTypesFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Optional[Sequence[str]] = None,
                 disk_types: Optional[Sequence[str]] = None,
                 exclude_families: Optional[Sequence[str]] = None,
                 exclude_metal: Optional[bool] = None,
                 hypervisors: Optional[Sequence[str]] = None,
                 include_families: Optional[Sequence[str]] = None,
                 is_ena_supported: Optional[str] = None,
                 max_gpu: Optional[int] = None,
                 max_memory_gib: Optional[float] = None,
                 max_network_performance: Optional[int] = None,
                 max_vcpu: Optional[int] = None,
                 min_enis: Optional[int] = None,
                 min_gpu: Optional[int] = None,
                 min_memory_gib: Optional[float] = None,
                 min_network_performance: Optional[int] = None,
                 min_vcpu: Optional[int] = None,
                 root_device_types: Optional[Sequence[str]] = None,
                 virtualization_types: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] categories: The filtered instance types will belong to one of the categories types from this list. Valid values: `Accelerated_computing`, `Compute_optimized`, `General_purpose`, `Memory_optimized`, `Storage_optimized`.
        :param Sequence[str] disk_types: The filtered instance types will have one of the disk type from this list. Valid values: `NVMe`, `EBS`, `SSD`, `HDD`.
        :param Sequence[str] exclude_families: Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        :param bool exclude_metal: In case excludeMetal is set to true, metal types will not be available for scaling.
        :param Sequence[str] hypervisors: The filtered instance types will have a hypervisor type from this list. Valid values: `nitro`, `xen`.
        :param Sequence[str] include_families: Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        :param str is_ena_supported: Ena is supported or not.
        :param int max_gpu: Maximum total number of GPUs.
        :param float max_memory_gib: Maximum amount of Memory (GiB).
        :param int max_network_performance: Maximum Bandwidth in Gib/s of network performance.
        :param int max_vcpu: Maximum number of vcpus available.
        :param int min_enis: Minimum number of network interfaces (ENIs).
        :param int min_gpu: Minimum total number of GPUs.
        :param float min_memory_gib: Minimum amount of Memory (GiB).
        :param int min_network_performance: Minimum Bandwidth in Gib/s of network performance.
        :param int min_vcpu: Minimum number of vcpus available.
        :param Sequence[str] root_device_types: The filtered instance types will have a root device types from this list. Valid values: `ebs`, or `instance-store`.
        :param Sequence[str] virtualization_types: The filtered instance types will support at least one of the virtualization types from this list. Valid values: `hvm`, `paravirtual`.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)
        if exclude_families is not None:
            pulumi.set(__self__, "exclude_families", exclude_families)
        if exclude_metal is not None:
            pulumi.set(__self__, "exclude_metal", exclude_metal)
        if hypervisors is not None:
            pulumi.set(__self__, "hypervisors", hypervisors)
        if include_families is not None:
            pulumi.set(__self__, "include_families", include_families)
        if is_ena_supported is not None:
            pulumi.set(__self__, "is_ena_supported", is_ena_supported)
        if max_gpu is not None:
            pulumi.set(__self__, "max_gpu", max_gpu)
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_network_performance is not None:
            pulumi.set(__self__, "max_network_performance", max_network_performance)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)
        if min_enis is not None:
            pulumi.set(__self__, "min_enis", min_enis)
        if min_gpu is not None:
            pulumi.set(__self__, "min_gpu", min_gpu)
        if min_memory_gib is not None:
            pulumi.set(__self__, "min_memory_gib", min_memory_gib)
        if min_network_performance is not None:
            pulumi.set(__self__, "min_network_performance", min_network_performance)
        if min_vcpu is not None:
            pulumi.set(__self__, "min_vcpu", min_vcpu)
        if root_device_types is not None:
            pulumi.set(__self__, "root_device_types", root_device_types)
        if virtualization_types is not None:
            pulumi.set(__self__, "virtualization_types", virtualization_types)

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will belong to one of the categories types from this list. Valid values: `Accelerated_computing`, `Compute_optimized`, `General_purpose`, `Memory_optimized`, `Storage_optimized`.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will have one of the disk type from this list. Valid values: `NVMe`, `EBS`, `SSD`, `HDD`.
        """
        return pulumi.get(self, "disk_types")

    @property
    @pulumi.getter(name="excludeFamilies")
    def exclude_families(self) -> Optional[Sequence[str]]:
        """
        Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "exclude_families")

    @property
    @pulumi.getter(name="excludeMetal")
    def exclude_metal(self) -> Optional[bool]:
        """
        In case excludeMetal is set to true, metal types will not be available for scaling.
        """
        return pulumi.get(self, "exclude_metal")

    @property
    @pulumi.getter
    def hypervisors(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will have a hypervisor type from this list. Valid values: `nitro`, `xen`.
        """
        return pulumi.get(self, "hypervisors")

    @property
    @pulumi.getter(name="includeFamilies")
    def include_families(self) -> Optional[Sequence[str]]:
        """
        Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "include_families")

    @property
    @pulumi.getter(name="isEnaSupported")
    def is_ena_supported(self) -> Optional[str]:
        """
        Ena is supported or not.
        """
        return pulumi.get(self, "is_ena_supported")

    @property
    @pulumi.getter(name="maxGpu")
    def max_gpu(self) -> Optional[int]:
        """
        Maximum total number of GPUs.
        """
        return pulumi.get(self, "max_gpu")

    @property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[float]:
        """
        Maximum amount of Memory (GiB).
        """
        return pulumi.get(self, "max_memory_gib")

    @property
    @pulumi.getter(name="maxNetworkPerformance")
    def max_network_performance(self) -> Optional[int]:
        """
        Maximum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "max_network_performance")

    @property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[int]:
        """
        Maximum number of vcpus available.
        """
        return pulumi.get(self, "max_vcpu")

    @property
    @pulumi.getter(name="minEnis")
    def min_enis(self) -> Optional[int]:
        """
        Minimum number of network interfaces (ENIs).
        """
        return pulumi.get(self, "min_enis")

    @property
    @pulumi.getter(name="minGpu")
    def min_gpu(self) -> Optional[int]:
        """
        Minimum total number of GPUs.
        """
        return pulumi.get(self, "min_gpu")

    @property
    @pulumi.getter(name="minMemoryGib")
    def min_memory_gib(self) -> Optional[float]:
        """
        Minimum amount of Memory (GiB).
        """
        return pulumi.get(self, "min_memory_gib")

    @property
    @pulumi.getter(name="minNetworkPerformance")
    def min_network_performance(self) -> Optional[int]:
        """
        Minimum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "min_network_performance")

    @property
    @pulumi.getter(name="minVcpu")
    def min_vcpu(self) -> Optional[int]:
        """
        Minimum number of vcpus available.
        """
        return pulumi.get(self, "min_vcpu")

    @property
    @pulumi.getter(name="rootDeviceTypes")
    def root_device_types(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will have a root device types from this list. Valid values: `ebs`, or `instance-store`.
        """
        return pulumi.get(self, "root_device_types")

    @property
    @pulumi.getter(name="virtualizationTypes")
    def virtualization_types(self) -> Optional[Sequence[str]]:
        """
        The filtered instance types will support at least one of the virtualization types from this list. Valid values: `hvm`, `paravirtual`.
        """
        return pulumi.get(self, "virtualization_types")


@pulumi.output_type
class OceanLaunchSpecLabel(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The label key.
        :param str value: The label value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The label value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanLaunchSpecResourceLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecResourceLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecResourceLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecResourceLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: Optional[int] = None,
                 min_instance_count: Optional[int] = None):
        """
        :param int max_instance_count: Set a maximum number of instances per Virtual Node Group. Can be null. If set, value must be greater than or equal to 0.
        :param int min_instance_count: Set a minimum number of instances per Virtual Node Group. Can be null. If set, value must be greater than or equal to 0.
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[int]:
        """
        Set a maximum number of instances per Virtual Node Group. Can be null. If set, value must be greater than or equal to 0.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        Set a minimum number of instances per Virtual Node Group. Can be null. If set, value must be greater than or equal to 0.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class OceanLaunchSpecSchedulingShutdownHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeWindows":
            suggest = "time_windows"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecSchedulingShutdownHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecSchedulingShutdownHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecSchedulingShutdownHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_windows: Sequence[str],
                 is_enabled: Optional[bool] = None):
        """
        :param Sequence[str] time_windows: The times that the shutdown hours will apply.
        :param bool is_enabled: Flag to enable or disable the shutdown hours mechanism. When `false`, the mechanism is deactivated, and the virtual node group remains in its current state.
        """
        pulumi.set(__self__, "time_windows", time_windows)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Sequence[str]:
        """
        The times that the shutdown hours will apply.
        """
        return pulumi.get(self, "time_windows")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Flag to enable or disable the shutdown hours mechanism. When `false`, the mechanism is deactivated, and the virtual node group remains in its current state.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class OceanLaunchSpecSchedulingTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "taskHeadrooms":
            suggest = "task_headrooms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecSchedulingTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecSchedulingTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecSchedulingTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: str,
                 is_enabled: bool,
                 task_type: str,
                 task_headrooms: Optional[Sequence['outputs.OceanLaunchSpecSchedulingTaskTaskHeadroom']] = None):
        """
        :param str cron_expression: A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        :param bool is_enabled: Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        :param str task_type: The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        :param Sequence['OceanLaunchSpecSchedulingTaskTaskHeadroomArgs'] task_headrooms: The config of this scheduled task. Depends on the value of taskType.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)
        if task_headrooms is not None:
            pulumi.set(__self__, "task_headrooms", task_headrooms)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="taskHeadrooms")
    def task_headrooms(self) -> Optional[Sequence['outputs.OceanLaunchSpecSchedulingTaskTaskHeadroom']]:
        """
        The config of this scheduled task. Depends on the value of taskType.
        """
        return pulumi.get(self, "task_headrooms")


@pulumi.output_type
class OceanLaunchSpecSchedulingTaskTaskHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numOfUnits":
            suggest = "num_of_units"
        elif key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "gpuPerUnit":
            suggest = "gpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecSchedulingTaskTaskHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecSchedulingTaskTaskHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecSchedulingTaskTaskHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_of_units: int,
                 cpu_per_unit: Optional[int] = None,
                 gpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None):
        """
        :param int num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        :param int cpu_per_unit: Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param int gpu_per_unit: Optionally configure the number of GPUS to allocate for each headroom unit.
        :param int memory_per_unit: Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        pulumi.set(__self__, "num_of_units", num_of_units)
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if gpu_per_unit is not None:
            pulumi.set(__self__, "gpu_per_unit", gpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> int:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        """
        return pulumi.get(self, "num_of_units")

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="gpuPerUnit")
    def gpu_per_unit(self) -> Optional[int]:
        """
        Optionally configure the number of GPUS to allocate for each headroom unit.
        """
        return pulumi.get(self, "gpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        return pulumi.get(self, "memory_per_unit")


@pulumi.output_type
class OceanLaunchSpecStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainingTimeout":
            suggest = "draining_timeout"
        elif key == "spotPercentage":
            suggest = "spot_percentage"
        elif key == "utilizeCommitments":
            suggest = "utilize_commitments"
        elif key == "utilizeReservedInstances":
            suggest = "utilize_reserved_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 draining_timeout: Optional[int] = None,
                 spot_percentage: Optional[int] = None,
                 utilize_commitments: Optional[bool] = None,
                 utilize_reserved_instances: Optional[bool] = None):
        """
        :param int draining_timeout: The configurable amount of time that Ocean will wait for the draining process to complete before terminating an instance. If you have not defined a draining timeout, the default of 300 seconds will be used.
        :param int spot_percentage: The desired percentage of the Spot instances out of all running instances for this VNG. Only available when the field is not set in the cluster directly (cluster.strategy.spotPercentage).
        :param bool utilize_commitments: When set as ‘true’, if savings plans commitments have available capacity, Ocean will utilize them alongside RIs (if exist) to maximize cost efficiency. If the value is set as 'null', it will automatically be inherited from the cluster level.
        :param bool utilize_reserved_instances: When set as ‘true’, if reserved instances exist, Ocean will utilize them before launching spot instances. If the value is set as 'null', it will automatically be inherited from the cluster level.
        """
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)

    @property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[int]:
        """
        The configurable amount of time that Ocean will wait for the draining process to complete before terminating an instance. If you have not defined a draining timeout, the default of 300 seconds will be used.
        """
        return pulumi.get(self, "draining_timeout")

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[int]:
        """
        The desired percentage of the Spot instances out of all running instances for this VNG. Only available when the field is not set in the cluster directly (cluster.strategy.spotPercentage).
        """
        return pulumi.get(self, "spot_percentage")

    @property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[bool]:
        """
        When set as ‘true’, if savings plans commitments have available capacity, Ocean will utilize them alongside RIs (if exist) to maximize cost efficiency. If the value is set as 'null', it will automatically be inherited from the cluster level.
        """
        return pulumi.get(self, "utilize_commitments")

    @property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[bool]:
        """
        When set as ‘true’, if reserved instances exist, Ocean will utilize them before launching spot instances. If the value is set as 'null', it will automatically be inherited from the cluster level.
        """
        return pulumi.get(self, "utilize_reserved_instances")


@pulumi.output_type
class OceanLaunchSpecTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanLaunchSpecTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: The effect of the taint. Valid values: `"NoSchedule"`, `"PreferNoSchedule"`, `"NoExecute"`.
        :param str key: The taint key.
        :param str value: The taint value.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        The effect of the taint. Valid values: `"NoSchedule"`, `"PreferNoSchedule"`, `"NoExecute"`.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The taint key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The taint value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanLaunchSpecUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldRoll":
            suggest = "should_roll"
        elif key == "rollConfig":
            suggest = "roll_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_roll: bool,
                 roll_config: Optional['outputs.OceanLaunchSpecUpdatePolicyRollConfig'] = None):
        """
        :param bool should_roll: Enables the roll.
        :param 'OceanLaunchSpecUpdatePolicyRollConfigArgs' roll_config: Holds the roll configuration.
        """
        pulumi.set(__self__, "should_roll", should_roll)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> bool:
        """
        Enables the roll.
        """
        return pulumi.get(self, "should_roll")

    @property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional['outputs.OceanLaunchSpecUpdatePolicyRollConfig']:
        """
        Holds the roll configuration.
        """
        return pulumi.get(self, "roll_config")


@pulumi.output_type
class OceanLaunchSpecUpdatePolicyRollConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "respectPdb":
            suggest = "respect_pdb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLaunchSpecUpdatePolicyRollConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLaunchSpecUpdatePolicyRollConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLaunchSpecUpdatePolicyRollConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size_percentage: int,
                 respect_pdb: Optional[bool] = None):
        """
        :param int batch_size_percentage: Sets the percentage of the instances to deploy in each batch.
        :param bool respect_pdb: During the roll, if the parameter is set to `true` we honor PDB during the instance replacement.
        """
        pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> int:
        """
        Sets the percentage of the instances to deploy in each batch.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[bool]:
        """
        During the roll, if the parameter is set to `true` we honor PDB during the instance replacement.
        """
        return pulumi.get(self, "respect_pdb")


@pulumi.output_type
class OceanLoadBalancer(dict):
    def __init__(__self__, *,
                 arn: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str arn: Required if type is set to `TARGET_GROUP`
        :param str name: Required if type is set to `CLASSIC`
        :param str type: Can be set to `CLASSIC` or `TARGET_GROUP`
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Required if type is set to `TARGET_GROUP`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Required if type is set to `CLASSIC`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Can be set to `CLASSIC` or `TARGET_GROUP`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OceanLogging(dict):
    def __init__(__self__, *,
                 export: Optional['outputs.OceanLoggingExport'] = None):
        """
        :param 'OceanLoggingExportArgs' export: Logging Export configuration.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)

    @property
    @pulumi.getter
    def export(self) -> Optional['outputs.OceanLoggingExport']:
        """
        Logging Export configuration.
        """
        return pulumi.get(self, "export")


@pulumi.output_type
class OceanLoggingExport(dict):
    def __init__(__self__, *,
                 s3s: Optional[Sequence['outputs.OceanLoggingExportS3']] = None):
        """
        :param Sequence['OceanLoggingExportS3Args'] s3s: Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        if s3s is not None:
            pulumi.set(__self__, "s3s", s3s)

    @property
    @pulumi.getter
    def s3s(self) -> Optional[Sequence['outputs.OceanLoggingExportS3']]:
        """
        Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        return pulumi.get(self, "s3s")


@pulumi.output_type
class OceanLoggingExportS3(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The identifier of The S3 data integration to export the logs to.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The identifier of The S3 data integration to export the logs to.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class OceanResourceTagSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldTagVolumes":
            suggest = "should_tag_volumes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanResourceTagSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanResourceTagSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanResourceTagSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_tag_volumes: Optional[bool] = None):
        """
        :param bool should_tag_volumes: Specify if Volume resources will be tagged with Virtual Node Group tags or Ocean tags.
        """
        if should_tag_volumes is not None:
            pulumi.set(__self__, "should_tag_volumes", should_tag_volumes)

    @property
    @pulumi.getter(name="shouldTagVolumes")
    def should_tag_volumes(self) -> Optional[bool]:
        """
        Specify if Volume resources will be tagged with Virtual Node Group tags or Ocean tags.
        """
        return pulumi.get(self, "should_tag_volumes")


@pulumi.output_type
class OceanScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shutdownHours":
            suggest = "shutdown_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shutdown_hours: Optional['outputs.OceanScheduledTaskShutdownHours'] = None,
                 tasks: Optional[Sequence['outputs.OceanScheduledTaskTask']] = None):
        """
        :param 'OceanScheduledTaskShutdownHoursArgs' shutdown_hours: Set shutdown hours for cluster object.
        :param Sequence['OceanScheduledTaskTaskArgs'] tasks: The scheduling tasks for the cluster.
        """
        if shutdown_hours is not None:
            pulumi.set(__self__, "shutdown_hours", shutdown_hours)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)

    @property
    @pulumi.getter(name="shutdownHours")
    def shutdown_hours(self) -> Optional['outputs.OceanScheduledTaskShutdownHours']:
        """
        Set shutdown hours for cluster object.
        """
        return pulumi.get(self, "shutdown_hours")

    @property
    @pulumi.getter
    def tasks(self) -> Optional[Sequence['outputs.OceanScheduledTaskTask']]:
        """
        The scheduling tasks for the cluster.
        """
        return pulumi.get(self, "tasks")


@pulumi.output_type
class OceanScheduledTaskShutdownHours(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeWindows":
            suggest = "time_windows"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskShutdownHours. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskShutdownHours.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskShutdownHours.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_windows: Sequence[str],
                 is_enabled: Optional[bool] = None):
        """
        :param Sequence[str] time_windows: Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of: `ddd:hh:mm-ddd:hh:mm` where `ddd` = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat, `hh` = hour 24 = 0 -23, `mm` = minute = 0 - 59. Time windows should not overlap. Required if `cluster.scheduling.isEnabled` is `true`. (Example: `Fri:15:30-Wed:14:30`).
        :param bool is_enabled: Toggle the shutdown hours task. (Example: `true`).
        """
        pulumi.set(__self__, "time_windows", time_windows)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Sequence[str]:
        """
        Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of: `ddd:hh:mm-ddd:hh:mm` where `ddd` = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat, `hh` = hour 24 = 0 -23, `mm` = minute = 0 - 59. Time windows should not overlap. Required if `cluster.scheduling.isEnabled` is `true`. (Example: `Fri:15:30-Wed:14:30`).
        """
        return pulumi.get(self, "time_windows")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Toggle the shutdown hours task. (Example: `true`).
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class OceanScheduledTaskTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "taskType":
            suggest = "task_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: str,
                 is_enabled: bool,
                 task_type: str,
                 parameters: Optional['outputs.OceanScheduledTaskTaskParameters'] = None):
        """
        :param str cron_expression: A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. (Example: `0 1 * * *`).
        :param bool is_enabled: Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        :param str task_type: Valid values: `clusterRoll` `amiAutoUpdate`. Required for `cluster.scheduling.tasks`
        :param 'OceanScheduledTaskTaskParametersArgs' parameters: This filed will be compatible to the `task_type` field. If `task_type` is defined as `clusterRoll`, user cluster roll object in parameters.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. (Example: `0 1 * * *`).
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        Valid values: `clusterRoll` `amiAutoUpdate`. Required for `cluster.scheduling.tasks`
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.OceanScheduledTaskTaskParameters']:
        """
        This filed will be compatible to the `task_type` field. If `task_type` is defined as `clusterRoll`, user cluster roll object in parameters.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class OceanScheduledTaskTaskParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiAutoUpdate":
            suggest = "ami_auto_update"
        elif key == "parametersClusterRoll":
            suggest = "parameters_cluster_roll"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskTaskParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskTaskParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskTaskParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_auto_update: Optional['outputs.OceanScheduledTaskTaskParametersAmiAutoUpdate'] = None,
                 parameters_cluster_roll: Optional['outputs.OceanScheduledTaskTaskParametersParametersClusterRoll'] = None):
        """
        :param 'OceanScheduledTaskTaskParametersAmiAutoUpdateArgs' ami_auto_update: Set amiAutoUpdate object
        :param 'OceanScheduledTaskTaskParametersParametersClusterRollArgs' parameters_cluster_roll: Set clusterRoll object
        """
        if ami_auto_update is not None:
            pulumi.set(__self__, "ami_auto_update", ami_auto_update)
        if parameters_cluster_roll is not None:
            pulumi.set(__self__, "parameters_cluster_roll", parameters_cluster_roll)

    @property
    @pulumi.getter(name="amiAutoUpdate")
    def ami_auto_update(self) -> Optional['outputs.OceanScheduledTaskTaskParametersAmiAutoUpdate']:
        """
        Set amiAutoUpdate object
        """
        return pulumi.get(self, "ami_auto_update")

    @property
    @pulumi.getter(name="parametersClusterRoll")
    def parameters_cluster_roll(self) -> Optional['outputs.OceanScheduledTaskTaskParametersParametersClusterRoll']:
        """
        Set clusterRoll object
        """
        return pulumi.get(self, "parameters_cluster_roll")


@pulumi.output_type
class OceanScheduledTaskTaskParametersAmiAutoUpdate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amiAutoUpdateClusterRoll":
            suggest = "ami_auto_update_cluster_roll"
        elif key == "applyRoll":
            suggest = "apply_roll"
        elif key == "minorVersion":
            suggest = "minor_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskTaskParametersAmiAutoUpdate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskTaskParametersAmiAutoUpdate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskTaskParametersAmiAutoUpdate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ami_auto_update_cluster_roll: Optional['outputs.OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll'] = None,
                 apply_roll: Optional[bool] = None,
                 minor_version: Optional[bool] = None,
                 patch: Optional[bool] = None):
        """
        :param 'OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRollArgs' ami_auto_update_cluster_roll: Set clusterRoll object
        :param bool apply_roll: When the AMI is updated according to the configuration set, a cluster roll can be triggered
        :param bool minor_version: When set to 'true', the auto-update process will update the VNGs’ AMI with the AMI to match the Kubernetes control plane version. either "patch" or "minor_version" must be true.
        :param bool patch: When set to 'true', the auto-update process will update the VNGs’ images with the latest security patches. either "patch" or "minorVersion" must be true.
        """
        if ami_auto_update_cluster_roll is not None:
            pulumi.set(__self__, "ami_auto_update_cluster_roll", ami_auto_update_cluster_roll)
        if apply_roll is not None:
            pulumi.set(__self__, "apply_roll", apply_roll)
        if minor_version is not None:
            pulumi.set(__self__, "minor_version", minor_version)
        if patch is not None:
            pulumi.set(__self__, "patch", patch)

    @property
    @pulumi.getter(name="amiAutoUpdateClusterRoll")
    def ami_auto_update_cluster_roll(self) -> Optional['outputs.OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll']:
        """
        Set clusterRoll object
        """
        return pulumi.get(self, "ami_auto_update_cluster_roll")

    @property
    @pulumi.getter(name="applyRoll")
    def apply_roll(self) -> Optional[bool]:
        """
        When the AMI is updated according to the configuration set, a cluster roll can be triggered
        """
        return pulumi.get(self, "apply_roll")

    @property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> Optional[bool]:
        """
        When set to 'true', the auto-update process will update the VNGs’ AMI with the AMI to match the Kubernetes control plane version. either "patch" or "minor_version" must be true.
        """
        return pulumi.get(self, "minor_version")

    @property
    @pulumi.getter
    def patch(self) -> Optional[bool]:
        """
        When set to 'true', the auto-update process will update the VNGs’ images with the latest security patches. either "patch" or "minorVersion" must be true.
        """
        return pulumi.get(self, "patch")


@pulumi.output_type
class OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "respectPdb":
            suggest = "respect_pdb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskTaskParametersAmiAutoUpdateAmiAutoUpdateClusterRoll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_min_healthy_percentage: Optional[int] = None,
                 batch_size_percentage: Optional[int] = None,
                 comment: Optional[str] = None,
                 respect_pdb: Optional[bool] = None):
        """
        :param int batch_min_healthy_percentage: Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param int batch_size_percentage: Value as a percent to set the size of a batch in a roll. Valid values are 0-100.
        :param str comment: Add a `comment` description for the roll. The `comment` is limited to 256 chars
        :param bool respect_pdb: During the roll, if the parameter is set to true we honor PDB during the instance replacement.
        """
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[int]:
        """
        Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[int]:
        """
        Value as a percent to set the size of a batch in a roll. Valid values are 0-100.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Add a `comment` description for the roll. The `comment` is limited to 256 chars
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[bool]:
        """
        During the roll, if the parameter is set to true we honor PDB during the instance replacement.
        """
        return pulumi.get(self, "respect_pdb")


@pulumi.output_type
class OceanScheduledTaskTaskParametersParametersClusterRoll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "respectPdb":
            suggest = "respect_pdb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanScheduledTaskTaskParametersParametersClusterRoll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanScheduledTaskTaskParametersParametersClusterRoll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanScheduledTaskTaskParametersParametersClusterRoll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_min_healthy_percentage: Optional[int] = None,
                 batch_size_percentage: Optional[int] = None,
                 comment: Optional[str] = None,
                 respect_pdb: Optional[bool] = None):
        """
        :param int batch_min_healthy_percentage: Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param int batch_size_percentage: Value as a percent to set the size of a batch in a roll. Valid values are 0-100.
        :param str comment: Add a `comment` description for the roll. The `comment` is limited to 256 chars
        :param bool respect_pdb: During the roll, if the parameter is set to true we honor PDB during the instance replacement.
        """
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if batch_size_percentage is not None:
            pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[int]:
        """
        Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> Optional[int]:
        """
        Value as a percent to set the size of a batch in a roll. Valid values are 0-100.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Add a `comment` description for the roll. The `comment` is limited to 256 chars
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[bool]:
        """
        During the roll, if the parameter is set to true we honor PDB during the instance replacement.
        """
        return pulumi.get(self, "respect_pdb")


@pulumi.output_type
class OceanTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The tag key.
        :param str value: The tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OceanUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shouldRoll":
            suggest = "should_roll"
        elif key == "autoApplyTags":
            suggest = "auto_apply_tags"
        elif key == "conditionedRoll":
            suggest = "conditioned_roll"
        elif key == "conditionedRollParams":
            suggest = "conditioned_roll_params"
        elif key == "rollConfig":
            suggest = "roll_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 should_roll: bool,
                 auto_apply_tags: Optional[bool] = None,
                 conditioned_roll: Optional[bool] = None,
                 conditioned_roll_params: Optional[Sequence[str]] = None,
                 roll_config: Optional['outputs.OceanUpdatePolicyRollConfig'] = None):
        """
        :param bool should_roll: Enables the roll.
        :param bool auto_apply_tags: will update instance tags on the fly without rolling the cluster.
        :param bool conditioned_roll: Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        :param Sequence[str] conditioned_roll_params: A custom list of attributes will trigger the cluster roll operation (overrides the predefined list of parameters). Valid only when the `conditioned_roll` parameter is set to true. (Valid values: `"subnet_ids"`,`"whitelist"`,`"blacklist"`,`"user_data"`,`"image_id"`,`"security_groups"`,`"key_name"`,`"iam_instance_profile"`,`"associate_public_ip_address"`,`"load_balancers"`,`"instance_metadata_options"`,`"ebs_optimized"`,`"root_volume_size"`)
        :param 'OceanUpdatePolicyRollConfigArgs' roll_config: While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        pulumi.set(__self__, "should_roll", should_roll)
        if auto_apply_tags is not None:
            pulumi.set(__self__, "auto_apply_tags", auto_apply_tags)
        if conditioned_roll is not None:
            pulumi.set(__self__, "conditioned_roll", conditioned_roll)
        if conditioned_roll_params is not None:
            pulumi.set(__self__, "conditioned_roll_params", conditioned_roll_params)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> bool:
        """
        Enables the roll.
        """
        return pulumi.get(self, "should_roll")

    @property
    @pulumi.getter(name="autoApplyTags")
    def auto_apply_tags(self) -> Optional[bool]:
        """
        will update instance tags on the fly without rolling the cluster.
        """
        return pulumi.get(self, "auto_apply_tags")

    @property
    @pulumi.getter(name="conditionedRoll")
    def conditioned_roll(self) -> Optional[bool]:
        """
        Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        """
        return pulumi.get(self, "conditioned_roll")

    @property
    @pulumi.getter(name="conditionedRollParams")
    def conditioned_roll_params(self) -> Optional[Sequence[str]]:
        """
        A custom list of attributes will trigger the cluster roll operation (overrides the predefined list of parameters). Valid only when the `conditioned_roll` parameter is set to true. (Valid values: `"subnet_ids"`,`"whitelist"`,`"blacklist"`,`"user_data"`,`"image_id"`,`"security_groups"`,`"key_name"`,`"iam_instance_profile"`,`"associate_public_ip_address"`,`"load_balancers"`,`"instance_metadata_options"`,`"ebs_optimized"`,`"root_volume_size"`)
        """
        return pulumi.get(self, "conditioned_roll_params")

    @property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional['outputs.OceanUpdatePolicyRollConfig']:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "roll_config")


@pulumi.output_type
class OceanUpdatePolicyRollConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSizePercentage":
            suggest = "batch_size_percentage"
        elif key == "batchMinHealthyPercentage":
            suggest = "batch_min_healthy_percentage"
        elif key == "launchSpecIds":
            suggest = "launch_spec_ids"
        elif key == "respectPdb":
            suggest = "respect_pdb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanUpdatePolicyRollConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanUpdatePolicyRollConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanUpdatePolicyRollConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size_percentage: int,
                 batch_min_healthy_percentage: Optional[int] = None,
                 launch_spec_ids: Optional[Sequence[str]] = None,
                 respect_pdb: Optional[bool] = None):
        """
        :param int batch_size_percentage: Sets the percentage of the instances to deploy in each batch.
        :param int batch_min_healthy_percentage: Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        :param Sequence[str] launch_spec_ids: List of virtual node group identifiers to be rolled.
        :param bool respect_pdb: During the roll, if the parameter is set to `true` we honor PDB during the instance replacement.
        """
        pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)
        if launch_spec_ids is not None:
            pulumi.set(__self__, "launch_spec_ids", launch_spec_ids)
        if respect_pdb is not None:
            pulumi.set(__self__, "respect_pdb", respect_pdb)

    @property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> int:
        """
        Sets the percentage of the instances to deploy in each batch.
        """
        return pulumi.get(self, "batch_size_percentage")

    @property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[int]:
        """
        Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @property
    @pulumi.getter(name="launchSpecIds")
    def launch_spec_ids(self) -> Optional[Sequence[str]]:
        """
        List of virtual node group identifiers to be rolled.
        """
        return pulumi.get(self, "launch_spec_ids")

    @property
    @pulumi.getter(name="respectPdb")
    def respect_pdb(self) -> Optional[bool]:
        """
        During the roll, if the parameter is set to `true` we honor PDB during the instance replacement.
        """
        return pulumi.get(self, "respect_pdb")


@pulumi.output_type
class SuspensionSuspension(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of process to suspend. Valid values: `"AUTO_HEALING" , "OUT_OF_STRATEGY", "PREVENTIVE_REPLACEMENT", "REVERT_PREFERRED", or "SCHEDULING"`.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of process to suspend. Valid values: `"AUTO_HEALING" , "OUT_OF_STRATEGY", "PREVENTIVE_REPLACEMENT", "REVERT_PREFERRED", or "SCHEDULING"`.
        """
        return pulumi.get(self, "name")


