# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanNpVirtualNodeGroupArgs', 'OceanNpVirtualNodeGroup']

@pulumi.input_type
class OceanNpVirtualNodeGroupArgs:
    def __init__(__self__, *,
                 ocean_id: pulumi.Input[str],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs']] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling: Optional[pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs']] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanNpVirtualNodeGroupUpdatePolicyArgs']] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a OceanNpVirtualNodeGroup resource.
        :param pulumi.Input[str] ocean_id: The Ocean cluster identifier. Required for Launch Spec creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[bool] fallback_to_ondemand: If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        :param pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs'] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input[str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input[int] max_count: Maximum node count limit.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[int] min_count: Minimum node count limit.
        :param pulumi.Input[str] name: Enter a name for the virtual node group.
        :param pulumi.Input[int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs'] scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        :param pulumi.Input[int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]] taints: Add taints to a virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        pulumi.set(__self__, "ocean_id", ocean_id)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if headrooms is not None:
            pulumi.set(__self__, "headrooms", headrooms)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_os_configs is not None:
            pulumi.set(__self__, "linux_os_configs", linux_os_configs)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_ids is not None:
            pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if vnet_subnet_ids is not None:
            pulumi.set(__self__, "vnet_subnet_ids", vnet_subnet_ids)

    @property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> pulumi.Input[str]:
        """
        The Ocean cluster identifier. Required for Launch Spec creation.
        """
        return pulumi.get(self, "ocean_id")

    @ocean_id.setter
    def ocean_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ocean_id", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable node public IP.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[bool]]:
        """
        If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs']]:
        """
        Filters for the VM sizes that can be launched from the virtual node group.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]]]:
        """
        Specify the custom headroom per VNG. Provide a list of headroom objects.
        """
        return pulumi.get(self, "headrooms")

    @headrooms.setter
    def headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]]]):
        pulumi.set(self, "headrooms", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linuxOsConfigs")
    def linux_os_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]]]:
        """
        Custom Linux OS configuration.
        """
        return pulumi.get(self, "linux_os_configs")

    @linux_os_configs.setter
    def linux_os_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]]]):
        pulumi.set(self, "linux_os_configs", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum node count limit.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods per node in the node pools.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum node count limit.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Enter a name for the virtual node group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the OS disk in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the OS disk.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_disk_type", value)

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The OS SKU of the OS type. Must correlate with the os type.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_sku", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The OS type of the OS disk. Can't be modified once set.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "pod_subnet_ids")

    @pod_subnet_ids.setter
    def pod_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_subnet_ids", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs']]:
        """
        An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of spot VMs to maintain.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_percentage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]]]:
        """
        Add taints to a virtual node group.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanNpVirtualNodeGroupUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanNpVirtualNodeGroupUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "vnet_subnet_ids")

    @vnet_subnet_ids.setter
    def vnet_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vnet_subnet_ids", value)


@pulumi.input_type
class _OceanNpVirtualNodeGroupState:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs']] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocean_id: Optional[pulumi.Input[str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling: Optional[pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs']] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanNpVirtualNodeGroupUpdatePolicyArgs']] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering OceanNpVirtualNodeGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[bool] fallback_to_ondemand: If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        :param pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs'] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input[str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input[int] max_count: Maximum node count limit.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[int] min_count: Minimum node count limit.
        :param pulumi.Input[str] name: Enter a name for the virtual node group.
        :param pulumi.Input[str] ocean_id: The Ocean cluster identifier. Required for Launch Spec creation.
        :param pulumi.Input[int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs'] scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        :param pulumi.Input[int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]] taints: Add taints to a virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if headrooms is not None:
            pulumi.set(__self__, "headrooms", headrooms)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_os_configs is not None:
            pulumi.set(__self__, "linux_os_configs", linux_os_configs)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocean_id is not None:
            pulumi.set(__self__, "ocean_id", ocean_id)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_ids is not None:
            pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if vnet_subnet_ids is not None:
            pulumi.set(__self__, "vnet_subnet_ids", vnet_subnet_ids)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable node public IP.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[bool]]:
        """
        If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs']]:
        """
        Filters for the VM sizes that can be launched from the virtual node group.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanNpVirtualNodeGroupFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]]]:
        """
        Specify the custom headroom per VNG. Provide a list of headroom objects.
        """
        return pulumi.get(self, "headrooms")

    @headrooms.setter
    def headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupHeadroomArgs']]]]):
        pulumi.set(self, "headrooms", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linuxOsConfigs")
    def linux_os_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]]]:
        """
        Custom Linux OS configuration.
        """
        return pulumi.get(self, "linux_os_configs")

    @linux_os_configs.setter
    def linux_os_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupLinuxOsConfigArgs']]]]):
        pulumi.set(self, "linux_os_configs", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum node count limit.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods per node in the node pools.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum node count limit.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Enter a name for the virtual node group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Ocean cluster identifier. Required for Launch Spec creation.
        """
        return pulumi.get(self, "ocean_id")

    @ocean_id.setter
    def ocean_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocean_id", value)

    @property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the OS disk in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the OS disk.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_disk_type", value)

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The OS SKU of the OS type. Must correlate with the os type.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_sku", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The OS type of the OS disk. Can't be modified once set.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "pod_subnet_ids")

    @pod_subnet_ids.setter
    def pod_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_subnet_ids", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs']]:
        """
        An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['OceanNpVirtualNodeGroupSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Percentage of spot VMs to maintain.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_percentage", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]]]:
        """
        Add taints to a virtual node group.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpVirtualNodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanNpVirtualNodeGroupUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanNpVirtualNodeGroupUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "vnet_subnet_ids")

    @vnet_subnet_ids.setter
    def vnet_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vnet_subnet_ids", value)


class OceanNpVirtualNodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupFiltersArgs', 'OceanNpVirtualNodeGroupFiltersArgsDict']]] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupHeadroomArgs', 'OceanNpVirtualNodeGroupHeadroomArgsDict']]]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupLinuxOsConfigArgs', 'OceanNpVirtualNodeGroupLinuxOsConfigArgsDict']]]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocean_id: Optional[pulumi.Input[str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupSchedulingArgs', 'OceanNpVirtualNodeGroupSchedulingArgsDict']]] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupTaintArgs', 'OceanNpVirtualNodeGroupTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupUpdatePolicyArgs', 'OceanNpVirtualNodeGroupUpdatePolicyArgsDict']]] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a Spotinst Ocean AKS Virtual Node Groups resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.azure.OceanNpVirtualNodeGroup("example",
            name="testVng",
            ocean_id="o-134abcd",
            headrooms=[{
                "cpu_per_unit": 1024,
                "memory_per_unit": 512,
                "gpu_per_unit": 0,
                "num_of_units": 2,
            }],
            availability_zones=[
                "1",
                "2",
                "3",
            ],
            labels={
                "key": "env",
                "value": "test",
            },
            min_count=1,
            max_count=100,
            max_pods_per_node=30,
            enable_node_public_ip=True,
            os_disk_size_gb=30,
            os_disk_type="Managed",
            os_type="Linux",
            os_sku="Ubuntu",
            kubernetes_version="1.26",
            pod_subnet_ids=["/subscriptions/123456-1234-1234-1234-123456789/resourceGroups/ExampleResourceGroup/providers/Microsoft.Network/virtualNetworks/ExampleVirtualNetwork/subnets/default"],
            vnet_subnet_ids=["/subscriptions/123456-1234-1234-1234-123456789/resourceGroups/ExampleResourceGroup/providers/Microsoft.Network/virtualNetworks/ExampleVirtualNetwork/subnets/default"],
            linux_os_configs=[{
                "sysctls": [{
                    "vm_max_map_count": 79550,
                }],
            }],
            spot_percentage=50,
            fallback_to_ondemand=True,
            taints=[{
                "key": "taintKey",
                "value": "taintValue",
                "effect": "NoSchedule",
            }],
            tags={
                "tagKey": "env",
                "tagValue": "staging",
            },
            filters={
                "min_vcpu": 2,
                "max_vcpu": 16,
                "min_memory_gib": 8,
                "max_memory_gib": 128,
                "architectures": [
                    "x86_64",
                    "arm64",
                ],
                "series": [
                    "D v3",
                    "Dds_v4",
                    "Dsv2",
                ],
                "exclude_series": [
                    "Av2",
                    "A",
                    "Bs",
                    "D",
                    "E",
                ],
                "accelerated_networking": "Enabled",
                "disk_performance": "Premium",
                "min_gpu": 1,
                "max_gpu": 2,
                "min_nics": 1,
                "vm_types": [
                    "generalPurpose",
                    "GPU",
                ],
                "min_disk": 1,
                "gpu_types": ["nvidia-tesla-t4"],
            },
            scheduling={
                "shutdown_hours": {
                    "is_enabled": True,
                    "time_windows": [
                        "Fri:15:30-Sat:20:30",
                        "Sun:08:30-Mon:08:30",
                    ],
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[bool] fallback_to_ondemand: If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        :param pulumi.Input[Union['OceanNpVirtualNodeGroupFiltersArgs', 'OceanNpVirtualNodeGroupFiltersArgsDict']] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupHeadroomArgs', 'OceanNpVirtualNodeGroupHeadroomArgsDict']]]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input[str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupLinuxOsConfigArgs', 'OceanNpVirtualNodeGroupLinuxOsConfigArgsDict']]]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input[int] max_count: Maximum node count limit.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[int] min_count: Minimum node count limit.
        :param pulumi.Input[str] name: Enter a name for the virtual node group.
        :param pulumi.Input[str] ocean_id: The Ocean cluster identifier. Required for Launch Spec creation.
        :param pulumi.Input[int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input[Union['OceanNpVirtualNodeGroupSchedulingArgs', 'OceanNpVirtualNodeGroupSchedulingArgsDict']] scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        :param pulumi.Input[int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupTaintArgs', 'OceanNpVirtualNodeGroupTaintArgsDict']]]] taints: Add taints to a virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanNpVirtualNodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spotinst Ocean AKS Virtual Node Groups resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.azure.OceanNpVirtualNodeGroup("example",
            name="testVng",
            ocean_id="o-134abcd",
            headrooms=[{
                "cpu_per_unit": 1024,
                "memory_per_unit": 512,
                "gpu_per_unit": 0,
                "num_of_units": 2,
            }],
            availability_zones=[
                "1",
                "2",
                "3",
            ],
            labels={
                "key": "env",
                "value": "test",
            },
            min_count=1,
            max_count=100,
            max_pods_per_node=30,
            enable_node_public_ip=True,
            os_disk_size_gb=30,
            os_disk_type="Managed",
            os_type="Linux",
            os_sku="Ubuntu",
            kubernetes_version="1.26",
            pod_subnet_ids=["/subscriptions/123456-1234-1234-1234-123456789/resourceGroups/ExampleResourceGroup/providers/Microsoft.Network/virtualNetworks/ExampleVirtualNetwork/subnets/default"],
            vnet_subnet_ids=["/subscriptions/123456-1234-1234-1234-123456789/resourceGroups/ExampleResourceGroup/providers/Microsoft.Network/virtualNetworks/ExampleVirtualNetwork/subnets/default"],
            linux_os_configs=[{
                "sysctls": [{
                    "vm_max_map_count": 79550,
                }],
            }],
            spot_percentage=50,
            fallback_to_ondemand=True,
            taints=[{
                "key": "taintKey",
                "value": "taintValue",
                "effect": "NoSchedule",
            }],
            tags={
                "tagKey": "env",
                "tagValue": "staging",
            },
            filters={
                "min_vcpu": 2,
                "max_vcpu": 16,
                "min_memory_gib": 8,
                "max_memory_gib": 128,
                "architectures": [
                    "x86_64",
                    "arm64",
                ],
                "series": [
                    "D v3",
                    "Dds_v4",
                    "Dsv2",
                ],
                "exclude_series": [
                    "Av2",
                    "A",
                    "Bs",
                    "D",
                    "E",
                ],
                "accelerated_networking": "Enabled",
                "disk_performance": "Premium",
                "min_gpu": 1,
                "max_gpu": 2,
                "min_nics": 1,
                "vm_types": [
                    "generalPurpose",
                    "GPU",
                ],
                "min_disk": 1,
                "gpu_types": ["nvidia-tesla-t4"],
            },
            scheduling={
                "shutdown_hours": {
                    "is_enabled": True,
                    "time_windows": [
                        "Fri:15:30-Sat:20:30",
                        "Sun:08:30-Mon:08:30",
                    ],
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param OceanNpVirtualNodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanNpVirtualNodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupFiltersArgs', 'OceanNpVirtualNodeGroupFiltersArgsDict']]] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupHeadroomArgs', 'OceanNpVirtualNodeGroupHeadroomArgsDict']]]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupLinuxOsConfigArgs', 'OceanNpVirtualNodeGroupLinuxOsConfigArgsDict']]]]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocean_id: Optional[pulumi.Input[str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_disk_type: Optional[pulumi.Input[str]] = None,
                 os_sku: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scheduling: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupSchedulingArgs', 'OceanNpVirtualNodeGroupSchedulingArgsDict']]] = None,
                 spot_percentage: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupTaintArgs', 'OceanNpVirtualNodeGroupTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupUpdatePolicyArgs', 'OceanNpVirtualNodeGroupUpdatePolicyArgsDict']]] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanNpVirtualNodeGroupArgs.__new__(OceanNpVirtualNodeGroupArgs)

            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["enable_node_public_ip"] = enable_node_public_ip
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["filters"] = filters
            __props__.__dict__["headrooms"] = headrooms
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linux_os_configs"] = linux_os_configs
            __props__.__dict__["max_count"] = max_count
            __props__.__dict__["max_pods_per_node"] = max_pods_per_node
            __props__.__dict__["min_count"] = min_count
            __props__.__dict__["name"] = name
            if ocean_id is None and not opts.urn:
                raise TypeError("Missing required property 'ocean_id'")
            __props__.__dict__["ocean_id"] = ocean_id
            __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
            __props__.__dict__["os_disk_type"] = os_disk_type
            __props__.__dict__["os_sku"] = os_sku
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["pod_subnet_ids"] = pod_subnet_ids
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["spot_percentage"] = spot_percentage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["vnet_subnet_ids"] = vnet_subnet_ids
        super(OceanNpVirtualNodeGroup, __self__).__init__(
            'spotinst:azure/oceanNpVirtualNodeGroup:OceanNpVirtualNodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[bool]] = None,
            filters: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupFiltersArgs', 'OceanNpVirtualNodeGroupFiltersArgsDict']]] = None,
            headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupHeadroomArgs', 'OceanNpVirtualNodeGroupHeadroomArgsDict']]]]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupLinuxOsConfigArgs', 'OceanNpVirtualNodeGroupLinuxOsConfigArgsDict']]]]] = None,
            max_count: Optional[pulumi.Input[int]] = None,
            max_pods_per_node: Optional[pulumi.Input[int]] = None,
            min_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ocean_id: Optional[pulumi.Input[str]] = None,
            os_disk_size_gb: Optional[pulumi.Input[int]] = None,
            os_disk_type: Optional[pulumi.Input[str]] = None,
            os_sku: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scheduling: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupSchedulingArgs', 'OceanNpVirtualNodeGroupSchedulingArgsDict']]] = None,
            spot_percentage: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupTaintArgs', 'OceanNpVirtualNodeGroupTaintArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanNpVirtualNodeGroupUpdatePolicyArgs', 'OceanNpVirtualNodeGroupUpdatePolicyArgsDict']]] = None,
            vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'OceanNpVirtualNodeGroup':
        """
        Get an existing OceanNpVirtualNodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[bool] fallback_to_ondemand: If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        :param pulumi.Input[Union['OceanNpVirtualNodeGroupFiltersArgs', 'OceanNpVirtualNodeGroupFiltersArgsDict']] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupHeadroomArgs', 'OceanNpVirtualNodeGroupHeadroomArgsDict']]]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input[str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupLinuxOsConfigArgs', 'OceanNpVirtualNodeGroupLinuxOsConfigArgsDict']]]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input[int] max_count: Maximum node count limit.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[int] min_count: Minimum node count limit.
        :param pulumi.Input[str] name: Enter a name for the virtual node group.
        :param pulumi.Input[str] ocean_id: The Ocean cluster identifier. Required for Launch Spec creation.
        :param pulumi.Input[int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input[Union['OceanNpVirtualNodeGroupSchedulingArgs', 'OceanNpVirtualNodeGroupSchedulingArgsDict']] scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        :param pulumi.Input[int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpVirtualNodeGroupTaintArgs', 'OceanNpVirtualNodeGroupTaintArgsDict']]]] taints: Add taints to a virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanNpVirtualNodeGroupState.__new__(_OceanNpVirtualNodeGroupState)

        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["enable_node_public_ip"] = enable_node_public_ip
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["filters"] = filters
        __props__.__dict__["headrooms"] = headrooms
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linux_os_configs"] = linux_os_configs
        __props__.__dict__["max_count"] = max_count
        __props__.__dict__["max_pods_per_node"] = max_pods_per_node
        __props__.__dict__["min_count"] = min_count
        __props__.__dict__["name"] = name
        __props__.__dict__["ocean_id"] = ocean_id
        __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
        __props__.__dict__["os_disk_type"] = os_disk_type
        __props__.__dict__["os_sku"] = os_sku
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["pod_subnet_ids"] = pod_subnet_ids
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["spot_percentage"] = spot_percentage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["vnet_subnet_ids"] = vnet_subnet_ids
        return OceanNpVirtualNodeGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable node public IP.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[Optional[bool]]:
        """
        If no spot instance markets are available, enable Ocean to launch on-demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.OceanNpVirtualNodeGroupFilters']]:
        """
        Filters for the VM sizes that can be launched from the virtual node group.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def headrooms(self) -> pulumi.Output[Optional[Sequence['outputs.OceanNpVirtualNodeGroupHeadroom']]]:
        """
        Specify the custom headroom per VNG. Provide a list of headroom objects.
        """
        return pulumi.get(self, "headrooms")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[Optional[str]]:
        """
        The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        An array of labels to add to the virtual node group.Only custom user labels are allowed, and not Kubernetes built-in labels or Spot internal labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxOsConfigs")
    def linux_os_configs(self) -> pulumi.Output[Optional[Sequence['outputs.OceanNpVirtualNodeGroupLinuxOsConfig']]]:
        """
        Custom Linux OS configuration.
        """
        return pulumi.get(self, "linux_os_configs")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum node count limit.
        """
        return pulumi.get(self, "max_count")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of pods per node in the node pools.
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> pulumi.Output[Optional[int]]:
        """
        Minimum node count limit.
        """
        return pulumi.get(self, "min_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Enter a name for the virtual node group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> pulumi.Output[str]:
        """
        The Ocean cluster identifier. Required for Launch Spec creation.
        """
        return pulumi.get(self, "ocean_id")

    @property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> pulumi.Output[Optional[int]]:
        """
        The size of the OS disk in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the OS disk.
        """
        return pulumi.get(self, "os_disk_type")

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> pulumi.Output[Optional[str]]:
        """
        The OS SKU of the OS type. Must correlate with the os type.
        """
        return pulumi.get(self, "os_sku")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[str]]:
        """
        The OS type of the OS disk. Can't be modified once set.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "pod_subnet_ids")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output[Optional['outputs.OceanNpVirtualNodeGroupScheduling']]:
        """
        An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> pulumi.Output[Optional[int]]:
        """
        Percentage of spot VMs to maintain.
        """
        return pulumi.get(self, "spot_percentage")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.OceanNpVirtualNodeGroupTaint']]]:
        """
        Add taints to a virtual node group.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanNpVirtualNodeGroupUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

    @property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "vnet_subnet_ids")

