# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ElastigroupBackendService',
    'ElastigroupBackendServiceNamedPort',
    'ElastigroupDisk',
    'ElastigroupDiskInitializeParam',
    'ElastigroupGpu',
    'ElastigroupInstanceTypesCustom',
    'ElastigroupIntegrationDockerSwarm',
    'ElastigroupIntegrationGke',
    'ElastigroupIntegrationGkeAutoscaleDown',
    'ElastigroupIntegrationGkeAutoscaleHeadroom',
    'ElastigroupIntegrationGkeAutoscaleLabel',
    'ElastigroupLabel',
    'ElastigroupMetadata',
    'ElastigroupNetworkInterface',
    'ElastigroupNetworkInterfaceAccessConfig',
    'ElastigroupNetworkInterfaceAliasIpRange',
    'ElastigroupRevertToPreemptible',
    'ElastigroupScalingDownPolicy',
    'ElastigroupScalingDownPolicyDimension',
    'ElastigroupScalingUpPolicy',
    'ElastigroupScalingUpPolicyDimension',
    'ElastigroupScheduledTask',
    'ElastigroupSubnet',
]

@pulumi.output_type
class ElastigroupBackendService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"
        elif key == "locationType":
            suggest = "location_type"
        elif key == "namedPorts":
            suggest = "named_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupBackendService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupBackendService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupBackendService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: str,
                 location_type: Optional[str] = None,
                 named_ports: Optional[Sequence['outputs.ElastigroupBackendServiceNamedPort']] = None,
                 scheme: Optional[str] = None):
        """
        :param str service_name: The name of the backend service.
        :param str location_type: Sets which location the backend services will be active. Valid values: `regional`, `global`.
        :param Sequence['ElastigroupBackendServiceNamedPortArgs'] named_ports: Describes a named port and a list of ports.
        :param str scheme: Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
        pulumi.set(__self__, "service_name", service_name)
        if location_type is not None:
            pulumi.set(__self__, "location_type", location_type)
        if named_ports is not None:
            pulumi.set(__self__, "named_ports", named_ports)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the backend service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> Optional[str]:
        """
        Sets which location the backend services will be active. Valid values: `regional`, `global`.
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter(name="namedPorts")
    def named_ports(self) -> Optional[Sequence['outputs.ElastigroupBackendServiceNamedPort']]:
        """
        Describes a named port and a list of ports.
        """
        return pulumi.get(self, "named_ports")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[str]:
        """
        Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class ElastigroupBackendServiceNamedPort(dict):
    def __init__(__self__, *,
                 name: str,
                 ports: Sequence[str]):
        """
        :param str name: The name of the port.
        :param Sequence[str] ports: A list of ports.
               
               Usage:
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        """
        A list of ports.

        Usage:
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ElastigroupDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "initializeParams":
            suggest = "initialize_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: Optional[bool] = None,
                 boot: Optional[bool] = None,
                 device_name: Optional[str] = None,
                 initialize_params: Optional[Sequence['outputs.ElastigroupDiskInitializeParam']] = None,
                 interface: Optional[str] = None,
                 mode: Optional[str] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param bool auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted.
        :param bool boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param str device_name: Specifies a unique device name of your choice.
        :param Sequence['ElastigroupDiskInitializeParamArgs'] initialize_params: Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        :param str interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        :param str mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        :param str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param str type: Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if initialize_params is not None:
            pulumi.set(__self__, "initialize_params", initialize_params)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[bool]:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted.
        """
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def boot(self) -> Optional[bool]:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        Specifies a unique device name of your choice.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> Optional[Sequence['outputs.ElastigroupDiskInitializeParam']]:
        """
        Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        """
        return pulumi.get(self, "initialize_params")

    @property
    @pulumi.getter
    def interface(self) -> Optional[str]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupDiskInitializeParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceImage":
            suggest = "source_image"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupDiskInitializeParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupDiskInitializeParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupDiskInitializeParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_image: str,
                 disk_size_gb: Optional[str] = None,
                 disk_type: Optional[str] = None):
        """
        :param str source_image: A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.
               
               Usage:
        :param str disk_size_gb: Specifies disk size in gigabytes. Must be in increments of 2.
        :param str disk_type: Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
        pulumi.set(__self__, "source_image", source_image)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> str:
        """
        A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.

        Usage:
        """
        return pulumi.get(self, "source_image")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[str]:
        """
        Specifies disk size in gigabytes. Must be in increments of 2.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
        return pulumi.get(self, "disk_type")


@pulumi.output_type
class ElastigroupGpu(dict):
    def __init__(__self__, *,
                 count: int,
                 type: str):
        """
        :param int count: The number of GPUs. Must be 0, 2, 4, 6, 8.
               
               Usage:
        :param str type: The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of GPUs. Must be 0, 2, 4, 6, 8.

        Usage:
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupInstanceTypesCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryGib":
            suggest = "memory_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupInstanceTypesCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupInstanceTypesCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupInstanceTypesCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_gib: int,
                 vcpu: int):
        """
        :param int memory_gib: The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        pulumi.set(__self__, "memory_gib", memory_gib)
        pulumi.set(__self__, "vcpu", vcpu)

    @property
    @pulumi.getter(name="memoryGib")
    def memory_gib(self) -> int:
        """
        The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        return pulumi.get(self, "memory_gib")

    @property
    @pulumi.getter
    def vcpu(self) -> int:
        return pulumi.get(self, "vcpu")


@pulumi.output_type
class ElastigroupIntegrationDockerSwarm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterHost":
            suggest = "master_host"
        elif key == "masterPort":
            suggest = "master_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationDockerSwarm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationDockerSwarm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationDockerSwarm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_host: str,
                 master_port: int):
        """
        :param str master_host: IP or FQDN of one of your swarm managers.
        :param int master_port: Network port used by your swarm.
               
               Usage:
        """
        pulumi.set(__self__, "master_host", master_host)
        pulumi.set(__self__, "master_port", master_port)

    @property
    @pulumi.getter(name="masterHost")
    def master_host(self) -> str:
        """
        IP or FQDN of one of your swarm managers.
        """
        return pulumi.get(self, "master_host")

    @property
    @pulumi.getter(name="masterPort")
    def master_port(self) -> int:
        """
        Network port used by your swarm.

        Usage:
        """
        return pulumi.get(self, "master_port")


@pulumi.output_type
class ElastigroupIntegrationGke(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUpdate":
            suggest = "auto_update"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsAutoConfig":
            suggest = "autoscale_is_auto_config"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"
        elif key == "autoscaleLabels":
            suggest = "autoscale_labels"
        elif key == "clusterId":
            suggest = "cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGke. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGke.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGke.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_update: Optional[bool] = None,
                 autoscale_cooldown: Optional[int] = None,
                 autoscale_down: Optional['outputs.ElastigroupIntegrationGkeAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.ElastigroupIntegrationGkeAutoscaleHeadroom'] = None,
                 autoscale_is_auto_config: Optional[bool] = None,
                 autoscale_is_enabled: Optional[bool] = None,
                 autoscale_labels: Optional[Sequence['outputs.ElastigroupIntegrationGkeAutoscaleLabel']] = None,
                 cluster_id: Optional[str] = None,
                 location: Optional[str] = None):
        if auto_update is not None:
            pulumi.set(__self__, "auto_update", auto_update)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_auto_config is not None:
            pulumi.set(__self__, "autoscale_is_auto_config", autoscale_is_auto_config)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if autoscale_labels is not None:
            pulumi.set(__self__, "autoscale_labels", autoscale_labels)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[bool]:
        return pulumi.get(self, "auto_update")

    @property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[int]:
        return pulumi.get(self, "autoscale_cooldown")

    @property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.ElastigroupIntegrationGkeAutoscaleDown']:
        return pulumi.get(self, "autoscale_down")

    @property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.ElastigroupIntegrationGkeAutoscaleHeadroom']:
        return pulumi.get(self, "autoscale_headroom")

    @property
    @pulumi.getter(name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_auto_config")

    @property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "autoscale_is_enabled")

    @property
    @pulumi.getter(name="autoscaleLabels")
    def autoscale_labels(self) -> Optional[Sequence['outputs.ElastigroupIntegrationGkeAutoscaleLabel']]:
        return pulumi.get(self, "autoscale_labels")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        return pulumi.get(self, "location")


@pulumi.output_type
class ElastigroupIntegrationGkeAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGkeAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGkeAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGkeAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[int] = None):
        """
        :param int evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")


@pulumi.output_type
class ElastigroupIntegrationGkeAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGkeAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGkeAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGkeAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[int] = None,
                 memory_per_unit: Optional[int] = None,
                 num_of_units: Optional[int] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "cpu_per_unit")

    @property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[int]:
        return pulumi.get(self, "memory_per_unit")

    @property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[int]:
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class ElastigroupIntegrationGkeAutoscaleLabel(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupLabel(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Labels key.
        :param str value: Labels value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Labels key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Labels value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupMetadata(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Metadata key.
        :param str value: Metadata value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Metadata key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Metadata value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfigs":
            suggest = "access_configs"
        elif key == "aliasIpRanges":
            suggest = "alias_ip_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: str,
                 access_configs: Optional[Sequence['outputs.ElastigroupNetworkInterfaceAccessConfig']] = None,
                 alias_ip_ranges: Optional[Sequence['outputs.ElastigroupNetworkInterfaceAliasIpRange']] = None):
        """
        :param str network: Network resource for this group.
        :param Sequence['ElastigroupNetworkInterfaceAccessConfigArgs'] access_configs: Array of configurations.
        """
        pulumi.set(__self__, "network", network)
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if alias_ip_ranges is not None:
            pulumi.set(__self__, "alias_ip_ranges", alias_ip_ranges)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Network resource for this group.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[Sequence['outputs.ElastigroupNetworkInterfaceAccessConfig']]:
        """
        Array of configurations.
        """
        return pulumi.get(self, "access_configs")

    @property
    @pulumi.getter(name="aliasIpRanges")
    def alias_ip_ranges(self) -> Optional[Sequence['outputs.ElastigroupNetworkInterfaceAliasIpRange']]:
        return pulumi.get(self, "alias_ip_ranges")


@pulumi.output_type
class ElastigroupNetworkInterfaceAccessConfig(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: The group name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupNetworkInterfaceAliasIpRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipCidrRange":
            suggest = "ip_cidr_range"
        elif key == "subnetworkRangeName":
            suggest = "subnetwork_range_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupNetworkInterfaceAliasIpRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupNetworkInterfaceAliasIpRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupNetworkInterfaceAliasIpRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_cidr_range: str,
                 subnetwork_range_name: str):
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "subnetwork_range_name", subnetwork_range_name)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> str:
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter(name="subnetworkRangeName")
    def subnetwork_range_name(self) -> str:
        return pulumi.get(self, "subnetwork_range_name")


@pulumi.output_type
class ElastigroupRevertToPreemptible(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupRevertToPreemptible. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupRevertToPreemptible.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupRevertToPreemptible.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: str):
        """
        :param str perform_at: Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
        pulumi.set(__self__, "perform_at", perform_at)

    @property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> str:
        """
        Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
        return pulumi.get(self, "perform_at")


@pulumi.output_type
class ElastigroupScalingDownPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingDownPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingDownPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingDownPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 threshold: float,
                 unit: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[int] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingDownPolicyDimension']] = None,
                 evaluation_periods: Optional[int] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 source: Optional[str] = None,
                 statistic: Optional[str] = None):
        """
        :param str metric_name: Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        :param str policy_name: Name of scaling policy.
        :param float threshold: The value at which the scaling action is triggered.
        :param str action_type: Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        :param int adjustment: Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        :param int cooldown: Time (seconds) to wait after a scaling action before resuming monitoring.
        :param Sequence['ElastigroupScalingDownPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param int evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        :param str operator: The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        :param int period: Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        :param str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param str statistic: Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        Name of scaling policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The value at which the scaling action is triggered.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[int]:
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingDownPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        return pulumi.get(self, "statistic")


@pulumi.output_type
class ElastigroupScalingDownPolicyDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The group name.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScalingUpPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingUpPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingUpPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingUpPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 policy_name: str,
                 threshold: float,
                 unit: str,
                 action_type: Optional[str] = None,
                 adjustment: Optional[int] = None,
                 cooldown: Optional[int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingUpPolicyDimension']] = None,
                 evaluation_periods: Optional[int] = None,
                 operator: Optional[str] = None,
                 period: Optional[int] = None,
                 source: Optional[str] = None,
                 statistic: Optional[str] = None):
        """
        :param str metric_name: Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        :param str policy_name: Name of scaling policy.
        :param float threshold: The value at which the scaling action is triggered.
        :param str action_type: Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        :param int adjustment: Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        :param int cooldown: Time (seconds) to wait after a scaling action before resuming monitoring.
        :param Sequence['ElastigroupScalingUpPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param int evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        :param str operator: The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        :param int period: Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        :param str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param str statistic: Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        Name of scaling policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The value at which the scaling action is triggered.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> str:
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def adjustment(self) -> Optional[int]:
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        return pulumi.get(self, "adjustment")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingUpPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        return pulumi.get(self, "statistic")


@pulumi.output_type
class ElastigroupScalingUpPolicyDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The dimension name.
        :param str value: The dimension value.
               
               Usage:
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The dimension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The dimension value.

        Usage:
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: str,
                 cron_expression: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 max_capacity: Optional[str] = None,
                 min_capacity: Optional[str] = None,
                 target_capacity: Optional[str] = None):
        """
        :param str task_type: The task type to run. Valid values: `"setCapacity"`.
        :param str cron_expression: A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        :param bool is_enabled: Setting the task to being enabled or disabled.
        :param str max_capacity: The maximum number of instances the group should have.
               
               Usage:
        :param str min_capacity: The minimum number of instances the group should have.
        :param str target_capacity: The desired number of instances the group should have.
        """
        pulumi.set(__self__, "task_type", task_type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> str:
        """
        The task type to run. Valid values: `"setCapacity"`.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[str]:
        """
        A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Setting the task to being enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[str]:
        """
        The maximum number of instances the group should have.

        Usage:
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[str]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[str]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ElastigroupSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetNames":
            suggest = "subnet_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 subnet_names: Sequence[str]):
        """
        :param str region: The region for the group of subnets.
        :param Sequence[str] subnet_names: The names of the subnets in the region.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_names", subnet_names)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region for the group of subnets.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetNames")
    def subnet_names(self) -> Sequence[str]:
        """
        The names of the subnets in the region.
        """
        return pulumi.get(self, "subnet_names")


