# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StrategyArgs', 'Strategy']

@pulumi.input_type
class StrategyArgs:
    def __init__(__self__, *,
                 strategy_name: pulumi.Input[str],
                 canary: Optional[pulumi.Input['StrategyCanaryArgs']] = None,
                 rolling: Optional[pulumi.Input['StrategyRollingArgs']] = None):
        """
        The set of arguments for constructing a Strategy resource.
        :param pulumi.Input['StrategyCanaryArgs'] canary: Represents Canary strategy. Cannot be defined when Rolling object is defined.
        :param pulumi.Input['StrategyRollingArgs'] rolling: Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        pulumi.set(__self__, "strategy_name", strategy_name)
        if canary is not None:
            pulumi.set(__self__, "canary", canary)
        if rolling is not None:
            pulumi.set(__self__, "rolling", rolling)

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "strategy_name")

    @strategy_name.setter
    def strategy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy_name", value)

    @property
    @pulumi.getter
    def canary(self) -> Optional[pulumi.Input['StrategyCanaryArgs']]:
        """
        Represents Canary strategy. Cannot be defined when Rolling object is defined.
        """
        return pulumi.get(self, "canary")

    @canary.setter
    def canary(self, value: Optional[pulumi.Input['StrategyCanaryArgs']]):
        pulumi.set(self, "canary", value)

    @property
    @pulumi.getter
    def rolling(self) -> Optional[pulumi.Input['StrategyRollingArgs']]:
        """
        Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        return pulumi.get(self, "rolling")

    @rolling.setter
    def rolling(self, value: Optional[pulumi.Input['StrategyRollingArgs']]):
        pulumi.set(self, "rolling", value)


@pulumi.input_type
class _StrategyState:
    def __init__(__self__, *,
                 canary: Optional[pulumi.Input['StrategyCanaryArgs']] = None,
                 rolling: Optional[pulumi.Input['StrategyRollingArgs']] = None,
                 strategy_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Strategy resources.
        :param pulumi.Input['StrategyCanaryArgs'] canary: Represents Canary strategy. Cannot be defined when Rolling object is defined.
        :param pulumi.Input['StrategyRollingArgs'] rolling: Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        if canary is not None:
            pulumi.set(__self__, "canary", canary)
        if rolling is not None:
            pulumi.set(__self__, "rolling", rolling)
        if strategy_name is not None:
            pulumi.set(__self__, "strategy_name", strategy_name)

    @property
    @pulumi.getter
    def canary(self) -> Optional[pulumi.Input['StrategyCanaryArgs']]:
        """
        Represents Canary strategy. Cannot be defined when Rolling object is defined.
        """
        return pulumi.get(self, "canary")

    @canary.setter
    def canary(self, value: Optional[pulumi.Input['StrategyCanaryArgs']]):
        pulumi.set(self, "canary", value)

    @property
    @pulumi.getter
    def rolling(self) -> Optional[pulumi.Input['StrategyRollingArgs']]:
        """
        Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        return pulumi.get(self, "rolling")

    @rolling.setter
    def rolling(self, value: Optional[pulumi.Input['StrategyRollingArgs']]):
        pulumi.set(self, "rolling", value)

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "strategy_name")

    @strategy_name.setter
    def strategy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy_name", value)


class Strategy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 canary: Optional[pulumi.Input[Union['StrategyCanaryArgs', 'StrategyCanaryArgsDict']]] = None,
                 rolling: Optional[pulumi.Input[Union['StrategyRollingArgs', 'StrategyRollingArgsDict']]] = None,
                 strategy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Spotinst OceanCD Strategy resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StrategyCanaryArgs', 'StrategyCanaryArgsDict']] canary: Represents Canary strategy. Cannot be defined when Rolling object is defined.
        :param pulumi.Input[Union['StrategyRollingArgs', 'StrategyRollingArgsDict']] rolling: Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StrategyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spotinst OceanCD Strategy resource.

        :param str resource_name: The name of the resource.
        :param StrategyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StrategyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 canary: Optional[pulumi.Input[Union['StrategyCanaryArgs', 'StrategyCanaryArgsDict']]] = None,
                 rolling: Optional[pulumi.Input[Union['StrategyRollingArgs', 'StrategyRollingArgsDict']]] = None,
                 strategy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StrategyArgs.__new__(StrategyArgs)

            __props__.__dict__["canary"] = canary
            __props__.__dict__["rolling"] = rolling
            if strategy_name is None and not opts.urn:
                raise TypeError("Missing required property 'strategy_name'")
            __props__.__dict__["strategy_name"] = strategy_name
        super(Strategy, __self__).__init__(
            'spotinst:oceancd/strategy:Strategy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            canary: Optional[pulumi.Input[Union['StrategyCanaryArgs', 'StrategyCanaryArgsDict']]] = None,
            rolling: Optional[pulumi.Input[Union['StrategyRollingArgs', 'StrategyRollingArgsDict']]] = None,
            strategy_name: Optional[pulumi.Input[str]] = None) -> 'Strategy':
        """
        Get an existing Strategy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StrategyCanaryArgs', 'StrategyCanaryArgsDict']] canary: Represents Canary strategy. Cannot be defined when Rolling object is defined.
        :param pulumi.Input[Union['StrategyRollingArgs', 'StrategyRollingArgsDict']] rolling: Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StrategyState.__new__(_StrategyState)

        __props__.__dict__["canary"] = canary
        __props__.__dict__["rolling"] = rolling
        __props__.__dict__["strategy_name"] = strategy_name
        return Strategy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def canary(self) -> pulumi.Output[Optional['outputs.StrategyCanary']]:
        """
        Represents Canary strategy. Cannot be defined when Rolling object is defined.
        """
        return pulumi.get(self, "canary")

    @property
    @pulumi.getter
    def rolling(self) -> pulumi.Output[Optional['outputs.StrategyRolling']]:
        """
        Represents Rolling Update strategy. Cannot be defined when Canary object is defined.
        """
        return pulumi.get(self, "rolling")

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "strategy_name")

