# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 feature_flags: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] account: Spotinst Account ID
        :param pulumi.Input[bool] enabled: Enable or disable the Spotinst provider
        :param pulumi.Input[str] feature_flags: Spotinst SDK Feature Flags
        :param pulumi.Input[str] token: Spotinst Personal API Access Token
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if feature_flags is not None:
            pulumi.set(__self__, "feature_flags", feature_flags)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        Spotinst Account ID
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable the Spotinst provider
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="featureFlags")
    def feature_flags(self) -> Optional[pulumi.Input[str]]:
        """
        Spotinst SDK Feature Flags
        """
        return pulumi.get(self, "feature_flags")

    @feature_flags.setter
    def feature_flags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_flags", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Spotinst Personal API Access Token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 feature_flags: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the spotinst package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: Spotinst Account ID
        :param pulumi.Input[bool] enabled: Enable or disable the Spotinst provider
        :param pulumi.Input[str] feature_flags: Spotinst SDK Feature Flags
        :param pulumi.Input[str] token: Spotinst Personal API Access Token
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the spotinst package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 feature_flags: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["account"] = account
            __props__.__dict__["enabled"] = pulumi.Output.from_input(enabled).apply(pulumi.runtime.to_json) if enabled is not None else None
            __props__.__dict__["feature_flags"] = feature_flags
            __props__.__dict__["token"] = token
        super(Provider, __self__).__init__(
            'spotinst',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Output[Optional[str]]:
        """
        Spotinst Account ID
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="featureFlags")
    def feature_flags(self) -> pulumi.Output[Optional[str]]:
        """
        Spotinst SDK Feature Flags
        """
        return pulumi.get(self, "feature_flags")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        Spotinst Personal API Access Token
        """
        return pulumi.get(self, "token")

