SELECT
  s_store_name,
  SUM(ss_net_profit)
FROM store_sales
JOIN date_dim ON ss_sold_date_sk = d_date_sk
JOIN store ON ss_store_sk = s_store_sk
JOIN (
  SELECT
    ca_zip
  FROM (
    SELECT
      SUBSTR(ca_zip, 1, 5) AS ca_zip
    FROM customer_address
    WHERE
      SUBSTR(ca_zip, 1, 5) IN ('58087', '52097', '23033', '46494', '27421', '56154', '72453', '14580', '66165', '59090', '51865', '42527', '43609', '33798', '50608', '59446', '41647', '71298', '41594', '41769', '47020', '11375', '78837', '24194', '80442', '96449', '17307', '90047', '35370', '47858', '18721', '24516', '56046', '60261', '54629', '64437', '50645', '90224', '22199', '49507', '29884', '39195', '42750', '80575', '42979', '23981', '93511', '64161', '86373', '54815', '52174', '61155', '65526', '63356', '97492', '83608', '10655', '23405', '13212', '98713', '60603', '94643', '64019', '55952', '52716', '41532', '67410', '20010', '25995', '59192', '30016', '73601', '39676', '86898', '44901', '34800', '26839', '38526', '81257', '87759', '32863', '65443', '47649', '20841', '28524', '71013', '22300', '59034', '11492', '53512', '50389', '90274', '20702', '54678', '72280', '39086', '71924', '26046', '31991', '36877', '93675', '14268', '60905', '97986', '65993', '43743', '57134', '30547', '13170', '33768', '19449', '36958', '34070', '11524', '51677', '43189', '60208', '99533', '24131', '38259', '54309', '27931', '77346', '65804', '49212', '40286', '25404', '47564', '31738', '15852', '88372', '67610', '45578', '72244', '80443', '58583', '79057', '92464', '45450', '70204', '16299', '20174', '18846', '54660', '58276', '67978', '68429', '83337', '66150', '14592', '53318', '80478', '39976', '96610', '36978', '12068', '54561', '28543', '76166', '17749', '59509', '85078', '84947', '66016', '53347', '63697', '54468', '25401', '37415', '86796', '18698', '42338', '10515', '76996', '25513', '22561', '28697', '54557', '61687', '75862', '57590', '53570', '34850', '31096', '55028', '19874', '93548', '34949', '90391', '65484', '28826', '14253', '16034', '43385', '55875', '52351', '29154', '56219', '44205', '12210', '30537', '11071', '53391', '35367', '37532', '23533', '53876', '57837', '85116', '43201', '23058', '73313', '13286', '21309', '25626', '51845', '63388', '33313', '58262', '28798', '48865', '54453', '26953', '13010', '56590', '87320', '17608', '98621', '96822', '24441', '17156', '41179', '37964', '92050', '33709', '36975', '86260', '44459', '98090', '40520', '54010', '42084', '39495', '53306', '29101', '92072', '70911', '95838', '19852', '75390', '75959', '53273', '62848', '59378', '45239', '77350', '27576', '80480', '18354', '37234', '36349', '46252', '70060', '11114', '61222', '18898', '40940', '87201', '43569', '31064', '19502', '68381', '52410', '77806', '44076', '68239', '75948', '39443', '57007', '86481', '93493', '53043', '56564', '10519', '57343', '65520', '18114', '46516', '23294', '39931', '11825', '62863', '20343', '73137', '45948', '31249', '34845', '39827', '98195', '93122', '26367', '11905', '44366', '15360', '23845', '57728', '92077', '27427', '31739', '31403', '23758', '40411', '29264', '15304', '40474', '75267', '18694', '99742', '23355', '14452', '74326', '75943', '66304', '82947', '93461', '18040', '20252', '48343', '28024', '78603', '98210', '45403', '72926', '33247', '48574', '16635', '21097', '36569', '37826', '84733', '48896', '70066', '48108', '31643', '31547', '93161', '13348', '78228', '36480', '31327', '16543', '64824', '82118', '33557', '55376', '79216', '72364', '48512', '60046', '24847', '28698', '49723', '25341', '31950', '40076', '27805', '18529', '68946', '20718', '74219', '31219', '18875', '10539', '34804', '15337', '57786', '24110', '16747', '78877', '67451', '40799', '91115', '43459', '38288', '48821', '69121', '45722', '13823', '90355', '72186', '22224', '24195', '77278', '45555', '46449', '36672', '22688', '50197', '36548', '34019')
    INTERSECT
    SELECT
      ca_zip
    FROM (
      SELECT
        SUBSTR(ca_zip, 1, 5) AS ca_zip,
        COUNT(*) AS cnt
      FROM customer_address
      JOIN customer ON ca_address_sk = c_current_addr_sk
      WHERE c_preferred_cust_flag = 'Y'
      GROUP BY ca_zip
      HAVING COUNT(*) > 10
    ) AS A1
  ) AS A2
) AS V1 ON SUBSTR(s_zip, 1, 2) = SUBSTR(V1.ca_zip, 1, 2)
WHERE d_qoy = 1
  AND d_year = 2002
GROUP BY s_store_name
ORDER BY s_store_name
LIMIT 100