# coding: utf-8

"""
    Paasta API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from paasta_tools.paastaapi.api_client import ApiClient, Endpoint
from paasta_tools.paastaapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from paasta_tools.paastaapi.model.inline_response403 import InlineResponse403
from paasta_tools.paastaapi.model.remote_run_outcome import RemoteRunOutcome
from paasta_tools.paastaapi.model.remote_run_start import RemoteRunStart
from paasta_tools.paastaapi.model.remote_run_stop import RemoteRunStop
from paasta_tools.paastaapi.model.remote_run_token import RemoteRunToken


class RemoteRunApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __remote_run_poll(
            self,
            service,
            instance,
            job_name,
            user,
            **kwargs
        ):
            """Check if remote run pod is ready  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remote_run_poll(service, instance, job_name, user, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                job_name (str): Job name
                user (str): User requesting job

            Keyword Args:
                toolbox (bool): Whether this is a toolbox job. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RemoteRunOutcome
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['job_name'] = \
                job_name
            kwargs['user'] = \
                user
            return self.call_with_http_info(**kwargs)

        self.remote_run_poll = Endpoint(
            settings={
                'response_type': (RemoteRunOutcome,),
                'auth': [],
                'endpoint_path': '/remote_run/{service}/{instance}/poll',
                'operation_id': 'remote_run_poll',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'job_name',
                    'user',
                    'toolbox',
                ],
                'required': [
                    'service',
                    'instance',
                    'job_name',
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'job_name':
                        (str,),
                    'user':
                        (str,),
                    'toolbox':
                        (bool,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'job_name': 'job_name',
                    'user': 'user',
                    'toolbox': 'toolbox',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'job_name': 'query',
                    'user': 'query',
                    'toolbox': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remote_run_poll
        )

        def __remote_run_start(
            self,
            service,
            instance,
            remote_run_start,
            **kwargs
        ):
            """Launch a remote-run pod  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remote_run_start(service, instance, remote_run_start, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                remote_run_start (RemoteRunStart):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RemoteRunOutcome
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['remote_run_start'] = \
                remote_run_start
            return self.call_with_http_info(**kwargs)

        self.remote_run_start = Endpoint(
            settings={
                'response_type': (RemoteRunOutcome,),
                'auth': [],
                'endpoint_path': '/remote_run/{service}/{instance}/start',
                'operation_id': 'remote_run_start',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'remote_run_start',
                ],
                'required': [
                    'service',
                    'instance',
                    'remote_run_start',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'remote_run_start':
                        (RemoteRunStart,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'remote_run_start': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remote_run_start
        )

        def __remote_run_stop(
            self,
            service,
            instance,
            remote_run_stop,
            **kwargs
        ):
            """Stop a remote-run pod  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remote_run_stop(service, instance, remote_run_stop, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                remote_run_stop (RemoteRunStop):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RemoteRunOutcome
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['remote_run_stop'] = \
                remote_run_stop
            return self.call_with_http_info(**kwargs)

        self.remote_run_stop = Endpoint(
            settings={
                'response_type': (RemoteRunOutcome,),
                'auth': [],
                'endpoint_path': '/remote_run/{service}/{instance}/stop',
                'operation_id': 'remote_run_stop',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'remote_run_stop',
                ],
                'required': [
                    'service',
                    'instance',
                    'remote_run_stop',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'remote_run_stop':
                        (RemoteRunStop,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'remote_run_stop': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remote_run_stop
        )

        def __remote_run_token(
            self,
            service,
            instance,
            user,
            **kwargs
        ):
            """Get a short lived token for exec into remote-run pod  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remote_run_token(service, instance, user, async_req=True)
            >>> result = thread.get()

            Args:
                service (str): Service name
                instance (str): Instance name
                user (str): User name

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RemoteRunToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service'] = \
                service
            kwargs['instance'] = \
                instance
            kwargs['user'] = \
                user
            return self.call_with_http_info(**kwargs)

        self.remote_run_token = Endpoint(
            settings={
                'response_type': (RemoteRunToken,),
                'auth': [],
                'endpoint_path': '/remote_run/{service}/{instance}/token',
                'operation_id': 'remote_run_token',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service',
                    'instance',
                    'user',
                ],
                'required': [
                    'service',
                    'instance',
                    'user',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service':
                        (str,),
                    'instance':
                        (str,),
                    'user':
                        (str,),
                },
                'attribute_map': {
                    'service': 'service',
                    'instance': 'instance',
                    'user': 'user',
                },
                'location_map': {
                    'service': 'path',
                    'instance': 'path',
                    'user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__remote_run_token
        )
