cocoon_icon_64 = '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'





spinner_value = "Running..."

END = '\033[0m'
BOLD = '\033[1m'
DIM = '\033[2m'
ITALIC = '\033[3m'
UNDERLINE = '\033[4m'
BLINK = '\033[5m'

BLACK = '\033[30m'
RED = '\033[31m'
GREEN = '\033[32m'
YELLOW = '\033[33m'
BLUE = '\033[34m'
MAGENTA = '\033[35m'
CYAN = '\033[36m'
WHITE = '\033[37m'

BG_BLACK = '\033[40m'
BG_RED = '\033[41m'
BG_GREEN = '\033[42m'
BG_YELLOW = '\033[43m'
BG_BLUE = '\033[44m'
BG_MAGENTA = '\033[45m'
BG_CYAN = '\033[46m'
BG_WHITE = '\033[47m'


target_concepts = {
    "PATIENT": {
        "Identity": {
            "Gender": ["gender_concept_id","gender_source_value"],
            "Race": ["race_concept_id","race_source_value"],
            "Ethnicity": ["ethnicity_concept_id","ethnicity_source_value"]
        },
        "Birth Details": {
            "Date of Birth": ["year_of_birth","month_of_birth","day_of_birth","birth_datetime"]
        },
        "Residence": {
            "Address": ["address","city","state","zip","county","location_source_value"],
            "Coordinates": ["latitude","longitude"]
        },
        "Identifier": ["person_id"]
    },
    "CONDITION_OCCURRENCE": {
        "Condition Information": {
            "Basic Condition Details": ["condition_occurrence_id", "condition_source_description_value", "condition_source_concept_id"],
            "Condition Duration": ["condition_start_date", "condition_start_datetime", "condition_end_date", "condition_end_datetime"],
            "Condition Status": ["stop_reason", "condition_status_source_value"]
        },
        "Patient Information": ["person_id"],
        "Provider Information": ["provider_id"],
        "Visit Information": {
            "Visit Identification": ["visit_occurrence_id", "visit_detail_id"],
            "Visit Context": ["condition_type_source"]
        }
    }

}

table_description = {
    "PATIENT": "The Patients table focuses on demographic and general information about individual patients. Key attributes include **person_id**, a unique identifier for each patient, and **gender_concept_id**, which records the patient's gender. The **year_of_birth**, **month_of_birth**, and **day_of_birth** attributes collectively provide the patient's date of birth. Other critical attributes are **race_concept_id** and **ethnicity_concept_id**, capturing the patient's race and ethnicity respectively. The **location_id** links to the patient's geographical information, while **provider_id** and **care_site_id** associate the patient with healthcare providers and care sites. Additionally, the **person_source_value**, **gender_source_value**, **gender_source_concept_id**, **race_source_value**, **race_source_concept_id**, **ethnicity_source_value**, and **ethnicity_source_concept_id** provide source-specific details for each corresponding attribute.",
    "VISIT_OCCURRENCE": "The VISIT_OCCURRENCE table documents detailed information about patient visits to healthcare facilities. It includes attributes such as **visit_occurrence_id** as a unique identifier for each visit, **person_id** linking to the patient's record, and **visit_concept_id** that classifies the type of visit (e.g., outpatient, inpatient). The table also tracks the **visit_start_date** and **visit_end_date** to specify the duration of the visit. Attributes like **visit_type_concept_id** offer insights into the context of the data collection, while **provider_id** links to the healthcare provider involved. Additionally, **care_site_id** associates the visit with a specific location, and **visit_source_value** and **visit_source_concept_id** capture information from original data sources. The table can also include **admitting_source_concept_id** and **discharge_to_concept_id** to detail patient transitions into and out of the care setting.", 
    "CONDITION_OCCURRENCE": "The CONDITION_OCCURRENCE table primarily focuses on recording patient conditions, typically diagnosed by a healthcare provider. It contains key attributes such as **person_id**, which uniquely identifies a patient, and **condition_concept_id**, referencing the specific condition diagnosed. The attribute **condition_start_date** indicates when the condition was first observed, while **condition_end_date** reflects when it was resolved or ceased. Additionally, **condition_type_concept_id** describes the context or source of the diagnosis, such as a hospital visit. The **stop_reason** attribute provides insight into why a condition was considered resolved or ended. Another crucial attribute, **provider_id**, identifies the healthcare provider responsible for the diagnosis, and **visit_occurrence_id** links the condition to a specific patient visit. The table also includes **condition_source_value**, a textual representation of the condition from the original source data, and **condition_source_concept_id** for mapping to a standardized concept. Lastly, **condition_status_concept_id** gives further details about the status of the condition, like whether it's an active diagnosis or a historical record.", 
    "DRUG_EXPOSURE": "The DRUG_EXPOSURE table captures information about a patient's exposure to a drug. The primary attribute, **DRUG_EXPOSURE_ID**, uniquely identifies each drug exposure event. **PERSON_ID** links to the individual patient, while **DRUG_CONCEPT_ID** identifies the specific drug. **DRUG_EXPOSURE_START_DATE** and **DRUG_EXPOSURE_END_DATE** denote the period of drug exposure. Dosage and frequency are detailed through **DOSE_UNIT_CONCEPT_ID** and **QUANTITY**. The table also includes **ROUTE_CONCEPT_ID** to specify the drug administration route, and **PROVIDER_ID** to identify the healthcare provider. **VISIT_OCCURRENCE_ID** links the drug exposure to a specific patient visit, and **DRUG_TYPE_CONCEPT_ID** categorizes the context of drug exposure, like prescription or inpatient administration.", 
    "PROCEDURE_OCCURRENCE": "The PROCEDURE_OCCURRENCE table records details of clinical procedures performed on patients. At its core, this table includes the **procedure_concept_id**, which identifies the specific type of procedure carried out. The **person_id** attribute links the procedure to a specific patient. The **procedure_date** and **procedure_datetime** attributes specify when the procedure was performed. The **procedure_type_concept_id** defines the context or source of data entry. Other important attributes include **quantity**, representing the number of times the procedure was performed, and **provider_id**, identifying the healthcare provider who performed the procedure. The **visit_occurrence_id** links the procedure to the patient visit during which it was performed, and **modifier_concept_id** provides additional details or modifications to the procedure. Finally, **procedure_source_value** and **procedure_source_concept_id** offer source-specific codes for the procedure, and **qualifier_concept_id** gives further context or qualifiers related to the procedure.", 
    "DEVICE": "The DEVICE table focuses on medical device usage in patient care. Key attributes include **device_id**, a unique identifier for each device record, and **person_id**, linking the device to an individual. **device_concept_id** represents the specific type of device. **device_exposure_start_date** and **device_exposure_end_date** define the usage period. **device_type_concept_id** describes the context of the device usage. **provider_id** identifies the healthcare provider involved, while **visit_occurrence_id** connects the device usage to a specific visit. Additional attributes like **device_source_value** and **quantity** provide extra details about the device and its usage.", 
    "MEASUREMENT": "The MEASUREMENT table captures quantitative data and observations about a patient's health status. It includes key attributes like **measurement_id**, a unique identifier for each measurement, and **person_id**, linking the measurement to a specific patient. The **measurement_concept_id** identifies what was measured, such as blood pressure or glucose level. The **measurement_date** and **measurement_datetime** record when the measurement was taken. The **measurement_type_concept_id** indicates the nature of the measurement, like lab result or vital sign. The **operator_concept_id** represents how the measurement was taken, for example, by a device or a clinician. The **value_as_number**, **value_as_concept_id**, and **unit_concept_id** provide the result and unit of the measurement. **range_low** and **range_high** offer reference ranges for the measurement value. **provider_id** and **visit_occurrence_id** link the measurement to the provider and the visit during which it was taken. Additional details such as **measurement_source_value**, **measurement_source_concept_id**, and **unit_source_value** capture the original source information. Lastly, **value_source_value** records the measurement result as it was originally represented.", 
    "OBSERVATION": "The OBSERVATION captures patient observations or measurements that are not diagnoses, procedures, or drug prescriptions. This table includes **person_id** to identify the patient, **observation_id** as a unique identifier for the observation, and **observation_concept_id** to specify the type of observation. The **observation_date** and **observation_datetime** record when the observation was made. **observation_type_concept_id** classifies the observation source, such as from a survey or a lab result. **value_as_number**, **value_as_string**, **value_as_concept_id**, and **unit_concept_id** describe the observation result in various formats. **qualifier_concept_id** and **associated_provider_id** give additional context to the observation, while **visit_occurrence_id** and **visit_detail_id** link the observation to specific visits. **obs_event_field_concept_id** captures the field from the source data where the observation originated, and **observation_source_value**, **observation_source_concept_id**, **unit_source_value**, and **qualifier_source_value** provide source-specific information. **observation_event_id**, **obs_event_field_concept_id**, and **value_as_datetime** offer further details on the observation event.", 
    "DEATH": "The DEATH table is specifically designed to capture information about patient deaths. It contains several key attributes that provide details about the circumstances and documentation of a patient's death. The primary attribute is **person_id**, which uniquely identifies the deceased individual within the database. Another crucial attribute is **death_date**, specifying the exact date of death. The **death_datetime** attribute can offer more precise timing if available. The **death_type_concept_id** is used to indicate the source or method of death determination, like a death certificate or autopsy report. The **cause_concept_id** and **cause_source_value** attributes are used to record the cause of death, either as a standard concept or as a raw value from the data source, respectively. Additionally, the **cause_source_concept_id** represents a standardized concept that corresponds to the source value for the cause of death.", 
    "SPECIMEN": "The SPECIMEN table stores detailed information about biological specimens collected from patients for diagnostic, treatment, or research purposes. This table includes several attributes that provide comprehensive data about each specimen. Key attributes include **specimen_id**, which is a unique identifier for each specimen, and **person_id**, linking the specimen to a specific individual in the database. The **specimen_concept_id** and **specimen_type_concept_id** describe the type of specimen and the method of its collection, respectively. **specimen_date** and **specimen_datetime** capture the date and time of specimen collection. **quantity** reflects the amount of specimen collected, and **unit_concept_id** indicates the unit of measurement. The **anatomic_site_concept_id** specifies the body site from where the specimen was taken, and **disease_status_concept_id** provides information about the disease status associated with the specimen. **specimen_source_id** and **visit_occurrence_id** are used to link the specimen to other relevant data in the database, such as the visit during which the specimen was collected. The **specimen_source_value**, **anatomic_site_source_value**, and **disease_status_source_value** attributes store the original values from the source data for mapping purposes.", 
    "COST": "The COST table stores financial information related to healthcare services provided to patients. This table captures various cost-related details associated with healthcare encounters, procedures, and medications. Key attributes include **cost_event_id** and **cost_domain_id**, which identify the event and its domain (like drug or procedure) associated with the cost. The **currency_concept_id** specifies the currency of the cost. There's a focus on the specific nature of costs with attributes like **paid_copay**, **paid_coinsurance**, **paid_toward_deductible**, and **paid_by_payer**, detailing different payment components. The **amount_allowed** and **revenue_code_concept_id** provide information on allowable amounts and revenue codes.", 
    "LOCATION": "The LOCATION table stores information about physical locations relevant to healthcare data. This table typically includes attributes such as **location_id**, which serves as a unique identifier for each location. It also contains **address_1** and **address_2** for detailed street addresses, **city** and **state** for regional identification, and **zip** for postal codes. Furthermore, the table includes **county**, **location_source_value**, and **country** to provide a comprehensive geographic context.", 
    "CARE_SITE": "The CARE_SITE table represents information related to healthcare facilities where patient care is provided. It includes the **care_site_id**, a unique identifier for each care site. The **care_site_name** provides the name of the care site, and the **place_of_service_concept_id** links to a standardized concept identifying the type of care site (e.g., hospital, clinic). The **location_id** associates the care site with a physical location, and the **care_site_source_value** captures the original source data for the care site as it appears in the source system. Additionally, the **place_of_service_source_value** is the source code used in the source data to identify the type of care site.", 
    "PROVIDER": "The PROVIDER tablecaptures detailed information about healthcare providers. It primarily focuses on the background and characteristics of individual providers. Key attributes include **provider_id**, serving as a unique identifier for each provider. The table also contains **provider_name**, which records the name of the provider. To classify the type of provider, there's **provider_type**, while **specialty_concept_id** links to their medical specialty. The **care_site_id** associates providers with their place of practice. Additionally, attributes like **gender_concept_id**, **year_of_birth**, and **provider_source_value** offer demographic and source-specific details about the providers.", 
    "PAYER_PLAN_PERIOD": "The PAYER_PLAN_PERIOD table stores information about the periods of time a person is covered by a particular payer or plan. It captures details about the insurance or payer coverage for an individual. The table includes attributes such as **PAYER_PLAN_PERIOD_ID**, which is a unique identifier for each record. **PERSON_ID** links the record to a specific individual. The coverage period is defined by **PAYER_PLAN_PERIOD_START_DATE** and **PAYER_PLAN_PERIOD_END_DATE**, indicating the start and end of the coverage period. **PAYER_SOURCE_VALUE** and **PLAN_SOURCE_VALUE** provide information about the payer and plan from the source data. There are also attributes for standard concepts: **PAYER_CONCEPT_ID** and **PLAN_CONCEPT_ID**, along with their associated source values and source concept IDs (**PAYER_SOURCE_CONCEPT_ID** and **PLAN_SOURCE_CONCEPT_ID**). Lastly, **FAMILY_SOURCE_VALUE** may contain additional information about the family or group plan, if applicable."
}


table_samples = {
    "PATIENT": 
"""	person_id	gender_concept_id	year_of_birth	month_of_birth	day_of_birth	birth_datetime	race_concept_id	ethnicity_concept_id	location_id	provider_id	care_site_id	person_source_value	gender_source_value	gender_source_concept_id	race_source_value	race_source_concept_id	ethnicity_source_value	ethnicity_source_concept_id
0	1	8507	1985	5	20	1985-05-20	8527	38003564	1	1	1	12345	M	8507	White	8527	Not Hispanic or Latino	38003564
1	2	8532	1990	8	10	1990-08-10	8516	38003563	2	2	2	67890	F	8532	Black or African American	8516	Hispanic or Latino	38003563""",
    
    "VISIT_OCCURRENCE": 
"""visit_occurrence_id	person_id	visit_concept_id	visit_start_date	visit_start_datetime	visit_end_date	visit_end_datetime	visit_type_concept_id	provider_id	care_site_id	visit_source_value	visit_source_concept_id	admitting_source_concept_id	admitting_source_value	discharge_to_concept_id	discharge_to_source_value	preceding_visit_occurrence_id
0	123456	101	9201	2023-01-10	2023-01-10 08:00:00	2023-01-12	2023-01-12 15:00:00	2001	501	601	VS123	3001	4001	AS123	5001	DS123	111
1	789012	102	9202	2023-02-15	2023-02-15 09:30:00	2023-02-16	2023-02-16 10:30:00	2002	502	602	VS456	3002	4002	AS456	5002	DS456	222""",
    
    "CONDITION_OCCURRENCE":
"""condition_occurrence_id	person_id	condition_concept_id	condition_start_date	condition_start_datetime	condition_end_date	condition_end_datetime	condition_type_concept_id	stop_reason	provider_id	visit_occurrence_id	visit_detail_id	condition_source_value	condition_source_concept_id	condition_status_concept_id	condition_status_source_value
0	1	101	201826	2021-01-10	2021-01-10 08:30:00	2021-01-20	2021-01-20 17:00:00	32019	Resolved	150	200	300	Diabetes	401	501	Active
1	2	102	31967	2021-02-15	2021-02-15 09:45:00	2021-02-25	2021-02-25 16:30:00	32020	Improved	151	201	301	Hypertension	402	502	Controlled""",
    
    "DRUG_EXPOSURE": 
"""drug_exposure_id	person_id	drug_concept_id	drug_exposure_start_date	drug_exposure_end_date	verbatim_end_date	drug_type_concept_id	stop_reason	refills	quantity	days_supply	sig	route_concept_id	lot_number	provider_id	visit_occurrence_id	drug_source_value	drug_source_concept_id	route_source_value	dose_unit_source_value
0	1	1001	456789	2023-01-01	2023-01-10	2023-01-10	38000177	Completed course	0	10	10	Take 1 tablet daily	0	LOT1001	12345	111	DrugA	0	Oral	mg
1	2	1002	987654	2023-02-15	2023-03-01	2023-03-01	38000177	Adverse reaction	1	30	15	Take 2 tablets twice daily	0	LOT1002	67890	222	DrugB	0	Oral	mg""",
    
    "PROCEDURE_OCCURRENCE":
"""   procedure_occurrence_id  person_id  procedure_concept_id procedure_date  \
0                        1        101               2100001     2023-01-15   
1                        2        102               2100002     2023-02-20   
    procedure_datetime  procedure_type_concept_id  modifier_concept_id  \
0  2023-01-15 10:00:00                   38000275                    0   
1  2023-02-20 14:30:00                   38000275                    0   

   quantity  provider_id  visit_occurrence_id  visit_detail_id  \
0         1          501                  701                0   
1         2          502                  702                0   

   procedure_source_concept_id procedure_source_value  qualifier_concept_id  \
0                      2100001                  PROC1                     0   
1                      2100002                  PROC2                     0   

  qualifier_source_value  procedure_cost  
0                   None           200.0  
1                   None           450.0  """,
    "DEVICE": 
"""device_id	person_id	device_exposure_start_date	device_exposure_start_datetime	device_exposure_end_date	device_exposure_end_datetime	device_concept_id	device_type_concept_id	unique_device_id	quantity	provider_id	visit_occurrence_id	device_source_value	device_source_concept_id
0	1001	2001	2023-01-15	2023-01-15 08:00:00	2023-01-20	2023-01-20 18:00:00	3001	4001	UD1001	1	5001	6001	DeviceA	7001
1	1002	2002	2023-02-20	2023-02-20 09:30:00	2023-02-25	2023-02-25 16:30:00	3002	4002	UD1002	2	5002	6002	DeviceB	7002""",
    
    "MEASUREMENT": """measurement_id	person_id	measurement_concept_id	measurement_date	measurement_datetime	measurement_type_concept_id	operator_concept_id	value_as_number	value_as_concept_id	unit_concept_id	range_low	range_high	provider_id	visit_occurrence_id	measurement_source_value	measurement_source_concept_id	unit_source_value	value_source_value
1001	2001	3001	2023-01-15	2023-01-15 08:00:00	4001	5001	5.6	6001	7001	4.5	8.0	8001	9001	BP_SYS	10001	mmHg	120
1002	2002	3002	2023-01-16	2023-01-16 09:30:00	4002	5002	7.8	6002	7002	6.0	9.5	8002	9002	BP_DIA	10002	mmHg	80""",
    
    "OBSERVATION": 
"""observation_id  person_id  observation_concept_id observation_date  \
0            1001        123                    3001       2023-01-01   
1            1002        456                    3002       2023-01-02   

  observation_datetime  observation_type_concept_id  value_as_number  \
0  2023-01-01 08:00:00                         2001             98.6   
1  2023-01-02 09:30:00                         2002             99.5   

  value_as_string  value_as_concept_id  qualifier_concept_id  unit_concept_id  \
0          Normal                 4001                  5001             6001   
1        Elevated                 4002                  5002             6002   

   provider_id  visit_occurrence_id observation_source_value  \
0         7001                 8001           Blood Pressure   
1         7002                 8002               Heart Rate   

   observation_source_concept_id unit_source_value qualifier_source_value  
0                           9001              mmHg                Resting  
1                           9002         beats/min         After Exercise  """,
    
    "DEATH": 
""" person_id  death_date      death_datetime  death_type_concept_id  cause_concept_id cause_source_value  cause_source_concept_id
    123456  2023-05-15  2023-05-15 14:30:00               38003565             50115              I21.9                  4323456
    789012  2023-06-20  2023-06-20 08:45:00               38003566            433146              C50.9                  7654321""",
    
    "SPECIMEN": 
"""specimen_id	person_id	specimen_concept_id	specimen_type_concept_id	specimen_date	specimen_datetime	quantity	unit_concept_id	anatomic_site_concept_id	disease_status_concept_id	specimen_source_id	visit_occurrence_id	visit_detail_id	specimen_source_value	unit_source_value	anatomic_site_source_value	disease_status_source_value
101	2001	3001	4001	2023-01-15	2023-01-15 10:00:00	1.5	5001	6001	7001	A123	8001	9001	Blood Sample	ml	Arm	Healthy
102	2002	3002	4002	2023-01-20	2023-01-20 11:30:00	2.0	5002	6002	7002	B456	8002	9002	Tissue Sample	g	Liver	Diseased""",
    
    "COST": 
"""	cost_id	person_id	cost_event_id	cost_domain_id	currency_concept_id	total_charge	total_paid	payer_plan_period_id	amount_allowed	paid_by_payer	paid_by_patient	paid_patient_copay	paid_patient_coinsurance	paid_patient_deductible	paid_by_primary	paid_ingredient_cost	paid_dispensing_fee
0	1001	2001	3001	Drug	840	500.0	450.0	4001	450.0	400.0	50.0	25.0	15.0	10.0	400.0	300.0	20.0
1	1002	2002	3002	Procedure	840	1500.0	1400.0	4002	1400.0	1300.0	100.0	50.0	40.0	10.0	1300.0	1000.0	50.0""",
    
    "LOCATION": 
"""location_id	address_1	address_2	city	state	zip	county	location_source_value	latitude	longitude
0	1	123 Main St	Suite 100	Springfield	NY	12345	Hampden	L123	40.7128	-74.0060
1	2	456 Elm St	Apt 202	Riverdale	CA	67890	Archie	L456	34.0522	-118.2437""",
    
    "CARE_SITE": 
""" care_site_id   care_site_name  place_of_service_concept_id  location_id care_site_source_value place_of_service_source_value
1   City Hospital                        12345          101                  CS001                      Hospital
2    Rural Clinic                        67890          102                  CS002                        Clinic""",
    
    "PROVIDER": 
"""provider_id	provider_name	npi	dea	specialty_concept_id	care_site_id	year_of_birth	gender_concept_id	provider_source_value	specialty_source_value	specialty_source_concept_id	gender_source_value	gender_source_concept_id
0	101	Dr. Jane Smith	1234567890	AB1234567	111	10	1970	8507	P101	Cardiology	1001	F	1003
1	102	Dr. John Doe	0987654321	CD7654321	222	20	1980	8507	P102	Neurology	1002	M	1004""",
    
    "PAYER_PLAN_PERIOD": 
"""payer_plan_period_id	person_id	payer_plan_period_start_date	payer_plan_period_end_date	payer_concept_id	plan_concept_id	sponsor_concept_id	family_plan_concept_id	stop_reason	payer_source_value	payer_source_concept_id	plan_source_value	plan_source_concept_id	sponsor_source_value	sponsor_source_concept_id	family_plan_source_value	family_plan_source_concept_id
1001	123	2023-01-01	2023-12-31	2001	3001	4001	5001	End of contract	PayerA	6001	PlanA	7001	SponsorA	8001	FamilyPlanA	9001
1002	456	2023-06-01	2023-12-31	2002	3002	4002	5002	Change of employment	PayerB	6002	PlanB	7002	SponsorB	8002	FamilyPlanB	9002""",
}

attributes_description = {
    "PATIENT" :{
    "person_id": "the original id from the source data provided, otherwise it can be an autogenerated number. ",
    "year_of_birth": "as an integer",
    "month_of_birth": "as an integer",
    "day_of_birth": "as an integer",
    "birth_datetime": "If birth_datetime is not provided in the source, use the following logic to infer the date: If day_of_birth is null and month_of_birth is not null then use the first of the month in that year. If month_of_birth is null or if day_of_birth AND month_of_birth are both null and the person has records during their year of birth then use the date of the earliest record, otherwise use the 15th of June of that year. If time of birth is not given use midnight (00:00:0000).",
    "gender_concept_id": "{ 'FEMALE': 8532, 'MALE': 8507 }",
    "gender_source_value": "the original value in the source table",
    "person_source_value": "any identifier from the source data that identifies the person.",
    "race_concept_id": "{ 'American Indian or Alaska Native': 8657, 'Asian': 8515, 'Black': 8516, 'Native Hawaiian or Other Pacific Islander': 8557, 'White': 8527 }",
    "race_source_value": "the original value in the source table",
    "ethnicity_concept_id": "{ 'Hispanic or Latino': 38003564, 'Not Hispanic or Latino': 38003563 }",
    "ethnicity_source_value": "the original value in the source table",
    },
    "CONDITION_OCCURRENCE": {
    "condition_occurrence_id": "the original id column from the source data provided, otherwise it can be an autogenerated number. ",
    "person_id": "The PERSON_ID of the PERSON for whom the condition is recorded.",
    "condition_start_date": "the start date of the condition",
    "condition_start_datetime": "If a source does not specify datetime the convention is to set the time to midnight (00:00:0000)",
    "condition_end_date": "The end date of the condition",
    "condition_end_datetime": " the end date of the condition",
    "stop_reason": "The Stop Reason indicates why a Condition is no longer valid with respect to the purpose within the source data.",
    "visit_occurrence_id": "The visit during which the condition occurred.",
    "condition_source_description_value": "Source data representing the condition that occurred.",
    "condition_type_source": "the provenance of the Condition record, as in whether the condition was from an EHR system, insurance claim, registry, or other sources.",
    "condition_status_source_value": "the source data indicating when and how a diagnosis was given to a patients",
    },
    "DEATH" :{
    "death_date": "Date of death, use January 1st of the year if only year is known. E.g., 2020-01-01",
    "death_datetime": "Exact date and time of death, default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "cause_source_value": "Original cause of death from source data. E.g., 'Heart Attack'",
    "death_record_source": "Source of death record (e.g., death certificate, hospital record). E.g., 'Death Certificate'",
    },
    "DRUG_EXPOSURE" :{
    "drug_exposure_id": "Unique identifier for each drug exposure record. E.g., 101",
    "drug_exposure_start_date": "Start date of the drug exposure. E.g., 2022-03-15",
    "drug_exposure_start_datetime": "Exact start date and time of the drug exposure. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "drug_exposure_end_date": "End date of the drug exposure. E.g., 2022-04-14",
    "drug_exposure_end_datetime": "Exact end date and time of the drug exposure. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "verbatim_end_date": "Original end date as recorded in the source data. E.g., 2022-04-14",
    "stop_reason": "Reason the drug exposure was stopped. E.g., 'Completed treatment'",
    "refills": "Number of refills prescribed. E.g., 2",
    "quantity": "Quantity of the drug prescribed. E.g., 30 (tablets)",
    "days_supply": "Number of days the drug supply is expected to last. E.g., 30",
    "sig": "Directions for use as specified by the prescriber. E.g., 'Take 1 tablet daily'",
    "lot_number": "Lot number of the drug. E.g., 'LN123456'",
    "drug_source_value": "Original value of the drug as in the source data. E.g., 'Aspirin'",
    "route_source_value": "Original value of the route of administration in the source data. E.g., 'Oral'",
    "dose_unit_source_value": "Unit of the dose as in the source data. E.g., 'mg'",
    },
    "PROCEDURE_OCCURRENCE" :{
    "procedure_occurrence_id": "Unique identifier for the procedure record. E.g., 456789",
    "procedure_date": "Date when the procedure was performed. E.g., 2023-05-20",
    "procedure_datetime": "Exact date and time of the procedure. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "procedure_type_concept_id": "Concept ID indicating the type of procedure (e.g., surgical, diagnostic). E.g., 44818701 (for 'Surgical procedure')",
    "modifier_concept_id": "Concept ID for any modifiers related to the procedure. E.g., 2000000 ('Laparoscopic')",
    "quantity": "Number of times the procedure was performed. E.g., 1",
    "procedure_source_value": "Original value of the procedure as in the source data. E.g., 'Appendectomy'",
    "qualifier_source_value": "Additional details about the procedure from the source data. E.g., 'Laparoscopic'",
    },
    "DEVICE" :{
    "device_exposure_id": "Unique identifier for each device exposure record. E.g., 999888",
    "device_exposure_start_date": "Start date of the device exposure. E.g., 2023-01-15",
    "device_exposure_start_datetime": "Exact start date and time of the device exposure. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "device_exposure_end_date": "End date of the device exposure. E.g., 2023-06-15",
    "device_exposure_end_datetime": "Exact end date and time of the device exposure. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "quantity": "Number of devices used or exposed to. E.g., 1",
    "device_source_value": "Original value of the device as in the source data. E.g., 'Pacemaker'",
    },
    "MEASUREMENT" :{
    "measurement_id": "Unique identifier for the measurement record. E.g., 123456",
    "measurement_date": "Date when the measurement was taken. E.g., 2023-08-10",
    "measurement_datetime": "Exact date and time the measurement was taken. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "value_as_number": "Numerical value of the measurement. E.g., 120 (for systolic blood pressure)",
    "range_low": "Lower limit of the normal range for the measurement. E.g., 90 (for systolic blood pressure)",
    "range_high": "Upper limit of the normal range for the measurement. E.g., 120 (for systolic blood pressure)",
    "measurement_source_value": "Original value of the measurement as in the source data. E.g., 'Blood Pressure'",
    "unit_source_value": "Original unit of the measurement as in the source data. E.g., 'mmHg'",
    },
    "OBSERVATION" :{
    "observation_id": "Unique identifier for each observation record. E.g., 789123",
    "observation_date": "Date of the observation. E.g., 2023-02-15",
    "observation_datetime": "Exact date and time of the observation. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "value_as_number": "Numerical value of the observation if applicable. E.g., 10 (for 'Cigarettes per day')",
    "value_as_string": "Textual value of the observation if applicable. E.g., 'Non-smoker'",
    "observation_source_value": "Original value of the observation as in the source data. E.g., 'Smoking status'",
    "unit_source_value": "Original unit of the observation as in the source data. E.g., 'Cigarettes per day'",
    },
    "SPECIMEN" :{
    "specimen_id": "Unique identifier for each specimen record. E.g., 123456",
    "specimen_date": "Date when the specimen was collected. E.g., 2023-03-01",
    "specimen_datetime": "Exact date and time when the specimen was collected. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "quantity": "Quantity of the specimen collected. E.g., 10 (ml for blood)",
    "specimen_source_value": "Original value of the specimen as in the source data. E.g., 'Blood Sample'",
    "unit_source_value": "Original unit of the specimen quantity as in the source data. E.g., 'ml'",
    },
    "COST" :{
    "total_charge": "Total charge for the event. E.g., 200.00",
    "total_cost": "Total cost for the event. E.g., 150.00",
    "total_paid": "Total amount paid for the event. E.g., 150.00",
    "paid_by_payer": "Amount paid by the payer (e.g., insurance). E.g., 100.00",
    "paid_by_patient": "Amount paid by the patient. E.g., 50.00",
    "paid_patient_copay": "Patient's copay amount. E.g., 20.00",
    "paid_patient_coinsurance": "Patient's coinsurance amount. E.g., 10.00",
    "paid_patient_deductible": "Patient's deductible amount. E.g., 20.00",
    "paid_by_primary": "Amount paid by primary payer. E.g., 100.00",
    "paid_ingredient_cost": "Cost of the ingredient for a drug. E.g., 30.00",
    "paid_dispensing_fee": "Dispensing fee paid. E.g., 5.00",
    "amount_allowed": "Amount allowed by the payer. E.g., 150.00",
    "cost_source_value": "Original value of the cost as in the source data. E.g., 'Procedure cost'",
    },
    "LOCATION" :{
    "location_id": "Unique identifier for each location record. E.g., 123",
    "address_1": "First line of the address. E.g., '123 Main St'",
    "address_2": "Second line of the address (if applicable). E.g., 'Apt 4'",
    "city": "City of the location. E.g., 'New York'",
    "state": "State of the location. E.g., 'NY'",
    "zip": "Zip code of the location. E.g., '10001'",
    "county": "County of the location. E.g., 'New York County'",
    "location_source_value": "Original value of the location as in the source data. E.g., '123 Main St, Apt 4, New York, NY, 10001'",
    "latitude": "a float, must be between -90 and 90.",
    "longitude": "a float, must be between -180 and 180.",
    },
    "CARE_SITE" :{
    "care_site_id": "Unique identifier for each care site record. E.g., 456",
    "care_site_name": "Name of the care site. E.g., 'Main Street Medical Center'",
    "care_site_source_value": "Original value of the care site as in the source data. E.g., 'Main Street Medical Center, Outpatient'",
    "place_of_service_source_value": "Original place of service as in the source data. E.g., 'Outpatient Hospital'",
    },
    "PROVIDER" :{
    "provider_id": "Unique identifier for each provider record. E.g., 789",
    "provider_name": "Name of the provider. E.g., 'Dr. Jane Smith'",
    "NPI": "National Provider Identifier. E.g., '1234567890'",
    "DEA": "Drug Enforcement Administration registration number. E.g., 'AB1234567'",
    "year_of_birth": "Year of birth of the provider. E.g., 1970",
    "provider_source_value": "Original value of the provider as in the source data. E.g., 'Dr. Jane Smith'",
    "specialty_source_value": "Original specialty of the provider as in the source data. E.g., 'Cardiology'",
    "gender_source_value": "Original gender of the provider as in the source data. E.g., 'Female'",
    },
    "PAYER_PLAN_PERIOD" :{
    "payer_plan_period_id": "Unique identifier for each payer plan period record. E.g., 12345",
    "payer_plan_period_start_date": "Start date of the coverage period. E.g., 2023-01-01",
    "payer_plan_period_end_date": "End date of the coverage period. E.g., 2023-12-31",
    "stop_reason": "Reason for the end of the coverage period. E.g., 'Change of employment'",
    "payer_source_value": "Original value of the payer as in the source data. E.g., 'Medicare'",
    "plan_source_value": "Original value of the plan as in the source data. E.g., 'Medicare Part D'",
    "sponsor_source_value": "Original value of the sponsor as in the source data. E.g., 'Government'",
    },
    "VISIT_OCCURRENCE" :{
    "visit_occurrence_id": "Unique identifier for each visit record. E.g., 456789",
    "visit_start_date": "Start date of the visit. E.g., 2023-04-15",
    "visit_start_datetime": "Exact start date and time of the visit. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "visit_end_date": "End date of the visit. E.g., 2023-04-15",
    "visit_end_datetime": "Exact end date and time of the visit. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "visit_source_value": "Original value of the visit as in the source data. E.g., 'Outpatient Visit'",
    },
    "OBSERVATION_PERIOD" :{
    "observation_period_id": "Unique identifier for each observation period record. E.g., 112233",
    "observation_period_start_date": "Start date of the observation period. E.g., 2023-01-01",
    "observation_period_start_datetime": "Exact start date and time of the observation period. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    "observation_period_end_date": "End date of the observation period. E.g., 2023-12-31",
    "observation_period_end_datetime": "Exact end date and time of the observation period. Default to midnight if time unknown. E.g., 2020-01-01 00:00:00",
    }
}

cdm_tables = """1. PATIENT: Individual's healthcare identity hub, capturing demographics, contact information, and unique medical identifiers.
2. OBSERVATION_PERIOD: Clinical data timeframe, marking the start and end dates of health monitoring or treatment phases.
3. VISIT_OCCURRENCE: Healthcare interaction records, detailing visit dates, types (e.g., inpatient, outpatient), locations, and involved healthcare professionals.
4. CONDITION_OCCURRENCE: Medical condition logs, encompassing diagnosis dates, condition types, severity indicators, and observed symptoms.
5. DRUG_EXPOSURE: Medication intake documentation, including drug names, dosages, administration routes, prescribing dates, and treatment durations.
6. PROCEDURE_OCCURRENCE: Patient treatment actions, specifying procedure types, execution dates, purposes, and attending practitioners.
7. DEVICE: Medical device utilization specifics, identifying device types, application or implantation dates, functional purposes, and locations.
8. MEASUREMENT: Clinical test outcomes, containing types of tests, numerical or categorical results, units, and test dates.
9. OBSERVATION: Diverse health-related facts, sourced from examinations, questionnaires, or procedural outcomes, inclusive of non-clinical information. This is general, and please prefer to use MEASUREMENT or CONDITION_OCCURRENCE if possible.
10. DEATH: End-of-life data, specifying causes, dates, and circumstances surrounding a patient's death.
11. SPECIMEN: Biological sample records, denoting sample types, collection dates, handling processes, and preservation methods.
12. COST: Healthcare financials, enumerating costs associated with medical events like procedures, medications, visits, and equipment.
13. LOCATION: Geographical pinpointing, detailing physical addresses or coordinates of healthcare facilities or patient residences.
14. CARE_SITE: Health service points, defining types of facilities (e.g., hospitals, clinics), specializations, and operational scopes.
15. PROVIDER: Practitioner profiles, listing professionals' credentials, specialties, roles, and contact information.
16. PAYER_PLAN_PERIOD: Insurance coverage chronology, indicating enrollment spans, plan types, provided benefits, and payer information.
"""


cocoon_steps = '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'


cocoon_js_expand_block = """document.querySelectorAll('.card-item').forEach(function(card) {{
    card.addEventListener('click', function() {{
        var indent = this.nextElementSibling;
        var toggle = this.querySelector('.toggle');
        if (indent.style.display === "block") {{
            indent.style.display = "none";
            toggle.textContent = '▼';
            this.classList.remove('card-item-collapsed');
        }} else {{
            indent.style.display = "block";
            toggle.textContent = '▲';
            this.classList.add('card-item-collapsed');
        }}
    }});
}});"""

cocoon_js_toggle_block = """  const toggleSwitch = document.querySelector('.switch input[type="checkbox"]');
  const labelTextAfter = document.querySelector('.label-text:last-of-type');
  const tableContainerBefore = document.querySelector('.table-container.before');
  const tableContainerAfter = document.querySelector('.table-container.after');

  const handleToggle = () => {
    if (toggleSwitch.checked) {
      labelTextAfter.style.color = 'blue';
      tableContainerBefore.classList.remove('active');
      tableContainerAfter.classList.add('active');
    } else {
      labelTextAfter.style.color = '';
      tableContainerBefore.classList.add('active');
      tableContainerAfter.classList.remove('active');
    }
  };

  toggleSwitch.addEventListener('change', handleToggle);"""

cocoon_js_viz_block = f"""    function drawBarChart(divId, data) {{
      const margin = {{top: 10, right: 10, bottom: 25, left: 100}},
            width = 300 - margin.left - margin.right,
            height = 100 - margin.top - margin.bottom;

      const targetDiv = d3.select("#" + divId);
      targetDiv.classed("bar-chart-container", true);

      const svg = targetDiv
                    .append("svg")
                      .attr("width", width + margin.left + margin.right)
                      .attr("height", height + margin.top + margin.bottom)
                    .append("g")
                      .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

      const y = d3.scaleBand()
                  .range([0, height])
                  .domain(data.map(d => d.label))
                  .padding(0.1);

      const x = d3.scaleLinear()
                  .domain([0, d3.max(data, d => d.value)])  // Percent scale
                  .range([0, width]);

      svg.append("g")
         .call(d3.axisLeft(y));

      svg.selectAll(".bar")
         .data(data)
         .enter().append("rect")
           .attr("class", "bar")
           .attr("y", d => y(d.label))
           .attr("height", y.bandwidth())
           .attr("x", 0)
           .attr("width", d => x(d.value))
           .attr("fill", "steelblue");

      svg.append("g")
         .attr("transform", "translate(0," + height + ")")
         .call(d3.axisBottom(x).ticks(5).tickFormat(d => d + "%"));
    }}
    
    function drawHistogram(divId, data, binWidth) {{
      const margin = {{top: 10, right: 10, bottom: 20, left: 40}},
            width = 300 - margin.left - margin.right,
            height = 100 - margin.top - margin.bottom;
            
      const targetDiv = d3.select("#" + divId);
      targetDiv.classed("histogram-container", true);

      const svg = targetDiv
                    .append("svg")
                      .attr("width", width + margin.left + margin.right)
                      .attr("height", height + margin.top + margin.bottom)
                    .append("g")
                      .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

      const x = d3.scaleLinear()
                  .domain([d3.min(data, d => d.x) - binWidth, d3.max(data, d => d.x) + binWidth])
                  .range([0, width]);

      const y = d3.scaleLinear()
                  .domain([0, d3.max(data, d => d.y) * 1.1]) // Increase the y-axis limit by 10% for margin
                  .range([height, 0]);

      const xAxis = d3.axisBottom(x).ticks(5);
      const yAxis = d3.axisLeft(y).ticks(5);

      svg.append("g")
         .attr("transform", "translate(0," + height + ")")
         .call(xAxis)

      svg.append("g")
         .call(yAxis)

      svg.selectAll("rect")
         .data(data)
         .enter().append("rect")
           .attr("x", d => x(d.x - binWidth / 2))
           .attr("y", d => y(d.y))
           .attr("width", x(binWidth) - x(0))
           .attr("height", d => height - y(d.y))
           .attr("fill", "steelblue");
    }}
    
    function drawMap(divId, coordinates) {{
      const targetDiv = d3.select("#" + divId);
      targetDiv.classed("map-container", true);

      const width = 300;
      const height = 200;
      const projection = d3.geoNaturalEarth1()
          .scale(width / 1.5 / Math.PI)
          .translate([width / 2, height / 2]);
      const path = d3.geoPath().projection(projection);

      const svg = targetDiv.append("svg")
          .attr("width", width)
          .attr("height", height);

      d3.json("https://raw.githubusercontent.com/holtzy/D3-graph-gallery/master/DATA/world.geojson").then(data => {{
        // Draw the map
        svg.append("g")
          .selectAll("path")
          .data(data.features)
          .join("path")
              .attr("fill", "#ccc")
              .attr("d", path)
              .style("stroke", "#fff");

        // Plotting the points
        coordinates.forEach(coords => {{
          svg.append("circle")
            .attr("cx", projection(coords)[0])
            .attr("cy", projection(coords)[1])
            .attr("r", 2)
            .attr("fill", "red");
        }});
      }});
    }}
    
    let data = [];
    let binWidth = 5;"""
    


cocoon_html_toggle_block = """<div class="switch-container">
<span class="label-text">Before</span>
<label class="switch">
    <input type="checkbox">
    <span class="slider"></span>
</label>
<span class="label-text">After</span>
</div>"""

cocoon_html_share_block = """<p style="text-align: right">Share Cocoon with the World 😊</p>
<div>
    <a href="https://twitter.com/intent/tweet?url=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon&text=Can%27t+believe+how+amazing+the+table+profiles+are+created+by+Cocoon+using+AI.+It%27s+Open+sourced%21&related=ZacharyHuang12" target="_blank"  style="text-decoration: none;">
        <i class="fa-brands fa-twitter icons"></i>
    </a>
    <a href="https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon" target="_blank"  style="text-decoration: none;">
        <i class="fa-brands fa-facebook icons"></i>
    </a>
    <a href="https://www.linkedin.com/sharing/share-offsite/?url=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon" target="_blank" style="text-decoration: none;">
        <i class="fa-brands fa-linkedin icons"></i>
    </a>
    <a href="https://api.whatsapp.com/send?text=Can%27t%20believe%20how%20amazing%20the%20table%20profiles%20are%20created%20by%20Cocoon%20using%20AI.%20It%27s%20Open%20sourced%21%20https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon" target="_blank" style="text-decoration: none;">
        <i class="fa-brands fa-whatsapp icons"></i>
    </a>
    <a href="https://www.reddit.com/submit?url=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon&title=Can%27t%20believe%20how%20amazing%20the%20table%20profiles%20are%20created%20by%20Cocoon%20using%20AI.%20It%27s%20Open%20sourced%21" target="_blank" style="text-decoration: none;">
        <i class="fa-brands fa-reddit icons"></i>
    </a>
    <a href="https://pinterest.com/pin/create/button/?url=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon&media=&description=Can%27t%20believe%20how%20amazing%20the%20table%20profiles%20are%20created%20by%20Cocoon%20using%20AI.%20It%27s%20Open%20sourced%21" target="_blank" style="text-decoration: none;">
        <i class="fa-brands fa-pinterest icons"></i>
    </a>
    <a href="https://www.tumblr.com/widgets/share/tool?posttype=link&title=Can%27t%20believe%20how%20amazing%20the%20table%20profiles%20are%20created%20by%20Cocoon%20using%20AI.%20It%27s%20Open%20sourced%21&caption=&content=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon&canonicalUrl=https%3A%2F%2Fgithub.com%2FCocoon-Data-Transformation%2Fcocoon&shareSource=tumblr_share_button" target="_blank" style="text-decoration: none;">
        <i class="fa-brands fa-tumblr icons"></i>
    </a>

</div>"""

small_table_style="""table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
    font-size: 0.9em;
    border-radius: 4px;
    overflow: hidden;
}

th,
td {
    padding: 3px 4px;
    text-align: left;
    border-bottom: 1px solid #dddddd;
    border-right: 1px solid #dddddd;
}

thead tr {
    background-color: #464646;
    /* Changed color for header */
    color: #ffffff;
    /* Changed text color for better contrast */
    text-align: left;
    font-weight: bold;
    font-size: 12px;
}

th {
    top: 0;
    background-color: #464646;
    color: #ffffff;
}

tbody tr {
    background-color: #f9f9f9;
    /* Lighter color for content rows */
    font-size: 10px
}"""


code_container_style = """.code_container {
    max-height: calc(60vh);
    overflow: auto;
}

.code_container pre[class*="language-"] {
    border-radius: 4px;
    padding: 1em;
    margin: .5em 0;
    overflow: auto;
    font-size: 12px;
}
"""

cocoon_table_style = """
table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 20px;
  font-size: 0.9em;
  border-radius: 8px;
  overflow: hidden;
}

th, td {
  padding: 6px 8px;
  text-align: left;
  border-bottom: 1px solid #dddddd;
  border-right: 1px solid #dddddd;
}

th:last-child, td:last-child {
  border-right: none; /* Removes the border from the last cell of each row */
}

thead tr {
  background-color: #bebebe; /* Changed color for header */
  color: #ffffff; /* Changed text color for better contrast */
  text-align: left;
  font-weight: bold;
  font-size: 14px;
}

th {
  position: sticky;
  top: 0;
  background-color: #bebebe; /* Ensure the sticky header has the same background color */
}

tbody tr {
  background-color: #f9f9f9; /* Lighter color for content rows */
  font-size: 14px
}

tbody tr:last-of-type {
  border-bottom: 2px solid #6e6e6e;
}

tbody tr.active-row {
  font-weight: bold;
  color: #6e6e6e;
}
"""

cocoon_html_style_block = f"""
<style>
  html {{
    height: 100%; /* Ensure the html element covers the full height */
    background-color: #f0f0f0; /* Set your desired background color */
  }}

  body {{
    /* Scale the entire content to 70% */
    transform: scale(0.75);
    transform-origin: top left; /* Adjust as needed */
    width: 133.33%; /* Increase width to fit, since scaling down shrinks the viewport */
    height: 133.33%; /* Adjust height similarly if necessary */
    overflow: auto; /* Add scrollbars if content overflows */
  }}

  body, h1, h2, p {{
    margin: 0;
    padding: 0;
    font-family: 'Arial', sans-serif;
  }}

  .container {{
    display: flex;
    justify-content: space-between;
    align-items: center; /* This ensures the items are aligned in the middle vertically */
  }}

  .map-container {{
    width: 300px;
    height: 200px;
    border: 1px solid black;
  }}
  
  .histogram-container {{
    width: 300px;
    height: 100px;
    border: 1px solid black;
  }}

  .chart-container {{ /* Style for the container */
    width: 200px;
    height: 80px;
    border: 1px solid black;
  }}
  
  .bar-chart-container {{
    width: 300px;
    height: 100px;
    border: 1px solid black;
  }}

  .dashboard {{
    display: grid;
    grid-template-areas:
      "main-panel right-panel"
      "bottom-panel right-panel";
    grid-template-rows: 1fr 1fr; /* Equal height for both rows */
    gap: 10px;
    height: 130vh;
    padding: 10px;
    background-color: #f0f0f0;
  }}

  .main-panel {{
    grid-area: main-panel;
    background-color: #ffffff;
    padding: 20px;
    position: relative; /* Set the main-panel to relative to position the chat box inside it */
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
    overflow: hidden;
    display: flex;
    flex-direction: column; /* Stack the children vertically */
  }}

  .table-container {{
    overflow-x: auto; /* Allows horizontal scrolling for the table */
    overflow-y: auto; /* Allows vertical scrolling for the table */
    flex-grow: 1;
    max-width: 100%; /* Ensures that the container doesn't exceed the width of its parent */
    display: none;
  }}

  .right-panel {{
    grid-area: right-panel;
    background-color: #fff;
    padding: 15px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
    overflow-y: auto; /* Enable scrolling for the panel */
    width: 360px;
  }}

  .indent {{
    padding-left: 5px; /* Increase as needed for deeper indents */
    font-size: small;
    display: none;
  }}

  .card-item {{
    display: flex;
    align-items: center;
    background-color: #626262; /* White background for the card */
    border: 1px solid #626262; /* Light grey border */
    color: white;
    border-radius: 4px; /* Slightly rounded corners */
    margin-bottom: 6px; /* Space between card items */
    padding: 3px;
    padding-left: 10px;
    width: 320px;
  }}

  .card-item-collapsed {{
    background-color: #d0d0d0; /* Lighter background for collapsed card */
    border: 1px solid #d0d0d0; /* Lighter border for collapsed card */
    color: black; /* Change text color for better contrast on light background */
  }}

  .icon {{
    /* Styles for the icon, you can replace it with an actual icon font or image */
    padding-right: 20px;
  }}

  .field-name {{
    /* Styles for the field name */
    flex-grow: 1;
    padding-right: 20px;
    font-size: 14px;

  }}

  .circle {{
    background-color: red;
    font-size: small;
    border-radius: 50%;
    color: white;
    padding: 0px;
    text-align: center;
    display: inline-block;
      width: 16px;         /* Fixed width */
      height: 16px;        /* Fixed height */
      line-height: 16px;   /* Center the number vertically */
  }}

  .circle2 {{
    background-color: green;
    font-size: small;
    border-radius: 50%;
    color: white;
    padding: 0px;
    text-align: center;
    display: inline-block;
    /* Changes for a better circle */
      width: 16px;         /* Fixed width */
      height: 16px;        /* Fixed height */
      line-height: 16px;   /* Center the number vertically */
  }}

  .card-controls {{
    display: flex;
  }}

  .drop-down-btn,
  .add-btn {{
    /* Shared styles for buttons */
    background-color: #4CAF50; /* Green background */
    color: white;
    border: none;
    border-radius: 2px; /* Slightly rounded corners for the buttons */
    cursor: pointer;
    padding: 2px 6px; /* Smaller padding for a compact look */
    margin-left: 4px; /* Spacing between buttons */
  }}

  .drop-down-btn:hover,
  .add-btn:hover {{
    background-color: #45a049; /* Darker green on hover */
  }}

  .bottom-panel {{
    grid-area: bottom-panel;
    background-color: #ffffff;
    padding: 20px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
    overflow-x: auto;
  }}

  {cocoon_table_style}

  .link {{
      fill: none;
      stroke: #555;
      stroke-opacity: 0.4;
      stroke-width: 1.5px;
  }}

  .node {{
      cursor: pointer;
  }}

  .node circle {{
      fill: #999;
      stroke: black;
      stroke-width: 1.5px;
  }}

  .node text {{
      font: 12px sans-serif;
      fill: #555;
  }}

  .icons {{
    /* Making the icon larger */
    font-size: 20px; /* You can adjust this value as needed */
    color: white; /* Icon color */
    background-color: black; /* Background color */
    padding: 6px 6px; /* Top/bottom padding and left/right padding */
    border-radius: 3px; /* Making the corners sharp for a rectangular look */
  }}

  .switch-container {{
    display: flex;
    align-items: center;
  }}

  .switch {{
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
    margin: 0 10px;
  }}

  .switch input {{
    opacity: 0;
    width: 0;
    height: 0;
  }}

  .slider {{
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 34px;
  }}

  .slider:before {{
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
  }}

  input:checked + .slider {{
    background-color: #2196F3;
  }}

  input:checked + .slider:before {{
    transform: translateX(26px);
  }}

  .label-text {{
    font-family: Verdana, sans-serif;
    font-size: 14px;
  }}

  .table-container.active {{
    display: block;
  }}

.tag {{
  display: inline-block;
  padding: 2px 6px;
  font-size: 12px;
  margin-right: 6px;
  border-radius: 4px;
}}

.tag-red {{
  background-color: #ffcccb;
  color: #ff0000;
  border: 1px solid #ff0000;
}}

.tag-blue {{
  background-color: #e0f2ff;
  color: #0066ff;
  border: 1px solid #0066ff;
}}

.tag-purple {{
  background-color: #e6ccff;
  color: #9900ff;
  border: 1px solid #9900ff;
}}

code {{
  font-family: Consolas,"courier new";
  color: crimson;
  background-color: #f1f1f1;
  padding: 2px;
  font-size: 105%;
}}
</style>"""

pandas_css = """
table {
  border: none;
  border-collapse: collapse;
  border-spacing: 0;
  color: black;
  font-size: 12px;
  table-layout: fixed;
}
thead {
  border-bottom: 1px solid black;
  vertical-align: bottom;
}
tr, th, td {
  text-align: right;
  vertical-align: middle;
  padding: 0.5em 0.5em;
  line-height: normal;
  white-space: normal;
  max-width: none;
  border: none;
}
th {
  font-weight: bold;
}

tbody tr:nth-child(even) {
    background: #f5f5f5;
}

tbody {
    display: table-row-group;
    vertical-align: middle;
    unicode-bidi: isolate;
    border-color: inherit;
}

tbody tr:hover {
  background: rgba(66, 165, 245, 0.2);
}
"""

def create_cocoon_logo(header, footer):
    cocoon_logo = f"""<a href="https://github.com/Cocoon-Data-Transformation/cocoon" target="_blank" style="display: flex; align-items: center; text-decoration: none; color: black;">
    <img src="https://raw.githubusercontent.com/Cocoon-Data-Transformation/cocoon/main/images/cocoon_icon.png" alt="cocoon icon" width=50 style="margin-right: 10px;">
    <div style="margin: 0; padding: 0;"><h2 style="margin: 0; padding: 0;">{header}</h2>
        <p style="margin: 0; padding: 0;">{footer}</p>
    </div>
</a>"""
    return cocoon_logo