from types import SimpleNamespace

# metadata compression types supported
COMPRESSION_TYPES = SimpleNamespace(
    ZSTD="zstd",
    GZ="gz",
)

COMPRESSION_CHOICES = (
    (COMPRESSION_TYPES.ZSTD, COMPRESSION_TYPES.ZSTD),
    (COMPRESSION_TYPES.GZ, COMPRESSION_TYPES.GZ),
)

CHECKSUM_TYPES = SimpleNamespace(
    UNKNOWN="unknown",
    MD5="md5",
    SHA="sha1",  # compatibility nickname from original createrepo
    SHA1="sha1",
    SHA224="sha224",
    SHA256="sha256",
    SHA384="sha384",
    SHA512="sha512",
)

# The same as above, but in a format that choice fields can use
CHECKSUM_CHOICES = (
    (CHECKSUM_TYPES.UNKNOWN, CHECKSUM_TYPES.UNKNOWN),
    (CHECKSUM_TYPES.MD5, CHECKSUM_TYPES.MD5),
    (CHECKSUM_TYPES.SHA, CHECKSUM_TYPES.SHA1),
    (CHECKSUM_TYPES.SHA1, CHECKSUM_TYPES.SHA1),
    (CHECKSUM_TYPES.SHA224, CHECKSUM_TYPES.SHA224),
    (CHECKSUM_TYPES.SHA256, CHECKSUM_TYPES.SHA256),
    (CHECKSUM_TYPES.SHA384, CHECKSUM_TYPES.SHA384),
    (CHECKSUM_TYPES.SHA512, CHECKSUM_TYPES.SHA512),
)

ALLOWED_CHECKSUM_ERROR_MSG = """Checksum must be one of the allowed checksum types.
You can adjust these with the 'ALLOWED_CONTENT_CHECKSUMS' setting."""

ALLOWED_PUBLISH_CHECKSUMS = {CHECKSUM_TYPES.SHA256, CHECKSUM_TYPES.SHA384, CHECKSUM_TYPES.SHA512}

ALLOWED_PUBLISH_CHECKSUM_ERROR_MSG = (
    """Checksum must be one of the allowed checksum types: sha256, sha384, or sha512."""
)

SYNC_POLICIES = SimpleNamespace(
    ADDITIVE="additive",
    MIRROR_COMPLETE="mirror_complete",
    MIRROR_CONTENT_ONLY="mirror_content_only",
)

SYNC_POLICY_CHOICES = (
    (SYNC_POLICIES.ADDITIVE, SYNC_POLICIES.ADDITIVE),
    (SYNC_POLICIES.MIRROR_COMPLETE, SYNC_POLICIES.MIRROR_COMPLETE),
    (SYNC_POLICIES.MIRROR_CONTENT_ONLY, SYNC_POLICIES.MIRROR_CONTENT_ONLY),
)

CR_PACKAGE_ATTRS = SimpleNamespace(
    ARCH="arch",
    CHANGELOGS="changelogs",
    CHECKSUM_TYPE="checksum_type",
    CONFLICTS="conflicts",
    DESCRIPTION="description",
    ENHANCES="enhances",
    EPOCH="epoch",
    FILES="files",
    LOCATION_BASE="location_base",
    LOCATION_HREF="location_href",
    NAME="name",
    OBSOLETES="obsoletes",
    PKGID="pkgId",
    PROVIDES="provides",
    RECOMMENDS="recommends",
    RELEASE="release",
    REQUIRES="requires",
    RPM_BUILDHOST="rpm_buildhost",
    RPM_GROUP="rpm_group",
    RPM_HEADER_END="rpm_header_end",
    RPM_HEADER_START="rpm_header_start",
    RPM_LICENSE="rpm_license",
    RPM_PACKAGER="rpm_packager",
    RPM_SOURCERPM="rpm_sourcerpm",
    RPM_VENDOR="rpm_vendor",
    SIZE_ARCHIVE="size_archive",
    SIZE_INSTALLED="size_installed",
    SIZE_PACKAGE="size_package",
    SUGGESTS="suggests",
    SUMMARY="summary",
    SUPPLEMENTS="supplements",
    TIME_BUILD="time_build",
    TIME_FILE="time_file",
    URL="url",
    VERSION="version",
)

PACKAGE_REPODATA = ["primary", "filelists", "other"]
PACKAGE_DB_REPODATA = ["primary_db", "filelists_db", "other_db"]
UPDATE_REPODATA = ["updateinfo"]
MODULAR_REPODATA = ["modules"]
COMPS_REPODATA = ["group"]
SKIP_TYPES = ["srpm", "treeinfo"]

CR_UPDATE_RECORD_ATTRS = SimpleNamespace(
    ID="id",
    UPDATED_DATE="updated_date",
    DESCRIPTION="description",
    ISSUED_DATE="issued_date",
    FROMSTR="fromstr",
    STATUS="status",
    TITLE="title",
    SUMMARY="summary",
    VERSION="version",
    TYPE="type",
    SEVERITY="severity",
    SOLUTION="solution",
    RELEASE="release",
    RIGHTS="rights",
    PUSHCOUNT="pushcount",
    REBOOT_SUGGESTED="reboot_suggested",
)

CR_UPDATE_COLLECTION_ATTRS = SimpleNamespace(NAME="name", SHORTNAME="shortname", MODULE="module")

CR_UPDATE_COLLECTION_PACKAGE_ATTRS = SimpleNamespace(
    ARCH="arch",
    EPOCH="epoch",
    FILENAME="filename",
    NAME="name",
    REBOOT_SUGGESTED="reboot_suggested",
    RELOGIN_SUGGESTED="relogin_suggested",
    RESTART_SUGGESTED="restart_suggested",
    RELEASE="release",
    SRC="src",
    SUM="sum",
    SUM_TYPE="sum_type",
    VERSION="version",
)

CR_UPDATE_REFERENCE_ATTRS = SimpleNamespace(HREF="href", ID="id", TITLE="title", TYPE="type")

CR_UPDATE_COLLECTION_ATTRS_MODULE = SimpleNamespace(
    NAME="name", STREAM="stream", VERSION="version", CONTEXT="context", ARCH="arch"
)

PULP_UPDATE_REFERENCE_ATTRS = SimpleNamespace(
    HREF="href", ID="ref_id", TITLE="title", TYPE="ref_type"
)

PULP_PACKAGE_ATTRS = CR_PACKAGE_ATTRS
PULP_UPDATE_RECORD_ATTRS = CR_UPDATE_RECORD_ATTRS
PULP_UPDATE_COLLECTION_ATTRS = CR_UPDATE_COLLECTION_ATTRS
PULP_UPDATE_COLLECTION_PACKAGE_ATTRS = CR_UPDATE_COLLECTION_PACKAGE_ATTRS

PULP_UPDATE_COLLECTION_ATTRS_MODULE = CR_UPDATE_COLLECTION_ATTRS_MODULE

MODULEMD_MODULE_ATTR = SimpleNamespace(
    ARCH="arch",
    ARTIFACTS="artifacts",
    STATIC_CONTEXT="static_context",
    CONTEXT="context",
    NAME="name",
    STREAM="stream",
    VERSION="version",
    DEPENDENCIES="dependencies",
    PROFILES="profiles",
    DESCRIPTION="description",
)

MODULEMD_MODULEDEFAULTS_ATTR = SimpleNamespace(
    MODULE="module", STREAM="stream", PROFILES="profiles"
)

PULP_MODULEDEFAULTS_ATTR = SimpleNamespace(
    MODULE="module", STREAM="stream", PROFILES="profiles", DIGEST="digest"
)

PULP_MODULEOBSOLETES_ATTR = SimpleNamespace(
    MODIFIED="modified",
    MODULE="module_name",
    STREAM="module_stream",
    MESSAGE="message",
    RESET="override_previous",
    CONTEXT="module_context",
    EOL="eol_date",
    OBSOLETE_BY_MODULE="obsoleted_by_module_name",
    OBSOLETE_BY_STREAM="obsoleted_by_module_stream",
)

# Mandatory fields for Modulemd types
# https://github.com/fedora-modularity/libmodulemd/blob/main/yaml_specs/modulemd_defaults_v1.yaml
YAML_MODULEMD_DEFAULTS_REQUIRED_ATTR = ["module"]
# https://github.com/fedora-modularity/libmodulemd/blob/main/yaml_specs/modulemd_obsoletes_v1.yaml
YAML_MODULEMD_OBSOLETES_REQUIRED_ATTR = ["modified", "module", "stream", "message"]

PULP_MODULE_ATTR = MODULEMD_MODULE_ATTR

LIBCOMPS_GROUP_ATTRS = SimpleNamespace(
    ID="id",
    DEFAULT="default",
    USER_VISIBLE="uservisible",
    DISPLAY_ORDER="display_order",
    NAME="name",
    DESCRIPTION="desc",
    PACKAGES="packages",
    BIARCH_ONLY="biarchonly",
    DESC_BY_LANG="desc_by_lang",
    NAME_BY_LANG="name_by_lang",
)

LIBCOMPS_CATEGORY_ATTRS = SimpleNamespace(
    ID="id",
    NAME="name",
    DESCRIPTION="desc",
    DISPLAY_ORDER="display_order",
    GROUP_IDS="group_ids",
    DESC_BY_LANG="desc_by_lang",
    NAME_BY_LANG="name_by_lang",
)

LIBCOMPS_ENVIRONMENT_ATTRS = SimpleNamespace(
    ID="id",
    NAME="name",
    DESCRIPTION="desc",
    DISPLAY_ORDER="display_order",
    GROUP_IDS="group_ids",
    OPTION_IDS="option_ids",
    DESC_BY_LANG="desc_by_lang",
    NAME_BY_LANG="name_by_lang",
)

PULP_LANGPACKS_ATTRS = SimpleNamespace(MATCHES="matches")

PULP_GROUP_ATTRS = SimpleNamespace(
    ID="id",
    DEFAULT="default",
    USER_VISIBLE="user_visible",
    DISPLAY_ORDER="display_order",
    NAME="name",
    DESCRIPTION="description",
    PACKAGES="packages",
    BIARCH_ONLY="biarch_only",
    DESC_BY_LANG="desc_by_lang",
    NAME_BY_LANG="name_by_lang",
)

PULP_CATEGORY_ATTRS = SimpleNamespace(
    ID="id",
    NAME="name",
    DESCRIPTION="description",
    DISPLAY_ORDER="display_order",
    GROUP_IDS="group_ids",
    DESC_BY_LANG="desc_by_lang",
    NAME_BY_LANG="name_by_lang",
)

PULP_ENVIRONMENT_ATTRS = SimpleNamespace(
    ID="id",
    NAME="name",
    DESCRIPTION="description",
    DISPLAY_ORDER="display_order",
    GROUP_IDS="group_ids",
    OPTION_IDS="option_ids",
    DESC_BY_LANG="desc_by_lang",
    NAME_BY_LANG="name_by_lang",
)

PACKAGES_DIRECTORY = "Packages"
DIST_TREE_MAIN_REPO_PATH = "."

# Mappings of the possible integer values of "sum_type" on Advisory packages to their user-facing
# string representation. Should mirror the createrepo_c source code:
# https://github.com/rpm-software-management/createrepo_c/blob/master/src/checksum.h#L43-L54
# Please keep dict consistent with createrepo_c mapping mentioned above.
ADVISORY_SUM_TYPE_TO_NAME = {
    0: "unknown",
    1: "md5",
    2: "sha",
    3: "sha1",
    4: "sha224",
    5: "sha256",
    6: "sha384",
    7: "sha512",
}
