# Generated by Django 2.2.16 on 2020-10-09 14:58

from django.db import migrations, models


def check_checksum(apps, schema_editor):
    checksum_model = apps.get_model("rpm", "Checksum")
    repository_model = apps.get_model("rpm", "RpmRepository")
    q_bad_dist_tree = checksum_model.objects.filter(checksum=None)
    if q_bad_dist_tree:
        dist_tree_pks = {
            dt.distribution_tree.pk
            for dt in q_bad_dist_tree
        }
        repository_list = {
            f"/pulp/api/v3/repositories/rpm/rpm/{repo.pk}"
            for repo in repository_model.objects.filter(content__in=dist_tree_pks)
        }
        raise ValueError(
            "Your Pulp instance contains DistributionTree content units with null checksums. "
            "They were not properly validated before this update. Please remove the affected "
            f"DistributionTrees content from your repositories {repository_list} by removing "
            "old repository versions and running orphan cleanup afterwards. "
            "If you need to get removed content back, please re-sync corresponding repositories."
        )


class Migration(migrations.Migration):

    dependencies = [
        ('rpm', '0026_add_gpgcheck_options'),
    ]

    operations = [
        migrations.RunPython(check_checksum),
        migrations.AlterField(
            model_name='checksum',
            name='checksum',
            field=models.CharField(max_length=128),
            preserve_default=False,
        ),
    ]
