# Generated by Django 2.2.10 on 2020-02-19 14:43


from django.db import models, migrations, transaction


def replace_nonestring_with_null(apps, schema_editor):
    with transaction.atomic():
        UpdateRecord = apps.get_model('rpm', 'UpdateRecord')

        recs = list(UpdateRecord.objects.filter(updated_date__in=('None', '')).only('updated_date'))
        for rec in recs:
            rec.updated_date = None

        UpdateRecord.objects.bulk_update(recs, ['updated_date'])


class Migration(migrations.Migration):

    dependencies = [
        ('rpm', '0029_rpmpublication_sqlite_metadata'),
    ]

    operations = [
        migrations.AlterField(
            model_name='updaterecord',
            name='updated_date',
            field=models.TextField(null=True),
        ),
        # The string "None" was stored in the database in place of "" or null
        migrations.RunPython(replace_nonestring_with_null),
    ]
