

def convert_num(num):
    if isinstance(num, float) and num % 1:
        return num
    return int(num)


def float_to_str(num: float, *, digit=0, plus=False):
    if 0 < digit:
        num.__round__(digit)
        text = f'{num:+,.{digit}f}' if plus else f'{num:,.{digit}f}'
    else:
        num = round(num, digit).__int__()
        text = f'{num:+,}' if plus else f'{num:,}'
    return text


unit_ko = {
    '경': 10_000_000_000_000_000,
    '조':      1_000_000_000_000,
    '억':            100_000_000,
    '만':                 10_000,
}
def convert_unit(value, *, digit=0, word='원', unit_data: dict[str, int]=None):
    if not unit_data:
        unit_data = unit_ko
    # print('ko')
    # print(f'{value=:,}')
    v = abs(value)
    for unit, n in unit_data.items():
        if n <= v:
            # print(f'{n=:,}')
            # print(f'{unit=}')
            num = value / n
            if word.startswith(' '):
                return f'{float_to_str(num, digit=digit)}{unit}{word}'
            return f'{float_to_str(num, digit=digit)}{unit} {word}'

    if not value % 1:
        value = int(value)
    text = f'{float_to_str(value, digit=digit)}{word}'
    # print(f'{text=}')
    return text

unit_en = {
    'Qd': 1_000_000_000_000_000,
    'T':      1_000_000_000_000,
    'B':          1_000_000_000,
    'M':              1_000_000,
    'K':                  1_000,
}
def convert_unit_en(value, *, digit=0, word='$', unit_data: dict[str, int]=None):
    if not unit_data:
        unit_data = unit_en
    # print('en')
    # print(f'{value=:,}')
    return convert_unit(value, digit=digit, word=word, unit_data=unit_data)


if __name__ == '__main__':
    a = 456.123
    print(float_to_str(a))
    print(float_to_str(a, 2))
    print(float_to_str(a, 6))


