"""Alpha Layers rows for Glorious Engrammer."""

from __future__ import annotations

from typing import TYPE_CHECKING

from glove80.layouts.layers import Token, rows_to_layer_spec

if TYPE_CHECKING:
    from glove80.base import LayerSpec

LayerRows = tuple[tuple[Token, ...], ...]


ALPHA_LAYER_SPECS: dict[str, LayerSpec] = {
    "Enthium": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "&none",
                "&none",
                "Z",
                "Y",
                "U",
                "O",
                "SEMI",
                "Q",
                "L",
            ),
            (
                "D",
                "P",
                "X",
                "&none",
                "W",
                ("Custom", "&LeftPinky (C, LAYER_Enthium)"),
                ("Custom", "&LeftRingy (I, LAYER_Enthium)"),
                ("Custom", "&LeftMiddy (E, LAYER_Enthium)"),
                ("Custom", "&LeftIndex (A, LAYER_Enthium)"),
                "COMMA",
            ),
            (
                "K",
                ("Custom", "&RightIndex (H, LAYER_Enthium)"),
                ("Custom", "&RightMiddy (T, LAYER_Enthium)"),
                ("Custom", "&RightRingy (N, LAYER_Enthium)"),
                ("Custom", "&RightPinky (S, LAYER_Enthium)"),
                "F",
                ("Custom", "&mo LAYER_Lower"),
                "SQT",
                "MINUS",
                "EQUAL",
            ),
            (
                "DOT",
                "FSLH",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                "J",
                "M",
            ),
            (
                "G",
                "B",
                "V",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                "GRAVE",
                "LBKT",
                "RBKT",
                ("Custom", "&thumb LAYER_Emoji BSLH"),
                ("Custom", "&thumb LAYER_Cursor SPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number TAB"),
                ("Custom", "&thumb LAYER_Typing INSERT"),
                ("Custom", "&thumb LAYER_Typing DELETE"),
                ("Custom", "&thumb LAYER_Mouse BACKSPACE"),
                ("Custom", "&space LAYER_Symbol R"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "Engrammer": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "&none",
                "&none",
                "B",
                "Y",
                "O",
                "U",
                "SQT",
                "SEMI",
                "L",
            ),
            (
                "D",
                "W",
                "V",
                "Z",
                "EQUAL",
                ("Custom", "&LeftPinky (C, LAYER_Engrammer)"),
                ("Custom", "&LeftRingy (I, LAYER_Engrammer)"),
                ("Custom", "&LeftMiddy (E, LAYER_Engrammer)"),
                ("Custom", "&LeftIndex (A, LAYER_Engrammer)"),
                "COMMA",
            ),
            (
                "DOT",
                ("Custom", "&RightIndex (H, LAYER_Engrammer)"),
                ("Custom", "&RightMiddy (T, LAYER_Engrammer)"),
                ("Custom", "&RightRingy (S, LAYER_Engrammer)"),
                ("Custom", "&RightPinky (N, LAYER_Engrammer)"),
                "Q",
                ("Custom", "&mo LAYER_Lower"),
                "G",
                "X",
                "J",
            ),
            (
                "K",
                "MINUS",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                "FSLH",
                "R",
            ),
            (
                "M",
                "F",
                "P",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                "GRAVE",
                "LBKT",
                "RBKT",
                ("Custom", "&thumb LAYER_Emoji BSLH"),
                ("Custom", "&thumb LAYER_Cursor BACKSPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number DELETE"),
                ("Custom", "&thumb LAYER_Typing INSERT"),
                ("Custom", "&mo LAYER_Typing"),
                ("Custom", "&thumb LAYER_Mouse TAB"),
                ("Custom", "&space LAYER_Symbol SPACE"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "Engram": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                ("Custom", "&engram_N1"),
                ("Custom", "&engram_N2"),
                ("Custom", "&engram_N3"),
                ("Custom", "&engram_N4"),
                ("Custom", "&engram_N5"),
                ("Custom", "&engram_N6"),
                ("Custom", "&engram_N7"),
                ("Custom", "&engram_N8"),
                ("Custom", "&engram_N9"),
            ),
            (
                ("Custom", "&engram_N0"),
                "&none",
                "&none",
                "B",
                "Y",
                "O",
                "U",
                ("Custom", "&engram_SQT"),
                ("Custom", "&engram_DQT"),
                "L",
            ),
            (
                "D",
                "W",
                "V",
                "Z",
                ("Custom", "&engram_HASH"),
                ("Custom", "&LeftPinky (C, LAYER_Engram)"),
                ("Custom", "&LeftRingy (I, LAYER_Engram)"),
                ("Custom", "&LeftMiddy (E, LAYER_Engram)"),
                ("Custom", "&LeftIndex (A, LAYER_Engram)"),
                ("Custom", "&engram_COMMA"),
            ),
            (
                ("Custom", "&engram_DOT"),
                ("Custom", "&RightIndex (H, LAYER_Engram)"),
                ("Custom", "&RightMiddy (T, LAYER_Engram)"),
                ("Custom", "&RightRingy (S, LAYER_Engram)"),
                ("Custom", "&RightPinky (N, LAYER_Engram)"),
                "Q",
                ("Custom", "&mo LAYER_Lower"),
                "G",
                "X",
                "J",
            ),
            (
                "K",
                "MINUS",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                ("Custom", "&engram_QMARK"),
                "R",
            ),
            (
                "M",
                "F",
                "P",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                ("Custom", "&engram_FSLH"),
                "LBKT",
                "RBKT",
                ("Custom", "&thumb_engram_AT LAYER_Emoji 0"),
                ("Custom", "&thumb LAYER_Cursor BACKSPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number DELETE"),
                ("Custom", "&thumb LAYER_Typing INSERT"),
                ("Custom", "&mo LAYER_Typing"),
                ("Custom", "&thumb LAYER_Mouse TAB"),
                ("Custom", "&space LAYER_Symbol SPACE"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "Dvorak": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "&none",
                "&none",
                "SQT",
                "COMMA",
                "DOT",
                "P",
                "Y",
                "F",
                "G",
            ),
            (
                "C",
                "R",
                "L",
                "SLASH",
                "EQUAL",
                ("Custom", "&LeftPinky (A, LAYER_Dvorak)"),
                ("Custom", "&LeftRingy (O, LAYER_Dvorak)"),
                ("Custom", "&LeftMiddy (E, LAYER_Dvorak)"),
                ("Custom", "&LeftIndex (U, LAYER_Dvorak)"),
                "I",
            ),
            (
                "D",
                ("Custom", "&RightIndex (H, LAYER_Dvorak)"),
                ("Custom", "&RightMiddy (T, LAYER_Dvorak)"),
                ("Custom", "&RightRingy (N, LAYER_Dvorak)"),
                ("Custom", "&RightPinky (S, LAYER_Dvorak)"),
                "MINUS",
                ("Custom", "&mo LAYER_Lower"),
                "SEMI",
                "Q",
                "J",
            ),
            (
                "K",
                "X",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                "B",
                "M",
            ),
            (
                "W",
                "V",
                "Z",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                "GRAVE",
                "LBKT",
                "RBKT",
                ("Custom", "&thumb LAYER_Emoji BSLH"),
                ("Custom", "&thumb LAYER_Cursor BACKSPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number DELETE"),
                ("Custom", "&thumb LAYER_Typing INSERT"),
                ("Custom", "&mo LAYER_Typing"),
                ("Custom", "&thumb LAYER_Mouse TAB"),
                ("Custom", "&space LAYER_Symbol SPACE"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "Colemak": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "&none",
                "&none",
                "Q",
                "W",
                "F",
                "P",
                "G",
                "J",
                "L",
            ),
            (
                "U",
                "Y",
                "SEMI",
                "MINUS",
                "EQUAL",
                ("Custom", "&LeftPinky (A, LAYER_Colemak)"),
                ("Custom", "&LeftRingy (R, LAYER_Colemak)"),
                ("Custom", "&LeftMiddy (S, LAYER_Colemak)"),
                ("Custom", "&LeftIndex (T, LAYER_Colemak)"),
                "D",
            ),
            (
                "H",
                ("Custom", "&RightIndex (N, LAYER_Colemak)"),
                ("Custom", "&RightMiddy (E, LAYER_Colemak)"),
                ("Custom", "&RightRingy (I, LAYER_Colemak)"),
                ("Custom", "&RightPinky (O, LAYER_Colemak)"),
                "SQT",
                ("Custom", "&mo LAYER_Lower"),
                "Z",
                "X",
                "C",
            ),
            (
                "V",
                "B",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                "K",
                "M",
            ),
            (
                "COMMA",
                "DOT",
                "FSLH",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                "GRAVE",
                "LBKT",
                "RBKT",
                ("Custom", "&thumb LAYER_Emoji BSLH"),
                ("Custom", "&thumb LAYER_Cursor BACKSPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number DELETE"),
                ("Custom", "&crumb LAYER_Typing INSERT"),
                ("Custom", "&mo LAYER_Typing"),
                ("Custom", "&thumb LAYER_Mouse TAB"),
                ("Custom", "&space LAYER_Symbol SPACE"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "QWERTY": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "&none",
                "&none",
                "Q",
                "W",
                "E",
                "R",
                "T",
                "Y",
                "U",
            ),
            (
                "I",
                "O",
                "P",
                "MINUS",
                "EQUAL",
                ("Custom", "&LeftPinky (A, LAYER_QWERTY)"),
                ("Custom", "&LeftRingy (S, LAYER_QWERTY)"),
                ("Custom", "&LeftMiddy (D, LAYER_QWERTY)"),
                ("Custom", "&LeftIndex (F, LAYER_QWERTY)"),
                "G",
            ),
            (
                "H",
                ("Custom", "&RightIndex (J, LAYER_QWERTY)"),
                ("Custom", "&RightMiddy (K, LAYER_QWERTY)"),
                ("Custom", "&RightRingy (L, LAYER_QWERTY)"),
                ("Custom", "&RightPinky (SEMI, LAYER_QWERTY)"),
                "SQT",
                ("Custom", "&mo LAYER_Lower"),
                "Z",
                "X",
                "C",
            ),
            (
                "V",
                "B",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                "N",
                "M",
            ),
            (
                "COMMA",
                "DOT",
                "FSLH",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                "GRAVE",
                "LBKT",
                "RBKT",
                ("Custom", "&thumb LAYER_Emoji BSLH"),
                ("Custom", "&thumb LAYER_Cursor BACKSPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number DELETE"),
                ("Custom", "&thumb LAYER_Typing INSERT"),
                ("Custom", "&mo LAYER_Typing"),
                ("Custom", "&thumb LAYER_Mouse TAB"),
                ("Custom", "&space LAYER_Symbol SPACE"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "ColemakDH": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "&none",
                "&none",
                "Q",
                "W",
                "F",
                "P",
                "B",
                "J",
                "L",
            ),
            (
                "U",
                "Y",
                "SEMI",
                "MINUS",
                "EQUAL",
                ("Custom", "&LeftPinky (A, LAYER_ColemakDH)"),
                ("Custom", "&LeftRingy (R, LAYER_ColemakDH)"),
                ("Custom", "&LeftMiddy (S, LAYER_ColemakDH)"),
                ("Custom", "&LeftIndex (T, LAYER_ColemakDH)"),
                "G",
            ),
            (
                "M",
                ("Custom", "&RightIndex (N, LAYER_ColemakDH)"),
                ("Custom", "&RightMiddy (E, LAYER_ColemakDH)"),
                ("Custom", "&RightRingy (I, LAYER_ColemakDH)"),
                ("Custom", "&RightPinky (O, LAYER_ColemakDH)"),
                "SQT",
                ("Custom", "&mo LAYER_Lower"),
                "Z",
                "X",
                "C",
            ),
            (
                "D",
                "V",
                ("Custom", "&thumb LAYER_Function ESC"),
                ("Custom", "&parang_left"),
                ("Custom", "&parang_right"),
                ("Custom", "&kp _HOME"),
                ("Custom", "&kp _END"),
                ("Custom", "&thumb LAYER_System ENTER"),
                "K",
                "H",
            ),
            (
                "COMMA",
                "DOT",
                "FSLH",
                ("Custom", "&mo LAYER_Lower"),
                "&magic",
                "GRAVE",
                "LBKT",
                "RBKT",
                ("Custom", "&thumb LAYER_Emoji BSLH"),
                ("Custom", "&thumb LAYER_Cursor BACKSPACE"),
            ),
            (
                ("Custom", "&thumb LAYER_Number DELETE"),
                ("Custom", "&thumb LAYER_Typing INSERT"),
                ("Custom", "&mo LAYER_Typing"),
                ("Custom", "&thumb LAYER_Mouse TAB"),
                ("Custom", "&space LAYER_Symbol SPACE"),
                ("Custom", "&thumb LAYER_World PAGE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                "PG_DN",
                "&magic",
            ),
        ),
    ),
    "Typing": rows_to_layer_spec(
        (
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                ("Custom", "&kp LEFT_PINKY_KEY"),
                ("Custom", "&kp LEFT_RINGY_KEY"),
                ("Custom", "&kp LEFT_MIDDY_KEY"),
                ("Custom", "&kp LEFT_INDEX_KEY"),
                "&trans",
            ),
            (
                "&trans",
                ("Custom", "&kp RIGHT_INDEX_KEY"),
                ("Custom", "&kp RIGHT_MIDDY_KEY"),
                ("Custom", "&kp RIGHT_RINGY_KEY"),
                ("Custom", "&kp RIGHT_PINKY_KEY"),
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                ("Custom", "&kp KEY_LH_T1"),
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                ("Custom", "&kp KEY_RH_T1"),
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                ("Custom", "&kp KEY_LH_C2R6"),
                ("Custom", "&kp KEY_LH_T4"),
            ),
            (
                ("Custom", "&kp KEY_LH_T5"),
                ("Custom", "&kp KEY_LH_T6"),
                ("Custom", "&kp KEY_RH_T6"),
                ("Custom", "&kp KEY_RH_T5"),
                ("Custom", "&kp KEY_RH_T4"),
                ("Custom", "&kp KEY_RH_C2R6"),
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
        ),
    ),
}
