"""Mouse Layers rows for Glorious Engrammer."""

from __future__ import annotations

from typing import TYPE_CHECKING

from glove80.layouts.layers import Token, rows_to_layer_spec

if TYPE_CHECKING:
    from glove80.base import LayerSpec

LayerRows = tuple[tuple[Token, ...], ...]


MOUSE_LAYER_SPECS: dict[str, LayerSpec] = {
    "Mouse": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&msc MOUSE_SCROLL_LEFT"),
                ("&mmv", "MOVE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_RIGHT"),
                "&none",
                "&none",
                ("Custom", "&sk RIGHT_INDEX_MOD"),
            ),
            (
                ("Custom", "&sk RIGHT_MIDDY_MOD"),
                ("Custom", "&sk RIGHT_RINGY_MOD"),
                ("Custom", "&sk RIGHT_PINKY_MOD"),
                "K_APP",
                "&none",
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("&mmv", "MOVE_LEFT"),
                ("&mmv", "MOVE_DOWN"),
                ("&mmv", "MOVE_RIGHT"),
                ("Custom", "&msc MOUSE_SCROLL_UP"),
            ),
            (
                ("Custom", "&msc MOUSE_SCROLL_UP"),
                ("Custom", "&mo LAYER_MouseFast"),
                ("Custom", "&mo LAYER_MouseSlow"),
                ("Custom", "&mo LAYER_MouseFine"),
                ("Custom", "&mo LAYER_MouseWarp"),
                ("&mkp", "MB4"),
                "&none",
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                ("Custom", "&kp _CUT"),
                ("Custom", "&kp _COPY"),
            ),
            (
                ("Custom", "&kp _PASTE"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                ("&mkp", "MCLK"),
                "K_APP",
                ("&mkp", "MB5"),
                ("Custom", "&kp _PASTE"),
                ("Custom", "&kp _COPY"),
                ("Custom", "&kp _PASTE"),
                ("Custom", "&msc MOUSE_SCROLL_DOWN"),
                ("Custom", "&msc MOUSE_SCROLL_LEFT"),
            ),
            (
                ("&mmv", "MOVE_UP"),
                ("Custom", "&msc MOUSE_SCROLL_RIGHT"),
                ("&mkp", "LCLK"),
                ("&mkp", "MB5"),
                "&none",
                ("Custom", "&mo LAYER_MouseWarp"),
                ("Custom", "&mo LAYER_MouseFine"),
                ("Custom", "&mo LAYER_MouseSlow"),
                ("Custom", "&mo LAYER_MouseFast"),
                ("&mkp", "LCLK"),
            ),
            (
                ("&mkp", "RCLK"),
                ("&mkp", "MB4"),
                "&none",
                ("Custom", "&tog LAYER_Mouse"),
                "&none",
                ("&mmv", "MOVE_LEFT"),
                ("&mmv", "MOVE_DOWN"),
                ("&mmv", "MOVE_RIGHT"),
                ("&mkp", "RCLK"),
                ("&mkp", "MCLK"),
            ),
        ),
    ),
    "MouseFine": rows_to_layer_spec(
        (
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
        ),
    ),
    "MouseSlow": rows_to_layer_spec(
        (
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
        ),
    ),
    "MouseFast": rows_to_layer_spec(
        (
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
        ),
    ),
    "MouseWarp": rows_to_layer_spec(
        (
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
            (
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
                "&trans",
            ),
        ),
    ),
}
