"""Utility Layers rows for Glorious Engrammer."""

from __future__ import annotations

from typing import TYPE_CHECKING

from glove80.layouts.layers import Token, rows_to_layer_spec

if TYPE_CHECKING:
    from glove80.base import LayerSpec

LayerRows = tuple[tuple[Token, ...], ...]


UTILITY_LAYER_SPECS: dict[str, LayerSpec] = {
    "Cursor": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "ESC",
                "INS",
                ("&kp", ("LS", "TAB")),
                "DEL",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "RET",
                "SPACE",
                "TAB",
                "BSPC",
                ("Custom", "&kp _CUT"),
                ("Custom", "&kp _CUT"),
                ("&kp", ("LS", "TAB")),
            ),
            (
                ("Custom", "&kp _UNDO"),
                ("Custom", "&kp _REDO"),
                "TAB",
                "&none",
                ("&sk", "LSHFT"),
                ("Custom", "&kp LEFT_PINKY_MOD"),
                ("Custom", "&kp LEFT_RINGY_MOD"),
                ("Custom", "&kp LEFT_MIDDY_MOD"),
                ("Custom", "&kp LEFT_INDEX_MOD"),
                ("Custom", "&kp _COPY"),
            ),
            (
                ("Custom", "&kp _COPY"),
                "LEFT",
                "UP",
                "DOWN",
                "RIGHT",
                ("&sk", "LSHFT"),
                ("Custom", "&kp _C(L)"),
                ("Custom", "&select_all"),
                ("Custom", "&select_line"),
                ("Custom", "&select_word"),
            ),
            (
                ("Custom", "&kp _FIND"),
                ("Custom", "&kp _PASTE"),
                ("&kp", ("LS", "TAB")),
                "TAB",
                "&none",
                ("Custom", "&select_none"),
                ("Custom", "&extend_line"),
                ("Custom", "&extend_word"),
                ("Custom", "&kp _PASTE"),
                ("Custom", "&kp _HOME"),
            ),
            (
                "PG_UP",
                "PG_DN",
                ("Custom", "&kp _END"),
                ("Custom", "&kp _C(L)"),
                ("Custom", "&kp _C(K)"),
                ("Custom", "&kp _UNDO"),
                ("Custom", "&kp _REDO"),
                ("Custom", "&kp _FIND_PREV"),
                ("Custom", "&kp _FIND_NEXT"),
                ("Custom", "&tog LAYER_Cursor"),
            ),
            (
                "&none",
                "&none",
                ("Custom", "&select_all"),
                ("Custom", "&select_line"),
                ("Custom", "&select_word"),
                ("Custom", "&kp _FIND"),
                ("Custom", "&kp _FIND_PREV"),
                ("Custom", "&kp _FIND_NEXT"),
                ("Custom", "&kp _C(H)"),
                ("Custom", "&kp _C(K)"),
            ),
        ),
    ),
    "Number": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "A",
                "B",
                "C",
                "D",
                "E",
            ),
            (
                "&none",
                "ESC",
                "INS",
                ("&kp", ("LS", "TAB")),
                "DEL",
                "&none",
                "PIPE",
                "HASH",
                "DLLR",
                "CARET",
            ),
            (
                "TILDE",
                "EXCL",
                "E",
                "RET",
                "SPACE",
                "TAB",
                "BSPC",
                "N0",
                ("&kp", ("LS", "G")),
                "N7",
            ),
            (
                "N8",
                "N9",
                "COLON",
                "PRCNT",
                ("&sk", "LSHFT"),
                ("Custom", "&kp LEFT_PINKY_MOD"),
                ("Custom", "&kp LEFT_RINGY_MOD"),
                ("Custom", "&kp LEFT_MIDDY_MOD"),
                ("Custom", "&kp LEFT_INDEX_MOD"),
                "X",
            ),
            (
                "K",
                "N4",
                "N5",
                "N6",
                "MINUS",
                "PLUS",
                "UNDER",
                ("Custom", "&select_all"),
                ("Custom", "&select_line"),
                ("Custom", "&select_word"),
            ),
            (
                ("Custom", "&kp _FIND"),
                "F",
                "&none",
                "&none",
                "&none",
                "LT",
                "GT",
                "COMMA",
                "J",
                "N1",
            ),
            (
                "N2",
                "N3",
                "FSLH",
                "STAR",
                "&none",
                ("Custom", "&kp _UNDO"),
                ("Custom", "&kp _REDO"),
                ("Custom", "&kp _FIND_PREV"),
                ("Custom", "&kp _FIND_NEXT"),
                "&none",
            ),
            (
                ("Custom", "&tog LAYER_Number"),
                "&none",
                "EQUAL",
                "DOT",
                "N0",
                "LPAR",
                "LBKT",
                "RBKT",
                "RPAR",
                "AT",
            ),
        ),
    ),
    "Function": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "ESC",
                "INS",
                ("&kp", ("LS", "TAB")),
                "DEL",
                "&none",
                "C_MEDIA_HOME",
                "C_PLAY",
                "C_PREV",
                "C_NEXT",
            ),
            (
                "C_STOP",
                "C_EJECT",
                "&none",
                "RET",
                "SPACE",
                "TAB",
                "BSPC",
                "K_CALC",
                "K_CALC",
                "F7",
            ),
            (
                "F8",
                "F9",
                "F10",
                "F13",
                ("&sk", "LSHFT"),
                ("Custom", "&kp LEFT_PINKY_MOD"),
                ("Custom", "&kp LEFT_RINGY_MOD"),
                ("Custom", "&kp LEFT_MIDDY_MOD"),
                ("Custom", "&kp LEFT_INDEX_MOD"),
                "K_WWW",
            ),
            (
                "K_WWW",
                "F4",
                "F5",
                "F6",
                "F11",
                "F14",
                "&none",
                ("Custom", "&select_all"),
                ("Custom", "&select_line"),
                ("Custom", "&select_word"),
            ),
            (
                ("Custom", "&kp _FIND"),
                ("Custom", "&kp _FILES"),
                ("Custom", "&tog LAYER_Function"),
                "&none",
                "&none",
                "C_PP",
                "C_PREV",
                "C_NEXT",
                ("Custom", "&kp _FILES"),
                "F1",
            ),
            (
                "F2",
                "F3",
                "F12",
                "F15",
                "&none",
                ("Custom", "&kp _UNDO"),
                ("Custom", "&kp _REDO"),
                ("Custom", "&kp _FIND_PREV"),
                ("Custom", "&kp _FIND_NEXT"),
                "&none",
            ),
            (
                "&none",
                "&none",
                "C_MUTE",
                "C_VOL_DN",
                "C_VOL_UP",
                "C_BRI_MAX",
                "C_BRI_UP",
                "C_BRI_DN",
                "C_BRI_MIN",
                "C_BRI_AUTO",
            ),
        ),
    ),
    "Emoji": rows_to_layer_spec(
        (
            (
                ("Custom", "&emoji_cloudy"),
                ("Custom", "&emoji_mostly_cloudy"),
                ("Custom", "&emoji_partly_cloudy"),
                ("Custom", "&emoji_mostly_sunny"),
                ("Custom", "&emoji_sunny"),
                ("Custom", "&emoji_new_moon"),
                ("Custom", "&emoji_moon_crescent"),
                ("Custom", "&emoji_moon_quarter"),
                ("Custom", "&emoji_moon_gibbous"),
                ("Custom", "&emoji_full_moon"),
            ),
            (
                ("Custom", "&emoji_rainbow "),
                ("Custom", "&emoji_light_skin_tone"),
                ("Custom", "&emoji_medium_light_skin_tone"),
                ("Custom", "&emoji_medium_skin_tone"),
                ("Custom", "&emoji_medium_dark_skin_tone"),
                ("Custom", "&emoji_dark_skin_tone"),
                ("Custom", "&emoji_theme_party"),
                ("Custom", "&emoji_theme_love"),
                ("Custom", "&emoji_theme_nature"),
                ("Custom", "&emoji_theme_strength"),
            ),
            (
                ("Custom", "&emoji_theme_effort"),
                ("Custom", "&emoji_theme_science"),
                ("Custom", "&emoji_left_arrow"),
                ("Custom", "&emoji_bald"),
                ("Custom", "&emoji_red_hair"),
                ("Custom", "&emoji_curly_hair"),
                ("Custom", "&emoji_white_hair"),
                ("Custom", "&emoji_right_arrow"),
                ("Custom", "&emoji_face_laugh"),
                ("Custom", "&emoji_face_smile"),
            ),
            (
                ("Custom", "&emoji_face_eyes"),
                ("Custom", "&emoji_face_joke"),
                ("Custom", "&emoji_face_fear"),
                ("Custom", "&emoji_face_surprise"),
                ("Custom", "&emoji_male_sign"),
                ("Custom", "&emoji_hair_style_preset"),
                ("Custom", "&emoji_skin_tone_preset"),
                ("Custom", "&emoji_gender_sign_preset"),
                ("&sk", "LSHFT"),
                ("Custom", "&emoji_female_sign"),
            ),
            (
                ("Custom", "&emoji_gesture_attention"),
                ("Custom", "&emoji_gesture_approval"),
                ("Custom", "&emoji_gesture_gratitude"),
                ("Custom", "&emoji_gesture_anxiety"),
                ("Custom", "&emoji_gesture_despair"),
                ("Custom", "&emoji_gesture_curious"),
                ("Custom", "&emoji_old_man"),
                ("Custom", "&emoji_man"),
                ("Custom", "&emoji_boy"),
                ("Custom", "&emoji_girl"),
            ),
            (
                ("Custom", "&emoji_woman"),
                ("Custom", "&emoji_old_woman"),
                ("Custom", "&emoji_cityscape"),
                ("Custom", "&emoji_cityscape_dusk"),
                ("Custom", "&emoji_cityscape_night"),
                ("Custom", "&emoji_theme_magic"),
                ("Custom", "&emoji_theme_space"),
                ("Custom", "&emoji_theme_awesome"),
                ("Custom", "&emoji_person_tipping_hand"),
                ("Custom", "&emoji_person_gesturing_ok"),
            ),
            (
                ("Custom", "&emoji_person_bowing"),
                ("Custom", "&emoji_person_raising_hand"),
                ("Custom", "&emoji_person_gesturing_no"),
                ("Custom", "&emoji_theme_sigh"),
                ("Custom", "&emoji_theme_game"),
                ("Custom", "&emoji_theme_trend"),
                ("Custom", "&emoji_baby"),
                ("Custom", "&emoji_baby_bottle"),
                ("Custom", "&tog LAYER_Emoji"),
                ("Custom", "&emoji_zwj"),
            ),
            (
                ("Custom", "&emoji_sunrise"),
                ("Custom", "&emoji_sunrise_mountains"),
                ("Custom", "&emoji_gesture_hands"),
                ("Custom", "&emoji_gesture_point"),
                ("Custom", "&emoji_gesture_thumbs"),
                ("Custom", "&emoji_check"),
                ("Custom", "&emoji_100"),
                ("Custom", "&emoji_warning"),
                ("Custom", "&emoji_cross"),
                ("Custom", "&emoji_question"),
            ),
        ),
    ),
    "World": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&world_y_base"),
                ("Custom", "&world_u_base"),
                ("Custom", "&world_o_base"),
                ("Custom", "&world_sign_angle"),
                "&none",
                "&none",
            ),
            (
                ("&sk", "LALT"),
                ("&sk", "RALT"),
                "&none",
                "&none",
                "&none",
                ("Custom", "&world_consonants_base"),
                ("Custom", "&world_i_base"),
                ("Custom", "&world_e_base"),
                ("Custom", "&world_a_base"),
                ("Custom", "&world_sign_exclaim"),
            ),
            (
                "&none",
                ("&sk", "LSHFT"),
                ("&sk", "LCTRL"),
                ("&sk", "RCTRL"),
                ("&sk", "RSHFT"),
                "&none",
                ("Custom", "&world_currency_base"),
                ("Custom", "&world_quotes_left_base"),
                ("Custom", "&world_sign_dash"),
                ("Custom", "&world_sign_landmark"),
            ),
            (
                ("Custom", "&world_sign_ordinal"),
                ("Custom", "&world_sign_question"),
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&world_sign_base"),
                ("Custom", "&world_quotes_right_base"),
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&tog LAYER_World"),
                "&none",
                "&none",
                "&none",
                "&none",
            ),
        ),
    ),
    "Symbol": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "GRAVE",
                "LBRC",
                "LBKT",
                "RBKT",
                "RBRC",
                "DOT",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "EXCL",
                "COMMA",
                "LPAR",
                "RPAR",
                "SEMI",
                "QMARK",
                "GRAVE",
                ("Custom", "&sk RIGHT_INDEX_MOD"),
            ),
            (
                ("Custom", "&sk RIGHT_MIDDY_MOD"),
                ("Custom", "&sk RIGHT_RINGY_MOD"),
                ("Custom", "&sk RIGHT_PINKY_MOD"),
                "&none",
                "HASH",
                "CARET",
                "EQUAL",
                "UNDER",
                "DLLR",
                "STAR",
            ),
            (
                "DQT",
                "BSPC",
                "TAB",
                "SPACE",
                "RET",
                "&none",
                "TILDE",
                "LT",
                "PIPE",
                "MINUS",
            ),
            (
                "GT",
                "FSLH",
                "BSLH",
                "DOT",
                "STAR",
                "&none",
                "&none",
                "&none",
                "SQT",
                "DEL",
            ),
            (
                ("&kp", ("LS", "TAB")),
                "INS",
                "ESC",
                "&none",
                ("Custom", "&dot_dot"),
                "AMPS",
                "SQT",
                "DQT",
                "PLUS",
                "PRCNT",
            ),
            (
                "COLON",
                "AT",
                "&none",
                "&none",
                ("Custom", "&tog LAYER_Symbol"),
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
        ),
    ),
    "System": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "PSCRN",
                "PAUSE_BREAK",
                ("&rgb_ug", "RGB_TOG"),
                ("&rgb_ug", "RGB_TOG"),
                ("Custom", "&sk RIGHT_INDEX_MOD"),
            ),
            (
                ("Custom", "&sk RIGHT_MIDDY_MOD"),
                ("Custom", "&sk RIGHT_RINGY_MOD"),
                ("Custom", "&sk RIGHT_PINKY_MOD"),
                "&none",
                "&none",
                ("&rgb_ug", "RGB_SPI"),
                ("&rgb_ug", "RGB_SAI"),
                ("&rgb_ug", "RGB_HUI"),
                ("&rgb_ug", "RGB_BRI"),
                ("&rgb_ug", "RGB_EFF"),
            ),
            (
                ("&rgb_ug", "RGB_EFF"),
                ("&rgb_ug", "RGB_BRI"),
                ("&rgb_ug", "RGB_HUI"),
                ("&rgb_ug", "RGB_SAI"),
                ("&rgb_ug", "RGB_SPI"),
                ("Custom", "&kp _LOCK"),
                "&none",
                ("&rgb_ug", "RGB_SPD"),
                ("&rgb_ug", "RGB_SAD"),
                ("&rgb_ug", "RGB_HUD"),
            ),
            (
                ("&rgb_ug", "RGB_BRD"),
                ("&rgb_ug", "RGB_EFR"),
                ("Custom", "&kp _LOCK"),
                ("Custom", "&kp _SLEEP"),
                ("Custom", "&kp _POWER"),
                "&none",
                "&none",
                ("Custom", "&tog LAYER_System"),
                ("&rgb_ug", "RGB_EFR"),
                ("&rgb_ug", "RGB_BRD"),
            ),
            (
                ("&rgb_ug", "RGB_HUD"),
                ("&rgb_ug", "RGB_SAD"),
                ("&rgb_ug", "RGB_SPD"),
                ("Custom", "&kp _SLEEP"),
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&linux_magic_sysrq"),
                "SLCK",
            ),
            (
                "KP_NUM",
                "CAPS",
                "&none",
                "PSCRN",
                "PAUSE_BREAK",
                ("Custom", "&linux_magic_sysrq"),
                "SLCK",
                "KP_NUM",
                "CAPS",
                ("Custom", "&kp _POWER"),
            ),
        ),
    ),
    "Gaming": rows_to_layer_spec(
        (
            (
                "ESC",
                "P",
                "O",
                "N",
                "BSPC",
                "F1",
                "F2",
                "F3",
                "F4",
                "F5",
            ),
            (
                "M",
                "N6",
                "N7",
                "N8",
                "N9",
                "N0",
                "F6",
                "F7",
                "F8",
                "F9",
            ),
            (
                "F10",
                "F11",
                "I",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "Y",
                "U",
            ),
            (
                "I",
                "O",
                "P",
                "F12",
                "T",
                "TAB",
                "Q",
                "W",
                "E",
                "R",
            ),
            (
                "H",
                "J",
                "K",
                "L",
                "SEMI",
                "SQT",
                "G",
                "LSHFT",
                "A",
                "S",
            ),
            (
                "D",
                "F",
                "LSHFT",
                "LALT",
                "V",
                "ESC",
                "UP",
                "RET",
                "N",
                "M",
            ),
            (
                "COMMA",
                "DOT",
                "FSLH",
                "BSLH",
                "B",
                "LCTRL",
                "Z",
                "X",
                "C",
                "SPACE",
            ),
            (
                "LCTRL",
                "RET",
                "LEFT",
                "DOWN",
                "RIGHT",
                "MINUS",
                "LBKT",
                "RBKT",
                "EQUAL",
                "GRAVE",
            ),
        ),
    ),
    "Factory": rows_to_layer_spec(
        (
            (
                "F1",
                "F2",
                "F3",
                "F4",
                "F5",
                "F6",
                "F7",
                "F8",
                "F9",
                "F10",
            ),
            (
                "EQUAL",
                "N1",
                "N2",
                "N3",
                "N4",
                "N5",
                "N6",
                "N7",
                "N8",
                "N9",
            ),
            (
                "N0",
                "MINUS",
                "TAB",
                "Q",
                "W",
                "E",
                "R",
                "T",
                "Y",
                "U",
            ),
            (
                "I",
                "O",
                "P",
                "BSLH",
                "ESC",
                "A",
                "S",
                "D",
                "F",
                "G",
            ),
            (
                "H",
                "J",
                "K",
                "L",
                "SEMI",
                "SQT",
                "GRAVE",
                "Z",
                "X",
                "C",
            ),
            (
                "V",
                "B",
                "LSHFT",
                "LCTRL",
                "&lower",
                "LGUI",
                "RCTRL",
                "RSHFT",
                "N",
                "M",
            ),
            (
                "COMMA",
                "DOT",
                "FSLH",
                "PG_UP",
                "&magic",
                "HOME",
                "END",
                "LEFT",
                "RIGHT",
                "BSPC",
            ),
            (
                "DEL",
                "LALT",
                "RALT",
                "RET",
                "SPACE",
                "UP",
                "DOWN",
                "LBKT",
                "RBKT",
                "PG_DN",
            ),
        ),
    ),
    "Lower": rows_to_layer_spec(
        (
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "KP_NUM",
                "KP_SLASH",
                "KP_MULTIPLY",
                "KP_MINUS",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "KP_CLEAR",
                "KP_N7",
                "KP_N8",
                "KP_N9",
            ),
            (
                "KP_MINUS",
                "FSLH",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "KP_LPAR",
                "KP_N4",
            ),
            (
                "KP_N5",
                "KP_N6",
                "KP_PLUS",
                "KP_MULTIPLY",
                "RALT",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "KP_RPAR",
                "KP_N1",
                "KP_N2",
                "KP_N3",
                "KP_ENTER",
                "KP_EQUAL",
                "&trans",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                ("Custom", "&tog LAYER_Function"),
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&tog LAYER_System"),
                "KP_N0",
                "KP_N0",
            ),
            (
                "KP_COMMA",
                "KP_DOT",
                "KP_ENTER",
                "&trans",
                "&none",
                "&none",
                "&none",
                "&none",
                ("Custom", "&tog LAYER_Emoji"),
                ("Custom", "&tog LAYER_Cursor"),
            ),
            (
                ("Custom", "&tog LAYER_Number"),
                "&none",
                "&none",
                ("Custom", "&tog LAYER_Mouse"),
                ("Custom", "&tog LAYER_Symbol"),
                ("Custom", "&tog LAYER_World"),
                "&none",
                "&none",
                "&none",
                "&none",
            ),
        ),
    ),
    "Magic": rows_to_layer_spec(
        (
            (
                ("&bt", "BT_CLR"),
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                ("&bt", "BT_CLR_ALL"),
            ),
            (
                ("Custom", "&to 0"),
                ("Custom", "&to 1"),
                ("Custom", "&to 2"),
                ("Custom", "&to 3"),
                ("Custom", "&to 4"),
                ("Custom", "&to 5"),
                ("Custom", "&to 6"),
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                ("&rgb_ug", "RGB_SPI"),
                ("&rgb_ug", "RGB_SAI"),
                ("&rgb_ug", "RGB_HUI"),
                ("&rgb_ug", "RGB_BRI"),
                ("&rgb_ug", "RGB_TOG"),
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&bootloader",
                ("&rgb_ug", "RGB_SPD"),
                ("&rgb_ug", "RGB_SAD"),
                ("&rgb_ug", "RGB_HUD"),
                ("&rgb_ug", "RGB_BRD"),
                ("&rgb_ug", "RGB_EFF"),
            ),
            (
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&bootloader",
                "&reset",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&bt_2",
                "&bt_3",
                ("&tog", 29),
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
            (
                "&none",
                "&none",
                "&none",
                "&reset",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&bt_0",
            ),
            (
                "&bt_1",
                ("&out", "OUT_USB"),
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
                "&none",
            ),
        ),
    ),
}
