"""QuantumTouch Base layer."""

from __future__ import annotations

from glove80.base import KeySpec, Layer, LayerSpec, build_layer_from_spec

BASE_LAYER_SPEC = LayerSpec(
    overrides={
        0: KeySpec("&kp", (KeySpec("F1"),)),
        1: KeySpec("&kp", (KeySpec("F2"),)),
        2: KeySpec("&kp", (KeySpec("F3"),)),
        3: KeySpec("&kp", (KeySpec("F4"),)),
        4: KeySpec("&kp", (KeySpec("F5"),)),
        5: KeySpec("&kp", (KeySpec("F6"),)),
        6: KeySpec("&kp", (KeySpec("F7"),)),
        7: KeySpec("&kp", (KeySpec("F8"),)),
        8: KeySpec("&kp", (KeySpec("F9"),)),
        9: KeySpec("&kp", (KeySpec("F10"),)),
        10: KeySpec("&mt", (KeySpec("PLUS"), KeySpec("EQUAL"))),
        11: KeySpec("&mt", (KeySpec("EXCL"), KeySpec("N1"))),
        12: KeySpec("&mt", (KeySpec("AT"), KeySpec("N2"))),
        13: KeySpec("&mt", (KeySpec("HASH"), KeySpec("N3"))),
        14: KeySpec("&mt", (KeySpec("DLLR"), KeySpec("N4"))),
        15: KeySpec("&mt", (KeySpec("PRCNT"), KeySpec("N5"))),
        16: KeySpec("&mt", (KeySpec("CARET"), KeySpec("N6"))),
        17: KeySpec("&mt", (KeySpec("AMPS"), KeySpec("N7"))),
        18: KeySpec("&mt", (KeySpec("STAR"), KeySpec("N8"))),
        19: KeySpec("&mt", (KeySpec("LPAR"), KeySpec("N9"))),
        20: KeySpec("&mt", (KeySpec("RPAR"), KeySpec("N0"))),
        21: KeySpec("&mt", (KeySpec("UNDER"), KeySpec("MINUS"))),
        22: KeySpec("&kp", (KeySpec("TAB"),)),
        23: KeySpec("&kp", (KeySpec("Q"),)),
        24: KeySpec("&kp", (KeySpec("W"),)),
        25: KeySpec("&kp", (KeySpec("E"),)),
        26: KeySpec("&kp", (KeySpec("R"),)),
        27: KeySpec("&kp", (KeySpec("T"),)),
        28: KeySpec("&kp", (KeySpec("Y"),)),
        29: KeySpec("&kp", (KeySpec("U"),)),
        30: KeySpec("&kp", (KeySpec("I"),)),
        31: KeySpec("&kp", (KeySpec("O"),)),
        32: KeySpec("&kp", (KeySpec("P"),)),
        33: KeySpec("&mt", (KeySpec("PIPE"), KeySpec("BSLH"))),
        34: KeySpec("&kp", (KeySpec("ESC"),)),
        35: KeySpec("&kp", (KeySpec("A"),)),
        36: KeySpec("&kp", (KeySpec("S"),)),
        37: KeySpec("&kp", (KeySpec("D"),)),
        38: KeySpec("&kp", (KeySpec("F"),)),
        39: KeySpec("&kp", (KeySpec("G"),)),
        40: KeySpec("&kp", (KeySpec("H"),)),
        41: KeySpec("&kp", (KeySpec("J"),)),
        42: KeySpec("&kp", (KeySpec("K"),)),
        43: KeySpec("&kp", (KeySpec("L"),)),
        44: KeySpec("&mt", (KeySpec("COLON"), KeySpec("SEMI"))),
        45: KeySpec("&mt", (KeySpec("DQT"), KeySpec("SQT"))),
        46: KeySpec("&mt", (KeySpec("TILDE"), KeySpec("GRAVE"))),
        47: KeySpec("&kp", (KeySpec("Z"),)),
        48: KeySpec("&kp", (KeySpec("X"),)),
        49: KeySpec("&kp", (KeySpec("C"),)),
        50: KeySpec("&kp", (KeySpec("V"),)),
        51: KeySpec("&kp", (KeySpec("B"),)),
        52: KeySpec("Custom", (KeySpec("&td_caps_lshift_sk"),)),
        53: KeySpec("&sk", (KeySpec("LCTRL"),)),
        54: KeySpec("&lower"),
        55: KeySpec("&sk", (KeySpec("RGUI"),)),
        56: KeySpec("&sk", (KeySpec("RCTRL"),)),
        57: KeySpec("Custom", (KeySpec("&td_caps_rshift_sk"),)),
        58: KeySpec("&kp", (KeySpec("N"),)),
        59: KeySpec("&kp", (KeySpec("M"),)),
        60: KeySpec("&mt", (KeySpec("LT"), KeySpec("COMMA"))),
        61: KeySpec("&mt", (KeySpec("GT"), KeySpec("DOT"))),
        62: KeySpec("&mt", (KeySpec("QMARK"), KeySpec("FSLH"))),
        63: KeySpec("&kp", (KeySpec("PG_UP"),)),
        64: KeySpec("&magic"),
        65: KeySpec("Custom", (KeySpec("&mt MEH_KEY HOME"),)),
        66: KeySpec("Custom", (KeySpec("&mt RA(RCTRL) END"),)),
        67: KeySpec("&kp", (KeySpec("LEFT"),)),
        68: KeySpec("&kp", (KeySpec("RIGHT"),)),
        69: KeySpec("Custom", (KeySpec("&bspc_del"),)),
        70: KeySpec("Custom", (KeySpec("&td_lgui_enter_sk"),)),
        71: KeySpec("&sk", (KeySpec("LALT"),)),
        72: KeySpec("&sk", (KeySpec("RALT"),)),
        73: KeySpec("&lt", (KeySpec("3"), KeySpec("RET"))),
        74: KeySpec("&kp", (KeySpec("SPACE"),)),
        75: KeySpec("&kp", (KeySpec("UP"),)),
        76: KeySpec("&kp", (KeySpec("DOWN"),)),
        77: KeySpec("&mt", (KeySpec("LBRC"), KeySpec("LBKT"))),
        78: KeySpec("&mt", (KeySpec("RBRC"), KeySpec("RBKT"))),
        79: KeySpec("&kp", (KeySpec("PG_DN"),)),
    },
)


def build_base_layer(_variant: str) -> Layer:
    """Return the declarative Base layer."""
    return build_layer_from_spec(BASE_LAYER_SPEC)
