"""Gaming layer generation."""

from __future__ import annotations

from glove80.base import (
    KeySpec,
    Layer,
    LayerSpec,
    build_layer_from_spec,
    copy_layer,
)

GAMING_SPEC = LayerSpec(
    overrides={
        0: KeySpec("&kp", (KeySpec("ESC"),)),
        1: KeySpec("&kp", (KeySpec("P"),)),
        2: KeySpec("&kp", (KeySpec("O"),)),
        3: KeySpec("&kp", (KeySpec("N"),)),
        4: KeySpec("&kp", (KeySpec("BSPC"),)),
        5: KeySpec("&kp", (KeySpec("F1"),)),
        6: KeySpec("&kp", (KeySpec("F2"),)),
        7: KeySpec("&kp", (KeySpec("F3"),)),
        8: KeySpec("&kp", (KeySpec("F4"),)),
        9: KeySpec("&kp", (KeySpec("F5"),)),
        10: KeySpec("&kp", (KeySpec("M"),)),
        11: KeySpec("&kp", (KeySpec("N6"),)),
        12: KeySpec("&kp", (KeySpec("N7"),)),
        13: KeySpec("&kp", (KeySpec("N8"),)),
        14: KeySpec("&kp", (KeySpec("N9"),)),
        15: KeySpec("&kp", (KeySpec("N0"),)),
        16: KeySpec("&kp", (KeySpec("F6"),)),
        17: KeySpec("&kp", (KeySpec("F7"),)),
        18: KeySpec("&kp", (KeySpec("F8"),)),
        19: KeySpec("&kp", (KeySpec("F9"),)),
        20: KeySpec("&kp", (KeySpec("F10"),)),
        21: KeySpec("&kp", (KeySpec("F11"),)),
        22: KeySpec("&kp", (KeySpec("I"),)),
        23: KeySpec("&kp", (KeySpec("N1"),)),
        24: KeySpec("&kp", (KeySpec("N2"),)),
        25: KeySpec("&kp", (KeySpec("N3"),)),
        26: KeySpec("&kp", (KeySpec("N4"),)),
        27: KeySpec("&kp", (KeySpec("N5"),)),
        28: KeySpec("&kp", (KeySpec("Y"),)),
        29: KeySpec("&kp", (KeySpec("U"),)),
        30: KeySpec("&kp", (KeySpec("I"),)),
        31: KeySpec("&kp", (KeySpec("O"),)),
        32: KeySpec("&kp", (KeySpec("P"),)),
        33: KeySpec("&kp", (KeySpec("F12"),)),
        34: KeySpec("&kp", (KeySpec("T"),)),
        35: KeySpec("&kp", (KeySpec("TAB"),)),
        36: KeySpec("&kp", (KeySpec("Q"),)),
        37: KeySpec("&kp", (KeySpec("W"),)),
        38: KeySpec("&kp", (KeySpec("E"),)),
        39: KeySpec("&kp", (KeySpec("R"),)),
        40: KeySpec("&kp", (KeySpec("H"),)),
        41: KeySpec("&kp", (KeySpec("J"),)),
        42: KeySpec("&kp", (KeySpec("K"),)),
        43: KeySpec("&kp", (KeySpec("L"),)),
        44: KeySpec("&kp", (KeySpec("SEMI"),)),
        45: KeySpec("&kp", (KeySpec("SQT"),)),
        46: KeySpec("&kp", (KeySpec("G"),)),
        47: KeySpec("&kp", (KeySpec("LSHFT"),)),
        48: KeySpec("&kp", (KeySpec("A"),)),
        49: KeySpec("&kp", (KeySpec("S"),)),
        50: KeySpec("&kp", (KeySpec("D"),)),
        51: KeySpec("&kp", (KeySpec("F"),)),
        52: KeySpec("&kp", (KeySpec("LSHFT"),)),
        53: KeySpec("&kp", (KeySpec("LALT"),)),
        54: KeySpec("&kp", (KeySpec("V"),)),
        55: KeySpec("&kp", (KeySpec("ESC"),)),
        56: KeySpec("&kp", (KeySpec("UP"),)),
        57: KeySpec("&kp", (KeySpec("RET"),)),
        58: KeySpec("&kp", (KeySpec("N"),)),
        59: KeySpec("&kp", (KeySpec("M"),)),
        60: KeySpec("&kp", (KeySpec("COMMA"),)),
        61: KeySpec("&kp", (KeySpec("DOT"),)),
        62: KeySpec("&kp", (KeySpec("FSLH"),)),
        63: KeySpec("&kp", (KeySpec("MINUS"),)),
        64: KeySpec("&kp", (KeySpec("B"),)),
        65: KeySpec("&kp", (KeySpec("LCTRL"),)),
        66: KeySpec("&kp", (KeySpec("Z"),)),
        67: KeySpec("&kp", (KeySpec("X"),)),
        68: KeySpec("&kp", (KeySpec("C"),)),
        69: KeySpec("&kp", (KeySpec("SPACE"),)),
        70: KeySpec("&kp", (KeySpec("LCTRL"),)),
        71: KeySpec("&kp", (KeySpec("RET"),)),
        72: KeySpec("&kp", (KeySpec("LEFT"),)),
        73: KeySpec("&kp", (KeySpec("DOWN"),)),
        74: KeySpec("&kp", (KeySpec("RIGHT"),)),
        75: KeySpec("&kp", (KeySpec("GRAVE"),)),
        76: KeySpec("&kp", (KeySpec("LBKT"),)),
        77: KeySpec("&kp", (KeySpec("RBKT"),)),
        78: KeySpec("&kp", (KeySpec("BSLH"),)),
        79: KeySpec("&kp", (KeySpec("EQUAL"),)),
    },
)

_BASE_GAMING_LAYER: Layer = build_layer_from_spec(GAMING_SPEC)


def build_gaming_layer(_variant: str) -> Layer:
    return copy_layer(_BASE_GAMING_LAYER)
