from pathlib import Path
from typing import  Tuple
from allytools.units import Length
from scanner3d.scanner.ScannersDB import ScannersDB
from scanner3d.test.tests.TripleSlice import TripleSlices
from scanner3d.test.tests.PsfBank import PsfBank
from scanner3d.test.TestSuit import TestSuite
from zempy.bridge.zempy_session import zempy_session
from zempy.raytracer.RayTracer import RayTracer
from scanner3d.zemod import ZeMod
from scanner3d.test.log_setup import LoggerSetup
from scanner3d.zemod.enums import ZeModRayType, RaysType
from scanner3d.tuner.OpticsBlueprint import OpticsBlueprint
from scanner3d.zemod.enums import ZeModFieldTypes

log = LoggerSetup.configure(__name__)

if __name__ == "__main__":
    camera = ScannersDB.Eva2C.cameras[0]
    zmx_path = camera.objective.zmx_file

    output_root = Path(__file__).parent / "output"

    psf_suite = TestSuite([
        TripleSlices(grid_size=5),
        PsfBank(dr_mm=Length(1), dz_mm=Length(25)),
    ])

    try:
        with zempy_session(zmx_path) as (_zs, s):
            zemod = ZeMod.from_optical_system(optical_system=s)
            blueprint = OpticsBlueprint(zemod=zemod, camera=camera)
            blueprint.perform_system_checks(
                field_type=ZeModFieldTypes.RealImageHeight,
                needs_wavelength_sync=True,
                needs_quick_focus=True,
            )
            x_coor = camera.sensor.width/2
            y_coor = camera.sensor.height/2
            zemod.sd.fields.add_field(x_coor.value_mm, y_coor.value_mm)

            ray_tracer = RayTracer(optical_system=s)
            result = ray_tracer.run(4, 0, (2,2))
            print(result)


    except Exception:
        log.exception("Unexpected error during test run")
